/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.post_processing_output;

import com.ibm.statistics.lighttable.ui.edit.dialogs.cellproperties.CellFormatPanel;
import com.ibm.statistics.lighttable.ui.util.LtEditorUtil;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.post_processing_output.TableStyleDlg;
import com.spss.pivottable.dialogs.cell_properties.CellPreviewString;
import com.spss.pivottable.resources.PTResUtil;
import com.spss.pivottable.util.CellFormatHelper;
import com.spss.pivottable.util.PvtLogger;
import com.spss.shared.export.table_export.BaseImageRenderer;
import com.spss.shared.syntaxeditor.resources.SyntaxEditorResUtil;
import com.spss.uitools.drop_menu_button.DropButton;
import com.spss.uitools.drop_menu_button.FillButtonDrawer;
import com.spss.vis.Visualization;
import com.spss.vis.VisualizationFactory;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.specification.Length;
import com.spss.vis.specification.Specification;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.format.DateTimeType;
import com.spss.vis.specification.format.FormatSpecification;
import com.spss.vis.specification.style.SetFormatSpecification;
import com.spss.vis.specification.style.StyleSpecification;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TableStyleFormatDlg
extends BaseSubDialog
implements ItemListener {
    public static final int AS_IS_COMBO_INDEX = 0;
    private static final String[] sCustomCurrencyPrefKeys = new String[]{"cca", "ccb", "ccc", "ccd", "cce"};
    private TableStyleDlg mParent;
    private TableStyleDlg.FormatData mOldFormatData;
    private TableStyleDlg.FormatData mNewFormatData = new TableStyleDlg.FormatData();
    private JLabel mPreviewArea;
    private JToggleButton mBoldButton;
    private JToggleButton mItalicizedButton;
    private JToggleButton mUnderlineButton;
    private DropButton mBGColorDropButton;
    private DropButton mForegroundColorDropButton;
    private SpssButtonGroup mRadioButtonGroup;
    JRadioButton mNoFormattingRB;
    JRadioButton mDoFormattingRB;
    JComboBox mFormatCB;
    JSpinner mDecimalSpinner;
    JCheckBox mDoDecimalsCheckBox;
    JComboBox mApplyToCB;
    JCheckBox mReplaceValueCheckBox;
    JTextField mReplaceValueText;
    JLabel mFormatLabel;
    JLabel mDecimalLabel;
    JLabel mApplyToLabel;
    JLabel mReplaceTextLabel;
    VisualizationSpecification mVisSpec;
    JPanel mPreviewPanel;
    MyCellFormatHelper mMyCellFormatHelper = new MyCellFormatHelper();

    public TableStyleFormatDlg(TableStyleDlg tableStyleDlg, TableStyleDlg.FormatData formatData) {
        super(tableStyleDlg.getBaseProcedureDialog(), "", true);
        String string = "";
        this.mParent = tableStyleDlg;
        this.mOldFormatData = formatData;
        this.mMyCellFormatHelper.init();
        this.setPreviewVisualizationSpecification();
        string = this.mParent.getResString("IDS_CF_FORMAT_DLG_TITLE");
        this.setTitle(string);
        this.initMyPanel();
        this.setDefaults(this.mOldFormatData);
        this.updatePreview();
        this.enableControls();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadSizeAndLocationState();
    }

    private void setDefaults(TableStyleDlg.FormatData formatData) {
        this.mNoFormattingRB.setSelected(!formatData.isDoFormatting());
        this.mDoFormattingRB.setSelected(formatData.isDoFormatting());
        this.mBoldButton.setSelected(formatData.isBold());
        this.mItalicizedButton.setSelected(formatData.isItalic());
        this.mUnderlineButton.setSelected(formatData.isUnderline());
        this.mBGColorDropButton.setUserSelectedColor(formatData.getBackgroundColor());
        this.mForegroundColorDropButton.setUserSelectedColor(formatData.getForegroundColor());
        this.mFormatCB.setSelectedIndex(formatData.getFormatOffset());
        this.mDoDecimalsCheckBox.setSelected(formatData.isDoDecimals());
        this.mDecimalSpinner.setValue(formatData.getDecimals());
        int n = this.findApplyToTypeIndex(formatData.getApplyToType());
        this.mApplyToCB.setSelectedIndex(n);
        this.mReplaceValueCheckBox.setSelected(formatData.isDoReplaceValue());
        this.mReplaceValueText.setText(formatData.getReplaceText());
    }

    private int findApplyToTypeIndex(TableStyleDlg.ApplyToType applyToType) {
        int n = 0;
        for (int i = 0; i < this.mApplyToCB.getItemCount(); ++i) {
            if (((ApplyToPair)this.mApplyToCB.getItemAt(i)).getApplyToType() != applyToType) continue;
            n = i;
            break;
        }
        return n;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public boolean canEnableContinue() {
        return true;
    }

    @Override
    public boolean continuePressed() {
        boolean bl = true;
        if (this.mReplaceValueCheckBox.isSelected() && this.mReplaceValueText.getText().length() == 0) {
            bl = false;
        }
        return bl;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_modify_output_table_style_format";
    }

    protected void initMyPanel() {
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.createMainPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel3 = new JPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, 23, new Insets(0, 0, 0, 0));
        this.pack();
        this.updatePreview();
    }

    private void initVars() {
        this.mNoFormattingRB = DialogUtil.createRadioButton(this.mParent, "IDS_CF_NO_FORMAT_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableStyleFormatDlg.this.doFullUpdate();
            }
        });
        this.mDoFormattingRB = DialogUtil.createRadioButton(this.mParent, "IDS_CF_DO_FORMAT_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableStyleFormatDlg.this.doFullUpdate();
            }
        });
        this.mRadioButtonGroup = new SpssButtonGroup();
        this.mRadioButtonGroup.add(this.mNoFormattingRB);
        this.mRadioButtonGroup.add(this.mDoFormattingRB);
        this.mFormatLabel = DialogUtil.createLabel(this.mParent, "IDS_CF_FORMAT_CB_LABEL");
        this.mFormatCB = new JComboBox<String>(this.mMyCellFormatHelper.getAllNames());
        this.mFormatLabel.setLabelFor(this.mFormatCB);
        this.mFormatCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableStyleFormatDlg.this.doFullUpdate();
            }
        });
        this.mDecimalLabel = DialogUtil.createLabel(this.mParent, "IDS_CF_DECIMALS_SPINNER_LABEL");
        this.mDecimalSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 10, 1));
        this.mDecimalSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TableStyleFormatDlg.this.doFullUpdate();
            }
        });
        this.mDecimalLabel.setLabelFor(this.mDecimalSpinner);
        this.mDoDecimalsCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_CF_DECIMALS_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableStyleFormatDlg.this.doFullUpdate();
            }
        });
        this.mApplyToLabel = DialogUtil.createLabel(this.mParent, "IDS_CF_APPLY_TO_CB_LABEL");
        this.mApplyToCB = new JComboBox<ApplyToPair>(this.createApplyToArray(TableStyleDlg.ApplyToType.values()));
        this.mApplyToLabel.setLabelFor(this.mApplyToCB);
        this.mReplaceValueCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_CF_REPLACE_VALUE_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableStyleFormatDlg.this.enableControls();
            }
        });
        this.mReplaceTextLabel = DialogUtil.createLabel(this.mParent, "IDS_CF_NEW_VALUE_LABEL");
        this.mReplaceValueText = new JTextField();
        this.mReplaceValueText.setPreferredSize(new Dimension(150, 25));
        this.mReplaceTextLabel.setLabelFor(this.mReplaceValueText);
        this.mReplaceValueText.getDocument().addDocumentListener(new MyDocumentListener());
    }

    private void doFullUpdate() {
        this.enableControls();
        this.setPreviewVisualizationSpecification();
        this.updatePreview();
    }

    private void setPreviewVisualizationSpecification() {
        try {
            String string = CellPreviewString.sChartXMLPattern1 + this.getPreviewSampleText() + CellPreviewString.sChartXMLPattern2;
            this.mVisSpec = new VisualizationSpecification((Reader)new StringReader(string));
        }
        catch (IOException iOException) {
            PvtLogger.printStackTrace((Exception)iOException);
        }
        catch (VisualizationException visualizationException) {
            PvtLogger.printStackTrace((Exception)((Object)visualizationException));
        }
    }

    private boolean updateSampleSpec() {
        int n = this.mFormatCB.getSelectedIndex();
        Integer n2 = this.mNoFormattingRB.isSelected() || n == 0 || !this.mDoDecimalsCheckBox.isSelected() ? 0 : (Integer)this.mDecimalSpinner.getValue();
        SetFormatSpecification setFormatSpecification = (SetFormatSpecification)this.mVisSpec.getSpecification("formatid");
        FormatSpecification formatSpecification = setFormatSpecification.getFormatChild();
        StyleSpecification styleSpecification = (StyleSpecification)this.mVisSpec.getSpecification("labelingStyle");
        StyleSpecification styleSpecification2 = (StyleSpecification)this.mVisSpec.getSpecification("intervalstyle");
        boolean bl = this.mDoFormattingRB.isSelected();
        styleSpecification.setColor(bl ? this.mNewFormatData.getForegroundColor() : Color.BLACK);
        styleSpecification.setFontSize(new Length("14pt"));
        styleSpecification.setFontBold(Boolean.valueOf(bl ? this.mNewFormatData.isBold() : false));
        styleSpecification.setFontItalic(Boolean.valueOf(bl ? this.mNewFormatData.isItalic() : false));
        styleSpecification.setFontUnderLine(Boolean.valueOf(bl ? this.mNewFormatData.isUnderline() : false));
        styleSpecification2.setColor(bl ? this.mNewFormatData.getBackgroundColor() : Color.WHITE);
        if (n == 0) {
            if (formatSpecification != null && formatSpecification.getBaseFormat() == DateTimeType.ELAPSEDTIME) {
                formatSpecification.setBaseFormat(null);
            }
            if (formatSpecification != null && formatSpecification.getBaseFormat() == null) {
                setFormatSpecification.setFormatChild(this.mMyCellFormatHelper.getNumberFormat((Specification)setFormatSpecification, 0, n2));
            }
        } else if (this.mMyCellFormatHelper.isNumberOffset(n)) {
            if (formatSpecification != null && formatSpecification.getBaseFormat() == DateTimeType.ELAPSEDTIME) {
                formatSpecification.setBaseFormat(null);
            }
            if (formatSpecification != null && formatSpecification.getBaseFormat() == null) {
                setFormatSpecification.setFormatChild(this.mMyCellFormatHelper.getNumberFormat((Specification)setFormatSpecification, this.mMyCellFormatHelper.getOffsetWithinType(n), n2));
            }
        } else if (this.mMyCellFormatHelper.isDateOffset(n)) {
            formatSpecification.setBaseFormat(DateTimeType.DATETIME);
            setFormatSpecification.setFormatChild(CellFormatPanel.getDateFormat((Specification)setFormatSpecification, (int)this.mMyCellFormatHelper.getOffsetWithinType(n), (Integer)n2));
        } else if (this.mMyCellFormatHelper.isTimeOffset(n)) {
            setFormatSpecification.setFormatChild(CellFormatPanel.getTimeFormat((Specification)setFormatSpecification, (int)(this.mMyCellFormatHelper.getOffsetWithinType(n) + 6), (Integer)n2));
        } else if (this.mMyCellFormatHelper.isCurrencyOffset(n)) {
            if (formatSpecification != null && formatSpecification.getBaseFormat() == DateTimeType.ELAPSEDTIME) {
                formatSpecification.setBaseFormat(null);
            }
            if (formatSpecification != null && formatSpecification.getBaseFormat() == null) {
                setFormatSpecification.setFormatChild(this.mMyCellFormatHelper.getCurrencyFormat((Specification)setFormatSpecification, this.mMyCellFormatHelper.getOffsetWithinType(n), n2));
            }
        }
        return true;
    }

    private JPanel createPreviewPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(PTResUtil.getString((String)"CellFontPreview")));
        JPanel jPanel2 = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                boolean bl = TableStyleFormatDlg.this.updateSampleSpec();
                if (bl) {
                    try {
                        Visualization visualization = VisualizationFactory.getInstance().makeVisualization(TableStyleFormatDlg.this.mVisSpec);
                        Dimension dimension = this.getSize();
                        dimension.width = Math.max(dimension.width - 10, 250);
                        visualization.setOutputSize(dimension.width, 50);
                        visualization.setRenderingHints(BaseImageRenderer.getRendingHints());
                        graphics2D.drawImage((Image)visualization.makeImage(), 0, 0, null);
                    }
                    catch (Exception exception) {
                        PvtLogger.printStackTrace((Exception)exception);
                    }
                }
            }
        };
        jPanel2.setPreferredSize(new Dimension(250, 50));
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel.add(jPanel2);
        return jPanel;
    }

    private ApplyToPair[] createApplyToArray(TableStyleDlg.ApplyToType[] applyToTypeArray) {
        ApplyToPair[] applyToPairArray = new ApplyToPair[applyToTypeArray.length];
        for (int i = 0; i < applyToTypeArray.length; ++i) {
            applyToPairArray[i] = new ApplyToPair(applyToTypeArray[i]);
        }
        return applyToPairArray;
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 10;
        JPanel jPanel2 = this.getPreviewPanel();
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom + 10, insets.right);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mNoFormattingRB, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mDoFormattingRB, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        JPanel jPanel3 = this.createFormatDecimalsPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 3, 1, 1, n, new Insets(0, 0, 0, 0));
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(this.mApplyToLabel);
        jPanel4.add(this.mApplyToCB);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 4, 1, 1, n, new Insets(0, 0, 0, 0));
        DialogUtil.addUsingGBL(jPanel, this.mReplaceValueCheckBox, gridBagConstraints, 0, 5, 1, 1, n, new Insets(0, 0, 0, 0));
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        this.mReplaceTextLabel.setLabelFor(this.mReplaceValueText);
        jPanel5.add(this.mReplaceTextLabel);
        jPanel5.add(this.mReplaceValueText);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 6, 1, 1, n, new Insets(0, 25, 0, 0));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 7, 1, 1, n, new Insets(0, 0, 0, 0));
        return jPanel;
    }

    private JPanel createFormatDecimalsPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, 25, insets.left, insets.right);
        Insets insets3 = new Insets(insets.top, 45, insets.left, insets.right);
        FontOptionsPanel fontOptionsPanel = new FontOptionsPanel(this.mOldFormatData);
        DialogUtil.addUsingGBL(jPanel, fontOptionsPanel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        this.mApplyToLabel.setLabelFor(this.mApplyToCB);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.mFormatLabel);
        jPanel2.add(this.mFormatCB);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 1, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mDoDecimalsCheckBox, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        this.mDecimalLabel.setLabelFor(this.mDecimalSpinner);
        this.mDecimalSpinner.setPreferredSize(new Dimension(45, 25));
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.mDecimalLabel);
        jPanel3.add(this.mDecimalSpinner);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 3, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 1, 3, 1, 1, n, null);
        return jPanel;
    }

    public JPanel getPreviewPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, new JLabel(this.mParent.getResString("IDS_CF_FORMAT_PREVIEW")), gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, 0, 0, 0));
        this.mPreviewPanel = this.createPreviewPanel();
        this.mPreviewArea = new JLabel();
        this.mPreviewArea.setPreferredSize(new Dimension(100, 25));
        this.mPreviewArea.setOpaque(true);
        this.mPreviewArea.setFont(this.mPreviewArea.getFont().deriveFont(24));
        this.mPreviewArea.setBorder(BorderFactory.createLineBorder(Color.black));
        this.mPreviewArea.setHorizontalAlignment(4);
        DialogUtil.addUsingGBL(jPanel, this.mPreviewPanel, gridBagConstraints, 0, 1, 1, 1, n, new Insets(0, 0, 0, 0));
        return jPanel;
    }

    private boolean enableControls() {
        boolean bl = this.mDoFormattingRB.isSelected();
        if (this.mBoldButton != null) {
            this.mBoldButton.setEnabled(bl);
        }
        if (this.mItalicizedButton != null) {
            this.mItalicizedButton.setEnabled(bl);
        }
        if (this.mUnderlineButton != null) {
            this.mUnderlineButton.setEnabled(bl);
        }
        if (this.mForegroundColorDropButton != null) {
            this.mForegroundColorDropButton.setEnabled(bl);
        }
        if (this.mBGColorDropButton != null) {
            this.mBGColorDropButton.setEnabled(bl);
        }
        if (this.mFormatCB != null) {
            this.mFormatCB.setEnabled(bl);
        }
        if (this.mFormatLabel != null) {
            this.mFormatLabel.setEnabled(bl);
        }
        boolean bl2 = this.mDoDecimalsCheckBox.isSelected();
        boolean bl3 = this.selectedFormatSupportsDecimals();
        if (this.mDoDecimalsCheckBox != null) {
            this.mDoDecimalsCheckBox.setEnabled(bl && bl3);
        }
        if (this.mDecimalSpinner != null) {
            this.mDecimalSpinner.setEnabled(bl && bl3 && bl2);
        }
        if (this.mDecimalLabel != null) {
            this.mDecimalLabel.setEnabled(bl && bl3 && bl2);
        }
        this.mReplaceTextLabel.setEnabled(this.mReplaceValueCheckBox.isSelected());
        this.mReplaceValueText.setEnabled(this.mReplaceValueCheckBox.isSelected());
        this.mContinueButton.setEnabled(!this.mReplaceValueCheckBox.isSelected() || this.mReplaceValueCheckBox.isSelected() && this.mReplaceValueText.getText().length() > 0);
        return true;
    }

    private boolean selectedFormatSupportsDecimals() {
        boolean bl = false;
        if (this.mFormatCB != null && this.mFormatCB.getSelectedIndex() != -1) {
            int n = this.mFormatCB.getSelectedIndex();
            bl = this.mMyCellFormatHelper.formatSupportsDecimals(n);
        }
        return bl;
    }

    public TableStyleDlg.FormatData getFormatData() {
        this.copySelectionsToFormatData();
        return this.mNewFormatData;
    }

    private void updatePreview() {
        this.copySelectionsToFormatData();
        this.mPreviewPanel.repaint();
    }

    public String getPreviewSampleText() {
        String string = "123.456";
        if (this.mFormatCB != null && this.mFormatCB.getSelectedIndex() != -1) {
            int n = this.mFormatCB.getSelectedIndex();
            if (this.mMyCellFormatHelper.isDateOffset(n) || this.mMyCellFormatHelper.isTimeOffset(n)) {
                string = "1929-02-10T00:00:00.000";
            } else if (n == 0) {
                string = "123";
            }
        }
        return string;
    }

    private void copySelectionsToFormatData() {
        this.mNewFormatData.setBold(this.mBoldButton.isSelected());
        this.mNewFormatData.setUnderline(this.mUnderlineButton.isSelected());
        this.mNewFormatData.setItalic(this.mItalicizedButton.isSelected());
        this.mNewFormatData.setBackgroundColor(this.mBGColorDropButton.getUserSelectedColor());
        this.mNewFormatData.setForegroundColor(this.mForegroundColorDropButton.getUserSelectedColor());
        this.mNewFormatData.setDoFormatting(this.mDoFormattingRB.isSelected());
        CellFormatHelper.FormatType formatType = this.mMyCellFormatHelper.getFormatTypeForIndex(this.mFormatCB.getSelectedIndex());
        this.mNewFormatData.setFormatType(formatType);
        this.mNewFormatData.setFormatOffset(0, this.mFormatCB.getSelectedIndex());
        boolean bl = this.selectedFormatSupportsDecimals();
        this.mNewFormatData.setDecimals((Integer)this.mDecimalSpinner.getValue());
        this.mNewFormatData.setDoDecimals(this.mDoDecimalsCheckBox.isSelected());
        this.mNewFormatData.setFormatSupportsDecimals(bl);
        this.mNewFormatData.setFormatStringRepersentation(this.mMyCellFormatHelper.getStringRepresentationForFormat(this.mFormatCB.getSelectedIndex()));
        this.mNewFormatData.setApplyToType(((ApplyToPair)this.mApplyToCB.getSelectedItem()).getApplyToType());
        this.mNewFormatData.setDoReplaceValue(this.mReplaceValueCheckBox.isSelected());
        this.mNewFormatData.setReplaceText(this.mReplaceValueText.getText());
    }

    class MyCellFormatHelper
    extends CellFormatHelper {
        private int[] sNoDecimal = new int[]{6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 24, 26, 28, 29, 31};
        public String[] sAllNames = null;
        int mNumberCount = -1;
        int mDateCount = -1;
        int mTmeCount = -1;
        int mCurrencyCount = -1;
        public static final int NUM_PRE_LIST_FORMATS = 1;

        MyCellFormatHelper() {
        }

        public void init() {
            this.getAllNames();
        }

        public String[] getAllNames() {
            if (this.sAllNames == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(TableStyleFormatDlg.this.mParent.getResString("IDS_CF_AS_IS"));
                String[] stringArray = CellFormatPanel.getTimeNames();
                arrayList.addAll(Arrays.asList(this.getNumberNames()));
                arrayList.addAll(Arrays.asList(CellFormatPanel.getDateNames()));
                arrayList.addAll(Arrays.asList(stringArray[6], stringArray[7], stringArray[8]));
                arrayList.addAll(Arrays.asList(this.getCurrencyNames()));
                this.sAllNames = arrayList.toArray((String[])Array.newInstance(String.class, arrayList.size()));
            }
            this.mNumberCount = this.getNumberCount();
            this.mDateCount = 24;
            this.mTmeCount = this.getTimeCount();
            this.mCurrencyCount = this.getCurrencyCount();
            return this.sAllNames;
        }

        public String[] getCurrencyNames() {
            String[] stringArray = new String[super.getCurrencyNames().length + 1];
            Preferences preferences = Preferences.userRoot().node(PrefsMgr.getPrefsMgr().getUIUserPrefs().absolutePath());
            this.loadCustomCurrencyFormat(preferences, sCustomCurrencyPrefKeys);
            stringArray[0] = super.getCurrencyNames()[0];
            for (int i = 0; i < this.getCustomCurrencyFormats().length; ++i) {
                String string;
                stringArray[i + 1] = string = this.getFormattedCustomCurrencyString(super.getCustomCurrencyFormats()[i]);
            }
            return stringArray;
        }

        public int getTimeCount() {
            return 3;
        }

        public boolean isNumberOffset(int n) {
            return n >= 1 && n < 1 + this.getNumberCount();
        }

        public boolean isDateOffset(int n) {
            return n >= 1 + this.mNumberCount && n < 1 + this.mNumberCount + this.mDateCount;
        }

        public boolean isTimeOffset(int n) {
            return n >= 1 + this.mNumberCount + this.mDateCount && n < 1 + this.mNumberCount + this.mDateCount + this.mTmeCount;
        }

        public boolean isCurrencyOffset(int n) {
            return n >= 1 + this.mNumberCount + this.mDateCount + this.mTmeCount && n < 1 + this.mNumberCount + this.mDateCount + this.mTmeCount + this.mCurrencyCount;
        }

        private String getStringRepresentationForFormat(int n) {
            String string = null;
            if (this.isNumberOffset(n)) {
                string = this.getNumberFormatSyntax(this.getOffsetWithinType(n));
            } else if (this.isDateOffset(n)) {
                string = this.getDateFormatSyntax(this.getOffsetWithinType(n));
            } else if (this.isTimeOffset(n)) {
                string = this.getTimeFormatSyntax(this.getOffsetWithinType(n));
            } else if (this.isCurrencyOffset(n)) {
                string = this.getCurrencyFormatSyntax(this.getOffsetWithinType(n));
            }
            return string;
        }

        public CellFormatHelper.FormatType getFormatTypeForIndex(int n) {
            CellFormatHelper.FormatType formatType = CellFormatHelper.FormatType.INVALID;
            if (this.isNumberOffset(n)) {
                formatType = CellFormatHelper.FormatType.NUMBER;
            } else if (this.isDateOffset(n)) {
                formatType = CellFormatHelper.FormatType.DATE;
            } else if (this.isTimeOffset(n)) {
                formatType = CellFormatHelper.FormatType.TIME;
            } else if (this.isCurrencyOffset(n)) {
                formatType = CellFormatHelper.FormatType.CURRENCY;
            }
            return formatType;
        }

        public int getOffsetWithinType(int n) {
            int n2 = -1;
            if (this.isNumberOffset(n)) {
                n2 = n - 1;
            } else if (this.isDateOffset(n)) {
                n2 = n - (1 + this.mNumberCount);
            } else if (this.isTimeOffset(n)) {
                n2 = n - (1 + this.mNumberCount + this.mDateCount);
            } else if (this.isCurrencyOffset(n)) {
                n2 = n - (1 + this.mNumberCount + this.mDateCount + this.mTmeCount);
            }
            return n2;
        }

        public boolean formatSupportsDecimals(int n) {
            boolean bl = true;
            if (n < 1) {
                bl = false;
            } else {
                for (int n2 : this.sNoDecimal) {
                    if (n2 != n - 1) continue;
                    bl = false;
                    break;
                }
            }
            return bl;
        }

        public String getNumberFormatSyntax(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = "F";
                    break;
                }
                case 1: {
                    string = "E";
                    break;
                }
                case 2: {
                    string = "COMMA";
                    break;
                }
                case 3: {
                    string = "DOT";
                    break;
                }
                case 4: {
                    string = "E";
                    break;
                }
                case 5: {
                    string = "PCT";
                }
            }
            return string;
        }

        public String getDateFormatSyntax(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = "DATE9";
                    break;
                }
                case 1: {
                    string = "DATE11";
                    break;
                }
                case 2: {
                    string = "ADATE8";
                    break;
                }
                case 3: {
                    string = "ADATE10";
                    break;
                }
                case 4: {
                    string = "EDATE8";
                    break;
                }
                case 5: {
                    string = "EDATE10";
                    break;
                }
                case 6: {
                    string = "SDATE8";
                    break;
                }
                case 7: {
                    string = "SDATE10";
                    break;
                }
                case 8: {
                    string = "JDATE5";
                    break;
                }
                case 9: {
                    string = "JDATE7";
                    break;
                }
                case 10: {
                    string = "QYR6";
                    break;
                }
                case 11: {
                    string = "QYR8";
                    break;
                }
                case 12: {
                    string = "MOYR6";
                    break;
                }
                case 13: {
                    string = "MOYR8";
                    break;
                }
                case 14: {
                    string = "WKYR8";
                    break;
                }
                case 15: {
                    string = "WKYR10";
                    break;
                }
                case 16: {
                    string = "DATETIME17";
                    break;
                }
                case 17: {
                    string = "DATETIME22";
                    break;
                }
                case 18: {
                    string = "YMDHMS16";
                    break;
                }
                case 19: {
                    string = "YMDHMS22";
                    break;
                }
                case 20: {
                    string = "DTIME9";
                    break;
                }
                case 21: {
                    string = "DTIME13";
                    break;
                }
                case 22: {
                    string = "WKDAY10";
                    break;
                }
                case 23: {
                    string = "MONTH10";
                }
            }
            return string;
        }

        private String getTimeFormatSyntax(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = "MTIME8";
                    break;
                }
                case 1: {
                    string = "TIME5";
                    break;
                }
                case 2: {
                    string = "TIME10";
                }
            }
            return string;
        }

        private String getCurrencyFormatSyntax(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = "DOLLAR";
                    break;
                }
                case 1: {
                    string = "CCA";
                    break;
                }
                case 2: {
                    string = "CCB";
                    break;
                }
                case 3: {
                    string = "CCC";
                    break;
                }
                case 4: {
                    string = "CCD";
                    break;
                }
                case 5: {
                    string = "CCE";
                }
            }
            return string;
        }

        private FormatSpecification getCurrencyFormat(Specification specification, int n, Integer n2) {
            FormatSpecification formatSpecification = new FormatSpecification();
            MyCellFormatHelper.copyAffixChildren((Specification)specification, (FormatSpecification)formatSpecification);
            CellFormatHelper.CellCurrencyFormat[] cellCurrencyFormatArray = this.getCustomCurrencyFormats();
            switch (n) {
                case 0: {
                    formatSpecification.setPrefix(sCurrencyDolor);
                    formatSpecification.setUseGrouping(Boolean.valueOf(true));
                    break;
                }
                case 1: {
                    formatSpecification.setPrefix(cellCurrencyFormatArray[0].allPrefix);
                    formatSpecification.setSuffix(cellCurrencyFormatArray[0].allSuffix);
                    if (cellCurrencyFormatArray[0].separator.equals("period")) {
                        formatSpecification.setSeparaterCharacters("" + sGroupChar + sDecimalChar + "::");
                        break;
                    }
                    formatSpecification.setSeparaterCharacters("" + sDecimalChar + sGroupChar + "::");
                    break;
                }
                case 2: {
                    formatSpecification.setPrefix(cellCurrencyFormatArray[1].allPrefix);
                    formatSpecification.setSuffix(cellCurrencyFormatArray[1].allSuffix);
                    if (cellCurrencyFormatArray[1].separator.equals("period")) {
                        formatSpecification.setSeparaterCharacters("" + sGroupChar + sDecimalChar + "::");
                        break;
                    }
                    formatSpecification.setSeparaterCharacters("" + sDecimalChar + sGroupChar + "::");
                    break;
                }
                case 3: {
                    formatSpecification.setPrefix(cellCurrencyFormatArray[2].allPrefix);
                    formatSpecification.setSuffix(cellCurrencyFormatArray[2].allSuffix);
                    if (cellCurrencyFormatArray[2].separator.equals("period")) {
                        formatSpecification.setSeparaterCharacters("" + sGroupChar + sDecimalChar + "::");
                        break;
                    }
                    formatSpecification.setSeparaterCharacters("" + sDecimalChar + sGroupChar + "::");
                    break;
                }
                case 4: {
                    formatSpecification.setPrefix(cellCurrencyFormatArray[3].allPrefix);
                    formatSpecification.setSuffix(cellCurrencyFormatArray[3].allSuffix);
                    if (cellCurrencyFormatArray[3].separator.equals("period")) {
                        formatSpecification.setSeparaterCharacters("" + sGroupChar + sDecimalChar + "::");
                        break;
                    }
                    formatSpecification.setSeparaterCharacters("" + sDecimalChar + sGroupChar + "::");
                    break;
                }
                case 5: {
                    formatSpecification.setPrefix(cellCurrencyFormatArray[4].allPrefix);
                    formatSpecification.setSuffix(cellCurrencyFormatArray[4].allSuffix);
                    if (cellCurrencyFormatArray[4].separator.equals("period")) {
                        formatSpecification.setSeparaterCharacters("" + sGroupChar + sDecimalChar + "::");
                        break;
                    }
                    formatSpecification.setSeparaterCharacters("" + sDecimalChar + sGroupChar + "::");
                }
            }
            if (n2 != null) {
                formatSpecification.setMaximumFractionDigits(n2);
                formatSpecification.setMinimumFractionDigits(n2);
            }
            return formatSpecification;
        }
    }

    private class FontAction
    extends AbstractAction {
        FontAction(String string, Icon icon) {
            super(string, icon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TableStyleFormatDlg.this.updatePreview();
        }
    }

    private class FontOptionsPanel
    extends JPanel {
        TableStyleDlg.FormatData mFormatData;

        FontOptionsPanel(TableStyleDlg.FormatData formatData) {
            this.mFormatData = formatData;
            this.initPanel();
        }

        private void initPanel() {
            ResourceBundle resourceBundle;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 3;
            Insets insets = DialogUtil.getStandardControlInsets();
            int n = 23;
            TableStyleFormatDlg.this.mBoldButton = new JToggleButton(new FontAction("", new ImageIcon(SyntaxEditorResUtil.getImageResource((String)SyntaxEditorResUtil.getString((String)"IDS_BOLD_IMAGE")))));
            TableStyleFormatDlg.this.mBoldButton.setMargin(new Insets(0, 0, 0, 0));
            TableStyleFormatDlg.this.mBoldButton.setSelected(this.mFormatData.isBold());
            AccessibleContext accessibleContext = TableStyleFormatDlg.this.mBoldButton.getAccessibleContext();
            if (accessibleContext != null) {
                resourceBundle = SyntaxEditorResUtil.getBundle(null, (Locale)SyntaxEditorResUtil.getLocale());
                accessibleContext.setAccessibleName(resourceBundle.getString("IDS_FONT_BOLD"));
            }
            TableStyleFormatDlg.this.mBoldButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableStyleFormatDlg.this.updatePreview();
                }
            });
            TableStyleFormatDlg.this.mItalicizedButton = new JToggleButton(new FontAction("", new ImageIcon(SyntaxEditorResUtil.getImageResource((String)SyntaxEditorResUtil.getString((String)"IDS_ITALIC_IMAGE")))));
            TableStyleFormatDlg.this.mItalicizedButton.setSelected(this.mFormatData.isItalic());
            TableStyleFormatDlg.this.mItalicizedButton.setMargin(new Insets(0, 0, 0, 0));
            accessibleContext = TableStyleFormatDlg.this.mItalicizedButton.getAccessibleContext();
            if (accessibleContext != null) {
                resourceBundle = SyntaxEditorResUtil.getBundle(null, (Locale)SyntaxEditorResUtil.getLocale());
                accessibleContext.setAccessibleName(resourceBundle.getString("IDS_FONT_ITALIC"));
            }
            TableStyleFormatDlg.this.mItalicizedButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableStyleFormatDlg.this.updatePreview();
                }
            });
            TableStyleFormatDlg.this.mUnderlineButton = new JToggleButton(new FontAction("", new ImageIcon(SyntaxEditorResUtil.getImageResource((String)SyntaxEditorResUtil.getString((String)"IDS_UNDERLINE_IMAGE")))));
            TableStyleFormatDlg.this.mUnderlineButton.setSelected(this.mFormatData.isUnderline());
            TableStyleFormatDlg.this.mUnderlineButton.setMargin(new Insets(0, 0, 0, 0));
            accessibleContext = TableStyleFormatDlg.this.mUnderlineButton.getAccessibleContext();
            if (accessibleContext != null) {
                resourceBundle = SyntaxEditorResUtil.getBundle(null, (Locale)SyntaxEditorResUtil.getLocale());
                accessibleContext.setAccessibleName(resourceBundle.getString("IDS_FONT_UNDERLINE"));
            }
            TableStyleFormatDlg.this.mUnderlineButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableStyleFormatDlg.this.updatePreview();
                }
            });
            resourceBundle = new FillButtonDrawer();
            TableStyleFormatDlg.this.mBGColorDropButton = LtEditorUtil.createFillDropButton((boolean)false);
            TableStyleFormatDlg.this.mBGColorDropButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableStyleFormatDlg.this.updatePreview();
                }
            });
            TableStyleFormatDlg.this.mForegroundColorDropButton = LtEditorUtil.createTextDropButton((boolean)false);
            TableStyleFormatDlg.this.mForegroundColorDropButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableStyleFormatDlg.this.updatePreview();
                }
            });
            TableStyleFormatDlg.this.mBoldButton.setPreferredSize(new Dimension(30, 30));
            TableStyleFormatDlg.this.mItalicizedButton.setPreferredSize(new Dimension(30, 30));
            TableStyleFormatDlg.this.mUnderlineButton.setPreferredSize(new Dimension(30, 30));
            TableStyleFormatDlg.this.mForegroundColorDropButton.setPreferredSize(new Dimension(50, 30));
            TableStyleFormatDlg.this.mForegroundColorDropButton.setSize(new Dimension(50, 30));
            TableStyleFormatDlg.this.mForegroundColorDropButton.setMaximumSize(new Dimension(50, 30));
            TableStyleFormatDlg.this.mForegroundColorDropButton.setMinimumSize(new Dimension(50, 30));
            TableStyleFormatDlg.this.mBGColorDropButton.setPreferredSize(new Dimension(50, 30));
            TableStyleFormatDlg.this.mBGColorDropButton.setSize(new Dimension(50, 30));
            TableStyleFormatDlg.this.mBGColorDropButton.setMaximumSize(new Dimension(50, 30));
            TableStyleFormatDlg.this.mBGColorDropButton.setMinimumSize(new Dimension(50, 30));
            Insets insets2 = new Insets(insets.top, insets.left, insets.bottom + 10, insets.right);
            DialogUtil.addUsingGBL(this, TableStyleFormatDlg.this.mBoldButton, gridBagConstraints, 0, 0, 1, 1, n, insets2);
            DialogUtil.addUsingGBL(this, TableStyleFormatDlg.this.mBoldButton, gridBagConstraints, 1, 0, 1, 1, n, insets2);
            DialogUtil.addUsingGBL(this, TableStyleFormatDlg.this.mItalicizedButton, gridBagConstraints, 2, 0, 1, 1, n, insets2);
            DialogUtil.addUsingGBL(this, TableStyleFormatDlg.this.mUnderlineButton, gridBagConstraints, 3, 0, 1, 1, n, insets2);
            DialogUtil.addUsingGBL(this, (JComponent)TableStyleFormatDlg.this.mForegroundColorDropButton, gridBagConstraints, 4, 0, 1, 1, n, insets2);
            DialogUtil.addUsingGBL(this, (JComponent)TableStyleFormatDlg.this.mBGColorDropButton, gridBagConstraints, 5, 0, 1, 1, n, insets2);
        }
    }

    class ApplyToPair {
        TableStyleDlg.ApplyToType mApplyToType;

        ApplyToPair(TableStyleDlg.ApplyToType applyToType) {
            this.mApplyToType = applyToType;
        }

        public TableStyleDlg.ApplyToType getApplyToType() {
            return this.mApplyToType;
        }

        public String toString() {
            return TableStyleFormatDlg.this.mParent.getApplyToStringRepresentation(this.mApplyToType);
        }
    }

    public class MyDocumentListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            TableStyleFormatDlg.this.enableControls();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            TableStyleFormatDlg.this.enableControls();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            TableStyleFormatDlg.this.enableControls();
        }
    }
}

