/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.post_processing_output;

import com.spss.java_client.ui.controls.ButtonEditCtrl;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.IButtonEditListener;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.post_processing_output.DialogHelper;
import com.spss.java_client.ui.dialogs.post_processing_output.EnumListRenderer;
import com.spss.java_client.ui.dialogs.post_processing_output.EnumTableCellRenderer;
import com.spss.java_client.ui.dialogs.post_processing_output.ModifyOutputEnumManager;
import com.spss.java_client.ui.dialogs.post_processing_output.TableStyleConditionDlg;
import com.spss.java_client.ui.dialogs.post_processing_output.TableStyleFormatDlg;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.pivottable.util.CellFormatHelper;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.row_management_table.AbstractListTableModel;
import com.spss.uitools.controls.row_management_table.TableRowManagementHelper;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class TableStyleDlg
extends BaseSubDialog {
    static ResourceBundle mMyResBundle;
    public static final int TABLE_COL = 0;
    public static final int VALUES_COL = 1;
    public static final int DIMENSIONS_COL = 2;
    public static final int CONDITION_COL = 3;
    public static final int FORMAT_COL = 4;
    private JScrollPane mTableScrollPane;
    private FocusableTextArea mInfoText1;
    private FocusableTextArea mInfoText2;
    public final MyEnumListRenderer mValueListRenderer = new MyEnumListRenderer();
    public final MyEnumListRenderer mTableListRenderer = new MyEnumListRenderer();
    public final MyEnumListRenderer mDimensionsListRenderer = new MyEnumListRenderer();
    public final MyEnumTableCellRenderer mValueColCellRenderer = new MyEnumTableCellRenderer();
    public final DimensionRenderer mDimensionsCellRenderer = new DimensionRenderer();
    public final ConditionColCellRenderer mConditionColCellRenderer = new ConditionColCellRenderer();
    public final FormatColCellRenderer mFormatColCellRenderer = new FormatColCellRenderer();
    public final MyEnumTableCellRenderer mTableColCellRenderer = new MyEnumTableCellRenderer();
    private ValueColComboEditor mValueColComboEditor;
    private DimensionsColComboEditor mDimensionsColComboEditor;
    private TableColComboEditor mTableColComboEditor;
    private Frame mParentFrame;
    private BaseProcedureDialog mParentDialog;
    private ArrayList<String> mTableColNames;
    ConditionalFormatDlgType mConditionalFormatDlgType;
    private TableDefaults mTableDefaults;
    private ConditionalFormattingTable mTable;
    private ConditionalFormattingTableModel mConditionalFormattingTableModel = null;
    private boolean mInRender = false;
    private DialogFocusTraversalPolicy mPolicy;
    private TableRowManagementHelper mTableRowManagementHelper;
    JButton mAddButton;
    JButton mCopyButton;
    JButton mUpButton;
    JButton mDownButton;
    JButton mDeleteButton;
    private JComboBox mValuesCombo = new JComboBox();
    private JCheckBox mReportCheckbox;
    private TableStyleData mStartupTableStyleData = null;

    public TableStyleDlg(BaseProcedureDialog baseProcedureDialog, ConditionalFormatDlgType conditionalFormatDlgType) {
        this(baseProcedureDialog, conditionalFormatDlgType, null);
    }

    public TableStyleDlg(BaseProcedureDialog baseProcedureDialog, ConditionalFormatDlgType conditionalFormatDlgType, TableStyleData tableStyleData) {
        super(baseProcedureDialog, "", true, ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), UtilitiesResBundle.getImageFolder());
        mMyResBundle = ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        new ModifyOutputEnumManager(mMyResBundle);
        this.mParentDialog = baseProcedureDialog;
        this.mStartupTableStyleData = tableStyleData;
        this.setTitle(this.getResString("IDS_TABLE_STYLE_DLG_TITLE"));
        this.postSuperInit(conditionalFormatDlgType);
        this.setupDefaultColumnWidths();
        if (this.mConditionalFormatDlgType == ConditionalFormatDlgType.ModifyDialog) {
            this.mReportCheckbox.setEnabled(false);
        }
    }

    private void setupDefaultColumnWidths() {
        final ConditionalFormattingTable conditionalFormattingTable = this.mTable;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableColumnModel tableColumnModel = TableStyleDlg.this.mTable.getColumnModel();
                int n = TableStyleDlg.this.mTable.getWidth();
                tableColumnModel.getColumn(0).setPreferredWidth((int)((double)n * 0.2));
                tableColumnModel.getColumn(1).setPreferredWidth((int)((double)n * 0.13));
                tableColumnModel.getColumn(2).setPreferredWidth((int)((double)n * 0.12));
                tableColumnModel.getColumn(3).setPreferredWidth((int)((double)n * 0.18));
                tableColumnModel.getColumn(4).setPreferredWidth((int)((double)n * 0.37));
                TableStyleDlg.this.selectRow(0);
                conditionalFormattingTable.revalidate();
            }
        });
    }

    public BaseProcedureDialog getBaseProcedureDialog() {
        return this.mParentDialog;
    }

    private void postSuperInit(ConditionalFormatDlgType conditionalFormatDlgType) {
        this.mConditionalFormatDlgType = conditionalFormatDlgType;
        this.mTableDefaults = new TableDefaults(conditionalFormatDlgType);
        this.initTableColumnNames();
        this.setupTableModel(null);
        this.mTableRowManagementHelper = new TableRowManagementHelper((JTable)this.mTable, this.mUpButton, this.mDownButton);
        this.pack();
        this.enableContinueButton();
    }

    private void initTableColumnNames() {
        this.mTableColNames = new ArrayList();
        this.mTableColNames.add(this.getResString("IDS_CONDITIONAL_TABLE_COL1_LABEL"));
        this.mTableColNames.add(this.getResString("IDS_CONDITIONAL_TABLE_COL2_LABEL"));
        this.mTableColNames.add(this.getResString("IDS_CONDITIONAL_TABLE_COL3_LABEL"));
        this.mTableColNames.add(this.getResString("IDS_CONDITIONAL_TABLE_COL4_LABEL"));
        this.mTableColNames.add(this.getResString("IDS_CONDITIONAL_TABLE_COL5_LABEL"));
    }

    public void setRowDatas(ArrayList<RowData> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            arrayList = new ArrayList();
            arrayList.add(new RowData(ModifyOutputEnumManager.TableType.All, ValueType.UserSpecified, ModifyOutputEnumManager.DimensionsType.Column));
        }
        this.setupTableModel(arrayList);
        this.enableContinueButton();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        TableStyleData tableStyleData = this.mStartupTableStyleData != null ? this.mStartupTableStyleData : (TableStyleData)dialogDataModel.getObject(TableStyleDlg.getDialogDataModelKeyName(this.mConditionalFormatDlgType));
        ArrayList<RowData> arrayList = tableStyleData != null ? this.createCopy(tableStyleData.getRowDatas()) : null;
        boolean bl = tableStyleData != null ? tableStyleData.isReportSelected() : false;
        this.setRowDatas(arrayList);
        if (bl) {
            this.mReportCheckbox.setSelected(bl);
        }
    }

    private ArrayList<RowData> createCopy(ArrayList<RowData> arrayList) {
        ArrayList<RowData> arrayList2 = new ArrayList<RowData>();
        for (RowData rowData : arrayList) {
            try {
                arrayList2.add((RowData)rowData.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        return arrayList2;
    }

    private static String getDialogDataModelKeyName(ConditionalFormatDlgType conditionalFormatDlgType) {
        return "ConditionalFormattingDlg_" + TableStyleDlg.getStringForConditionalFormatDlgType(conditionalFormatDlgType);
    }

    private void setupTableModel(ArrayList<RowData> arrayList) {
        this.mConditionalFormattingTableModel = new ConditionalFormattingTableModel(arrayList);
        this.mTable.setModel((TableModel)((Object)this.mConditionalFormattingTableModel));
        this.initTableRenderers();
        if (arrayList != null && arrayList.size() > 0) {
            this.selectRow(0);
            this.mTableDefaults.modifyDefaultsForTableType(this.mConditionalFormattingTableModel.getTableTypeForRow(0));
        }
    }

    private void selectRow(final int n) {
        this.mTable.setColumnSelectionInterval(0, this.mTable.getColumnCount() - 1);
        this.mTable.setRowSelectionInterval(n, n);
        this.mTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(-1);
        this.mTable.getColumnModel().getSelectionModel().setLeadSelectionIndex(-1);
        this.mTable.getSelectionModel().setAnchorSelectionIndex(-1);
        this.mTable.getSelectionModel().setLeadSelectionIndex(-1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableStyleDlg.this.mTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(0);
                TableStyleDlg.this.mTable.getSelectionModel().setAnchorSelectionIndex(n);
                TableStyleDlg.this.mTable.getColumnModel().getSelectionModel().setLeadSelectionIndex(0);
                TableStyleDlg.this.mTable.getSelectionModel().setLeadSelectionIndex(n);
            }
        });
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        super.saveState(dialogDataModel);
        if (this.mConditionalFormatDlgType != ConditionalFormatDlgType.ModifyDialog) {
            TableStyleData tableStyleData = new TableStyleData(this.mConditionalFormattingTableModel.getRowDatas(), this.mConditionalFormatDlgType != ConditionalFormatDlgType.ModifyDialog, this.mReportCheckbox.isSelected());
            dialogDataModel.putObject(TableStyleDlg.getDialogDataModelKeyName(this.mConditionalFormatDlgType), tableStyleData);
        }
        return true;
    }

    public TableStyleData getTableStyleData() {
        ArrayList<RowData> arrayList = this.mConditionalFormattingTableModel.getRowDatas();
        TableStyleData tableStyleData = new TableStyleData(arrayList, this.mConditionalFormatDlgType != ConditionalFormatDlgType.ModifyDialog, this.mReportCheckbox.isSelected());
        return tableStyleData;
    }

    public ArrayList<RowData> getRowDatas() {
        return this.mConditionalFormattingTableModel.getRowDatas();
    }

    @Override
    public void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, n2, n2);
        JPanel jPanel2 = this.setupInfoTextPanel();
        DialogUtil.normalizeLabelWidths(jPanel2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mTableScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mReportCheckbox, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 1, 0, 1, 1, n, insets);
        jPanel2 = this.setupAddUpDownRemoveCmdButtonPanel();
        DialogUtil.normalizeLabelWidths(jPanel2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 1, 1, 1, n, insets);
        this.setTabTraversalOrder();
    }

    private JPanel setupAddUpDownRemoveCmdButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, n2, n2);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_CONDITIONAL_DLG_ADD"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableStyleDlg.this.mTableRowManagementHelper.doInsert(TableStyleDlg.this.mTable.getRowCount(), 1);
            }
        };
        this.mAddButton = DialogUtil.createButton(this, "IDS_CONDITIONAL_DLG_ADD", toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mAddButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_CONDITIONAL_DLG_DUPLICATE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableStyleDlg.this.doCopySelectedRow();
            }
        };
        this.mCopyButton = DialogUtil.createButton(this, "IDS_CONDITIONAL_DLG_DUPLICATE", toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mCopyButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mUpButton = DialogUtil.createButton(this, "IDS_CONDITIONAL_DLG_MOVE_UP");
        DialogUtil.addUsingGBL(jPanel2, this.mUpButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.mDownButton = DialogUtil.createButton(this, "IDS_CONDITIONAL_DLG_MOVE_DOWN");
        DialogUtil.addUsingGBL(jPanel2, this.mDownButton, gridBagConstraints, 0, 3, 1, 1, n, insets);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_CONDITIONAL_DLG_DELETE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableStyleDlg.this.mTableRowManagementHelper.doRemove();
            }
        };
        this.mDeleteButton = DialogUtil.createButton(this, "IDS_CONDITIONAL_DLG_DELETE", toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mCopyButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.mDeleteButton, "South");
        return jPanel;
    }

    private void doCopySelectedRow() {
        int n = this.mTable.getSelectedRow();
        if (n >= 0) {
            this.mTable.copyRow(n);
        }
    }

    private void initVars() {
        this.mTable = this.createTable();
        this.mTableScrollPane = new JScrollPane(this.mTable);
        this.mTableScrollPane.setVerticalScrollBarPolicy(20);
        this.mTableScrollPane.setHorizontalScrollBarPolicy(31);
        this.mTableScrollPane.setMinimumSize(new Dimension(800, 200));
        this.mTableScrollPane.setPreferredSize(new Dimension(800, 200));
        JTableHeader jTableHeader = this.mTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(true);
        jTableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setHorizontalAlignment(0);
                jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                jLabel.setBackground(jTable.getTableHeader().getBackground());
                jLabel.setForeground(jTable.getTableHeader().getForeground());
                jLabel.setFont(jTable.getTableHeader().getFont().deriveFont(1));
                return jLabel;
            }
        });
        this.mTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mTable.getActionMap().put("tabIn", abstractAction2);
        this.mTable.getActionMap().put("tabOut", abstractAction);
        this.mReportCheckbox = DialogUtil.createCheckBox(this, "IDS_CONDITIONAL_REPORT_CHECKBOX");
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTable);
        this.mPolicy = new DialogFocusTraversalPolicy(vector, false);
    }

    public String getIActionKey() {
        return null;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_modify_output_table_style";
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
    }

    private JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        return jPanel;
    }

    private JPanel setupInfoTextPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, n2, n2);
        String string = this.getResString("CONDITIONAL_FORMATTING_TEXT_1");
        this.mInfoText1 = new FocusableTextArea(string, null);
        DialogUtil.addUsingGBL(jPanel, this.mInfoText1, gridBagConstraints, 0, 0, 1, 1, n, insets);
        string = this.getResString("CONDITIONAL_FORMATTING_TEXT_2");
        this.mInfoText2 = new FocusableTextArea(string, null);
        DialogUtil.addUsingGBL(jPanel, this.mInfoText2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JLabel jLabel = new JLabel(this.getResString("IDS_CONDITIONAL_TABLE_TITLE"));
        jLabel.setLabelFor(this.mTable);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 1, 1, n, new Insets(insets.top, insets.left, 0, insets.right));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            jLabel.setDisplayedMnemonic((Integer)this.mResBundle.getObject("IDK_CONDITIONAL_TABLE_TITLE_KEY"));
        }
        jLabel.setLabelFor(this.mTable);
        return jPanel;
    }

    private ConditionalFormattingTable createTable() {
        this.mTable = new ConditionalFormattingTable();
        this.mTable.setFocusable(true);
        this.mTable.setRowHeight(22);
        this.mTable.setColumnSelectionAllowed(true);
        this.mTable.setRowSelectionAllowed(true);
        this.mTable.setCellSelectionEnabled(true);
        this.mTable.getTableHeader().setReorderingAllowed(false);
        this.mTable.getTableHeader().setResizingAllowed(false);
        this.mTable.setGridColor(Color.darkGray);
        this.mTable.getTableHeader().setReorderingAllowed(false);
        return this.mTable;
    }

    private void initTableRenderers() {
        this.mValueColComboEditor = new ValueColComboEditor(this.mValuesCombo);
        this.mTable.getColumnModel().getColumn(1).setCellEditor(this.mValueColComboEditor);
        this.mTable.getColumnModel().getColumn(1).setCellRenderer(this.mValueColCellRenderer);
        MyButtonEditCtrl myButtonEditCtrl = new MyButtonEditCtrl(3);
        this.mTable.getColumnModel().getColumn(3).setCellEditor(myButtonEditCtrl);
        this.mTable.getColumnModel().getColumn(3).setCellRenderer(this.mConditionColCellRenderer);
        myButtonEditCtrl.addButtonListener(new ConditionButtonListener());
        myButtonEditCtrl = new MyButtonEditCtrl(4);
        this.mTable.getColumnModel().getColumn(4).setCellEditor(myButtonEditCtrl);
        this.mTable.getColumnModel().getColumn(4).setCellRenderer(this.mFormatColCellRenderer);
        myButtonEditCtrl.addButtonListener(new FormatButtonListener());
        this.mDimensionsColComboEditor = new DimensionsColComboEditor();
        this.mTable.getColumnModel().getColumn(2).setCellEditor(this.mDimensionsColComboEditor);
        this.mTable.getColumnModel().getColumn(2).setCellRenderer(this.mDimensionsCellRenderer);
        this.mTableColComboEditor = new TableColComboEditor();
        this.mTable.getColumnModel().getColumn(0).setCellEditor(this.mTableColComboEditor);
        this.mTable.getColumnModel().getColumn(0).setCellRenderer(this.mTableColCellRenderer);
    }

    public Color getForegroundColor(Component component, boolean bl) {
        Color color = component.getForeground();
        if (bl) {
            if (component instanceof JTable) {
                color = ((JTable)component).getSelectionForeground();
            } else if (component instanceof JList) {
                color = ((JList)component).getSelectionForeground();
            }
        }
        return color;
    }

    public Color getBackgroundColor(Component component, int n, boolean bl) {
        Color color = component.getBackground();
        if (bl) {
            if (component instanceof JTable) {
                color = ((JTable)component).getSelectionBackground();
            } else if (component instanceof JList) {
                color = ((JList)component).getSelectionBackground();
            }
        } else if (component instanceof ConditionalFormattingTable && ((ConditionalFormattingTable)component).getSelectionModel().getAnchorSelectionIndex() == n) {
            color = ((JTable)component).getSelectionBackground();
        }
        return color;
    }

    protected String truncateStringToColumnWidth(String string, int n) {
        return this.truncateStringToColumnWidth(string, n, 0);
    }

    protected String truncateStringToColumnWidth(String string, int n, int n2) {
        String string2 = string;
        int n3 = this.mTable.getTableHeader().getHeaderRect((int)n).width - 25 - n2;
        Graphics graphics = this.mTable.getTableHeader().getGraphics();
        if (graphics == null) {
            return string;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = fontMetrics.stringWidth(string);
        graphics.dispose();
        string2 = n4 > n3 ? this.truncateStringToWidth(fontMetrics, string, n3 - 2) : string;
        return string2;
    }

    private String truncateStringToWidth(FontMetrics fontMetrics, String string, int n) {
        String string2 = "";
        try {
            int n2 = 0;
            int n3 = 0;
            if (n3 < 3) {
                String string3 = "";
                boolean bl = false;
                do {
                    int n4;
                    if ((n4 = fontMetrics.stringWidth(string3 = string3 + string.charAt(n2++))) > n) {
                        if (string3.length() > 1) {
                            --n2;
                            string3 = string3.substring(0, string3.length() - 1);
                        }
                        bl = true;
                        continue;
                    }
                    if (n2 != string.length()) continue;
                    bl = true;
                } while (!bl);
                string2 = string2 + string3;
            }
            if (n2 < string.length()) {
                string2 = string2.substring(0, string2.length() - 3) + "...";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private boolean enableContinueButton() {
        boolean bl = true;
        if (this.mConditionalFormattingTableModel != null && this.mConditionalFormattingTableModel.getRowDatas() != null && this.mConditionalFormattingTableModel.getRowDatas().size() > 0) {
            ArrayList<RowData> arrayList = this.mConditionalFormattingTableModel.getRowDatas();
            for (RowData rowData : arrayList) {
                if (rowData.getValueType() != ValueType.UserSpecified || rowData.getUserSpecifiedValue().trim().length() != 0) continue;
                bl = false;
                break;
            }
        }
        this.mContinueButton.setEnabled(bl);
        return bl;
    }

    @Override
    public boolean continuePressed() {
        ArrayList<RowData> arrayList = this.mConditionalFormattingTableModel.getRowDatas();
        return super.continuePressed();
    }

    private ValueType findValueTypeGivenString(String string) {
        ValueType valueType = ValueType.UserSpecified;
        for (ValueType valueType2 : ValueType.values()) {
            String string2 = this.getValueTypeStringRepresentation(valueType2);
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            valueType = valueType2;
            break;
        }
        return valueType;
    }

    public void updatePanel() {
        this.createTable();
    }

    protected ConditionalFormattingTableModel getConditionalFormattingTableModel() {
        return (ConditionalFormattingTableModel)((Object)this.mTable.getModel());
    }

    public static String generateSyntax(DialogDataModel dialogDataModel, ConditionalFormatDlgType conditionalFormatDlgType) {
        return TableStyleDlg.generateSyntax(dialogDataModel, conditionalFormatDlgType, null);
    }

    public static String generateSyntax(DialogDataModel dialogDataModel, ConditionalFormatDlgType conditionalFormatDlgType, String[] stringArray) {
        TableStyleData tableStyleData = (TableStyleData)dialogDataModel.getObject(TableStyleDlg.getDialogDataModelKeyName(conditionalFormatDlgType));
        String string = TableStyleDlg.generateSyntax(tableStyleData, stringArray);
        return string;
    }

    public String generateSyntax() {
        String string = null;
        if (this.mConditionalFormattingTableModel != null && this.mConditionalFormattingTableModel.getRowDatas() != null && this.mConditionalFormattingTableModel.getRowDatas().size() > 0) {
            ArrayList<RowData> arrayList = this.mConditionalFormattingTableModel.getRowDatas();
            TableStyleData tableStyleData = new TableStyleData(arrayList, this.mConditionalFormatDlgType != ConditionalFormatDlgType.ModifyDialog, this.mReportCheckbox.isSelected());
            string = TableStyleDlg.generateSyntax(tableStyleData);
        }
        return string;
    }

    public static String generateSyntax(TableStyleData tableStyleData) {
        return TableStyleDlg.generateSyntax(tableStyleData, false, null);
    }

    public static String generateSyntax(TableStyleData tableStyleData, String[] stringArray) {
        return TableStyleDlg.generateSyntax(tableStyleData, false, stringArray);
    }

    public static String generateSyntax(TableStyleData tableStyleData, boolean bl) {
        return TableStyleDlg.generateSyntax(tableStyleData, bl, null);
    }

    public static String generateSyntax(TableStyleData tableStyleData, boolean bl, String[] stringArray) {
        ArrayList<RowData> arrayList;
        StringBuffer stringBuffer = new StringBuffer();
        if (tableStyleData != null && (arrayList = tableStyleData.getRowDatas()) != null && arrayList.size() > 0) {
            if (!bl) {
                stringBuffer.append("\nOUTPUT MODIFY");
            }
            TableStyleDlg.appendReportSyntax(tableStyleData, stringBuffer);
            for (int i = 0; i < arrayList.size(); ++i) {
                RowData rowData = arrayList.get(i);
                TableStyleDlg.appendRowSyntax(stringBuffer, rowData, bl, stringArray);
                if (i + 1 >= arrayList.size()) continue;
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString().length() > 0 ? stringBuffer.toString() : null;
    }

    private static void appendReportSyntax(TableStyleData tableStyleData, StringBuffer stringBuffer) {
        if (tableStyleData.isDoReportSyntax()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/REPORT"));
            stringBuffer.append(" PRINTREPORT=");
            String string = tableStyleData.isReportSelected() ? "YES" : "NO";
            stringBuffer.append(string + "\n");
        }
    }

    private static void appendRowSyntax(StringBuffer stringBuffer, RowData rowData, boolean bl, String[] stringArray) {
        int n;
        if (!bl) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/SELECT TABLES\n"));
            stringBuffer.append(SyntaxUtil.getSubCommand("/IF COMMANDS="));
            if (stringArray == null) {
                stringBuffer.append("[LAST] ");
            } else {
                stringBuffer.append("[");
                for (n = 0; n < stringArray.length; ++n) {
                    if (n > 0) {
                        stringBuffer.append(" ");
                    }
                    String string = stringArray[n];
                    stringBuffer.append(SyntaxUtil.wrapText(string, '\"'));
                    stringBuffer.append("(LAST)");
                }
                stringBuffer.append("] ");
            }
            if (rowData.getTableType() != ModifyOutputEnumManager.TableType.All) {
                stringBuffer.append("SUBTYPES=\"" + ModifyOutputEnumManager.getTableTypeStringRepresentation(rowData.getTableType(), true) + "\"");
            }
        }
        if (!bl) {
            stringBuffer.append("\n");
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/TABLECELLS "));
        if (rowData.getValueType() == ValueType.UserSpecified) {
            stringBuffer.append("SELECT=[\"" + rowData.getUserSpecifiedValue().trim() + "\"]" + " ");
        } else {
            stringBuffer.append("SELECT=[" + TableStyleDlg.getValueTypeSyntaxRepresentation(rowData.getValueType()) + "] ");
        }
        if (rowData.getValueType() != ValueType.AllDataCells) {
            stringBuffer.append("SELECTDIMENSION=" + ModifyOutputEnumManager.getDimensionsTypeStringRepresentation(rowData.getDimensionsType(), true) + " ");
        }
        stringBuffer.append("SELECTCONDITION=" + TableStyleDlg.getConditionDataStringRepresentation(rowData.getConditionData(), true) + " ");
        if (!rowData.getFormatData().isDoFormatting()) {
            stringBuffer.append("REVERTTODEFAULT=YES ");
        } else {
            stringBuffer.append(TableStyleDlg.getBoldItalicUnderlineSyntax(rowData));
            if (rowData.getFormatData().getForegroundColor().getRGB() != Color.BLACK.getRGB()) {
                stringBuffer.append(TableStyleDlg.getRGBText(rowData.getFormatData().getForegroundColor(), "TEXTCOLOR=RGB") + " ");
            }
            if (rowData.getFormatData().getBackgroundColor().getRGB() != Color.WHITE.getRGB()) {
                stringBuffer.append(TableStyleDlg.getRGBText(rowData.getFormatData().getBackgroundColor(), "BACKGROUNDCOLOR=RGB") + " ");
            }
        }
        if (rowData.getFormatData().getFormatStringRepresentation() != null) {
            stringBuffer.append("FORMAT=");
            stringBuffer.append(TableStyleDlg.getFormatSyntax(rowData.getFormatData()) + " ");
        }
        stringBuffer.append("APPLYTO=");
        stringBuffer.append(TableStyleDlg.getApplyToStringRepresentation(rowData.getFormatData().getApplyToType(), true));
        if (rowData.getFormatData().isDoReplaceValue()) {
            stringBuffer.append(" ");
            stringBuffer.append("REPLACE=");
            n = DialogHelper.isValidDouble(rowData.getFormatData().getReplaceText()) ? 1 : 0;
            if (n != 0) {
                stringBuffer.append(rowData.getFormatData().getReplaceText());
            } else {
                stringBuffer.append("\"" + rowData.getFormatData().getReplaceText() + "\"");
            }
        }
    }

    public static String getFormatSyntax(FormatData formatData) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        if (formatData.getFormatOffset() != 0 && (string = formatData.getFormatStringRepresentation()) != null) {
            stringBuffer.append("\"");
            stringBuffer.append(string);
            if (formatData.isFormatSupportsDecimals() && formatData.isDoDecimals()) {
                stringBuffer.append(".");
                stringBuffer.append("" + formatData.getDecimals());
            }
            stringBuffer.append("\"");
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    private static String getBoldItalicUnderlineSyntax(RowData rowData) {
        StringBuffer stringBuffer = new StringBuffer();
        if (rowData.getFormatData().isBold() || rowData.getFormatData().isItalic() || rowData.getFormatData().isUnderline()) {
            stringBuffer.append("STYLE=REGULAR ");
            if (rowData.getFormatData().isBold()) {
                stringBuffer.append("BOLD ");
            }
            if (rowData.getFormatData().isItalic() || rowData.getFormatData().isUnderline()) {
                if (rowData.getFormatData().isItalic()) {
                    stringBuffer.append("ITALIC ");
                }
                if (rowData.getFormatData().isUnderline()) {
                    stringBuffer.append("UNDERLINE ");
                } else {
                    stringBuffer.append(" ");
                }
            } else {
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    private static String getStringForConditionalFormatDlgType(ConditionalFormatDlgType conditionalFormatDlgType) {
        String string = null;
        switch (conditionalFormatDlgType) {
            case BivariateCorrelations: {
                string = "BivariateCorrelations";
                break;
            }
            case CrossTabs: {
                string = "CrossTabs";
                break;
            }
            case CTables: {
                string = "CTables";
                break;
            }
            case Descriptives: {
                string = "Descriptives";
                break;
            }
            case Frequencies: {
                string = "Frequencies";
                break;
            }
            case LogisticRegression: {
                string = "LogisticRegression";
                break;
            }
            case LinearRegression: {
                string = "LinearRegression";
                break;
            }
            case Means: {
                string = "Means";
                break;
            }
            case ModifyDialog: {
                string = "ModifyDialog";
                break;
            }
        }
        return string;
    }

    public String getEnumTypeStringRepresentation(Enum enum_, int n) {
        String string = null;
        if (enum_ instanceof ValueType) {
            RowData rowData;
            string = this.getValueTypeStringRepresentation((ValueType)enum_);
            if (string == null && (rowData = this.mConditionalFormattingTableModel.getRowDataAt(n)) != null) {
                string = rowData.getUserSpecifiedValue();
            }
        } else {
            string = ModifyOutputEnumManager.getEnumTypeStringRepresentation(enum_, false);
        }
        return string;
    }

    private String getValueTypeStringRepresentation(ValueType valueType) {
        return TableStyleDlg.getValueTypeStringRepresentation(valueType, false);
    }

    public static String getValueTypeSyntaxRepresentation(ValueType valueType) {
        return TableStyleDlg.getValueTypeStringRepresentation(valueType, true);
    }

    private static String getStaticResString(String string) {
        return UIToolResUtil.getString((ResourceBundle)mMyResBundle, (String)string);
    }

    private static String getValueTypeStringRepresentation(ValueType valueType, boolean bl) {
        String string = null;
        switch (valueType) {
            case Correlation: {
                string = !bl ? TableStyleDlg.getStaticResString("IDS_VALUE_CORRELATION") : "CORRELATION";
                break;
            }
            case Count: {
                string = !bl ? TableStyleDlg.getStaticResString("IDS_VALUE_COUNT") : "COUNT";
                break;
            }
            case Mean: {
                string = !bl ? TableStyleDlg.getStaticResString("IDS_VALUE_MEAN") : "MEAN";
                break;
            }
            case Median: {
                string = !bl ? TableStyleDlg.getStaticResString("IDS_VALUE_MEDIAN") : "MEDIAN";
                break;
            }
            case Percent: {
                string = !bl ? TableStyleDlg.getStaticResString("IDS_VALUE_PERCENT") : "PERCENT";
                break;
            }
            case Significance: {
                string = !bl ? TableStyleDlg.getStaticResString("IDS_VALUE_SIGNIFICANCE") : "SIGNIFICANCE";
                break;
            }
            case Residuals: {
                string = !bl ? TableStyleDlg.getStaticResString("IDS_VALUE_RESIDUALS") : "RESIDUALS";
                break;
            }
            case AllDataCells: {
                string = !bl ? TableStyleDlg.getStaticResString("IDS_VALUE_All_DATA_CELLS") : "BODY";
                break;
            }
        }
        return string;
    }

    public String getApplyToStringRepresentation(ApplyToType applyToType) {
        return TableStyleDlg.getApplyToStringRepresentation(applyToType, false);
    }

    public static String getApplyToStringRepresentation(ApplyToType applyToType, boolean bl) {
        String string = null;
        switch (applyToType) {
            case CellsOnly: {
                string = !bl ? TableStyleDlg.getStaticResString("IDS_CF_APPLY_TO_CELLS_ONLY") : "CELL";
                break;
            }
            case EntireColumn: {
                string = !bl ? TableStyleDlg.getStaticResString("IDS_CF_APPLY_TO_ENTIRE_COLUMN") : "COLUMN";
                break;
            }
            case EntireRow: {
                string = !bl ? TableStyleDlg.getStaticResString("IDS_CF_APPLY_TO_ENTIRE_ROW") : "ROW";
                break;
            }
        }
        return string;
    }

    public String getFormatHTMLRepresentation(FormatData formatData, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (formatData != null) {
            stringBuffer.append("<html>");
            if (formatData.isDoFormatting()) {
                if (formatData.getBackgroundColor() != null) {
                    stringBuffer.append("<body bgcolor=\"" + TableStyleDlg.getColorValue(formatData.getBackgroundColor()) + "\">");
                }
                if (formatData.getForegroundColor() != null) {
                    stringBuffer.append("<font color=\"" + TableStyleDlg.getColorValue(formatData.getForegroundColor()) + "\">");
                }
                stringBuffer.append("<font size=\"22\">");
                stringBuffer.append("</font>");
                if (formatData.isBold()) {
                    stringBuffer.append("<b>");
                }
                if (formatData.isItalic()) {
                    stringBuffer.append("<i>");
                }
                if (formatData.isUnderline()) {
                    stringBuffer.append("<u>");
                }
            }
            stringBuffer.append(string + " ");
            if (formatData.isDoFormatting()) {
                if (formatData.isUnderline()) {
                    stringBuffer.append("</u>");
                }
                if (formatData.isItalic()) {
                    stringBuffer.append("</i>");
                }
                if (formatData.isBold()) {
                    stringBuffer.append("</bold>");
                }
            }
            stringBuffer.append("</html>");
        }
        return stringBuffer.toString();
    }

    public static String getColorValue(Color color) {
        return "#" + TableStyleDlg.hex(color.getRed()) + TableStyleDlg.hex(color.getGreen()) + TableStyleDlg.hex(color.getBlue());
    }

    public static String hex(int n) {
        String string = Integer.toHexString(n);
        if (n < 16) {
            string = "0" + string;
        }
        return string;
    }

    private String getFormatDisplayText(FormatData formatData) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (formatData != null) {
            if (formatData.isDoFormatting()) {
                if (formatData.isBold()) {
                    stringBuffer.append(this.getResString("IDS_CF_FONT_BOLD") + ", ");
                }
                if (formatData.isItalic()) {
                    stringBuffer.append(this.getResString("IDS_CF_FONT_ITALIC") + ", ");
                }
                if (formatData.isUnderline()) {
                    stringBuffer.append(this.getResString("IDS_CF_FONT_UNDERLINE") + ", ");
                }
                if (formatData.getForegroundColor().getRGB() != Color.BLACK.getRGB()) {
                    stringBuffer.append(TableStyleDlg.getRGBText(formatData.getForegroundColor(), this.getResString("IDS_CF_TEXT")) + ", ");
                }
                if (formatData.getBackgroundColor().getRGB() != Color.WHITE.getRGB()) {
                    stringBuffer.append(TableStyleDlg.getRGBText(formatData.getBackgroundColor(), this.getResString("IDS_CF_BACKGROUND")) + ", ");
                }
                if (formatData.getFormatOffset() != 0) {
                    if (formatData.getFormatStringRepresentation() != null) {
                        string = MessageFormat.format(TableStyleDlg.getStaticResString("IDS_CF_FORMAT"), "" + formatData.getFormatStringRepresentation());
                        stringBuffer.append(string + ", ");
                    }
                    if (formatData.isDoDecimals() && formatData.isFormatSupportsDecimals()) {
                        string = MessageFormat.format(TableStyleDlg.getStaticResString("IDS_CF_DECIMALS"), "" + formatData.getDecimals());
                        stringBuffer.append(string + ", ");
                    }
                }
            }
            if (formatData.isDoReplaceValue()) {
                string = MessageFormat.format(this.getResString("IDS_CF_REPLACE_TEXT"), "" + formatData.getReplaceText());
                stringBuffer.append(string + ", ");
            }
        }
        if ((string = stringBuffer.toString().trim()).length() > 0 && string.charAt(string.length() - 1) == ',') {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() == 0) {
            string = this.getResString("IDS_CF_NO_FORMATTING");
        }
        return string;
    }

    private static String getRGBText(Color color, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("(");
        stringBuffer.append(color.getRed());
        stringBuffer.append(", ");
        stringBuffer.append(color.getGreen());
        stringBuffer.append(", ");
        stringBuffer.append(color.getBlue());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String getConditionDataStringRepresentation(ConditionData conditionData, boolean bl) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string = conditionData.canDoAbsoluteValues() ? TableStyleDlg.getStaticResString("IDS_CONDITION_COL_ABS_NUMBER") : "x";
        if (conditionData.isApplyToAll()) {
            String string3 = bl ? "ALL" : TableStyleDlg.getStaticResString("IDS_CONDITION_COL_ALL");
            stringBuffer.append(string3);
        } else {
            stringBuffer.append("\"");
            switch (conditionData.getConditionType()) {
                case Exactly: {
                    stringBuffer.append(string);
                    stringBuffer.append("=");
                    stringBuffer.append("" + conditionData.getValueOne());
                    break;
                }
                case LessThan: {
                    stringBuffer.append(string);
                    stringBuffer.append("<");
                    stringBuffer.append("" + conditionData.getValueOne());
                    break;
                }
                case LessThanOrEqualTo: {
                    stringBuffer.append(string);
                    stringBuffer.append("<=");
                    stringBuffer.append("" + conditionData.getValueOne());
                    break;
                }
                case GreaterThan: {
                    stringBuffer.append(string);
                    stringBuffer.append(">");
                    stringBuffer.append("" + conditionData.getValueOne());
                    break;
                }
                case GreaterThanOrEqualTo: {
                    stringBuffer.append(string);
                    stringBuffer.append(">=");
                    stringBuffer.append("" + conditionData.getValueOne());
                    break;
                }
                case Between: {
                    stringBuffer.append("" + conditionData.getValueOneTwoMinValue());
                    stringBuffer.append("<");
                    stringBuffer.append("x");
                    stringBuffer.append("<");
                    stringBuffer.append("" + conditionData.getValueOneTwoMaxValue());
                    break;
                }
                case BetweenInclusive: {
                    stringBuffer.append("" + conditionData.getValueOneTwoMinValue());
                    stringBuffer.append("<=");
                    stringBuffer.append("x");
                    stringBuffer.append("<=");
                    stringBuffer.append("" + conditionData.getValueOneTwoMaxValue());
                    break;
                }
                case BetweenHigherInclusive: {
                    stringBuffer.append("" + conditionData.getValueOneTwoMinValue());
                    stringBuffer.append("<");
                    stringBuffer.append("x");
                    stringBuffer.append("<=");
                    stringBuffer.append("" + conditionData.getValueOneTwoMaxValue());
                    break;
                }
                case BetweenLowerInclusive: {
                    stringBuffer.append("" + conditionData.getValueOneTwoMinValue());
                    stringBuffer.append("<=");
                    stringBuffer.append("x");
                    stringBuffer.append("<");
                    stringBuffer.append("" + conditionData.getValueOneTwoMaxValue());
                    break;
                }
                case Top: {
                    String string4 = bl ? "TOP({0})" : TableStyleDlg.getStaticResString("IDS_CONDITION_COL_TOP_N");
                    String string5 = MessageFormat.format(string4, "" + conditionData.getValueNumber());
                    stringBuffer.append(string5);
                    break;
                }
                case Bottom: {
                    String string6 = bl ? "BOTTOM({0})" : TableStyleDlg.getStaticResString("IDS_CONDITION_COL_BOTTOM_N");
                    String string7 = MessageFormat.format(string6, "" + conditionData.getValueNumber());
                    stringBuffer.append(string7);
                    break;
                }
                case Sysmis: {
                    if (!bl) {
                        stringBuffer.append(TableStyleDlg.getStaticResString("IDS_CONDITION_COL_SYSMIS"));
                        break;
                    }
                    stringBuffer.append("SYSMIS");
                    break;
                }
            }
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    public static enum ApplyToType {
        CellsOnly,
        EntireColumn,
        EntireRow;

    }

    public static enum ValueType {
        UserSpecified,
        Correlation,
        Count,
        Mean,
        Median,
        Percent,
        Significance,
        Residuals,
        AllDataCells;

    }

    public static enum ConditionalFormatDlgType {
        BivariateCorrelations,
        CrossTabs,
        CTables,
        Descriptives,
        Frequencies,
        LogisticRegression,
        LinearRegression,
        Means,
        ModifyDialog;

    }

    public static class ConditionData {
        boolean mApplyToAll = true;
        ModifyOutputEnumManager.ConditionType mConditionType = ModifyOutputEnumManager.ConditionType.Exactly;
        double mValueOne = Double.MIN_VALUE;
        double mValueTwo = Double.MIN_VALUE;
        int mValueNumber = Integer.MIN_VALUE;
        boolean mAbsoluteValues = false;
        private boolean mDirty = false;

        public ModifyOutputEnumManager.ConditionType getConditionType() {
            return this.mConditionType;
        }

        public void setApplyToAll(boolean bl) {
            this.mApplyToAll = bl;
        }

        public boolean isApplyToAll() {
            return this.mApplyToAll;
        }

        public void setConditionType(ModifyOutputEnumManager.ConditionType conditionType) {
            this.mConditionType = conditionType;
        }

        public double getValueOneTwoMinValue() {
            return Math.min(this.mValueOne, this.mValueTwo);
        }

        public double getValueOneTwoMaxValue() {
            return Math.max(this.mValueOne, this.mValueTwo);
        }

        public double getValueOne() {
            return this.mValueOne;
        }

        public void setValueOne(double d) {
            this.mValueOne = d;
        }

        public double getValueTwo() {
            return this.mValueTwo;
        }

        public void setValueTwo(double d) {
            this.mValueTwo = d;
        }

        public int getValueNumber() {
            return this.mValueNumber;
        }

        public void setValueNumber(int n) {
            this.mValueNumber = n;
        }

        public boolean isAbsoluteValues() {
            return this.mAbsoluteValues;
        }

        public boolean canDoAbsoluteValues() {
            return ConditionData.conditionTypeSupportsAbsolute(this.mConditionType) && this.mAbsoluteValues;
        }

        public void setAbsoluteValues(boolean bl) {
            this.mAbsoluteValues = bl;
        }

        public static boolean conditionTypeSupportsAbsolute(ModifyOutputEnumManager.ConditionType conditionType) {
            return conditionType == ModifyOutputEnumManager.ConditionType.Sysmis ? false : conditionType == ModifyOutputEnumManager.ConditionType.Exactly || conditionType == ModifyOutputEnumManager.ConditionType.LessThan || conditionType == ModifyOutputEnumManager.ConditionType.LessThanOrEqualTo || conditionType == ModifyOutputEnumManager.ConditionType.GreaterThan || conditionType == ModifyOutputEnumManager.ConditionType.GreaterThanOrEqualTo;
        }

        public static boolean conditionTypeIsBetweenType(ModifyOutputEnumManager.ConditionType conditionType) {
            boolean bl = conditionType == ModifyOutputEnumManager.ConditionType.Between || conditionType == ModifyOutputEnumManager.ConditionType.BetweenInclusive || conditionType == ModifyOutputEnumManager.ConditionType.BetweenHigherInclusive || conditionType == ModifyOutputEnumManager.ConditionType.BetweenLowerInclusive;
            return bl;
        }

        public static boolean conditionTypeNeedsOneValue(ModifyOutputEnumManager.ConditionType conditionType) {
            return conditionType == ModifyOutputEnumManager.ConditionType.Sysmis ? false : conditionType != ModifyOutputEnumManager.ConditionType.Top && conditionType != ModifyOutputEnumManager.ConditionType.Bottom;
        }

        public static boolean conditionTypeNeedsTwoValue(ModifyOutputEnumManager.ConditionType conditionType) {
            return conditionType == ModifyOutputEnumManager.ConditionType.Sysmis ? false : ConditionData.conditionTypeIsBetweenType(conditionType);
        }

        public static boolean conditionTypeNeedsNumberValue(ModifyOutputEnumManager.ConditionType conditionType) {
            return conditionType == ModifyOutputEnumManager.ConditionType.Sysmis ? false : conditionType == ModifyOutputEnumManager.ConditionType.Top || conditionType == ModifyOutputEnumManager.ConditionType.Bottom;
        }

        public void setDirty() {
            this.mDirty = true;
        }

        public boolean isDirty() {
            return this.mDirty;
        }

        public void resetDefaults() {
            this.mApplyToAll = true;
            this.mConditionType = ModifyOutputEnumManager.ConditionType.Exactly;
            this.mValueOne = Double.MIN_VALUE;
            this.mValueTwo = Double.MIN_VALUE;
            this.mValueNumber = Integer.MIN_VALUE;
            this.mAbsoluteValues = false;
            boolean bl = false;
        }
    }

    public static class FormatData {
        boolean mDoFormatting = false;
        boolean mBold = false;
        boolean mItalic = false;
        boolean mUnderline = false;
        boolean mDirty = false;
        Color mForegroundColor = Color.BLACK;
        Color mBackgroundColor = Color.WHITE;
        CellFormatHelper.FormatType mFormatType = CellFormatHelper.FormatType.INVALID;
        int mFormatOffset = 0;
        boolean mAsIsFormat = true;
        int mDecimals = 0;
        boolean doDecimals = false;
        boolean mFormatSupportsDecimals = false;
        ApplyToType mApplyToType = ApplyToType.CellsOnly;
        boolean mDoReplaceValue = false;
        String mReplaceText = "";
        String mFormatStringRepresentation = null;

        public void setDirty() {
            this.mDirty = true;
        }

        public boolean isDirty() {
            return this.mDirty;
        }

        public boolean isBold() {
            return this.mBold;
        }

        public void setBold(boolean bl) {
            this.mBold = bl;
        }

        public boolean isItalic() {
            return this.mItalic;
        }

        public void setItalic(boolean bl) {
            this.mItalic = bl;
        }

        public boolean isUnderline() {
            return this.mUnderline;
        }

        public void setUnderline(boolean bl) {
            this.mUnderline = bl;
        }

        public Color getForegroundColor() {
            return this.mForegroundColor;
        }

        public void setForegroundColor(Color color) {
            this.mForegroundColor = color;
        }

        public Color getBackgroundColor() {
            return this.mBackgroundColor;
        }

        public void setBackgroundColor(Color color) {
            this.mBackgroundColor = color;
        }

        public boolean isDoFormatting() {
            return this.mDoFormatting;
        }

        public void setDoFormatting(boolean bl) {
            this.mDoFormatting = bl;
        }

        public ApplyToType getApplyToType() {
            return this.mApplyToType;
        }

        public void setApplyToType(ApplyToType applyToType) {
            this.mApplyToType = applyToType;
        }

        public boolean isDoDecimals() {
            return this.doDecimals;
        }

        public void setDoDecimals(boolean bl) {
            this.doDecimals = bl;
        }

        public int getDecimals() {
            return this.mDecimals;
        }

        public void setDecimals(int n) {
            this.mDecimals = n;
        }

        public boolean isFormatSupportsDecimals() {
            return this.mFormatSupportsDecimals;
        }

        public void setFormatSupportsDecimals(boolean bl) {
            this.mFormatSupportsDecimals = bl;
        }

        public CellFormatHelper.FormatType getFormatType() {
            return this.mFormatType;
        }

        public boolean isAsIsFormat() {
            return this.mAsIsFormat;
        }

        public void setFormatType(CellFormatHelper.FormatType formatType) {
            this.mFormatType = formatType;
        }

        public int getFormatOffset() {
            return this.mFormatOffset;
        }

        public void setFormatOffset(int n, int n2) {
            this.mFormatOffset = n2;
            this.mAsIsFormat = n == n2;
        }

        public boolean isDoReplaceValue() {
            return this.mDoReplaceValue;
        }

        public void setDoReplaceValue(boolean bl) {
            this.mDoReplaceValue = bl;
        }

        public String getReplaceText() {
            return this.mReplaceText;
        }

        public void setReplaceText(String string) {
            this.mReplaceText = string;
        }

        public void setFormatStringRepersentation(String string) {
            this.mFormatStringRepresentation = string;
        }

        public String getFormatStringRepresentation() {
            return this.mFormatStringRepresentation;
        }

        public void resetDefaults() {
            this.mDoFormatting = false;
            this.mBold = false;
            this.mItalic = false;
            this.mUnderline = false;
            this.mDirty = false;
            this.mForegroundColor = Color.BLACK;
            this.mBackgroundColor = Color.WHITE;
            this.mFormatType = CellFormatHelper.FormatType.INVALID;
            this.mFormatOffset = 0;
            this.mAsIsFormat = true;
            this.mDecimals = 0;
            this.doDecimals = false;
            this.mFormatSupportsDecimals = false;
            this.mApplyToType = ApplyToType.CellsOnly;
            this.mDoReplaceValue = false;
            this.mReplaceText = "";
            this.mFormatStringRepresentation = null;
        }
    }

    public class RowData
    implements Cloneable {
        private ValueType mValueType = ValueType.Significance;
        private boolean mValueTypeDirty = false;
        private String mUserSpecifiedValue = "";
        private ConditionData mConditionData = new ConditionData();
        private FormatData mFormatData = new FormatData();
        private ModifyOutputEnumManager.DimensionsType mDimensionsType = ModifyOutputEnumManager.DimensionsType.Column;
        private ModifyOutputEnumManager.TableType mTableType = ModifyOutputEnumManager.TableType.All;

        private RowData(ModifyOutputEnumManager.TableType tableType, ValueType valueType, ModifyOutputEnumManager.DimensionsType dimensionsType) {
            this.mTableType = tableType;
            this.mDimensionsType = dimensionsType;
            this.mValueType = valueType;
        }

        public ValueType getValueType() {
            return this.mValueType;
        }

        public ConditionData getConditionData() {
            return this.mConditionData;
        }

        public void setConditionData(ConditionData conditionData) {
            this.mConditionData = conditionData;
        }

        public FormatData getFormatData() {
            return this.mFormatData;
        }

        public void setFormatData(FormatData formatData) {
            this.mFormatData = formatData;
        }

        public ModifyOutputEnumManager.DimensionsType getDimensionsType() {
            return this.mDimensionsType;
        }

        public ModifyOutputEnumManager.TableType getTableType() {
            return this.mTableType;
        }

        public void setValueType(ValueType valueType) {
            this.mValueType = valueType;
        }

        public void setValueTypeDirty(boolean bl) {
            this.mValueTypeDirty = bl;
        }

        public boolean isValueTypeDirty() {
            return this.mValueTypeDirty;
        }

        public void setDimensionsType(ModifyOutputEnumManager.DimensionsType dimensionsType) {
            this.mDimensionsType = dimensionsType;
        }

        public void setTableType(ModifyOutputEnumManager.TableType tableType) {
            this.mTableType = tableType;
        }

        public void setConditionFormatDefaultsForValueType(ValueType valueType) {
            switch (valueType) {
                case Correlation: {
                    this.setConditionFormatDefaultsForValueType(ModifyOutputEnumManager.ConditionType.GreaterThanOrEqualTo, true, 0.5, Color.YELLOW);
                    break;
                }
                case Count: {
                    this.setConditionFormatDefaultsForValueType(ModifyOutputEnumManager.ConditionType.LessThanOrEqualTo, 5.0, Color.YELLOW);
                    break;
                }
                case Percent: {
                    this.setConditionFormatDefaultsForValueType(ModifyOutputEnumManager.ConditionType.GreaterThanOrEqualTo, 50.0, Color.YELLOW);
                    break;
                }
                case Significance: {
                    this.setConditionFormatDefaultsForValueType(ModifyOutputEnumManager.ConditionType.LessThanOrEqualTo, 0.05, Color.YELLOW);
                    break;
                }
                case Mean: 
                case Median: 
                case Residuals: 
                case AllDataCells: 
                case UserSpecified: {
                    if (!this.mConditionData.isDirty()) {
                        this.mConditionData.resetDefaults();
                    }
                    if (this.mFormatData.isDirty()) break;
                    this.mFormatData.resetDefaults();
                    break;
                }
            }
        }

        private void setConditionFormatDefaultsForValueType(ModifyOutputEnumManager.ConditionType conditionType, double d, Color color) {
            this.setConditionFormatDefaultsForValueType(conditionType, false, d, color);
        }

        private void setConditionFormatDefaultsForValueType(ModifyOutputEnumManager.ConditionType conditionType, boolean bl, double d, Color color) {
            if (!this.mConditionData.isDirty()) {
                this.mConditionData.setApplyToAll(false);
                this.mConditionData.setConditionType(conditionType);
                this.mConditionData.setValueOne(d);
                this.mConditionData.setAbsoluteValues(bl);
            }
            if (!this.mFormatData.isDirty()) {
                this.mFormatData.setDoFormatting(true);
                this.formatBackgroundColor(color);
            }
        }

        private void formatBackgroundColor(Color color) {
            this.mFormatData.setBackgroundColor(color);
        }

        protected Object clone() throws CloneNotSupportedException {
            RowData rowData = (RowData)super.clone();
            return rowData;
        }

        public String getUserSpecifiedValue() {
            return this.mUserSpecifiedValue;
        }

        public void setUserSpecifiedValue(String string) {
            this.mUserSpecifiedValue = string;
        }
    }

    class TableDefaults {
        ConditionalFormatDlgType mConditionalFormatDlgType;
        ValueType[] mDefaultValues;
        ModifyOutputEnumManager.TableType[] mDefaultTables;
        HashMap<ModifyOutputEnumManager.TableType, ValueType> mTableTypeToDefaultValueType = new HashMap();
        HashMap<ValueType, ModifyOutputEnumManager.DimensionsType> mValueTypeToDefaultDimensionsType = new HashMap();

        public TableDefaults(ConditionalFormatDlgType conditionalFormatDlgType) {
            this.mConditionalFormatDlgType = conditionalFormatDlgType;
            this.setupDefaults();
        }

        public ConditionalFormatDlgType getConditionalFormatDlgType() {
            return this.mConditionalFormatDlgType;
        }

        public ModifyOutputEnumManager.TableType[] getTables() {
            return this.mDefaultTables;
        }

        public ValueType[] getDefaultValues() {
            return this.mDefaultValues;
        }

        public ModifyOutputEnumManager.DimensionsType getDefaultDimensionsTypeForValueType(ValueType valueType) {
            return this.mValueTypeToDefaultDimensionsType.get((Object)valueType);
        }

        public ValueType getDefaultValueForTableType(ModifyOutputEnumManager.TableType tableType) {
            return this.mTableTypeToDefaultValueType.get((Object)tableType);
        }

        private void setupDefaults() {
            switch (this.mConditionalFormatDlgType) {
                case BivariateCorrelations: {
                    this.mDefaultTables = new ModifyOutputEnumManager.TableType[]{ModifyOutputEnumManager.TableType.All, ModifyOutputEnumManager.TableType.Correlations, ModifyOutputEnumManager.TableType.DescriptiveStatistics};
                    this.mDefaultValues = new ValueType[]{ValueType.Correlation, ValueType.Count, ValueType.Mean, ValueType.Significance, ValueType.AllDataCells};
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.Correlations, ValueType.Correlation);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.DescriptiveStatistics, ValueType.Mean);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Correlation, ModifyOutputEnumManager.DimensionsType.Row);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Mean, ModifyOutputEnumManager.DimensionsType.Column);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Significance, ModifyOutputEnumManager.DimensionsType.Row);
                    break;
                }
                case CrossTabs: {
                    this.mDefaultTables = new ModifyOutputEnumManager.TableType[]{ModifyOutputEnumManager.TableType.All, ModifyOutputEnumManager.TableType.Bootstrap, ModifyOutputEnumManager.TableType.CaseProcessingSummary, ModifyOutputEnumManager.TableType.ChiSquareTests, ModifyOutputEnumManager.TableType.Crosstabulation, ModifyOutputEnumManager.TableType.DirectionalMeasures, ModifyOutputEnumManager.TableType.MantelHaenszelCommonOddsRatioEstimate, ModifyOutputEnumManager.TableType.OutputFileSummary, ModifyOutputEnumManager.TableType.RiskEstimate, ModifyOutputEnumManager.TableType.SymmetricMeasures, ModifyOutputEnumManager.TableType.TestsConditionalIndependence, ModifyOutputEnumManager.TableType.TestsHomogeneityOddsRatio, ModifyOutputEnumManager.TableType.ZeroOrderPartialGammas};
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.CaseProcessingSummary, ValueType.Count);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.ChiSquareTests, ValueType.Significance);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.Crosstabulation, ValueType.Count);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.DirectionalMeasures, ValueType.Significance);
                    this.mDefaultValues = new ValueType[]{ValueType.Count, ValueType.Percent, ValueType.Residuals, ValueType.Significance, ValueType.AllDataCells};
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Residuals, ModifyOutputEnumManager.DimensionsType.Row);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Significance, ModifyOutputEnumManager.DimensionsType.Column);
                    break;
                }
                case CTables: {
                    this.mDefaultTables = new ModifyOutputEnumManager.TableType[]{ModifyOutputEnumManager.TableType.All, ModifyOutputEnumManager.TableType.ComparisonsMeans, ModifyOutputEnumManager.TableType.ComparisonsProportions, ModifyOutputEnumManager.TableType.CustomTable, ModifyOutputEnumManager.TableType.PearsonChiSquareTests};
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.ComparisonsMeans, null);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.ComparisonsProportions, null);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.CustomTable, ValueType.Count);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.PearsonChiSquareTests, ValueType.Significance);
                    this.mDefaultValues = new ValueType[]{ValueType.Count, ValueType.Mean, ValueType.Median, ValueType.Percent, ValueType.Significance, ValueType.AllDataCells};
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Count, ModifyOutputEnumManager.DimensionsType.Column);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Mean, ModifyOutputEnumManager.DimensionsType.Column);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Median, ModifyOutputEnumManager.DimensionsType.Column);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Percent, ModifyOutputEnumManager.DimensionsType.Column);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Significance, ModifyOutputEnumManager.DimensionsType.Row);
                    break;
                }
                case Descriptives: {
                    this.mDefaultTables = new ModifyOutputEnumManager.TableType[]{ModifyOutputEnumManager.TableType.All, ModifyOutputEnumManager.TableType.DescriptiveStatistics};
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.DescriptiveStatistics, ValueType.Count);
                    this.mDefaultValues = new ValueType[]{ValueType.Count, ValueType.Mean, ValueType.AllDataCells};
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Count, ModifyOutputEnumManager.DimensionsType.Column);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Mean, ModifyOutputEnumManager.DimensionsType.Column);
                    break;
                }
                case Frequencies: {
                    this.mDefaultTables = new ModifyOutputEnumManager.TableType[]{ModifyOutputEnumManager.TableType.All, ModifyOutputEnumManager.TableType.Frequencies, ModifyOutputEnumManager.TableType.Statistics};
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.Frequencies, ValueType.Count);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.Statistics, ValueType.Count);
                    this.mDefaultValues = new ValueType[]{ValueType.Count, ValueType.Mean, ValueType.Median, ValueType.Percent, ValueType.AllDataCells};
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Percent, ModifyOutputEnumManager.DimensionsType.Column);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Mean, ModifyOutputEnumManager.DimensionsType.Row);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Median, ModifyOutputEnumManager.DimensionsType.Row);
                    break;
                }
                case LogisticRegression: {
                    this.mDefaultTables = new ModifyOutputEnumManager.TableType[]{ModifyOutputEnumManager.TableType.All, ModifyOutputEnumManager.TableType.Bootstrap, ModifyOutputEnumManager.TableType.CaseProcessingSummary, ModifyOutputEnumManager.TableType.CasewiseList, ModifyOutputEnumManager.TableType.CategoricalVariablesCodings, ModifyOutputEnumManager.TableType.ClassificationTable, ModifyOutputEnumManager.TableType.ContingencyTable, ModifyOutputEnumManager.TableType.CorrelationMatrix, ModifyOutputEnumManager.TableType.DependentVariableEncoding, ModifyOutputEnumManager.TableType.HosmerLemeshowTest, ModifyOutputEnumManager.TableType.IterationHistory, ModifyOutputEnumManager.TableType.ModelTermRemoved, ModifyOutputEnumManager.TableType.ModelSummary, ModifyOutputEnumManager.TableType.OmnibusTestsModelCoefficients, ModifyOutputEnumManager.TableType.StepSummary, ModifyOutputEnumManager.TableType.VariablesInTheEquation, ModifyOutputEnumManager.TableType.VariablesNotInTheEquation};
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.CaseProcessingSummary, ValueType.Count);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.CasewiseList, ValueType.Residuals);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.CategoricalVariablesCodings, null);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.ClassificationTable, null);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.ContingencyTable, null);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.CorrelationMatrix, ValueType.Correlation);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.DependentVariableEncoding, null);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.HosmerLemeshowTest, ValueType.Significance);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.IterationHistory, null);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.ModelTermRemoved, null);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.ModelSummary, null);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.OmnibusTestsModelCoefficients, ValueType.Significance);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.StepSummary, null);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.VariablesInTheEquation, ValueType.Significance);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.VariablesNotInTheEquation, ValueType.Significance);
                    this.mDefaultValues = new ValueType[]{ValueType.Correlation, ValueType.Count, ValueType.Residuals, ValueType.Significance, ValueType.AllDataCells};
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Count, ModifyOutputEnumManager.DimensionsType.Column);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Residuals, ModifyOutputEnumManager.DimensionsType.Column);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Significance, ModifyOutputEnumManager.DimensionsType.Column);
                    break;
                }
                case LinearRegression: {
                    this.mDefaultTables = new ModifyOutputEnumManager.TableType[]{ModifyOutputEnumManager.TableType.All, ModifyOutputEnumManager.TableType.ANOVA, ModifyOutputEnumManager.TableType.Bootstrap, ModifyOutputEnumManager.TableType.CasewiseDiagnostics, ModifyOutputEnumManager.TableType.CoefficientCorrelations, ModifyOutputEnumManager.TableType.Coefficients, ModifyOutputEnumManager.TableType.CollinearityDiagnostics, ModifyOutputEnumManager.TableType.Correlations, ModifyOutputEnumManager.TableType.DescriptiveStatistics, ModifyOutputEnumManager.TableType.ExcludedVariables, ModifyOutputEnumManager.TableType.ModelSummary, ModifyOutputEnumManager.TableType.OutlierStatistics, ModifyOutputEnumManager.TableType.ResidualsStatistics, ModifyOutputEnumManager.TableType.SweptCorrelationMatrix, ModifyOutputEnumManager.TableType.VariablesEnteredRemoved};
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.ANOVA, ValueType.Significance);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.CasewiseDiagnostics, ValueType.Residuals);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.CoefficientCorrelations, ValueType.Correlation);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.Coefficients, ValueType.Significance);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.CollinearityDiagnostics, null);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.Correlations, ValueType.Correlation);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.DescriptiveStatistics, ValueType.Mean);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.ExcludedVariables, null);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.ModelSummary, ValueType.Correlation);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.OutlierStatistics, null);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.ResidualsStatistics, ValueType.Mean);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.SweptCorrelationMatrix, null);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.VariablesEnteredRemoved, null);
                    this.mDefaultValues = new ValueType[]{ValueType.Correlation, ValueType.Count, ValueType.Mean, ValueType.Residuals, ValueType.Significance, ValueType.AllDataCells};
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Mean, ModifyOutputEnumManager.DimensionsType.Column);
                    break;
                }
                case Means: {
                    this.mDefaultTables = new ModifyOutputEnumManager.TableType[]{ModifyOutputEnumManager.TableType.All, ModifyOutputEnumManager.TableType.ANOVA, ModifyOutputEnumManager.TableType.CaseProcessingSummary, ModifyOutputEnumManager.TableType.MeasuresAssociation, ModifyOutputEnumManager.TableType.Report};
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.ANOVA, ValueType.Significance);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.CaseProcessingSummary, ValueType.Count);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.MeasuresAssociation, null);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.Report, ValueType.Mean);
                    this.mDefaultValues = new ValueType[]{ValueType.Count, ValueType.Mean, ValueType.Median, ValueType.Percent, ValueType.Significance, ValueType.AllDataCells};
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Mean, ModifyOutputEnumManager.DimensionsType.Row);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Median, ModifyOutputEnumManager.DimensionsType.Row);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Significance, ModifyOutputEnumManager.DimensionsType.Column);
                    break;
                }
                case ModifyDialog: {
                    this.mDefaultTables = new ModifyOutputEnumManager.TableType[]{ModifyOutputEnumManager.TableType.All};
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.Frequencies, ValueType.Count);
                    this.mTableTypeToDefaultValueType.put(ModifyOutputEnumManager.TableType.Statistics, ValueType.Count);
                    this.mDefaultValues = new ValueType[]{ValueType.Correlation, ValueType.Count, ValueType.Mean, ValueType.Median, ValueType.Percent, ValueType.Significance, ValueType.Residuals, ValueType.AllDataCells};
                    break;
                }
            }
        }

        public void modifyDefaultsForTableType(ModifyOutputEnumManager.TableType tableType) {
            ModifyOutputEnumManager.DimensionsType dimensionsType = null;
            switch (this.mConditionalFormatDlgType) {
                case BivariateCorrelations: {
                    if (tableType == ModifyOutputEnumManager.TableType.All) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Both;
                    } else if (tableType == ModifyOutputEnumManager.TableType.Correlations) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Row;
                    } else if (tableType == ModifyOutputEnumManager.TableType.DescriptiveStatistics) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Column;
                    }
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Count, dimensionsType);
                    break;
                }
                case CrossTabs: {
                    if (tableType == ModifyOutputEnumManager.TableType.All) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Both;
                    } else if (tableType == ModifyOutputEnumManager.TableType.CaseProcessingSummary) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Column;
                    } else if (tableType == ModifyOutputEnumManager.TableType.Crosstabulation) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Row;
                    }
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Count, dimensionsType);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Percent, dimensionsType);
                    break;
                }
                case Frequencies: {
                    if (tableType == ModifyOutputEnumManager.TableType.Frequencies) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Column;
                    } else if (tableType == ModifyOutputEnumManager.TableType.Statistics) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Row;
                    }
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Count, dimensionsType);
                    break;
                }
                case LinearRegression: {
                    if (tableType == ModifyOutputEnumManager.TableType.Coefficients || tableType == ModifyOutputEnumManager.TableType.ModelSummary) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Column;
                    } else if (tableType == ModifyOutputEnumManager.TableType.CoefficientCorrelations || tableType == ModifyOutputEnumManager.TableType.Correlations) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Row;
                    }
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Correlation, dimensionsType);
                    if (tableType == ModifyOutputEnumManager.TableType.CasewiseDiagnostics) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Column;
                    } else if (tableType == ModifyOutputEnumManager.TableType.ANOVA || tableType == ModifyOutputEnumManager.TableType.ResidualsStatistics) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Row;
                    }
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Residuals, dimensionsType);
                    if (tableType == ModifyOutputEnumManager.TableType.Coefficients || tableType == ModifyOutputEnumManager.TableType.ModelSummary) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Column;
                    } else if (tableType == ModifyOutputEnumManager.TableType.ANOVA || tableType == ModifyOutputEnumManager.TableType.Correlations) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Row;
                    }
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Significance, dimensionsType);
                    if (tableType == ModifyOutputEnumManager.TableType.DescriptiveStatistics) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Column;
                    } else if (tableType == ModifyOutputEnumManager.TableType.Correlations) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Row;
                    }
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Count, dimensionsType);
                    break;
                }
                case Means: {
                    if (tableType == ModifyOutputEnumManager.TableType.All) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Both;
                    } else if (tableType == ModifyOutputEnumManager.TableType.CaseProcessingSummary) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Column;
                    } else if (tableType == ModifyOutputEnumManager.TableType.Report) {
                        dimensionsType = ModifyOutputEnumManager.DimensionsType.Row;
                    }
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Count, dimensionsType);
                    this.mValueTypeToDefaultDimensionsType.put(ValueType.Percent, dimensionsType);
                }
            }
        }
    }

    class TableColComboEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox mCombo = new JComboBox();

        TableColComboEditor() {
            for (ModifyOutputEnumManager.TableType tableType : TableStyleDlg.this.mTableDefaults.getTables()) {
                this.mCombo.addItem(tableType);
            }
            this.mCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = TableStyleDlg.this.mTable.getEditingRow();
                    ModifyOutputEnumManager.TableType tableType = (ModifyOutputEnumManager.TableType)((Object)((JComboBox)actionEvent.getSource()).getSelectedItem());
                    TableStyleDlg.this.mTable.setTableTypeForRow(n, tableType);
                }
            });
            this.mCombo.setEditable(false);
            this.mCombo.setRenderer(TableStyleDlg.this.mTableListRenderer);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object != null && object.toString().length() == 0) {
                object = null;
            }
            TableStyleDlg.this.mInRender = true;
            this.mCombo.setSelectedItem(object);
            TableStyleDlg.this.mInRender = false;
            return this.mCombo;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mCombo.getSelectedItem();
        }
    }

    class DimensionsColComboEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox mCombo = new JComboBox();

        DimensionsColComboEditor() {
            for (ModifyOutputEnumManager.DimensionsType dimensionsType : ModifyOutputEnumManager.DimensionsType.values()) {
                this.mCombo.addItem(dimensionsType);
            }
            this.mCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = TableStyleDlg.this.mTable.getEditingRow();
                    ModifyOutputEnumManager.DimensionsType dimensionsType = (ModifyOutputEnumManager.DimensionsType)((Object)((JComboBox)actionEvent.getSource()).getSelectedItem());
                    TableStyleDlg.this.mTable.setDimenstionTypeForRow(n, dimensionsType);
                }
            });
            this.mCombo.setEditable(false);
            this.mCombo.setRenderer(TableStyleDlg.this.mDimensionsListRenderer);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            TableStyleDlg.this.mInRender = true;
            this.mCombo.setSelectedItem(object);
            TableStyleDlg.this.mInRender = false;
            return this.mCombo;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mCombo.getSelectedItem();
        }
    }

    class ValueColComboEditor
    extends DefaultCellEditor {
        ValueColComboEditor(JComboBox jComboBox) {
            super(jComboBox);
            TableStyleDlg.this.mValuesCombo.removeAllItems();
            for (ValueType valueType : TableStyleDlg.this.mTableDefaults.getDefaultValues()) {
                TableStyleDlg.this.mValuesCombo.addItem(valueType);
            }
            JTextComponent jTextComponent = (JTextComponent)TableStyleDlg.this.mValuesCombo.getEditor().getEditorComponent();
            jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    ValueColComboEditor.this.processEditableComboTextChange();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    ValueColComboEditor.this.processEditableComboTextChange();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    ValueColComboEditor.this.processEditableComboTextChange();
                }
            });
            TableStyleDlg.this.mValuesCombo.setEditable(true);
            TableStyleDlg.this.mValuesCombo.setRenderer(TableStyleDlg.this.mValueListRenderer);
        }

        private void processEditableComboTextChange() {
            if (!TableStyleDlg.this.mInRender) {
                int n = TableStyleDlg.this.mTable.getEditingRow();
                JTextComponent jTextComponent = (JTextComponent)TableStyleDlg.this.mValuesCombo.getEditor().getEditorComponent();
                if (jTextComponent != null) {
                    String string = jTextComponent.getText();
                    ValueType valueType = TableStyleDlg.this.findValueTypeGivenString(string);
                    if (valueType == ValueType.UserSpecified) {
                        TableStyleDlg.this.mTable.setUserSpecifiedValueTypeForRow(n, string);
                    } else {
                        TableStyleDlg.this.mTable.setValueTypeForRow(n, valueType);
                    }
                }
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (bl) {
                TableStyleDlg.this.mValuesCombo.setForeground(jTable.getSelectionForeground());
                TableStyleDlg.this.mValuesCombo.setBackground(jTable.getSelectionBackground());
            } else {
                TableStyleDlg.this.mValuesCombo.setForeground(jTable.getForeground());
                TableStyleDlg.this.mValuesCombo.setBackground(jTable.getBackground());
            }
            TableStyleDlg.this.mInRender = true;
            RowData rowData = ((ConditionalFormattingTable)jTable).getRowDataAt(n);
            JTextComponent jTextComponent = (JTextComponent)TableStyleDlg.this.mValuesCombo.getEditor().getEditorComponent();
            if (jTextComponent != null && rowData != null && object instanceof ValueType) {
                if ((ValueType)((Object)object) == ValueType.UserSpecified) {
                    jTextComponent.setText(TableStyleDlg.this.mTable.getUserSpecifiedValueTextForRow(n));
                } else {
                    jTextComponent.setText(TableStyleDlg.this.getValueTypeStringRepresentation((ValueType)((Object)object)));
                }
            }
            TableStyleDlg.this.mInRender = false;
            return TableStyleDlg.this.mValuesCombo;
        }

        @Override
        public Object getCellEditorValue() {
            return TableStyleDlg.this.mValuesCombo.getSelectedItem();
        }
    }

    class ComboActionListener
    implements ActionListener {
        ComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TableStyleDlg.this.mInRender) {
                int n = TableStyleDlg.this.mTable.getEditingRow();
            }
        }
    }

    class ConditionColCellRenderer
    extends DefaultTableCellRenderer
    implements ListCellRenderer,
    TableCellRenderer {
        ConditionColCellRenderer() {
        }

        private void prepTableCellRenderer(Component component, ConditionData conditionData, int n, boolean bl) {
            String string = null;
            if (conditionData != null) {
                string = TableStyleDlg.getConditionDataStringRepresentation(conditionData, false);
            }
            if (string != null) {
                this.setText(string);
                this.getAccessibleContext().setAccessibleDescription(string);
                this.getAccessibleContext().setAccessibleName(string);
            }
            this.setOpaque(true);
            Color color = TableStyleDlg.this.getForegroundColor(component, bl);
            Color color2 = TableStyleDlg.this.getBackgroundColor(component, n, bl);
            this.setForeground(color);
            this.setBackground(color2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.prepTableCellRenderer(jTable, (ConditionData)object, n, bl);
            return this;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.prepTableCellRenderer(jList, (ConditionData)object, -1, bl);
            return this;
        }
    }

    class FormatColCellRenderer
    extends JLabel
    implements TableCellRenderer {
        FormatColCellRenderer() {
        }

        private void prepTableCellRenderer(Component component, FormatData formatData, int n, boolean bl) {
            String string = TableStyleDlg.this.truncateStringToColumnWidth(TableStyleDlg.this.getFormatDisplayText(formatData), 4);
            String string2 = TableStyleDlg.this.getFormatHTMLRepresentation(formatData, string);
            this.setText(string2);
            this.setOpaque(true);
            Color color = TableStyleDlg.this.getForegroundColor(component, bl);
            Color color2 = TableStyleDlg.this.getBackgroundColor(component, n, bl);
            this.setForeground(color);
            this.setBackground(color2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.prepTableCellRenderer(jTable, (FormatData)object, n, bl);
            return this;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.prepTableCellRenderer(jList, (FormatData)object, -1, bl);
            return this;
        }
    }

    class FormatButtonListener
    implements IButtonEditListener {
        FormatButtonListener() {
        }

        @Override
        public void buttonPressed(long l, int n) {
            TableStyleDlg.this.mTable.getCellEditor().stopCellEditing();
            TableStyleFormatDlg tableStyleFormatDlg = new TableStyleFormatDlg(TableStyleDlg.this, TableStyleDlg.this.mTable.getFormatDataForRow((int)l));
            tableStyleFormatDlg.setVisible(true);
            if (tableStyleFormatDlg.wasContinuePressed()) {
                FormatData formatData = tableStyleFormatDlg.getFormatData();
                formatData.setDirty();
                TableStyleDlg.this.mTable.setFormatDataForRow((int)l, formatData);
            }
        }
    }

    class ConditionButtonListener
    implements IButtonEditListener {
        ConditionButtonListener() {
        }

        @Override
        public void buttonPressed(long l, int n) {
            ValueType valueType = TableStyleDlg.this.mTable.getValueTypeForRow((int)l);
            String string = TableStyleDlg.this.getEnumTypeStringRepresentation(valueType, (int)l);
            TableStyleDlg.this.mTable.getCellEditor().stopCellEditing();
            TableStyleConditionDlg tableStyleConditionDlg = new TableStyleConditionDlg(TableStyleDlg.this, TableStyleDlg.this.mTable.getConditionalDataForRow((int)l), string);
            tableStyleConditionDlg.setVisible(true);
            if (tableStyleConditionDlg.wasContinuePressed()) {
                ConditionData conditionData = tableStyleConditionDlg.getConditionData();
                conditionData.setDirty();
                TableStyleDlg.this.mTable.setConditionDataForRow((int)l, conditionData);
            }
        }
    }

    private class MyButtonEditCtrl
    extends ButtonEditCtrl {
        private MyButtonEditCtrl(int n) {
            super(n, true);
        }

        @Override
        protected String getTextForValue(Object object) {
            String string = super.getTextForValue(object);
            if (object != null) {
                if (this.getColumn() == 3) {
                    string = TableStyleDlg.getConditionDataStringRepresentation((ConditionData)object, false);
                } else if (this.getColumn() == 4) {
                    String string2 = TableStyleDlg.this.truncateStringToColumnWidth(TableStyleDlg.this.getFormatDisplayText((FormatData)object), 4, this.mButton.getWidth());
                    string = TableStyleDlg.this.getFormatHTMLRepresentation((FormatData)object, string2);
                }
            }
            return string;
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", TableStyleDlg.this.getResString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("OK HIT");
            TableStyleDlg.this.dispose();
        }
    }

    private class ConditionalFormattingTableModel
    extends AbstractListTableModel {
        private ArrayList<RowData> mRowData = new ArrayList();

        public ConditionalFormattingTableModel(ArrayList<RowData> arrayList) {
            if (arrayList != null) {
                this.mRowData = arrayList;
            }
            this.setList(this.mRowData);
            TableStyleDlg.this.initTableColumnNames();
        }

        protected String[] createDefaultColumnNames() {
            return TableStyleDlg.this.mTableColNames.toArray(new String[TableStyleDlg.this.mTableColNames.size()]);
        }

        protected Object createDefaultEntry() {
            RowData rowData = new RowData(ModifyOutputEnumManager.TableType.All, ValueType.UserSpecified, ModifyOutputEnumManager.DimensionsType.Column);
            return rowData;
        }

        public int getColumnCount() {
            return TableStyleDlg.this.mTableColNames != null ? TableStyleDlg.this.mTableColNames.size() : 0;
        }

        public int getRowCount() {
            return this.mRowData != null ? this.mRowData.size() : 0;
        }

        public String getColumnName(int n) {
            return (String)TableStyleDlg.this.mTableColNames.get(n);
        }

        public ArrayList<RowData> getRowDatas() {
            return this.mRowData;
        }

        public boolean isCellEditable(int n, int n2) {
            switch (n2) {
                case 2: {
                    boolean bl = false;
                    RowData rowData = TableStyleDlg.this.mConditionalFormattingTableModel.getRowDataAt(n);
                    if (rowData != null) {
                        bl = rowData.getValueType() != ValueType.AllDataCells;
                    }
                    return bl;
                }
                case 0: {
                    return TableStyleDlg.this.mConditionalFormatDlgType != ConditionalFormatDlgType.ModifyDialog;
                }
                case 1: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            RowData rowData;
            if (n2 == 0) {
                if (object instanceof ModifyOutputEnumManager.TableType) {
                    ValueType valueType;
                    ModifyOutputEnumManager.TableType tableType = (ModifyOutputEnumManager.TableType)((Object)object);
                    RowData rowData2 = this.getRowDataAt(n);
                    TableStyleDlg.this.mTableDefaults.modifyDefaultsForTableType(tableType);
                    if (rowData2 != null && (valueType = TableStyleDlg.this.mTableDefaults.getDefaultValueForTableType(tableType)) != null) {
                        rowData2.setValueType(valueType);
                        rowData2.setConditionFormatDefaultsForValueType(valueType);
                        ModifyOutputEnumManager.DimensionsType dimensionsType = TableStyleDlg.this.mTableDefaults.getDefaultDimensionsTypeForValueType(valueType);
                        dimensionsType = dimensionsType != null ? dimensionsType : ModifyOutputEnumManager.DimensionsType.Column;
                        rowData2.setDimensionsType(dimensionsType);
                        this.fireTableRowsUpdated(n, n);
                    }
                }
            } else if (n2 == 1 && (rowData = this.getRowDataAt(n)) != null && object instanceof ValueType) {
                ValueType valueType = (ValueType)((Object)object);
                rowData.setValueType(valueType);
                rowData.setConditionFormatDefaultsForValueType(valueType);
                ModifyOutputEnumManager.DimensionsType dimensionsType = TableStyleDlg.this.mTableDefaults.getDefaultDimensionsTypeForValueType(valueType);
                dimensionsType = dimensionsType != null ? dimensionsType : ModifyOutputEnumManager.DimensionsType.Column;
                rowData.setDimensionsType(dimensionsType);
                this.fireTableRowsUpdated(n, n);
            }
            TableStyleDlg.this.enableContinueButton();
        }

        public Object getValueAt(int n, int n2) {
            Object object = "";
            RowData rowData = this.getRowDataAt(n);
            if (rowData != null) {
                switch (n2) {
                    case 1: {
                        object = rowData.getValueType();
                        break;
                    }
                    case 3: {
                        object = rowData.getConditionData();
                        break;
                    }
                    case 4: {
                        object = rowData.getFormatData();
                        break;
                    }
                    case 2: {
                        object = rowData.getDimensionsType();
                        break;
                    }
                    case 0: {
                        object = rowData.getTableType();
                    }
                }
            }
            return object;
        }

        private void readDisplayPrefs() {
        }

        public ValueType getValueForRow(int n) {
            ValueType valueType = null;
            RowData rowData = this.getRowDataAt(n);
            if (rowData != null) {
                valueType = rowData.getValueType();
            }
            return valueType;
        }

        public ModifyOutputEnumManager.DimensionsType getDimensionsForRow(int n) {
            ModifyOutputEnumManager.DimensionsType dimensionsType = null;
            RowData rowData = this.getRowDataAt(n);
            if (rowData != null) {
                dimensionsType = rowData.getDimensionsType();
            }
            return dimensionsType;
        }

        public ModifyOutputEnumManager.TableType getTableTypeForRow(int n) {
            ModifyOutputEnumManager.TableType tableType = null;
            RowData rowData = this.getRowDataAt(n);
            if (rowData != null) {
                tableType = rowData.getTableType();
            }
            return tableType;
        }

        public ConditionData getConditionDataForRow(int n) {
            ConditionData conditionData = null;
            RowData rowData = this.getRowDataAt(n);
            if (rowData != null) {
                conditionData = rowData.getConditionData();
            }
            return conditionData;
        }

        public void setConditionDataForRow(int n, ConditionData conditionData) {
            RowData rowData = this.getRowDataAt(n);
            rowData.setConditionData(conditionData);
            this.fireTableRowsUpdated(n, n);
        }

        public FormatData getFormatDataForRow(int n) {
            FormatData formatData = null;
            RowData rowData = this.getRowDataAt(n);
            if (rowData != null) {
                formatData = rowData.getFormatData();
            }
            return formatData;
        }

        public void setFormatDataForRow(int n, FormatData formatData) {
            RowData rowData = this.getRowDataAt(n);
            rowData.setFormatData(formatData);
            this.fireTableRowsUpdated(n, n);
        }

        public void copyRow(int n) {
            try {
                RowData rowData = (RowData)this.mRowData.get(n).clone();
                this.mRowData.add(rowData);
                this.fireTableRowsInserted(this.mRowData.size() - 1, this.mRowData.size() - 1);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }

        public String getUserSpecifiedValueTextForRow(int n) {
            String string = "";
            RowData rowData = this.getRowDataAt(n);
            if (rowData != null) {
                string = rowData.getUserSpecifiedValue();
            }
            return string;
        }

        public void setUserSpecifiedValueTypeForRow(int n, String string) {
            RowData rowData = this.getRowDataAt(n);
            if (rowData != null) {
                rowData.setValueType(ValueType.UserSpecified);
                rowData.setUserSpecifiedValue(string);
            }
        }

        public void setValueTypeForRow(int n, ValueType valueType) {
            RowData rowData = this.getRowDataAt(n);
            if (rowData != null) {
                rowData.setValueType(valueType);
            }
        }

        public void setDimensionTypeForRow(int n, ModifyOutputEnumManager.DimensionsType dimensionsType) {
            RowData rowData = this.getRowDataAt(n);
            if (rowData != null) {
                rowData.setDimensionsType(dimensionsType);
            }
        }

        public void setTableTypeForRow(int n, ModifyOutputEnumManager.TableType tableType) {
            RowData rowData = this.getRowDataAt(n);
            if (rowData != null) {
                rowData.setTableType(tableType);
            }
        }

        private RowData getRowDataAt(int n) {
            RowData rowData = null;
            if (this.mRowData != null && n >= 0 && n < this.mRowData.size()) {
                rowData = this.mRowData.get(n);
            }
            return rowData;
        }
    }

    private class ConditionalFormattingTable
    extends JTable {
        private ConditionalFormattingTable() {
        }

        public ConditionalFormattingTable(ConditionalFormattingTableModel conditionalFormattingTableModel) {
            super((TableModel)((Object)conditionalFormattingTableModel));
            this.updateListeners();
        }

        private void updateListeners() {
            this.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    int n;
                    if (tableModelEvent.getType() == 1 && (n = tableModelEvent.getFirstRow()) >= 0 && n < ConditionalFormattingTable.this.getModel().getRowCount()) {
                        TableStyleDlg.this.selectRow(n);
                    }
                    TableStyleDlg.this.enableContinueButton();
                }
            });
        }

        @Override
        public void setModel(TableModel tableModel) {
            super.setModel(tableModel);
            this.updateListeners();
        }

        protected void initSelectionListener() {
            if (this.getSelectionModel() != null) {
                this.getSelectionModel().addListSelectionListener(this);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.processControlStates();
            this.repaint();
        }

        public void processControlStates() {
            int[] nArray = this.getSelectedRows();
            boolean bl = nArray.length > 0;
            TableStyleDlg.this.mCopyButton.setEnabled(bl);
            TableStyleDlg.this.mDeleteButton.setEnabled(bl);
        }

        @Override
        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            if (!super.editCellAt(n, n2, eventObject)) {
                return false;
            }
            Component component = this.getEditorComponent();
            component.requestFocusInWindow();
            if (component.getClass() == JComboBox.class) {
                final ComboBoxEditor comboBoxEditor = ((JComboBox)component).getEditor();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((JTextField)comboBoxEditor.getEditorComponent()).selectAll();
                    }
                });
            }
            return true;
        }

        public ValueType getValueTypeForRow(int n) {
            return TableStyleDlg.this.getConditionalFormattingTableModel().getValueForRow(n);
        }

        public ModifyOutputEnumManager.DimensionsType getDimensionTypeForRow(int n) {
            return TableStyleDlg.this.getConditionalFormattingTableModel().getDimensionsForRow(n);
        }

        public ModifyOutputEnumManager.TableType getTableTypeForRow(int n) {
            return TableStyleDlg.this.getConditionalFormattingTableModel().getTableTypeForRow(n);
        }

        public ConditionData getConditionalDataForRow(int n) {
            return TableStyleDlg.this.getConditionalFormattingTableModel().getConditionDataForRow(n);
        }

        public void setConditionDataForRow(int n, ConditionData conditionData) {
            TableStyleDlg.this.getConditionalFormattingTableModel().setConditionDataForRow(n, conditionData);
        }

        public FormatData getFormatDataForRow(int n) {
            return TableStyleDlg.this.getConditionalFormattingTableModel().getFormatDataForRow(n);
        }

        public void setFormatDataForRow(int n, FormatData formatData) {
            TableStyleDlg.this.getConditionalFormattingTableModel().setFormatDataForRow(n, formatData);
        }

        public void copyRow(int n) {
            TableStyleDlg.this.getConditionalFormattingTableModel().copyRow(n);
        }

        public void setUserSpecifiedValueTypeForRow(int n, String string) {
            TableStyleDlg.this.getConditionalFormattingTableModel().setUserSpecifiedValueTypeForRow(n, string);
        }

        public String getUserSpecifiedValueTextForRow(int n) {
            return TableStyleDlg.this.getConditionalFormattingTableModel().getUserSpecifiedValueTextForRow(n);
        }

        public void setValueTypeForRow(int n, ValueType valueType) {
            TableStyleDlg.this.getConditionalFormattingTableModel().setValueTypeForRow(n, valueType);
        }

        public void setDimenstionTypeForRow(int n, ModifyOutputEnumManager.DimensionsType dimensionsType) {
            TableStyleDlg.this.getConditionalFormattingTableModel().setDimensionTypeForRow(n, dimensionsType);
        }

        public void setTableTypeForRow(int n, ModifyOutputEnumManager.TableType tableType) {
            TableStyleDlg.this.getConditionalFormattingTableModel().setTableTypeForRow(n, tableType);
        }

        public RowData getRowDataAt(int n) {
            return TableStyleDlg.this.getConditionalFormattingTableModel().getRowDataAt(n);
        }
    }

    private class DimensionRenderer
    extends MyEnumTableCellRenderer {
        private DimensionRenderer() {
        }

        @Override
        protected boolean canEnableRenderer(int n) {
            boolean bl = false;
            RowData rowData = TableStyleDlg.this.mConditionalFormattingTableModel.getRowDataAt(n);
            if (rowData != null) {
                bl = rowData.getValueType() != ValueType.AllDataCells;
            }
            return bl;
        }
    }

    public class MyEnumTableCellRenderer
    extends EnumTableCellRenderer {
        @Override
        public String getEnumTypeStringRepresentation(Enum enum_, int n) {
            return TableStyleDlg.this.getEnumTypeStringRepresentation(enum_, n);
        }
    }

    public class MyEnumListRenderer
    extends EnumListRenderer {
        @Override
        public String getEnumTypeStringRepresentation(Enum enum_, int n) {
            return TableStyleDlg.this.getEnumTypeStringRepresentation(enum_, n);
        }
    }

    public class TableStyleData {
        boolean doReportSyntax = false;
        boolean isReportSelected;
        ArrayList<RowData> rowDatas;

        public TableStyleData(ArrayList<RowData> arrayList, boolean bl, boolean bl2) {
            this.isReportSelected = bl2;
            this.doReportSyntax = bl;
            this.rowDatas = arrayList;
        }

        public boolean isReportSelected() {
            return this.isReportSelected;
        }

        public ArrayList<RowData> getRowDatas() {
            return this.rowDatas;
        }

        public boolean isDoReportSyntax() {
            return this.doReportSyntax;
        }
    }
}

