/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.post_processing_output;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.post_processing_output.DialogHelper;
import com.spss.java_client.ui.dialogs.post_processing_output.EnumListRenderer;
import com.spss.java_client.ui.dialogs.post_processing_output.ModifyOutputEnumManager;
import com.spss.java_client.ui.dialogs.post_processing_output.TableStyleDlg;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.FocusableLabel;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.SPSSTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TableStyleConditionDlg
extends BaseSubDialog
implements ItemListener {
    private TableStyleDlg mParent;
    private TableStyleDlg.ConditionData mOldConditionData;
    private TableStyleDlg.ConditionData mNewConditionData = new TableStyleDlg.ConditionData();
    String mValueTypeText;
    JLabel mValueOneLabel;
    JLabel mValueTwoLabel;
    JLabel mValueNumberLabel;
    FloatTextField mValueOneEdit;
    FloatTextField mValueTwoEdit;
    IntTextField mValueNumberEdit;
    private SpssButtonGroup mRadioButtonGroup;
    JRadioButton mAppyToAllRB;
    JRadioButton mBasedOnTheFollowingRB;
    private JCheckBox mAbsoluteValueCheckBox;
    private ConditionsComboBox mConditionTypesComboBox;
    private JLabel mConditionTypesComboBoxLabel;

    public TableStyleConditionDlg(TableStyleDlg tableStyleDlg, TableStyleDlg.ConditionData conditionData, String string) {
        super(tableStyleDlg.getBaseProcedureDialog(), "", true);
        this.mParent = tableStyleDlg;
        this.mOldConditionData = conditionData;
        this.mValueTypeText = string != null ? string : "";
        this.setTitle(this.mParent.getResString("IDS_CF_CONDITION_DLG_TITLE"));
        this.initMyPanel();
        this.setDefaults(this.mOldConditionData);
        this.enableControls();
    }

    private void setDefaults(TableStyleDlg.ConditionData conditionData) {
        this.mConditionTypesComboBox.setSelectedItem((Object)conditionData.getConditionType());
        this.mAbsoluteValueCheckBox.setSelected(conditionData.isAbsoluteValues());
        String string = conditionData.getValueOne() == Double.MIN_VALUE ? "" : "" + conditionData.getValueOne();
        this.mValueOneEdit.setText(string);
        string = conditionData.getValueTwo() == Double.MIN_VALUE ? "" : "" + conditionData.getValueTwo();
        this.mValueTwoEdit.setText(string);
        string = conditionData.getValueNumber() == Integer.MIN_VALUE ? "" : "" + conditionData.getValueNumber();
        this.mValueNumberEdit.setText(string);
        this.mAppyToAllRB.setSelected(conditionData.isApplyToAll());
        this.mBasedOnTheFollowingRB.setSelected(!conditionData.isApplyToAll());
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadSizeAndLocationState();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public boolean canEnableContinue() {
        ModifyOutputEnumManager.ConditionType conditionType = (ModifyOutputEnumManager.ConditionType)((Object)this.mConditionTypesComboBox.getSelectedItem());
        boolean bl = TableStyleDlg.ConditionData.conditionTypeNeedsOneValue(conditionType) && this.mValueOneEdit.getText() != null;
        boolean bl2 = TableStyleDlg.ConditionData.conditionTypeNeedsTwoValue(conditionType) && this.mValueTwoEdit.getText() != null;
        boolean bl3 = TableStyleDlg.ConditionData.conditionTypeNeedsNumberValue(conditionType) && this.mValueNumberEdit.getText() != null;
        return bl && bl2 && bl3;
    }

    @Override
    public boolean continuePressed() {
        long l;
        Double d;
        this.mNewConditionData.setApplyToAll(this.mAppyToAllRB.isSelected());
        ModifyOutputEnumManager.ConditionType conditionType = (ModifyOutputEnumManager.ConditionType)((Object)this.mConditionTypesComboBox.getSelectedItem());
        this.mNewConditionData.setConditionType(conditionType);
        if (this.mValueOneEdit.getText() != null && this.mValueOneEdit.getText().length() > 0) {
            d = Double.parseDouble(this.mValueOneEdit.getText());
            this.mNewConditionData.setValueOne(d);
        }
        if (this.mValueTwoEdit.getText() != null && this.mValueTwoEdit.getText().length() > 0) {
            d = Double.parseDouble(this.mValueTwoEdit.getText());
            this.mNewConditionData.setValueTwo(d);
        }
        if (this.mValueNumberEdit.getText() != null && this.mValueNumberEdit.getText().length() > 0) {
            Integer n = Integer.parseInt(this.mValueNumberEdit.getText());
            this.mNewConditionData.setValueNumber(n);
        }
        this.mNewConditionData.setAbsoluteValues(this.mAbsoluteValueCheckBox.isSelected());
        boolean bl = true;
        if (TableStyleDlg.ConditionData.conditionTypeNeedsNumberValue(conditionType) && (l = Long.parseLong(this.mValueNumberEdit.getText())) == 0L) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), this.mParent.getResString("IDS_CF_NUMBER_MUST_BE_GREATER_ZERO"), "");
            bl = false;
            this.mValueNumberEdit.requestFocusInWindow();
        }
        return bl;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_modify_output_table_style_condition";
    }

    protected void initMyPanel() {
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.createMainPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n, n);
        int n2 = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n2, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel3 = new JPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 2, 1, n2, new Insets(0, 0, 0, 0));
        this.pack();
    }

    private void initVars() {
        this.mAppyToAllRB = DialogUtil.createRadioButton(this.mParent, "IDS_CF_CONDITION_TO_ALL_VALUES_OF_THIS_TYPE", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableStyleConditionDlg.this.enableControls();
            }
        });
        this.mBasedOnTheFollowingRB = DialogUtil.createRadioButton(this.mParent, "IDS_CF_CONDITION_BASED_ON_THE_FOLLOWING_CONDITIONS", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableStyleConditionDlg.this.enableControls();
            }
        });
        this.mRadioButtonGroup = new SpssButtonGroup();
        this.mRadioButtonGroup.add(this.mAppyToAllRB);
        this.mRadioButtonGroup.add(this.mBasedOnTheFollowingRB);
        this.mValueOneEdit = new FloatTextField(false);
        this.mValueOneEdit.setSize(new Dimension(90, 25));
        this.mValueOneEdit.getDocument().addDocumentListener(new MyDocumentListener());
        this.mValueTwoEdit = new FloatTextField(false);
        this.mValueTwoEdit.setPreferredSize(new Dimension(55, 25));
        this.mValueTwoEdit.getDocument().addDocumentListener(new MyDocumentListener());
        this.mValueNumberEdit = new IntTextField(true);
        this.mValueNumberEdit.setPreferredSize(new Dimension(60, 25));
        this.mValueNumberEdit.getDocument().addDocumentListener(new MyDocumentListener());
        this.mValueOneLabel = DialogUtil.createLabel(this.mParent, "IDS_CF_CONDITION_VALUE_ONE");
        this.mValueOneLabel.setLabelFor((Component)this.mValueOneEdit);
        this.mValueTwoLabel = DialogUtil.createLabel(this.mParent, "IDS_CF_CONDITION_VALUE_TWO");
        this.mValueTwoLabel.setLabelFor((Component)this.mValueTwoEdit);
        this.mValueNumberLabel = DialogUtil.createLabel(this.mParent, "IDS_CF_CONDITION_NUMBER");
        this.mValueNumberLabel.setLabelFor((Component)this.mValueNumberEdit);
        this.mAbsoluteValueCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_CF_CONDITION_ABSOLUTE_VALUE", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableStyleConditionDlg.this.enableControls();
            }
        });
        this.mConditionTypesComboBoxLabel = DialogUtil.createLabel(this.mParent, "IDS_CF_CONDITION_VALUES");
        this.mConditionTypesComboBox = new ConditionsComboBox();
        this.mConditionTypesComboBoxLabel.setLabelFor(this.mConditionTypesComboBox);
        this.mConditionTypesComboBox.setRenderer(new MyEnumListRenderer());
        this.enableControls();
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        FocusableLabel focusableLabel = new FocusableLabel(this.getValueUsedforConditionText());
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom + 10, insets.right);
        DialogUtil.addUsingGBL(jPanel, (JComponent)focusableLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        JLabel jLabel = new JLabel(this.mParent.getResString("IDS_CF_CONDITION_APPLY_FORMATTING"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mAppyToAllRB, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mBasedOnTheFollowingRB, gridBagConstraints, 0, 3, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.mConditionTypesComboBoxLabel);
        jPanel2.add(this.mConditionTypesComboBox);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 4, 1, 1, n, insets);
        JPanel jPanel3 = this.createValuesPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel createValuesPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left + 25, insets.bottom, insets.right);
        int n = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mValueOneLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mValueOneEdit, gridBagConstraints, 1, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mAbsoluteValueCheckBox, gridBagConstraints, 3, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mValueTwoLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mValueTwoEdit, gridBagConstraints, 1, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mValueNumberLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mValueNumberEdit, gridBagConstraints, 1, 2, 2, 1, n, insets);
        return jPanel;
    }

    private boolean enableControls() {
        boolean bl = !this.mAppyToAllRB.isSelected();
        this.mConditionTypesComboBox.setEnabled(bl);
        this.mConditionTypesComboBoxLabel.setEnabled(bl);
        this.mAbsoluteValueCheckBox.setEnabled(bl);
        this.mValueOneEdit.setEnabled(bl);
        this.mValueTwoEdit.setEnabled(bl);
        this.mValueNumberEdit.setEnabled(bl);
        this.mValueOneLabel.setEnabled(bl);
        this.mValueTwoLabel.setEnabled(bl);
        this.mValueNumberLabel.setEnabled(bl);
        if (bl) {
            this.enableConditionEditControls((ModifyOutputEnumManager.ConditionType)((Object)this.mConditionTypesComboBox.getSelectedItem()));
        }
        this.enableContinueButton((ModifyOutputEnumManager.ConditionType)((Object)this.mConditionTypesComboBox.getSelectedItem()));
        return true;
    }

    private void enableConditionEditControls(ModifyOutputEnumManager.ConditionType conditionType) {
        boolean bl = TableStyleDlg.ConditionData.conditionTypeNeedsOneValue(conditionType);
        boolean bl2 = TableStyleDlg.ConditionData.conditionTypeNeedsTwoValue(conditionType);
        boolean bl3 = TableStyleDlg.ConditionData.conditionTypeNeedsNumberValue(conditionType);
        boolean bl4 = TableStyleDlg.ConditionData.conditionTypeSupportsAbsolute(conditionType);
        this.mValueOneEdit.setEnabled(bl);
        this.mValueOneLabel.setEnabled(bl);
        this.mValueTwoEdit.setEnabled(bl2);
        this.mValueTwoLabel.setEnabled(bl2);
        this.mValueNumberEdit.setEnabled(bl3);
        this.mValueNumberLabel.setEnabled(bl3);
        this.mAbsoluteValueCheckBox.setEnabled(bl4);
    }

    private void enableContinueButton(ModifyOutputEnumManager.ConditionType conditionType) {
        boolean bl = TableStyleDlg.ConditionData.conditionTypeNeedsOneValue(conditionType);
        boolean bl2 = TableStyleDlg.ConditionData.conditionTypeNeedsTwoValue(conditionType);
        boolean bl3 = TableStyleDlg.ConditionData.conditionTypeNeedsNumberValue(conditionType);
        boolean bl4 = !bl || bl && this.isValidNumber((SPSSTextField)this.mValueOneEdit);
        boolean bl5 = !bl2 || bl2 && this.isValidNumber((SPSSTextField)this.mValueTwoEdit);
        boolean bl6 = !bl3 || bl3 && this.isValidNumber((SPSSTextField)this.mValueNumberEdit);
        this.mContinueButton.setEnabled(this.mAppyToAllRB.isSelected() || bl4 && bl5 && bl6);
    }

    private boolean isValidNumber(SPSSTextField sPSSTextField) {
        boolean bl = true;
        bl = sPSSTextField instanceof FloatTextField ? DialogHelper.isValidDouble(sPSSTextField.getText()) : DialogHelper.isValidLong(sPSSTextField.getText());
        return bl;
    }

    public TableStyleDlg.ConditionData getConditionData() {
        return this.mNewConditionData;
    }

    public String getValueUsedforConditionText() {
        String string = MessageFormat.format(this.mParent.getResString("IDS_CF_CONDITION_VALUE_USED_FOR_CONDITION"), this.mValueTypeText);
        return string;
    }

    class ConditionsComboBox
    extends JComboBox {
        ConditionsComboBox() {
            for (ModifyOutputEnumManager.ConditionType conditionType : ModifyOutputEnumManager.ConditionType.values()) {
                this.addItem(conditionType);
            }
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableStyleConditionDlg.this.enableControls();
                }
            });
            this.setEditable(false);
        }
    }

    public class MyDocumentListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            TableStyleConditionDlg.this.enableControls();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            TableStyleConditionDlg.this.enableControls();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            TableStyleConditionDlg.this.enableControls();
        }
    }

    public class MyEnumListRenderer
    extends EnumListRenderer {
        @Override
        public String getEnumTypeStringRepresentation(Enum enum_, int n) {
            return ModifyOutputEnumManager.getEnumTypeStringRepresentation(enum_, false);
        }
    }
}

