/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.post_processing_output;

import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.post_processing_output.EnumListRenderer;
import com.spss.java_client.ui.dialogs.post_processing_output.ModifyOutputDlg;
import com.spss.java_client.ui.dialogs.post_processing_output.ModifyOutputEnumManager;
import com.spss.shared.export.table_look.BaseTableProperties;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.vis.specification.Length;
import com.spss.vis.specification.UnitType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ModifySizeDlg
extends BaseSubDialog {
    public static final String PERCENT = "percent";
    public static final String POINTS = "points";
    public static final String INCHES = "inches";
    public static final String CENTIMETERS = "centimeters";
    ModifySizeData mOldSizeData;
    ModifySizeData mNewSizeData;
    Dimension mOriginalPixelSize = new Dimension(50, 50);
    private ModifyOutputEnumManager.MeasurementType mOldMeasurementType;
    private ModifyOutputDlg mParent;
    private MeasurementComboBox mMeasurementTypesComboBox;
    private JLabel mMeasurementTypesComboBoxLabel;
    JCheckBox mLockAspectCheckBox;
    private MyNumberSpinner mHeightSpinner;
    private MyNumberSpinner mWidthSpinner;
    JLabel mHeightSpinnerLabel;
    JLabel mWidthSpinnerLabel;
    boolean mModified = false;
    double mAspectRatio;
    boolean mIgnoreSpinnerChanges = false;

    public ModifySizeDlg(ModifyOutputDlg modifyOutputDlg, ModifySizeData modifySizeData, Dimension dimension) {
        super(modifyOutputDlg, "", true);
        this.mParent = modifyOutputDlg;
        this.mOldSizeData = modifySizeData;
        this.mNewSizeData = modifySizeData;
        this.mOldMeasurementType = modifySizeData.getMeasurementType();
        this.mOriginalPixelSize = dimension;
        this.setTitle(this.mParent.getResString("IDS_MODIFY_SIZE_DLG_TITLE"));
        this.initMyPanel();
        this.setDefaults(modifySizeData, dimension);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadSizeAndLocationState();
    }

    private void setDefaults(ModifySizeData modifySizeData, Dimension dimension) {
        ModifySizeData modifySizeData2 = modifySizeData != null ? modifySizeData : new ModifySizeData();
        ModifyOutputEnumManager.MeasurementType measurementType = modifySizeData2.getMeasurementType() != null ? modifySizeData2.getMeasurementType() : ModifyOutputEnumManager.MeasurementType.Percent;
        this.mMeasurementTypesComboBox.setSelectedItem((Object)measurementType);
        this.mIgnoreSpinnerChanges = true;
        this.mHeightSpinner.getModel().setValue(modifySizeData.getHeightValue());
        this.mWidthSpinner.getModel().setValue(modifySizeData.getWidthValue());
        this.mLockAspectCheckBox.setSelected(modifySizeData2.isLockAspectRatio());
        if (modifySizeData2.isLockAspectRatio()) {
            if (measurementType == ModifyOutputEnumManager.MeasurementType.Percent) {
                this.saveAspectRatio(dimension);
            } else {
                this.saveAspectRatio();
            }
        }
        this.mIgnoreSpinnerChanges = false;
    }

    private void saveAspectRatio(Dimension dimension) {
        this.mAspectRatio = dimension.getWidth() / dimension.getHeight();
    }

    protected double getActiveAspectRatio() {
        return this.getSelectedMeasurementType() == ModifyOutputEnumManager.MeasurementType.Percent ? 1.0 : this.mAspectRatio;
    }

    private void saveAspectRatio() {
        this.mAspectRatio = this.getSpinnerValueAsDouble(this.mWidthSpinner.getModel()) / this.getSpinnerValueAsDouble(this.mHeightSpinner.getModel());
    }

    private Double getSpinnerValueAsDouble(SpinnerModel spinnerModel) {
        Object object = spinnerModel.getValue();
        if (object instanceof Double) {
            return (double)((Double)object);
        }
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Float) {
            ((Float)object).doubleValue();
        }
        return 123.456;
    }

    private Float getSpinnerValueAsFloat(SpinnerModel spinnerModel) {
        Object object = spinnerModel.getValue();
        if (object instanceof Double) {
            return Float.valueOf(((Double)object).floatValue());
        }
        if (object instanceof Integer) {
            return Float.valueOf(((Integer)object).floatValue());
        }
        if (object instanceof Float) {
            return (Float)object;
        }
        return Float.valueOf(123.456f);
    }

    public static double trimDecimals(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = stringBuffer.lastIndexOf(".");
        if (n2 > -1) {
            int n3 = n2 + n + 1;
            int n4 = stringBuffer.length();
            if (n3 < n4) {
                stringBuffer.replace(n3, n4, "");
            }
            if (n2 + 1 == stringBuffer.length()) {
                stringBuffer.replace(n2, n2 + 1, "");
            }
        }
        Double d = Double.parseDouble(stringBuffer.toString());
        return d;
    }

    private MinMaxData getMinMaxDataForMeasurementType(ModifyOutputEnumManager.MeasurementType measurementType) {
        double d = 1.0;
        double d2 = 1.0;
        switch (measurementType) {
            case Centimeters: {
                d2 = 50.0;
                break;
            }
            case Percent: {
                d2 = 1000.0;
                break;
            }
            case Inches: {
                d2 = 20.0;
                break;
            }
            case Points: {
                d = 10.0;
                d2 = 10000.0;
            }
        }
        return new MinMaxData(d, d2);
    }

    private ModifyOutputEnumManager.MeasurementType getSelectedMeasurementType() {
        return (ModifyOutputEnumManager.MeasurementType)((Object)this.mMeasurementTypesComboBox.getSelectedItem());
    }

    private UnitType convertMeasurementTypeToVizUnitType(ModifyOutputEnumManager.MeasurementType measurementType) {
        UnitType unitType = null;
        switch (measurementType) {
            case Centimeters: {
                unitType = UnitType.CM;
                break;
            }
            case Percent: {
                unitType = UnitType.PERCENT;
                break;
            }
            case Inches: {
                unitType = UnitType.IN;
                break;
            }
            case Points: {
                unitType = UnitType.PT;
            }
        }
        return unitType;
    }

    private double convertToUnitValue(double d, double d2, double d3, UnitType unitType, UnitType unitType2) {
        double d4 = -1.0;
        Object object = BaseTableProperties.convertToUserUnitValue((Length)new Length((float)d, unitType), (UnitType)unitType2);
        if (object != null) {
            if (object instanceof Integer) {
                d4 = Integer.parseInt(object.toString());
            } else if (object instanceof Double) {
                d4 = Float.parseFloat(object.toString());
            }
            d4 = Math.min(d4, d3);
            d4 = Math.max(d4, d2);
        }
        return d4;
    }

    public boolean canEnableContinue() {
        return true;
    }

    @Override
    public boolean continuePressed() {
        boolean bl = true;
        this.copySelectionsToLabelsAndTextData();
        return bl;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_modify_output_size";
    }

    protected void initMyPanel() {
        this.initUIComponents();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.createMainPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel3 = new JPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 2, 1, n, new Insets(0, 0, 0, 0));
        this.pack();
    }

    private void initUIComponents() {
        this.mMeasurementTypesComboBoxLabel = DialogUtil.createLabel(this.mParent, "IDS_MODIFY_SIZE_MEASUREMENT_COMBO");
        this.mMeasurementTypesComboBox = new MeasurementComboBox();
        this.mMeasurementTypesComboBoxLabel.setLabelFor(this.mMeasurementTypesComboBox);
        this.mMeasurementTypesComboBox.setRenderer(new MyEnumListRenderer());
        this.mHeightSpinnerLabel = DialogUtil.createLabel(this.mParent, "IDS_MODIFY_SIZE_HEIGHT");
        this.mHeightSpinner = new MyNumberSpinner(true, 100, 0, 100, true, 1);
        this.mHeightSpinner.setBorder(BorderFactory.createEmptyBorder());
        this.mHeightSpinner.setPreferredSize(new Dimension(75, 26));
        this.mHeightSpinnerLabel.setLabelFor((Component)((Object)this.mHeightSpinner));
        this.mWidthSpinnerLabel = DialogUtil.createLabel(this.mParent, "IDS_MODIFY_SIZE_WIDTH");
        this.mWidthSpinner = new MyNumberSpinner(false, 100, 0, 100, true, 1);
        this.mWidthSpinner.setBorder(BorderFactory.createEmptyBorder());
        this.mWidthSpinner.setPreferredSize(new Dimension(75, 26));
        this.mWidthSpinnerLabel.setLabelFor((Component)((Object)this.mWidthSpinner));
        this.mLockAspectCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_MODIFY_SIZE_LOCK_ASPECT_RATIO", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModifySizeDlg.this.mLockAspectCheckBox.isSelected()) {
                    ModifySizeDlg.this.saveAspectRatio();
                } else {
                    ModifySizeDlg.this.mAspectRatio = -1.0;
                }
            }
        });
    }

    private JPanel createMainPanel() {
        Insets insets;
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        Insets insets2 = insets = DialogUtil.getStandardControlInsets();
        Insets insets3 = new Insets(insets2.top, insets2.left + 50, insets2.bottom, insets2.right);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.createFlowPanel(this.mMeasurementTypesComboBoxLabel, 2), gridBagConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.createFlowPanel(this.mMeasurementTypesComboBox, 0), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.createFlowPanel(this.mHeightSpinnerLabel, 2), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.createFlowPanel((JComponent)((Object)this.mHeightSpinner), 0), gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.createFlowPanel(this.mWidthSpinnerLabel, 2), gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.createFlowPanel((JComponent)((Object)this.mWidthSpinner), 0), gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mLockAspectCheckBox, gridBagConstraints, 0, 3, 2, 1, n, insets3);
        return jPanel;
    }

    private JComponent createFlowPanel(JComponent jComponent, int n) {
        JPanel jPanel = new JPanel(new FlowLayout(n));
        jPanel.add(jComponent);
        return jPanel;
    }

    private void setSpinnersBasedOnMeasurementType(ModifyOutputEnumManager.MeasurementType measurementType, ModifyOutputEnumManager.MeasurementType measurementType2) {
        double d = this.getSpinnerValueAsDouble(this.mHeightSpinner.getModel());
        double d2 = this.getSpinnerValueAsDouble(this.mWidthSpinner.getModel());
        UnitType unitType = this.convertMeasurementTypeToVizUnitType(measurementType);
        UnitType unitType2 = this.convertMeasurementTypeToVizUnitType(measurementType2);
        MinMaxData minMaxData = this.getMinMaxDataForMeasurementType(measurementType);
        if (!this.mModified) {
            if (measurementType == ModifyOutputEnumManager.MeasurementType.Percent) {
                d = 100.0;
                d2 = 100.0;
            } else {
                d = this.convertToUnitValue(this.mOriginalPixelSize.getHeight(), minMaxData.getMinValue(), minMaxData.getMaxValue(), UnitType.PX, unitType);
                d2 = this.convertToUnitValue(this.mOriginalPixelSize.getWidth(), minMaxData.getMinValue(), minMaxData.getMaxValue(), UnitType.PX, unitType);
            }
        }
        d = Math.min(minMaxData.getMaxValue(), d);
        d2 = Math.min(minMaxData.getMaxValue(), d2);
        d = Math.max(minMaxData.getMinValue(), d);
        d2 = Math.max(minMaxData.getMinValue(), d2);
        this.mIgnoreSpinnerChanges = true;
        this.mHeightSpinner.reinitValues(d, minMaxData.getMinValue(), minMaxData.getMaxValue());
        this.mWidthSpinner.reinitValues(d2, minMaxData.getMinValue(), minMaxData.getMaxValue());
        this.mIgnoreSpinnerChanges = false;
    }

    private void setValue(MyNumberSpinner myNumberSpinner, double d) {
        FloatTextField floatTextField = (FloatTextField)myNumberSpinner.getTextField();
        floatTextField.setText(floatTextField.getNumberFormat().format(d));
    }

    private double trimDecimalPlaces(double d) {
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(1, 4);
        return bigDecimal.doubleValue();
    }

    private void resetSpinnerModel(SpinnerModel spinnerModel, float f, MinMaxData minMaxData) {
    }

    private void updateFieldByRatio(boolean bl) {
        this.updateFieldByRatio(bl, true);
    }

    private void updateFieldByRatio(boolean bl, boolean bl2) {
        this.mIgnoreSpinnerChanges = true;
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.mHeightSpinner.getModel();
        SpinnerNumberModel spinnerNumberModel2 = (SpinnerNumberModel)this.mWidthSpinner.getModel();
        double d = 0.0;
        double d2 = 0.0;
        if (bl) {
            d = (double)this.getSpinnerValueAsFloat(spinnerNumberModel).floatValue() * this.getActiveAspectRatio();
            d2 = this.getSpinnerValueAsFloat(spinnerNumberModel2).floatValue();
            if (d2 != d) {
                if (this.checkOtherRange(spinnerNumberModel2, d)) {
                    spinnerNumberModel2.setValue(d);
                    if (bl2) {
                        this.mHeightSpinner.getTextField().requestFocus();
                        this.mHeightSpinner.getTextField().selectAll();
                    }
                } else {
                    this.updateFieldByRatio(false);
                }
            }
        } else {
            d = this.getSpinnerValueAsDouble(spinnerNumberModel2) / this.getActiveAspectRatio();
            d2 = this.getSpinnerValueAsDouble(spinnerNumberModel);
            if (d2 != d) {
                if (this.checkOtherRange(spinnerNumberModel, d)) {
                    this.mHeightSpinner.getModel().setValue(d);
                    if (bl2) {
                        this.mWidthSpinner.getTextField().requestFocus();
                        this.mWidthSpinner.getTextField().selectAll();
                    }
                } else {
                    this.updateFieldByRatio(true);
                }
            }
        }
        this.mIgnoreSpinnerChanges = false;
    }

    private boolean checkOtherRange(SpinnerNumberModel spinnerNumberModel, double d) {
        boolean bl = true;
        double d2 = (Double)spinnerNumberModel.getMinimum();
        double d3 = (Double)spinnerNumberModel.getMaximum();
        if (d < d2 || d > d3) {
            bl = false;
        }
        return bl;
    }

    private void copySelectionsToLabelsAndTextData() {
        if (this.mNewSizeData == null) {
            this.mNewSizeData = new ModifySizeData();
        }
        this.mNewSizeData.setMeasurementType(this.getSelectedMeasurementType());
        this.mNewSizeData.setHeightValue(this.getSpinnerValueAsDouble(this.mHeightSpinner.getModel()));
        this.mNewSizeData.setWidthValue(this.getSpinnerValueAsDouble(this.mWidthSpinner.getModel()));
        this.mNewSizeData.setDoLockAspectRatio(this.mLockAspectCheckBox.isSelected());
    }

    public ModifySizeData getModifySizeData() {
        return this.mNewSizeData;
    }

    class MeasurementComboBox
    extends JComboBox {
        MeasurementComboBox() {
            for (ModifyOutputEnumManager.MeasurementType measurementType : ModifyOutputEnumManager.MeasurementType.values()) {
                this.addItem(measurementType);
            }
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModifySizeDlg.this.setSpinnersBasedOnMeasurementType(ModifySizeDlg.this.getSelectedMeasurementType(), ModifySizeDlg.this.mOldMeasurementType);
                    ModifySizeDlg.this.mOldMeasurementType = ModifySizeDlg.this.getSelectedMeasurementType();
                }
            });
            this.setEditable(false);
        }
    }

    public class MyNumberSpinner
    extends NumberSpinner {
        private FloatTextField textField;
        private boolean mIsHeightSpinner;

        public MyNumberSpinner(boolean bl, int n, int n2, int n3, boolean bl2, int n4) {
            super((double)n, (double)n2, (double)n3, 1, bl2, (double)n4);
            this.mIsHeightSpinner = false;
            this.mIsHeightSpinner = bl;
            Dimension dimension = this.getPreferredSize();
            dimension.width += 5;
            dimension.height += 2;
            this.setPreferredSize(dimension);
            JComponent jComponent = this.getEditor();
            this.textField = (FloatTextField)jComponent;
            SpinnerKeyAdapter spinnerKeyAdapter = new SpinnerKeyAdapter();
            this.textField.addKeyListener((KeyListener)spinnerKeyAdapter);
            this.textField.addFocusListener((FocusListener)new MyFocusAdapter(this.mIsHeightSpinner));
        }

        public void setValueIntoTextField(double d) {
            this.textField.setText(this.textField.getNumberFormat().format(d));
        }

        protected void onNumberChanged(NumberSpinner numberSpinner) {
            super.onNumberChanged(numberSpinner);
            if (!this.isIsEditChange() && !ModifySizeDlg.this.mIgnoreSpinnerChanges) {
                ModifySizeDlg.this.mModified = true;
                if (ModifySizeDlg.this.mLockAspectCheckBox.isSelected()) {
                    ModifySizeDlg.this.updateFieldByRatio(this.mIsHeightSpinner);
                }
            }
        }

        public JTextField getTextField() {
            return this.textField;
        }

        public void reinitValues(double d, double d2, double d3) {
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(d, d2, d3, 1.0);
            this.setModel(spinnerNumberModel);
            FloatTextField floatTextField = (FloatTextField)this.getTextField();
            floatTextField.setMinVal(d2);
            floatTextField.setMaxVal(d3);
            this.setValueIntoTextField(d);
        }

        class SpinnerKeyAdapter
        extends KeyAdapter {
            SpinnerKeyAdapter() {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ModifySizeDlg.this.mModified = true;
            }
        }
    }

    public static class ModifySizeData
    implements Cloneable {
        ModifyOutputEnumManager.MeasurementType measurementType = ModifyOutputEnumManager.MeasurementType.Percent;
        double heightValue = 100.0;
        double widthValue = 100.0;
        boolean lockAspectRatio = true;

        public ModifyOutputEnumManager.MeasurementType getMeasurementType() {
            return this.measurementType;
        }

        public void setMeasurementType(ModifyOutputEnumManager.MeasurementType measurementType) {
            this.measurementType = measurementType;
        }

        public double getHeightValue() {
            return this.heightValue;
        }

        public void setHeightValue(double d) {
            this.heightValue = d;
        }

        public double getWidthValue() {
            return this.widthValue;
        }

        public void setWidthValue(double d) {
            this.widthValue = d;
        }

        public boolean isLockAspectRatio() {
            return this.lockAspectRatio;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public void setDoLockAspectRatio(boolean bl) {
            this.lockAspectRatio = bl;
        }
    }

    private class MinMaxData {
        double minValue = 1.0;
        double maxValue = 1.0;

        private MinMaxData(double d, double d2) {
            this.minValue = d;
            this.maxValue = d2;
        }

        public double getMinValue() {
            return this.minValue;
        }

        public void setMinValue(double d) {
            this.minValue = d;
        }

        public double getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(double d) {
            this.maxValue = d;
        }
    }

    public class MyEnumListRenderer
    extends EnumListRenderer {
        @Override
        public String getEnumTypeStringRepresentation(Enum enum_, int n) {
            return ModifyOutputEnumManager.getEnumTypeStringRepresentation(enum_, false);
        }
    }

    class SpinnerChangeListener
    implements ChangeListener {
        boolean mIsHeightSpinner = false;

        SpinnerChangeListener(boolean bl) {
            this.mIsHeightSpinner = bl;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (!ModifySizeDlg.this.mIgnoreSpinnerChanges) {
                ModifySizeDlg.this.mModified = true;
                if (!ModifySizeDlg.this.mIgnoreSpinnerChanges && ModifySizeDlg.this.mLockAspectCheckBox.isSelected()) {
                    ModifySizeDlg.this.updateFieldByRatio(this.mIsHeightSpinner);
                }
            }
        }
    }

    class MyFocusAdapter
    extends FocusAdapter {
        boolean mIsHeightSpinner = false;

        MyFocusAdapter(boolean bl) {
            this.mIsHeightSpinner = bl;
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!ModifySizeDlg.this.mIgnoreSpinnerChanges && ModifySizeDlg.this.mLockAspectCheckBox.isSelected()) {
                ModifySizeDlg.this.updateFieldByRatio(this.mIsHeightSpinner, false);
            }
            super.focusLost(focusEvent);
        }
    }
}

