/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.post_processing_output;

import com.spss.java_client.core.documents.output.modify.OutputModifyIndexing;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.post_processing_output.DialogHelper;
import com.spss.java_client.ui.dialogs.post_processing_output.EnumListRenderer;
import com.spss.java_client.ui.dialogs.post_processing_output.ModifyOutputDlg;
import com.spss.java_client.ui.dialogs.post_processing_output.ModifyOutputEnumManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ModifyIndexingDlg
extends BaseSubDialog
implements ItemListener {
    ModifyIndexingData mOldIndexingData;
    ModifyIndexingData mNewIndexingData = new ModifyIndexingData();
    private ModifyOutputDlg mParent;
    JComboBox mIndexingTypeComboBox;
    StringTextField mIndexingStartingValueEdit;
    JLabel mIndexingTypeLabel;
    JLabel mIndexingStartingValueLabel;

    public ModifyIndexingDlg(ModifyOutputDlg modifyOutputDlg, ModifyIndexingData modifyIndexingData) {
        super(modifyOutputDlg, "", true);
        this.mParent = modifyOutputDlg;
        this.mOldIndexingData = modifyIndexingData;
        this.mNewIndexingData = modifyIndexingData;
        this.setTitle(this.mParent.getResString("IDS_MODIFY_INDEXING_DLG_TITLE"));
        this.initMyPanel();
        this.setDefaults(modifyIndexingData);
        this.enableControls();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadSizeAndLocationState();
    }

    private void setDefaults(ModifyIndexingData modifyIndexingData) {
        ModifyIndexingData modifyIndexingData2 = modifyIndexingData != null ? modifyIndexingData : new ModifyIndexingData();
        ModifyOutputEnumManager.IndexType indexType = modifyIndexingData2.getIndexingType() != null ? modifyIndexingData2.getIndexingType() : ModifyOutputEnumManager.IndexType.TYPE_NUMBER;
        this.mIndexingTypeComboBox.setSelectedItem((Object)indexType);
        this.mIndexingStartingValueEdit.setText(modifyIndexingData2.getIndexingStartingValue());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public boolean canEnableContinue() {
        return true;
    }

    @Override
    public boolean continuePressed() {
        boolean bl = true;
        if (!this.typeAndStartValueMatch()) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), this.mParent.getResString("IDS_MODIFY_INDEXING_START_MUST_MATCH"), this.getResString("IDS_MODIFY_INDEXING_ERROR_TITLE"));
            this.mIndexingStartingValueEdit.requestFocusInWindow();
            this.mIndexingStartingValueEdit.selectAll();
            bl = false;
        } else {
            this.copySelectionsToLabelsAndTextData();
        }
        return bl;
    }

    protected boolean typeAndStartValueMatch() {
        ModifyOutputEnumManager.IndexType indexType = (ModifyOutputEnumManager.IndexType)((Object)this.mIndexingTypeComboBox.getSelectedItem());
        String string = this.mIndexingStartingValueEdit.getText();
        boolean bl = indexType == ModifyOutputEnumManager.IndexType.TYPE_NUMBER && DialogHelper.isValidInteger(string);
        boolean bl2 = (indexType == ModifyOutputEnumManager.IndexType.TYPE_LOWERCASE_ALPHA || indexType == ModifyOutputEnumManager.IndexType.TYPE_UPPERCASE_ALPHA) && DialogHelper.isValidAlphaString(string);
        boolean bl3 = !(indexType != ModifyOutputEnumManager.IndexType.TYPE_LOWERCASE_ROMAN && indexType != ModifyOutputEnumManager.IndexType.TYPE_UPPERCASE_ROMAN || !DialogHelper.isValidInteger(string) && !DialogHelper.isValidRomanString(string));
        return bl || bl2 || bl3;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_modify_output_indexing";
    }

    protected void initMyPanel() {
        this.initUIComponents();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.createMainPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel3 = new JPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 2, 1, n, new Insets(0, 0, 0, 0));
        this.pack();
    }

    private void initUIComponents() {
        this.mIndexingTypeLabel = DialogUtil.createLabel(this.mParent, "IDS_MODIFY_INDEXING_COMBOBOX_LABEL");
        this.mIndexingStartingValueLabel = DialogUtil.createLabel(this.mParent, "IDS_MODIFY_INDEXING_STARTING_VALUE_LABEL");
        this.mIndexingTypeComboBox = new JComboBox<Enum>(new Enum[]{ModifyOutputEnumManager.IndexType.TYPE_NUMBER, ModifyOutputEnumManager.IndexType.TYPE_LOWERCASE_ALPHA, ModifyOutputEnumManager.IndexType.TYPE_UPPERCASE_ALPHA, ModifyOutputEnumManager.IndexType.TYPE_LOWERCASE_ROMAN, ModifyOutputEnumManager.IndexType.TYPE_UPPERCASE_ROMAN});
        this.mIndexingTypeComboBox.setRenderer(new MyEnumListRenderer());
        this.mIndexingTypeLabel.setLabelFor(this.mIndexingTypeComboBox);
        this.mIndexingTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModifyOutputEnumManager.IndexType indexType = (ModifyOutputEnumManager.IndexType)((Object)ModifyIndexingDlg.this.mIndexingTypeComboBox.getSelectedItem());
                String string = "";
                if (indexType == ModifyOutputEnumManager.IndexType.TYPE_NUMBER) {
                    string = "1";
                } else if (indexType == ModifyOutputEnumManager.IndexType.TYPE_LOWERCASE_ALPHA) {
                    string = "a";
                } else if (indexType == ModifyOutputEnumManager.IndexType.TYPE_UPPERCASE_ALPHA) {
                    string = "A";
                } else if (indexType == ModifyOutputEnumManager.IndexType.TYPE_LOWERCASE_ROMAN) {
                    string = "i";
                } else if (indexType == ModifyOutputEnumManager.IndexType.TYPE_UPPERCASE_ROMAN) {
                    string = "I";
                }
                ModifyIndexingDlg.this.mIndexingStartingValueEdit.setText(string);
            }
        });
        this.mIndexingStartingValueEdit = new StringTextField();
        this.mIndexingStartingValueLabel.setLabelFor((Component)((Object)this.mIndexingStartingValueEdit));
        this.mIndexingStartingValueEdit.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string;
                String string2 = string = ModifyIndexingDlg.this.typeAndStartValueMatch() ? ModifyIndexingDlg.this.autoConvertToType((ModifyOutputEnumManager.IndexType)((Object)ModifyIndexingDlg.this.mIndexingTypeComboBox.getSelectedItem()), ModifyIndexingDlg.this.mIndexingStartingValueEdit.getText()) : ModifyIndexingDlg.this.mIndexingStartingValueEdit.getText();
                if (string != null) {
                    ModifyIndexingDlg.this.mIndexingStartingValueEdit.setText(string);
                }
            }
        });
        this.mIndexingStartingValueEdit.setPreferredSize(new Dimension(75, 25));
    }

    private JPanel createMainPanel() {
        Insets insets;
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        Insets insets2 = insets = DialogUtil.getStandardControlInsets();
        Insets insets3 = new Insets(insets2.top, insets2.left + 25, insets2.bottom, insets2.right);
        int n = 23;
        FocusableTextArea focusableTextArea = new FocusableTextArea(this.getResString("IDS_MODIFY_LABELS_TEXT_INFO"), null);
        DialogUtil.addUsingGBL(jPanel, focusableTextArea, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        n = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mIndexingTypeLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mIndexingTypeComboBox, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mIndexingStartingValueLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mIndexingStartingValueEdit), gridBagConstraints, 1, 2, 1, 1, n, insets3);
        return jPanel;
    }

    private void enableControls() {
        this.mIndexingTypeComboBox.setEnabled(true);
        this.mIndexingTypeLabel.setEnabled(true);
        this.mIndexingStartingValueEdit.setEnabled(true);
        this.mIndexingStartingValueLabel.setEnabled(true);
    }

    private void copySelectionsToLabelsAndTextData() {
        if (this.mNewIndexingData == null) {
            this.mNewIndexingData = new ModifyIndexingData();
        }
        this.mNewIndexingData.setIndexingType((ModifyOutputEnumManager.IndexType)((Object)this.mIndexingTypeComboBox.getSelectedItem()));
        String string = this.typeAndStartValueMatch() ? this.autoConvertToType((ModifyOutputEnumManager.IndexType)((Object)this.mIndexingTypeComboBox.getSelectedItem()), this.mIndexingStartingValueEdit.getText()) : this.mIndexingStartingValueEdit.getText();
        this.mNewIndexingData.setIndexingStartingValue(string);
    }

    private String autoConvertToType(ModifyOutputEnumManager.IndexType indexType, String string) {
        boolean bl;
        boolean bl2 = indexType == ModifyOutputEnumManager.IndexType.TYPE_LOWERCASE_ALPHA;
        boolean bl3 = indexType == ModifyOutputEnumManager.IndexType.TYPE_UPPERCASE_ALPHA;
        boolean bl4 = indexType == ModifyOutputEnumManager.IndexType.TYPE_LOWERCASE_ROMAN;
        boolean bl5 = bl = indexType == ModifyOutputEnumManager.IndexType.TYPE_UPPERCASE_ROMAN;
        if (bl2) {
            string = string.toLowerCase();
        } else if (bl3) {
            string = string.toUpperCase();
        } else if (bl4 || bl) {
            if (DialogHelper.isValidInteger(string)) {
                string = OutputModifyIndexing.convertNumberToRoman((int)Integer.parseInt(string));
            }
            if (bl4) {
                string = string.toLowerCase();
            } else if (bl) {
                string = string.toUpperCase();
            }
        }
        return string;
    }

    public ModifyIndexingData getModifyIndexingData() {
        return this.mNewIndexingData;
    }

    public class MyDocumentListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ModifyIndexingDlg.this.enableControls();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ModifyIndexingDlg.this.enableControls();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            ModifyIndexingDlg.this.enableControls();
        }
    }

    public class MyEnumListRenderer
    extends EnumListRenderer {
        @Override
        public String getEnumTypeStringRepresentation(Enum enum_, int n) {
            return ModifyOutputEnumManager.getEnumTypeStringRepresentation(enum_, false);
        }
    }

    public static class ModifyIndexingData
    implements Cloneable {
        ModifyOutputEnumManager.IndexType indexingType = ModifyOutputEnumManager.IndexType.TYPE_NUMBER;
        String indexingStartingValue = "1";

        public ModifyOutputEnumManager.IndexType getIndexingType() {
            return this.indexingType;
        }

        public void setIndexingType(ModifyOutputEnumManager.IndexType indexType) {
            this.indexingType = indexType;
        }

        public String getIndexingStartingValue() {
            return this.indexingStartingValue;
        }

        public void setIndexingStartingValue(String string) {
            this.indexingStartingValue = string;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

