/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.nps_feedless;

import com.spss.java_client.core.nps_feedless.UserInfoUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.DlgKeyAdapter;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class NpsFeedlessDialog
extends BaseDialog {
    protected JLabel mTitle;
    protected JTextArea mMessageArea;
    protected String mMessage;
    protected JCheckBox mOptionOutCheckbox;
    private JLabel mPolicyLinkLabel;
    private JButton mYesButton;
    private JButton mNoButton;
    private int mButtonPressedValue;

    public NpsFeedlessDialog(JFrame jFrame, String string, boolean bl, ResourceBundle resourceBundle, String string2) throws HeadlessException {
        super(jFrame, string, bl, resourceBundle, string2);
        this.doInit();
        this.setTabTraversal();
        this.pack();
    }

    protected void addDlgKeyAdapter() {
        this.mKeyAdapter = new npsDlgKeyAdapter(this);
    }

    private void doInit() {
        this.setDefaultCloseOperation(0);
        this.initVars();
        this.addComponents(false);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NpsFeedlessDialog.this.updateOptionOutSetting();
                UserInfoUtil.resetTriggerTime();
                NpsFeedlessDialog.this.mButtonPressedValue = -1;
                NpsFeedlessDialog.this.dispose();
            }
        };
        this.addWindowListener(windowAdapter);
        if (this.mCmdButtonPanel == null) {
            this.mCmdButtonPanel = this.setupCmdButtons();
        }
        if (this.mCmdButtonPanel != null) {
            UIToolDialogUtil.normalizeButtonWidths((JPanel)this.mCmdButtonPanel);
            boolean bl = UIToolDialogUtil.areCommandButtonsBelow();
            this.mViewPanel.getParent().add((Component)this.mCmdButtonPanel, bl ? "South" : "East");
        }
        this.setPreferredSize(new Dimension(600, 250));
    }

    protected JPanel setupCmdButtons() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = insets.left + insets.right;
        YesAction yesAction = new YesAction();
        this.mYesButton = new JButton(yesAction);
        NoAction noAction = new NoAction();
        this.mNoButton = new JButton(noAction);
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            FlowLayout flowLayout = new FlowLayout(2, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(this.mNoButton);
            jPanel.add(this.mYesButton);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(this.mYesButton);
            jPanel.add(this.mNoButton);
        }
        this.getRootPane().setDefaultButton(this.mYesButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void updateOptionOutSetting() {
        UserInfoUtil.setFeedlessOptionOut((boolean)this.mOptionOutCheckbox.isSelected());
    }

    protected void addComponents(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 10;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        if (!bl) {
            gridBagConstraints.weighty = 1.0;
        }
        insets.set(DialogUtil.getGroupBoxInnerMargin() * 2, DialogUtil.getGroupBoxInnerMargin() * 3, 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(this.mViewPanel, this.mTitle, gridBagConstraints, 5, 0, 9, 1, n, insets);
        DialogUtil.addUsingGBL(this.mViewPanel, this.mMessageArea, gridBagConstraints, 0, 1, 16, 1, n, insets);
        DialogUtil.addUsingGBL(this.mViewPanel, this.mPolicyLinkLabel, gridBagConstraints, 6, 3, 4, 1, n, insets);
    }

    protected void initVars() {
        this.mTitle = new JLabel(ResUtil.getCommonDlgString("IDS_MEDALLIA_TITLE"));
        Font font = this.mTitle.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize() + 5);
        this.mTitle.setFont(font2);
        this.mMessage = ResUtil.getCommonDlgString("IDS_MEDALLIA_CONTENT");
        this.mMessageArea = new JTextArea(this.mMessage);
        this.mMessageArea.setText(this.mMessage);
        this.mMessageArea.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.mMessageArea.setOpaque(false);
        this.mMessageArea.setFocusable(true);
        this.mMessageArea.setEditable(false);
        this.mMessageArea.setLineWrap(true);
        this.mMessageArea.setWrapStyleWord(true);
        this.mOptionOutCheckbox = new JCheckBox();
        this.mOptionOutCheckbox.setText(ResUtil.getCommonDlgString("IDS_MEDALLIA_OPTION_OUT"));
        this.mOptionOutCheckbox.setSelected(false);
        this.mPolicyLinkLabel = new JLabel();
        this.mPolicyLinkLabel.setText("<html><a href=''>" + ResUtil.getCommonDlgString("IDS_MEDALLIA_PRIVACY_POLICY") + "</a></html>");
        this.mPolicyLinkLabel.setCursor(new Cursor(12));
        this.mPolicyLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                UserInfoUtil.openBrowser((UserInfoUtil.npsActionType)UserInfoUtil.npsActionType.IBM_POLICY_LINK);
            }
        });
    }

    protected void setTabTraversal() {
    }

    int getButtonPressedValue() {
        return this.mButtonPressedValue;
    }

    public void doHelp() {
    }

    protected JPanel setupCmdButtonPanel() {
        return null;
    }

    class YesAction
    extends AbstractAction {
        YesAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_MEDALLIA_PROVIDE_FEEDBACK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NpsFeedlessDialog.this.updateOptionOutSetting();
            UserInfoUtil.openBrowser((UserInfoUtil.npsActionType)UserInfoUtil.npsActionType.GIVE_FEEDBACK);
            UserInfoUtil.resetTriggerTime();
            NpsFeedlessDialog.this.mButtonPressedValue = 0;
            NpsFeedlessDialog.this.dispose();
        }
    }

    class NoAction
    extends AbstractAction {
        NoAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_MEDALLIA_NO_THANKYOU"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NpsFeedlessDialog.this.updateOptionOutSetting();
            UserInfoUtil.resetTriggerTime();
            NpsFeedlessDialog.this.mButtonPressedValue = 1;
            NpsFeedlessDialog.this.dispose();
        }
    }

    class npsDlgKeyAdapter
    extends DlgKeyAdapter {
        public npsDlgKeyAdapter(BaseDialog baseDialog) {
            super(baseDialog);
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 27) {
                NpsFeedlessDialog.this.updateOptionOutSetting();
                UserInfoUtil.resetTriggerTime();
                NpsFeedlessDialog.this.mButtonPressedValue = -1;
                NpsFeedlessDialog.this.dispose();
            }
        }
    }
}

