/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.multiple_imputation.impute_missing_data;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.ListTravArrowButtonFactory;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.multiple_imputation.impute_missing_data.ImputeMissingDataDlg;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.NumberSpinner;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class MIVariablesTab
extends BaseProcedureTab
implements ItemListener,
ListDataListener,
DocumentListener,
ActionListener,
CaretListener {
    static final int STANDARD_DPI = 96;
    private int STATIC_TEXT_WIDTH = 393;
    private int STATIC_TEXT_HEIGHT = 51;
    private static final String DATASET_SET_NAME = "IDS_MI_IMPUTE_MISSING_DATASET_NAME";
    private static final String NEW_FILE_NAME = "IDS_MI_IMPUTE_MISSING_NEW_DATA_FILE_NAME";
    static final String NUMBER_OF_IMPUTATIONS = "IDS_MI_IMPUTE_NUMBER_OF_IMPUTATIONS";
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private TargetVariableList mAnalysisVarList;
    private ArrowButton mAnalysisVarButton;
    private JScrollPane mAnalysisVarListScrollPane;
    private ListTravArrowButtonFactory mTraveralArrowButton;
    private JPanel mAnalysisUpAndDownArrowButtonPanel;
    private NumberSpinner mImputationSpinner;
    private JLabel mImputationLabel;
    private TargetVariableList mWeightVarList;
    private ArrowButton mWeightVarButton;
    private JScrollPane mWeightVarListScrollPane;
    private JRadioButton mCreateDatasetRadio;
    private JRadioButton mWriteDataFileRadio;
    private JLabel mDatasetNameLabel;
    private FileTextField mNewDataFilePath;
    private StringTextField mDatasetNameValue;
    private JButton mDataFileButton;
    private boolean mDatasetNameCheckFlag = true;
    private String mPerAttributesSyntax = "";

    public MIVariablesTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initialize();
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mSrcVarList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mDataFileButton) {
            String string = ((ImputeMissingDataDlg)this.mParent).showSaveDialog();
            this.mNewDataFilePath.setText(string);
            this.setEnabledOkPaste();
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.setEnabledOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        Object object;
        DialogDataModel dialogDataModel = ((ImputeMissingDataDlg)this.mParent).getDialogDataModel();
        if (dialogDataModel != null && (object = dialogDataModel.getObject("IDS_MI_IMPUTE_MISSING_CONSTRIANTS")) != null) {
            ((ImputeMissingDataDlg)this.mParent).getConstraintsTab().updateTables();
        }
        this.setEnabledOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.setEnabledOkPaste();
    }

    @Override
    public void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        if (dialogDataModel != null) {
            String string = dialogDataModel.getString(NUMBER_OF_IMPUTATIONS);
            if (string != null) {
                ((JTextField)this.mImputationSpinner.getEditor()).setText(string);
            }
            this.setEnabledOkPaste();
        }
    }

    @Override
    public void saveTabState(DialogDataModel dialogDataModel) {
        dialogDataModel.putString(NUMBER_OF_IMPUTATIONS, ((JTextField)this.mImputationSpinner.getEditor()).getText());
    }

    void setDataSetFlag(boolean bl) {
        this.mDatasetNameCheckFlag = bl;
    }

    boolean getDataSetFlag() {
        return this.mDatasetNameCheckFlag;
    }

    void selectDataSetNameField() {
        ImputeMissingDataDlg.setSelectionText((JComponent)((Object)this.mDatasetNameValue));
    }

    boolean isDataSetNameOK() {
        if (this.mCreateDatasetRadio.isSelected()) {
            String string = this.mDatasetNameValue.getText();
            if (string.length() == 0) {
                String string2 = this.getResString("ERR_MI_IMPUTE_MISSING_NO_DATASET_WARNING2");
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, string2, VersionInfo.getAppVersionString());
                ImputeMissingDataDlg.setSelectionText((JComponent)((Object)this.mDatasetNameValue));
                return false;
            }
            int n = DatasetNameValidator.validateDatasetName((String)string, (Component)this);
            if (n == 0) {
                ImputeMissingDataDlg.setSelectionText((JComponent)((Object)this.mDatasetNameValue));
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean validateTab() {
        try {
            if (this.mAnalysisVarList.getModel().getSize() == 1) {
                String string = this.getResString("ERR_MI_AP_ONE_TARGET_VAR_WARNING");
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, string, VersionInfo.getAppVersionString());
                this.mAnalysisVarList.requestFocusInWindow();
                return false;
            }
            if (this.mDatasetNameCheckFlag && this.getAnalysisVariableListModel().getSize() >= 2 && !this.isDataSetNameOK()) {
                return false;
            }
            String string = ((JTextField)this.mImputationSpinner.getEditor()).getText();
            String string2 = "";
            if (string.length() == 0) {
                string2 = this.getResString("ERR_MI_IMPUTE_MISSING_VARIABLE_TAB_MESG1");
            } else if (Integer.parseInt(string) == 0) {
                string2 = this.getResString("ERR_MI_IMPUTE_MISSING_VARIABLE_TAB_MESG2");
            }
            if (string2.length() > 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, string2, VersionInfo.getAppVersionString());
                this.mImputationSpinner.getEditor().requestFocusInWindow();
                return false;
            }
            if (this.mDataFileButton.isEnabled() && this.mNewDataFilePath.getText().length() == 0) {
                String string3 = this.getResString("ERR_MI_IMPUTE_MISSING_NO_FILE_WARNING1");
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, string3, VersionInfo.getAppVersionString());
                this.mDataFileButton.requestFocusInWindow();
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mCreateDatasetRadio) {
            this.mDatasetNameLabel.setEnabled(true);
            this.mDatasetNameValue.setEnabled(true);
            this.mDataFileButton.setEnabled(false);
            this.mNewDataFilePath.setEnabled(false);
            this.setEnabledOkPaste();
        }
        if (itemEvent.getSource() == this.mWriteDataFileRadio) {
            this.mDatasetNameLabel.setEnabled(false);
            this.mDatasetNameValue.setEnabled(false);
            this.mDataFileButton.setEnabled(true);
            this.mNewDataFilePath.setEnabled(true);
            this.setEnabledOkPaste();
        }
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_MI_VARIABLES";
    }

    public VarListModel getAnalysisVariableListModel() {
        return this.mAnalysisVarList.getModel();
    }

    public VarListModel getSrcListModel() {
        return this.mSrcVarList.getModel();
    }

    public VarListModel getWeightListModel() {
        return this.mWeightVarList.getModel();
    }

    public String getVariablesTabSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\nMULTIPLE IMPUTATION ");
        VarListModel varListModel = this.getAnalysisVariableListModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            stringBuffer.append(iSpssVariable.getName()).append(" ");
        }
        VarListModel varListModel2 = this.getWeightListModel();
        if (varListModel2.getSize() == 1) {
            stringBuffer.append("\n  /ANALYSISWEIGHT ").append(varListModel2.getElementAt(0).getName());
        }
        return stringBuffer.toString();
    }

    public String getOutputFileSyntax() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n  /OUTFILE IMPUTATIONS=");
        if (this.mCreateDatasetRadio.isSelected()) {
            stringBuffer.append(this.mDatasetNameValue.getText()).append(" ");
        } else {
            String string;
            stringBuffer.append("'").append(this.mNewDataFilePath.getText()).append("' ");
            this.mPerAttributesSyntax = "";
            PesFile pesFile = PES_Repository.getPesFile((String)this.mNewDataFilePath.getText());
            if (pesFile != null && (string = pesFile.getPerAttributesSyntax()) != null) {
                this.mPerAttributesSyntax = this.mPerAttributesSyntax + "\n";
                this.mPerAttributesSyntax = this.mPerAttributesSyntax + string;
            }
        }
        return stringBuffer.toString();
    }

    public String getPESSyntax() {
        return this.mPerAttributesSyntax;
    }

    String getDataSetName() {
        if (this.mCreateDatasetRadio.isSelected()) {
            return this.mDatasetNameValue.getText();
        }
        return "";
    }

    String getDataFilePath() {
        if (this.mWriteDataFileRadio.isSelected()) {
            return this.mNewDataFilePath.getText();
        }
        return "";
    }

    public String getDatasetDelcareSyntax() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.mCreateDatasetRadio.isSelected()) {
            stringBuffer.append("\nDATASET DECLARE ");
            stringBuffer.append(this.mDatasetNameValue.getText()).append(".");
        }
        return stringBuffer.toString();
    }

    public String getNImputationsSyntax() {
        StringBuffer stringBuffer = new StringBuffer("NIMPUTATIONS=");
        stringBuffer.append(((JTextField)this.mImputationSpinner.getEditor()).getText() + " ");
        return stringBuffer.toString();
    }

    boolean hasCategoricalTarget() {
        ISpssVariable iSpssVariable;
        MeasurementLevel measurementLevel;
        boolean bl = false;
        VarListModel varListModel = this.getAnalysisVariableListModel();
        if (varListModel.getSize() == 1 && ((measurementLevel = (iSpssVariable = varListModel.getElementAt(0)).getDisplayMeasurementLevel()) == MeasurementLevel.nominal || measurementLevel == MeasurementLevel.ordinal)) {
            return true;
        }
        return bl;
    }

    @Override
    public void reset() {
        this.mWeightVarList.removeAll();
        this.mAnalysisVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocusInWindow();
        this.setDefaults();
    }

    public boolean setEnabledOkPaste() {
        boolean bl = false;
        if (this.mAnalysisVarList.getModel().getSize() > 0) {
            bl = true;
        }
        if (bl) {
            bl = this.mCreateDatasetRadio.isSelected() ? this.mDatasetNameValue.getText().length() > 0 : this.mNewDataFilePath.getText().length() > 0;
        }
        ((ImputeMissingDataDlg)this.mParent).enableOkPaste(bl);
        return bl;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.setDataSetFlag(true);
        this.setEnabledOkPaste();
    }

    private void initialize() {
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Dimension dimension = this.mSrcScrollPane.getPreferredSize();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2 - 4, 0, 0, 0);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_MI_AP_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, 0, n2, 0);
        DialogUtil.addUsingGBL(this, this.mSrcScrollPane, gridBagConstraints, 0, 1, 2, 3, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2 - 4, 0, 0, 0);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_MI_IMPUTE_MISSING_VARIABLE_TAB_VARS_IN_MODEL");
        jLabel2.setLabelFor(this.mAnalysisVarList);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2 - 4, n2, 1, n2 - 4);
        DialogUtil.addUsingGBL(this, jLabel2, gridBagConstraints, 3, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(this, this.mAnalysisVarButton, gridBagConstraints, 2, 1, 1, 1, 10, insets);
        gridBagConstraints.fill = 1;
        insets.set(1, n2, n2, n2 - 4);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this, this.mAnalysisVarListScrollPane, gridBagConstraints, 3, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2 - 4, 0, 0);
        DialogUtil.addUsingGBL(this, this.mAnalysisUpAndDownArrowButtonPanel, gridBagConstraints, 4, 1, 1, 1, 10, insets);
        JLabel jLabel3 = DialogUtil.createLabel(this.mParent, "IDS_MI_AP_WEIGHT_VAR_LABEL");
        jLabel3.setLabelFor(this.mWeightVarList);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2 * 2, n2, 1, n2);
        DialogUtil.addUsingGBL(this, jLabel3, gridBagConstraints, 3, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        insets.set(n2 * 2, n2, 0, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, this.mWeightVarButton, gridBagConstraints, 2, 2, 1, 2, 20, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, n2, 0, n2 - 4);
        DialogUtil.addUsingGBL(this, this.mWeightVarListScrollPane, gridBagConstraints, 3, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2 * 3, n2, n2, n2);
        DialogUtil.addUsingGBL(this, this.mImputationLabel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2 * 3, n2, n2, n2);
        DialogUtil.addUsingGBL(this, (JComponent)this.mImputationSpinner, gridBagConstraints, 1, 4, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, 0, 4, n2);
        DialogUtil.addUsingGBL(this, this.setupImputedDataLocationPanel(), gridBagConstraints, 0, 5, 4, 1, n, insets);
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel4 = new JLabel();
        jLabel4.setIcon(new ImageIcon(uRL));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 0, 0, 1, 1, n, insets);
        try {
            double d;
            double d2;
            JTextPane jTextPane = new JTextPane();
            jTextPane.setBorder(null);
            StyledDocument styledDocument = jTextPane.getStyledDocument();
            styledDocument.insertString(0, this.getResString("IDS_MI_IMPUTE_MISSING_VARIABLE_TAB_MESG1"), SimpleAttributeSet.EMPTY);
            Style style = jTextPane.addStyle("icon1", null);
            StyleConstants.setIcon(style, new ImageIcon(ResUtil.getImageResource("multiple_imputation_procedure_icon.png")));
            styledDocument.insertString(styledDocument.getLength(), "  ", styledDocument.getStyle("icon1"));
            styledDocument.insertString(styledDocument.getLength(), "  " + this.getResString("IDS_MI_IMPUTE_MISSING_VARIABLE_TAB_MESG2"), SimpleAttributeSet.EMPTY);
            jTextPane.setEditable(false);
            jTextPane.setOpaque(false);
            jTextPane.setFocusable(false);
            JScrollPane jScrollPane = new JScrollPane(jTextPane);
            jScrollPane.setBorder(null);
            jScrollPane.setVerticalScrollBarPolicy(21);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            double d3 = jScrollPane.getPreferredSize().getWidth() * 0.36;
            if ((int)d3 - this.STATIC_TEXT_WIDTH > 20) {
                this.STATIC_TEXT_HEIGHT += 17;
            }
            if ((d2 = (d = (double)Toolkit.getDefaultToolkit().getScreenResolution()) / 96.0) < 1.0) {
                d2 = 1.0;
            }
            int n3 = (int)((double)this.STATIC_TEXT_WIDTH * d2);
            if (d2 > 1.0) {
                d2 += 0.25;
            }
            int n4 = (int)((double)this.STATIC_TEXT_HEIGHT * d2);
            jScrollPane.setMinimumSize(new Dimension(n3, n4));
            jScrollPane.setPreferredSize(new Dimension(n3, n4));
            insets.set(n2, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 0, 1, 1, n, insets);
        }
        catch (Exception exception) {
            // empty catch block
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 6, 4, 1, n, insets);
        this.setFocusTraversalPolicy();
    }

    protected JPanel setupImputedDataLocationPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_MI_IMPUTE_MISSING_VARIABLE_TAB_DATA_LOCATION_TITLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(2, 2, 4, n);
        int n2 = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n * 3, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mCreateDatasetRadio, gridBagConstraints, 0, 0, 3, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n * 8, 0, -n * 4);
        DialogUtil.addUsingGBL(jPanel, this.mDatasetNameLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n, -n * 4, 0, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDatasetNameValue), gridBagConstraints, 1, 1, 2, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n * 3, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mWriteDataFileRadio, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mDataFileButton, gridBagConstraints, 1, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n + 3, n, n - 3, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNewDataFilePath), gridBagConstraints, 2, 2, 1, 1, n2, insets);
        return jPanel;
    }

    private Vector<Object> setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mAnalysisVarButton);
        vector.add(this.mWeightVarButton);
        vector.add(this.mAnalysisVarList);
        vector.add(this.mTraveralArrowButton.getUpArrowButton());
        vector.add(this.mTraveralArrowButton.getDownArrowButton());
        vector.add(this.mWeightVarList);
        vector.add(this.mImputationSpinner.getEditor());
        vector.add(this.mCreateDatasetRadio);
        vector.add(this.mDatasetNameValue);
        vector.add(this.mWriteDataFileRadio);
        vector.add(this.mDataFileButton);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
        return vector;
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mImputationSpinner.setValue((Object)Integer.parseInt("5"));
        this.mCreateDatasetRadio.setSelected(true);
        this.mDatasetNameLabel.setEnabled(true);
        this.mDatasetNameValue.setEnabled(true);
        this.mDatasetNameValue.setText("");
        this.mDataFileButton.setEnabled(false);
        this.mNewDataFilePath.setEnabled(false);
        this.mNewDataFilePath.setText("");
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier("ImputeMissingDataSrcList");
        this.mSrcVarList.getModel().addListDataListener(this);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcScrollPane.setHorizontalScrollBarPolicy(30);
        this.mSrcScrollPane.setVerticalScrollBarPolicy(20);
        this.mAnalysisVarList = new TargetVariableList();
        this.mAnalysisVarList.setIdentifier("ImputeMissingDataTargetList");
        this.mAnalysisVarList.getModel().addListDataListener(this);
        this.mAnalysisVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mAnalysisVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mAnalysisVarList.getFixedCellHeight() * 6 + 2));
        this.mAnalysisVarListScrollPane = new JScrollPane(this.mAnalysisVarList);
        this.mAnalysisVarListScrollPane.setPreferredSize(this.mAnalysisVarList.getMinimumSize());
        this.mAnalysisVarButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mAnalysisVarButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mAnalysisVarButton.registerVariableList(this.mAnalysisVarList, SpssArrowButton.ButtonOrientation.left);
        this.mTraveralArrowButton = new ListTravArrowButtonFactory(this.mAnalysisVarList, false);
        this.mAnalysisUpAndDownArrowButtonPanel = this.mTraveralArrowButton.getArrowButtonPanel();
        TargetVariableList.TargetListType targetListType = TargetVariableList.TargetListType.single_item;
        this.mWeightVarList = new TargetVariableList(targetListType);
        this.mWeightVarList.setIdentifier("ImputeMissingDataWeightList");
        this.mWeightVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mWeightVarList.addVarFilter(new SpssVarFilter(32, false));
        this.mWeightVarList.addVarFilter(new SpssVarFilter(64, false));
        this.mWeightVarList.getModel().addListDataListener(this);
        this.mWeightVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mWeightVarList.getFixedCellHeight()));
        this.mWeightVarListScrollPane = new JScrollPane(this.mWeightVarList);
        this.mWeightVarListScrollPane.setVerticalScrollBarPolicy(21);
        this.mWeightVarListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mWeightVarListScrollPane.setPreferredSize(this.mWeightVarList.getMinimumSize());
        this.mWeightVarButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mWeightVarButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mWeightVarButton.registerVariableList(this.mWeightVarList, SpssArrowButton.ButtonOrientation.left);
        this.mImputationLabel = DialogUtil.createLabel(this.mParent, "IDS_MI_IMPUTE_MISSING_VARIABLE_TAB_IMPUTATION");
        this.mImputationSpinner = new NumberSpinner(5, 0, Integer.MAX_VALUE, true, 1);
        Dimension dimension = this.mImputationSpinner.getEditor().getPreferredSize();
        int n = dimension.width;
        dimension.width = n * 5;
        this.mImputationSpinner.getEditor().setMinimumSize(dimension);
        this.mImputationSpinner.getEditor().setPreferredSize(dimension);
        this.mImputationLabel.setLabelFor(this.mImputationSpinner.getEditor());
        this.mCreateDatasetRadio = DialogUtil.createRadioButton(this.mParent, "IDS_MI_IMPUTE_MISSING_VARIABLE_TAB_NEW_DATASET_LABEL", null);
        this.mCreateDatasetRadio.addItemListener(this);
        this.mWriteDataFileRadio = DialogUtil.createRadioButton(this.mParent, "IDS_MI_IMPUTE_MISSING_VARIABLE_TAB_DATAFILE_LABEL", null);
        this.mWriteDataFileRadio.addItemListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mCreateDatasetRadio);
        spssButtonGroup.add(this.mWriteDataFileRadio);
        this.mDatasetNameLabel = DialogUtil.createLabel(this.mParent, "IDS_MI_IMPUTE_MISSING_VARIABLE_TAB_NEW_DATASET_NAME_LABEL");
        this.mDatasetNameValue = new StringTextField();
        this.mDatasetNameValue.setColumns(30);
        this.mDatasetNameValue.setAction(new TextFieldAction(this.mParent, DATASET_SET_NAME));
        this.mDatasetNameValue.addCaretListener(this);
        this.mDatasetNameValue.getDocument().addDocumentListener(this);
        this.mDatasetNameLabel.setLabelFor((Component)((Object)this.mDatasetNameValue));
        this.mNewDataFilePath = new FileTextField();
        this.mNewDataFilePath.setEditable(false);
        this.mNewDataFilePath.setOpaque(false);
        this.mNewDataFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mNewDataFilePath.setAction(new TextFieldAction(this.mParent, NEW_FILE_NAME));
        this.mDataFileButton = DialogUtil.createButton(this.mParent, "IDS_MI_IMPUTE_MISSING_VARIABLE_TAB_DATAFILE_BUTTON", null);
        this.mDataFileButton.setEnabled(true);
        this.mDataFileButton.addActionListener(this);
    }

    public SplitVarFilter getSplitVarFilter() {
        return new SplitVarFilter();
    }

    private class SplitVarFilter
    implements IVarFilter {
        private SplitVarFilter() {
        }

        @Override
        public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
            LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.getNSplitVars();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable2 = iSpssDataSrc.getVariable(iSpssDataSrc.getSplitVarIndex(i));
                if (iSpssVariable == null || iSpssVariable2 == null || !iSpssVariable.getId().equals((Object)iSpssVariable2.getId())) continue;
                return false;
            }
            return true;
        }
    }
}

