/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.multiple_imputation.impute_missing_data;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.multiple_imputation.impute_missing_data.ImputeMissingDataDlg;
import com.spss.uitools.controls.NumberSpinner;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MIMethodTab
extends BaseProcedureTab
implements ItemListener,
DocumentListener {
    private int LABEL_LENGTH_IN_ENGLISH = 101;
    private static String NUMBER_OF_ITERATIONS = "IDS_MI_IMPUTE_FCS_ITERATIONS";
    private SpssButtonGroup mExportDistanceRadioGrp;
    private JRadioButton mAutoRadio;
    private JTextArea mAutoMessage;
    private JRadioButton mCustomRadio;
    private JRadioButton mFullyConditionRadio;
    private JTextArea mFullyConditionMessage;
    private JRadioButton mMonotoneRadio;
    private JTextArea mMonotoneMessage;
    private JCheckBox mIncludeTwoWayLCheck;
    private JLabel mModelTypeLabel;
    private JComboBox mModelTypeCombo;
    private JLabel mMaxIterationLabel;
    private NumberSpinner mMaxIterations;
    private JLabel mToleranceLabel;
    private JComboBox mToleranceCombo;

    public MIMethodTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initialize();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        String string;
        if (dialogDataModel != null && (string = dialogDataModel.getString(NUMBER_OF_ITERATIONS)) != null) {
            ((JTextField)this.mMaxIterations.getEditor()).setText(string);
        }
    }

    @Override
    public void saveTabState(DialogDataModel dialogDataModel) {
        dialogDataModel.putString(NUMBER_OF_ITERATIONS, ((JTextField)this.mMaxIterations.getEditor()).getText());
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mCustomRadio) {
            this.mFullyConditionRadio.setEnabled(true);
            this.mFullyConditionMessage.setEnabled(true);
            if (this.mFullyConditionRadio.isSelected()) {
                this.mMaxIterationLabel.setEnabled(true);
                this.mMaxIterations.setEnabled(true);
                this.mMaxIterations.getEditor().setEnabled(true);
            }
            this.mMonotoneMessage.setEnabled(true);
            this.mMonotoneRadio.setEnabled(true);
            if (this.mMonotoneRadio.isSelected()) {
                this.mMaxIterationLabel.setEnabled(false);
                this.mMaxIterations.setEnabled(false);
                this.mMaxIterations.getEditor().setEnabled(false);
            }
            this.mIncludeTwoWayLCheck.setEnabled(true);
            this.mModelTypeCombo.setEnabled(true);
            this.mModelTypeLabel.setEnabled(true);
            this.mToleranceCombo.setEnabled(true);
            this.mToleranceLabel.setEnabled(true);
        }
        if (itemEvent.getSource() == this.mAutoRadio) {
            this.mFullyConditionRadio.setEnabled(false);
            this.mFullyConditionMessage.setEnabled(false);
            this.mMaxIterationLabel.setEnabled(false);
            this.mMaxIterations.setEnabled(false);
            this.mMaxIterations.getEditor().setEnabled(false);
            this.mMonotoneMessage.setEnabled(false);
            this.mMonotoneRadio.setEnabled(false);
            this.mIncludeTwoWayLCheck.setEnabled(false);
            this.mModelTypeCombo.setEnabled(false);
            this.mModelTypeLabel.setEnabled(false);
            this.mToleranceCombo.setEnabled(false);
            this.mToleranceLabel.setEnabled(false);
        }
        if (itemEvent.getSource() == this.mFullyConditionRadio) {
            this.mMaxIterationLabel.setEnabled(true);
            this.mMaxIterations.setEnabled(true);
            this.mMaxIterations.getEditor().setEnabled(true);
        }
        if (itemEvent.getSource() == this.mMonotoneRadio) {
            this.mMaxIterationLabel.setEnabled(false);
            this.mMaxIterations.getEditor().setEnabled(false);
            this.mMaxIterations.setEnabled(false);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_MI_METHOD";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public boolean isLinearModel() {
        if (this.mAutoRadio.isSelected()) {
            return true;
        }
        return this.mModelTypeCombo.getSelectedIndex() == 0;
    }

    boolean isMonotoneSelected() {
        return this.mCustomRadio.isSelected() && this.mMonotoneRadio.isSelected();
    }

    public String getMethodTabSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n  /IMPUTE METHOD=");
        Boolean bl = dialogDataModel.getBoolean("IDS_MI_IMPUTE_MISSING_METHOD_AUTOMATIC_RADIO");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("AUTO ");
            stringBuffer.append(((ImputeMissingDataDlg)this.mParent).getVariablesTab().getNImputationsSyntax());
        } else {
            Boolean bl2 = dialogDataModel.getBoolean("IDS_MI_IMPUTE_MISSING_METHOD_MONOTONE_RADIO");
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append("MONOTONE ");
            } else {
                stringBuffer.append("FCS ");
                stringBuffer.append("MAXITER= ").append(((JTextField)this.mMaxIterations.getEditor()).getText() + " ");
            }
            stringBuffer.append(((ImputeMissingDataDlg)this.mParent).getVariablesTab().getNImputationsSyntax());
            if (this.mModelTypeCombo.getSelectedIndex() == 0) {
                stringBuffer.append("SCALEMODEL=LINEAR ");
            } else if (this.mModelTypeCombo.getSelectedIndex() == 1) {
                stringBuffer.append("SCALEMODEL=PMM ");
            }
            if (this.mIncludeTwoWayLCheck.isSelected()) {
                stringBuffer.append("INTERACTIONS=TWOWAY ");
            } else {
                stringBuffer.append("INTERACTIONS=NONE ");
            }
            stringBuffer.append("SINGULAR=").append(this.mToleranceCombo.getSelectedItem().toString() + " ");
        }
        stringBuffer.append(((ImputeMissingDataDlg)this.mParent).getConstraintsTab().getImputeSyntax(dialogDataModel));
        return stringBuffer.toString();
    }

    @Override
    protected boolean validateTab() {
        return this.doValidation();
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mIncludeTwoWayLCheck;
    }

    private void initialize() {
        this.initVars();
        super.initPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2, n2, n2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, this.setupImputationMethodPanel(), gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mIncludeTwoWayLCheck, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2 + 4, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mModelTypeLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mModelTypeCombo, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        int n3 = n2 * 5;
        if (this.mToleranceLabel.getPreferredSize().getWidth() - (double)this.LABEL_LENGTH_IN_ENGLISH > 30.0) {
            n3 = -n2;
        }
        insets.set(n2, n2 + 4, n2, -n3);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mToleranceLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, -n3, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mToleranceCombo, gridBagConstraints, 1, 3, 1, 1, n, insets);
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    private JPanel setupImputationMethodPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_MI_IMPUTE_MISSING_METHOD_IMPUTATION_TITLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(2, 2, 4, 0);
        int n2 = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mAutoRadio, gridBagConstraints, 0, 0, 2, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(4, n * 5, 0, 2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mAutoMessage, gridBagConstraints, 0, 1, 2, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 2, 4, 2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCustomRadio, gridBagConstraints, 0, 2, 2, 1, n2, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        insets.set(0, n * 5, 0, 0);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFullyConditionRadio, gridBagConstraints, 0, 3, 2, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, n * 8, 4, 0);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mFullyConditionMessage, gridBagConstraints, 0, 4, 2, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(2, n * 8, n - 2, n);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mMaxIterationLabel, gridBagConstraints, 0, 5, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, n, n, n);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterations, gridBagConstraints, 1, 5, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, n * 5, 4, 0);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mMonotoneRadio, gridBagConstraints, 0, 6, 2, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        insets.set(0, n * 8, n * 2, 0);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mMonotoneMessage, gridBagConstraints, 0, 7, 2, 1, n2, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mAutoRadio);
        vector.add(this.mCustomRadio);
        vector.add(this.mFullyConditionRadio);
        vector.add(this.mMonotoneRadio);
        vector.add(this.mIncludeTwoWayLCheck);
        vector.add(this.mModelTypeCombo);
        vector.add(this.mMaxIterations);
        vector.add(this.mToleranceCombo);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void setDefaults() {
        int n;
        this.mAutoRadio.setSelected(true);
        this.mIncludeTwoWayLCheck.setEnabled(false);
        this.mIncludeTwoWayLCheck.setSelected(false);
        this.mFullyConditionRadio.setSelected(true);
        this.mFullyConditionRadio.setEnabled(false);
        this.mFullyConditionMessage.setEnabled(false);
        this.mMonotoneMessage.setEnabled(false);
        this.mMonotoneRadio.setEnabled(false);
        if (this.mModelTypeCombo.getItemCount() > 0) {
            this.mModelTypeCombo.removeAllItems();
        }
        String[] stringArray = this.getResStringArray("IDS_MI_IMPUTE_MISSING_METHOD_MODEL_TYPE_ARRARY");
        for (n = 0; n < stringArray.length; ++n) {
            this.mModelTypeCombo.addItem(stringArray[n]);
        }
        this.mModelTypeCombo.setSelectedIndex(0);
        this.mModelTypeCombo.setEditable(false);
        this.mModelTypeCombo.setEnabled(false);
        if (this.mToleranceCombo.getItemCount() > 0) {
            this.mToleranceCombo.removeAllItems();
        }
        stringArray = this.getResStringArray("IDS_MI_IMPUTE_MISSING_METHOD_TOLERANCE_ARRARY");
        for (n = 0; n < stringArray.length; ++n) {
            this.mToleranceCombo.addItem(stringArray[n]);
        }
        this.mToleranceCombo.setSelectedIndex(stringArray.length - 1);
        this.mToleranceCombo.setEditable(false);
        this.mToleranceCombo.setEnabled(false);
        this.mMaxIterations.setValue((Object)Integer.parseInt("10"));
        this.mMaxIterationLabel.setEnabled(false);
        this.mMaxIterations.getEditor().setEnabled(false);
        this.mMaxIterations.setEnabled(false);
    }

    private void initVars() {
        this.mAutoRadio = DialogUtil.createRadioButton(this.mParent, "IDS_MI_IMPUTE_MISSING_METHOD_AUTOMATIC_RADIO", null);
        this.mAutoRadio.addItemListener(this);
        this.mCustomRadio = DialogUtil.createRadioButton(this.mParent, "IDS_MI_IMPUTE_MISSING_METHOD_CUSTOM_RADIO", null);
        this.mCustomRadio.addItemListener(this);
        this.mExportDistanceRadioGrp = new SpssButtonGroup();
        this.mExportDistanceRadioGrp.add(this.mAutoRadio);
        this.mExportDistanceRadioGrp.add(this.mCustomRadio);
        this.mAutoMessage = new JTextArea();
        this.mAutoMessage.setRows(1);
        this.mAutoMessage.setOpaque(false);
        this.mAutoMessage.setFont(this.mAutoRadio.getFont());
        this.mAutoMessage.setLineWrap(true);
        this.mAutoMessage.setWrapStyleWord(true);
        this.mAutoMessage.setText(this.getResString("IDS_MI_IMPUTE_MISSING_METHOD_AUTOMATIC_MESG"));
        this.mAutoMessage.setFocusable(false);
        this.mFullyConditionRadio = DialogUtil.createRadioButton(this.mParent, "IDS_MI_IMPUTE_MISSING_METHOD_FCS_RADIO", null);
        this.mFullyConditionRadio.addItemListener(this);
        this.mMonotoneRadio = DialogUtil.createRadioButton(this.mParent, "IDS_MI_IMPUTE_MISSING_METHOD_MONOTONE_RADIO", null);
        this.mMonotoneRadio.addItemListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mFullyConditionRadio);
        spssButtonGroup.add(this.mMonotoneRadio);
        this.mFullyConditionMessage = new JTextArea();
        this.mFullyConditionMessage.setRows(1);
        this.mFullyConditionMessage.setOpaque(false);
        this.mFullyConditionMessage.setFont(this.mAutoRadio.getFont());
        this.mFullyConditionMessage.setLineWrap(true);
        this.mFullyConditionMessage.setWrapStyleWord(true);
        this.mFullyConditionMessage.setText(this.getResString("IDK_MI_IMPUTE_MISSING_METHOD_FCS_MESG"));
        this.mFullyConditionMessage.setFocusable(false);
        this.mMonotoneMessage = new JTextArea();
        this.mMonotoneMessage.setRows(3);
        this.mMonotoneMessage.setOpaque(false);
        this.mMonotoneMessage.setFont(this.mAutoRadio.getFont());
        this.mMonotoneMessage.setLineWrap(true);
        this.mMonotoneMessage.setWrapStyleWord(true);
        this.mMonotoneMessage.setText(this.getResString("IDS_MI_IMPUTE_MISSING_METHOD_MONOTONE_MESG"));
        this.mMonotoneMessage.setFocusable(false);
        ControlAction controlAction = new ToggleButtonAction(this.mParent, "IDS_MI_IMPUTE_MISSING_METHOD_TWO_WAY_CHECK");
        this.mIncludeTwoWayLCheck = new JCheckBox(controlAction);
        this.mIncludeTwoWayLCheck.addItemListener(this);
        this.mModelTypeLabel = DialogUtil.createLabel(this.mParent, "IDS_MI_IMPUTE_MISSING_METHOD_MODEL_TYPE_LABEL");
        controlAction = new ComboboxAction(this.mParent, "IDS_MI_IMPUTE_MISSING_METHOD_MODEL_TYPE_LABEL");
        this.mModelTypeCombo = new JComboBox();
        this.mModelTypeCombo.setEditable(true);
        this.mModelTypeCombo.addItemListener(this);
        this.mModelTypeCombo.setAction(controlAction);
        this.mModelTypeCombo.setEnabled(true);
        this.mModelTypeLabel.setLabelFor(this.mModelTypeCombo);
        this.mMaxIterationLabel = DialogUtil.createLabel(this.mParent, "IDS_MI_IMPUTE_MISSING_METHOD_MAX_ITERATION_LABEL");
        this.mMaxIterations = new NumberSpinner(10, 0, Integer.MAX_VALUE, true, 1);
        ((JTextField)this.mMaxIterations.getEditor()).setColumns(10);
        this.mMaxIterationLabel.setLabelFor(this.mMaxIterations.getEditor());
        this.mToleranceLabel = DialogUtil.createLabel(this.mParent, "IDS_MI_IMPUTE_MISSING_METHOD_TOLERANCE_LABEL");
        controlAction = new ComboboxAction(this.mParent, "IDS_MI_IMPUTE_MISSING_METHOD_TOLERANCE_LABEL");
        this.mToleranceCombo = new JComboBox();
        this.mToleranceCombo.setEditable(true);
        this.mToleranceCombo.addItemListener(this);
        this.mToleranceCombo.setAction(controlAction);
        this.mToleranceCombo.setEnabled(true);
        this.mToleranceLabel.setLabelFor(this.mModelTypeCombo);
    }

    private boolean doValidation() {
        try {
            if (this.mFullyConditionRadio.isSelected() && this.mFullyConditionRadio.isEnabled()) {
                String string = ((JTextField)this.mMaxIterations.getEditor()).getText();
                String string2 = null;
                if (string.length() == 0) {
                    string2 = this.getResString("ERR_MI_IMPUTE_MISSING_METHOD_MESG1");
                } else if (Integer.parseInt(string) == 0) {
                    string2 = this.getResString("ERR_MI_IMPUTE_MISSING_METHOD_MESG2");
                }
                if (string2 != null) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, string2, VersionInfo.getAppVersionString());
                    this.mMaxIterations.getEditor().requestFocusInWindow();
                    ImputeMissingDataDlg.setSelectionText(this.mMaxIterations.getEditor());
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

