/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.multiple_imputation.impute_missing_data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.CoreFrequencies;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.server.messages.sysfilemsg.ObsVecMap;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.FrequenciesScanner;
import com.spss.java_client.ui.dialogs.common.IFrequencyScannerListener;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.multiple_imputation.impute_missing_data.ImputeMissingDataDlg;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.controls.TypeAheadCombo;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class MIConstraintsTab
extends BaseProcedureTab
implements ItemListener,
IFrequencyScannerListener,
ActionListener {
    static final String LIMIT_NUMBER_CASES_SCANNED = "IDS_MI_CONSTRAINTS_CASES_TO_SCANN";
    static final String DISPLAY_CASE_FIELD = "IDS_MI_CONSTRAINTS_DISPLAY_CASE_FIELD";
    static final String MAX_PERCENT_MISSING = "IDS_MI_CONSTRAINTS_MAX_PERCENT_MISSING_KEY";
    static final String MAX_CASE_DRAW_VALUE = "IDS_MI_CONSTRAINTS_MAX_CASE_DRAW_VALUE";
    static final String MAX_PARAM_DRAW_VALUE = "IDS_MI_CONSTRAINTS_MAX_PARAMETER_DRAW_VALUE";
    private JButton mScanData;
    private JCheckBox mLimitCaseScanned;
    private JLabel mScannedCasesLabel;
    private IntTextField mScannedCasesField;
    private JLabel mVariableSummaryTableLabel;
    private JLabel mDisplayCasesLabel;
    private JLabel mDisplayCasesField;
    private PlainTable mVariableSummaryTable;
    private DefaultTableModel mVariableSummaryModel;
    private AnalysisVariableCellRenderer mVarRenderer;
    private AnalysisVariableEditor mVarEditor;
    private Vector<String> mSummaryHeaderNames = new Vector();
    private PlainTable mDefineConstraintTable;
    private DefaultTableModel mDefineConstraintModel;
    private Vector<String> mConstraintHeaderNames = new Vector();
    private String[] mRoleArray;
    private VariableFloatFieldRender mFloatFieldRender;
    private JLabel mDefineConstraintsTableLabel;
    private JCheckBox mExcludeVariables;
    private JLabel mMaxPercentMissing;
    private FloatTextField mMaxPcentField;
    private JLabel mMaxCasesDrawLabel;
    private NumberSpinner mMaxCasesDraw;
    private JLabel mMaxParamDrawLabel;
    private NumberSpinner mMaxParamDraw;
    private JTextArea mMessage;
    private HashMap<ISpssVariable, ScannedVarListVar> mSummaryVarMap = new HashMap();
    private HashMap<ISpssVariable, ScannedVarListVar> mConstraintVarMap = new HashMap();
    private long mCasesScanned = 0L;
    private CoreFrequencies mCoreFrequencies = new CoreFrequencies();
    private DialogDataModel mDialogDataModel;
    private Vector<ISpssVariable> mVarsToBeDeleted = new Vector();
    private Vector<ISpssVariable> mVarsToBeAddeded = new Vector();
    private boolean mInRender = false;
    private DisplayTableRenderer mSummaryTableRender = new DisplayTableRenderer();

    public MIConstraintsTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initialize();
        this.setTabThroughCells(true);
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mScanData;
    }

    @Override
    public void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        this.mDialogDataModel = dialogDataModel;
        if (this.mDialogDataModel != null) {
            Object object = this.mDialogDataModel.getObject("IDS_MI_IMPUTE_MISSING_SUMMARY_VARIABLE_MAP_DATA");
            if (object != null) {
                this.mSummaryVarMap = (HashMap)object;
            }
            if ((object = this.mDialogDataModel.getString("IDS_MI_IMPUTE_MISSING_SCANNED_CASES")) != null && !((String)object).equals("none")) {
                this.mCasesScanned = Long.parseLong((String)object);
            }
            if ((object = this.mDialogDataModel.getString(MAX_CASE_DRAW_VALUE)) != null) {
                ((JTextField)this.mMaxCasesDraw.getEditor()).setText((String)object);
            }
            if ((object = this.mDialogDataModel.getString(MAX_PARAM_DRAW_VALUE)) != null) {
                ((JTextField)this.mMaxParamDraw.getEditor()).setText((String)object);
            }
            this.loadTable();
            this.enableSpinner("");
        }
    }

    @Override
    public void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        Vector<Vector> vector = this.mVariableSummaryModel.getDataVector();
        dialogDataModel.putObject("IDS_MI_IMPUTE_MISSING_VARIABLE_SUMMARY", vector);
        Vector<Vector> vector2 = this.mDefineConstraintModel.getDataVector();
        dialogDataModel.putObject("IDS_MI_IMPUTE_MISSING_CONSTRIANTS", vector2);
        dialogDataModel.putObject("IDS_MI_IMPUTE_MISSING_SUMMARY_VARIABLE_MAP_DATA", this.mSummaryVarMap);
        dialogDataModel.putString("IDS_MI_IMPUTE_MISSING_SCANNED_CASES", this.mDisplayCasesField.getText());
        dialogDataModel.putString(MAX_CASE_DRAW_VALUE, ((JTextField)this.mMaxCasesDraw.getEditor()).getText());
        dialogDataModel.putString(MAX_PARAM_DRAW_VALUE, ((JTextField)this.mMaxParamDraw.getEditor()).getText());
    }

    @Override
    public void finishedScanning(CoreFrequencies coreFrequencies) {
        this.getFreqTable(coreFrequencies);
        this.updateSummaryTable(true);
        this.mDisplayCasesField.setText(Long.toString(this.mCasesScanned));
        this.mScanData.setText(this.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_RESCAN_DATA_BUTTON"));
    }

    boolean isALLPredictorOnly() {
        Object object;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mDefineConstraintTable.getModel();
        Vector<Vector> vector = defaultTableModel.getDataVector();
        int n = defaultTableModel.getColumnCount();
        int n2 = defaultTableModel.getRowCount();
        boolean bl = true;
        int n3 = -1;
        int n4 = 0;
        for (n4 = 0; n4 < n2; ++n4) {
            object = vector.get(n4);
            String string = ((Vector)object).get(1).toString();
            if (!string.equals(this.mRoleArray[2])) {
                bl = false;
                continue;
            }
            if (n3 >= 0) continue;
            n3 = n4;
        }
        if (bl && n3 >= 0) {
            object = this.getResString("ERR_MI_IMPUTE_CONSTRAINTS_MISSING_WARNING3");
            SpssAlertOptionPane.showWarningMessageDialog(this, (String)object, VersionInfo.getAppVersionString());
            this.changeSelection(n3, 1, false);
        }
        return bl && n2 > 0;
    }

    @Override
    protected boolean validateTab() {
        Object object;
        Object object2;
        Object object3;
        if (this.mDefineConstraintTable.isEditing()) {
            this.mDefineConstraintTable.getCellEditor().stopCellEditing();
        }
        if (this.isALLPredictorOnly()) {
            return false;
        }
        if (this.mMaxCasesDraw.getEditor().isEnabled()) {
            object3 = ((JTextField)this.mMaxCasesDraw.getEditor()).getText();
            boolean bl = true;
            String string = "";
            if (((String)object3).length() == 0 || Integer.parseInt((String)object3) == 0) {
                string = this.getResString("ERR_MI_IMPUTE_CONSTRAINTS_MISSING_WARNING6");
                bl = false;
            }
            if (string.length() == 0 && (((String)(object3 = ((JTextField)this.mMaxParamDraw.getEditor()).getText())).length() == 0 || Integer.parseInt((String)object3) == 0)) {
                string = this.getResString("ERR_MI_IMPUTE_CONSTRAINTS_MISSING_WARNING6");
            }
            if (string.length() > 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, string, VersionInfo.getAppVersionString());
                if (!bl) {
                    ImputeMissingDataDlg.setSelectionText(this.mMaxCasesDraw.getEditor());
                } else {
                    ImputeMissingDataDlg.setSelectionText(this.mMaxParamDraw.getEditor());
                }
                return false;
            }
        }
        object3 = (DefaultTableModel)this.mDefineConstraintTable.getModel();
        Vector<Vector> vector = ((DefaultTableModel)object3).getDataVector();
        int n = ((DefaultTableModel)object3).getRowCount();
        int n2 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = -1;
        for (n2 = 0; n2 < n; ++n2) {
            OBS oBS;
            object2 = vector.get(n2);
            object = (ISpssVariable)((Vector)object2).get(0);
            string = ((Vector)object2).get(2).toString();
            string2 = ((Vector)object2).get(3).toString();
            String string4 = "";
            if (string.length() > 0) {
                if (object.getFormat().getFormatType().isDateOrTimeFormat()) {
                    oBS = new OBS();
                    if (this.isMinMaxValueValid((ISpssVariable)object, string, oBS)) {
                        d = oBS.getNum();
                    } else {
                        n3 = 2;
                        string4 = this.getResString("ERR_MI_IMPUTE_CONSTRAINTS_MISSING_WARNING7");
                    }
                } else {
                    d = this.getDoubleValue(string);
                    if (d == Double.MAX_VALUE) {
                        n3 = 2;
                        string4 = this.getResString("ERR_MI_IMPUTE_CONSTRAINTS_MISSING_WARNING7");
                    }
                }
            }
            if (string4.length() == 0 && string2.length() > 0) {
                if (object.getFormat().getFormatType().isDateOrTimeFormat()) {
                    oBS = new OBS();
                    if (this.isMinMaxValueValid((ISpssVariable)object, string2, oBS)) {
                        d2 = oBS.getNum();
                    } else {
                        n3 = 3;
                        string4 = this.getResString("ERR_MI_IMPUTE_CONSTRAINTS_MISSING_WARNING7");
                    }
                } else {
                    d2 = this.getDoubleValue(string2);
                    if (d2 == Double.MAX_VALUE) {
                        n3 = 3;
                        string4 = this.getResString("ERR_MI_IMPUTE_CONSTRAINTS_MISSING_WARNING7");
                    }
                }
            }
            if (string4.length() > 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, string4, VersionInfo.getAppVersionString());
                this.changeSelection(n2, n3, false);
                return false;
            }
            if (string.length() > 0 && string2.length() > 0 && d >= d2) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_MI_IMPUTE_CONSTRAINTS_MISSING_WARNING4"), VersionInfo.getAppVersionString());
                this.changeSelection(n2, 2, false);
                return false;
            }
            string3 = ((Vector)object2).get(4).toString();
            if (string3.length() > 0 && (d3 = this.getDoubleValue(string3)) == Double.MAX_VALUE) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_MI_IMPUTE_CONSTRAINTS_MISSING_WARNING7"), VersionInfo.getAppVersionString());
                this.changeSelection(n2, 4, true);
                return false;
            }
            if (string3.length() <= 0 || d3 != 0.0) continue;
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_MI_IMPUTE_CONSTRAINTS_MISSING_WARNING5"), VersionInfo.getAppVersionString());
            this.changeSelection(n2, 4, false);
            return false;
        }
        if (this.mMaxPcentField.isEnabled()) {
            object2 = this.mMaxPcentField.getText();
            object = "";
            if (((String)object2).length() == 0) {
                object = this.getResString("ERR_MI_IMPUTE_CONSTRAINTS_MISSING_WARNING1");
            } else {
                try {
                    double d4 = Double.parseDouble((String)object2);
                    if (d4 == 0.0 || d4 >= 100.0) {
                        object = this.getResString("ERR_MI_IMPUTE_CONSTRAINTS_MISSING_WARNING2");
                    }
                }
                catch (Exception exception) {
                    this.mMaxPcentField.setText("");
                    object = this.getResString("ERR_MI_IMPUTE_CONSTRAINTS_MISSING_WARNING2");
                }
            }
            if (((String)object).length() > 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, (String)object, VersionInfo.getAppVersionString());
                ImputeMissingDataDlg.setSelectionText((JComponent)this.mMaxPcentField);
                return false;
            }
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mExcludeVariables) {
            if (itemEvent.getStateChange() == 2) {
                this.mMaxPercentMissing.setEnabled(false);
                this.mMaxPcentField.setEnabled(false);
            } else {
                this.mMaxPercentMissing.setEnabled(true);
                this.mMaxPcentField.setEnabled(true);
            }
        }
        if (object == this.mLimitCaseScanned) {
            if (itemEvent.getStateChange() == 2) {
                this.mScannedCasesLabel.setEnabled(false);
                this.mScannedCasesField.setEnabled(false);
            } else {
                this.mScannedCasesLabel.setEnabled(true);
                this.mScannedCasesField.setEnabled(true);
            }
        }
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_MI_CONSTRAINTS";
    }

    public String getConstraintTabSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("");
        ISpssVariable iSpssVariable = null;
        OBS oBS = new OBS();
        Object object = dialogDataModel.getObject("IDS_MI_IMPUTE_MISSING_CONSTRIANTS");
        if (object != null) {
            Vector vector = (Vector)object;
            for (int i = 0; i < vector.size(); ++i) {
                Vector vector2 = (Vector)vector.get(i);
                iSpssVariable = (ISpssVariable)vector2.get(0);
                String string = iSpssVariable.getName();
                String string2 = vector2.get(1).toString();
                StringBuffer stringBuffer2 = new StringBuffer("");
                boolean bl = iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat();
                if (!string2.equals(this.mRoleArray[2])) {
                    if (iSpssVariable.getMeasurementLevel() == MeasurementLevel.scale && ((ImputeMissingDataDlg)this.mParent).getMethodTab().isLinearModel()) {
                        String string3 = UIToolResUtil.removeLocale((String)vector2.get(2).toString());
                        if (string3.length() > 0) {
                            if (bl) {
                                CellValueFormatter.stringToObs((String)string3, (SPSS_Format)iSpssVariable.getFormat(), (OBS)oBS);
                                string3 = "'" + CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)iSpssVariable.getFormat()) + "'";
                            }
                            stringBuffer2.append(" MIN=").append(string3);
                        }
                        if ((string3 = UIToolResUtil.removeLocale((String)vector2.get(3).toString())).length() > 0) {
                            if (bl) {
                                CellValueFormatter.stringToObs((String)string3, (SPSS_Format)iSpssVariable.getFormat(), (OBS)oBS);
                                string3 = "'" + CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)iSpssVariable.getFormat()) + "'";
                            }
                            stringBuffer2.append(" MAX=").append(string3);
                        }
                        if ((string3 = vector2.get(4).toString()).length() > 0) {
                            stringBuffer2.append(" RND=").append(string3);
                        }
                    }
                    if (string2.equals(this.mRoleArray[1])) {
                        stringBuffer2.append(" ROLE=DEP");
                    }
                } else {
                    stringBuffer2.append(" ROLE=IND");
                }
                if (stringBuffer2.length() <= 0) continue;
                stringBuffer.append("\n  /CONSTRAINTS ").append(string).append("(");
                stringBuffer.append(stringBuffer2);
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    public String getImputeSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("MAXPCTMISSING=");
        Boolean bl = dialogDataModel.getBoolean("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_EXCLUDE_VARIABLES_CHECK");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(this.mMaxPcentField.getText() + " ");
        } else {
            stringBuffer.append("NONE ");
        }
        if (this.mMaxCasesDraw.isEnabled()) {
            stringBuffer.append(" MAXCASEDRAWS=").append(((JTextField)this.mMaxCasesDraw.getEditor()).getText());
        }
        if (this.mMaxParamDraw.isEnabled()) {
            stringBuffer.append(" MAXPARAMDRAWS=").append(((JTextField)this.mMaxParamDraw.getEditor()).getText());
        }
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        Vector vector = new Vector();
        this.mVariableSummaryModel.setDataVector(vector, this.mSummaryHeaderNames);
        this.mDefineConstraintModel.setDataVector(vector, this.mConstraintHeaderNames);
        this.mDialogDataModel.putObject("IDS_MI_IMPUTE_MISSING_VARIABLE_SUMMARY", null);
        this.mDialogDataModel.putObject("IDS_MI_IMPUTE_MISSING_CONSTRIANTS", null);
        this.setDefaults();
        this.loadTable();
        this.setupColumnWidths();
        this.mDefineConstraintTable.validate();
        this.mDefineConstraintTable.repaint();
        this.mVariableSummaryTable.validate();
        this.mVariableSummaryTable.repaint();
    }

    void updateTables() {
        VarListModel varListModel = ((ImputeMissingDataDlg)this.mParent).getVariablesTab().getAnalysisVariableListModel();
        if (this.mSummaryVarMap.size() == 0 || this.mSummaryVarMap.size() > 0 && this.isAnalysisVarListChanged()) {
            this.mSummaryVarMap = new HashMap();
            for (int i = 0; i < varListModel.getSize(); ++i) {
                ISpssVariable iSpssVariable = varListModel.getElementAt(i);
                this.mSummaryVarMap.put(iSpssVariable, new ScannedVarListVar(iSpssVariable));
            }
            this.mCasesScanned = 0L;
        }
        this.updateSummaryTable(false);
        this.updateConstraintsTable();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.mInRender && actionEvent.getSource().getClass() == TypeAheadCombo.class) {
            Vector vector;
            int n = this.mDefineConstraintTable.getEditingRow();
            if (((ImputeMissingDataDlg)this.mParent).getMethodTab().isLinearModel() && this.mDefineConstraintModel.getDataVector().size() > n && this.mDefineConstraintModel.getDataVector().get(n) != null && (vector = this.mDefineConstraintModel.getDataVector().get(n)).size() > 4) {
                String string;
                ISpssVariable iSpssVariable = (ISpssVariable)vector.get(0);
                boolean bl = iSpssVariable.getMeasurementLevel() == MeasurementLevel.scale;
                Object object = this.mDefineConstraintTable.getCellEditor().getCellEditorValue();
                String string2 = string = object != null ? object.toString() : "";
                if (bl && string.equals(this.mRoleArray[2])) {
                    vector.setElementAt("", 2);
                    vector.setElementAt("", 3);
                    vector.setElementAt("", 4);
                    this.enableSpinner("");
                    this.mDefineConstraintModel.fireTableRowsUpdated(n, n);
                }
                this.mDefineConstraintTable.repaint(100L);
            }
        }
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        VarListModel varListModel = ((ImputeMissingDataDlg)this.mParent).getVariablesTab().getAnalysisVariableListModel();
        this.loadTable();
        if (this.mSummaryVarMap.size() == 0 || this.mSummaryVarMap.size() > 0 && this.isAnalysisVarListChanged()) {
            this.mSummaryVarMap = new HashMap();
            for (int i = 0; i < varListModel.getSize(); ++i) {
                ISpssVariable iSpssVariable = varListModel.getElementAt(i);
                this.mSummaryVarMap.put(iSpssVariable, new ScannedVarListVar(iSpssVariable));
            }
            this.mCasesScanned = 0L;
        }
        this.updateSummaryTable(false);
        if (this.mCasesScanned > 0L) {
            this.mDisplayCasesField.setText(Long.toString(this.mCasesScanned));
        } else {
            this.mDisplayCasesField.setText("none");
        }
        this.updateConstraintsTable();
        this.setupColumnWidths();
        this.enableSpinner("");
        this.setFocusTraversalPolicy();
    }

    private void initialize() {
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, n2, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, this.setupScanDataPanel(), gridBagConstraints, 0, 0, 2, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mDefineConstraintTable, 20, 31);
        this.mDefineConstraintsTableLabel.setLabelFor(this.mDefineConstraintTable);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 2, n2);
        DialogUtil.addUsingGBL(this, this.mDefineConstraintsTableLabel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        jScrollPane.setMinimumSize(new Dimension(jScrollPane.getPreferredSize().width, 100));
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, 100));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(2, n2, 2, n2);
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, this.mExcludeVariables, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(2, n2 * 5, 2, n2);
        DialogUtil.addUsingGBL(this, this.mMaxPercentMissing, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(2, n2, 2, n2);
        DialogUtil.addUsingGBL(this, (JComponent)this.mMaxPcentField, gridBagConstraints, 1, 4, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(4, n2 + 4, 0, n2);
        DialogUtil.addUsingGBL(this, this.mMaxCasesDrawLabel, gridBagConstraints, 0, 5, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(2, n2, 2, n2);
        DialogUtil.addUsingGBL(this, (JComponent)this.mMaxCasesDraw, gridBagConstraints, 1, 5, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(4, n2 + 4, 0, n2);
        DialogUtil.addUsingGBL(this, this.mMaxParamDrawLabel, gridBagConstraints, 0, 6, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(2, n2, 2, n2);
        DialogUtil.addUsingGBL(this, (JComponent)this.mMaxParamDraw, gridBagConstraints, 1, 6, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(uRL));
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mMessage, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(2, n2, 2, n2);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 7, 2, 1, n, insets);
    }

    private JPanel setupScanDataPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_SCAN_DATA_PANEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(2, n2 - 4, 6, 2);
        DialogUtil.addUsingGBL(jPanel, this.mScanData, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(2, n2, 6, n2);
        DialogUtil.addUsingGBL(jPanel, this.mLimitCaseScanned, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(6, n2, 2, n2 - 6);
        DialogUtil.addUsingGBL(jPanel, this.mScannedCasesLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        insets.set(6, n2 - 6, 4, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mScannedCasesField, gridBagConstraints, 3, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mVariableSummaryTable, 20, 31);
        this.mVariableSummaryTableLabel.setLabelFor(this.mVariableSummaryTable);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(6, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mVariableSummaryTableLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        jScrollPane.setMinimumSize(new Dimension(jScrollPane.getPreferredSize().width, 100));
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, 100));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(0, n2, 2, n2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 2, 4, 1, n, insets);
        insets.set(2, n2, 2, -n2 * 2);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayCasesLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        insets.set(2, -n2 * 2, 2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayCasesField, gridBagConstraints, 1, 3, 1, 1, n, insets);
        return jPanel;
    }

    private Vector<Object> setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mScanData);
        vector.add(this.mLimitCaseScanned);
        vector.add(this.mScannedCasesField);
        vector.add(this.mVariableSummaryTable);
        vector.add(this.mDisplayCasesField);
        vector.add(this.mDefineConstraintTable);
        vector.add(this.mExcludeVariables);
        vector.add(this.mMaxPercentMissing);
        vector.add(this.mMaxPcentField);
        vector.add(this.mMaxCasesDraw.getEditor());
        vector.add(this.mMaxParamDraw.getEditor());
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
        return vector;
    }

    private void setDefaults() {
        this.mLimitCaseScanned.setSelected(false);
        this.mDisplayCasesField.setText("none");
        this.mMaxCasesDrawLabel.setEnabled(false);
        this.mMaxCasesDraw.setEnabled(false);
        ((JTextField)this.mMaxCasesDraw.getEditor()).setText("50");
        this.mMaxCasesDraw.getEditor().setEnabled(false);
        this.mMaxParamDrawLabel.setEnabled(false);
        this.mMaxParamDraw.setEnabled(false);
        ((JTextField)this.mMaxParamDraw.getEditor()).setText("2");
        this.mMaxParamDraw.getEditor().setEnabled(false);
        this.mExcludeVariables.setSelected(false);
        this.mMaxPercentMissing.setEnabled(false);
        this.mMaxPcentField.setText("");
        this.mMaxPcentField.setEnabled(false);
        this.mScannedCasesLabel.setEnabled(false);
        this.mScannedCasesField.setEnabled(false);
        this.mScannedCasesField.setText("5000");
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MI_IMPUTE_MISSING_CONSTRAINTS_SCAN_DATA_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MIConstraintsTab.this.runScanData();
            }
        };
        this.mScanData = new JButton(toggleButtonAction);
        JButton jButton = new JButton(this.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_RESCAN_DATA_BUTTON"));
        this.mScanData.setMaximumSize(jButton.getPreferredSize());
        this.mScanData.setPreferredSize(jButton.getPreferredSize());
        this.mLimitCaseScanned = DialogUtil.createCheckBox(this.mParent, "IDS_MI_IMPUTE_MISSING_CONSTRAINTS_CASE_SCANNED_CHECK", null);
        this.mLimitCaseScanned.addItemListener(this);
        this.mScannedCasesLabel = DialogUtil.createLabel(this.mParent, "IDS_MI_IMPUTE_MISSING_CONSTRAINTS_SCANNED_CASES_LABEL");
        this.mScannedCasesField = new IntTextField(true);
        this.mScannedCasesField.setColumns(10);
        TextFieldAction textFieldAction = new TextFieldAction(this.mParent, "LIMIT_NUMBER_CASES_SCANNED");
        this.mScannedCasesField.setAction((Action)textFieldAction);
        this.mScannedCasesLabel.setLabelFor((Component)this.mScannedCasesField);
        this.mRoleArray = this.getResStringArray("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_TABLE_ROLE_ARRARY");
        this.mFloatFieldRender = new VariableFloatFieldRender();
        this.mVariableSummaryTableLabel = DialogUtil.createLabel(this.mParent, "IDS_MI_IMPUTE_MISSING_CONSTRAINTS_VARIABLE_SUMMARY_LABEL");
        Vector vector = new Vector();
        this.mSummaryHeaderNames.add(this.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_TABLE_HEADER_VARIABLE"));
        this.mSummaryHeaderNames.add(this.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_TABLE_HEADER_PERCENT_MISSING"));
        this.mSummaryHeaderNames.add(this.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_TABLE_HEADER_OBSERVED_MIN"));
        this.mSummaryHeaderNames.add(this.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_TABLE_HEADER_OBSERVED_MAX"));
        this.mVariableSummaryModel = new DefaultTableModel(vector, this.mSummaryHeaderNames){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.mVariableSummaryTable = new PlainTable(this.mVariableSummaryModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                return MIConstraintsTab.this.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_SUMMARY_TOOLTIP_TEXT");
            }
        };
        this.mVariableSummaryTable.setPreferredScrollableViewportSize(new Dimension(300, 100));
        this.mVariableSummaryTable.setRowHeight(22);
        this.mVariableSummaryTable.setColumnSelectionAllowed(true);
        this.mVariableSummaryTable.setRowSelectionAllowed(true);
        this.mVariableSummaryTable.getTableHeader().setReorderingAllowed(false);
        this.mVariableSummaryTable.getTableHeader().setResizingAllowed(true);
        this.mVariableSummaryTable.setGridColor(Color.darkGray);
        this.mVariableSummaryTable.getTableHeader().setReorderingAllowed(false);
        this.mVarRenderer = new AnalysisVariableCellRenderer();
        this.mVarEditor = new AnalysisVariableEditor();
        JTableHeader jTableHeader = this.mVariableSummaryTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = null;
                jLabel = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setHorizontalAlignment(0);
                jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                jLabel.setBackground(jTable.getTableHeader().getBackground());
                jLabel.setForeground(jTable.getTableHeader().getForeground());
                return jLabel;
            }
        });
        vector = new Vector();
        this.mConstraintHeaderNames = new Vector();
        this.mConstraintHeaderNames.add(this.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_TABLE_HEADER_VARIABLE"));
        this.mConstraintHeaderNames.add(this.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_TABLE_HEADER_VARIABLE_ROLE"));
        this.mConstraintHeaderNames.add(this.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_TABLE_HEADER_MIN"));
        this.mConstraintHeaderNames.add(this.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_TABLE_HEADER_MAX"));
        this.mConstraintHeaderNames.add(this.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_TABLE_HEADER_ROUNDING"));
        this.mDefineConstraintModel = new DefaultTableModel(vector, this.mConstraintHeaderNames){

            @Override
            public boolean isCellEditable(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        return true;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        Vector vector;
                        if (((ImputeMissingDataDlg)MIConstraintsTab.this.mParent).getMethodTab().isLinearModel() && this.dataVector.size() > n && this.dataVector.get(n) != null && (vector = (Vector)this.dataVector.get(n)).size() > n2) {
                            String string;
                            ISpssVariable iSpssVariable = (ISpssVariable)vector.get(0);
                            boolean bl = iSpssVariable.getMeasurementLevel() == MeasurementLevel.scale;
                            String string2 = string = MIConstraintsTab.this.mDefineConstraintTable.isEditing() && n == MIConstraintsTab.this.mDefineConstraintTable.getEditingRow() ? MIConstraintsTab.this.mDefineConstraintTable.getCellEditor().getCellEditorValue().toString() : vector.get(1).toString();
                            if (bl && !string.equals(MIConstraintsTab.this.mRoleArray[2])) {
                                return true;
                            }
                        }
                        return false;
                    }
                }
                return false;
            }
        };
        this.mDefineConstraintTable = new PlainTable(this.mDefineConstraintModel){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                Component component = this.getEditorComponent();
                if (component != null && component instanceof FloatTextField && component.isEnabled()) {
                    final FloatTextField floatTextField = (FloatTextField)component;
                    if (eventObject == null) {
                        ImputeMissingDataDlg.setSelectionText((JComponent)floatTextField);
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ImputeMissingDataDlg.setSelectionText((JComponent)floatTextField);
                            }
                        });
                    }
                }
                return bl;
            }
        };
        this.mDefineConstraintTable.setFocusable(true);
        this.mDefineConstraintTable.setPreferredScrollableViewportSize(new Dimension(300, 100));
        this.mDefineConstraintTable.setRowHeight(22);
        this.mDefineConstraintTable.setColumnSelectionAllowed(true);
        this.mDefineConstraintTable.setRowSelectionAllowed(true);
        this.mDefineConstraintTable.setCellSelectionEnabled(true);
        this.mDefineConstraintTable.getTableHeader().setReorderingAllowed(false);
        this.mDefineConstraintTable.getTableHeader().setResizingAllowed(true);
        this.mDefineConstraintTable.setGridColor(Color.darkGray);
        this.mDefineConstraintTable.getTableHeader().setReorderingAllowed(false);
        JTableHeader jTableHeader2 = this.mDefineConstraintTable.getTableHeader();
        jTableHeader2.setReorderingAllowed(false);
        jTableHeader2.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = null;
                jLabel = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setHorizontalAlignment(0);
                jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                jLabel.setBackground(jTable.getTableHeader().getBackground());
                jLabel.setForeground(jTable.getTableHeader().getForeground());
                return jLabel;
            }
        });
        this.mDisplayCasesLabel = DialogUtil.createLabel(this.mParent, "IDS_MI_IMPUTE_MISSING_CONSTRAINTS_CASES_SCANNED_LABEL");
        this.mDisplayCasesField = DialogUtil.createLabel(this.mParent, "DISPLAY_CASE_FIELD");
        this.mDisplayCasesLabel.setLabelFor(this.mDisplayCasesField);
        this.mDefineConstraintsTableLabel = DialogUtil.createLabel(this.mParent, "IDS_MI_IMPUTE_MISSING_CONSTRAINTS_DEFINE_CONSTRAINTS_LABEL");
        this.mExcludeVariables = DialogUtil.createCheckBox(this.mParent, "IDS_MI_IMPUTE_MISSING_CONSTRAINTS_EXCLUDE_VARIABLES_CHECK", null);
        this.mExcludeVariables.addItemListener(this);
        this.mMaxPercentMissing = DialogUtil.createLabel(this.mParent, "IDS_MI_IMPUTE_MISSING_CONSTRAINTS_MAX_PERCENT_MISSING_LABEL");
        this.mMaxPcentField = new FloatTextField(0.0, 100.0, 2, true);
        this.mMaxPcentField.setColumns(8);
        textFieldAction = new TextFieldAction(this.mParent, "MAX_PERCENT_MISSING");
        this.mMaxPcentField.setAction((Action)textFieldAction);
        this.mMaxPercentMissing.setLabelFor((Component)this.mMaxPcentField);
        this.mMaxCasesDrawLabel = DialogUtil.createLabel(this.mParent, "IDS_MI_IMPUTE_MISSING_CONSTRAINTS_MAX_CASES_TO_DRAW_LABEL");
        this.mMaxCasesDraw = new NumberSpinner(50, Integer.MIN_VALUE, Integer.MAX_VALUE, true, 1);
        this.mMaxCasesDrawLabel.setLabelFor(this.mMaxCasesDraw.getEditor());
        this.mMaxParamDrawLabel = DialogUtil.createLabel(this.mParent, "IDS_MI_IMPUTE_MISSING_CONSTRAINTS_MAX_PARAM_LABEL");
        this.mMaxParamDraw = new NumberSpinner(2, Integer.MIN_VALUE, Integer.MAX_VALUE, true, 1);
        ((IntTextField)this.mMaxParamDraw.getEditor()).setColumns(12);
        this.mMaxParamDrawLabel.setLabelFor(this.mMaxParamDraw.getEditor());
        this.mMessage = new JTextArea();
        this.mMessage.setRows(1);
        this.mMessage.setOpaque(false);
        this.mMessage.setFont(this.mMaxParamDrawLabel.getFont());
        this.mMessage.setLineWrap(true);
        this.mMessage.setWrapStyleWord(true);
        this.mMessage.setText(this.getResString("IDK_MI_IMPUTE_MISSING_CONSTRAINTS_MESSAGE"));
        this.mMessage.setFocusable(false);
    }

    private void loadTable() {
        VarListModel varListModel = ((ImputeMissingDataDlg)this.mParent).getVariablesTab().getAnalysisVariableListModel();
        Vector vector = null;
        Vector vector2 = null;
        if (this.mDialogDataModel != null) {
            Object object = this.mDialogDataModel.getObject("IDS_MI_IMPUTE_MISSING_VARIABLE_SUMMARY");
            vector = object != null ? (Vector)object : new Vector();
            object = this.mDialogDataModel.getObject("IDS_MI_IMPUTE_MISSING_CONSTRIANTS");
            vector2 = object != null ? (Vector)object : new Vector();
        } else {
            vector = new Vector();
            vector2 = new Vector();
        }
        boolean bl = vector2.size() == 0 && vector.size() == 0;
        boolean bl2 = false;
        for (int i = 0; i < varListModel.getSize() && bl; ++i) {
            Vector<Object> vector3 = new Vector<Object>();
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            if (!bl2 && iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat()) {
                bl2 = true;
            }
            vector3.add(iSpssVariable);
            vector3.add("");
            vector3.add("");
            vector3.add("");
            vector.add(vector3);
            vector3 = new Vector();
            vector3.add(iSpssVariable);
            vector3.add(this.mRoleArray[0]);
            vector3.add("");
            vector3.add("");
            vector3.add("");
            vector2.add(vector3);
        }
        if (vector.size() > 0) {
            this.mVariableSummaryModel.setDataVector(vector, this.mSummaryHeaderNames);
            this.mVariableSummaryTable.setModel(this.mVariableSummaryModel);
            this.mVariableSummaryTable.getColumnModel().getColumn(0).setCellRenderer(this.mVarRenderer);
            this.mVariableSummaryTable.getColumnModel().getColumn(0).setCellEditor(this.mVarEditor);
            this.mVariableSummaryTable.getColumnModel().getColumn(1).setCellRenderer(this.mSummaryTableRender);
            this.mVariableSummaryTable.getColumnModel().getColumn(2).setCellRenderer(this.mSummaryTableRender);
            this.mVariableSummaryTable.getColumnModel().getColumn(3).setCellRenderer(this.mSummaryTableRender);
            this.mDefineConstraintModel.setDataVector(vector2, this.mConstraintHeaderNames);
            this.mDefineConstraintTable.setModel(this.mDefineConstraintModel);
            this.mDefineConstraintTable.getColumnModel().getColumn(0).setCellRenderer(new AnalysisVariableCellRenderer());
            this.mDefineConstraintTable.getColumnModel().getColumn(0).setCellEditor(new AnalysisVariableEditor());
            this.mDefineConstraintTable.getColumnModel().getColumn(1).setCellEditor(new VariableRoleComboEditor(1));
            this.mDefineConstraintTable.getColumnModel().getColumn(1).setCellRenderer(new VarRoleComboBoxRenderer(this.mRoleArray));
            this.mDefineConstraintTable.getColumnModel().getColumn(2).setCellRenderer(new VariableFloatFieldRender());
            this.mDefineConstraintTable.getColumnModel().getColumn(2).setCellEditor(new VariableFloatFieldEditor(2, bl2));
            this.mDefineConstraintTable.getColumnModel().getColumn(3).setCellRenderer(new VariableFloatFieldRender());
            this.mDefineConstraintTable.getColumnModel().getColumn(3).setCellEditor(new VariableFloatFieldEditor(3, bl2));
            this.mDefineConstraintTable.getColumnModel().getColumn(4).setCellRenderer(new VariableFloatFieldRender());
            this.mDefineConstraintTable.getColumnModel().getColumn(4).setCellEditor(new VariableFloatFieldEditor(4, bl2));
        } else {
            this.mVariableSummaryTable.setModel(this.mVariableSummaryModel);
            this.mDefineConstraintTable.setModel(this.mDefineConstraintModel);
        }
    }

    private boolean updateSummaryTable(boolean bl) {
        VarListModel varListModel = ((ImputeMissingDataDlg)this.mParent).getVariablesTab().getAnalysisVariableListModel();
        Vector vector = new Vector();
        boolean bl2 = false;
        for (int i = 0; i < varListModel.getSize() && i < this.mSummaryVarMap.size(); ++i) {
            Vector<Object> vector2 = new Vector<Object>();
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            vector2.add(iSpssVariable);
            ScannedVarListVar scannedVarListVar = this.mSummaryVarMap.get(iSpssVariable);
            if (!bl2 && scannedVarListVar.getMissingVals().length() > 0) {
                bl2 = true;
            }
            vector2.add(scannedVarListVar.getMissingVals());
            if (iSpssVariable.getFormat().getFormatType().isStringFormat()) {
                vector2.add("-");
                vector2.add("-");
            } else {
                double d = scannedVarListVar.getMinVal();
                if (d == Double.MIN_VALUE) {
                    vector2.add("");
                } else {
                    vector2.add(CellValueFormatter.obsToString((OBS)new OBS(d), (SPSS_Format)scannedVarListVar.getSpssVar().getFormat()));
                }
                d = scannedVarListVar.getMaxVal();
                if (d == Double.MAX_VALUE) {
                    vector2.add("");
                } else {
                    vector2.add(CellValueFormatter.obsToString((OBS)new OBS(d), (SPSS_Format)scannedVarListVar.getSpssVar().getFormat()));
                }
            }
            vector.add(vector2);
        }
        this.mVariableSummaryModel.setDataVector(vector, this.mSummaryHeaderNames);
        if (bl) {
            this.mVariableSummaryModel.fireTableDataChanged();
        }
        this.mVariableSummaryTable.setModel(this.mVariableSummaryModel);
        this.mVariableSummaryTable.getColumnModel().getColumn(0).setCellRenderer(this.mVarRenderer);
        this.mVariableSummaryTable.getColumnModel().getColumn(0).setCellEditor(this.mVarEditor);
        this.mVariableSummaryTable.getColumnModel().getColumn(1).setCellRenderer(this.mSummaryTableRender);
        this.mVariableSummaryTable.getColumnModel().getColumn(2).setCellRenderer(this.mSummaryTableRender);
        this.mVariableSummaryTable.getColumnModel().getColumn(3).setCellRenderer(this.mSummaryTableRender);
        return bl2;
    }

    private void updateConstraintsTable() {
        boolean bl = this.mVarsToBeAddeded.size() > 0;
        this.mConstraintVarMap.clear();
        ISpssVariable iSpssVariable = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl2 = false;
        for (int i = 0; i < this.mDefineConstraintTable.getModel().getRowCount(); ++i) {
            iSpssVariable = (ISpssVariable)this.mDefineConstraintTable.getModel().getValueAt(i, 0);
            if (!this.mSummaryVarMap.containsKey(iSpssVariable)) {
                this.mDefineConstraintModel.removeRow(i);
                continue;
            }
            block7: for (int j = 1; j < this.mDefineConstraintTable.getModel().getColumnCount(); ++j) {
                switch (j) {
                    case 1: {
                        string = this.mDefineConstraintTable.getModel().getValueAt(i, j).toString();
                        continue block7;
                    }
                    case 2: {
                        string2 = this.mDefineConstraintTable.getModel().getValueAt(i, j).toString();
                        continue block7;
                    }
                    case 3: {
                        string3 = this.mDefineConstraintTable.getModel().getValueAt(i, j).toString();
                        continue block7;
                    }
                    case 4: {
                        if (this.mDefineConstraintTable.getModel().getValueAt(i, j) == null) continue block7;
                        string4 = this.mDefineConstraintTable.getModel().getValueAt(i, j).toString();
                    }
                }
            }
            this.mConstraintVarMap.put(iSpssVariable, new ScannedVarListVar(iSpssVariable, string, string2, string3, string4));
        }
        VarListModel varListModel = ((ImputeMissingDataDlg)this.mParent).getVariablesTab().getAnalysisVariableListModel();
        Vector vector = new Vector();
        boolean bl3 = false;
        for (int i = 0; i < varListModel.getSize(); ++i) {
            Vector<Object> vector2 = new Vector<Object>();
            iSpssVariable = varListModel.getElementAt(i);
            vector2.add(iSpssVariable);
            bl3 = iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat();
            if (!bl2 && bl3) {
                bl2 = true;
            }
            if (this.mConstraintVarMap.containsKey(iSpssVariable)) {
                ScannedVarListVar scannedVarListVar = this.mConstraintVarMap.get(iSpssVariable);
                vector2.add(scannedVarListVar.getSelectedRole());
                double d = scannedVarListVar.getMinVal();
                if (d != Double.MIN_VALUE) {
                    if (bl3) {
                        vector2.add(CellValueFormatter.obsToString((OBS)new OBS(d), (SPSS_Format)iSpssVariable.getFormat()));
                    } else {
                        vector2.add(d);
                    }
                } else {
                    vector2.add("");
                }
                d = scannedVarListVar.getMaxVal();
                if (d != Double.MAX_VALUE) {
                    if (bl3) {
                        vector2.add(CellValueFormatter.obsToString((OBS)new OBS(d), (SPSS_Format)iSpssVariable.getFormat()));
                    } else {
                        vector2.add(d);
                    }
                } else {
                    vector2.add("");
                }
                vector2.add(scannedVarListVar.getRounding());
            } else {
                vector2.add(this.mRoleArray[0]);
                vector2.add("");
                vector2.add("");
                vector2.add("");
            }
            vector.add(vector2);
        }
        this.mDefineConstraintModel.setDataVector(vector, this.mConstraintHeaderNames);
        this.mDefineConstraintTable.setModel(this.mDefineConstraintModel);
        this.mDefineConstraintTable.getColumnModel().getColumn(0).setCellRenderer(new AnalysisVariableCellRenderer());
        this.mDefineConstraintTable.getColumnModel().getColumn(0).setCellEditor(new AnalysisVariableEditor());
        this.mDefineConstraintTable.getColumnModel().getColumn(1).setCellEditor(new VariableRoleComboEditor(1));
        this.mDefineConstraintTable.getColumnModel().getColumn(1).setCellRenderer(new VarRoleComboBoxRenderer(this.mRoleArray));
        this.mDefineConstraintTable.getColumnModel().getColumn(2).setCellRenderer(new VariableFloatFieldRender());
        this.mDefineConstraintTable.getColumnModel().getColumn(2).setCellEditor(new VariableFloatFieldEditor(2, bl2));
        this.mDefineConstraintTable.getColumnModel().getColumn(3).setCellRenderer(new VariableFloatFieldRender());
        this.mDefineConstraintTable.getColumnModel().getColumn(3).setCellEditor(new VariableFloatFieldEditor(3, bl2));
        this.mDefineConstraintTable.getColumnModel().getColumn(4).setCellRenderer(new VariableFloatFieldRender());
        this.mDefineConstraintTable.getColumnModel().getColumn(4).setCellEditor(new VariableFloatFieldEditor(4, bl2));
    }

    private boolean isAnalysisVarListChanged() {
        this.mVarsToBeDeleted.clear();
        this.mVarsToBeAddeded.clear();
        VarListModel varListModel = ((ImputeMissingDataDlg)this.mParent).getVariablesTab().getAnalysisVariableListModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            if (this.mSummaryVarMap.containsKey(iSpssVariable)) continue;
            this.mVarsToBeAddeded.add(iSpssVariable);
        }
        Set<ISpssVariable> set = this.mSummaryVarMap.keySet();
        if (set != null) {
            for (ISpssVariable iSpssVariable : set) {
                if (varListModel.findElementIndex(iSpssVariable) >= 0) continue;
                this.mVarsToBeDeleted.add(iSpssVariable);
            }
        }
        return this.mVarsToBeDeleted.size() > 0 || this.mVarsToBeAddeded.size() > 0;
    }

    private void setupColumnWidths() {
        TableColumnModel tableColumnModel = this.mDefineConstraintTable.getColumnModel();
        int n = this.mDefineConstraintTable.getWidth();
        tableColumnModel.getColumn(0).setPreferredWidth((int)((double)n * 0.22));
        tableColumnModel.getColumn(1).setPreferredWidth((int)((double)n * 0.35));
        tableColumnModel.getColumn(2).setPreferredWidth((int)((double)n * 0.15));
        tableColumnModel.getColumn(3).setPreferredWidth((int)((double)n * 0.15));
        tableColumnModel.getColumn(4).setPreferredWidth((int)((double)n * 0.13));
    }

    private boolean runScanData() {
        VarListModel varListModel = ((ImputeMissingDataDlg)this.mParent).getVariablesTab().getAnalysisVariableListModel();
        if (varListModel.getSize() > 0) {
            long l = -1L;
            if (this.mLimitCaseScanned.isSelected() && this.mScannedCasesField.getText() != null && !this.mScannedCasesField.getText().equals("")) {
                l = Long.parseLong(this.mScannedCasesField.getText());
            }
            FrequenciesThread frequenciesThread = new FrequenciesThread(l);
            frequenciesThread.start();
            FrequenciesScanner frequenciesScanner = new FrequenciesScanner(this.mCoreFrequencies, this.mParent, this.getResString("IDS_MI_IMPUTE_MISSING_DATA_TITLE"));
            frequenciesScanner.registerScannerListener(this);
            frequenciesScanner.startScanning();
            return true;
        }
        return false;
    }

    private void getFreqTable(CoreFrequencies coreFrequencies) {
        int n = coreFrequencies.getVarMapCount();
        VarListModel varListModel = ((ImputeMissingDataDlg)this.mParent).getVariablesTab().getAnalysisVariableListModel();
        this.mCasesScanned = coreFrequencies.casesPassed();
        for (int i = 0; i < n; ++i) {
            ObsVecMap obsVecMap = coreFrequencies.getVariableMap(i);
            short s = (Short)obsVecMap.getKeySpec().get(0);
            TreeMap treeMap = obsVecMap.getObsMap();
            SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
            ScannedVarListVar scannedVarListVar = this.mSummaryVarMap.get(spssVariable);
            this.getNonMissingCount(treeMap, scannedVarListVar);
            int n2 = scannedVarListVar.getValMap().size();
            if (n2 <= 0 || s != 0) continue;
            double d = scannedVarListVar.getValMap().firstKey().getNum();
            double d2 = scannedVarListVar.getValMap().lastKey().getNum();
            scannedVarListVar.setMinVal(d);
            scannedVarListVar.setMaxVal(d2);
        }
    }

    private long getNonMissingCount(TreeMap<OBS, Double> treeMap, ScannedVarListVar scannedVarListVar) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = 0;
        long l = 0L;
        TreeMap<OBS, Double> treeMap2 = new TreeMap<OBS, Double>();
        for (Map.Entry<OBS, Double> entry : treeMap.entrySet()) {
            boolean bl;
            OBS oBS = entry.getKey();
            double d = entry.getValue();
            boolean bl2 = scannedVarListVar.getSpssVar().isMissing(oBS);
            boolean bl3 = bl = oBS.getNum() == iSpssDataSrc.getSystemMissing();
            if (bl2 || bl) {
                n += (int)d;
            } else {
                treeMap2.put(oBS, d);
            }
            l = (long)((double)l + d);
        }
        scannedVarListVar.setValMap(treeMap2);
        double d = (double)n / (double)l * 100.0;
        scannedVarListVar.setMissingVals(d);
        return l;
    }

    private int getUpdateInterval(long l) {
        int n = 500;
        if (l > 500000L) {
            n = 2000;
        } else if (l > 100000L) {
            n = 1000;
        }
        return n;
    }

    private void enableSpinner(String string) {
        if (string.length() > 0) {
            this.mMaxCasesDrawLabel.setEnabled(true);
            this.mMaxCasesDraw.setEnabled(true);
            this.mMaxCasesDraw.getEditor().setEnabled(true);
            this.mMaxParamDrawLabel.setEnabled(true);
            this.mMaxParamDraw.setEnabled(true);
            this.mMaxParamDraw.getEditor().setEnabled(true);
        } else {
            boolean bl = true;
            for (int i = 0; i < this.mDefineConstraintTable.getModel().getRowCount() && bl; ++i) {
                String string2 = this.mDefineConstraintTable.getModel().getValueAt(i, 2).toString();
                String string3 = this.mDefineConstraintTable.getModel().getValueAt(i, 3).toString();
                if (string2.length() <= 0 && string3.length() <= 0) continue;
                bl = false;
            }
            if (bl) {
                this.mMaxCasesDrawLabel.setEnabled(false);
                this.mMaxCasesDraw.setEnabled(false);
                this.mMaxCasesDraw.getEditor().setEnabled(false);
                this.mMaxParamDrawLabel.setEnabled(false);
                this.mMaxParamDraw.setEnabled(false);
                this.mMaxParamDraw.getEditor().setEnabled(false);
            } else if (!this.mMaxCasesDrawLabel.isEnabled()) {
                this.mMaxCasesDrawLabel.setEnabled(true);
                this.mMaxCasesDraw.setEnabled(true);
                this.mMaxCasesDraw.getEditor().setEnabled(true);
                this.mMaxParamDrawLabel.setEnabled(true);
                this.mMaxParamDraw.setEnabled(true);
                this.mMaxParamDraw.getEditor().setEnabled(true);
            }
        }
    }

    private void changeSelection(final int n, final int n2, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){
            final boolean empty;
            {
                this.empty = bl;
            }

            @Override
            public void run() {
                if (this.empty) {
                    MIConstraintsTab.this.mDefineConstraintTable.setValueAt("", n, n2);
                }
                MIConstraintsTab.this.mDefineConstraintTable.changeSelection(n, n2, false, false);
                MIConstraintsTab.this.mDefineConstraintTable.requestFocusInWindow();
            }
        });
    }

    private boolean isMinMaxValueValid(ISpssVariable iSpssVariable, String string, OBS oBS) {
        if (CellValueFormatter.stringToObs((String)string, (SPSS_Format)iSpssVariable.getFormat(), (OBS)oBS)) {
            if (iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat()) {
                if (oBS.getNum() > 0.0) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private double getDoubleValue(String string) {
        double d = Double.MAX_VALUE;
        String string2 = UIToolResUtil.removeLocale((String)string);
        try {
            d = Double.parseDouble(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    class ScannedVarListVar {
        private ISpssVariable mSpssVar;
        private double mMissingVals = Double.MIN_VALUE;
        private double mMinVal = Double.MIN_VALUE;
        private double mMaxVal = Double.MAX_VALUE;
        private TreeMap<OBS, Double> mFreqTable;
        private String mRole = "";
        private double mRounding = Double.MIN_VALUE;

        public ScannedVarListVar(ISpssVariable iSpssVariable) {
            this.mSpssVar = iSpssVariable;
        }

        public ScannedVarListVar(ISpssVariable iSpssVariable, String string, String string2, String string3, String string4) {
            this.mSpssVar = iSpssVariable;
            this.mRole = string;
            if (this.mSpssVar.getFormat().getFormatType().isDateOrTimeFormat()) {
                OBS oBS = new OBS();
                if (string2.length() > 0 && CellValueFormatter.stringToObs((String)string2, (SPSS_Format)this.mSpssVar.getFormat(), (OBS)oBS)) {
                    this.mMinVal = oBS.getNum();
                }
                if (string3.length() > 0 && CellValueFormatter.stringToObs((String)string3, (SPSS_Format)this.mSpssVar.getFormat(), (OBS)oBS)) {
                    this.mMaxVal = oBS.getNum();
                }
            } else {
                if (string2.length() > 0) {
                    this.mMinVal = MIConstraintsTab.this.getDoubleValue(string2);
                }
                if (string3.length() > 0) {
                    this.mMaxVal = MIConstraintsTab.this.getDoubleValue(string3);
                }
            }
            if (string4.length() > 0) {
                this.mRounding = MIConstraintsTab.this.getDoubleValue(string4);
            }
        }

        public double getMaxVal() {
            return this.mMaxVal;
        }

        public void setMaxVal(double d) {
            this.mMaxVal = d;
        }

        public double getMinVal() {
            return this.mMinVal;
        }

        public void setMinVal(double d) {
            this.mMinVal = d;
        }

        public String getMissingVals() {
            if (this.mMissingVals == Double.MIN_VALUE) {
                return "";
            }
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            return decimalFormat.format(this.mMissingVals);
        }

        public void setMissingVals(double d) {
            this.mMissingVals = d;
        }

        public ISpssVariable getSpssVar() {
            return this.mSpssVar;
        }

        public TreeMap<OBS, Double> getValMap() {
            return this.mFreqTable;
        }

        public void setValMap(TreeMap<OBS, Double> treeMap) {
            this.mFreqTable = treeMap;
            if (this.mFreqTable.size() > 0) {
                this.mMinVal = this.mFreqTable.firstKey().getNum();
                this.mMaxVal = this.mFreqTable.lastKey().getNum();
            }
        }

        public void setSelectedRole(String string) {
            this.mRole = string;
        }

        public String getSelectedRole() {
            return this.mRole;
        }

        public void setRounding(double d) {
            this.mRounding = d;
        }

        public String getRounding() {
            if (this.mRounding == Double.MIN_VALUE) {
                return "";
            }
            return Double.toString(this.mRounding);
        }
    }

    class FrequenciesThread
    extends Thread {
        private long mMaxCases;

        public FrequenciesThread(long l) {
            this.mMaxCases = l;
        }

        @Override
        public void run() {
            super.run();
            DataFrame dataFrame = (DataFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
            LocallyUniqueId locallyUniqueId = dataFrame.getDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            Vector<LocallyUniqueId> vector = new Vector<LocallyUniqueId>();
            VarListModel varListModel = ((ImputeMissingDataDlg)MIConstraintsTab.this.mParent).getVariablesTab().getAnalysisVariableListModel();
            int n = varListModel.getSize();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = varListModel.getElementAt(i);
                vector.add(iSpssVariable.getId());
            }
            long l = iSpssDataSrc.rowCount();
            long l2 = this.mMaxCases == -1L ? Math.min(1000000L, l) : this.mMaxCases;
            int n2 = MIConstraintsTab.this.getUpdateInterval(l2);
            MIConstraintsTab.this.mCoreFrequencies.wantWeighted(true);
            MIConstraintsTab.this.mCoreFrequencies.run(locallyUniqueId, vector, n2, this.mMaxCases);
        }
    }

    class VariableFloatFieldRender
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        VariableFloatFieldRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ISpssVariable iSpssVariable;
            Object object2;
            boolean bl3 = jTable.isCellEditable(n, n2);
            this.setBackground(jTable.getTableHeader().getBackground());
            if (bl3) {
                this.setForeground(jTable.getForeground());
                this.setOpaque(false);
            } else {
                this.setForeground(Color.gray);
                this.setOpaque(true);
            }
            if (bl2) {
                object2 = null;
                if (bl) {
                    object2 = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (object2 == null) {
                    object2 = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                this.setBorder((Border)object2);
            } else {
                this.setBorder(noFocusBorder);
            }
            this.setEnabled(bl3);
            object2 = object.toString();
            if (bl3 && ((String)object2).length() > 0 && (n2 == 2 || n2 == 3 || n2 == 4) && !(iSpssVariable = (ISpssVariable)jTable.getValueAt(n, 0)).getFormat().getFormatType().isDateOrTimeFormat()) {
                object2 = UIToolResUtil.addLocale((String)object2);
            }
            this.setText((String)object2);
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }

    class VariableFloatFieldEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    CaretListener {
        private JTextField mField;
        private int mColumn;

        VariableFloatFieldEditor(int n, boolean bl) {
            if (n == 2 || n == 3) {
                if (bl) {
                    this.mField = new StringTextField();
                    this.mField.addCaretListener(this);
                } else {
                    this.mField = new FloatTextField();
                    this.mField.addCaretListener(this);
                }
            } else if (n == 4) {
                this.mField = new FloatTextField(true);
                this.mField.addCaretListener(this);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (ComponentState.isBtdRtlOrLtr()) {
                if (ComponentState.getBTD() == 1) {
                    this.mField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                } else {
                    this.mField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                }
            }
            this.mField.setText(object.toString());
            this.mColumn = n2;
            return this.mField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mField.getText();
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            String string = this.mField.getText();
            if (this.mColumn == 2 || this.mColumn == 3) {
                MIConstraintsTab.this.enableSpinner(string);
            }
        }
    }

    public class VarRoleComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public VarRoleComboBoxRenderer(String[] stringArray) {
            super(stringArray);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl2) {
                Border border = null;
                if (bl) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                this.setBorder(border);
            } else {
                this.setBorder(null);
            }
            this.getModel().setSelectedItem(object);
            return this;
        }
    }

    class VariableRoleComboEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TypeAheadCombo mCombo = new TypeAheadCombo();

        VariableRoleComboEditor(int n) {
            if (n == 1) {
                for (String string : MIConstraintsTab.this.mRoleArray) {
                    this.mCombo.addItem((Object)string);
                }
                this.mCombo.addActionListener((ActionListener)MIConstraintsTab.this);
            } else assert (false);
            this.mCombo.setEditable(false);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object.toString().length() == 0) {
                object = null;
            }
            MIConstraintsTab.this.mInRender = true;
            this.mCombo.setSelectedItem(object);
            MIConstraintsTab.this.mInRender = false;
            return this.mCombo;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mCombo.getSelectedItem();
        }
    }

    class AnalysisVariableEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JLabel mVarLabel = new JLabel();
        private ISpssVariable mSpssVar;

        AnalysisVariableEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.mSpssVar;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            boolean bl2 = object instanceof ISpssVariable;
            boolean bl3 = false;
            if (bl2) {
                this.mSpssVar = (ISpssVariable)object;
                this.mVarLabel.setIcon(VariableList.getStandardIcon((ISpssVariable)object));
                String string = this.mSpssVar.getName();
                String string2 = this.mSpssVar.getLabel();
                if (bl3 && string2.length() > 0) {
                    if (ComponentState.isBtdRtlOrLtr()) {
                        this.mVarLabel.setText(ComponentState.prepareStringForBidiRendering((String)(string2 + " [" + string + "]")));
                    } else {
                        this.mVarLabel.setText(string2 + " [" + string + "]");
                    }
                } else if (ComponentState.isBtdRtlOrLtr()) {
                    this.mVarLabel.setText(ComponentState.prepareStringForBidiRendering((String)string));
                } else {
                    this.mVarLabel.setText(string);
                }
            }
            return this.mVarLabel;
        }
    }

    class AnalysisVariableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        AnalysisVariableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            boolean bl3 = object instanceof ISpssVariable;
            boolean bl4 = false;
            boolean bl5 = false;
            if (bl3) {
                object2 = (ISpssVariable)object;
                this.setIcon(VariableList.getStandardIcon((ISpssVariable)object));
                String string = object2.getName();
                String string2 = object2.getLabel();
                if (bl4 && string2.length() > 0) {
                    this.setText(string2 + " [" + string + "]");
                } else {
                    this.setText(string);
                }
                if (object2.getId().isNull() && !DialogDataModel.isSpecialVariable(object2)) {
                    bl5 = true;
                }
            } else if (object != null) {
                this.setText(object.toString());
            }
            if (jTable.isCellEditable(n, 0)) {
                this.setOpaque(true);
                if (bl) {
                    if (jTable.hasFocus()) {
                        this.setBackground(jTable.getSelectionBackground());
                        this.setForeground(jTable.getSelectionForeground());
                    } else {
                        this.setBackground(Color.lightGray);
                        this.setForeground(Color.black);
                    }
                } else {
                    this.setBackground(jTable.getBackground());
                    this.setForeground(jTable.getForeground());
                }
                if (bl5) {
                    this.setForeground(Color.RED);
                }
            } else {
                if (bl2) {
                    object2 = null;
                    if (bl) {
                        object2 = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                    }
                    if (object2 == null) {
                        object2 = UIManager.getBorder("Table.focusCellHighlightBorder");
                    }
                    this.setBorder((Border)object2);
                } else {
                    this.setBorder(null);
                }
                this.setOpaque(false);
            }
            this.setEnabled(jTable.isEnabled());
            this.setFont(jTable.getFont());
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }

    class DisplayTableRenderer
    extends DefaultTableCellRenderer {
        JLabel label;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.label = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setBackground(jTable.getTableHeader().getBackground());
            if (n2 != 0) {
                this.setForeground(Color.black);
                this.setOpaque(true);
            }
            this.setToolTipText(MIConstraintsTab.this.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_SUMMARY_TOOLTIP_TEXT"));
            return this.label;
        }
    }
}

