/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.multiple_imputation.impute_missing_data;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.multiple_imputation.impute_missing_data.MIConstraintsTab;
import com.spss.java_client.ui.dialogs.multiple_imputation.impute_missing_data.MIMethodTab;
import com.spss.java_client.ui.dialogs.multiple_imputation.impute_missing_data.MIOutputTab;
import com.spss.java_client.ui.dialogs.multiple_imputation.impute_missing_data.MIVariablesTab;
import com.spss.java_client.ui.dialogs.multiple_imputation.res.MultipleImputationResBundle;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class ImputeMissingDataDlg
extends BaseTabbedDialog {
    private MIVariablesTab mVariableTab;
    private MIMethodTab mMethodTab;
    private MIConstraintsTab mConstraintsTab;
    private MIOutputTab mOutputTab;

    public ImputeMissingDataDlg(JFrame jFrame) {
        super(jFrame, false, MultipleImputationResBundle.getDefaultResourceBundleName(), MultipleImputationResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_MI_IMPUTE_MISSING_DATA_TITLE"));
        this.setLocationRelativeTo(jFrame);
    }

    public static void setSelectionText(JComponent jComponent) {
        ImputeMissingDataDlg.setSelectionText(jComponent, 0);
    }

    public static void setSelectionText(final JComponent jComponent, int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jComponent.requestFocusInWindow();
            }
        });
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).setSelectionStart(n);
            ((JTextField)jComponent).setSelectionEnd(((JTextField)jComponent).getText().length());
        }
    }

    public String showSaveDialog() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), true);
        remoteFileChooser.setDialogTitle(this.getResString("IDS_MI_IMPUTE_MISSING_SAVE_DIALOG_TITLE"));
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_MI_IMPUTE_MISSING_FILE_FILTER"), this.getResString("IDS_MI_IMPUTE_MISSING_FILE_FILTER_EXTN")));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = remoteFileChooser.showSaveDialog((Component)((Object)this));
        if (n == 0) {
            String string = remoteFileChooser.getSelectedFilePath();
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            int n2 = string.indexOf(this.getResString("IDS_MI_IMPUTE_MISSING_FILE_FILTER_EXTN"));
            if (n2 == -1) {
                string = string.concat(this.getResString("IDS_MI_IMPUTE_MISSING_FILE_FILTER_EXTN"));
            }
            return string;
        }
        return "";
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mVariableTab.loadTabState(this.getDialogDataModel(), this.getNameLabelOverride());
        this.mMethodTab.loadTabState(this.getDialogDataModel(), this.getNameLabelOverride());
        this.mConstraintsTab.loadTabState(this.getDialogDataModel(), this.getNameLabelOverride());
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        this.mVariableTab.saveTabState(dialogDataModel);
        this.mMethodTab.saveTabState(dialogDataModel);
        this.mConstraintsTab.saveTabState(dialogDataModel);
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("*Impute Missing Data Values.");
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(this.mVariableTab.getDatasetDelcareSyntax());
        stringBuffer.append(this.mOutputTab.getDataSetCommand(dialogDataModel));
        stringBuffer.append(this.mVariableTab.getVariablesTabSyntax(dialogDataModel));
        stringBuffer.append(this.mMethodTab.getMethodTabSyntax(dialogDataModel));
        stringBuffer.append(this.mConstraintsTab.getConstraintTabSyntax(dialogDataModel));
        stringBuffer.append(this.mOutputTab.getOutputTabSyntax(dialogDataModel));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(this.mVariableTab.getPESSyntax());
        stringBuffer.append(this.mOutputTab.getPESSyntax());
        return stringBuffer.toString();
    }

    @Override
    public boolean okPastePressed() {
        Object object;
        String string = this.getVariablesTab().getDataSetName();
        if (string.length() > 0 && this.mOutputTab.getDatasetField().isEnabled() && string.equals((object = this.mOutputTab.getDatasetField()).getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MI_IMPUTE_MISSING_DUPLICATE_DATASET_NAME_WARNING"), VersionInfo.getAppVersionString());
            if (!(this.mTabbedPane.getSelectedComponent() instanceof MIOutputTab)) {
                this.mTabbedPane.setSelectedIndex(3);
            }
            ImputeMissingDataDlg.setSelectionText((JComponent)((Object)this.mOutputTab.getDatasetField()));
            return false;
        }
        object = this.getVariablesTab().getDataFilePath();
        String string2 = this.mOutputTab.getHistoryFilePath();
        if (((String)object).length() > 0 && string2.length() > 0 && ((String)object).equals(string2)) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MI_IMPUTE_MISSING_DUPLICATE_FILE_PATH_WARNING"), VersionInfo.getAppVersionString());
            if (!(this.mTabbedPane.getSelectedComponent() instanceof MIOutputTab)) {
                this.mTabbedPane.setSelectedIndex(3);
            }
            this.mOutputTab.getBrowseButton().requestFocusInWindow();
            return false;
        }
        boolean bl = true;
        if (!this.mVariableTab.validateTab()) {
            bl = false;
        } else if (!this.mVariableTab.getDataSetFlag() && !this.mVariableTab.isDataSetNameOK()) {
            if (!(this.mTabbedPane.getSelectedComponent() instanceof MIVariablesTab)) {
                this.mTabbedPane.setSelectedIndex(0);
            }
            this.mVariableTab.selectDataSetNameField();
            bl = false;
        }
        if (!bl) {
            return false;
        }
        if (!this.mMethodTab.validateTab()) {
            return false;
        }
        if (!this.mConstraintsTab.validateTab()) {
            return false;
        }
        return this.mOutputTab.validateTab();
    }

    @Override
    public String getIActionKey() {
        return "analyze_multiple_imputation_impute_missing_data";
    }

    public MIVariablesTab getVariablesTab() {
        return this.mVariableTab;
    }

    public MIConstraintsTab getConstraintsTab() {
        return this.mConstraintsTab;
    }

    public MIMethodTab getMethodTab() {
        return this.mMethodTab;
    }

    @Override
    protected void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    @Override
    public void reset() {
        Object[] objectArray = this.getResStringArray("IDS_MI_IMPUTE_MISSING_RESET_BUTTON_LABELS");
        int n = SpssAlertOptionPane.showOptionDialog((Window)((Object)this), this.getResString("ERR_MI_IMPUTE_MISSING_WARNING2"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, objectArray, (Object)objectArray[0]);
        if (n != 2) {
            if (n == 0) {
                super.reset();
                this.mVariableTab.reset();
                this.mMethodTab.reset();
                this.mConstraintsTab.reset();
                this.mOutputTab.reset();
            } else {
                Component component = this.mTabbedPane.getSelectedComponent();
                if (component instanceof BaseProcedureTab) {
                    ((BaseProcedureTab)component).reset();
                }
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        this.mVariableTab = new MIVariablesTab(this);
        this.addTab(this.getResString("IDS_MI_IMPUTE_MISSING_VARIABLE_TAB_TITLE"), this.mVariableTab);
        this.mVariableTab.setDataSetFlag(false);
        this.mMethodTab = new MIMethodTab(this);
        this.addTab(this.getResString("IDS_MI_IMPUTE_MISSING_METHOD_TAB_TITLE"), this.mMethodTab);
        this.mConstraintsTab = new MIConstraintsTab(this);
        this.addTab(this.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_TAB_TITLE"), this.mConstraintsTab);
        this.mOutputTab = new MIOutputTab(this);
        this.addTab(this.getResString("IDS_MI_IMPUTE_MISSING_OUTOUT_TAB_TITLE"), this.mOutputTab);
        this.pack();
    }
}

