/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.multiple_imputation.analyze_patterns;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ListFocusTraversalPolicy;
import com.spss.java_client.ui.controls.ListTravArrowButtonFactory;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.multiple_imputation.res.MultipleImputationResBundle;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.NumberSpinner;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class AnalyzePatternsDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
DocumentListener {
    private static String MAX_NUMBER_VARIABLES = "IDS_MI_ANALYZE_MAX_NUMBER_VARIABLES";
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private TargetVariableList mAnalysisVarList;
    private ArrowButton mAnalysisVarButton;
    private JScrollPane mAnalysisVarListScrollPane;
    private ListTravArrowButtonFactory mTraveralArrowButton;
    private JPanel mAnalysisUpAndDownArrowButtonPanel;
    private TargetVariableList mWeightVarList;
    private ArrowButton mWeightVarButton;
    private JScrollPane mWeightVarListScrollPane;
    private JCheckBox mSummaryCheckBox;
    private JCheckBox mPatternCheckBox;
    private JCheckBox mVariableCheckBox;
    private JLabel mMaxToDisplayLabel;
    private JLabel mMinToDisplayLabel;
    private NumberSpinner mMaxNumber;
    private FloatTextField mMinPercent;

    public AnalyzePatternsDlg(JFrame jFrame) {
        super(jFrame, false, MultipleImputationResBundle.getDefaultResourceBundleName(), MultipleImputationResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_MI_AP_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_MI_ANALYSIS";
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("*Analyze Patterns of Missing Values.\n");
        stringBuffer.append(SyntaxUtil.getMainCommand("MULTIPLE IMPUTATION "));
        String string = this.mAnalysisVarList.getVariablesStringList();
        if (string != null && string.length() > 0) {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
        }
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand(" /IMPUTE METHOD=NONE"));
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand(" /MISSINGSUMMARIES "));
        StringBuffer stringBuffer2 = new StringBuffer("");
        boolean bl = false;
        Boolean bl2 = dialogDataModel.getBoolean("IDS_MI_AP_SUMMARY_LABEL");
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer2.append(" OVERALL");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_MI_AP_VARIABLE_LABEL")) != null && bl2.booleanValue()) {
            stringBuffer2.append(" VARIABLES (MAXVARS=").append(((JTextField)this.mMaxNumber.getEditor()).getText());
            stringBuffer2.append(" MINPCTMISSING=").append(this.mMinPercent.getText()).append(")");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_MI_AP_PATTERNS_LABEL")) != null && bl2.booleanValue()) {
            stringBuffer2.append(" PATTERNS");
            bl = true;
        }
        if (!bl) {
            stringBuffer2.append(" NONE");
        }
        stringBuffer.append(stringBuffer2);
        string = this.mWeightVarList.getVariablesStringList();
        if (string != null && string.length() > 0) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand(" /ANALYSISWEIGHT ")).append(string);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public final String getIActionKey() {
        return "analyze_multiple_imputation_analyze_patterns";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mVariableCheckBox) {
            if (itemEvent.getStateChange() == 1) {
                this.mMaxToDisplayLabel.setEnabled(true);
                this.mMaxNumber.setEnabled(true);
                this.mMinPercent.setEnabled(true);
                this.mMinToDisplayLabel.setEnabled(true);
            } else {
                this.mMaxToDisplayLabel.setEnabled(false);
                this.mMaxNumber.setEnabled(false);
                this.mMinPercent.setEnabled(false);
                this.mMinToDisplayLabel.setEnabled(false);
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateOkAndPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateOkAndPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void reset() {
        super.reset();
        this.mWeightVarList.removeAll();
        this.mAnalysisVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocusInWindow();
        this.setDefaults();
    }

    protected void updateOkAndPaste() {
        this.enableOkPaste(this.mAnalysisVarList.getModel().getSize() > 0);
    }

    @Override
    public boolean okPastePressed() {
        if (this.mAnalysisVarList.getModel().getSize() < 2) {
            String string = this.getResString("ERR_MI_AP_ONE_TARGET_VAR_WARNING");
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
            this.mAnalysisVarList.requestFocusInWindow();
            return false;
        }
        if (this.mVariableCheckBox.isSelected()) {
            double d;
            int n;
            String string = ((JTextField)this.mMaxNumber.getEditor()).getText();
            String string2 = "";
            if (string.length() == 0) {
                string2 = this.getResString("ERR_MI_AP_ONE_MAX_TO_DISPLAY_WARNING1");
            }
            if (string2.length() == 0 && (n = Integer.parseInt(string)) == 0) {
                string2 = this.getResString("ERR_MI_AP_ONE_MAX_TO_DISPLAY_WARNING2");
            }
            if (string2.length() > 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
                this.mMaxNumber.getEditor().requestFocus();
                return false;
            }
            String string3 = this.mMinPercent.getText();
            string2 = "";
            if (string3.length() == 0) {
                string2 = this.getResString("ERR_MI_AP_ONE_MIN_TO_DISPLAY_WARNING3");
            }
            if (string2.length() == 0 && (d = Double.parseDouble(string3)) >= 100.0) {
                string2 = this.getResString("ERR_MI_AP_ONE_MIN_TO_DISPLAY_WARNING4");
            }
            if (string2.length() > 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
                this.mMinPercent.requestFocusInWindow();
                this.mMinPercent.setSelectionStart(0);
                this.mMinPercent.setSelectionEnd(string3.length());
                return false;
            }
        }
        return true;
    }

    protected JPanel setupOutputPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_MI_AP_OUTPUT_TITLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(2, 2, 4, n);
        int n2 = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSummaryCheckBox, gridBagConstraints, 0, 0, 2, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mPatternCheckBox, gridBagConstraints, 0, 1, 2, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mVariableCheckBox, gridBagConstraints, 0, 2, 2, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(4, n * 4, 4, -n * 12);
        DialogUtil.addUsingGBL(jPanel, this.mMaxToDisplayLabel, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        insets.set(4, -n * 12, 0, n);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxNumber, gridBagConstraints, 1, 3, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(4, n * 4, 4, 2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mMinToDisplayLabel, gridBagConstraints, 0, 4, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        insets.set(4, 2, 0, n);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinPercent, gridBagConstraints, 1, 4, 1, 1, n2, insets);
        return jPanel;
    }

    @Override
    protected void loadDialogState() {
        String string;
        super.loadDialogState();
        this.updateOkAndPaste();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocusInWindow();
        if (this.getDialogDataModel() != null && (string = this.getDialogDataModel().getString(MAX_NUMBER_VARIABLES)) != null) {
            ((JTextField)this.mMaxNumber.getEditor()).setText(string);
        }
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        if (this.getDialogDataModel() != null) {
            this.getDialogDataModel().putString(MAX_NUMBER_VARIABLES, ((JTextField)this.mMaxNumber.getEditor()).getText());
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupLists(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSummaryCheckBox.setSelected(true);
        this.mPatternCheckBox.setSelected(true);
        this.mVariableCheckBox.setSelected(true);
        this.mMinPercent.setText("10");
        this.mMaxNumber.setValue((Object)new Integer(25));
        if (this.mVariableCheckBox.isSelected()) {
            this.mMaxToDisplayLabel.setEnabled(true);
            this.mMaxNumber.setEnabled(true);
            this.mMinPercent.setEnabled(true);
            this.mMinToDisplayLabel.setEnabled(true);
        }
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier("AnalysisPatternsSrcList");
        this.mSrcVarList.getModel().addListDataListener(this);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcScrollPane.setHorizontalScrollBarPolicy(30);
        this.mSrcScrollPane.setVerticalScrollBarPolicy(20);
        this.mAnalysisVarList = new TargetVariableList();
        this.mAnalysisVarList.setIdentifier("AnalysisPatternsTargetList");
        this.mAnalysisVarList.getModel().addListDataListener(this);
        this.mAnalysisVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mAnalysisVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mAnalysisVarList.getFixedCellHeight() * 7 + 2));
        this.mAnalysisVarListScrollPane = new JScrollPane(this.mAnalysisVarList);
        this.mAnalysisVarListScrollPane.setPreferredSize(this.mAnalysisVarList.getMinimumSize());
        this.mAnalysisVarButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mAnalysisVarButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mAnalysisVarButton.registerVariableList(this.mAnalysisVarList, SpssArrowButton.ButtonOrientation.left);
        this.mTraveralArrowButton = new ListTravArrowButtonFactory(this.mAnalysisVarList, false);
        this.mAnalysisUpAndDownArrowButtonPanel = this.mTraveralArrowButton.getArrowButtonPanel();
        TargetVariableList.TargetListType targetListType = TargetVariableList.TargetListType.single_item;
        this.mWeightVarList = new TargetVariableList(targetListType);
        this.mWeightVarList.setIdentifier("AnalysisPatternsWeightList");
        this.mWeightVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mWeightVarList.addVarFilter(new SpssVarFilter(32, false));
        this.mWeightVarList.addVarFilter(new SpssVarFilter(64, false));
        this.mWeightVarList.getModel().addListDataListener(this);
        this.mWeightVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mWeightVarList.getFixedCellHeight()));
        this.mWeightVarListScrollPane = new JScrollPane(this.mWeightVarList);
        this.mWeightVarListScrollPane.setVerticalScrollBarPolicy(21);
        this.mWeightVarListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mWeightVarListScrollPane.setPreferredSize(this.mWeightVarList.getMinimumSize());
        this.mWeightVarButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mWeightVarButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mWeightVarButton.registerVariableList(this.mWeightVarList, SpssArrowButton.ButtonOrientation.left);
        this.mSummaryCheckBox = DialogUtil.createCheckBox(this, "IDS_MI_AP_SUMMARY_LABEL", null);
        this.mSummaryCheckBox.addItemListener(this);
        this.mPatternCheckBox = DialogUtil.createCheckBox(this, "IDS_MI_AP_PATTERNS_LABEL", null);
        this.mPatternCheckBox.addItemListener(this);
        this.mVariableCheckBox = DialogUtil.createCheckBox(this, "IDS_MI_AP_VARIABLE_LABEL", null);
        this.mVariableCheckBox.addItemListener(this);
        this.mMaxToDisplayLabel = DialogUtil.createLabel(this, "IDS_MI_AP_MAX_TO_DISPLAY");
        this.mMaxNumber = new NumberSpinner(25, 0, Integer.MAX_VALUE, true, 1);
        this.mMaxToDisplayLabel.setLabelFor(this.mMaxNumber.getEditor());
        this.mMinToDisplayLabel = DialogUtil.createLabel(this, "IDS_MI_AP_MIN_TO_DISPLAY");
        this.mMinPercent = new FloatTextField(0.0, 100.0, 2);
        this.mMinPercent.setAction((Action)new TextFieldAction(this, "IDS_MI_AP_MIN_FILED"));
        this.mMinPercent.setColumns(5);
        this.mMinPercent.getDocument().addDocumentListener(this);
        this.mMinToDisplayLabel.setLabelFor((Component)this.mMinPercent);
    }

    private void setupLists(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2 - 4, 0, 0, 0);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_MI_AP_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 3, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2 - 4, 0, 0, 0);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_MI_AP_ANALYSIS_VAR_LABEL");
        jLabel2.setLabelFor(this.mAnalysisVarList);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2 - 4, n2, 1, n2 - 4);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mAnalysisVarButton, gridBagConstraints, 1, 1, 1, 1, 10, insets);
        gridBagConstraints.fill = 1;
        insets.set(1, n2, n2, n2 - 4);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mAnalysisVarListScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2 - 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mAnalysisUpAndDownArrowButtonPanel, gridBagConstraints, 3, 1, 1, 1, 10, insets);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_MI_AP_WEIGHT_VAR_LABEL");
        jLabel3.setLabelFor(this.mWeightVarList);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, 1, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        insets.set(0, n2, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mWeightVarButton, gridBagConstraints, 1, 2, 1, 2, 20, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, n2, 0, n2 - 4);
        DialogUtil.addUsingGBL(jPanel, this.mWeightVarListScrollPane, gridBagConstraints, 2, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, 0, 10, n2);
        DialogUtil.addUsingGBL(jPanel, this.setupOutputPanel(), gridBagConstraints, 0, 4, 4, 1, n, insets);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mAnalysisVarButton);
        vector.add(this.mWeightVarButton);
        vector.add(this.mAnalysisVarList);
        vector.add(this.mTraveralArrowButton.getUpArrowButton());
        vector.add(this.mTraveralArrowButton.getDownArrowButton());
        vector.add(this.mWeightVarList);
        vector.add(this.mSummaryCheckBox);
        vector.add(this.mPatternCheckBox);
        vector.add(this.mVariableCheckBox);
        vector.add(this.mMaxNumber.getEditor());
        vector.add(this.mMinPercent);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        ListFocusTraversalPolicy listFocusTraversalPolicy = new ListFocusTraversalPolicy(new ListTravArrowButtonFactory[]{this.mTraveralArrowButton, this.mTraveralArrowButton}, vector, false);
        this.setFocusTraversalPolicy(listFocusTraversalPolicy);
    }
}

