/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.missing_values.missingvalue_analysis;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.missing_values.missingvalue_analysis.MissingValueAnalysisDlg;
import com.spss.java_client.ui.dialogs.missing_values.missingvalue_analysis.MissingValueAnalysisUtil;
import com.spss.java_client.ui.dialogs.missing_values.missingvalue_analysis.MissingValueVarFormatter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MissingValueAnalysisVariables
extends BaseSubDialog
implements ListSelectionListener,
ListDataListener,
ItemListener {
    static final String MVAV_ALL_VARS_KEY = "IDS_MVAV_QUANTATIVE_VAR_RADIO";
    static final String MVAV_SELECTED_VARS_KEY = "IDS_MVAV_SELECT_VAR_RADIO";
    static final String MVAV_QUANTITATIVE_VARSLIST_KEY = "MVAV_QUANTITATIVE_VARSLIST_KEY";
    static final String MVAV_PREDICTED_VARSLIST_KEY = "MVAV_PREDICTED_VARSLIST_KEY";
    static final String MVAV_PREDICTOR_VARSLIST_KEY = "MVAV_PREDICTOR_VARSLIST_KEY";
    private JRadioButton mAllVarRadio;
    private JRadioButton mSelectedVarRadio;
    private JLabel mQuantitativeVarLabel;
    private JLabel mPredictedVarLabel;
    private JLabel mPredictorVarLabel;
    private TargetVariableList mQuantitativeVarList;
    private TargetVariableList mPredictedVarList;
    private TargetVariableList mPredictorVarList;
    private ArrowButton mBothArrow;
    private ArrowButton mPredictedVarArrow;
    private ArrowButton mPredictorVarArrow;

    public MissingValueAnalysisVariables(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_MVAV_VARIABLES_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_miss_var";
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.mSelectedVarRadio.isSelected()) {
            boolean bl = this.mQuantitativeVarList.getSelectedIndex() >= 0;
            boolean bl2 = this.mSelectedVarRadio.isSelected();
            this.mBothArrow.setEnabled(bl2 && bl);
            this.mPredictedVarArrow.setEnabled(bl2 && bl);
            this.mPredictorVarArrow.setEnabled(bl2 && bl);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableContinueButton();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableContinueButton();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableContinueButton();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableControls();
        this.enableContinueButton();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        VarListModel varListModel = ((MissingValueAnalysisDlg)this.mParentDlg).getQuantitativeVarList();
        VarListModel varListModel2 = this.mQuantitativeVarList.getModel();
        varListModel2.removeAll();
        int n = varListModel.getSize();
        for (int i = 0; i < n; ++i) {
            varListModel2.addElement(varListModel.getElementAt(i));
        }
        MissingValueAnalysisUtil.verifyLists(varListModel2, this.mPredictedVarList.getModel());
        MissingValueAnalysisUtil.verifyLists(varListModel2, this.mPredictorVarList.getModel());
        this.enableControls();
        this.enableContinueButton();
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.enableControls();
        this.enableContinueButton();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = 23;
        JPanel jPanel2 = this.setupVariablesPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    private JPanel setupVariablesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_MVAV_VARIABLES_PANEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(0, n2, n, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n3 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mAllVarRadio, gridBagConstraints, 0, 0, 2, 1, n3, insets2);
        insets2.left = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSelectedVarRadio, gridBagConstraints, 2, 0, 1, 1, n3, insets2);
        gridBagConstraints.fill = 2;
        JSeparator jSeparator = new JSeparator();
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 1, 3, 1, n3, insets2);
        gridBagConstraints.fill = 0;
        insets2.bottom = insets.bottom;
        insets2.left = n2;
        DialogUtil.addUsingGBL(jPanel, this.mQuantitativeVarLabel, gridBagConstraints, 0, 2, 1, 1, n3, insets2);
        insets2.left = 0;
        DialogUtil.addUsingGBL(jPanel, this.mPredictedVarLabel, gridBagConstraints, 2, 2, 1, 1, n3, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.left = n2;
        JScrollPane jScrollPane = new JScrollPane(this.mQuantitativeVarList);
        jScrollPane.setPreferredSize(this.mQuantitativeVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 3, 1, 3, n3, insets2);
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        gridBagConstraints.fill = 0;
        n3 = 10;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mPredictedVarArrow, gridBagConstraints, 1, 3, 1, 1, n3, insets3);
        JPanel jPanel2 = this.setupBothArrowPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 4, 1, 1, n3, null);
        DialogUtil.addUsingGBL(jPanel, this.mPredictorVarArrow, gridBagConstraints, 1, 5, 1, 1, n3, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel2 = this.setupVarListPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 3, 1, 3, n3, null);
        return jPanel;
    }

    private JPanel setupVarListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, DialogUtil.getStandardControlInsets().bottom, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mPredictorVarLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mPredictedVarList);
        this.mPredictedVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mPredictedVarList.getFixedCellHeight() * 8 + 2));
        jScrollPane.setPreferredSize(this.mPredictedVarList.getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane(this.mPredictorVarList);
        this.mPredictorVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mPredictorVarList.getFixedCellHeight() * 8 + 2));
        jScrollPane2.setPreferredSize(this.mPredictorVarList.getMinimumSize());
        jScrollPane.setPreferredSize(jScrollPane2.getPreferredSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupBothArrowPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MVAV_BOTH_PANEL");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 10;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, DialogUtil.getStandardButtonInsets().bottom, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mBothArrow, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, MVAV_ALL_VARS_KEY);
        this.mAllVarRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MVAV_SELECTED_VARS_KEY);
        this.mSelectedVarRadio = new JRadioButton(toggleButtonAction);
        this.mQuantitativeVarList = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eKeepOriginal);
        this.mQuantitativeVarList.setIdentifier(MVAV_QUANTITATIVE_VARSLIST_KEY);
        MissingValueVarFormatter missingValueVarFormatter = new MissingValueVarFormatter(this.mQuantitativeVarList);
        this.mQuantitativeVarList.setCellRenderer(new CustomVarListCellRenderer(missingValueVarFormatter));
        this.mQuantitativeVarList.setDataSource(true);
        this.mQuantitativeVarList.addListSelectionListener(this);
        this.mQuantitativeVarList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (MissingValueAnalysisVariables.this.mQuantitativeVarList.getSelectedIndex() >= 0 && MissingValueAnalysisVariables.this.mSelectedVarRadio.isSelected()) {
                    MissingValueAnalysisVariables.this.mPredictedVarArrow.setEnabled(true);
                    MissingValueAnalysisVariables.this.mBothArrow.setEnabled(true);
                    MissingValueAnalysisVariables.this.mPredictorVarArrow.setEnabled(true);
                }
            }
        });
        this.mPredictedVarList = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eKeepOriginal);
        this.mPredictedVarList.setIdentifier(MVAV_PREDICTED_VARSLIST_KEY);
        missingValueVarFormatter = new MissingValueVarFormatter(this.mPredictedVarList);
        this.mPredictedVarList.setCellRenderer(new CustomVarListCellRenderer(missingValueVarFormatter));
        this.mPredictedVarList.getModel().addListDataListener(this);
        this.mPredictorVarList = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eKeepOriginal);
        this.mPredictorVarList.setIdentifier(MVAV_PREDICTOR_VARSLIST_KEY);
        missingValueVarFormatter = new MissingValueVarFormatter(this.mPredictedVarList);
        this.mPredictorVarList.setCellRenderer(new CustomVarListCellRenderer(missingValueVarFormatter));
        this.mPredictorVarList.getModel().addListDataListener(this);
        this.mQuantitativeVarLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MVAV_QUANTATIVE_VAR_LABEL");
        this.mQuantitativeVarLabel.setLabelFor(this.mQuantitativeVarList);
        this.mPredictedVarLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MVAV_PREDICTED_VAR_LABEL");
        this.mPredictedVarLabel.setLabelFor(this.mPredictedVarList);
        this.mPredictorVarLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MVAV_PREDICTOR_VAR_LABEL");
        this.mPredictorVarLabel.setLabelFor(this.mPredictorVarList);
        this.mPredictedVarArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mPredictedVarArrow.registerVariableList(this.mQuantitativeVarList, SpssArrowButton.ButtonOrientation.right);
        this.mPredictedVarArrow.registerVariableList(this.mPredictedVarList, SpssArrowButton.ButtonOrientation.left);
        this.mPredictorVarArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mPredictorVarArrow.registerVariableList(this.mQuantitativeVarList, SpssArrowButton.ButtonOrientation.right);
        this.mPredictorVarArrow.registerVariableList(this.mPredictorVarList, SpssArrowButton.ButtonOrientation.left);
        this.mBothArrow = new ArrowButton(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ISpssVariable[] iSpssVariableArray = MissingValueAnalysisVariables.this.mQuantitativeVarList.getSelectedValues();
                VarListModel varListModel = MissingValueAnalysisVariables.this.mPredictedVarList.getModel();
                VarListModel varListModel2 = MissingValueAnalysisVariables.this.mPredictorVarList.getModel();
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    if (varListModel.findElementIndex(iSpssVariable) < 0) {
                        varListModel.addElement(iSpssVariable);
                    }
                    if (varListModel2.findElementIndex(iSpssVariable) >= 0) continue;
                    varListModel2.addElement(iSpssVariable);
                }
                MissingValueAnalysisVariables.this.mPredictedVarList.setModel(varListModel);
                MissingValueAnalysisVariables.this.mPredictorVarList.setModel(varListModel2);
                MissingValueAnalysisVariables.this.mBothArrow.setEnabled(false);
                MissingValueAnalysisVariables.this.mPredictorVarList.setSelection(iSpssVariableArray);
                MissingValueAnalysisVariables.this.mPredictedVarArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
                MissingValueAnalysisVariables.this.mPredictorVarArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            }
        };
        this.mPredictorVarArrow.registerVariableList(this.mQuantitativeVarList, SpssArrowButton.ButtonOrientation.right);
        this.mAllVarRadio.addItemListener(this);
        this.mSelectedVarRadio.addItemListener(this);
    }

    private void setDefaults() {
        this.mAllVarRadio.setSelected(true);
        this.enableControls();
    }

    private void enableControls() {
        boolean bl = this.mSelectedVarRadio.isSelected();
        this.mQuantitativeVarLabel.setEnabled(bl);
        this.mPredictedVarLabel.setEnabled(bl);
        this.mPredictorVarLabel.setEnabled(bl);
        this.mQuantitativeVarList.setEnabled(bl);
        this.mQuantitativeVarList.setOpaque(bl);
        this.mPredictedVarList.setEnabled(bl);
        this.mPredictedVarList.setOpaque(bl);
        this.mPredictorVarList.setEnabled(bl);
        this.mPredictorVarList.setOpaque(bl);
        boolean bl2 = this.mQuantitativeVarList.getSelectedIndex() >= 0;
        this.mBothArrow.setEnabled(bl && bl2);
        this.mPredictedVarArrow.setEnabled(bl && bl2);
        this.mPredictorVarArrow.setEnabled(bl && bl2);
    }

    private void enableContinueButton() {
        if (this.mAllVarRadio.isSelected()) {
            this.enableContinue(true);
        } else {
            this.enableContinue(this.mPredictedVarList.getModel().getSize() > 0 && this.mPredictorVarList.getModel().getSize() > 0);
        }
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mAllVarRadio);
        spssButtonGroup.add(this.mSelectedVarRadio);
        vector.add(spssButtonGroup);
        vector.add(this.mQuantitativeVarList);
        vector.add(this.mPredictedVarArrow);
        vector.add(this.mPredictedVarList);
        vector.add(this.mBothArrow);
        vector.add(this.mPredictorVarArrow);
        vector.add(this.mPredictorVarList);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

