/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.missing_values.missingvalue_analysis;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.missing_values.missingvalue_analysis.MissingValueAnalysisUtil;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.util.TraceSettings;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class MissingValueAnalysisRegression
extends BaseSubDialog
implements DocumentListener,
FocusListener,
ItemListener {
    static final String MVAR_RESIDUAL_RADIO_KEY = "IDS_MVAR_RESIDUALS_RADIO";
    static final String MVAR_NORMAL_VARIATE_KEY = "IDS_MVAR_NORMAL_VARIATES_RADIO";
    static final String MVAR_STUDENT_VAR_KEY = "IDS_MVAR_STUDENTS_VARIATES_RADIO";
    static final String MVAR_DEGREE_FREEDOM_KEY = "IDS_MVAR_DEGREE_FREEDOM_RADIO";
    static final String MVAR_NONE_RADIO_KEY = "IDS_MVAR_NONE_RADIO";
    static final String MVAR_MAX_PREDICTORS_CHECK_KEY = "IDS_MVAR_MAX_PREDICTORS_CHECK";
    static final String MVAR_MAX_PREDICTORS_TEXT_KEY = "MVAR_MAX_PREDICTORS_TEXT_KEY";
    static final String MVAR_SAVE_DATA_KEY = "IDS_MVAR_SAVE_DATA_CHECK";
    static final String MVAR_CREATE_DATASET_KEY = "IDS_MVAR_CREATE_DATASET_RADIO";
    static final String MVAR_WRITE_DATAFILE_KEY = "IDS_MVAR_WRITE_FILE_RADIO";
    static final String MVAR_DATASET_NAME_KEY = "MVAR_DATASET_NAME_KEY";
    static final String MVAR_FILE_NAME_KEY = "MVAR_FILE_NAME_KEY";
    private JRadioButton mResidualRadio;
    private JRadioButton mNormalVariantRadio;
    private JRadioButton mStudentRadio;
    private JRadioButton mNoneRadio;
    private JLabel mDegreeFreedomLabel;
    private IntTextField mDegreeFreedomText;
    private JCheckBox mMaxPredictorsCheck;
    private IntTextField mMaxPredictorsText;
    private JCheckBox mSaveDataCheck;
    private JRadioButton mCreateDatasetRadio;
    private JRadioButton mWriteDataFileRadio;
    private JLabel mDatasetNameLabel;
    private StringTextField mDatasetNameText;
    private JButton mFileButton;
    private FileTextField mFileTextField;

    public MissingValueAnalysisRegression(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_MVAR_REGRESSION_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_miss_regr";
    }

    public void paint(Graphics graphics) {
        this.mFileTextField.setText(this.mFileTextField.getText());
        super.paint(graphics);
        super.validate();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mMaxPredictorsCheck)) {
            boolean bl = this.mMaxPredictorsCheck.isSelected();
            this.mMaxPredictorsText.setEnabled(bl);
            this.mMaxPredictorsText.setOpaque(bl);
            this.enableContinueButton();
        } else if (itemEvent.getSource().equals(this.mSaveDataCheck)) {
            this.enableSaveDataControls();
        } else if (itemEvent.getSource().equals(this.mCreateDatasetRadio)) {
            this.enableDatasetControls();
        } else if (itemEvent.getSource().equals(this.mWriteDataFileRadio)) {
            this.enableDatasetControls();
        } else {
            this.enableEstAdjustmentPanelControls();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public boolean continuePressed() {
        int n;
        if (this.mStudentRadio.isSelected() && ((n = Integer.parseInt(this.mDegreeFreedomText.getText())) < 2 || n > 200)) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MVA_OUTOFRANGE_WARNING"), VersionInfo.getAppVersionString());
            this.mDegreeFreedomText.requestFocus();
            this.mDegreeFreedomText.selectAll();
            return false;
        }
        if (this.mSaveDataCheck.isSelected() && this.mCreateDatasetRadio.isSelected()) {
            n = DatasetNameValidator.validateDatasetName((String)this.mDatasetNameText.getText(), (Component)((Object)this));
            if (n == 1) {
                return true;
            }
            this.mDatasetNameText.requestFocus();
            this.mDatasetNameText.selectAll();
            return false;
        }
        return super.continuePressed();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JTextField[] jTextFieldArray;
        for (JTextField jTextField : jTextFieldArray = new JTextField[]{this.mDegreeFreedomText, this.mMaxPredictorsText, this.mDatasetNameText}) {
            if (!focusEvent.getSource().equals(jTextField)) continue;
            jTextField.selectAll();
            break;
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.enableEstAdjustmentPanelControls();
        this.enableDatasetControls();
        this.enableSaveDataControls();
        boolean bl = this.mMaxPredictorsCheck.isSelected();
        this.mMaxPredictorsText.setEnabled(bl);
        this.mMaxPredictorsText.setOpaque(bl);
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.enableEstAdjustmentPanelControls();
        this.enableSaveDataControls();
        this.enableContinueButton();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, n, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n3 = 23;
        JPanel jPanel2 = this.setupEstAdjustmentPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n3, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.left = n2;
        DialogUtil.addUsingGBL(jPanel, this.mMaxPredictorsCheck, gridBagConstraints, 0, 1, 1, 1, n3, insets);
        gridBagConstraints.weightx = 1.0;
        insets.left = n;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxPredictorsText, gridBagConstraints, 1, 1, 1, 1, n3, insets);
        insets.left = n2;
        JComponent[] jComponentArray = new JComponent[]{this.mSaveDataCheck, this.mCreateDatasetRadio, this.mWriteDataFileRadio, this.mDatasetNameLabel, this.mDatasetNameText, this.mFileButton, this.mFileTextField};
        jPanel2 = MissingValueAnalysisUtil.createSaveDataPanel(jComponentArray);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 2, 1, n3, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    private JPanel setupEstAdjustmentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_MVAR_ESTIMATION_ADJ_PANEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(0, n2, insets.bottom, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n3 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mResidualRadio, gridBagConstraints, 0, 0, 2, 1, n3, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mNormalVariantRadio, gridBagConstraints, 0, 1, 2, 1, n3, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mStudentRadio, gridBagConstraints, 0, 2, 2, 1, n3, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mNoneRadio, gridBagConstraints, 0, 4, 2, 1, n3, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets2.left = n * 3;
        DialogUtil.addUsingGBL(jPanel, this.mDegreeFreedomLabel, gridBagConstraints, 0, 3, 1, 1, n3, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.left = n;
        n3 = 23;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDegreeFreedomText, gridBagConstraints, 1, 3, 1, 1, n3, insets2);
        return jPanel;
    }

    private void initVars() {
        ControlAction controlAction = new ToggleButtonAction(this, MVAR_RESIDUAL_RADIO_KEY);
        this.mResidualRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, MVAR_NORMAL_VARIATE_KEY);
        this.mNormalVariantRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, MVAR_STUDENT_VAR_KEY);
        this.mStudentRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, MVAR_NONE_RADIO_KEY);
        this.mNoneRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, MVAR_MAX_PREDICTORS_CHECK_KEY);
        this.mMaxPredictorsCheck = new JCheckBox(controlAction);
        this.mDegreeFreedomText = new IntTextField(2, 200, true);
        controlAction = new TextFieldAction(this, MVAR_DEGREE_FREEDOM_KEY);
        this.mDegreeFreedomText.setAction((Action)controlAction);
        this.mDegreeFreedomText.getDocument().addDocumentListener(this);
        this.mMaxPredictorsText = new IntTextField(1, Integer.MAX_VALUE, true);
        controlAction = new TextFieldAction(this, MVAR_MAX_PREDICTORS_TEXT_KEY);
        this.mMaxPredictorsText.setAction((Action)controlAction);
        this.mMaxPredictorsText.getDocument().addDocumentListener(this);
        this.mDegreeFreedomLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MVAR_DEGREE_FREEDOM_LABEL");
        this.mDegreeFreedomLabel.setLabelFor((Component)this.mDegreeFreedomText);
        controlAction = new ToggleButtonAction(this, MVAR_SAVE_DATA_KEY);
        this.mSaveDataCheck = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this, MVAR_CREATE_DATASET_KEY);
        this.mCreateDatasetRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, MVAR_WRITE_DATAFILE_KEY);
        this.mWriteDataFileRadio = new JRadioButton(controlAction);
        this.mDatasetNameText = new StringTextField();
        controlAction = new TextFieldAction(this, MVAR_DATASET_NAME_KEY);
        this.mDatasetNameText.setAction(controlAction);
        this.mDatasetNameText.getDocument().addDocumentListener(this);
        this.mDatasetNameLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MVAR_DATASET_NAME_LABEL");
        this.mDatasetNameLabel.setLabelFor((Component)((Object)this.mDatasetNameText));
        controlAction = new ToggleButtonAction(this, "IDS_MVAR_FILE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = DataServerProxy.getDataProxy().isRemoteConnection();
                RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), bl);
                remoteFileChooser.setDialogTitle(MissingValueAnalysisRegression.this.getResString("IDS_MVA_SAVE_FILE_TITLE"));
                RefFileFilter refFileFilter = new RefFileFilter(MissingValueAnalysisRegression.this.getResString("IDS_MVA_FILE_FILTER"), MissingValueAnalysisRegression.this.getResString("IDS_MVA_FILE_EXTENSION"));
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                int n = remoteFileChooser.showSaveDialog((Component)((Object)MissingValueAnalysisRegression.this));
                if (n == 0) {
                    FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                    String string = remoteFileChooser.getSelectedFilePath();
                    if (!string.endsWith(MissingValueAnalysisRegression.this.getResString("IDS_MVA_SAVE_FILE_EXTENSION"))) {
                        string = string + MissingValueAnalysisRegression.this.getResString("IDS_MVA_SAVE_FILE_EXTENSION");
                    }
                    MissingValueAnalysisRegression.this.mFileTextField.setText(string);
                } else {
                    TraceSettings.trace1((String)"No Selection", (int)15);
                }
                MissingValueAnalysisRegression.this.enableContinueButton();
            }
        };
        this.mFileButton = new JButton(controlAction);
        this.mFileTextField = new FileTextField();
        this.mFileTextField.setAction(new TextFieldAction(this, MVAR_FILE_NAME_KEY));
        this.mFileTextField.setBorder(BorderFactory.createEmptyBorder());
        this.mDegreeFreedomText.addFocusListener((FocusListener)this);
        this.mMaxPredictorsText.addFocusListener((FocusListener)this);
        this.mDatasetNameText.addFocusListener(this);
        this.mDatasetNameText.setColumns(20);
        this.mFileTextField.setColumns(20);
        this.mDegreeFreedomText.setColumns(5);
        this.mResidualRadio.addItemListener(this);
        this.mNormalVariantRadio.addItemListener(this);
        this.mStudentRadio.addItemListener(this);
        this.mNoneRadio.addItemListener(this);
        this.mMaxPredictorsCheck.addItemListener(this);
        this.mSaveDataCheck.addItemListener(this);
        this.mCreateDatasetRadio.addItemListener(this);
        this.mWriteDataFileRadio.addItemListener(this);
    }

    private void setDefaults() {
        this.mResidualRadio.setSelected(true);
        this.mMaxPredictorsCheck.setSelected(false);
        this.mDegreeFreedomText.setText("5");
        boolean bl = this.mMaxPredictorsCheck.isSelected();
        this.mMaxPredictorsText.setEnabled(bl);
        this.mMaxPredictorsText.setOpaque(bl);
        this.mCreateDatasetRadio.setSelected(true);
        this.mFileTextField.setEnabled(false);
        this.mFileTextField.setOpaque(false);
        this.mFileTextField.setEditable(false);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mSaveDataCheck.setEnabled(false);
        }
        if (CommandLine.isClementineCaller() && RemoteFileChooser.getFileBrowseCallback() != null) {
            this.mWriteDataFileRadio.setSelected(true);
        }
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mResidualRadio);
        spssButtonGroup.add(this.mNormalVariantRadio);
        spssButtonGroup.add(this.mStudentRadio);
        spssButtonGroup.add(this.mNoneRadio);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mCreateDatasetRadio);
        spssButtonGroup2.add(this.mWriteDataFileRadio);
        vector.add(spssButtonGroup);
        vector.add(this.mDegreeFreedomText);
        vector.add(this.mMaxPredictorsCheck);
        vector.add(this.mMaxPredictorsText);
        vector.add(this.mSaveDataCheck);
        vector.add(spssButtonGroup2);
        vector.add(this.mDatasetNameText);
        vector.add(this.mFileButton);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void enableSaveDataControls() {
        boolean bl = this.mSaveDataCheck.isSelected();
        this.mCreateDatasetRadio.setEnabled(bl);
        if (CommandLine.isClementineCaller() && RemoteFileChooser.getFileBrowseCallback() != null) {
            this.mCreateDatasetRadio.setEnabled(false);
            this.mWriteDataFileRadio.setSelected(true);
        }
        this.mWriteDataFileRadio.setEnabled(bl);
        this.enableDatasetControls();
        this.enableContinueButton();
    }

    private void enableDatasetControls() {
        boolean bl = this.mCreateDatasetRadio.isSelected();
        boolean bl2 = this.mSaveDataCheck.isSelected();
        this.mDatasetNameText.setEnabled(bl2 && bl);
        this.mDatasetNameText.setOpaque(bl2 && bl);
        this.mDatasetNameLabel.setEnabled(bl2 && bl);
        this.mFileButton.setEnabled(bl2 && !bl);
        this.mFileTextField.setEnabled(this.mWriteDataFileRadio.isSelected() && bl2);
    }

    private void enableContinueButton() {
        boolean bl = true;
        if (this.mStudentRadio.isSelected()) {
            boolean bl2 = bl = this.mDegreeFreedomText.getDocument().getLength() != 0;
        }
        if (bl && this.mMaxPredictorsCheck.isSelected()) {
            boolean bl3 = bl = this.mMaxPredictorsText.getDocument().getLength() != 0;
        }
        if (bl && this.mSaveDataCheck.isSelected()) {
            if (this.mCreateDatasetRadio.isSelected()) {
                if (this.mDatasetNameText.getDocument().getLength() == 0) {
                    bl = false;
                }
            } else if (this.mFileTextField.getText() != null && this.mFileTextField.getText().length() == 0) {
                bl = false;
            }
        }
        this.enableContinue(bl);
    }

    private void enableEstAdjustmentPanelControls() {
        boolean bl = this.mStudentRadio.isSelected();
        this.mDegreeFreedomLabel.setEnabled(bl);
        this.mDegreeFreedomText.setEnabled(bl);
        this.mDegreeFreedomText.setOpaque(bl);
        this.enableContinueButton();
    }
}

