/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.missing_values.missingvalue_analysis;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.missing_values.missingvalue_analysis.MissingValueAnalysisUtil;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.util.TraceSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;

public class MissingValueAnalysisEM
extends BaseSubDialog
implements DocumentListener,
FocusListener,
ItemListener {
    static final String MVAE_NORMAL_RADIO_KEY = "IDS_MVAE_NORMAL_RADIO";
    static final String MVAE_MIXED_NORMAL_RADIO_KEY = "IDS_MVAE_MIXED_NORMAL_RADIO";
    static final String MVAE_STUDENT_T_KEY = "IDS_MVAE_STUDENTS_RADIO";
    static final String MVAE_MIX_PROPORTION_KEY = "MVAE_MIX_PROPORTION_KEY";
    static final String MVAE_STD_DEV_KEY = "MVAE_STD_DEV_KEY";
    static final String MVAE_DEGREE_FREEDOM_KEY = "MVAE_DEGREE_FREEDOM_KEY";
    static final String MVAE_MAX_ITERATIONS_KEY = "MVAE_MAX_ITERATIONS_KEY";
    static final String MVAE_SAVE_DATA_KEY = "IDS_MVAE_SAVE_DATA_CHECK";
    static final String MVAE_CREATE_DATASET_KEY = "IDS_MVAE_CREATE_DATASET_RADIO";
    static final String MVAE_WRITE_DATAFILE_KEY = "IDS_MVAE_WRITE_FILE_RADIO";
    static final String MVAE_DATASET_NAME_KEY = "MVAE_DATASET_NAME_KEY";
    static final String MVAE_FILE_NAME_KEY = "MVAE_FILE_NAME_KEY";
    private JRadioButton mNormalRadio;
    private JRadioButton mMixedNormalRadio;
    private JRadioButton mStudentRadio;
    private JLabel mMixProportionLabel;
    private JLabel mStdDeviationLabel;
    private FloatTextField mMixProportionText;
    private ContextEnabledTextField mStdDeviationText;
    private JLabel mDegreeFreedomLabel;
    private IntTextField mDegreeFreedomText;
    private JTextField mMaxIterationsText;
    private JCheckBox mSaveDataCheck;
    private JRadioButton mCreateDatasetRadio;
    private JRadioButton mWriteDataFileRadio;
    private JLabel mDatasetNameLabel;
    private StringTextField mDatasetNameText;
    private JButton mFileButton;
    private FileTextField mFileTextField;

    public MissingValueAnalysisEM(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_MVAE_EM_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_miss_em";
    }

    public void paint(Graphics graphics) {
        this.mFileTextField.setText(this.mFileTextField.getText());
        super.paint(graphics);
        super.validate();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public boolean continuePressed() {
        BigDecimal bigDecimal;
        int n = new Integer(this.mMaxIterationsText.getText());
        if (n < 1 || n > Integer.MAX_VALUE) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MVA_OUTOFRANGE_WARNING"), VersionInfo.getAppVersionString());
            this.mMaxIterationsText.requestFocus();
            this.mMaxIterationsText.selectAll();
            return false;
        }
        if (this.mMixedNormalRadio.isSelected() && (bigDecimal = new BigDecimal(this.mStdDeviationText.getText())).compareTo(new BigDecimal(0)) == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MVA_OUTOFRANGE_WARNING"), VersionInfo.getAppVersionString());
            this.mStdDeviationText.requestFocus();
            this.mStdDeviationText.selectAll();
            return false;
        }
        if (this.mSaveDataCheck.isSelected() && this.mCreateDatasetRadio.isSelected()) {
            int n2 = DatasetNameValidator.validateDatasetName((String)this.mDatasetNameText.getText(), (Component)((Object)this));
            if (n2 == 1) {
                return true;
            }
            this.mDatasetNameText.requestFocus();
            this.mDatasetNameText.selectAll();
            return false;
        }
        return true;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JTextField[] jTextFieldArray;
        for (JTextField jTextField : jTextFieldArray = new JTextField[]{this.mMixProportionText, this.mStdDeviationText, this.mDegreeFreedomText, this.mMaxIterationsText, this.mDatasetNameText}) {
            if (!focusEvent.getSource().equals(jTextField)) continue;
            jTextField.selectAll();
            break;
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mSaveDataCheck)) {
            this.enableSaveDataControls();
        } else if (itemEvent.getSource().equals(this.mCreateDatasetRadio)) {
            this.enableDatasetControls();
        } else if (itemEvent.getSource().equals(this.mWriteDataFileRadio)) {
            this.enableDatasetControls();
        } else {
            this.enableDistPanelControls();
        }
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.enableDistPanelControls();
        this.enableSaveDataControls();
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.enableDistPanelControls();
        this.enableSaveDataControls();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, n, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n3 = 23;
        JPanel jPanel2 = this.setupDistributionPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n3, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.left = n2;
        JLabel jLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MVAE_MAX_ITERATION_LABEL");
        jLabel.setLabelFor(this.mMaxIterationsText);
        Dimension dimension = new Dimension(this.getMaxLabelWidth(), jLabel.getPreferredSize().height);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n3, insets);
        gridBagConstraints.weightx = 1.0;
        insets.left = n * 4;
        DialogUtil.addUsingGBL(jPanel, this.mMaxIterationsText, gridBagConstraints, 1, 1, 1, 1, n3, insets);
        insets.left = n2;
        JComponent[] jComponentArray = new JComponent[]{this.mSaveDataCheck, this.mCreateDatasetRadio, this.mWriteDataFileRadio, this.mDatasetNameLabel, this.mDatasetNameText, this.mFileButton, this.mFileTextField};
        jPanel2 = MissingValueAnalysisUtil.createSaveDataPanel(jComponentArray);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 2, 1, n3, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    private int getMaxLabelWidth() {
        int n = this.mMixProportionLabel.getPreferredSize().width;
        int n2 = this.mStdDeviationLabel.getPreferredSize().width;
        int n3 = this.mDegreeFreedomLabel.getPreferredSize().width;
        if (n < n2) {
            n = n2;
        }
        if (n < n3) {
            n = n3;
        }
        return n;
    }

    private JPanel setupDistributionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_MVAE_DISTRIBUTION_PANEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(0, n2, insets.bottom, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n3 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mNormalRadio, gridBagConstraints, 0, 0, 2, 1, n3, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mMixedNormalRadio, gridBagConstraints, 0, 1, 2, 1, n3, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mStudentRadio, gridBagConstraints, 0, 4, 2, 1, n3, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.left = n * 3;
        DialogUtil.addUsingGBL(jPanel, this.mMixProportionLabel, gridBagConstraints, 0, 2, 1, 1, n3, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mStdDeviationLabel, gridBagConstraints, 0, 3, 1, 1, n3, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDegreeFreedomLabel, gridBagConstraints, 0, 5, 1, 1, n3, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets2.left = n;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMixProportionText, gridBagConstraints, 1, 2, 1, 1, n3, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStdDeviationText, gridBagConstraints, 1, 3, 1, 1, n3, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDegreeFreedomText, gridBagConstraints, 1, 5, 1, 1, n3, insets2);
        return jPanel;
    }

    private void initVars() {
        ControlAction controlAction = new ToggleButtonAction(this, MVAE_NORMAL_RADIO_KEY);
        this.mNormalRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, MVAE_MIXED_NORMAL_RADIO_KEY);
        this.mMixedNormalRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, MVAE_STUDENT_T_KEY);
        this.mStudentRadio = new JRadioButton(controlAction);
        this.mMixProportionText = new FloatTextField(0.0, 1.0, -1, true);
        this.mMixProportionText.setIncludeMinRange(false);
        this.mMixProportionText.setIncludeMaxRange(false);
        controlAction = new TextFieldAction(this, MVAE_MIX_PROPORTION_KEY);
        this.mMixProportionText.setAction((Action)controlAction);
        this.mMixProportionText.getDocument().addDocumentListener(this);
        this.mStdDeviationText = new ContextEnabledTextField();
        this.mStdDeviationText.setDocument((Document)new FixedLengthNumericDocument(19, true, true));
        controlAction = new TextFieldAction(this, MVAE_STD_DEV_KEY);
        this.mStdDeviationText.setAction((Action)controlAction);
        this.mStdDeviationText.getDocument().addDocumentListener(this);
        this.mDegreeFreedomText = new IntTextField(2, 200, true);
        controlAction = new TextFieldAction(this, MVAE_DEGREE_FREEDOM_KEY);
        this.mDegreeFreedomText.setAction((Action)controlAction);
        this.mDegreeFreedomText.getDocument().addDocumentListener(this);
        this.mMaxIterationsText = new JTextField();
        controlAction = new TextFieldAction(this, MVAE_MAX_ITERATIONS_KEY);
        this.mMaxIterationsText.setAction(controlAction);
        this.mMixProportionLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MVAE_MIX_PROP_LABEL");
        this.mMixProportionLabel.setLabelFor((Component)this.mMixProportionText);
        this.mStdDeviationLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MVAE_STD_DEV_LABEL");
        this.mStdDeviationLabel.setLabelFor((Component)this.mStdDeviationText);
        this.mDegreeFreedomLabel = DialogUtil.createLabel(this, "IDS_MVAE_DEGREE_FREEDOM_LABEL");
        this.mDegreeFreedomLabel.setLabelFor((Component)this.mDegreeFreedomText);
        controlAction = new ToggleButtonAction(this, MVAE_SAVE_DATA_KEY);
        this.mSaveDataCheck = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this, MVAE_CREATE_DATASET_KEY);
        this.mCreateDatasetRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, MVAE_WRITE_DATAFILE_KEY);
        this.mWriteDataFileRadio = new JRadioButton(controlAction);
        this.mDatasetNameText = new StringTextField();
        controlAction = new TextFieldAction(this, MVAE_DATASET_NAME_KEY);
        this.mDatasetNameText.setAction(controlAction);
        this.mDatasetNameText.getDocument().addDocumentListener(this);
        this.mDatasetNameLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MVAE_DATASET_NAME_LABEL");
        this.mDatasetNameLabel.setLabelFor((Component)((Object)this.mDatasetNameText));
        controlAction = new ToggleButtonAction(this, "IDS_MVAE_FILE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = DataServerProxy.getDataProxy().isRemoteConnection();
                RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), bl);
                remoteFileChooser.setDialogTitle(MissingValueAnalysisEM.this.getResString("IDS_MVA_SAVE_FILE_TITLE"));
                RefFileFilter refFileFilter = new RefFileFilter(MissingValueAnalysisEM.this.getResString("IDS_MVA_FILE_FILTER"), MissingValueAnalysisEM.this.getResString("IDS_MVA_FILE_EXTENSION"));
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                int n = remoteFileChooser.showSaveDialog((Component)((Object)MissingValueAnalysisEM.this));
                if (n == 0) {
                    FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                    String string = remoteFileChooser.getSelectedFilePath();
                    if (!string.endsWith(MissingValueAnalysisEM.this.getResString("IDS_MVA_SAVE_FILE_EXTENSION"))) {
                        string = string + MissingValueAnalysisEM.this.getResString("IDS_MVA_SAVE_FILE_EXTENSION");
                    }
                    MissingValueAnalysisEM.this.mFileTextField.setText(string);
                } else {
                    TraceSettings.trace1((String)"No Selection", (int)15);
                }
                MissingValueAnalysisEM.this.enableContinueButton();
            }
        };
        this.mFileButton = new JButton(controlAction);
        this.mFileTextField = new FileTextField();
        this.mFileTextField.setAction(new TextFieldAction(this, MVAE_FILE_NAME_KEY));
        this.mFileTextField.setBorder(BorderFactory.createEmptyBorder());
        this.mMixProportionText.addFocusListener((FocusListener)this);
        this.mStdDeviationText.addFocusListener((FocusListener)this);
        this.mDegreeFreedomText.addFocusListener((FocusListener)this);
        this.mMaxIterationsText.addFocusListener(this);
        this.mDatasetNameText.addFocusListener(this);
        this.mMixProportionText.setColumns(5);
        this.mStdDeviationText.setColumns(5);
        this.mDegreeFreedomText.setColumns(5);
        this.mMaxIterationsText.setColumns(5);
        this.mDatasetNameText.setColumns(20);
        this.mFileTextField.setColumns(20);
        this.mNormalRadio.addItemListener(this);
        this.mMixedNormalRadio.addItemListener(this);
        this.mStudentRadio.addItemListener(this);
        this.mSaveDataCheck.addItemListener(this);
        this.mCreateDatasetRadio.addItemListener(this);
        this.mWriteDataFileRadio.addItemListener(this);
    }

    private void setDefaults() {
        this.mNormalRadio.setSelected(true);
        this.mMaxIterationsText.setText("25");
        this.mSaveDataCheck.setSelected(false);
        this.mFileTextField.setEnabled(false);
        this.mFileTextField.setOpaque(false);
        this.mFileTextField.setEditable(false);
        this.mCreateDatasetRadio.setSelected(true);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mSaveDataCheck.setEnabled(false);
        }
        if (CommandLine.isClementineCaller() && RemoteFileChooser.getFileBrowseCallback() != null) {
            this.mWriteDataFileRadio.setSelected(true);
        }
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mNormalRadio);
        spssButtonGroup.add(this.mMixedNormalRadio);
        spssButtonGroup.add(this.mStudentRadio);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mCreateDatasetRadio);
        spssButtonGroup2.add(this.mWriteDataFileRadio);
        vector.add(spssButtonGroup);
        vector.add(this.mMixProportionText);
        vector.add(this.mStdDeviationText);
        vector.add(this.mDegreeFreedomText);
        vector.add(this.mMaxIterationsText);
        vector.add(this.mSaveDataCheck);
        vector.add(spssButtonGroup2);
        vector.add(this.mDatasetNameText);
        vector.add(this.mFileButton);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void enableSaveDataControls() {
        boolean bl = this.mSaveDataCheck.isSelected();
        this.mCreateDatasetRadio.setEnabled(bl);
        if (CommandLine.isClementineCaller() && RemoteFileChooser.getFileBrowseCallback() != null) {
            this.mCreateDatasetRadio.setEnabled(false);
            this.mWriteDataFileRadio.setSelected(true);
        }
        this.mWriteDataFileRadio.setEnabled(bl);
        this.enableDatasetControls();
        this.enableContinueButton();
    }

    private void enableDatasetControls() {
        boolean bl = this.mCreateDatasetRadio.isSelected();
        boolean bl2 = this.mSaveDataCheck.isSelected();
        this.mDatasetNameText.setEnabled(bl2 && bl);
        this.mDatasetNameText.setOpaque(bl2 && bl);
        this.mDatasetNameLabel.setEnabled(bl2 && bl);
        this.mFileButton.setEnabled(bl2 && !bl);
        this.mFileTextField.setEnabled(this.mWriteDataFileRadio.isSelected() && bl2);
        this.enableContinueButton();
    }

    private void enableContinueButton() {
        boolean bl = true;
        if (this.mMixedNormalRadio.isSelected()) {
            if (this.mMixProportionText.getDocument().getLength() == 0 || this.mStdDeviationText.getDocument().getLength() == 0) {
                bl = false;
            }
        } else if (this.mStudentRadio.isSelected() && this.mDegreeFreedomText.getDocument().getLength() == 0) {
            bl = false;
        }
        if (bl && this.mSaveDataCheck.isSelected()) {
            if (this.mCreateDatasetRadio.isSelected()) {
                if (this.mDatasetNameText.getDocument().getLength() == 0) {
                    bl = false;
                }
            } else if (this.mFileTextField.getText() != null && this.mFileTextField.getText().length() == 0) {
                bl = false;
            }
        }
        this.enableContinue(bl);
    }

    private void enableDistPanelControls() {
        boolean bl = this.mMixedNormalRadio.isSelected();
        this.mMixProportionLabel.setEnabled(bl);
        this.mMixProportionText.setEnabled(bl);
        this.mMixProportionText.setOpaque(bl);
        this.mStdDeviationLabel.setEnabled(bl);
        this.mStdDeviationText.setEnabled(bl);
        this.mStdDeviationText.setOpaque(bl);
        boolean bl2 = this.mStudentRadio.isSelected();
        this.mDegreeFreedomLabel.setEnabled(bl2);
        this.mDegreeFreedomText.setEnabled(bl2);
        this.mDegreeFreedomText.setOpaque(bl2);
        this.enableContinueButton();
    }
}

