/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.missing_values.missingvalue_analysis;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.missing_values.missingvalue_analysis.MissingValueAnalysisDescriptives;
import com.spss.java_client.ui.dialogs.missing_values.missingvalue_analysis.MissingValueAnalysisEM;
import com.spss.java_client.ui.dialogs.missing_values.missingvalue_analysis.MissingValueAnalysisPatterns;
import com.spss.java_client.ui.dialogs.missing_values.missingvalue_analysis.MissingValueAnalysisRegression;
import com.spss.java_client.ui.dialogs.missing_values.missingvalue_analysis.MissingValueAnalysisUtil;
import com.spss.java_client.ui.dialogs.missing_values.missingvalue_analysis.MissingValueAnalysisVariables;
import com.spss.java_client.ui.dialogs.missing_values.res.MissingValuesResBundle;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MissingValueAnalysisDlg
extends BaseProcedureDialog
implements ListDataListener,
DocumentListener,
FocusListener {
    private static final String MVA_SOURCE_LIST = "MVA_SOURCE_LIST";
    private static final String MVA_QUNATITATIVE_VAR_LIST = "MVA_QUNATITATIVE_VAR_LIST";
    private static final String MVA_CATEGORIACAL_VAR_LIST = "MVA_CATEGORIACAL_VAR_LIST";
    private static final String MVA_CASELABEL_VAR_LIST = "MVA_CASELABEL_VAR_LIST";
    private static final String MVA_CAT_VAR_TEXT = "MVA_CAT_VAR_TEXT";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mQuantitativeVarList;
    private TargetVariableList mCategoryVarList;
    private TargetVariableList mCaseLabelsVarList;
    private ArrowButton mQuantitativeVarArrow;
    private ArrowButton mCategoryVarArrow;
    private ArrowButton mCaseLabelsArrow;
    private JButton mUseAllVarsButton;
    private JButton mPatternsButton;
    private JButton mDescriptivesButton;
    private JButton mVariablesButton;
    private JButton mEMBtton;
    private JButton mRegressionButton;
    private JCheckBox mListwiseCheck;
    private JCheckBox mPairwiseCheck;
    private JCheckBox mEMCheck;
    private JCheckBox mRegressionCheck;
    private IntTextField mMaxCatText;
    private JLabel mMaxCatLabel;
    private String mEMOutfile;
    private String mRegressionOutfile;

    public MissingValueAnalysisDlg(JFrame jFrame) {
        super(jFrame, false, MissingValuesResBundle.getDefaultResourceBundleName(), MissingValuesResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_MVA_TITLE"));
    }

    @Override
    public String generateSyntax() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        this.mEMOutfile = null;
        this.mRegressionOutfile = null;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_MVAR_CREATE_DATASET_RADIO");
        if (bl != null && bl.booleanValue() && (string5 = dialogDataModel.getString("MVAR_DATASET_NAME_KEY")).length() > 0) {
            stringBuffer.append(SyntaxUtil.getMainCommand("DATASET DECLARE "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string5));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MVAE_CREATE_DATASET_RADIO")) != null && bl.booleanValue() && (string5 = dialogDataModel.getString("MVAE_DATASET_NAME_KEY")).length() > 0) {
            stringBuffer.append(SyntaxUtil.getMainCommand("DATASET DECLARE "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string5));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("MVA"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES=" + this.mQuantitativeVarList.getVariablesStringList()));
        stringBuffer.append(" ").append(this.mCategoryVarList.getVariablesStringList());
        int n = this.mCategoryVarList.getModel().getSize();
        if (n > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("MAXCAT", this.mMaxCatText.getText(), false));
        }
        if (this.mCaseLabelsVarList.getModel().getSize() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("ID", this.mCaseLabelsVarList.getVariablesStringList(), false));
        }
        if (n > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("CATEGORICAL", this.mCategoryVarList.getVariablesStringList(), false));
        }
        if ((string4 = this.generateDescriptivesSyntax(dialogDataModel)).length() > 0) {
            stringBuffer.append(string4);
        }
        if ((string3 = this.generatePatternSyntax(dialogDataModel)).length() > 0) {
            stringBuffer.append(string3);
        }
        if (this.mListwiseCheck.isSelected()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/LISTWISE"));
        }
        if (this.mPairwiseCheck.isSelected()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/PAIRWISE"));
        }
        String string6 = this.generateVariableSyntax(dialogDataModel);
        String string7 = this.generateEMSyntax(dialogDataModel);
        if (string7.length() > 0) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/EM"));
            if (string6.length() > 0) {
                stringBuffer.append(string6);
            }
            stringBuffer.append(string7);
        }
        if ((string2 = this.generateRegressionSyntax(dialogDataModel)).length() > 0) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/REGRESSION"));
            if (string6.length() > 0) {
                stringBuffer.append(string6);
            }
            stringBuffer.append(string2);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        PesFile pesFile = PES_Repository.getPesFile((String)this.mEMOutfile);
        if (pesFile != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        if ((pesFile = PES_Repository.getPesFile((String)this.mRegressionOutfile)) != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    @Override
    public final String getIActionKey() {
        return "analyze_missing_val";
    }

    @Override
    public void reset() {
        super.reset();
        this.mQuantitativeVarList.removeAll();
        this.mCategoryVarList.removeAll();
        this.mCaseLabelsVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.setDefaults();
        this.enableOkButton();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableEstimationPanelControl();
        this.enableMaxCatControl();
        this.enableOkButton();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableEstimationPanelControl();
        this.enableMaxCatControl();
        this.enableOkButton();
        this.updateDialogDataModel("MVAP_MISSING_PATTERN_LIST_KEY", true, true);
        this.updateDialogDataModel("MVAP_ADD_INFO_LIST_KEY", true, true);
        this.updateDialogDataModel("MVAP_SORT_BY_LIST_KEY", true, true);
        this.updateDialogDataModel("MVAV_QUANTITATIVE_VARSLIST_KEY", true, false);
        this.updateDialogDataModel("MVAV_PREDICTOR_VARSLIST_KEY", true, false);
        this.updateDialogDataModel("MVAV_PREDICTED_VARSLIST_KEY", true, false);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableEstimationPanelControl();
        this.enableMaxCatControl();
        this.enableOkButton();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableOkButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableOkButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableOkButton();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_miss";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.mMaxCatText.selectAll();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public String getAllSeletedVars() {
        return this.mQuantitativeVarList.getVariablesStringList() + " " + this.mCategoryVarList.getVariablesStringList();
    }

    public VarListModel getQuantitativeVarList() {
        return this.mQuantitativeVarList.getModel();
    }

    public VarListModel getCategoryVarList() {
        return this.mCategoryVarList.getModel();
    }

    public String getQuantitativeVars() {
        return this.mQuantitativeVarList.getVariablesStringList();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.enableEstimationPanelButtons();
        this.enableEstimationPanelControl();
        this.enableMaxCatControl();
        this.enableOkButton();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        this.enableMaxCatControl();
        this.enableEstimationPanelControl();
        this.enableEstimationPanelButtons();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_MVA_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, DialogUtil.getStandardControlInsets().bottom, 0);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 6, n, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_MVA_QUANTATIVE_VAR_LABEL");
        jLabel2.setLabelFor(this.mQuantitativeVarList);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mQuantitativeVarList);
        jScrollPane.setPreferredSize(this.mQuantitativeVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mQuantitativeVarArrow, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        jLabel2 = DialogUtil.createLabel(this, "IDS_MVA_CATEGORICAL_VAR_LABEL");
        jLabel2.setLabelFor(this.mCategoryVarList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        insets.top = n2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mCategoryVarList);
        jScrollPane.setPreferredSize(this.mCategoryVarList.getMinimumSize());
        insets.top = 0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mCategoryVarArrow, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        JPanel jPanel2 = this.setupMaxCategoryFields();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 4, 2, 1, n, insets);
        jLabel2 = DialogUtil.createLabel(this, "IDS_MVA_CASE_LABELS");
        jLabel2.setLabelFor(this.mCaseLabelsVarList);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 5, 1, 1, n, new Insets(0, 0, DialogUtil.getGroupBoxInnerMargin() * 4, 0));
        gridBagConstraints.fill = 2;
        jScrollPane = new JScrollPane(this.mCaseLabelsVarList);
        jScrollPane.setPreferredSize(this.mCaseLabelsVarList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 5, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mCaseLabelsArrow, gridBagConstraints, 1, 5, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        insets.left = 0;
        insets.right = 0;
        insets.top = n2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mUseAllVarsButton, gridBagConstraints, 0, 7, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.left = n2;
        insets.top = 0;
        insets.bottom = n2;
        jPanel2 = this.setupPatternDescEstmPanel();
        DialogUtil.normalizeButtonWidths((JPanel)jPanel2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 3, 0, 1, 5, n, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    private void enableOkButton() {
        if (this.mCategoryVarList.getModel().getSize() > 0) {
            if (this.mMaxCatText.getText().length() > 0) {
                this.enableOkPaste(true);
            } else {
                this.enableOkPaste(false);
            }
        } else if (this.mQuantitativeVarList.getModel().getSize() > 0) {
            this.enableOkPaste(true);
        } else {
            this.enableOkPaste(false);
        }
    }

    private void updateDialogDataModel(String string, boolean bl, boolean bl2) {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(string);
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (bl && this.isItemPresent(iSpssVariable, this.mQuantitativeVarList)) {
                    vector.add(iSpssVariable);
                }
                if (!bl2 || !this.isItemPresent(iSpssVariable, this.mCategoryVarList)) continue;
                vector.add(iSpssVariable);
            }
            if (vector.size() > 0) {
                ISpssVariable[] iSpssVariableArray2 = new ISpssVariable[vector.size()];
                dialogDataModel.putVarArray(string, vector.toArray(iSpssVariableArray2));
            } else {
                dialogDataModel.putVarArray(string, null);
            }
        }
    }

    private boolean isItemPresent(ISpssVariable iSpssVariable, TargetVariableList targetVariableList) {
        boolean bl = !RemoteFileChooser.enableSaveInModeler();
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            LocallyUniqueId locallyUniqueId;
            if (!(!bl ? (locallyUniqueId = targetVariableList.getModel().getElementAt(i).getId()).equals((Object)iSpssVariable.getId()) : targetVariableList.getModel().getElementAt(i).getName().equals(iSpssVariable.getName()))) continue;
            return true;
        }
        return false;
    }

    private String generatePatternSyntax(DialogDataModel dialogDataModel) {
        Boolean bl = dialogDataModel.getBoolean("IDS_MVAP_ALL_CASES_CHECK");
        StringBuffer stringBuffer = new StringBuffer();
        if (bl != null) {
            StringBuffer stringBuffer2 = new StringBuffer();
            ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("MVAP_ADD_INFO_LIST_KEY");
            String string = MissingValueAnalysisUtil.getVariableString(iSpssVariableArray);
            if (string.length() > 0) {
                stringBuffer2.append(" DESCRIBE=").append(string);
            }
            if (bl.booleanValue()) {
                stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/DPATTERN"));
                stringBuffer.append(stringBuffer2.toString());
                iSpssVariableArray = dialogDataModel.getVarArray("MVAP_SORT_BY_LIST_KEY");
                string = MissingValueAnalysisUtil.getVariableString(iSpssVariableArray);
                if (string.length() > 0) {
                    stringBuffer.append(" SORT=").append(string);
                    bl = dialogDataModel.getBoolean("IDS_MVAP_ASC_RADIO");
                    if (bl.booleanValue()) {
                        stringBuffer.append("(ASCENDING)");
                    } else {
                        stringBuffer.append("(DESCENDING)");
                    }
                }
            }
            if ((bl = dialogDataModel.getBoolean("IDS_MVAP_CASES_MISSING_VAL_CHECK")) != null && bl.booleanValue()) {
                stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/MPATTERN"));
                bl = dialogDataModel.getBoolean("IDS_MVAP_CMV_TC_SORT_VARS_CHECK");
                if (bl != null && !bl.booleanValue()) {
                    stringBuffer.append(" NOSORT");
                }
                stringBuffer.append(stringBuffer2.toString());
            }
            if ((bl = dialogDataModel.getBoolean("IDS_MVAP_TABULATED_CASES_CHECK")) != null && bl.booleanValue()) {
                stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/TPATTERN"));
                bl = dialogDataModel.getBoolean("IDS_MVAP_TC_SORT_VARS_CHECK");
                if (!bl.booleanValue()) {
                    stringBuffer.append(" NOSORT");
                }
                if ((string = dialogDataModel.getString("MVAP_OMIT_PATTERN_KEY")).length() > 0) {
                    stringBuffer.append(" PERCENT=").append(string);
                }
                stringBuffer.append(stringBuffer2.toString());
            }
        }
        return stringBuffer.toString();
    }

    private String generateEMSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mEMCheck.isSelected()) {
            stringBuffer.append("(TOLERANCE=0.001");
            stringBuffer.append(" CONVERGENCE=0.0001");
            stringBuffer.append(" ITERATIONS=");
            String string = dialogDataModel.getString("MVAE_MAX_ITERATIONS_KEY");
            if (string != null) {
                stringBuffer.append(string);
                Boolean bl = dialogDataModel.getBoolean("IDS_MVAE_MIXED_NORMAL_RADIO");
                if (bl != null && bl.booleanValue()) {
                    string = dialogDataModel.getString("MVAE_STD_DEV_KEY");
                    stringBuffer.append(" LAMBDA=").append(string);
                    string = dialogDataModel.getString("MVAE_MIX_PROPORTION_KEY");
                    stringBuffer.append(" PROPORTION=").append(string);
                }
                if ((bl = dialogDataModel.getBoolean("IDS_MVAE_STUDENTS_RADIO")) != null && bl.booleanValue()) {
                    string = dialogDataModel.getString("MVAE_DEGREE_FREEDOM_KEY");
                    stringBuffer.append(" TDF=").append(string);
                }
                if ((bl = dialogDataModel.getBoolean("IDS_MVAE_SAVE_DATA_CHECK")) != null && bl.booleanValue()) {
                    bl = dialogDataModel.getBoolean("IDS_MVAE_CREATE_DATASET_RADIO");
                    if (bl != null && bl.booleanValue()) {
                        string = dialogDataModel.getString("MVAE_DATASET_NAME_KEY");
                        stringBuffer.append(" OUTFILE=").append(string);
                    } else {
                        this.mEMOutfile = dialogDataModel.getString("MVAE_FILE_NAME_KEY");
                        stringBuffer.append(" OUTFILE=").append(CharacterUtil.smartQuote((String)this.mEMOutfile));
                    }
                }
            } else {
                stringBuffer.append("25");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private String generateRegressionSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mRegressionCheck.isSelected()) {
            stringBuffer.append("(TOLERANCE=0.001");
            stringBuffer.append(" FLIMIT=4.0");
            Boolean bl = dialogDataModel.getBoolean("IDS_MVAR_RESIDUALS_RADIO");
            if (bl != null) {
                String string;
                Boolean bl2 = dialogDataModel.getBoolean("IDS_MVAR_MAX_PREDICTORS_CHECK");
                if (bl2 != null && bl2.booleanValue()) {
                    string = dialogDataModel.getString("MVAR_MAX_PREDICTORS_TEXT_KEY");
                    stringBuffer.append(" NPREDICTORS=").append(string);
                }
                if (bl.booleanValue()) {
                    stringBuffer.append(" ADDTYPE=RESIDUAL");
                } else {
                    bl2 = dialogDataModel.getBoolean("IDS_MVAR_NORMAL_VARIATES_RADIO");
                    if (bl2 != null && bl2.booleanValue()) {
                        stringBuffer.append(" ADDTYPE=NORMAL");
                    } else {
                        bl2 = dialogDataModel.getBoolean("IDS_MVAR_STUDENTS_VARIATES_RADIO");
                        if (bl2 != null && bl2.booleanValue()) {
                            string = dialogDataModel.getString("IDS_MVAR_DEGREE_FREEDOM_RADIO");
                            stringBuffer.append(" ADDTYPE=T(").append(string).append(")");
                        } else {
                            stringBuffer.append(" ADDTYPE=NONE");
                        }
                    }
                }
                bl2 = dialogDataModel.getBoolean("IDS_MVAR_SAVE_DATA_CHECK");
                if (bl2 != null && bl2.booleanValue()) {
                    bl2 = dialogDataModel.getBoolean("IDS_MVAR_CREATE_DATASET_RADIO");
                    if (bl2 != null && bl2.booleanValue()) {
                        String string2 = dialogDataModel.getString("MVAR_DATASET_NAME_KEY");
                        stringBuffer.append(" OUTFILE=").append(string2);
                    } else {
                        this.mRegressionOutfile = dialogDataModel.getString("MVAR_FILE_NAME_KEY");
                        stringBuffer.append(" OUTFILE=").append(CharacterUtil.smartQuote((String)this.mRegressionOutfile));
                    }
                }
            } else {
                stringBuffer.append(" ADDTYPE=RESIDUAL");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private String generateVariableSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = dialogDataModel.getBoolean("IDS_MVAV_SELECT_VAR_RADIO");
        if (bl != null && bl.booleanValue()) {
            ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("MVAV_PREDICTED_VARSLIST_KEY");
            String string = MissingValueAnalysisUtil.getVariableString(iSpssVariableArray);
            if (string.length() > 0) {
                stringBuffer.append(" ");
                stringBuffer.append(string);
            }
            stringBuffer.append(" WITH ");
            iSpssVariableArray = dialogDataModel.getVarArray("MVAV_PREDICTOR_VARSLIST_KEY");
            string = MissingValueAnalysisUtil.getVariableString(iSpssVariableArray);
            if (string.length() > 0) {
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    private String generateDescriptivesSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = dialogDataModel.getBoolean("IDS_MVAD_UNIVAR_STATS_CHECK");
        if (bl != null) {
            if (!bl.booleanValue()) {
                stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/NOUNIVARIATE"));
            }
            String string = dialogDataModel.getString("IDS_MVAD_OMIT_VAR_EDIT");
            String string2 = "";
            if (string.length() > 0) {
                string2 = " PERCENT=" + string;
            }
            if ((bl = dialogDataModel.getBoolean("IDS_MVAD_TTEST_CHECK")) != null && bl.booleanValue()) {
                stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/TTEST"));
                bl = dialogDataModel.getBoolean("IDS_MVAD_INCLUDE_PROB_CHECK");
                if (bl != null && bl.booleanValue()) {
                    stringBuffer.append(" PROB");
                } else {
                    stringBuffer.append(" NOPROB");
                }
                stringBuffer.append(string2);
            }
            if ((bl = dialogDataModel.getBoolean("IDS_MVAD_CROSS_TAB_CHECK")) != null && bl.booleanValue()) {
                stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/CROSSTAB"));
                stringBuffer.append(string2);
            }
            if ((bl = dialogDataModel.getBoolean("IDS_MVAD_PERC_MATCH_CHECK")) != null && bl.booleanValue()) {
                stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/MISMATCH"));
                bl = dialogDataModel.getBoolean("IDS_MVAD_SORT_MISSING_VAL_CHECK");
                if (bl == null || !bl.booleanValue()) {
                    stringBuffer.append(" NOSORT");
                }
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    private JPanel setupPatternDescEstmPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardButtonInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mPatternsButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mDescriptivesButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel2 = this.setupEstimationPanel();
        DialogUtil.normalizeButtonWidths((JPanel)jPanel2);
        Insets insets2 = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupEstimationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_MVA_ESTIMATION_PANEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = DialogUtil.getStandardButtonInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mListwiseCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mPairwiseCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mEMCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRegressionCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mVariablesButton, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mEMBtton, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mRegressionButton, gridBagConstraints, 0, 6, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupMaxCategoryFields() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n, DialogUtil.getArrowButtonInsets().left, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mMaxCatLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        insets.left = n;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxCatText, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setIdentifier(MVA_SOURCE_LIST);
        ListDataListener listDataListener = new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                this.checkChangeUseAllVarsBtnState();
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                this.checkChangeUseAllVarsBtnState();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                this.checkChangeUseAllVarsBtnState();
            }

            private void checkChangeUseAllVarsBtnState() {
                if (MissingValueAnalysisDlg.this.mSrcVarList.getModel().getSize() == 0) {
                    MissingValueAnalysisDlg.this.mUseAllVarsButton.setEnabled(false);
                } else {
                    MissingValueAnalysisDlg.this.mUseAllVarsButton.setEnabled(true);
                }
            }
        };
        this.mSrcVarList.getModel().addListDataListener(listDataListener);
        this.mQuantitativeVarList = new TargetVariableList();
        this.mQuantitativeVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mQuantitativeVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mQuantitativeVarList.setIdentifier(MVA_QUNATITATIVE_VAR_LIST);
        this.mQuantitativeVarList.getModel().addListDataListener(this);
        this.mCategoryVarList = new TargetVariableList();
        this.mCategoryVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCategoryVarList.setIdentifier(MVA_CATEGORIACAL_VAR_LIST);
        this.mCategoryVarList.getModel().addListDataListener(this);
        this.mCaseLabelsVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mCaseLabelsVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCaseLabelsVarList.setIdentifier(MVA_CASELABEL_VAR_LIST);
        this.mQuantitativeVarArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mQuantitativeVarArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mQuantitativeVarArrow.registerVariableList(this.mQuantitativeVarList, SpssArrowButton.ButtonOrientation.left);
        this.mCategoryVarArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCategoryVarArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCategoryVarArrow.registerVariableList(this.mCategoryVarList, SpssArrowButton.ButtonOrientation.left);
        this.mCaseLabelsArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCaseLabelsArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCaseLabelsArrow.registerVariableList(this.mCaseLabelsVarList, SpssArrowButton.ButtonOrientation.left);
        this.mMaxCatText = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mMaxCatText.setAction((Action)new TextFieldAction(this, MVA_CAT_VAR_TEXT));
        this.mMaxCatText.getDocument().addDocumentListener(this);
        this.mMaxCatText.addFocusListener((FocusListener)this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_MVA_LISTWISE_CHECK");
        this.mListwiseCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_MVA_PAIRWISE_CHECK");
        this.mPairwiseCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_MVA_EM_CHECK"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MissingValueAnalysisDlg.this.enableEstimationPanelButtons();
                super.actionPerformed(actionEvent);
            }
        };
        this.mEMCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_MVA_REGRESSION_CHECK"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MissingValueAnalysisDlg.this.enableEstimationPanelButtons();
                super.actionPerformed(actionEvent);
            }
        };
        this.mRegressionCheck = new JCheckBox(toggleButtonAction);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mListwiseCheck);
        spssButtonGroup.add(this.mPairwiseCheck);
        spssButtonGroup.add(this.mEMCheck);
        spssButtonGroup.add(this.mRegressionCheck);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_MVA_USE_ALL_VARS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < MissingValueAnalysisDlg.this.mSrcVarList.getModel().getSize(); ++i) {
                    ISpssVariable iSpssVariable = MissingValueAnalysisDlg.this.mSrcVarList.getModel().getElementAt(i);
                    if (iSpssVariable.getType() == 0) {
                        MissingValueAnalysisDlg.this.mQuantitativeVarList.getModel().addElement(iSpssVariable);
                        continue;
                    }
                    MissingValueAnalysisDlg.this.mCategoryVarList.getModel().addElement(iSpssVariable);
                }
                MissingValueAnalysisDlg.this.mSrcVarList.removeAll();
            }
        };
        this.mUseAllVarsButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_MVA_PATTERNS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MissingValueAnalysisDlg.this.runPatternsSubDialog();
            }
        };
        this.mPatternsButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_MVA_DESCRIPTIVES_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MissingValueAnalysisDlg.this.runDescriptiveSubDialog();
            }
        };
        this.mDescriptivesButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_MVA_VARIABLES_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MissingValueAnalysisDlg.this.runVariablesSubDialog();
            }
        };
        this.mVariablesButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_MVA_EM_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MissingValueAnalysisDlg.this.runEMSubDialog();
            }
        };
        this.mEMBtton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_MVA_REGRESSION_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MissingValueAnalysisDlg.this.runRegressionSubDialog();
            }
        };
        this.mRegressionButton = new JButton(toggleButtonAction);
        this.mMaxCatLabel = DialogUtil.createLabel(this, "IDS_MVA_MAX_CATEGORIES_LABEL");
        this.mMaxCatLabel.setLabelFor((Component)this.mMaxCatText);
    }

    private void setDefaults() {
        if (this.mSrcVarList.getModel().getSize() >= 0) {
            this.mSrcVarList.setSelectedIndex(0);
            this.mSrcVarList.requestFocus();
        }
        this.mMaxCatText.setColumns(5);
        this.mMaxCatText.setText("25");
        this.mListwiseCheck.setSelected(false);
        this.mPairwiseCheck.setSelected(false);
        this.mEMCheck.setSelected(false);
        this.mRegressionCheck.setSelected(false);
    }

    private void enableEstimationPanelControl() {
        boolean bl = false;
        if (this.mQuantitativeVarList.getModel().getSize() > 0) {
            bl = true;
            this.enableEstimationPanelButtons();
        } else {
            this.mVariablesButton.setEnabled(false);
            this.mEMBtton.setEnabled(false);
            this.mRegressionButton.setEnabled(false);
        }
        this.mListwiseCheck.setEnabled(bl);
        this.mPairwiseCheck.setEnabled(bl);
        this.mEMCheck.setEnabled(bl);
        this.mRegressionCheck.setEnabled(bl);
    }

    private void enableMaxCatControl() {
        boolean bl = false;
        if (this.mCategoryVarList.getModel().getSize() > 0) {
            bl = true;
        }
        this.mMaxCatText.setEnabled(bl);
        this.mMaxCatText.setOpaque(bl);
        this.mMaxCatLabel.setEnabled(bl);
        this.enableOkButton();
    }

    private void enableEstimationPanelButtons() {
        this.mEMBtton.setEnabled(this.mEMCheck.isSelected());
        this.mRegressionButton.setEnabled(this.mRegressionCheck.isSelected());
        this.mVariablesButton.setEnabled(this.mEMCheck.isSelected() || this.mRegressionCheck.isSelected());
    }

    private void runPatternsSubDialog() {
        this.runSubDialog(new MissingValueAnalysisPatterns(this));
    }

    private void runDescriptiveSubDialog() {
        this.runSubDialog(new MissingValueAnalysisDescriptives(this));
    }

    private void runVariablesSubDialog() {
        this.runSubDialog(new MissingValueAnalysisVariables(this));
    }

    private void runEMSubDialog() {
        this.runSubDialog(new MissingValueAnalysisEM(this));
    }

    private void runRegressionSubDialog() {
        this.runSubDialog(new MissingValueAnalysisRegression(this));
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mUseAllVarsButton);
        vector.add(this.mQuantitativeVarArrow);
        vector.add(this.mQuantitativeVarList);
        vector.add(this.mCategoryVarArrow);
        vector.add(this.mCategoryVarList);
        vector.add(this.mMaxCatText);
        vector.add(this.mCaseLabelsArrow);
        vector.add(this.mCaseLabelsVarList);
        vector.add(this.mPatternsButton);
        vector.add(this.mDescriptivesButton);
        vector.add(this.mListwiseCheck);
        vector.add(this.mPairwiseCheck);
        vector.add(this.mEMCheck);
        vector.add(this.mRegressionCheck);
        vector.add(this.mVariablesButton);
        vector.add(this.mEMBtton);
        vector.add(this.mRegressionButton);
        Component[] componentArray = this.mCmdButtonPanel.getComponents();
        vector.addAll(Arrays.asList(componentArray));
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

