/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.missing_values.missingvalue_analysis;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;

public class MissingValueAnalysisDescriptives
extends BaseSubDialog
implements FocusListener {
    static final String MVAD_UNIVARIATE_KEY = "IDS_MVAD_UNIVAR_STATS_CHECK";
    static final String MVAD_PERCENTAGE_MISMATCH_KEY = "IDS_MVAD_PERC_MATCH_CHECK";
    static final String MVAD_SORTBY_MISSINGVAL_KEY = "IDS_MVAD_SORT_MISSING_VAL_CHECK";
    static final String MVAD_T_TEST_KEY = "IDS_MVAD_TTEST_CHECK";
    static final String MVAD_INCLUDE_PROB_KEY = "IDS_MVAD_INCLUDE_PROB_CHECK";
    static final String MVAD_CROSS_TAB_KEY = "IDS_MVAD_CROSS_TAB_CHECK";
    static final String MVAD_OMIT_VAR_KEY = "IDS_MVAD_OMIT_VAR_EDIT";
    private JCheckBox mUnivariateStatsCheck;
    private JCheckBox mPercentageMismatchCheck;
    private JCheckBox mSortMissingValCheck;
    private JCheckBox mTTestCheck;
    private JCheckBox mIncludeProbCheck;
    private JCheckBox mCrossTabCheck;
    private JLabel mOmitVarLabel;
    private FloatTextField mOmitVarText;
    private JLabel mPercentageCasesLabel;

    public MissingValueAnalysisDescriptives(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_MVAD_DESC_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_miss_desc";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.mOmitVarText.selectAll();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.mSortMissingValCheck.setEnabled(this.mPercentageMismatchCheck.isSelected());
        this.mIncludeProbCheck.setEnabled(this.mTTestCheck.isSelected());
        this.enableOmitVarControls();
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.enableOmitVarControls();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mUnivariateStatsCheck, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupIndicatorVarPanel();
        insets.bottom = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    private JPanel setupIndicatorVarPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_MVAD_INDICATOR_VAR_STATS_PANEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(0, n2, insets.bottom, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n3 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mPercentageMismatchCheck, gridBagConstraints, 0, 0, 3, 1, n3, insets2);
        insets2.left = n * 2;
        DialogUtil.addUsingGBL(jPanel, this.mSortMissingValCheck, gridBagConstraints, 0, 1, 3, 1, n3, insets2);
        insets2.left = n2;
        DialogUtil.addUsingGBL(jPanel, this.mTTestCheck, gridBagConstraints, 0, 2, 3, 1, n3, insets2);
        insets2.left = n * 2;
        DialogUtil.addUsingGBL(jPanel, this.mIncludeProbCheck, gridBagConstraints, 0, 3, 3, 1, n3, insets2);
        insets2.left = n2;
        insets2.bottom = n;
        DialogUtil.addUsingGBL(jPanel, this.mCrossTabCheck, gridBagConstraints, 0, 4, 3, 1, n3, insets2);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 5, 3, 1, n3, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets2.left = n;
        insets2.right = 0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mOmitVarLabel, gridBagConstraints, 0, 6, 1, 1, n3, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mOmitVarText, gridBagConstraints, 1, 6, 1, 1, n3, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.right = n2;
        DialogUtil.addUsingGBL(jPanel, this.mPercentageCasesLabel, gridBagConstraints, 2, 6, 1, 1, n3, insets2);
        return jPanel;
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, MVAD_UNIVARIATE_KEY);
        this.mUnivariateStatsCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MVAD_PERCENTAGE_MISMATCH_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = MissingValueAnalysisDescriptives.this.mPercentageMismatchCheck.isSelected();
                MissingValueAnalysisDescriptives.this.mSortMissingValCheck.setEnabled(bl);
                MissingValueAnalysisDescriptives.this.enableOmitVarControls();
            }
        };
        this.mPercentageMismatchCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MVAD_SORTBY_MISSINGVAL_KEY);
        this.mSortMissingValCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MVAD_T_TEST_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MissingValueAnalysisDescriptives.this.mIncludeProbCheck.setEnabled(MissingValueAnalysisDescriptives.this.mTTestCheck.isSelected());
                MissingValueAnalysisDescriptives.this.enableOmitVarControls();
            }
        };
        this.mTTestCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MVAD_INCLUDE_PROB_KEY);
        this.mIncludeProbCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MVAD_CROSS_TAB_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MissingValueAnalysisDescriptives.this.enableOmitVarControls();
            }
        };
        this.mCrossTabCheck = new JCheckBox(toggleButtonAction);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mPercentageMismatchCheck);
        spssButtonGroup.add(this.mTTestCheck);
        spssButtonGroup.add(this.mCrossTabCheck);
        this.mOmitVarText = new FloatTextField(0.0, 100.0, -1, true);
        this.mOmitVarText.setIncludeMaxRange(false);
        this.mOmitVarText.setAction((Action)new TextFieldAction(this, MVAD_OMIT_VAR_KEY));
        this.mOmitVarText.addFocusListener((FocusListener)this);
        this.mOmitVarLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MVAD_OMIT_VAR_LABEL");
        this.mOmitVarLabel.setLabelFor((Component)this.mOmitVarText);
        this.mPercentageCasesLabel = new JLabel(this.getResString("IDS_MVAD_PERC_CASES_LABEL"), 10);
    }

    private void setDefaults() {
        this.mUnivariateStatsCheck.setSelected(true);
        this.mPercentageMismatchCheck.setSelected(false);
        this.mSortMissingValCheck.setSelected(true);
        this.mSortMissingValCheck.setEnabled(this.mPercentageMismatchCheck.isSelected());
        this.mTTestCheck.setSelected(false);
        this.mIncludeProbCheck.setEnabled(this.mTTestCheck.isSelected());
        this.mIncludeProbCheck.setSelected(false);
        this.mCrossTabCheck.setSelected(false);
        this.mOmitVarText.setColumns(4);
        this.mOmitVarText.setText("5");
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mUnivariateStatsCheck);
        vector.add(this.mPercentageMismatchCheck);
        vector.add(this.mSortMissingValCheck);
        vector.add(this.mTTestCheck);
        vector.add(this.mIncludeProbCheck);
        vector.add(this.mCrossTabCheck);
        vector.add(this.mOmitVarText);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void enableOmitVarControls() {
        boolean bl = this.mCrossTabCheck.isSelected() || this.mPercentageMismatchCheck.isSelected() || this.mTTestCheck.isSelected();
        this.mOmitVarLabel.setEnabled(bl);
        this.mOmitVarText.setEnabled(bl);
        this.mOmitVarText.setOpaque(bl);
        this.mPercentageCasesLabel.setEnabled(bl);
    }
}

