/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.proxscal;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.res.MarketResearchResBundle;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.IDlgKeyPressListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;

public class ProxscalDlg
extends BaseGatingDialog
implements ItemListener {
    private GridBagConstraints mConstaints;
    private Insets mInsets;
    private JRadioButton mDataAreProximitiesRadioButton;
    private JRadioButton mCreateProximitiesFromDataRadioButton;
    private JRadioButton mOneMatrixRadioButton;
    private JRadioButton mMultipleMatrixRadioButton;
    private JList mOneSourceList;
    private JList mMultipleSourcesList;
    private ImageIcon mPMatrixAcrossColumnImage;
    private ImageIcon mPSingleColumnImage;
    private ImageIcon mPStackedMatricesAcrossColumnImage;
    private ImageIcon mPOneSourcePerColumnImage;
    private ImageIcon mPStackedInSingleColumnImage;
    private ImageIcon mBlankImage;
    private int mOneMatrixSelectedIndex;
    private int mMultipleMatricesSelectedIndex;
    private Vector<Object> mFocus;
    private JLabel mMatrixAcrossColumns;
    private JLabel mSingleColumn;
    private JLabel mStackedMatricesAcrossColumns;
    private JLabel mOneSourcePerColumn;
    private JLabel mStackedSingleColumn;

    public ProxscalDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, MarketResearchResBundle.getDefaultResourceBundleName(), MarketResearchResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_PROXSCAL_DIALOG_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        if (!ProxscalDlg.isAlwaysModal()) {
            this.setModal(false);
        }
        this.mKeyAdapter.addDlgKeyPressListener((IDlgKeyPressListener)new ProxscalDlgKeyListener());
    }

    @Override
    public String getIActionKey() {
        return "analyze_scale_mult_proxscal";
    }

    @Override
    public String getNextProcDlgActionKey() {
        if (this.mCreateProximitiesFromDataRadioButton.isSelected()) {
            return "analyze_scale_create_prox_from_data";
        }
        if (this.mDataAreProximitiesRadioButton.isSelected()) {
            if (this.mOneMatrixRadioButton.isSelected()) {
                if (this.mOneSourceList.getSelectedIndex() == 0) {
                    return "analyze_scale_one_matr_prox_in_matrices";
                }
                if (this.mOneSourceList.getSelectedIndex() == 1) {
                    return "analyze_scale_one_matr_prox_in_one_col";
                }
            } else if (this.mMultipleMatrixRadioButton.isSelected()) {
                if (this.mMultipleSourcesList.getSelectedIndex() == 0) {
                    return "analyze_scale_mult_matr_prox_in_matrices";
                }
                if (this.mMultipleSourcesList.getSelectedIndex() == 1) {
                    return "analyze_scale_mult_matr_prox_in_cols";
                }
                if (this.mMultipleSourcesList.getSelectedIndex() == 2) {
                    return "analyze_scale_mult_matr_prox_in_one_col";
                }
            }
        }
        return null;
    }

    @Override
    public boolean continuePressed() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (this.mOneSourceList.isEnabled()) {
            dialogDataModel.putInteger("ONE_SOURCE_LIST_INDEX", this.mOneSourceList.getSelectedIndex());
            dialogDataModel.putInteger("MULTIPLE_SOURCE_LIST_INDEX", this.mMultipleMatricesSelectedIndex);
        } else if (this.mMultipleSourcesList.isEnabled()) {
            dialogDataModel.putInteger("ONE_SOURCE_LIST_INDEX", this.mOneMatrixSelectedIndex);
            dialogDataModel.putInteger("MULTIPLE_SOURCE_LIST_INDEX", this.mMultipleSourcesList.getSelectedIndex());
        }
        if (!this.mOneSourceList.isEnabled() && !this.mMultipleSourcesList.isEnabled()) {
            dialogDataModel.putInteger("ONE_SOURCE_LIST_INDEX", this.mOneMatrixSelectedIndex);
            dialogDataModel.putInteger("MULTIPLE_SOURCE_LIST_INDEX", this.mMultipleMatricesSelectedIndex);
        }
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prxs";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mDataAreProximitiesRadioButton.isSelected() && this.mOneMatrixRadioButton.isSelected()) {
            this.mMultipleMatricesSelectedIndex = this.mMultipleSourcesList.getSelectedIndex() == -1 ? this.mMultipleMatricesSelectedIndex : this.mMultipleSourcesList.getSelectedIndex();
            ((DefaultListModel)this.mMultipleSourcesList.getModel()).clear();
            ((DefaultListModel)this.mMultipleSourcesList.getModel()).setSize(3);
            this.mMultipleSourcesList.setEnabled(false);
            this.mOneSourceList.setEnabled(true);
            ((DefaultListModel)this.mOneSourceList.getModel()).clear();
            ((DefaultListModel)this.mOneSourceList.getModel()).setSize(2);
            this.mOneSourceList.setSelectedIndex(this.mOneMatrixSelectedIndex);
        } else if (this.mDataAreProximitiesRadioButton.isSelected() && this.mMultipleMatrixRadioButton.isSelected()) {
            this.mOneMatrixSelectedIndex = this.mOneSourceList.getSelectedIndex() == -1 ? this.mOneMatrixSelectedIndex : this.mOneSourceList.getSelectedIndex();
            ((DefaultListModel)this.mOneSourceList.getModel()).clear();
            ((DefaultListModel)this.mOneSourceList.getModel()).setSize(2);
            this.mMultipleSourcesList.setEnabled(true);
            this.mOneSourceList.setEnabled(false);
            ((DefaultListModel)this.mMultipleSourcesList.getModel()).clear();
            ((DefaultListModel)this.mMultipleSourcesList.getModel()).setSize(3);
            this.mMultipleSourcesList.setSelectedIndex(this.mMultipleMatricesSelectedIndex);
        } else {
            if (this.mOneSourceList.isEnabled()) {
                this.mOneMatrixSelectedIndex = this.mOneSourceList.getSelectedIndex();
            } else if (this.mMultipleSourcesList.isEnabled()) {
                this.mMultipleMatricesSelectedIndex = this.mMultipleSourcesList.getSelectedIndex();
            }
            ((DefaultListModel)this.mOneSourceList.getModel()).clear();
            ((DefaultListModel)this.mOneSourceList.getModel()).setSize(2);
            this.mOneSourceList.setEnabled(false);
            ((DefaultListModel)this.mMultipleSourcesList.getModel()).clear();
            ((DefaultListModel)this.mMultipleSourcesList.getModel()).setSize(3);
            this.mMultipleSourcesList.setEnabled(false);
        }
        this.mMatrixAcrossColumns.setEnabled(this.mDataAreProximitiesRadioButton.isSelected() && this.mOneMatrixRadioButton.isSelected());
        this.mSingleColumn.setEnabled(this.mDataAreProximitiesRadioButton.isSelected() && this.mOneMatrixRadioButton.isSelected());
        this.mStackedMatricesAcrossColumns.setEnabled(this.mDataAreProximitiesRadioButton.isSelected() && this.mMultipleMatrixRadioButton.isSelected());
        this.mOneSourcePerColumn.setEnabled(this.mDataAreProximitiesRadioButton.isSelected() && this.mMultipleMatrixRadioButton.isSelected());
        this.mStackedSingleColumn.setEnabled(this.mDataAreProximitiesRadioButton.isSelected() && this.mMultipleMatrixRadioButton.isSelected());
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (dialogDataModel.getInteger("ONE_SOURCE_LIST_INDEX") != null) {
            this.mOneSourceList.clearSelection();
            this.mOneMatrixSelectedIndex = dialogDataModel.getInteger("ONE_SOURCE_LIST_INDEX");
            this.mMultipleMatricesSelectedIndex = dialogDataModel.getInteger("MULTIPLE_SOURCE_LIST_INDEX");
            if (dialogDataModel.getBoolean("IDS_PROXSCAL_DATA_ARE_PROXIMITIES").booleanValue()) {
                if (dialogDataModel.getBoolean("IDS_PROXSCAL_ONE_MATRIX_SOURCE").booleanValue()) {
                    this.mMultipleSourcesList.setEnabled(false);
                    this.mOneSourceList.setEnabled(true);
                    this.mOneSourceList.setSelectedIndex(this.mOneMatrixSelectedIndex);
                } else if (dialogDataModel.getBoolean("IDS_PROXSCAL_MULTIPLE_MATRIX_SOURCES").booleanValue()) {
                    this.mOneSourceList.setEnabled(false);
                    this.mMultipleSourcesList.setEnabled(true);
                    this.mMultipleSourcesList.setSelectedIndex(this.mMultipleMatricesSelectedIndex);
                }
            } else {
                this.mOneSourceList.setEnabled(false);
                this.mMultipleSourcesList.setEnabled(false);
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        this.renameContinueAction("IDS_DEFINE");
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setUpUI(jPanel);
        this.setDefaults();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            this.mFocus.add(this.mHelpButton);
            this.mFocus.add(this.mCancelButton);
            this.mFocus.add(this.mDefineButton);
        } else {
            this.mFocus.add(this.mDefineButton);
            this.mFocus.add(this.mCancelButton);
            this.mFocus.add(this.mHelpButton);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mFocus, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void initVars() {
        this.mFocus = new Vector();
        this.mConstaints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
        this.mDataAreProximitiesRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_PROXSCAL_DATA_ARE_PROXIMITIES"));
        this.mCreateProximitiesFromDataRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_PROXSCAL_CREATE_PROXIMITIES_FROM_DATA"));
        this.mOneMatrixRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_PROXSCAL_ONE_MATRIX_SOURCE"));
        this.mMultipleMatrixRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_PROXSCAL_MULTIPLE_MATRIX_SOURCES"));
        this.mDataAreProximitiesRadioButton.addItemListener(this);
        this.mCreateProximitiesFromDataRadioButton.addItemListener(this);
        this.mOneMatrixRadioButton.addItemListener(this);
        this.mMultipleMatrixRadioButton.addItemListener(this);
        this.mOneSourceList = new JList();
        this.mOneSourceList.setSelectionMode(0);
        JListCellRenderer jListCellRenderer = new JListCellRenderer();
        DefaultListModel defaultListModel = new DefaultListModel();
        this.mOneSourceList.setCellRenderer(jListCellRenderer);
        defaultListModel.setSize(2);
        this.mOneSourceList.setModel(defaultListModel);
        this.mOneSourceList.addKeyListener(new BarKeyListener());
        this.mMultipleSourcesList = new JList();
        this.mMultipleSourcesList.setSelectionMode(0);
        jListCellRenderer = new JListCellRenderer();
        DefaultListModel defaultListModel2 = new DefaultListModel();
        this.mMultipleSourcesList.setCellRenderer(jListCellRenderer);
        defaultListModel2.setSize(3);
        this.mMultipleSourcesList.setModel(defaultListModel2);
        this.mMultipleSourcesList.addKeyListener(new BarKeyListener());
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mDataAreProximitiesRadioButton);
        spssButtonGroup.add(this.mCreateProximitiesFromDataRadioButton);
        this.mFocus.add(spssButtonGroup);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mOneMatrixRadioButton);
        spssButtonGroup2.add(this.mMultipleMatrixRadioButton);
        this.mFocus.add(spssButtonGroup2);
        this.mFocus.add(this.mOneSourceList);
        this.mFocus.add(this.mMultipleSourcesList);
        URL uRL = this.getResImageURL("IDS_PROXSCAL_PROXIMITIES_MATRIX_ACROSS_COLUMN_IMAGE");
        this.mPMatrixAcrossColumnImage = new ImageIcon(uRL);
        uRL = this.getResImageURL("IDS_PROXSCAL_PROXIMITIES_SINGLE_COLUMN_IMAGE");
        this.mPSingleColumnImage = new ImageIcon(uRL);
        uRL = this.getResImageURL("IDS_PROXSCAL_BLANK_IMAGE");
        this.mBlankImage = new ImageIcon(uRL);
        uRL = this.getResImageURL("IDS_PROXSCAL_PROXIMITIES_STACKED_MATRICES_ACROSS_COLUMNS_IMAGE");
        this.mPStackedMatricesAcrossColumnImage = new ImageIcon(uRL);
        uRL = this.getResImageURL("IDS_PROXSCAL_PROXIMITIES_ONE_SOURCE_PER_COLUMN_IMAGE");
        this.mPOneSourcePerColumnImage = new ImageIcon(uRL);
        uRL = this.getResImageURL("IDS_PROXSCAL_PROXIMITIES_STACKED_IN_SINGLE_COLUMN_IMAGE");
        this.mPStackedInSingleColumnImage = new ImageIcon(uRL);
    }

    private void setDefaults() {
        this.mOneSourceList.setSelectedIndex(0);
        this.mDataAreProximitiesRadioButton.setSelected(true);
        this.mOneMatrixRadioButton.setSelected(true);
        this.mMultipleSourcesList.setEnabled(false);
    }

    private void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = this.setupDataFormatPanel();
        JPanel jPanel3 = this.setupNumberOfSourcesPanel();
        JPanel jPanel4 = this.setupOneSourcePanel();
        JPanel jPanel5 = this.setupMultipleSourcesPanel();
        this.mConstaints.fill = 1;
        this.mConstaints.weightx = 1.0;
        this.mConstaints.weighty = 1.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstaints, 0, 0, 1, 1, n, null);
        this.mInsets.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mConstaints, 1, 0, 1, 1, n, this.mInsets);
        this.mInsets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel4, this.mConstaints, 0, 1, 2, 1, n, null);
        this.mInsets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel5, this.mConstaints, 0, 2, 2, 1, n, null);
    }

    private JPanel setupDataFormatPanel() {
        this.mConstaints.fill = 0;
        this.mConstaints.weightx = 0.0;
        this.mConstaints.weighty = 0.0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PROXSCAL_DATAFORMAT_TITLE")));
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        this.mConstaints.weightx = 1.0;
        this.mInsets.set(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mDataAreProximitiesRadioButton, this.mConstaints, 0, 0, 1, 1, n2, this.mInsets);
        this.mConstaints.weighty = 1.0;
        this.mInsets.set(insets.top, n, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mCreateProximitiesFromDataRadioButton, this.mConstaints, 0, 1, 1, 1, n2, this.mInsets);
        return jPanel;
    }

    private JPanel setupNumberOfSourcesPanel() {
        this.mConstaints.fill = 0;
        this.mConstaints.weightx = 0.0;
        this.mConstaints.weighty = 0.0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PROXSCAL_NUMBER_OF_SOURCES_TITLE")));
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        this.mConstaints.weightx = 1.0;
        this.mInsets.set(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mOneMatrixRadioButton, this.mConstaints, 0, 0, 1, 1, n2, this.mInsets);
        this.mConstaints.weighty = 1.0;
        this.mInsets.set(insets.top, n, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mMultipleMatrixRadioButton, this.mConstaints, 0, 1, 1, 1, n2, this.mInsets);
        return jPanel;
    }

    private JPanel setupOneSourcePanel() {
        this.mConstaints.fill = 0;
        this.mConstaints.weightx = 0.0;
        this.mConstaints.weighty = 0.0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PROXSCAL_ONE_SOURCE_TITLE")));
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        this.mInsets.set(n, n, n, 0);
        DialogUtil.addUsingGBL(jPanel, this.mOneSourceList, this.mConstaints, 0, 0, 1, 1, n2, this.mInsets);
        this.mConstaints.weightx = 1.0;
        this.mInsets.set(n, 0, n, n);
        JPanel jPanel2 = this.setupLabelPanelForOneMatrix();
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstaints, 1, 0, 1, 1, n2, this.mInsets);
        return jPanel;
    }

    private JPanel setupMultipleSourcesPanel() {
        this.mConstaints.fill = 0;
        this.mConstaints.weightx = 0.0;
        this.mConstaints.weighty = 0.0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PROXSCAL_MULTIPLE_SOURCES_TITLE")));
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        this.mInsets.set(n, n, n, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMultipleSourcesList, this.mConstaints, 0, 0, 1, 1, n2, this.mInsets);
        this.mConstaints.weightx = 1.0;
        this.mInsets.set(n, 0, n, n);
        JPanel jPanel2 = this.setupLabelPanelForMultipleMatrix();
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstaints, 1, 0, 1, 1, n2, this.mInsets);
        return jPanel;
    }

    private JPanel setupLabelPanelForOneMatrix() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mConstaints.weightx = 1.0;
        this.mConstaints.weighty = 1.0;
        this.mConstaints.fill = 2;
        int n = DialogUtil.getGroupBoxInnerMargin();
        this.mMatrixAcrossColumns = DialogUtil.createLabel(this, "IDS_PROXSCAL_PROXIMITIES_IN_MATRIX_ACROSS_COLUMNS");
        this.mSingleColumn = DialogUtil.createLabel(this, "IDS_PROXSCAL_PROXIMITIES_IN_SINGLE_COLUMN");
        this.mInsets.set(8, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mMatrixAcrossColumns, this.mConstaints, 0, 0, 1, 1, 23, this.mInsets);
        DialogUtil.addUsingGBL(jPanel, this.mSingleColumn, this.mConstaints, 0, 1, 1, 1, 23, new Insets(21, n, n, n));
        return jPanel;
    }

    private JPanel setupLabelPanelForMultipleMatrix() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mConstaints.weightx = 1.0;
        this.mConstaints.weighty = 1.0;
        this.mConstaints.fill = 2;
        int n = DialogUtil.getGroupBoxInnerMargin();
        this.mStackedMatricesAcrossColumns = DialogUtil.createLabel(this, "IDS_PROXSCAL_PROXIMITIES_IN_STACKED_MATRICES_ACROSS_COLUMNS");
        this.mOneSourcePerColumn = DialogUtil.createLabel(this, "IDS_PROXSCAL_PROXIMITIES_ONE_SOURCE_PER_COLUMN");
        this.mStackedSingleColumn = DialogUtil.createLabel(this, "IDS_PROXSCAL_PROXIMITIES_STACKED_IN_SINGLE_COLUMN");
        this.mInsets.set(8, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mStackedMatricesAcrossColumns, this.mConstaints, 0, 0, 1, 1, 23, this.mInsets);
        DialogUtil.addUsingGBL(jPanel, this.mOneSourcePerColumn, this.mConstaints, 0, 1, 1, 1, 23, new Insets(21, n, 0, n));
        DialogUtil.addUsingGBL(jPanel, this.mStackedSingleColumn, this.mConstaints, 0, 2, 1, 1, 23, new Insets(21, n, n, n));
        return jPanel;
    }

    private class ProxscalDlgKeyListener
    implements IDlgKeyPressListener {
        private ProxscalDlgKeyListener() {
        }

        public void dialogKeyEvent(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (keyEvent.isAltDown()) {
                if (ProxscalDlg.this.mOneMatrixRadioButton.isSelected()) {
                    if (n == 65) {
                        ProxscalDlg.this.mOneSourceList.setSelectedIndex(0);
                    } else if (n == 83) {
                        ProxscalDlg.this.mOneSourceList.setSelectedIndex(1);
                    }
                } else if (ProxscalDlg.this.mMultipleMatrixRadioButton.isSelected()) {
                    if (n == 84) {
                        ProxscalDlg.this.mMultipleSourcesList.setSelectedIndex(0);
                    } else if (n == 78) {
                        ProxscalDlg.this.mMultipleSourcesList.setSelectedIndex(1);
                    } else if (n == 75) {
                        ProxscalDlg.this.mMultipleSourcesList.setSelectedIndex(2);
                    }
                }
            }
        }
    }

    private class BarKeyListener
    extends KeyAdapter {
        private BarKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Component component = ProxscalDlg.this.getFocusOwner();
            if (component instanceof JList) {
                JList jList = (JList)component;
                if (keyEvent.getKeyCode() == 40 && jList.getSelectedIndex() == jList.getModel().getSize() - 1) {
                    keyEvent.consume();
                    jList.setSelectedIndex(0);
                }
                if (keyEvent.getKeyCode() == 38 && jList.getSelectedIndex() == 0) {
                    keyEvent.consume();
                    jList.setSelectedIndex(jList.getModel().getSize() - 1);
                }
            }
        }
    }

    private class JListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private LineBorder mBlackBorderWithoutFocus;
        private LineBorder mBlackBorderWithFocus;
        private LineBorder mWhiteBorder;

        public JListCellRenderer() {
            this.setOpaque(true);
            this.mWhiteBorder = new LineBorder(Color.WHITE, 3);
            this.mBlackBorderWithoutFocus = new LineBorder(Color.BLACK, 2);
            this.mBlackBorderWithFocus = new LineBorder(Color.BLACK, 3);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (jList == ProxscalDlg.this.mOneSourceList) {
                boolean bl3 = ProxscalDlg.this.mOneMatrixRadioButton.isSelected();
                if (bl3 && ProxscalDlg.this.mDataAreProximitiesRadioButton.isSelected()) {
                    switch (n) {
                        case 0: {
                            this.setIcon(ProxscalDlg.this.mPMatrixAcrossColumnImage);
                            break;
                        }
                        case 1: {
                            this.setIcon(ProxscalDlg.this.mPSingleColumnImage);
                        }
                    }
                } else {
                    switch (n) {
                        case 0: {
                            this.setIcon(ProxscalDlg.this.mBlankImage);
                            break;
                        }
                        case 1: {
                            this.setIcon(ProxscalDlg.this.mBlankImage);
                        }
                    }
                }
            } else if (jList == ProxscalDlg.this.mMultipleSourcesList) {
                boolean bl4 = ProxscalDlg.this.mMultipleMatrixRadioButton.isSelected();
                if (bl4 && ProxscalDlg.this.mDataAreProximitiesRadioButton.isSelected()) {
                    switch (n) {
                        case 0: {
                            this.setIcon(ProxscalDlg.this.mPStackedMatricesAcrossColumnImage);
                            break;
                        }
                        case 1: {
                            this.setIcon(ProxscalDlg.this.mPOneSourcePerColumnImage);
                            break;
                        }
                        case 2: {
                            this.setIcon(ProxscalDlg.this.mPStackedInSingleColumnImage);
                        }
                    }
                } else {
                    switch (n) {
                        case 0: {
                            this.setIcon(ProxscalDlg.this.mBlankImage);
                            break;
                        }
                        case 1: {
                            this.setIcon(ProxscalDlg.this.mBlankImage);
                            break;
                        }
                        case 2: {
                            this.setIcon(ProxscalDlg.this.mBlankImage);
                        }
                    }
                }
            }
            this.setOpaque(true);
            if (bl) {
                this.setBorder(this.mBlackBorderWithoutFocus);
            } else {
                this.setBorder(this.mWhiteBorder);
            }
            if (bl2) {
                this.setBorder(this.mBlackBorderWithFocus);
            }
            return this;
        }
    }
}

