/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.proxscal;

import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.comp_util.RemoteFileStatus;
import com.spss.java_client.core.comp_util.RemoteFileSysUtil;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesOptions;
import com.spss.uitools.util.CharacterUtil;
import java.util.ArrayList;
import java.util.Vector;

public class ProximitiesUtils {
    private static String mCommonOutFile = null;
    private static String mWeightsOutFile = null;
    private static String mDistancesOutFile = null;
    private static String mTransformsOutFile = null;
    private static String mVariablesOutFile = null;

    public static StringBuffer generateModelSyntax(DialogDataModel dialogDataModel) {
        DialogDataModel dialogDataModel2 = new DialogDataModel();
        ProcedureDlgMgr.getMgr().loadPersistentState("analyze_scale_mult_proxscal", dialogDataModel2);
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = dialogDataModel.getBoolean("IDS_PROXSCAL_IDENTITY");
        Boolean bl2 = dialogDataModel2.getBoolean("IDS_PROXSCAL_ONE_MATRIX_SOURCE");
        if (bl == null && bl2 != null && !bl2.booleanValue()) {
            return SyntaxUtil.getSingleValueSubCommand("MODEL", "IDENTITY");
        }
        if (bl != null && bl.booleanValue() && bl2 != null && !bl2.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("MODEL", "IDENTITY"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_PROXSCAL_WEIGHTED_EUCL")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("MODEL", "WEIGHTED"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_PROXSCAL_GEN_EUCL")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("MODEL", "GENERALIZED"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_PROXSCAL_RED_RANK")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getBracedSingleValueSubCommand("MODEL", "REDUCED", dialogDataModel.getString("IDS_RANK_EDIT")));
        }
        return stringBuffer;
    }

    public static StringBuffer generateInitialSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = dialogDataModel.getBoolean("IDS_PROXSCAL_SIMPLEX");
        if (bl == null) {
            return SyntaxUtil.getSingleValueSubCommand("INITIAL", "SIMPLEX");
        }
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("INITIAL", "SIMPLEX"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_PROXSCAL_TORGERSON")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("INITIAL", "TORGERSON"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_PROXSCAL_SINGLE_RAND_START")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getBracedSingleValueSubCommand("INITIAL", "RANDOM", "1"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_PROXSCAL_MULT_RAND_START")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getBracedSingleValueSubCommand("INITIAL", "RANDOM", dialogDataModel.getString("IDS_NO_OF_STARTS_EDIT")));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_PROXSCAL_CUSTOM")) != null && bl.booleanValue()) {
            Object[] objectArray;
            stringBuffer.append(SyntaxUtil.getSubCommand("/INITIAL=("));
            stringBuffer.append(CharacterUtil.smartQuote((String)dialogDataModel.getString("IDS_FILE_TEXT")) + ") ");
            for (Object object : objectArray = dialogDataModel.getArray("SELECTED_FILE")) {
                stringBuffer.append(object.toString() + " ");
            }
            stringBuffer = new StringBuffer(stringBuffer.toString().trim());
            stringBuffer.insert(0, "  ");
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer generateTransformationSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = dialogDataModel.getBoolean("IDS_PROXSCAL_RATIO");
        if (bl == null) {
            return SyntaxUtil.getSingleValueSubCommand("TRANSFORMATION", "RATIO");
        }
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("TRANSFORMATION", "RATIO"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_PROXSCAL_INTERVAL")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("TRANSFORMATION", "INTERVAL"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_PROXSCAL_ORDINAL")) != null && bl.booleanValue()) {
            bl = dialogDataModel.getBoolean("IDS_PROXSCAL_UNTIE");
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append(SyntaxUtil.getBracedSingleValueSubCommand("TRANSFORMATION", "ORDINAL", "UNTIE"));
            } else {
                stringBuffer.append(SyntaxUtil.getBracedSingleValueSubCommand("TRANSFORMATION", "ORDINAL", "KEEPTIES"));
            }
        }
        if ((bl = dialogDataModel.getBoolean("IDS_PROXSCAL_SPLINE")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/TRANSFORMATION="));
            stringBuffer.append("SPLINE DEGREE=");
            stringBuffer.append(dialogDataModel.getString("IDS_DEGREE_EDIT"));
            stringBuffer.append(" INKNOT=");
            stringBuffer.append(dialogDataModel.getString("IDS_INT_KNOTS_EDIT"));
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer generateCriteriaSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA=DIMENSIONS"));
        String string = dialogDataModel.getString("MIN_TEXT");
        if (string == null) {
            stringBuffer.append("(2,2) ");
        } else {
            stringBuffer.append("(" + string + "," + dialogDataModel.getString("MAX_TEXT") + ") ");
        }
        string = dialogDataModel.getString("IDS_MAX_ITER_EDIT");
        if (string == null) {
            stringBuffer.append("MAXITER(100) DIFFSTRESS(.0001) MINSTRESS(.0001)");
        } else {
            stringBuffer.append("MAXITER(" + string + ") ");
            string = dialogDataModel.getString("IDS_STRESS_CONV_EDIT");
            stringBuffer.append("DIFFSTRESS(" + string + ") ");
            string = dialogDataModel.getString("IDS_MIN_STRESS_EDIT");
            stringBuffer.append("MINSTRESS(" + string + ")");
        }
        stringBuffer.append("\n");
        return stringBuffer;
    }

    public static StringBuffer generateRestrictionSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = dialogDataModel.getBoolean("IDS_PROXSCAL_RESTRICTION_NO_RESTRICTION_RADIOBUTTON");
        if (bl != null) {
            Object[] objectArray;
            if (bl.booleanValue()) {
                return stringBuffer;
            }
            stringBuffer.append(SyntaxUtil.getSubCommand("/RESTRICTIONS="));
            bl = dialogDataModel.getBoolean("IDS_PROXSCAL_RESTRICTION_LINEAR_COMBINATION_RADIOBUTTON");
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append("VARIABLES ");
                stringBuffer.append("(" + CharacterUtil.smartQuote((String)dialogDataModel.getString("fileIdentifier")) + ") ");
                objectArray = dialogDataModel.getArray("targetIdentifier");
                ArrayList<String> arrayList = new ArrayList<String>();
                Vector vector = (Vector)dialogDataModel.getObject("FormatVector");
                for (String string : vector) {
                    arrayList.add(string);
                }
                Object[] objectArray2 = arrayList.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray2[i].equals(dialogDataModel.getString("IDS_PROXIMITIES_RESTRICTION_ORDINAL"))) {
                        stringBuffer.append(objectArray[i] + "(" + dialogDataModel.getString("IDS_PROXIMITIES_RESTRICTION_ORDINAL_KEEP_TIES_DISPLAY_SYNTAX") + ")" + " ");
                        continue;
                    }
                    if (objectArray2[i].equals(dialogDataModel.getString("IDS_PROXIMITIES_RESTRICTION_NOMINAL"))) {
                        stringBuffer.append(objectArray[i] + "(" + dialogDataModel.getString("IDS_PROXIMITIES_RESTRICTION_NOMINAL_DISPLAY_SYNTAX") + ")" + " ");
                        continue;
                    }
                    if (((String)objectArray2[i]).startsWith(dialogDataModel.getString("IDS_PROXIMITIES_RESTRICTION_SPLINE"))) {
                        String[] stringArray = ((String)objectArray2[i]).split(" ");
                        stringBuffer.append(objectArray[i] + "(" + dialogDataModel.getString("IDS_PROXIMITIES_RESTRICTION_SPLINE_DISPLAY_SYNTAX") + stringArray[1] + " " + dialogDataModel.getString("IDS_PROXIMITIES_RESTRICTION_SPLINE_DISPLAY_INKNOT_SYNTAX") + stringArray[2] + ")" + " ");
                        continue;
                    }
                    if (objectArray2[i].equals(dialogDataModel.getString("IDS_PROXIMITIES_RESTRICTION_INVERVAL"))) {
                        stringBuffer.append(objectArray[i] + "(" + dialogDataModel.getString("IDS_PROXIMITIES_RESTRICTION_INTERVAL_DISPLAY_SYNTAX") + ")" + " ");
                        continue;
                    }
                    if (!objectArray2[i].equals(dialogDataModel.getString("IDS_PROXIMITIES_RESTRICTION_ORDINAL_UNITE"))) continue;
                    stringBuffer.append(objectArray[i] + "(" + dialogDataModel.getString("IDS_PROXIMITIES_RESTRICTION_ORDINAL_BREAK_TIES_DISPLAY_SYNTAX") + ")" + " ");
                }
            }
            if ((bl = dialogDataModel.getBoolean("IDS_PROXSCAL_RESTRICTION_SOME_COORDINATES_RADIOBUTTON")) != null && bl.booleanValue()) {
                stringBuffer.append("COORDINATES ");
                stringBuffer.append("(" + CharacterUtil.smartQuote((String)dialogDataModel.getString("fileIdentifier")) + ") ");
                objectArray = dialogDataModel.getArray("targetIdentifier");
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append(objectArray[i] + " ");
                }
            }
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer generatePrintSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = dialogDataModel.getBoolean("IDS_PROXSCAL_IDENTITY");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_PROXSCAL_RESTRICTION_LINEAR_COMBINATION_RADIOBUTTON");
        Boolean bl3 = dialogDataModel.getBoolean("IDS_PROXSCAL_MULT_RAND_START");
        Boolean bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_COMMON_COORDI");
        if (bl == null && bl2 == null && bl3 == null && bl4 == null) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT=COMMON STRESS") + "\n");
            return stringBuffer;
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT="));
        if (bl4 == null || bl4 != null && bl4.booleanValue()) {
            stringBuffer.append("COMMON ");
        }
        if (bl != null && !bl.booleanValue()) {
            bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_INDV_COORDI");
            if (bl4 != null && bl4.booleanValue()) {
                stringBuffer.append("INDIVIDUAL ");
            }
            if ((bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_INDV_WGTS")) == null || bl4 != null && bl4.booleanValue()) {
                stringBuffer.append("WEIGHTS ");
            }
        }
        if ((bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_DISTANCES")) != null && bl4.booleanValue()) {
            stringBuffer.append("DISTANCES ");
        }
        if ((bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_TRANS_PROX")) != null && bl4.booleanValue()) {
            stringBuffer.append("TRANSFORMATIONS ");
        }
        if ((bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_INPUT_DATA")) != null && bl4.booleanValue()) {
            stringBuffer.append("INPUT ");
        }
        if (bl3 != null && bl3.booleanValue() && (bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_STRESS_FOR_RAND")) != null && bl4.booleanValue()) {
            stringBuffer.append("RANDOM ");
        }
        if ((bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_ITER_HISTORY")) != null && bl4.booleanValue()) {
            stringBuffer.append("HISTORY ");
        }
        if ((bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_MULT_STRESS")) == null || bl4 != null && bl4.booleanValue()) {
            stringBuffer.append("STRESS ");
        }
        if ((bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_STRESS_DECOMP")) != null && bl4.booleanValue()) {
            stringBuffer.append("DECOMPOSITION ");
        }
        if (bl2 != null && bl2.booleanValue()) {
            bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_TRANS_IND_VARS");
            if (bl4 == null || bl4 != null && bl4.booleanValue()) {
                stringBuffer.append("VARIABLES ");
            }
            if ((bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_VAR_AND_COR")) != null && bl4.booleanValue()) {
                stringBuffer.append("CORRELATIONS");
            }
        }
        if (stringBuffer.toString().equals("  /PRINT=")) {
            stringBuffer.append("NONE");
        }
        stringBuffer.append("\n");
        return stringBuffer;
    }

    public static StringBuffer generateOutfileSyntax(DialogDataModel dialogDataModel) {
        mCommonOutFile = null;
        mWeightsOutFile = null;
        mDistancesOutFile = null;
        mTransformsOutFile = null;
        mVariablesOutFile = null;
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = dialogDataModel.getBoolean("IDS_PROXSCAL_IDENTITY");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_PROXSCAL_RESTRICTION_LINEAR_COMBINATION_RADIOBUTTON");
        Boolean bl3 = dialogDataModel.getBoolean("IDS_PROXSCAL_SAVE_COMMON_COORDI");
        if (bl3 == null) {
            return stringBuffer;
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/OUTFILE="));
        if (bl3.booleanValue()) {
            bl3 = dialogDataModel.getBoolean("IDS_COMMON_DATASET_SELECTION_STATE");
            mCommonOutFile = bl3 != null && bl3 != false ? dialogDataModel.getString("IDS_DATASETNAME_COMMON_TEXT_FIELD") : dialogDataModel.getString("IDS_COMMON_TEXT_FIELD");
            stringBuffer.append("COMMON(" + CharacterUtil.smartQuote((String)mCommonOutFile) + ") ");
        }
        if (bl != null && !bl.booleanValue() && (bl3 = dialogDataModel.getBoolean("IDS_PROXSCAL_SAVE_INDV_WGTS")) != null && bl3.booleanValue()) {
            bl3 = dialogDataModel.getBoolean("IDS_SPACE_DATASET_SELECTION_STATE");
            mWeightsOutFile = bl3 != null && bl3 != false ? dialogDataModel.getString("IDS_DATASETNAME_SPACE_TEXT_FIELD") : dialogDataModel.getString("IDS_SPACE_TEXT_FIELD");
            stringBuffer.append("WEIGHTS(" + CharacterUtil.smartQuote((String)mWeightsOutFile) + ") ");
        }
        if ((bl3 = dialogDataModel.getBoolean("IDS_PROXSCAL_SAVE_DISTANCES")) != null && bl3.booleanValue()) {
            bl3 = dialogDataModel.getBoolean("IDS_DIST_DATASET_SELECTION_STATE");
            mDistancesOutFile = bl3 != null && bl3 != false ? dialogDataModel.getString("IDS_DATASETNAME_DIST_TEXT_FIELD") : dialogDataModel.getString("IDS_DIST_TEXT_FIELD");
            stringBuffer.append("DISTANCES(" + CharacterUtil.smartQuote((String)mDistancesOutFile) + ") ");
        }
        if ((bl3 = dialogDataModel.getBoolean("IDS_PROXSCAL_SAVE_TRANS_PROX")) != null && bl3.booleanValue()) {
            bl3 = dialogDataModel.getBoolean("IDS_TRANS_DATASET_SELECTION_STATE");
            mTransformsOutFile = bl3 != null && bl3 != false ? dialogDataModel.getString("IDS_DATASETNAME_TRANS_TEXT_FIELD") : dialogDataModel.getString("IDS_TRANS_TEXT_FIELD");
            stringBuffer.append("TRANSFORMATI(" + CharacterUtil.smartQuote((String)mTransformsOutFile) + ") ");
        }
        if (bl2 != null && bl2.booleanValue() && (bl3 = dialogDataModel.getBoolean("IDS_PROXSCAL_SAVE_TRANS_IND_VARS")) != null && bl3.booleanValue()) {
            bl3 = dialogDataModel.getBoolean("IDS_TRANSIND_DATASET_SELECTION_STATE");
            mVariablesOutFile = bl3 != null && bl3 != false ? dialogDataModel.getString("IDS_DATASETNAME_TRANS_TEXT_FIELD") : dialogDataModel.getString("IDS_TRANSIND_TEXT_FIELD");
            stringBuffer.append("VARIABLES(" + CharacterUtil.smartQuote((String)mVariablesOutFile) + ") ");
        }
        stringBuffer.append("\n");
        if (stringBuffer.toString().equals("  /OUTFILE=\n")) {
            stringBuffer.setLength(0);
        }
        return stringBuffer;
    }

    public static StringBuffer generatePerAttributesSyntax() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        PesFile pesFile = PES_Repository.getPesFile((String)mCommonOutFile);
        if (pesFile != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        if ((pesFile = PES_Repository.getPesFile((String)mWeightsOutFile)) != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        if ((pesFile = PES_Repository.getPesFile((String)mDistancesOutFile)) != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        if ((pesFile = PES_Repository.getPesFile((String)mTransformsOutFile)) != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        if ((pesFile = PES_Repository.getPesFile((String)mVariablesOutFile)) != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        return stringBuffer;
    }

    public static StringBuffer generatePlotsSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Boolean bl2 = dialogDataModel.getBoolean("IDS_PROXSCAL_IDENTITY");
        Boolean bl3 = dialogDataModel.getBoolean("IDS_PROXSCAL_RESTRICTION_LINEAR_COMBINATION_RADIOBUTTON");
        Boolean bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_PLOTS_STRESS_CHECKBOX");
        if (bl2 == null && bl3 == null && bl4 == null) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT=COMMON"));
            return stringBuffer;
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT="));
        if (bl4 != null && bl4.booleanValue()) {
            stringBuffer.append("STRESS ");
            bl = false;
        }
        if ((bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_PLOTS_COMMON_SPACE_CHECKBOX")) == null || bl4 != null && bl4.booleanValue()) {
            stringBuffer.append("COMMON ");
            bl = false;
        }
        Boolean bl5 = dialogDataModel.getBoolean("IDS_PROXSCAL_PLOTS_ALL_SOURCES_RADIOBUTTON");
        if (bl2 != null && !bl2.booleanValue()) {
            bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_PLOTS_INDIVIDUAL_SPACE_WEIGHTS_CHECKBOX");
            if (bl4 == null || bl4 != null && bl4.booleanValue()) {
                stringBuffer.append("WEIGHTS ");
                bl = false;
            }
            if ((bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_PLOTS_INDIVIDUAL_SPACES_CHECKBOX")) != null && bl4.booleanValue() && bl5 != null) {
                if (!bl5.booleanValue()) {
                    stringBuffer.append("INDIVIDUAL(" + ProximitiesUtils.generatePlots1Syntax(dialogDataModel).toString().trim() + ") ");
                    bl = false;
                } else {
                    stringBuffer.append("INDIVIDUAL(ALL) ");
                    bl = false;
                }
            }
        }
        if ((bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_PLOTS_ORIGINAL_CHECKBOX")) != null && bl4.booleanValue() && bl5 != null) {
            if (!bl5.booleanValue()) {
                stringBuffer.append("TRANSFORMATIONS(" + ProximitiesUtils.generatePlots1Syntax(dialogDataModel).toString().trim() + ") ");
                bl = false;
            } else if (bl5.booleanValue()) {
                stringBuffer.append("TRANSFORMATIONS(ALL) ");
                bl = false;
            }
        }
        if ((bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_PLOTS_TRANSFORMED_PROXIMITIES_CHECKBOX")) != null && bl4.booleanValue() && bl5 != null) {
            if (!bl5.booleanValue()) {
                stringBuffer.append("RESIDUALS(" + ProximitiesUtils.generatePlots1Syntax(dialogDataModel).toString().trim() + ") ");
                bl = false;
            } else if (bl5.booleanValue()) {
                stringBuffer.append("RESIDUALS(ALL) ");
                bl = false;
            }
        }
        if (bl3 != null && bl3.booleanValue()) {
            bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_PLOTS_TRANSFORMED_INDEPENDENT_CHECKBOX");
            if (bl4 != null && bl4.booleanValue()) {
                stringBuffer.append("VARIABLES(ALL) ");
                bl = false;
            }
            if ((bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_PLOTS1_VARIABLE_CHECKBOX")) == null || bl4 != null && bl4.booleanValue()) {
                stringBuffer.append("CORRELATIONS");
                bl = false;
            }
        }
        if (bl) {
            stringBuffer.append("NONE");
        }
        if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equals(" ")) {
            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        }
        return stringBuffer;
    }

    public static StringBuffer generatePlots1Syntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = dialogDataModel.getBoolean("IDS_PROXSCAL_PLOTS_TRANSFORMED_PROXIMITIES_CHECKBOX");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_PROXSCAL_PLOTS_ORIGINAL_CHECKBOX");
        Boolean bl3 = dialogDataModel.getBoolean("IDS_PROXSCAL_PLOTS_INDIVIDUAL_SPACES_CHECKBOX");
        if (bl != null && bl != false || bl2 != null && bl2 != false || bl3 != null && bl3.booleanValue()) {
            Boolean bl4 = dialogDataModel.getBoolean("IDS_PROXSCAL_PLOTS_ALL_SOURCES_RADIOBUTTON");
            if (bl4 != null && bl4.booleanValue()) {
                stringBuffer.append("ALL");
            } else {
                Object[] objectArray = dialogDataModel.getArray("LIST_ACTION");
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringBuffer.append("SRC_" + objectArray[i] + " ");
                    }
                } else {
                    objectArray = dialogDataModel.getArray("SelectedList");
                    if (objectArray != null) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            stringBuffer.append(objectArray[i] + " ");
                        }
                    }
                }
            }
        }
        if (stringBuffer.length() > 0 && stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equals(" ")) {
            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        }
        return stringBuffer;
    }

    public static boolean isServerFileExists(String string) {
        RemoteFileStatus remoteFileStatus = RemoteFileSysUtil.getRemoteFileSysUtil().validateFile(string);
        boolean bl = !remoteFileStatus.errorOccurred();
        boolean bl2 = false;
        if (bl) {
            bl2 = remoteFileStatus.getFileStatus() != RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST;
        }
        return bl2;
    }

    public static void validateRestrictionSubDialogModel(DialogDataModel dialogDataModel) {
        String string = dialogDataModel.getString("fileIdentifier");
        if (string != null) {
            boolean bl = ProximitiesUtils.isServerFileExists(string);
            if (!bl && DatasetNameValidator.hasDatasetName((String)string)) {
                bl = true;
            }
            if (!bl) {
                dialogDataModel.putBoolean("IDS_PROXSCAL_RESTRICTION_NO_RESTRICTION_RADIOBUTTON", true);
                dialogDataModel.putBoolean("IDS_PROXSCAL_RESTRICTION_SOME_COORDINATES_RADIOBUTTON", null);
                dialogDataModel.putBoolean("IDS_PROXSCAL_RESTRICTION_LINEAR_COMBINATION_RADIOBUTTON", null);
                dialogDataModel.putString("fileIdentifier", null);
                dialogDataModel.putArray("srcIdentifier", null);
                dialogDataModel.putArray("targetIdentifier", null);
                dialogDataModel.putString("IDS_PROXIMITIES_RESTRICTION_DEGREE_TXT", "2");
                dialogDataModel.putString("IDS_PROXIMITIES_RESTRICTION_KNOTS_TXT", "1");
                dialogDataModel.putInteger("IDS_PROXIMITIES_RESTRICTION_INDEPENDENT_VAR_TRANSFORM_COMBO", 0);
                dialogDataModel.putMap("Hashmap", null);
            }
        }
    }

    public static void appendAccelerationSyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        Boolean bl;
        boolean bl2 = ProximitiesOptions.isUseUpdatesEnabled(dialogDataModel);
        if (bl2 && ((bl = dialogDataModel.getBoolean("IDS_PROXSCAL_USE_REL_UPD")) == null || !bl.booleanValue())) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("ACCELERATION", "NONE"));
        }
    }

    public static void validateOptionsSubDialogModel(DialogDataModel dialogDataModel) {
        String string = dialogDataModel.getString("IDS_FILE_TEXT");
        if (string != null && !string.equals("")) {
            boolean bl = ProximitiesUtils.isServerFileExists(string);
            if (!bl && DatasetNameValidator.hasDatasetName((String)string)) {
                bl = true;
            }
            if (!bl) {
                dialogDataModel.putBoolean("IDS_PROXSCAL_SIMPLEX", true);
                dialogDataModel.putBoolean("IDS_PROXSCAL_TORGERSON", null);
                dialogDataModel.putBoolean("IDS_PROXSCAL_SINGLE_RAND_START", null);
                dialogDataModel.putBoolean("IDS_PROXSCAL_MULT_RAND_START", null);
                dialogDataModel.putString("IDS_NO_OF_STARTS_EDIT", "2");
                dialogDataModel.putBoolean("IDS_PROXSCAL_CUSTOM", null);
                dialogDataModel.putString("IDS_FILE_TEXT", null);
                dialogDataModel.putArray("AVAILABLE_FILE", null);
                dialogDataModel.putArray("SELECTED_FILE", null);
                dialogDataModel.putString("IDS_STRESS_CONV_EDIT", ".0001");
                dialogDataModel.putString("IDS_MIN_STRESS_EDIT", ".0001");
                dialogDataModel.putString("IDS_MAX_ITER_EDIT", "100");
                dialogDataModel.putBoolean("IDS_PROXSCAL_USE_REL_UPD", null);
            }
        }
    }
}

