/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.proxscal;

import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.MultiDimensionalCommonPanel;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesListCellRenderer;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesUtils;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ProximitiesRestrictions
extends BaseSubDialog
implements ActionListener,
ListDataListener,
DocumentListener,
FocusListener,
ItemListener {
    public static final String FILEPATH = "fileIdentifier";
    public static final String SRC_IDENTIFIER = "srcIdentifier";
    public static final String TARGET_IDENTIFIER = "targetIdentifier";
    private JRadioButton mNoRestrictionsRadioButton;
    private JRadioButton mCoordinatesRadioButton;
    private JRadioButton mIndependentVariablesRadioButton;
    private SpssButtonGroup mRestrictionsButtonGrp;
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private JButton mChangeButton;
    private JLabel mIndependentVarTransform;
    private JLabel mDegree;
    private JLabel mKnots;
    private IntTextField mDegreeTextField;
    private IntTextField mKnotsTextField;
    private JComboBox mIndependentVarTransformCombobox;
    private MultiDimensionalCommonPanel mRestrictionVariablesPanel;
    private Vector<String> mFormatVector;
    private ProximitiesListCellRenderer mProximitiesRenderer;

    public ProximitiesRestrictions(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prxa_restrict";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mNoRestrictionsRadioButton) {
            this.mRestrictionVariablesPanel.enableComponents(false);
            this.enableAllComponents(false);
            this.mRestrictionVariablesPanel.makeLabelVisible(false);
            this.enableContinue(true);
        } else if (itemEvent.getSource() == this.mCoordinatesRadioButton) {
            this.mRestrictionVariablesPanel.enableComponents(true);
            this.enableAllComponents(false);
            this.mRestrictionVariablesPanel.makeLabelVisible(true);
            if (this.mRestrictionVariablesPanel.getTargetList().getModel().getSize() >= 1) {
                this.enableContinue(true);
            } else {
                this.enableContinue(false);
            }
        } else if (itemEvent.getSource() == this.mIndependentVariablesRadioButton) {
            this.mRestrictionVariablesPanel.enableComponents(true);
            this.enableAllComponents(true);
            this.mRestrictionVariablesPanel.makeLabelVisible(false);
            if (this.mIndependentVarTransformCombobox.getSelectedIndex() == 4) {
                this.mDegree.setEnabled(true);
                this.mDegreeTextField.setEnabled(true);
                this.mDegreeTextField.setOpaque(true);
                this.mKnots.setEnabled(true);
                this.mKnotsTextField.setEnabled(true);
                this.mKnotsTextField.setOpaque(true);
            } else {
                this.mDegree.setEnabled(false);
                this.mDegreeTextField.setEnabled(false);
                this.mDegreeTextField.setOpaque(false);
                this.mKnots.setEnabled(false);
                this.mKnotsTextField.setEnabled(false);
                this.mKnotsTextField.setOpaque(false);
            }
            if (this.mRestrictionVariablesPanel.getTargetList().getModel().getSize() >= 1) {
                this.enableContinue(true);
            } else {
                this.enableContinue(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mIndependentVarTransformCombobox) {
            int n = this.mIndependentVarTransformCombobox.getSelectedIndex();
            if (n == 4) {
                this.mDegree.setEnabled(true);
                this.mKnots.setEnabled(true);
                this.mDegreeTextField.setEnabled(true);
                this.mDegreeTextField.setOpaque(true);
                this.mKnotsTextField.setEnabled(true);
                this.mKnotsTextField.setOpaque(true);
            } else {
                this.mDegree.setEnabled(false);
                this.mKnots.setEnabled(false);
                this.mDegreeTextField.setEnabled(false);
                this.mDegreeTextField.setOpaque(false);
                this.mKnotsTextField.setEnabled(false);
                this.mKnotsTextField.setOpaque(false);
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mIndependentVarTransformCombobox.getSelectedIndex() == 4 && this.mDegreeTextField.getText().length() > 0 && this.mKnotsTextField.getText().length() > 0) {
            this.mChangeButton.setEnabled(true);
        } else if (this.mIndependentVarTransformCombobox.getSelectedIndex() == 4 && (this.mDegreeTextField.getText().length() == 0 || this.mKnotsTextField.getText().length() == 0)) {
            this.mChangeButton.setEnabled(false);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mIndependentVarTransformCombobox.getSelectedIndex() == 4 && this.mDegreeTextField.getText().length() > 0 && this.mKnotsTextField.getText().length() > 0) {
            this.mChangeButton.setEnabled(true);
        } else if (this.mIndependentVarTransformCombobox.getSelectedIndex() == 4 && (this.mDegreeTextField.getText().length() == 0 || this.mKnotsTextField.getText().length() == 0)) {
            this.mChangeButton.setEnabled(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (this.mRestrictionVariablesPanel.getTargetList().getModel().getSize() >= 1) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (this.mRestrictionVariablesPanel.getTargetList().getModel().getSize() >= 1) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mDegreeTextField)) {
            this.mDegreeTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mKnotsTextField)) {
            this.mKnotsTextField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean continuePressed() {
        this.mParentDlg.getDialogDataModel().putObject("FormatVector", this.mFormatVector);
        return true;
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters();
        }
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        ProximitiesUtils.validateRestrictionSubDialogModel(dialogDataModel);
        super.loadState(dialogDataModel);
        Vector vector = (Vector)dialogDataModel.getObject("FormatVector");
        if (vector != null) {
            this.mFormatVector = vector;
            this.mProximitiesRenderer.setFormatVector(vector);
            this.mRestrictionVariablesPanel.getTargetList().repaint();
        }
        if (this.mNoRestrictionsRadioButton.isSelected()) {
            this.mRestrictionVariablesPanel.enableComponents(false);
            this.enableAllComponents(false);
        } else if (this.mIndependentVariablesRadioButton.isSelected()) {
            this.mRestrictionVariablesPanel.enableComponents(true);
            this.enableAllComponents(true);
            this.mRestrictionVariablesPanel.makeLabelVisible(false);
            if (this.mIndependentVarTransformCombobox.getSelectedIndex() == 4) {
                this.mDegree.setEnabled(true);
                this.mDegreeTextField.setEnabled(true);
                this.mDegreeTextField.setOpaque(true);
                this.mKnots.setEnabled(true);
                this.mKnotsTextField.setEnabled(true);
                this.mKnotsTextField.setOpaque(true);
            } else {
                this.mDegree.setEnabled(false);
                this.mDegreeTextField.setEnabled(false);
                this.mDegreeTextField.setOpaque(false);
                this.mKnots.setEnabled(false);
                this.mKnotsTextField.setEnabled(false);
                this.mKnotsTextField.setOpaque(false);
            }
        } else if (this.mCoordinatesRadioButton.isSelected()) {
            this.mRestrictionVariablesPanel.enableComponents(true);
            this.enableAllComponents(false);
            this.mRestrictionVariablesPanel.makeLabelVisible(true);
        }
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        PlainList plainList = this.mRestrictionVariablesPanel.getSourceList();
        PlainList plainList2 = this.mRestrictionVariablesPanel.getTargetList();
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(plainList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(plainList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(plainList, this.mPlainListVarMoveHandler));
        plainListDragAdapter = new PlainListDragAdapter(plainList2, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(plainList2, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(plainList2, this.mPlainListVarMoveHandler));
    }

    private void initVars() {
        this.mNoRestrictionsRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_PROXSCAL_RESTRICTION_NO_RESTRICTION_RADIOBUTTON"));
        this.mNoRestrictionsRadioButton.addItemListener(this);
        this.mCoordinatesRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_PROXSCAL_RESTRICTION_SOME_COORDINATES_RADIOBUTTON"));
        this.mCoordinatesRadioButton.addItemListener(this);
        this.mIndependentVariablesRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_PROXSCAL_RESTRICTION_LINEAR_COMBINATION_RADIOBUTTON"));
        this.mIndependentVariablesRadioButton.addItemListener(this);
        this.mRestrictionsButtonGrp = new SpssButtonGroup();
        this.mRestrictionsButtonGrp.add(this.mNoRestrictionsRadioButton);
        this.mRestrictionsButtonGrp.add(this.mCoordinatesRadioButton);
        this.mRestrictionsButtonGrp.add(this.mIndependentVariablesRadioButton);
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
        this.mChangeButton = DialogUtil.createButton(this, "IDS_PROXIMITIES_RESTRICTION_CHANGE_BUTTON", new ActionClass());
        this.mChangeButton.addActionListener(this);
        this.mIndependentVarTransform = DialogUtil.createLabel(this.mParentDlg, "IDS_PROXIMITIES_RESTRICTION_INDEPENDENT_VAR_TRANSFORM_LABEL");
        String[] stringArray = new String[]{this.getResString("IDS_PROXIMITIES_RESTRICTION_INTERVAL"), this.getResString("IDS_PROXIMITIES_RESTRICTION_NOMINAL"), this.getResString("IDS_PROXIMITIES_RESTRICTION_ORDINAL_BREAK_TIES"), this.getResString("IDS_PROXIMITIES_RESTRICTION_ORDINAL_KEEP_TIES"), this.getResString("IDS_PROXIMITIES_RESTRICTION_SPLINE")};
        this.mIndependentVarTransformCombobox = new JComboBox<String>(stringArray);
        this.mIndependentVarTransform.setLabelFor(this.mIndependentVarTransformCombobox);
        ComboboxAction comboboxAction = new ComboboxAction(this.mParentDlg, "IDS_PROXIMITIES_RESTRICTION_INDEPENDENT_VAR_TRANSFORM_COMBO");
        this.mIndependentVarTransformCombobox.setAction(comboboxAction);
        this.mIndependentVarTransformCombobox.setFont(this.mIndependentVarTransform.getFont());
        this.mIndependentVarTransformCombobox.addActionListener(this);
        this.mIndependentVarTransformCombobox.setPreferredSize(new Dimension(170, 22));
        this.mDegreeTextField = new IntTextField(1, 3, true);
        this.mDegreeTextField.setColumns(4);
        this.mDegreeTextField.setText("2");
        this.mDegree = DialogUtil.createLabel(this, "IDS_PROXIMITIES_RESTRICTION_DEGREE_LABEL");
        this.mDegree.setLabelFor((Component)this.mDegreeTextField);
        TextFieldAction textFieldAction = new TextFieldAction(this, "IDS_PROXIMITIES_RESTRICTION_DEGREE_TXT");
        this.mDegreeTextField.setAction((Action)textFieldAction);
        this.mDegreeTextField.getDocument().addDocumentListener(this);
        this.mDegreeTextField.addFocusListener((FocusListener)this);
        this.mKnotsTextField = new IntTextField(0, 99999999);
        this.mKnotsTextField.setColumns(4);
        this.mKnotsTextField.setText("1");
        this.mKnots = DialogUtil.createLabel(this, "IDS_PROXIMITIES_RESTRICTION_KNOTS_LABEL");
        this.mKnots.setLabelFor((Component)this.mKnotsTextField);
        textFieldAction = new TextFieldAction(this, "IDS_PROXIMITIES_RESTRICTION_KNOTS_TXT");
        this.mKnotsTextField.setAction((Action)textFieldAction);
        this.mKnotsTextField.getDocument().addDocumentListener(this);
        this.mKnotsTextField.addFocusListener((FocusListener)this);
        this.mFormatVector = new Vector();
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        String string = dialogDataModel.getString("MAX_TEXT");
        if (string == null) {
            string = "2";
        }
        this.mRestrictionVariablesPanel = new MultiDimensionalCommonPanel(this, "", FILEPATH, SRC_IDENTIFIER, TARGET_IDENTIFIER, string, "", true);
        this.mRestrictionVariablesPanel.getTargetList().getModel().addListDataListener(this);
        this.mProximitiesRenderer = new ProximitiesListCellRenderer(this.mRestrictionVariablesPanel.getTargetList(), this.mFormatVector);
        this.mRestrictionVariablesPanel.getTargetList().getModel().addListDataListener(this.mProximitiesRenderer);
        this.mRestrictionVariablesPanel.getTargetList().setCellRenderer(this.mProximitiesRenderer);
        DialogDataModel dialogDataModel2 = this.mParentDlg.getDialogDataModel();
        dialogDataModel2.putString("IDS_PROXIMITIES_RESTRICTION_INTERVAL_DISPLAY_SYNTAX", "INTERVAL");
        dialogDataModel2.putString("IDS_PROXIMITIES_RESTRICTION_NOMINAL_DISPLAY_SYNTAX", "NOMINAL");
        dialogDataModel2.putString("IDS_PROXIMITIES_RESTRICTION_ORDINAL_BREAK_TIES_DISPLAY_SYNTAX", "ORDINAL(UNTIE)");
        dialogDataModel2.putString("IDS_PROXIMITIES_RESTRICTION_ORDINAL_KEEP_TIES_DISPLAY_SYNTAX", "ORDINAL(KEEPTIES)");
        dialogDataModel2.putString("IDS_PROXIMITIES_RESTRICTION_SPLINE_DISPLAY_SYNTAX", "SPLINE DEGREE=");
        dialogDataModel2.putString("IDS_PROXIMITIES_RESTRICTION_SPLINE_DISPLAY_INKNOT_SYNTAX", "INKNOT=");
        dialogDataModel2.putString("IDS_PROXIMITIES_RESTRICTION_INVERVAL", this.getResString("IDS_PROXIMITIES_RESTRICTION_INTERVAL_DISPLAY"));
        dialogDataModel2.putString("IDS_PROXIMITIES_RESTRICTION_NOMINAL", this.getResString("IDS_PROXIMITIES_RESTRICTION_NOMINAL_DISPLAY"));
        dialogDataModel2.putString("IDS_PROXIMITIES_RESTRICTION_ORDINAL_UNITE", this.getResString("IDS_PROXIMITIES_RESTRICTION_ORDINAL_BREAK_TIES_DISPLAY"));
        dialogDataModel2.putString("IDS_PROXIMITIES_RESTRICTION_ORDINAL", this.getResString("IDS_PROXIMITIES_RESTRICTION_ORDINAL_KEEP_TIES_DISPLAY"));
        dialogDataModel2.putString("IDS_PROXIMITIES_RESTRICTION_SPLINE", this.getResString("IDS_PROXIMITIES_RESTRICTION_SPLINE_DISPLAY"));
        this.mProximitiesRenderer.setIntervalText(this.getResString("IDS_PROXIMITIES_RESTRICTION_INTERVAL_DISPLAY"));
    }

    private void setDefaults() {
        this.mNoRestrictionsRadioButton.setSelected(true);
        this.mRestrictionVariablesPanel.enableComponents(false);
        this.enableAllComponents(false);
        this.mRestrictionVariablesPanel.makeLabelVisible(false);
    }

    private void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = this.setupRestrictionCommonSpace();
        JPanel jPanel3 = this.setupRestrictionVariables();
        int n = 23;
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mConstraints, 0, 1, 1, 1, n, null);
    }

    private JPanel setupRestrictionCommonSpace() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PROXSCAL_RESTRICTION_COMMONSPACE_PANEL")));
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mInsets.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mNoRestrictionsRadioButton, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        this.mInsets.set(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mCoordinatesRadioButton, this.mConstraints, 0, 1, 1, 1, n, this.mInsets);
        this.mConstraints.weighty = 1.0;
        this.mInsets.set(insets.top, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mIndependentVariablesRadioButton, this.mConstraints, 0, 2, 1, 1, n, this.mInsets);
        return jPanel;
    }

    private JPanel setupRestrictionVariables() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PROXSCAL_RESTRICTION_VARIABLES_PANEL")));
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mRestrictionVariablesPanel, this.mConstraints, 0, 0, 1, 1, 23, null);
        JPanel jPanel2 = this.setupTransformationPanel();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 1, 1, 1, 23, null);
        return jPanel;
    }

    private JPanel setupTransformationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = DialogUtil.getGroupBoxInnerMargin();
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        Insets insets = new Insets(n, n, 0, DialogUtil.getComponentGroupGap() * 3);
        DialogUtil.addUsingGBL(jPanel, this.mChangeButton, this.mConstraints, 2, 0, 2, 1, 24, insets);
        this.mConstraints.weightx = 1.0;
        insets.set(n, n * 3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mIndependentVarTransform, this.mConstraints, 0, 1, 1, 1, 24, insets);
        this.mConstraints.weightx = 0.0;
        insets.set(n, n * 3, 0, DialogUtil.getComponentGroupGap() * 3);
        DialogUtil.addUsingGBL(jPanel, this.mIndependentVarTransformCombobox, this.mConstraints, 1, 1, 3, 1, 24, insets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        insets.set(n, n, n, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDegree, this.mConstraints, 0, 2, 1, 1, 24, insets);
        this.mConstraints.weightx = 0.0;
        insets.set(n, n * 3, n, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDegreeTextField, this.mConstraints, 1, 2, 1, 1, 24, insets);
        DialogUtil.addUsingGBL(jPanel, this.mKnots, this.mConstraints, 2, 2, 1, 1, 24, insets);
        insets.set(n, n, n, DialogUtil.getComponentGroupGap() * 3);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mKnotsTextField, this.mConstraints, 3, 2, 1, 1, 24, insets);
        return jPanel;
    }

    private void enableAllComponents(boolean bl) {
        this.mChangeButton.setEnabled(bl);
        this.mIndependentVarTransform.setEnabled(bl);
        this.mIndependentVarTransformCombobox.setEnabled(bl);
        this.mDegree.setEnabled(bl);
        this.mDegreeTextField.setEnabled(bl);
        this.mDegreeTextField.setOpaque(bl);
        this.mKnots.setEnabled(bl);
        this.mKnotsTextField.setEnabled(bl);
        this.mKnotsTextField.setOpaque(bl);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRestrictionsButtonGrp);
        this.mRestrictionVariablesPanel.getElementsForFocusVector(vector);
        vector.add(this.mChangeButton);
        vector.add(this.mIndependentVarTransformCombobox);
        vector.add(this.mDegreeTextField);
        vector.add(this.mKnotsTextField);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private class ActionClass
    implements ActionListener {
        private ActionClass() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ProximitiesRestrictions.this.mRestrictionVariablesPanel.getTargetList().getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                if (ProximitiesRestrictions.this.mIndependentVarTransformCombobox.getSelectedIndex() == 2) {
                    ProximitiesRestrictions.this.mProximitiesRenderer.getFormatVector().remove(nArray[i]);
                    ProximitiesRestrictions.this.mProximitiesRenderer.getFormatVector().add(nArray[i], ProximitiesRestrictions.this.getResString("IDS_PROXIMITIES_RESTRICTION_ORDINAL_BREAK_TIES_DISPLAY"));
                    continue;
                }
                if (ProximitiesRestrictions.this.mIndependentVarTransformCombobox.getSelectedIndex() == 3) {
                    ProximitiesRestrictions.this.mProximitiesRenderer.getFormatVector().remove(nArray[i]);
                    ProximitiesRestrictions.this.mProximitiesRenderer.getFormatVector().add(nArray[i], ProximitiesRestrictions.this.getResString("IDS_PROXIMITIES_RESTRICTION_ORDINAL_KEEP_TIES_DISPLAY"));
                    continue;
                }
                if (ProximitiesRestrictions.this.mIndependentVarTransformCombobox.getSelectedIndex() == 4) {
                    ProximitiesRestrictions.this.mProximitiesRenderer.getFormatVector().remove(nArray[i]);
                    ProximitiesRestrictions.this.mProximitiesRenderer.getFormatVector().add(nArray[i], ProximitiesRestrictions.this.getResString("IDS_PROXIMITIES_RESTRICTION_SPLINE_DISPLAY") + " " + ProximitiesRestrictions.this.mDegreeTextField.getText() + " " + ProximitiesRestrictions.this.mKnotsTextField.getText());
                    continue;
                }
                if (ProximitiesRestrictions.this.mIndependentVarTransformCombobox.getSelectedIndex() == 0) {
                    ProximitiesRestrictions.this.mProximitiesRenderer.getFormatVector().remove(nArray[i]);
                    ProximitiesRestrictions.this.mProximitiesRenderer.getFormatVector().add(nArray[i], ProximitiesRestrictions.this.getResString("IDS_PROXIMITIES_RESTRICTION_INTERVAL_DISPLAY"));
                    continue;
                }
                if (ProximitiesRestrictions.this.mIndependentVarTransformCombobox.getSelectedIndex() != 1) continue;
                ProximitiesRestrictions.this.mProximitiesRenderer.getFormatVector().remove(nArray[i]);
                ProximitiesRestrictions.this.mProximitiesRenderer.getFormatVector().add(nArray[i], ProximitiesRestrictions.this.getResString("IDS_PROXIMITIES_RESTRICTION_NOMINAL_DISPLAY"));
            }
            ProximitiesRestrictions.this.mRestrictionVariablesPanel.getTargetList().repaint();
        }
    }
}

