/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.proxscal;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.MultiDimensionalCommonPanel;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ProximitiesPlots2
extends BaseSubDialog {
    public static final String COMMON_SPACE_RADIO = "IDS_PROXSCAL_PLOTS_COMMON_SPACE_CHECKBOX";
    public static final String ORIGINAL_RADIO = "IDS_PROXSCAL_PLOTS_ORIGINAL_CHECKBOX";
    public static final String DISTANCES_RADIO = "IDS_PROXSCAL_PLOTS_TRANSFORMED_PROXIMITIES_CHECKBOX";
    public static final String ALL_SOURCES_RADIO = "IDS_PROXSCAL_PLOTS_ALL_SOURCES_RADIOBUTTON";
    public static final String SELECT_SOURCES_RADIO = "IDS_PROXSCAL_PLOTS_SELECT_SOURCES_RADIOBUTTON";
    static final String AVAILABLE_LIST = "AvailableList";
    static final String SELECTED_LIST = "SelectedList";
    private JCheckBox mStressCheckBox;
    private JCheckBox mCommonSpaceCheckBox;
    private JCheckBox mIndividualSpacesCheckBox;
    private JCheckBox mIndividualSpaceWeightsCheckBox;
    private JCheckBox mOriginalCheckBox;
    private JCheckBox mDistanceCheckBox;
    private JCheckBox mIndependentVariablesCheckBox;
    private JCheckBox mCorrelationsCheckBox;
    private JRadioButton mAllSourcesRadioButton;
    private JRadioButton mSelectSourcesRadioButton;
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private MultiDimensionalCommonPanel mScaleDimension;
    private Vector<Object> mFocus;

    public ProximitiesPlots2(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prxc_plots";
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters();
        }
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (this.mOriginalCheckBox.isSelected() || this.mDistanceCheckBox.isSelected() || this.mIndividualSpacesCheckBox.isEnabled() && this.mIndividualSpacesCheckBox.isSelected()) {
            this.mAllSourcesRadioButton.setEnabled(true);
            this.mSelectSourcesRadioButton.setEnabled(true);
            if (this.mSelectSourcesRadioButton.isSelected()) {
                this.setEnableStatus(true);
            } else {
                this.setEnableStatus(false);
            }
        } else {
            this.mAllSourcesRadioButton.setEnabled(false);
            this.mSelectSourcesRadioButton.setEnabled(false);
            this.setEnableStatus(false);
        }
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            Component component = this.mCmdButtonPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mFocus.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mFocus, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        PlainList plainList = this.mScaleDimension.getSourceList();
        PlainList plainList2 = this.mScaleDimension.getTargetList();
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(plainList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(plainList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(plainList, this.mPlainListVarMoveHandler));
        plainListDragAdapter = new PlainListDragAdapter(plainList2, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(plainList2, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(plainList2, this.mPlainListVarMoveHandler));
    }

    private void initVars() {
        this.mFocus = new Vector();
        this.mStressCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_PROXSCAL_PLOTS_STRESS_CHECKBOX"));
        this.mCommonSpaceCheckBox = new JCheckBox(new ToggleButtonAction(this, COMMON_SPACE_RADIO));
        this.mIndividualSpacesCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_PROXSCAL_PLOTS_INDIVIDUAL_SPACES_CHECKBOX"));
        this.mIndividualSpaceWeightsCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_PROXSCAL_PLOTS_INDIVIDUAL_SPACE_WEIGHTS_CHECKBOX"));
        this.mOriginalCheckBox = new JCheckBox(new ToggleButtonAction(this, ORIGINAL_RADIO));
        this.mDistanceCheckBox = new JCheckBox(new ToggleButtonAction(this, DISTANCES_RADIO));
        this.mIndependentVariablesCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_PROXSCAL_PLOTS_TRANSFORMED_INDEPENDENT_CHECKBOX"));
        this.mCorrelationsCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_PROXSCAL_PLOTS1_VARIABLE_CHECKBOX"));
        this.mOriginalCheckBox.addActionListener(new CheckBoxListener());
        this.mDistanceCheckBox.addActionListener(new CheckBoxListener());
        this.mIndividualSpacesCheckBox.addActionListener(new CheckBoxListener());
        this.mAllSourcesRadioButton = new JRadioButton(new ToggleButtonAction(this, ALL_SOURCES_RADIO));
        this.mAllSourcesRadioButton.addActionListener(new CheckBoxListener());
        this.mSelectSourcesRadioButton = new JRadioButton(new ToggleButtonAction(this, SELECT_SOURCES_RADIO));
        this.mSelectSourcesRadioButton.addActionListener(new CheckBoxListener());
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mAllSourcesRadioButton);
        spssButtonGroup.add(this.mSelectSourcesRadioButton);
        this.mScaleDimension = new MultiDimensionalCommonPanel(this, "", "", AVAILABLE_LIST, SELECTED_LIST, "", "", false);
        this.mScaleDimension.getTargetList().getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                ProximitiesPlots2.this.enableContinue(true);
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                if (ProximitiesPlots2.this.mScaleDimension.getTargetList().getModel().getSize() == 0) {
                    ProximitiesPlots2.this.enableContinue(false);
                } else {
                    ProximitiesPlots2.this.enableContinue(true);
                }
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
            }
        });
        this.mFocus.add(this.mStressCheckBox);
        this.mFocus.add(this.mCommonSpaceCheckBox);
        this.mFocus.add(this.mIndividualSpacesCheckBox);
        this.mFocus.add(this.mIndividualSpaceWeightsCheckBox);
        this.mFocus.add(this.mOriginalCheckBox);
        this.mFocus.add(this.mDistanceCheckBox);
        this.mFocus.add(this.mIndependentVariablesCheckBox);
        this.mFocus.add(this.mCorrelationsCheckBox);
        this.mFocus.add(spssButtonGroup);
        this.mScaleDimension.getElementsForFocusVector(this.mFocus);
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
    }

    private void setDefaults() {
        ISpssVariable[] iSpssVariableArray;
        Object object;
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        if (dialogDataModel.getString("MIN_TEXT") != null) {
            object = dialogDataModel.getString("MIN_TEXT");
            this.mStressCheckBox.setEnabled(!((String)object).equals(iSpssVariableArray = dialogDataModel.getString("MAX_TEXT")));
            boolean bl = dialogDataModel.getBoolean("IDS_PROXSCAL_IDENTITY");
            this.mIndividualSpacesCheckBox.setEnabled(!bl);
            this.mIndividualSpaceWeightsCheckBox.setEnabled(!bl);
        } else {
            this.mStressCheckBox.setEnabled(false);
            this.mIndividualSpacesCheckBox.setEnabled(false);
            this.mIndividualSpaceWeightsCheckBox.setEnabled(false);
        }
        object = dialogDataModel.getBoolean("IDS_PROXSCAL_RESTRICTION_LINEAR_COMBINATION_RADIOBUTTON");
        if (object != null) {
            this.mIndependentVariablesCheckBox.setEnabled((Boolean)object);
            this.mCorrelationsCheckBox.setEnabled((Boolean)object);
        } else {
            this.mIndependentVariablesCheckBox.setEnabled(false);
            this.mCorrelationsCheckBox.setEnabled(false);
        }
        this.mCommonSpaceCheckBox.setSelected(true);
        this.mIndividualSpaceWeightsCheckBox.setSelected(true);
        this.mCorrelationsCheckBox.setSelected(true);
        this.mAllSourcesRadioButton.setSelected(true);
        this.mAllSourcesRadioButton.setEnabled(false);
        this.mSelectSourcesRadioButton.setEnabled(false);
        iSpssVariableArray = dialogDataModel.getVarArray("IDS_PROX_VAR_LIST");
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        Object[] objectArray = new String[iSpssVariableArray.length];
        for (int i = 0; iSpssVariableArray != null && i < iSpssVariableArray.length; ++i) {
            ISpssVariable iSpssVariable = iSpssVariableArray[i];
            objectArray[i] = iSpssVariable.getName();
        }
        dialogDataModel.putArray(AVAILABLE_LIST, objectArray);
        this.setEnableStatus(false);
    }

    private void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = this.setUpPlotsPanel();
        JPanel jPanel3 = this.setupSourcePlotsPanel();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mConstraints, 0, 1, 1, 1, n, null);
    }

    private JPanel setUpPlotsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mStressCheckBox, this.mCommonSpaceCheckBox, this.mIndividualSpacesCheckBox, this.mIndividualSpaceWeightsCheckBox, this.mOriginalCheckBox, this.mDistanceCheckBox, this.mIndependentVariablesCheckBox, this.mCorrelationsCheckBox};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_PROXSCAL_PLOTS_PLOTSPANEL_TITLE"), 4);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupSourcePlotsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PROXSCAL_PLOTS_SOURCEPLOTS_TITLE")));
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mAllSourcesRadioButton, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        this.mInsets.set(insets.top, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSelectSourcesRadioButton, this.mConstraints, 0, 1, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(DialogUtil.getComponentGroupGap(), 40, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mScaleDimension, this.mConstraints, 0, 2, 1, 1, n, this.mInsets);
        return jPanel;
    }

    private void setEnableStatus(boolean bl) {
        this.mScaleDimension.enableVisibleComponents(bl);
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox;
            if (actionEvent.getSource() instanceof JCheckBox && ((jCheckBox = (JCheckBox)actionEvent.getSource()) == ProximitiesPlots2.this.mOriginalCheckBox || jCheckBox == ProximitiesPlots2.this.mDistanceCheckBox || jCheckBox == ProximitiesPlots2.this.mIndividualSpacesCheckBox)) {
                if (ProximitiesPlots2.this.mOriginalCheckBox.isSelected() || ProximitiesPlots2.this.mDistanceCheckBox.isSelected() || ProximitiesPlots2.this.mIndividualSpacesCheckBox.isEnabled() && ProximitiesPlots2.this.mIndividualSpacesCheckBox.isSelected()) {
                    ProximitiesPlots2.this.mAllSourcesRadioButton.setEnabled(true);
                    ProximitiesPlots2.this.mSelectSourcesRadioButton.setEnabled(true);
                    if (ProximitiesPlots2.this.mSelectSourcesRadioButton.isSelected()) {
                        ProximitiesPlots2.this.setEnableStatus(true);
                    } else {
                        ProximitiesPlots2.this.setEnableStatus(false);
                    }
                } else {
                    ProximitiesPlots2.this.mAllSourcesRadioButton.setEnabled(false);
                    ProximitiesPlots2.this.mSelectSourcesRadioButton.setEnabled(false);
                    ProximitiesPlots2.this.setEnableStatus(false);
                }
            }
            if (actionEvent.getSource() instanceof JRadioButton) {
                if (ProximitiesPlots2.this.mSelectSourcesRadioButton.isSelected()) {
                    if (ProximitiesPlots2.this.mScaleDimension.getTargetList().getModel().getSize() == 0) {
                        ProximitiesPlots2.this.enableContinue(false);
                    } else {
                        ProximitiesPlots2.this.enableContinue(true);
                    }
                    ProximitiesPlots2.this.setEnableStatus(true);
                } else {
                    ProximitiesPlots2.this.setEnableStatus(false);
                    ProximitiesPlots2.this.enableContinue(true);
                }
            }
        }
    }
}

