/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.proxscal;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.MultidimensionalPlots;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ProximitiesPlots1
extends BaseSubDialog {
    private JCheckBox mStressCheckBox;
    private JCheckBox mCommonSpaceCheckBox;
    private JCheckBox mIndividualSpacesCheckBox;
    private JCheckBox mIndividualSpaceWeightsCheckBox;
    private JCheckBox mOriginalCheckBox;
    private JCheckBox mDistanceCheckBox;
    private JCheckBox mIndependentVariablesCheckBox;
    private JCheckBox mCorrelationsCheckBox;
    private GridBagConstraints mConstraints;
    private MultidimensionalPlots mSourcePlotsPanel;
    private Vector<Object> mFocus;

    public ProximitiesPlots1(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prxb_plots";
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (this.mOriginalCheckBox.isSelected() || this.mDistanceCheckBox.isSelected() || this.mIndividualSpacesCheckBox.isEnabled() && this.mIndividualSpacesCheckBox.isSelected()) {
            this.mSourcePlotsPanel.setEnabled(true);
        } else {
            this.mSourcePlotsPanel.setEnabled(false);
        }
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            Component component = this.mCmdButtonPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mFocus.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mFocus, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void initVars() {
        this.mFocus = new Vector();
        this.mStressCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_PROXSCAL_PLOTS_STRESS_CHECKBOX"));
        this.mCommonSpaceCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_PROXSCAL_PLOTS_COMMON_SPACE_CHECKBOX"));
        this.mIndividualSpacesCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_PROXSCAL_PLOTS_INDIVIDUAL_SPACES_CHECKBOX"));
        this.mIndividualSpaceWeightsCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_PROXSCAL_PLOTS_INDIVIDUAL_SPACE_WEIGHTS_CHECKBOX"));
        this.mOriginalCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_PROXSCAL_PLOTS_ORIGINAL_CHECKBOX"));
        this.mDistanceCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_PROXSCAL_PLOTS_TRANSFORMED_PROXIMITIES_CHECKBOX"));
        this.mIndependentVariablesCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_PROXSCAL_PLOTS_TRANSFORMED_INDEPENDENT_CHECKBOX"));
        this.mCorrelationsCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_PROXSCAL_PLOTS1_VARIABLE_CHECKBOX"));
        this.mOriginalCheckBox.addActionListener(new CheckBoxListener());
        this.mDistanceCheckBox.addActionListener(new CheckBoxListener());
        this.mIndividualSpacesCheckBox.addActionListener(new CheckBoxListener());
        String[] stringArray = new String[]{"IDS_PROXSCAL_PLOTS_ALL_SOURCES_RADIOBUTTON", "IDS_PROXSCAL_PLOTS_SELECT_SOURCES_RADIOBUTTON", "IDS_PROXSCAL_PLOTS_SOURCE_NUMBER_LABEL", "IDS_PROXSCAL_PLOTS_SOURCES_LABEL", "IDS_PROXSCAL_PLOTS_SOURCEPLOTS_TITLE"};
        this.mSourcePlotsPanel = new MultidimensionalPlots(stringArray, this);
        this.mFocus.add(this.mStressCheckBox);
        this.mFocus.add(this.mCommonSpaceCheckBox);
        this.mFocus.add(this.mIndividualSpacesCheckBox);
        this.mFocus.add(this.mIndividualSpaceWeightsCheckBox);
        this.mFocus.add(this.mOriginalCheckBox);
        this.mFocus.add(this.mDistanceCheckBox);
        this.mFocus.add(this.mIndependentVariablesCheckBox);
        this.mFocus.add(this.mCorrelationsCheckBox);
        this.mFocus.addAll(this.mSourcePlotsPanel.getTraversalComponents());
        this.mConstraints = new GridBagConstraints();
    }

    private void setDefaults() {
        Object object;
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        if (dialogDataModel.getString("MIN_TEXT") != null) {
            String string;
            object = dialogDataModel.getString("MIN_TEXT");
            this.mStressCheckBox.setEnabled(!((String)object).equals(string = dialogDataModel.getString("MAX_TEXT")));
            boolean bl = dialogDataModel.getBoolean("IDS_PROXSCAL_IDENTITY");
            this.mIndividualSpacesCheckBox.setEnabled(!bl);
            this.mIndividualSpaceWeightsCheckBox.setEnabled(!bl);
        } else {
            this.mStressCheckBox.setEnabled(false);
            this.mIndividualSpacesCheckBox.setEnabled(false);
            this.mIndividualSpaceWeightsCheckBox.setEnabled(false);
        }
        object = dialogDataModel.getBoolean("IDS_PROXSCAL_RESTRICTION_LINEAR_COMBINATION_RADIOBUTTON");
        if (object != null) {
            this.mIndependentVariablesCheckBox.setEnabled((Boolean)object);
            this.mCorrelationsCheckBox.setEnabled((Boolean)object);
        } else {
            this.mIndependentVariablesCheckBox.setEnabled(false);
            this.mCorrelationsCheckBox.setEnabled(false);
        }
        this.mCommonSpaceCheckBox.setSelected(true);
        this.mIndividualSpaceWeightsCheckBox.setSelected(true);
        this.mCorrelationsCheckBox.setSelected(true);
        this.mSourcePlotsPanel.setEnabled(false);
    }

    private void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = this.setUpPlotsPanel();
        JPanel jPanel3 = this.mSourcePlotsPanel.setupSourcePlotsPanel();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mConstraints, 0, 1, 1, 1, n, null);
    }

    private JPanel setUpPlotsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mStressCheckBox, this.mCommonSpaceCheckBox, this.mIndividualSpacesCheckBox, this.mIndividualSpaceWeightsCheckBox, this.mOriginalCheckBox, this.mDistanceCheckBox, this.mIndependentVariablesCheckBox, this.mCorrelationsCheckBox};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_PROXSCAL_PLOTS_PLOTSPANEL_TITLE"), 4);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox;
            if (actionEvent.getSource() instanceof JCheckBox && ((jCheckBox = (JCheckBox)actionEvent.getSource()) == ProximitiesPlots1.this.mOriginalCheckBox || jCheckBox == ProximitiesPlots1.this.mDistanceCheckBox || jCheckBox == ProximitiesPlots1.this.mIndividualSpacesCheckBox)) {
                if (ProximitiesPlots1.this.mOriginalCheckBox.isSelected() || ProximitiesPlots1.this.mDistanceCheckBox.isSelected() || ProximitiesPlots1.this.mIndividualSpacesCheckBox.isEnabled() && ProximitiesPlots1.this.mIndividualSpacesCheckBox.isSelected()) {
                    ProximitiesPlots1.this.mSourcePlotsPanel.setEnabled(true);
                } else {
                    ProximitiesPlots1.this.mSourcePlotsPanel.setEnabled(false);
                }
            }
        }
    }
}

