/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.proxscal;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.MultiDimensionalCommonSavePanel;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ProximitiesOutput
extends BaseSubDialog
implements ItemListener {
    static final String COMMOM_COORDINATES = "IDS_PROXSCAL_COMMON_COORDI";
    static final String INDV_COORDINATES = "IDS_PROXSCAL_INDV_COORDI";
    static final String INDV_WEIGHTS = "IDS_PROXSCAL_INDV_WGTS";
    static final String DISTANCES = "IDS_PROXSCAL_DISTANCES";
    static final String TRANS_PROX = "IDS_PROXSCAL_TRANS_PROX";
    static final String INPUT_DATA = "IDS_PROXSCAL_INPUT_DATA";
    static final String STRESS_FOR_RAND_STARTS = "IDS_PROXSCAL_STRESS_FOR_RAND";
    static final String ITER_HISTORY = "IDS_PROXSCAL_ITER_HISTORY";
    static final String MULT_STRESS_MEASURE = "IDS_PROXSCAL_MULT_STRESS";
    static final String STRESS_DECOMP = "IDS_PROXSCAL_STRESS_DECOMP";
    static final String TRANS_IND_VARS = "IDS_PROXSCAL_TRANS_IND_VARS";
    static final String VAR_AND_DIMEN_CORRELATION = "IDS_PROXSCAL_VAR_AND_COR";
    static final String SAVE_COMMOM_COORDINATES = "IDS_PROXSCAL_SAVE_COMMON_COORDI";
    static final String SAVE_INDV_WEIGHTS = "IDS_PROXSCAL_SAVE_INDV_WGTS";
    static final String SAVE_DISTANCES = "IDS_PROXSCAL_SAVE_DISTANCES";
    static final String SAVE_TRANS_PROX = "IDS_PROXSCAL_SAVE_TRANS_PROX";
    static final String SAVE_TRANS_IND_VARS = "IDS_PROXSCAL_SAVE_TRANS_IND_VARS";
    static final String FILE_BUTTON = "IDS_PROXSCAL_FILE_3_DOTS";
    static final String[] FILE_TEXT_EDIT = new String[]{"TEXT1", "TEXT2", "TEXT3", "TEXT4", "TEXT5"};
    static final String COMMON_TEXT_FIELD = "IDS_COMMON_TEXT_FIELD";
    static final String SPACE_TEXT_FIELD = "IDS_SPACE_TEXT_FIELD";
    static final String DIST_TEXT_FIELD = "IDS_DIST_TEXT_FIELD";
    static final String TRANS_TEXT_FIELD = "IDS_TRANS_TEXT_FIELD";
    static final String TRANSIND_TEXT_FIELD = "IDS_TRANSIND_TEXT_FIELD";
    static final String COMMON_DATASET_SELECTION_STATE = "IDS_COMMON_DATASET_SELECTION_STATE";
    static final String SPACE_DATASET_SELECTION_STATE = "IDS_SPACE_DATASET_SELECTION_STATE";
    static final String DIST_DATASET_SELECTION_STATE = "IDS_DIST_DATASET_SELECTION_STATE";
    static final String TRANS_DATASET_SELECTION_STATE = "IDS_TRANS_DATASET_SELECTION_STATE";
    static final String TRANSIND_DATASET_SELECTION_STATE = "IDS_TRANSIND_DATASET_SELECTION_STATE";
    static final String COMMON_DATASETNAME_TEXT_FIELD = "IDS_DATASETNAME_COMMON_TEXT_FIELD";
    static final String SPACE_DATASETNAME_TEXT_FIELD = "IDS_DATASETNAME_SPACE_TEXT_FIELD";
    static final String DIST_DATASETNAME_TEXT_FIELD = "IDS_DATASETNAME_DIST_TEXT_FIELD";
    static final String TRANS_DATASETNAME_TEXT_FIELD = "IDS_DATASETNAME_TRANS_TEXT_FIELD";
    static final String TRANSIND_DATASETNAME_TEXT_FIELD = "IDS_DATASETNAME_TRANS_TEXT_FIELD";
    JComponent[] mFileButtons;
    FileTextField[] mTextField;
    JCheckBox[] mCheckBoxes;
    String[] mFileName;
    private JCheckBox mCommonSpaceCord;
    private JCheckBox mIndvSpaceCord;
    private JCheckBox mIndvSpaceWgts;
    private JCheckBox mDistances;
    private JCheckBox mTransProx;
    private JCheckBox mInputData;
    private JCheckBox mStressForRandStarts;
    private JCheckBox mIterHistory;
    private JCheckBox mMultStressMeasures;
    private JCheckBox mStressDecomp;
    private JCheckBox mTransIndVars;
    private JCheckBox mVarAndDimenCor;
    private MultiDimensionalCommonSavePanel mSpaceCoordiPanel;
    private MultiDimensionalCommonSavePanel mIndividualSpWtPanel;
    private MultiDimensionalCommonSavePanel mDistancesPanel;
    private MultiDimensionalCommonSavePanel mTransformProxPanel;
    private MultiDimensionalCommonSavePanel mTransformIndPanel;

    public ProximitiesOutput(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_PROXSCAL_OUTPUT_TITLE"), true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = itemEvent.getStateChange() == 1;
        for (int i = 0; i < this.mCheckBoxes.length; ++i) {
            if (itemEvent.getSource() != this.mCheckBoxes[i]) continue;
            this.mFileButtons[i].setEnabled(bl);
            this.mTextField[i].setEnabled(bl);
            if (!bl) continue;
            this.enableContinue(!this.mTextField[i].getText().equals(""));
            break;
        }
        if (!bl) {
            this.canEnableContinueButton();
        }
    }

    public void validate() {
        super.validate();
        for (int i = 0; i < this.mCheckBoxes.length; ++i) {
            if (this.mFileName[i] == null || this.mFileName[i].length() <= 0) continue;
            this.mTextField[i].setText(this.mFileName[i]);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prxa_output";
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        boolean bl;
        String string;
        super.loadState(dialogDataModel);
        if (dialogDataModel.getBoolean(COMMON_DATASET_SELECTION_STATE) != null) {
            this.mSpaceCoordiPanel.setCreateNewDataSetRadio(dialogDataModel.getBoolean(COMMON_DATASET_SELECTION_STATE));
        }
        if ((string = dialogDataModel.getString(COMMON_DATASETNAME_TEXT_FIELD)) != null && string.length() > 0) {
            this.mSpaceCoordiPanel.setDatasetNameText(string);
        }
        if ((string = dialogDataModel.getString(COMMON_TEXT_FIELD)) != null && string.length() > 0) {
            this.mFileName[0] = string;
        }
        if (dialogDataModel.getBoolean(SPACE_DATASET_SELECTION_STATE) != null) {
            this.mIndividualSpWtPanel.setCreateNewDataSetRadio(dialogDataModel.getBoolean(SPACE_DATASET_SELECTION_STATE));
        }
        if ((string = dialogDataModel.getString(SPACE_DATASETNAME_TEXT_FIELD)) != null && string.length() > 0) {
            this.mIndividualSpWtPanel.setDatasetNameText(string);
        }
        if ((string = dialogDataModel.getString(SPACE_TEXT_FIELD)) != null && string.length() > 0) {
            this.mFileName[1] = string;
        }
        if (dialogDataModel.getBoolean(DIST_DATASET_SELECTION_STATE) != null) {
            this.mDistancesPanel.setCreateNewDataSetRadio(dialogDataModel.getBoolean(DIST_DATASET_SELECTION_STATE));
        }
        if ((string = dialogDataModel.getString(DIST_DATASETNAME_TEXT_FIELD)) != null && string.length() > 0) {
            this.mDistancesPanel.setDatasetNameText(string);
        }
        if ((string = dialogDataModel.getString(DIST_TEXT_FIELD)) != null && string.length() > 0) {
            this.mFileName[2] = string;
        }
        if (dialogDataModel.getBoolean(TRANS_DATASET_SELECTION_STATE) != null) {
            this.mTransformProxPanel.setCreateNewDataSetRadio(dialogDataModel.getBoolean(TRANS_DATASET_SELECTION_STATE));
        }
        if ((string = dialogDataModel.getString("IDS_DATASETNAME_TRANS_TEXT_FIELD")) != null && string.length() > 0) {
            this.mTransformProxPanel.setDatasetNameText(string);
        }
        if ((string = dialogDataModel.getString(TRANS_TEXT_FIELD)) != null && string.length() > 0) {
            this.mFileName[3] = string;
        }
        if (dialogDataModel.getBoolean(TRANSIND_DATASET_SELECTION_STATE) != null) {
            this.mTransformIndPanel.setCreateNewDataSetRadio(dialogDataModel.getBoolean(TRANSIND_DATASET_SELECTION_STATE));
        }
        if ((string = dialogDataModel.getString("IDS_DATASETNAME_TRANS_TEXT_FIELD")) != null && string.length() > 0) {
            this.mTransformIndPanel.setDatasetNameText(string);
        }
        if ((string = dialogDataModel.getString(TRANSIND_TEXT_FIELD)) != null && string.length() > 0) {
            this.mFileName[4] = string;
        }
        if (this.mParentDlg.getDialogDataModel().getBoolean("IDS_PROXSCAL_IDENTITY") != null) {
            bl = this.mParentDlg.getDialogDataModel().getBoolean("IDS_PROXSCAL_IDENTITY");
            this.mIndvSpaceCord.setEnabled(!bl);
            this.mIndvSpaceWgts.setEnabled(!bl);
            this.mIndividualSpWtPanel.setCreateCheckEnabled(!bl);
        } else {
            this.mIndvSpaceCord.setEnabled(false);
            this.mIndvSpaceWgts.setEnabled(false);
            this.mIndividualSpWtPanel.setCreateCheckEnabled(false);
        }
        if (this.mParentDlg.getDialogDataModel().getBoolean("IDS_PROXSCAL_RESTRICTION_LINEAR_COMBINATION_RADIOBUTTON") != null) {
            bl = this.mParentDlg.getDialogDataModel().getBoolean("IDS_PROXSCAL_RESTRICTION_LINEAR_COMBINATION_RADIOBUTTON");
            this.mTransIndVars.setEnabled(bl);
            this.mVarAndDimenCor.setEnabled(bl);
            this.mTransformIndPanel.setCreateCheckEnabled(bl);
        } else {
            this.mTransIndVars.setEnabled(false);
            this.mVarAndDimenCor.setEnabled(false);
            this.mTransformIndPanel.setCreateCheckEnabled(false);
        }
        if (this.mParentDlg.getDialogDataModel().getBoolean("IDS_PROXSCAL_MULT_RAND_START") != null) {
            this.mStressForRandStarts.setEnabled(this.mParentDlg.getDialogDataModel().getBoolean("IDS_PROXSCAL_MULT_RAND_START"));
        } else {
            this.mStressForRandStarts.setEnabled(false);
        }
        if (CommandLine.isClementineCaller()) {
            this.disableSaving();
        }
        this.enableContinue(true);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        dialogDataModel.putBoolean(COMMON_DATASET_SELECTION_STATE, this.mSpaceCoordiPanel.isCreateNewDataSetRadioSelected());
        dialogDataModel.putBoolean(SPACE_DATASET_SELECTION_STATE, this.mIndividualSpWtPanel.isCreateNewDataSetRadioSelected());
        dialogDataModel.putBoolean(DIST_DATASET_SELECTION_STATE, this.mDistancesPanel.isCreateNewDataSetRadioSelected());
        dialogDataModel.putBoolean(TRANS_DATASET_SELECTION_STATE, this.mTransformProxPanel.isCreateNewDataSetRadioSelected());
        dialogDataModel.putBoolean(TRANSIND_DATASET_SELECTION_STATE, this.mTransformIndPanel.isCreateNewDataSetRadioSelected());
        dialogDataModel.putString(COMMON_DATASETNAME_TEXT_FIELD, this.mSpaceCoordiPanel.getDatasetNameText());
        dialogDataModel.putString(SPACE_DATASETNAME_TEXT_FIELD, this.mIndividualSpWtPanel.getDatasetNameText());
        dialogDataModel.putString(DIST_DATASETNAME_TEXT_FIELD, this.mDistancesPanel.getDatasetNameText());
        dialogDataModel.putString("IDS_DATASETNAME_TRANS_TEXT_FIELD", this.mTransformProxPanel.getDatasetNameText());
        dialogDataModel.putString("IDS_DATASETNAME_TRANS_TEXT_FIELD", this.mTransformIndPanel.getDatasetNameText());
        dialogDataModel.putString(COMMON_TEXT_FIELD, this.mSpaceCoordiPanel.getFileText());
        dialogDataModel.putString(SPACE_TEXT_FIELD, this.mIndividualSpWtPanel.getFileText());
        dialogDataModel.putString(DIST_TEXT_FIELD, this.mDistancesPanel.getFileText());
        dialogDataModel.putString(TRANS_TEXT_FIELD, this.mTransformProxPanel.getFileText());
        dialogDataModel.putString(TRANSIND_TEXT_FIELD, this.mTransformIndPanel.getFileText());
        return bl;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.pack();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, COMMOM_COORDINATES);
        this.mCommonSpaceCord = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, INDV_COORDINATES);
        this.mIndvSpaceCord = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, INDV_WEIGHTS);
        this.mIndvSpaceWgts = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, DISTANCES);
        this.mDistances = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, TRANS_PROX);
        this.mTransProx = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, INPUT_DATA);
        this.mInputData = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, STRESS_FOR_RAND_STARTS);
        this.mStressForRandStarts = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, ITER_HISTORY);
        this.mIterHistory = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MULT_STRESS_MEASURE);
        this.mMultStressMeasures = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, STRESS_DECOMP);
        this.mStressDecomp = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, TRANS_IND_VARS);
        this.mTransIndVars = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, VAR_AND_DIMEN_CORRELATION);
        this.mVarAndDimenCor = new JCheckBox(toggleButtonAction);
        this.mSpaceCoordiPanel = new MultiDimensionalCommonSavePanel(this, this.getResString(SAVE_COMMOM_COORDINATES), this.getResString("IDS_MULTI_UNFOLD_SAVE_FILE_CHOOSER_TITLE"), this.getResString("IDS_MULTI_UNFOLD_FILE_FILTER"), this.getResString("IDS_MULTI_UNFOLD_FILE_EXTENSION"), SAVE_COMMOM_COORDINATES);
        this.mIndividualSpWtPanel = new MultiDimensionalCommonSavePanel(this, this.getResString(SAVE_INDV_WEIGHTS), this.getResString("IDS_MULTI_UNFOLD_SAVE_FILE_CHOOSER_TITLE"), this.getResString("IDS_MULTI_UNFOLD_FILE_FILTER"), this.getResString("IDS_MULTI_UNFOLD_FILE_EXTENSION"), SAVE_INDV_WEIGHTS);
        this.mDistancesPanel = new MultiDimensionalCommonSavePanel(this, this.getResString(SAVE_DISTANCES), this.getResString("IDS_MULTI_UNFOLD_SAVE_FILE_CHOOSER_TITLE"), this.getResString("IDS_MULTI_UNFOLD_FILE_FILTER"), this.getResString("IDS_MULTI_UNFOLD_FILE_EXTENSION"), SAVE_DISTANCES);
        this.mTransformProxPanel = new MultiDimensionalCommonSavePanel(this, this.getResString(SAVE_TRANS_PROX), this.getResString("IDS_MULTI_UNFOLD_SAVE_FILE_CHOOSER_TITLE"), this.getResString("IDS_MULTI_UNFOLD_FILE_FILTER"), this.getResString("IDS_MULTI_UNFOLD_FILE_EXTENSION"), SAVE_TRANS_PROX);
        this.mTransformIndPanel = new MultiDimensionalCommonSavePanel(this, this.getResString(SAVE_TRANS_IND_VARS), this.getResString("IDS_MULTI_UNFOLD_SAVE_FILE_CHOOSER_TITLE"), this.getResString("IDS_MULTI_UNFOLD_FILE_FILTER"), this.getResString("IDS_MULTI_UNFOLD_FILE_EXTENSION"), SAVE_TRANS_IND_VARS);
        this.mCheckBoxes = new JCheckBox[5];
        this.mCheckBoxes[0] = this.mSpaceCoordiPanel.getCheckBox();
        this.mCheckBoxes[1] = this.mIndividualSpWtPanel.getCheckBox();
        this.mCheckBoxes[2] = this.mDistancesPanel.getCheckBox();
        this.mCheckBoxes[3] = this.mTransformProxPanel.getCheckBox();
        this.mCheckBoxes[4] = this.mTransformIndPanel.getCheckBox();
        this.mFileButtons = new JComponent[this.mCheckBoxes.length];
        this.mFileButtons[0] = this.mSpaceCoordiPanel.getFileButton();
        this.mFileButtons[1] = this.mIndividualSpWtPanel.getFileButton();
        this.mFileButtons[2] = this.mDistancesPanel.getFileButton();
        this.mFileButtons[3] = this.mTransformProxPanel.getFileButton();
        this.mFileButtons[4] = this.mTransformIndPanel.getFileButton();
        this.mTextField = new FileTextField[this.mCheckBoxes.length];
        this.mTextField[0] = this.mSpaceCoordiPanel.getTextField();
        this.mTextField[1] = this.mIndividualSpWtPanel.getTextField();
        this.mTextField[2] = this.mDistancesPanel.getTextField();
        this.mTextField[3] = this.mTransformProxPanel.getTextField();
        this.mTextField[4] = this.mTransformIndPanel.getTextField();
        this.mFileName = new String[this.mCheckBoxes.length];
        this.mFileName[0] = this.mSpaceCoordiPanel.getFileName();
        this.mFileName[1] = this.mIndividualSpWtPanel.getFileName();
        this.mFileName[2] = this.mDistancesPanel.getFileName();
        this.mFileName[3] = this.mTransformProxPanel.getFileName();
        this.mFileName[4] = this.mTransformIndPanel.getFileName();
    }

    private void setDefaults() {
        this.mCommonSpaceCord.setSelected(true);
        this.mIndvSpaceWgts.setSelected(true);
        this.mMultStressMeasures.setSelected(true);
        this.mTransIndVars.setSelected(true);
        if (CommandLine.isClementineCaller()) {
            this.disableSaving();
        }
    }

    private void disableSaving() {
        this.mSpaceCoordiPanel.setCreateCheckEnabled(false);
        this.mIndividualSpWtPanel.setCreateCheckEnabled(false);
        this.mDistancesPanel.setCreateCheckEnabled(false);
        this.mTransformProxPanel.setCreateCheckEnabled(false);
        this.mTransformIndPanel.setCreateCheckEnabled(false);
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mCommonSpaceCord);
        vector.add(this.mIndvSpaceCord);
        vector.add(this.mIndvSpaceWgts);
        vector.add(this.mDistances);
        vector.add(this.mTransProx);
        vector.add(this.mInputData);
        vector.add(this.mStressForRandStarts);
        vector.add(this.mIterHistory);
        vector.add(this.mMultStressMeasures);
        vector.add(this.mStressDecomp);
        vector.add(this.mTransIndVars);
        vector.add(this.mVarAndDimenCor);
        for (n = 0; n < this.mCheckBoxes.length; ++n) {
            vector.add(this.mCheckBoxes[n]);
            vector.add(this.mFileButtons[n]);
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }

    private void setupViewPanel(JPanel jPanel) {
        JPanel jPanel2 = this.setupDisplayPanel();
        JPanel jPanel3 = this.setupSaveToNewFilePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(0, 0, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, null);
        DialogUtil.createButtonGroup(jPanel2);
        DialogUtil.createButtonGroup(jPanel3);
    }

    private JPanel setupDisplayPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mCommonSpaceCord, this.mIndvSpaceCord, this.mIndvSpaceWgts, this.mDistances, this.mTransProx, this.mInputData, this.mStressForRandStarts, this.mIterHistory, this.mMultStressMeasures, this.mStressDecomp, this.mTransIndVars, this.mVarAndDimenCor};
        return PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_PROXSCAL_DISPLAY_PANEL"), 6);
    }

    private JPanel setupSaveToNewFilePanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_PROXSCAL_SAVE_TO_NEW_FILE_PANEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mSpaceCoordiPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mIndividualSpWtPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mDistancesPanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mTransformProxPanel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mTransformIndPanel, gridBagConstraints, 2, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void canEnableContinueButton() {
        boolean bl = true;
        for (int i = 0; i < this.mCheckBoxes.length; ++i) {
            if (!this.mCheckBoxes[i].isSelected()) continue;
            bl &= !this.mTextField[i].getText().equals("");
        }
        this.enableContinue(bl);
    }
}

