/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.proxscal;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.MultiDimensionalCommonPanel;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesUtils;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ProximitiesOptions
extends BaseSubDialog
implements ItemListener,
DocumentListener,
ListDataListener {
    public static final String FILEPATH = "IDS_FILE_TEXT";
    public static final String AVAILABLE_FILE_IDENTIFIER = "AVAILABLE_FILE";
    public static final String SELECTED_FILE_IDENTIFIER = "SELECTED_FILE";
    static final String DEFAULT_NO_OF_STARTS = "2";
    static final String DEFAULT_STRESS = ".0001";
    static final String DEFAULT_MAX_ITER = "100";
    static final String SIMPLEX = "IDS_PROXSCAL_SIMPLEX";
    static final String TORGERSON = "IDS_PROXSCAL_TORGERSON";
    static final String SINGLE_RAND_START = "IDS_PROXSCAL_SINGLE_RAND_START";
    static final String MULT_RAND_STARTS = "IDS_PROXSCAL_MULT_RAND_START";
    static final String NO_OF_STARTS_EDIT = "IDS_NO_OF_STARTS_EDIT";
    static final String CUSTOM = "IDS_PROXSCAL_CUSTOM";
    static final String STRESS_CONV_EDIT = "IDS_STRESS_CONV_EDIT";
    static final String MIN_STRESS_EDIT = "IDS_MIN_STRESS_EDIT";
    static final String MAX_ITER_EDIT = "IDS_MAX_ITER_EDIT";
    static final String USE_REL_UPDATES = "IDS_PROXSCAL_USE_REL_UPD";
    private JRadioButton mSimplex;
    private JRadioButton mTorgerson;
    private JRadioButton mSingleRandStart;
    private JRadioButton mMultRandStarts;
    private JLabel mNoOfStarts;
    private IntTextField mNoOfStartsText;
    private JRadioButton mCustom;
    private SpssButtonGroup mInitConfigButtonGroup;
    private JLabel mStressConv;
    private FloatTextField mStressConvText;
    private JLabel mMinStress;
    private FloatTextField mMinStressText;
    private JLabel mMaxIter;
    private IntTextField mMaxIterText;
    private JCheckBox mUseRelUpdates;
    PlainList mSelectedList;
    MultiDimensionalCommonPanel mCustConfigPanel;

    public ProximitiesOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_PROXSCAL_OPTIONS_TITLE"), true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = itemEvent.getStateChange() == 1;
        boolean bl2 = false;
        bl2 = this.mStressConvText.getText().length() > 0;
        bl2 = bl2 && this.mMinStressText.getText().length() > 0;
        boolean bl3 = bl2 = bl2 && this.mMaxIterText.getText().length() > 0;
        if (itemEvent.getSource() == this.mMultRandStarts) {
            this.mNoOfStarts.setEnabled(bl);
            this.mNoOfStartsText.setEnabled(bl);
            this.mNoOfStartsText.setOpaque(bl);
            if (bl) {
                bl2 = bl2 && this.mNoOfStartsText.getText().length() > 0;
            }
        } else if (itemEvent.getSource() == this.mCustom) {
            this.mCustConfigPanel.enableComponents(bl);
            if (bl) {
                bl2 = bl2 && this.mSelectedList.getModel().getSize() > 0;
            }
        }
        this.enableContinue(bl2);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        boolean bl = false;
        bl = this.mStressConvText.getText().length() > 0;
        bl = bl && this.mMinStressText.getText().length() > 0;
        bl = bl && this.mMaxIterText.getText().length() > 0;
        bl = bl && this.mSelectedList.getModel().getSize() > 0;
        this.enableContinue(bl);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        boolean bl = false;
        bl = this.mStressConvText.getText().length() > 0;
        bl = bl && this.mMinStressText.getText().length() > 0;
        bl = bl && this.mMaxIterText.getText().length() > 0;
        bl = bl && this.mSelectedList.getModel().getSize() > 0;
        this.enableContinue(bl);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        boolean bl = false;
        bl = this.mStressConvText.getText().length() > 0;
        bl = bl && this.mMinStressText.getText().length() > 0;
        bl = bl && this.mMaxIterText.getText().length() > 0;
        bl = bl && this.mSelectedList.getModel().getSize() > 0;
        this.enableContinue(bl);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        boolean bl = false;
        bl = this.mStressConvText.getText().length() > 0;
        bl = bl && this.mMinStressText.getText().length() > 0;
        boolean bl2 = bl = bl && this.mMaxIterText.getText().length() > 0;
        if (this.mMultRandStarts.isSelected()) {
            bl = bl && this.mNoOfStartsText.getText().length() > 0;
        }
        this.enableContinue(bl);
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        boolean bl = false;
        bl = this.mStressConvText.getText().length() > 0;
        bl = bl && this.mMinStressText.getText().length() > 0;
        boolean bl2 = bl = bl && this.mMaxIterText.getText().length() > 0;
        if (this.mMultRandStarts.isSelected()) {
            bl = bl && this.mNoOfStartsText.getText().length() > 0;
        }
        this.enableContinue(bl);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        boolean bl = false;
        bl = this.mStressConvText.getText().length() > 0;
        bl = bl && this.mMinStressText.getText().length() > 0;
        boolean bl2 = bl = bl && this.mMaxIterText.getText().length() > 0;
        if (this.mMultRandStarts.isSelected()) {
            bl = bl && this.mNoOfStartsText.getText().length() > 0;
        }
        this.enableContinue(bl);
    }

    public MultiDimensionalCommonPanel getCustomConfigPanel() {
        return this.mCustConfigPanel;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prxa_options";
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        ProximitiesUtils.validateOptionsSubDialogModel(dialogDataModel);
        super.loadState(dialogDataModel);
        if (this.mParentDlg.getDialogDataModel().getString("MIN_TEXT") != null && Integer.parseInt(this.mParentDlg.getDialogDataModel().getString("MIN_TEXT")) < Integer.parseInt(this.mParentDlg.getDialogDataModel().getString("MAX_TEXT"))) {
            if (this.mMultRandStarts.isSelected()) {
                this.mSingleRandStart.setSelected(true);
            }
            this.mMultRandStarts.setEnabled(false);
        }
        if (this.mMultRandStarts.isSelected()) {
            this.mNoOfStarts.setEnabled(true);
            this.mNoOfStartsText.setEnabled(true);
            this.mNoOfStartsText.setOpaque(true);
        } else {
            this.mNoOfStarts.setEnabled(false);
            this.mNoOfStartsText.setEnabled(false);
            this.mNoOfStartsText.setOpaque(false);
        }
        boolean bl = ProximitiesOptions.isUseUpdatesEnabled(this.mParentDlg.getDialogDataModel());
        this.mUseRelUpdates.setEnabled(bl);
    }

    public static boolean isUseUpdatesEnabled(DialogDataModel dialogDataModel) {
        boolean bl = true;
        Boolean bl2 = dialogDataModel.getBoolean("IDS_PROXSCAL_IDENTITY");
        if (bl2 != null && !bl2.booleanValue()) {
            bl = false;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_PROXSCAL_RESTRICTION_NO_RESTRICTION_RADIOBUTTON")) != null && !bl2.booleanValue()) {
            bl = false;
        }
        return bl;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.pack();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, SIMPLEX);
        this.mSimplex = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, TORGERSON);
        this.mTorgerson = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, SINGLE_RAND_START);
        this.mSingleRandStart = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MULT_RAND_STARTS);
        this.mMultRandStarts = new JRadioButton(toggleButtonAction);
        this.mMultRandStarts.addItemListener(this);
        this.mNoOfStarts = DialogUtil.createLabel(this, "IDS_PROXSCAL_NO_OF_STARTS");
        this.mNoOfStartsText = new IntTextField(2, 99999999, true);
        this.mNoOfStartsText.setColumns(4);
        this.mNoOfStartsText.setAction((Action)new TextFieldAction(this.mParentDlg, NO_OF_STARTS_EDIT));
        this.mNoOfStartsText.getDocument().addDocumentListener(this);
        this.mNoOfStarts.setLabelFor((Component)this.mNoOfStartsText);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, CUSTOM);
        this.mCustom = new JRadioButton(toggleButtonAction);
        this.mCustom.addItemListener(this);
        this.mInitConfigButtonGroup = new SpssButtonGroup();
        this.mInitConfigButtonGroup.add(this.mSimplex);
        this.mInitConfigButtonGroup.add(this.mTorgerson);
        this.mInitConfigButtonGroup.add(this.mSingleRandStart);
        this.mInitConfigButtonGroup.add(this.mMultRandStarts);
        this.mInitConfigButtonGroup.add(this.mCustom);
        this.mStressConv = DialogUtil.createLabel(this, "IDS_PROXSCAL_STRESS_CONV");
        this.mStressConvText = new FloatTextField(0.0, 1.0, 7, true);
        this.mStressConvText.setColumns(4);
        this.mStressConvText.setAction((Action)new TextFieldAction(this.mParentDlg, STRESS_CONV_EDIT));
        this.mStressConvText.getDocument().addDocumentListener(this);
        this.mStressConv.setLabelFor((Component)this.mStressConvText);
        this.mMinStress = DialogUtil.createLabel(this, "IDS_PROXSCAL_MIN_STRESS");
        this.mMinStressText = new FloatTextField(0.0, 1.0, 7, true);
        this.mMinStressText.setColumns(4);
        this.mMinStressText.setAction((Action)new TextFieldAction(this.mParentDlg, MIN_STRESS_EDIT));
        this.mMinStressText.getDocument().addDocumentListener(this);
        this.mMinStress.setLabelFor((Component)this.mMinStressText);
        this.mMaxIter = DialogUtil.createLabel(this, "IDS_PROXSCAL_MAX_ITER");
        this.mMaxIterText = new IntTextField(1, 99999999, true);
        this.mMaxIterText.setColumns(4);
        this.mMaxIterText.setAction((Action)new TextFieldAction(this.mParentDlg, MAX_ITER_EDIT));
        this.mMaxIterText.getDocument().addDocumentListener(this);
        this.mMaxIter.setLabelFor((Component)this.mMaxIterText);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, USE_REL_UPDATES);
        this.mUseRelUpdates = new JCheckBox(toggleButtonAction);
        String string = DEFAULT_NO_OF_STARTS;
        if (this.mParentDlg.getDialogDataModel().getString("MAX_TEXT") != null) {
            string = this.mParentDlg.getDialogDataModel().getString("MAX_TEXT");
        }
        this.mCustConfigPanel = new MultiDimensionalCommonPanel(this, this.getResString("IDS_PROXSCAL_CUSTOM_CONFIG_PANEL"), FILEPATH, AVAILABLE_FILE_IDENTIFIER, SELECTED_FILE_IDENTIFIER, string, null, true);
        this.mCustConfigPanel.enableComponents(false);
        this.mCustConfigPanel.replaceDefaultFileChooserTitleKey("IDS_PROXSCAL_READ_FILE");
        this.mCustConfigPanel.replaceDefaultMnemonic("IDK_PROXSCAL_RESTRICTION_FILE_BUTTON_KEY", "IDK_MULTI_UNFOLD_CMN_AVAILABLE_KEY", "IDK_MULTI_UNFOLD_CMN_OPTION_SELECTED_KEY");
        this.mSelectedList = this.mCustConfigPanel.getTargetList();
        this.mSelectedList.getModel().addListDataListener(this);
    }

    private void setDefaults() {
        this.mSimplex.setSelected(true);
        this.mNoOfStartsText.setText(DEFAULT_NO_OF_STARTS);
        this.mStressConvText.setText(DEFAULT_STRESS);
        this.mMinStressText.setText(DEFAULT_STRESS);
        this.mMaxIterText.setText(DEFAULT_MAX_ITER);
        if (CommandLine.isClementineCaller()) {
            this.mCustom.setEnabled(false);
        }
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mInitConfigButtonGroup);
        vector.add(this.mNoOfStartsText);
        vector.add(this.mStressConvText);
        vector.add(this.mMinStressText);
        vector.add(this.mMaxIterText);
        vector.add(this.mUseRelUpdates);
        Vector<Object> vector2 = new Vector<Object>();
        this.mCustConfigPanel.getElementsForFocusVector(vector2);
        for (n = 0; n < vector2.size(); ++n) {
            vector.add(vector2.get(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }

    private void setupViewPanel(JPanel jPanel) {
        JPanel jPanel2 = this.setupInitConfigPanel();
        JPanel jPanel3 = this.setupIterCritPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, null);
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCustConfigPanel, gridBagConstraints, 0, 1, 2, 1, n, insets);
    }

    private JPanel setupInitConfigPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_PROXSCAL_INIT_CONFIG_PANEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mSimplex, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mTorgerson, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSingleRandStart, gridBagConstraints, 0, 2, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMultRandStarts, gridBagConstraints, 0, 3, 2, 1, n, insets);
        Insets insets2 = new Insets(insets.top, insets.left + 20, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mNoOfStarts, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        insets2.set(0, 0, 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNoOfStartsText, gridBagConstraints, 1, 4, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCustom, gridBagConstraints, 0, 5, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setupIterCritPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_PROXSCAL_ITER_CRITERIA_PANEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, insets.left, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin());
        Insets insets3 = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 2 * DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mStressConv, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStressConvText, gridBagConstraints, 1, 0, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMinStress, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinStressText, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMaxIter, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterText, gridBagConstraints, 1, 2, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mUseRelUpdates, gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        PlainList plainList = this.mCustConfigPanel.getSourceList();
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(plainList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(plainList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(plainList, this.mPlainListVarMoveHandler));
        PlainList plainList2 = this.mCustConfigPanel.getTargetList();
        plainListDragAdapter = new PlainListDragAdapter(plainList2, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(plainList2, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(plainList2, this.mPlainListVarMoveHandler));
    }
}

