/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.proxscal;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesCreateFromDataDlg;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesInColumnsDlg;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesInMatricesDlg;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesInOneColumnDlg;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ProximitiesModel
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    static final String IDENTITY = "IDS_PROXSCAL_IDENTITY";
    static final String WEIGHTED_EUCLIDEAN = "IDS_PROXSCAL_WEIGHTED_EUCL";
    static final String GENERALIZED_EUCLIDEAN = "IDS_PROXSCAL_GEN_EUCL";
    static final String REDUCED_RANK = "IDS_PROXSCAL_RED_RANK";
    static final String RANK_EDIT = "IDS_RANK_EDIT";
    static final String LOWER_TRI_MATRIX = "IDS_PROXSCAL_LOW_TRI_MATRIX";
    static final String UPPER_TRI_MATRIX = "IDS_PROXSCAL_UP_TRI_MATRIX";
    static final String FULL_MATRIX = "IDS_PROXSCAL_FULL_MATRIX";
    static final String DISSIMILARITIES = "IDS_PROXSCAL_DISSIMILARITIES";
    static final String SIMILARITIES = "IDS_PROXSCAL_SIMILARITIES";
    static final String RATIO = "IDS_PROXSCAL_RATIO";
    static final String INTERVAL = "IDS_PROXSCAL_INTERVAL";
    static final String ORDINAL = "IDS_PROXSCAL_ORDINAL";
    static final String UNTIE_TIED = "IDS_PROXSCAL_UNTIE";
    static final String SPLINE = "IDS_PROXSCAL_SPLINE";
    static final String DEGREE_EDIT = "IDS_DEGREE_EDIT";
    static final String INT_KNOTS_EDIT = "IDS_INT_KNOTS_EDIT";
    static final String EACH_SOURCE_SEP = "IDS_PROXSCAL_EACH_SRC_SEP";
    static final String ALL_SOURCES_SIMUL = "IDS_PROXSCAL_ALL_SRC_SIMUL";
    static final String MINIMUM_TEXT = "MIN_TEXT";
    static final String MAXIMUM_TEXT = "MAX_TEXT";
    private JRadioButton mIdentity;
    private JRadioButton mWtEuclidean;
    private JRadioButton mGenEuclidean;
    private JRadioButton mReducedRank;
    private JLabel mRank;
    private IntTextField mRankText;
    private JRadioButton mLowTriMatrix;
    private JRadioButton mUpperTriMatrix;
    private JRadioButton mFullMatrix;
    private JRadioButton mDissimilarities;
    private JRadioButton mSimilarities;
    private JRadioButton mRatio;
    private JRadioButton mInterval;
    private JRadioButton mOrdinal;
    private JCheckBox mUntie;
    private JRadioButton mSpline;
    private SpssButtonGroup mScModelButtonGroup;
    private SpssButtonGroup mShapeButtonGroup;
    private SpssButtonGroup mProxButtonGroup;
    private SpssButtonGroup mProxTransButtonGroup;
    private SpssButtonGroup mSourcesButtonGroup;
    private JLabel mDegree;
    private IntTextField mDegreeText;
    private JLabel mIntKnots;
    private IntTextField mIntKnotsText;
    private JLabel mApplyTrans;
    private JRadioButton mEachSourceSep;
    private JRadioButton mAllSourcesSimul;
    private IntTextField mMinimumText;
    private IntTextField mMaximumText;

    public ProximitiesModel(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_PROXSCAL_MODEL_TITLE"), true);
    }

    @Override
    public boolean continuePressed() {
        if (Integer.parseInt(this.mMinimumText.getText()) > Integer.parseInt(this.mMaximumText.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_PROXSCAL_MIN_GREATER_WARNING"), VersionInfo.getAppVersionString());
            this.mMaximumText.requestFocus();
            this.mMaximumText.selectAll();
            return false;
        }
        if (this.mReducedRank.isSelected() && Integer.parseInt(this.mRankText.getText()) >= Integer.parseInt(this.mMaximumText.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_PROXSCAL_RANK_GREATER_WARNING"), VersionInfo.getAppVersionString());
            this.mRankText.requestFocus();
            this.mRankText.selectAll();
            return false;
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = itemEvent.getStateChange() == 1;
        boolean bl2 = false;
        if (this.mMinimumText.getText().length() > 0 && this.mMaximumText.getText().length() > 0) {
            bl2 = true;
        }
        if (itemEvent.getSource() == this.mReducedRank) {
            this.mRank.setEnabled(bl);
            this.mRankText.setEnabled(bl);
            this.mRankText.setOpaque(bl);
            if (bl) {
                boolean bl3 = bl2 = bl2 && this.mRankText.getText().length() > 0;
            }
        }
        if (itemEvent.getSource() == this.mOrdinal) {
            this.mUntie.setEnabled(bl);
        } else if (itemEvent.getSource() == this.mSpline) {
            this.mDegree.setEnabled(bl);
            this.mDegreeText.setEnabled(bl);
            this.mDegreeText.setOpaque(bl);
            this.mIntKnots.setEnabled(bl);
            this.mIntKnotsText.setEnabled(bl);
            this.mIntKnotsText.setOpaque(bl);
            if (bl) {
                boolean bl4 = bl2 = bl2 && this.mDegreeText.getText().length() > 0 && this.mIntKnotsText.getText().length() > 0;
            }
        }
        if (itemEvent.getSource() == this.mSimilarities && bl) {
            if (this.mRatio.isSelected()) {
                this.mInterval.setSelected(bl);
            }
            this.mRatio.setEnabled(!bl);
        }
        if (itemEvent.getSource() == this.mDissimilarities) {
            this.mRatio.setEnabled(bl);
        }
        this.enableContinue(bl2);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        boolean bl = true;
        if (this.mReducedRank.isSelected()) {
            boolean bl2 = bl = this.mRankText.getText().length() > 0;
        }
        if (this.mSpline.isSelected()) {
            bl = bl && this.mDegreeText.getText().length() > 0 && this.mIntKnotsText.getText().length() > 0;
        }
        bl = bl && this.mMinimumText.getText().length() > 0 && this.mMaximumText.getText().length() > 0;
        this.enableContinue(bl);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        boolean bl = true;
        if (this.mReducedRank.isSelected()) {
            boolean bl2 = bl = this.mRankText.getText().length() > 0;
        }
        if (this.mSpline.isSelected()) {
            bl = bl && this.mDegreeText.getText().length() > 0 && this.mIntKnotsText.getText().length() > 0;
        }
        bl = bl && this.mMinimumText.getText().length() > 0 && this.mMaximumText.getText().length() > 0;
        this.enableContinue(bl);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        boolean bl = true;
        if (this.mReducedRank.isSelected()) {
            boolean bl2 = bl = this.mRankText.getText().length() > 0;
        }
        if (this.mSpline.isSelected()) {
            bl = bl && this.mDegreeText.getText().length() > 0 && this.mIntKnotsText.getText().length() > 0;
        }
        bl = bl && this.mMinimumText.getText().length() > 0 && this.mMaximumText.getText().length() > 0;
        this.enableContinue(bl);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prxa_model";
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        int n;
        super.loadState(dialogDataModel);
        DialogDataModel dialogDataModel2 = null;
        if (this.mParentDlg instanceof ProximitiesCreateFromDataDlg) {
            dialogDataModel2 = ((ProximitiesCreateFromDataDlg)this.mParentDlg).mGatingDialogModel;
        } else if (this.mParentDlg instanceof ProximitiesInColumnsDlg) {
            dialogDataModel2 = ((ProximitiesInColumnsDlg)this.mParentDlg).mGatingDialogModel;
        } else if (this.mParentDlg instanceof ProximitiesInMatricesDlg) {
            dialogDataModel2 = ((ProximitiesInMatricesDlg)this.mParentDlg).mGatingDialogModel;
        } else if (this.mParentDlg instanceof ProximitiesInOneColumnDlg) {
            dialogDataModel2 = ((ProximitiesInOneColumnDlg)this.mParentDlg).mGatingDialogModel;
        }
        if (dialogDataModel2.getBoolean("IDS_PROXSCAL_CREATE_PROXIMITIES_FROM_DATA").booleanValue()) {
            this.mLowTriMatrix.setEnabled(false);
            this.mUpperTriMatrix.setEnabled(false);
            this.mFullMatrix.setEnabled(false);
            this.mDissimilarities.setEnabled(false);
            this.mSimilarities.setEnabled(false);
            if (dialogDataModel2.getBoolean("IDS_PROXSCAL_ONE_MATRIX_SOURCE").booleanValue()) {
                this.mIdentity.setEnabled(false);
                this.mWtEuclidean.setEnabled(false);
                this.mGenEuclidean.setEnabled(false);
                this.mReducedRank.setEnabled(false);
                this.mEachSourceSep.setEnabled(false);
                this.mAllSourcesSimul.setEnabled(false);
                this.mApplyTrans.setEnabled(false);
            }
        } else if (dialogDataModel2.getBoolean("IDS_PROXSCAL_ONE_MATRIX_SOURCE").booleanValue()) {
            int n2 = dialogDataModel2.getInteger("ONE_SOURCE_LIST_INDEX");
            if (n2 == 1) {
                this.mLowTriMatrix.setEnabled(false);
                this.mUpperTriMatrix.setEnabled(false);
                this.mFullMatrix.setEnabled(false);
            }
            this.mIdentity.setEnabled(false);
            this.mWtEuclidean.setEnabled(false);
            this.mGenEuclidean.setEnabled(false);
            this.mReducedRank.setEnabled(false);
            this.mEachSourceSep.setEnabled(false);
            this.mAllSourcesSimul.setEnabled(false);
            this.mApplyTrans.setEnabled(false);
        } else if (dialogDataModel2.getBoolean("IDS_PROXSCAL_MULTIPLE_MATRIX_SOURCES").booleanValue() && ((n = dialogDataModel2.getInteger("MULTIPLE_SOURCE_LIST_INDEX").intValue()) == 1 || n == 2)) {
            this.mLowTriMatrix.setEnabled(false);
            this.mUpperTriMatrix.setEnabled(false);
            this.mFullMatrix.setEnabled(false);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.pack();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDENTITY);
        this.mIdentity = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, WEIGHTED_EUCLIDEAN);
        this.mWtEuclidean = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, GENERALIZED_EUCLIDEAN);
        this.mGenEuclidean = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, REDUCED_RANK);
        this.mReducedRank = new JRadioButton(toggleButtonAction);
        this.mReducedRank.addItemListener(this);
        this.mScModelButtonGroup = new SpssButtonGroup();
        this.mScModelButtonGroup.add(this.mIdentity);
        this.mScModelButtonGroup.add(this.mWtEuclidean);
        this.mScModelButtonGroup.add(this.mGenEuclidean);
        this.mScModelButtonGroup.add(this.mReducedRank);
        this.mRank = DialogUtil.createLabel(this, "IDS_PROXSCAL_RANK");
        this.mRankText = new IntTextField(1, 99999999, true);
        this.mRankText.setColumns(3);
        this.mRankText.setAction((Action)new TextFieldAction(this.mParentDlg, RANK_EDIT));
        this.mRankText.getDocument().addDocumentListener(this);
        this.mRank.setLabelFor((Component)this.mRankText);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, LOWER_TRI_MATRIX);
        this.mLowTriMatrix = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, UPPER_TRI_MATRIX);
        this.mUpperTriMatrix = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, FULL_MATRIX);
        this.mFullMatrix = new JRadioButton(toggleButtonAction);
        this.mShapeButtonGroup = new SpssButtonGroup();
        this.mShapeButtonGroup.add(this.mLowTriMatrix);
        this.mShapeButtonGroup.add(this.mUpperTriMatrix);
        this.mShapeButtonGroup.add(this.mFullMatrix);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, DISSIMILARITIES);
        this.mDissimilarities = new JRadioButton(toggleButtonAction);
        this.mDissimilarities.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, SIMILARITIES);
        this.mSimilarities = new JRadioButton(toggleButtonAction);
        this.mSimilarities.addItemListener(this);
        this.mProxButtonGroup = new SpssButtonGroup();
        this.mProxButtonGroup.add(this.mDissimilarities);
        this.mProxButtonGroup.add(this.mSimilarities);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, RATIO);
        this.mRatio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, INTERVAL);
        this.mInterval = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, ORDINAL);
        this.mOrdinal = new JRadioButton(toggleButtonAction);
        this.mOrdinal.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, UNTIE_TIED);
        this.mUntie = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, SPLINE);
        this.mSpline = new JRadioButton(toggleButtonAction);
        this.mSpline.addItemListener(this);
        this.mDegree = DialogUtil.createLabel(this, "IDS_PROXSCAL_DEGREE");
        this.mIntKnots = DialogUtil.createLabel(this, "IDS_PROXSCAL_INT_KNOTS");
        this.mProxTransButtonGroup = new SpssButtonGroup();
        this.mProxTransButtonGroup.add(this.mRatio);
        this.mProxTransButtonGroup.add(this.mInterval);
        this.mProxTransButtonGroup.add(this.mOrdinal);
        this.mProxTransButtonGroup.add(this.mSpline);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, EACH_SOURCE_SEP);
        this.mDegreeText = new IntTextField(1, 3, true);
        this.mDegreeText.setColumns(4);
        this.mDegreeText.setAction((Action)new TextFieldAction(this.mParentDlg, DEGREE_EDIT));
        this.mDegreeText.getDocument().addDocumentListener(this);
        this.mDegree.setLabelFor((Component)this.mDegreeText);
        this.mIntKnotsText = new IntTextField(0, 99999999, true);
        this.mIntKnotsText.setColumns(4);
        this.mIntKnotsText.setAction((Action)new TextFieldAction(this.mParentDlg, INT_KNOTS_EDIT));
        this.mIntKnotsText.getDocument().addDocumentListener(this);
        this.mIntKnots.setLabelFor((Component)this.mIntKnotsText);
        this.mApplyTrans = new JLabel(this.getResString("IDS_PROXSCAL_APPLY_TRANS"));
        this.mEachSourceSep = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, ALL_SOURCES_SIMUL);
        this.mAllSourcesSimul = new JRadioButton(toggleButtonAction);
        this.mSourcesButtonGroup = new SpssButtonGroup();
        this.mSourcesButtonGroup.add(this.mEachSourceSep);
        this.mSourcesButtonGroup.add(this.mAllSourcesSimul);
        this.mMinimumText = new IntTextField(1, 99999999, true);
        this.mMinimumText.setColumns(3);
        this.mMinimumText.setAction((Action)new TextFieldAction(this.mParentDlg, MINIMUM_TEXT));
        this.mMinimumText.getDocument().addDocumentListener(this);
        this.mMaximumText = new IntTextField(1, 99999999, true);
        this.mMaximumText.setColumns(3);
        this.mMaximumText.setAction((Action)new TextFieldAction(this.mParentDlg, MAXIMUM_TEXT));
        this.mMaximumText.getDocument().addDocumentListener(this);
    }

    private void setDefaults() {
        this.mIdentity.setSelected(true);
        this.mLowTriMatrix.setSelected(true);
        this.mDissimilarities.setSelected(true);
        this.mRatio.setSelected(true);
        this.mEachSourceSep.setSelected(true);
        boolean bl = this.mReducedRank.isSelected();
        this.mRank.setEnabled(bl);
        this.mRankText.setText("1");
        this.mRankText.setEnabled(bl);
        this.mRankText.setOpaque(bl);
        boolean bl2 = this.mSpline.isSelected();
        this.mDegree.setEnabled(bl2);
        this.mDegreeText.setText("2");
        this.mDegreeText.setEnabled(bl2);
        this.mDegreeText.setOpaque(bl2);
        this.mIntKnots.setEnabled(bl2);
        this.mIntKnotsText.setText("1");
        this.mIntKnotsText.setEnabled(bl2);
        this.mIntKnotsText.setOpaque(bl2);
        this.mUntie.setEnabled(this.mOrdinal.isSelected());
        this.mMinimumText.setText("2");
        this.mMaximumText.setText("2");
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mScModelButtonGroup);
        vector.add(this.mRankText);
        vector.add(this.mShapeButtonGroup);
        vector.add(this.mProxButtonGroup);
        vector.add(this.mProxTransButtonGroup);
        vector.add(this.mUntie);
        vector.add(this.mDegreeText);
        vector.add(this.mIntKnotsText);
        vector.add(this.mSourcesButtonGroup);
        vector.add(this.mMinimumText);
        vector.add(this.mMaximumText);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void setupViewPanel(JPanel jPanel) {
        JPanel jPanel2 = this.setupScModelPanel();
        JPanel jPanel3 = this.setupShapePanel();
        JPanel jPanel4 = this.setupProximitiesPanel();
        JPanel jPanel5 = this.setupDimensionsPanel();
        JPanel jPanel6 = this.setupProxTransPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(0, 0, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel6, gridBagConstraints, 1, 0, 1, 2, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 1, 2, 1, 1, n, null);
    }

    private JPanel setupScModelPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_PROXSCAL_SCALING_MODEL_PANEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mIdentity, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mWtEuclidean, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mGenEuclidean, gridBagConstraints, 0, 2, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mReducedRank, gridBagConstraints, 0, 3, 2, 1, n, insets);
        Insets insets2 = new Insets(insets.top, insets.left + 40, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRank, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        insets2.set(0, 0, DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mRankText, gridBagConstraints, 1, 4, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupShapePanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mLowTriMatrix, this.mUpperTriMatrix, this.mFullMatrix};
        return PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_PROXSCAL_SHAPE_PANEL"));
    }

    private JPanel setupProximitiesPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mDissimilarities, this.mSimilarities};
        return PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_PROXSCAL_PROX_PANEL"));
    }

    private JPanel setupProxTransPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_PROXSCAL_PROX_TRANS_PANEL"));
        JSeparator jSeparator = new JSeparator();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mRatio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mInterval, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mOrdinal, gridBagConstraints, 0, 2, 2, 1, n, insets);
        Insets insets2 = new Insets(insets.top, insets.left + 20, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mUntie, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mSpline, gridBagConstraints, 0, 4, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets3 = new Insets(0, 0, DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mDegree, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDegreeText, gridBagConstraints, 1, 5, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mIntKnots, gridBagConstraints, 0, 6, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mIntKnotsText, gridBagConstraints, 1, 6, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mApplyTrans, gridBagConstraints, 0, 7, 1, 1, n, null);
        n = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 1, 7, 1, 1, n, null);
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mEachSourceSep, gridBagConstraints, 0, 8, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mAllSourcesSimul, gridBagConstraints, 0, 9, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setupDimensionsPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_PROXSCAL_DIMENSIONS_PANEL"));
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PROXSCAL_MIN");
        jLabel.setLabelFor((Component)this.mMinimumText);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_PROXSCAL_MAX");
        jLabel2.setLabelFor((Component)this.mMaximumText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinimumText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaximumText, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }
}

