/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.proxscal;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ListFocusTraversalPolicy;
import com.spss.java_client.ui.controls.ListTravArrowButtonFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesModel;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesOptions;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesOutput;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesPlots1;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesRestrictions;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesUtils;
import com.spss.java_client.ui.dialogs.market_research.res.MarketResearchResBundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ProximitiesInMatricesDlg
extends BaseProcedureDialog
implements ListDataListener {
    static final String PROX_VAR_LIST = "IDS_PROX_VAR_LIST";
    static final String ROWS_VAR_LIST = "IDS_ROWS_VAR_LIST";
    static final String SOURCES_VAR_LIST = "IDS_SOURCES_VAR_LIST";
    static final String WEIGHTS_VAR_LIST = "IDS_WEIGHTS_VAR_LIST";
    static final String WLSWEIGHT_LIST = "IDS_WLSWEIGHT_LIST";
    static final String MODEL_BUTTON = "IDS_COMMON_MODEL_BUTTON";
    static final String RESTRICTIONS_BUTTON = "IDS_COMMON_RESTRICT_BUTTON";
    static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    static final String PLOTS_BUTTON = "IDS_COMMON_PLOTS_BUTTON";
    static final String OUTPUT_BUTTON = "IDS_COMMON_OUTPUT_BUTTON";
    DialogDataModel mGatingDialogModel;
    private ArrowButton mProxListArrow;
    private ArrowButton mSourcesListArrow;
    private ArrowButton mWeightsListArrow;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mProxVarList;
    private TargetVariableList mSourcesVarList;
    private TargetVariableList mWeightsVarList;
    private JLabel mSourcesVarListLabel;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mProxListScrollPane;
    private JScrollPane mSourcesListScrollPane;
    private JScrollPane mWeightsListScrollPane;
    private ProximitiesOptions mOptionsDialog;
    private ListTravArrowButtonFactory mProxListButton;
    private ListTravArrowButtonFactory mWgtsListButton;

    public ProximitiesInMatricesDlg(JFrame jFrame) {
        super(jFrame, false, MarketResearchResBundle.getDefaultResourceBundleName(), MarketResearchResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_PROXSCAL_PROXIMITIES_IN_MATRICES_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mProxVarList.getModel().getSize() > 2);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mProxVarList.getModel().getSize() > 2);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mProxVarList.getModel().getSize() > 2);
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public String generateSyntax() {
        Boolean bl;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getMainCommand("PROXSCAL"));
        String string = this.mProxVarList.getVariablesStringList();
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES=") + string + "\n");
        if (this.mGatingDialogModel.getBoolean("IDS_PROXSCAL_MULTIPLE_MATRIX_SOURCES").booleanValue()) {
            string = this.mSourcesVarList.getVariablesStringList();
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("TABLE", string));
        }
        if ((string = this.mWeightsVarList.getVariablesStringList()) != null && !string.equals("")) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("WEIGHTS", string));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_PROXSCAL_LOW_TRI_MATRIX")) == null || bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("SHAPE", "LOWER"));
        } else {
            bl = dialogDataModel.getBoolean("IDS_PROXSCAL_UP_TRI_MATRIX");
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("SHAPE", "UPPER"));
            }
            if ((bl = dialogDataModel.getBoolean("IDS_PROXSCAL_FULL_MATRIX")) != null && bl.booleanValue()) {
                stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("SHAPE", "BOTH"));
            }
        }
        stringBuffer.append(ProximitiesUtils.generateInitialSyntax(dialogDataModel));
        if (this.mGatingDialogModel.getBoolean("IDS_PROXSCAL_MULTIPLE_MATRIX_SOURCES").booleanValue()) {
            bl = dialogDataModel.getBoolean("IDS_PROXSCAL_ALL_SRC_SIMUL");
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("CONDITION", "UNCONDITIONAL"));
            } else {
                stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("CONDITION", "MATRIX"));
            }
        }
        stringBuffer.append(ProximitiesUtils.generateTransformationSyntax(dialogDataModel));
        bl = dialogDataModel.getBoolean("IDS_PROXSCAL_SIMILARITIES");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("PROXIMITIES", "SIMILARITIES"));
        } else {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("PROXIMITIES", "DISSIMILARITIES"));
        }
        if (this.mGatingDialogModel.getBoolean("IDS_PROXSCAL_MULTIPLE_MATRIX_SOURCES").booleanValue()) {
            stringBuffer.append(ProximitiesUtils.generateModelSyntax(dialogDataModel));
        }
        stringBuffer.append(ProximitiesUtils.generateRestrictionSyntax(dialogDataModel));
        ProximitiesUtils.appendAccelerationSyntax(stringBuffer, dialogDataModel);
        stringBuffer.append(ProximitiesUtils.generateCriteriaSyntax(dialogDataModel));
        stringBuffer.append(ProximitiesUtils.generatePrintSyntax(dialogDataModel));
        stringBuffer.append(ProximitiesUtils.generateOutfileSyntax(dialogDataModel));
        stringBuffer.append(ProximitiesUtils.generatePlotsSyntax(dialogDataModel));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(ProximitiesUtils.generatePerAttributesSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prxm";
    }

    @Override
    public String getIActionKey() {
        return "analyze_scale_one_matr_prox_in_matrices";
    }

    @Override
    public boolean okPastePressed() {
        int n;
        Object[] objectArray;
        Object object;
        if (this.mWeightsVarList.getModel().getSize() > 0 && this.mWeightsVarList.getModel().getSize() != this.mProxVarList.getModel().getSize()) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_PROXSCAL_WEIGHTS_VAR_WARNING"), VersionInfo.getAppVersionString());
            return false;
        }
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_PROXSCAL_CUSTOM");
        if (bl != null && bl.booleanValue()) {
            object = dialogDataModel.getString("MAX_TEXT");
            objectArray = dialogDataModel.getArray("SELECTED_FILE");
            n = objectArray == null ? 0 : objectArray.length;
            Object object2 = object = object == null ? "2" : object;
            if (Integer.parseInt((String)object) != n) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DIMENSION_MATCH_WARNING"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        if ((object = dialogDataModel.getBoolean("IDS_PROXSCAL_RESTRICTION_SOME_COORDINATES_RADIOBUTTON")) != null && ((Boolean)object).booleanValue() && (objectArray = dialogDataModel.getArray("targetIdentifier")) != null) {
            n = objectArray.length;
            String string = dialogDataModel.getString("MAX_TEXT");
            String string2 = string = string == null ? "2" : string;
            if (Integer.parseInt(string) != n) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DIMENSION_MATCH_WARNING"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        return super.okPastePressed();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected boolean validateDialogDataModel(boolean bl) {
        super.validateDialogDataModel(bl);
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ProximitiesUtils.validateRestrictionSubDialogModel(dialogDataModel);
        ProximitiesUtils.validateOptionsSubDialogModel(dialogDataModel);
        return true;
    }

    protected void initVars() {
        this.mGatingDialogModel = new DialogDataModel();
        ProcedureDlgMgr.getMgr().loadPersistentState("analyze_scale_mult_proxscal", this.mGatingDialogModel);
        Boolean bl = this.mGatingDialogModel.getBoolean("IDS_PROXSCAL_ONE_MATRIX_SOURCE");
        if (bl == null) {
            this.mGatingDialogModel.putBoolean("IDS_PROXSCAL_ONE_MATRIX_SOURCE", true);
            this.mGatingDialogModel.putBoolean("IDS_PROXSCAL_MULTIPLE_MATRIX_SOURCES", false);
            this.mGatingDialogModel.putBoolean("IDS_PROXSCAL_DATA_ARE_PROXIMITIES", true);
            this.mGatingDialogModel.putBoolean("IDS_PROXSCAL_CREATE_PROXIMITIES_FROM_DATA", false);
            this.mGatingDialogModel.putInteger("ONE_SOURCE_LIST_INDEX", 0);
        }
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, false);
        this.mSrcVarList.addVarFilter(spssVarFilter);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.setSelectedIndex(0);
        this.mProxVarList = new TargetVariableList();
        this.mProxVarList.getModel().addListDataListener(this);
        this.mProxVarList.setIdentifier(PROX_VAR_LIST);
        this.mProxVarList.addVarFilter(spssVarFilter);
        this.mProxListScrollPane = new JScrollPane(this.mProxVarList);
        this.mProxListScrollPane.setPreferredSize(this.mProxVarList.getMinimumSize());
        this.mWeightsVarList = new TargetVariableList();
        this.mWeightsVarList.setIdentifier(WEIGHTS_VAR_LIST);
        this.mWeightsVarList.addVarFilter(spssVarFilter);
        this.mWeightsListScrollPane = new JScrollPane(this.mWeightsVarList);
        this.mWeightsListScrollPane.setPreferredSize(this.mWeightsVarList.getMinimumSize());
        this.mSourcesVarListLabel = DialogUtil.createLabel(this, "IDS_PROXSCAL_SOURCES");
        this.mSourcesVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mSourcesVarList.setIdentifier(SOURCES_VAR_LIST);
        this.mSourcesVarList.addVarFilter(spssVarFilter);
        this.mSourcesVarListLabel.setLabelFor(this.mSourcesVarList);
        this.mSourcesListScrollPane = new JScrollPane(this.mSourcesVarList);
        this.mSourcesListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mSourcesListScrollPane.setVerticalScrollBarPolicy(21);
        this.mSourcesListScrollPane.setPreferredSize(this.mSourcesVarList.getMinimumSize());
        this.mProxListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mProxListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mProxListArrow.registerVariableList(this.mProxVarList, SpssArrowButton.ButtonOrientation.left);
        this.mWeightsListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mWeightsListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mWeightsListArrow.registerVariableList(this.mWeightsVarList, SpssArrowButton.ButtonOrientation.left);
        this.mSourcesListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSourcesListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSourcesListArrow.registerVariableList(this.mSourcesVarList, SpssArrowButton.ButtonOrientation.left);
        this.mProxListButton = new ListTravArrowButtonFactory(this.mProxVarList, false);
        this.mWgtsListButton = new ListTravArrowButtonFactory(this.mWeightsVarList, false);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(MODEL_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProximitiesInMatricesDlg.this.runModelSubDlg();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(RESTRICTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProximitiesInMatricesDlg.this.runRestrictionsSubDlg();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        if (CommandLine.isClementineCaller()) {
            jButton2.setEnabled(false);
        }
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProximitiesInMatricesDlg.this.runOptionsSubDlg();
            }
        };
        JButton jButton3 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton3);
        toggleButtonAction = new ToggleButtonAction(PLOTS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProximitiesInMatricesDlg.this.runPlotsSubDlg();
            }
        };
        JButton jButton4 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton4);
        toggleButtonAction = new ToggleButtonAction(OUTPUT_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProximitiesInMatricesDlg.this.runOutputSubDlg();
            }
        };
        JButton jButton5 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton5);
        return jPanel;
    }

    protected void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mProxVarList.removeAll();
        this.mWeightsVarList.removeAll();
        this.mSourcesVarList.removeAll();
        this.enableOkPaste(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        boolean bl = this.mGatingDialogModel.getBoolean("IDS_PROXSCAL_ONE_MATRIX_SOURCE");
        this.mSourcesVarListLabel.setEnabled(!bl);
        this.mSourcesListArrow.setEnabled(!bl);
        this.mSourcesVarList.setEnabled(!bl);
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mProxListArrow);
        vector.add(this.mWeightsListArrow);
        vector.add(this.mSourcesListArrow);
        vector.add(this.mProxVarList);
        vector.add(this.mProxListButton.getUpArrowButton());
        vector.add(this.mProxListButton.getDownArrowButton());
        vector.add(this.mWeightsVarList);
        vector.add(this.mWgtsListButton.getUpArrowButton());
        vector.add(this.mWgtsListButton.getDownArrowButton());
        vector.add(this.mSourcesVarList);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        ListFocusTraversalPolicy listFocusTraversalPolicy = new ListFocusTraversalPolicy(new ListTravArrowButtonFactory[]{this.mProxListButton, this.mWgtsListButton}, vector, false);
        this.setFocusTraversalPolicy(listFocusTraversalPolicy);
    }

    private void setupViewPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PROXSCAL_PROXIMITIES");
        jLabel.setLabelFor(this.mProxVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_PROXSCAL_WEIGHTS");
        jLabel2.setLabelFor(this.mWeightsVarList);
        JPanel jPanel2 = this.mProxListButton.getArrowButtonPanel();
        JPanel jPanel3 = this.mWgtsListButton.getArrowButtonPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_PROXSCAL_PROXIMITIES_IN_MATRICES_SOURCE_LABEL");
        jLabel3.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 9, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mProxListArrow, gridBagConstraints, 1, 1, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mProxListScrollPane, gridBagConstraints, 2, 1, 1, 2, n, null);
        n = 25;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 3, 2, 1, 1, n, null);
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mWeightsListArrow, gridBagConstraints, 1, 4, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        Insets insets3 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 3, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mWeightsListScrollPane, gridBagConstraints, 2, 4, 1, 2, n, null);
        n = 25;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 3, 5, 1, 1, n, null);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mSourcesListArrow, gridBagConstraints, 1, 6, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSourcesVarListLabel, gridBagConstraints, 2, 6, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mSourcesListScrollPane, gridBagConstraints, 2, 7, 1, 1, n, null);
    }

    private void runModelSubDlg() {
        this.runSubDialog(new ProximitiesModel(this));
    }

    private void runRestrictionsSubDlg() {
        this.runSubDialog(new ProximitiesRestrictions(this, this.getResString("IDS_PROXSCAL_RESTRICTION_TITLE"), true));
    }

    private void runPlotsSubDlg() {
        this.runSubDialog(new ProximitiesPlots1(this, this.getResString("IDS_PROXSCAL_PLOTS_DIALOG_TITLE"), true));
    }

    private void runOutputSubDlg() {
        this.runSubDialog(new ProximitiesOutput(this));
    }

    private void runOptionsSubDlg() {
        this.mOptionsDialog = new ProximitiesOptions(this);
        this.runSubDialog(this.mOptionsDialog);
    }
}

