/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.proxscal;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ListFocusTraversalPolicy;
import com.spss.java_client.ui.controls.ListTravArrowButtonFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesModel;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesOptions;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesOutput;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesPlots2;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesRestrictions;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesUtils;
import com.spss.java_client.ui.dialogs.market_research.res.MarketResearchResBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ProximitiesInColumnsDlg
extends BaseProcedureDialog
implements ListDataListener {
    static final String PROX_VAR_LIST = "IDS_PROX_VAR_LIST";
    static final String ROWS_VAR_LIST = "IDS_ROWS_VAR_LIST";
    static final String COLS_VAR_LIST = "IDS_COLS_VAR_LIST";
    static final String WEIGHTS_VAR_LIST = "IDS_WEIGHTS_VAR_LIST";
    static final String MODEL_BUTTON = "IDS_COMMON_MODEL_BUTTON";
    static final String RESTRICTIONS_BUTTON = "IDS_COMMON_RESTRICT_BUTTON";
    static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    static final String PLOTS_BUTTON = "IDS_COMMON_PLOTS_BUTTON";
    static final String OUTPUT_BUTTON = "IDS_COMMON_OUTPUT_BUTTON";
    DialogDataModel mGatingDialogModel;
    private ArrowButton mProxListArrow;
    private ArrowButton mRowsListArrow;
    private ArrowButton mColumnsListArrow;
    private ArrowButton mWeightsListArrow;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mProxVarList;
    private TargetVariableList mRowsVarList;
    private TargetVariableList mColumnsVarList;
    private TargetVariableList mWeightsVarList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mProxListScrollPane;
    private JScrollPane mRowsListScrollPane;
    private JScrollPane mColumnsListScrollPane;
    private JScrollPane mWeightsListScrollPane;
    private ListTravArrowButtonFactory mListButton;

    public ProximitiesInColumnsDlg(JFrame jFrame) {
        super(jFrame, false, MarketResearchResBundle.getDefaultResourceBundleName(), MarketResearchResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_PROXSCAL_PROXIMITIES_IN_COLUMNS_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        boolean bl = this.mProxVarList.getModel().getSize() > 1;
        bl = bl && this.mRowsVarList.getModel().getSize() > 0;
        bl = bl && this.mColumnsVarList.getModel().getSize() > 0;
        this.enableOkPaste(bl);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        DialogDataModel dialogDataModel;
        Object[] objectArray;
        boolean bl = this.mProxVarList.getModel().getSize() > 1;
        bl = bl && this.mRowsVarList.getModel().getSize() > 0;
        bl = bl && this.mColumnsVarList.getModel().getSize() > 0;
        this.enableOkPaste(bl);
        if (listDataEvent.getSource() == this.mProxVarList.getModel() && (objectArray = (dialogDataModel = this.getDialogDataModel()).getArray("SelectedList")) != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            VarListModel varListModel = this.mProxVarList.getModel();
            int n = varListModel.getSize();
            for (int i = 0; i < n; ++i) {
                arrayList.add(varListModel.getElementAt(i).getName());
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Object object : objectArray) {
                if (!arrayList.contains(object.toString())) continue;
                arrayList2.add((String)object);
            }
            Object[] objectArray2 = new String[arrayList2.size()];
            dialogDataModel.putArray("SelectedList", arrayList2.toArray(objectArray2));
            if (objectArray2.length == 0) {
                dialogDataModel.putBoolean("IDS_PROXSCAL_PLOTS_COMMON_SPACE_CHECKBOX", null);
                dialogDataModel.putBoolean("IDS_PROXSCAL_PLOTS_ORIGINAL_CHECKBOX", null);
                dialogDataModel.putBoolean("IDS_PROXSCAL_PLOTS_TRANSFORMED_PROXIMITIES_CHECKBOX", null);
                dialogDataModel.putBoolean("IDS_PROXSCAL_PLOTS_ALL_SOURCES_RADIOBUTTON", true);
                dialogDataModel.putBoolean("IDS_PROXSCAL_PLOTS_SELECT_SOURCES_RADIOBUTTON", null);
            }
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        boolean bl = this.mProxVarList.getModel().getSize() > 1;
        bl = bl && this.mRowsVarList.getModel().getSize() > 0;
        bl = bl && this.mColumnsVarList.getModel().getSize() > 0;
        this.enableOkPaste(bl);
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("PROXSCAL"));
        String string = this.mProxVarList.getVariablesStringList();
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES=")).append(string).append("\n");
        string = this.mRowsVarList.getVariablesStringList();
        stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("TABLE", string, false));
        string = this.mColumnsVarList.getVariablesStringList();
        stringBuffer.append(" BY ").append(string);
        stringBuffer.append("\n");
        string = this.mWeightsVarList.getVariablesStringList();
        if (string != null && !string.equals("")) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("WEIGHTS", string));
        }
        stringBuffer.append(ProximitiesUtils.generateInitialSyntax(dialogDataModel));
        Boolean bl = dialogDataModel.getBoolean("IDS_PROXSCAL_ALL_SRC_SIMUL");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("CONDITION", "UNCONDITIONAL"));
        } else {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("CONDITION", "MATRIX"));
        }
        stringBuffer.append(ProximitiesUtils.generateTransformationSyntax(dialogDataModel));
        bl = dialogDataModel.getBoolean("IDS_PROXSCAL_SIMILARITIES");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("PROXIMITIES", "SIMILARITIES"));
        } else {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("PROXIMITIES", "DISSIMILARITIES"));
        }
        stringBuffer.append(ProximitiesUtils.generateModelSyntax(dialogDataModel));
        stringBuffer.append(ProximitiesUtils.generateRestrictionSyntax(dialogDataModel));
        ProximitiesUtils.appendAccelerationSyntax(stringBuffer, dialogDataModel);
        stringBuffer.append(ProximitiesUtils.generateCriteriaSyntax(dialogDataModel));
        stringBuffer.append(ProximitiesUtils.generatePrintSyntax(dialogDataModel));
        stringBuffer.append(ProximitiesUtils.generateOutfileSyntax(dialogDataModel));
        stringBuffer.append(ProximitiesUtils.generatePlotsSyntax(dialogDataModel));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(ProximitiesUtils.generatePerAttributesSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prxc";
    }

    @Override
    public String getIActionKey() {
        return "analyze_scale_mult_matr_prox_in_cols";
    }

    @Override
    public boolean okPastePressed() {
        int n;
        Object[] objectArray;
        Object object;
        if (this.mWeightsVarList.getModel().getSize() > 0 && this.mWeightsVarList.getModel().getSize() != this.mProxVarList.getModel().getSize()) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_PROXSCAL_WEIGHTS_VAR_WARNING"), VersionInfo.getAppVersionString());
            return false;
        }
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_PROXSCAL_CUSTOM");
        if (bl != null && bl.booleanValue()) {
            object = dialogDataModel.getString("MAX_TEXT");
            objectArray = dialogDataModel.getArray("SELECTED_FILE");
            n = objectArray == null ? 0 : objectArray.length;
            Object object2 = object = object == null ? "2" : object;
            if (Integer.parseInt((String)object) != n) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DIMENSION_MATCH_WARNING"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        if ((object = dialogDataModel.getBoolean("IDS_PROXSCAL_RESTRICTION_SOME_COORDINATES_RADIOBUTTON")) != null && ((Boolean)object).booleanValue() && (objectArray = dialogDataModel.getArray("targetIdentifier")) != null) {
            n = objectArray.length;
            String string = dialogDataModel.getString("MAX_TEXT");
            String string2 = string = string == null ? "2" : string;
            if (Integer.parseInt(string) != n) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DIMENSION_MATCH_WARNING"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        return super.okPastePressed();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected boolean validateDialogDataModel(boolean bl) {
        super.validateDialogDataModel(bl);
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ProximitiesUtils.validateRestrictionSubDialogModel(dialogDataModel);
        ProximitiesUtils.validateOptionsSubDialogModel(dialogDataModel);
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(PROX_VAR_LIST);
        Object[] objectArray = dialogDataModel.getArray("SelectedList");
        if (iSpssVariableArray != null && objectArray != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                for (Object object : objectArray) {
                    if (!object.equals(iSpssVariable.getName())) continue;
                    arrayList.add((String)object);
                }
            }
            String[] stringArray = new String[arrayList.size()];
            dialogDataModel.putArray("SelectedList", arrayList.toArray(stringArray));
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    protected void initVars() {
        this.mGatingDialogModel = new DialogDataModel();
        ProcedureDlgMgr.getMgr().loadPersistentState("analyze_scale_mult_proxscal", this.mGatingDialogModel);
        Boolean bl = this.mGatingDialogModel.getBoolean("IDS_PROXSCAL_MULTIPLE_MATRIX_SOURCES");
        if (bl == null) {
            this.mGatingDialogModel.putBoolean("IDS_PROXSCAL_ONE_MATRIX_SOURCE", false);
            this.mGatingDialogModel.putBoolean("IDS_PROXSCAL_MULTIPLE_MATRIX_SOURCES", true);
            this.mGatingDialogModel.putBoolean("IDS_PROXSCAL_DATA_ARE_PROXIMITIES", true);
            this.mGatingDialogModel.putBoolean("IDS_PROXSCAL_CREATE_PROXIMITIES_FROM_DATA", false);
            this.mGatingDialogModel.putInteger("MULTIPLE_SOURCE_LIST_INDEX", 1);
        }
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, false);
        this.mSrcVarList.addVarFilter(spssVarFilter);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.setSelectedIndex(0);
        this.mProxVarList = new TargetVariableList();
        this.mProxVarList.getModel().addListDataListener(this);
        this.mProxVarList.setIdentifier(PROX_VAR_LIST);
        this.mProxVarList.addVarFilter(spssVarFilter);
        this.mProxListScrollPane = new JScrollPane(this.mProxVarList);
        this.mProxVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mProxVarList.getFixedCellHeight() * 2 + 2));
        this.mProxListScrollPane.setPreferredSize(this.mProxVarList.getMinimumSize());
        this.mRowsVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mRowsVarList.getModel().addListDataListener(this);
        this.mRowsVarList.setIdentifier(ROWS_VAR_LIST);
        this.mRowsVarList.addVarFilter(spssVarFilter);
        this.mRowsListScrollPane = new JScrollPane(this.mRowsVarList);
        this.mRowsListScrollPane.setPreferredSize(this.mRowsVarList.getMinimumSize());
        this.mRowsListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mRowsListScrollPane.setVerticalScrollBarPolicy(21);
        this.mColumnsVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mColumnsVarList.getModel().addListDataListener(this);
        this.mColumnsVarList.setIdentifier(COLS_VAR_LIST);
        this.mColumnsVarList.addVarFilter(spssVarFilter);
        this.mColumnsListScrollPane = new JScrollPane(this.mColumnsVarList);
        this.mColumnsListScrollPane.setPreferredSize(this.mColumnsVarList.getMinimumSize());
        this.mColumnsListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mColumnsListScrollPane.setVerticalScrollBarPolicy(21);
        this.mWeightsVarList = new TargetVariableList();
        this.mWeightsVarList.setIdentifier(WEIGHTS_VAR_LIST);
        this.mWeightsVarList.addVarFilter(spssVarFilter);
        this.mWeightsListScrollPane = new JScrollPane(this.mWeightsVarList);
        this.mWeightsVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mWeightsVarList.getFixedCellHeight() * 2 + 2));
        this.mWeightsListScrollPane.setPreferredSize(this.mWeightsVarList.getMinimumSize());
        this.mProxListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mProxListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mProxListArrow.registerVariableList(this.mProxVarList, SpssArrowButton.ButtonOrientation.left);
        this.mRowsListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRowsListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsListArrow.registerVariableList(this.mRowsVarList, SpssArrowButton.ButtonOrientation.left);
        this.mColumnsListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mColumnsListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mColumnsListArrow.registerVariableList(this.mColumnsVarList, SpssArrowButton.ButtonOrientation.left);
        this.mWeightsListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mWeightsListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mWeightsListArrow.registerVariableList(this.mWeightsVarList, SpssArrowButton.ButtonOrientation.left);
        this.mListButton = new ListTravArrowButtonFactory(this.mWeightsVarList, false);
    }

    protected void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mProxVarList.removeAll();
        this.mRowsVarList.removeAll();
        this.mColumnsVarList.removeAll();
        this.mWeightsVarList.removeAll();
        this.enableOkPaste(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(MODEL_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProximitiesInColumnsDlg.this.runModelSubDlg();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(RESTRICTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProximitiesInColumnsDlg.this.runRestrictionsSubDlg();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProximitiesInColumnsDlg.this.runOptionsSubDlg();
            }
        };
        JButton jButton3 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton3);
        toggleButtonAction = new ToggleButtonAction(PLOTS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProximitiesInColumnsDlg.this.runPlotsSubDlg();
            }
        };
        JButton jButton4 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton4);
        toggleButtonAction = new ToggleButtonAction(OUTPUT_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProximitiesInColumnsDlg.this.runOutputSubDlg();
            }
        };
        JButton jButton5 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton5);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mProxListArrow);
        vector.add(this.mRowsListArrow);
        vector.add(this.mColumnsListArrow);
        vector.add(this.mWeightsListArrow);
        vector.add(this.mProxVarList);
        vector.add(this.mRowsVarList);
        vector.add(this.mColumnsVarList);
        vector.add(this.mWeightsVarList);
        vector.add(this.mListButton.getUpArrowButton());
        vector.add(this.mListButton.getDownArrowButton());
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        ListFocusTraversalPolicy listFocusTraversalPolicy = new ListFocusTraversalPolicy(new ListTravArrowButtonFactory[]{this.mListButton}, vector, false);
        this.setFocusTraversalPolicy(listFocusTraversalPolicy);
    }

    private void setupViewPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PROXSCAL_PROXIMITIES");
        jLabel.setLabelFor(this.mProxVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_PROXSCAL_ROWS");
        jLabel2.setLabelFor(this.mRowsVarList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_PROXSCAL_COLUMNS");
        jLabel3.setLabelFor(this.mColumnsVarList);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_PROXSCAL_WEIGHTS");
        jLabel4.setLabelFor(this.mWeightsVarList);
        JPanel jPanel2 = this.mListButton.getArrowButtonPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel5 = DialogUtil.createLabel(this, "IDS_PROXSCAL_PROXIMITIES_IN_COLUMNS_SOURCE_LABEL");
        jLabel5.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel5, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 9, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mProxListArrow, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mProxListScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRowsListArrow, gridBagConstraints, 1, 2, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        Insets insets3 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mRowsListScrollPane, gridBagConstraints, 2, 3, 1, 1, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mColumnsListArrow, gridBagConstraints, 1, 4, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 4, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mColumnsListScrollPane, gridBagConstraints, 2, 5, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mWeightsListArrow, gridBagConstraints, 1, 9, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 8, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mWeightsListScrollPane, gridBagConstraints, 2, 9, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 3, 9, 1, 1, n, null);
    }

    private void runModelSubDlg() {
        this.runSubDialog(new ProximitiesModel(this));
    }

    private void runRestrictionsSubDlg() {
        this.runSubDialog(new ProximitiesRestrictions(this, this.getResString("IDS_PROXSCAL_RESTRICTION_TITLE"), true));
    }

    private void runPlotsSubDlg() {
        this.runSubDialog(new ProximitiesPlots2(this, this.getResString("IDS_PROXSCAL_PLOTS_DIALOG_TITLE"), true));
    }

    private void runOutputSubDlg() {
        this.runSubDialog(new ProximitiesOutput(this));
    }

    private void runOptionsSubDlg() {
        ProximitiesOptions proximitiesOptions = new ProximitiesOptions(this);
        this.runSubDialog(proximitiesOptions);
    }
}

