/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.proxscal;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.UtilityProxy;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.scale.alscal.MultidimensionalMeasure;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesModel;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesOptions;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesOutput;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesPlots1;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesRestrictions;
import com.spss.java_client.ui.dialogs.market_research.proxscal.ProximitiesUtils;
import com.spss.java_client.ui.dialogs.market_research.res.MarketResearchResBundle;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ProximitiesCreateFromDataDlg
extends BaseProcedureDialog
implements ListDataListener {
    static final String VARIABLES_LIST = "IDS_VARIABLES_LIST";
    static final String ROWS_VAR_LIST = "IDS_ROWS_VAR_LIST";
    static final String SOURCES_VAR_LIST = "IDS_SOURCES_VAR_LIST";
    static final String WEIGHTS_VAR_LIST = "IDS_WEIGHTS_VAR_LIST";
    static final String WLSWEIGHT_LIST = "IDS_WLSWEIGHT_LIST";
    static final String MODEL_BUTTON = "IDS_COMMON_MODEL_BUTTON";
    static final String RESTRICTIONS_BUTTON = "IDS_COMMON_RESTRICT_BUTTON";
    static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    static final String PLOTS_BUTTON = "IDS_COMMON_PLOTS_BUTTON";
    static final String OUTPUT_BUTTON = "IDS_COMMON_OUTPUT_BUTTON";
    static final String MEASURE_BUTTON = "IDS_PROXSCAL_MEASURE_3DOTS";
    DialogDataModel mGatingDialogModel;
    private ArrowButton mVariablesArrow;
    private ArrowButton mSourcesListArrow;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mVariablesList;
    private TargetVariableList mSourcesVarList;
    private JLabel mSourcesVarListLabel;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mVariablesScrollPane;
    private JScrollPane mSourcesListScrollPane;
    private JButton mMeasureButton;
    private JLabel mMeasureLabel;
    private JLabel mCreateDistLabel;
    private ProximitiesOptions mOptionsDialog;
    private int mMaxLabelWidth;

    public ProximitiesCreateFromDataDlg(JFrame jFrame) {
        super(jFrame, false, MarketResearchResBundle.getDefaultResourceBundleName(), MarketResearchResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_PROXSCAL_CREATE_PROXIMITIES_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPasteButtons();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPasteButtons();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPasteButtons();
    }

    public void setMeasureLabel(String string) {
        this.mMeasureLabel.setText(string);
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public String generateSyntax() {
        boolean bl;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string = this.mSourcesVarList.getVariablesStringList();
        if (string != null && !string.equals("") && this.mSourcesVarList.isEnabled()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("SORT CASES BY "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("SPLIT FILE BY "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getCommand("PROXIMITIES", false));
        String string2 = this.mVariablesList.getVariablesStringList();
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(string2));
        stringBuffer.append("\n" + SyntaxUtil.getSingleParameterSubCommand("PRINT", "NONE", false));
        stringBuffer.append("\n" + SyntaxUtil.getSingleParameterSubCommand("MATRIX", "OUT(" + CharacterUtil.smartQuote((String)(UtilityProxy.getUtilProxy().getServerTemporaryPath() + "spssprxs.tmp")) + ")"));
        stringBuffer.append(this.generateMeasureSyntax());
        if (string != null && !string.equals("") && this.mSourcesVarList.isEnabled()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("SPLIT FILE OFF"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getCommand("PROXSCAL"));
        stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("MATRIX", "IN(" + CharacterUtil.smartQuote((String)(UtilityProxy.getUtilProxy().getServerTemporaryPath() + "spssprxs.tmp")) + ")", true));
        if (string != null && !string.equals("") && this.mSourcesVarList.isEnabled()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("TABLE", string));
        }
        stringBuffer.append(ProximitiesUtils.generateInitialSyntax(dialogDataModel));
        Boolean bl2 = dialogDataModel.getBoolean("IDS_PROXSCAL_ALL_SRC_SIMUL");
        Boolean bl3 = this.mGatingDialogModel.getBoolean("IDS_PROXSCAL_ONE_MATRIX_SOURCE");
        boolean bl4 = bl = bl3 != null ? bl3 : false;
        if (bl3 != null) {
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("CONDITION", "UNCONDITIONAL"));
            } else if (!bl) {
                stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("CONDITION", "MATRIX"));
            }
        }
        stringBuffer.append(ProximitiesUtils.generateTransformationSyntax(dialogDataModel));
        if (!bl) {
            stringBuffer.append(ProximitiesUtils.generateModelSyntax(dialogDataModel));
        }
        stringBuffer.append(ProximitiesUtils.generateRestrictionSyntax(dialogDataModel));
        ProximitiesUtils.appendAccelerationSyntax(stringBuffer, dialogDataModel);
        stringBuffer.append(ProximitiesUtils.generateCriteriaSyntax(dialogDataModel));
        stringBuffer.append(ProximitiesUtils.generatePrintSyntax(dialogDataModel));
        stringBuffer.append(ProximitiesUtils.generateOutfileSyntax(dialogDataModel));
        stringBuffer.append(ProximitiesUtils.generatePlotsSyntax(dialogDataModel));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("ERASE "));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("FILE=" + CharacterUtil.smartQuote((String)(UtilityProxy.getUtilProxy().getServerTemporaryPath() + "spssprxs.tmp"))));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(ProximitiesUtils.generatePerAttributesSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prxd";
    }

    @Override
    public String getIActionKey() {
        return "analyze_scale_create_prox_from_data";
    }

    @Override
    public boolean okPastePressed() {
        int n;
        Object[] objectArray;
        Object object;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_PROXSCAL_CUSTOM");
        if (bl != null && bl.booleanValue()) {
            object = dialogDataModel.getString("MAX_TEXT");
            objectArray = dialogDataModel.getArray("SELECTED_FILE");
            n = objectArray == null ? 0 : objectArray.length;
            Object object2 = object = object == null ? "2" : object;
            if (Integer.parseInt((String)object) != n) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DIMENSION_MATCH_WARNING"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        if ((object = dialogDataModel.getBoolean("IDS_PROXSCAL_RESTRICTION_SOME_COORDINATES_RADIOBUTTON")) != null && ((Boolean)object).booleanValue() && (objectArray = dialogDataModel.getArray("targetIdentifier")) != null) {
            n = objectArray.length;
            String string = dialogDataModel.getString("MAX_TEXT");
            String string2 = string = string == null ? "2" : string;
            if (Integer.parseInt(string) != n) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DIMENSION_MATCH_WARNING"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        return super.okPastePressed();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected boolean validateDialogDataModel(boolean bl) {
        super.validateDialogDataModel(bl);
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ProximitiesUtils.validateRestrictionSubDialogModel(dialogDataModel);
        ProximitiesUtils.validateOptionsSubDialogModel(dialogDataModel);
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void initVars() {
        this.mGatingDialogModel = new DialogDataModel();
        ProcedureDlgMgr.getMgr().loadPersistentState("analyze_scale_mult_proxscal", this.mGatingDialogModel);
        Boolean bl = this.mGatingDialogModel.getBoolean("IDS_PROXSCAL_ONE_MATRIX_SOURCE");
        if (bl == null) {
            this.mGatingDialogModel.putBoolean("IDS_PROXSCAL_DATA_ARE_PROXIMITIES", false);
            this.mGatingDialogModel.putBoolean("IDS_PROXSCAL_CREATE_PROXIMITIES_FROM_DATA", true);
            this.mGatingDialogModel.putBoolean("IDS_PROXSCAL_ONE_MATRIX_SOURCE", true);
            this.mGatingDialogModel.putBoolean("IDS_PROXSCAL_MULTIPLE_MATRIX_SOURCES", false);
        }
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, false);
        this.mSrcVarList.addVarFilter(spssVarFilter);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.setSelectedIndex(0);
        this.mVariablesList = new TargetVariableList();
        this.mVariablesList.getModel().addListDataListener(this);
        this.mVariablesList.setIdentifier(VARIABLES_LIST);
        this.mVariablesList.addVarFilter(spssVarFilter);
        this.mVariablesScrollPane = new JScrollPane(this.mVariablesList);
        this.mVariablesScrollPane.setPreferredSize(this.mVariablesList.getMinimumSize());
        this.mSourcesVarListLabel = DialogUtil.createLabel(this, "IDS_PROXSCAL_SOURCES");
        this.mSourcesVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mSourcesVarList.setIdentifier(SOURCES_VAR_LIST);
        this.mSourcesVarList.addVarFilter(spssVarFilter);
        this.mSourcesVarListLabel.setLabelFor(this.mSourcesVarList);
        this.mSourcesListScrollPane = new JScrollPane(this.mSourcesVarList);
        this.mSourcesListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mSourcesListScrollPane.setVerticalScrollBarPolicy(21);
        this.mSourcesListScrollPane.setPreferredSize(this.mSourcesVarList.getMinimumSize());
        this.mVariablesArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mVariablesArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mVariablesArrow.registerVariableList(this.mVariablesList, SpssArrowButton.ButtonOrientation.left);
        this.mSourcesListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSourcesListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSourcesListArrow.registerVariableList(this.mSourcesVarList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, MEASURE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProximitiesCreateFromDataDlg.this.runMeasureSubDlg();
            }
        };
        this.mMeasureButton = new JButton(toggleButtonAction);
        this.mMeasureLabel = new JLabel(this.getResString("IDS_ALSCAL_EULI_DIS"));
        this.mCreateDistLabel = new JLabel(this.getResString("IDS_PROXSCAL_CREATE_DIST"), 10);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(MODEL_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProximitiesCreateFromDataDlg.this.runModelSubDlg();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(RESTRICTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProximitiesCreateFromDataDlg.this.runRestrictionsSubDlg();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        if (CommandLine.isClementineCaller()) {
            jButton2.setEnabled(false);
        }
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProximitiesCreateFromDataDlg.this.runOptionsSubDlg();
            }
        };
        JButton jButton3 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton3);
        toggleButtonAction = new ToggleButtonAction(PLOTS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProximitiesCreateFromDataDlg.this.runPlotsSubDlg();
            }
        };
        JButton jButton4 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton4);
        toggleButtonAction = new ToggleButtonAction(OUTPUT_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProximitiesCreateFromDataDlg.this.runOutputSubDlg();
            }
        };
        JButton jButton5 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton5);
        return jPanel;
    }

    protected void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mVariablesList.removeAll();
        this.mSourcesVarList.removeAll();
        this.enableOkPaste(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mMeasureLabel.setText(this.getResString("IDS_ALSCAL_EULI_DIS"));
        boolean bl = this.mGatingDialogModel.getBoolean("IDS_PROXSCAL_ONE_MATRIX_SOURCE");
        this.mSourcesVarListLabel.setEnabled(!bl);
        this.mSourcesListArrow.setEnabled(!bl);
        this.mSourcesVarList.setEnabled(!bl);
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mVariablesArrow);
        vector.add(this.mSourcesListArrow);
        vector.add(this.mVariablesList);
        vector.add(this.mSourcesVarList);
        vector.add(this.mMeasureButton);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupViewPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PROXSCAL_VARIABLES");
        jLabel.setLabelFor(this.mVariablesList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_PROXSCAL_CREATE_PROXIMITIES_SOURCE_LABEL");
        jLabel2.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 4, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mVariablesArrow, gridBagConstraints, 1, 1, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mVariablesScrollPane, gridBagConstraints, 2, 1, 1, 2, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mSourcesListArrow, gridBagConstraints, 1, 3, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        Insets insets3 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSourcesVarListLabel, gridBagConstraints, 2, 3, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mSourcesListScrollPane, gridBagConstraints, 2, 4, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.setupMeasurePanel(), gridBagConstraints, 0, 5, 3, 1, n, null);
    }

    private JPanel setupMeasurePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(2 * n, 0, n3, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCreateDistLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2 * n, 3 * n, n3, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMeasureButton, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(2 * n, 3 * n, n3, n3);
        String[] stringArray = new String[]{this.getResString("IDS_PROXSCAL_SQUARED_DIS"), this.getResString("IDS_ALSCAL_BIN_EUCLIDEAN")};
        String[] stringArray2 = this.getResStringArray("IDS_ALSCAL_INTERVAL_COMBO_VALUES");
        String[] stringArray3 = this.getResStringArray("IDS_ALSCAL_COUNTS_COMBO_VALUES");
        String[] stringArray4 = this.getResStringArray("IDS_ALSCAL_BINARY_COMBO_VALUES");
        this.calculateMaxLabelWidth(stringArray, jPanel);
        this.calculateMaxLabelWidth(stringArray2, jPanel);
        this.calculateMaxLabelWidth(stringArray3, jPanel);
        this.calculateMaxLabelWidth(stringArray4, jPanel);
        Dimension dimension = this.mMeasureLabel.getPreferredSize();
        this.mMeasureLabel.setPreferredSize(new Dimension(this.mMaxLabelWidth, dimension.height));
        DialogUtil.addUsingGBL(jPanel, this.mMeasureLabel, gridBagConstraints, 2, 0, 1, 1, n2, insets);
        return jPanel;
    }

    private void calculateMaxLabelWidth(String[] stringArray, JPanel jPanel) {
        Font font = jPanel.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            n = fontMetrics.stringWidth(stringArray[i]);
            if (n <= this.mMaxLabelWidth) continue;
            this.mMaxLabelWidth = n;
        }
    }

    private void enableOkPasteButtons() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_ALSCAL_BETWEEN_CASES");
        if (bl != null && bl.booleanValue()) {
            this.enableOkPaste(this.mVariablesList.getModel().getSize() > 0);
        } else {
            this.enableOkPaste(this.mVariablesList.getModel().getSize() > 2);
        }
    }

    private void runModelSubDlg() {
        this.runSubDialog(new ProximitiesModel(this));
    }

    private void runRestrictionsSubDlg() {
        this.runSubDialog(new ProximitiesRestrictions(this, this.getResString("IDS_PROXSCAL_RESTRICTION_TITLE"), true));
    }

    private void runPlotsSubDlg() {
        this.runSubDialog(new ProximitiesPlots1(this, this.getResString("IDS_PROXSCAL_PLOTS_DIALOG_TITLE"), true));
    }

    private void runOutputSubDlg() {
        this.runSubDialog(new ProximitiesOutput(this));
    }

    private void runOptionsSubDlg() {
        this.mOptionsDialog = new ProximitiesOptions(this);
        this.runSubDialog(this.mOptionsDialog);
    }

    private void runMeasureSubDlg() {
        if (this.runSubDialog(new MultidimensionalMeasure(this, this.getResString("IDS_PROXSCAL_MEASURE_TITLE"), true))) {
            this.enableOkPasteButtons();
        }
    }

    private StringBuffer generateMeasureSyntax() {
        String string;
        Map<Integer, String> map;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "EUCLID";
        Boolean bl = dialogDataModel.getBoolean("IDS_ALSCAL_INTERVAL_DOT");
        if (bl != null && bl.booleanValue()) {
            n = dialogDataModel.getInteger("INTERVAL_ALSCAL_KEy");
            map = MultidimensionalMeasure.getIntervalMap();
            string2 = string = map.get(n).toString().trim();
            int n2 = dialogDataModel.getInteger("POWER_ALSCAL_KEY");
            int n3 = dialogDataModel.getInteger("ROOT_ALSCAL_KEY");
            if (n == 5) {
                string2 = string + "(" + (n2 + 1) + "," + (n3 + 1) + ")";
            }
            if (n == 4) {
                string2 = string + "(" + (n2 + 1) + ")";
            }
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_COUNTS")) != null && bl.booleanValue()) {
            n = dialogDataModel.getInteger("COUNT_ALSCAL_KEY");
            map = MultidimensionalMeasure.getCountMap();
            string2 = map.get(n).toString().trim();
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_BINARY")) != null && bl.booleanValue()) {
            n = dialogDataModel.getInteger("BINARY_ALSCAL_KEY");
            map = MultidimensionalMeasure.getBinMap();
            string = map.get(n).toString().trim();
            string2 = string + " (" + dialogDataModel.getString("IDS_ALSCAL_PRESENT1661") + "," + dialogDataModel.getString("IDS_ALSCAL_ABESNT2266") + ")";
        }
        stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("MEASURE", string2));
        Boolean bl2 = dialogDataModel.getBoolean("IDS_ALSCAL_INTERVAL_DOT");
        Boolean bl3 = dialogDataModel.getBoolean("IDS_ALSCAL_BINARY");
        Boolean bl4 = dialogDataModel.getBoolean("IDS_ALSCAL_COUNTS");
        if (bl2 != null && bl2.booleanValue() || bl4 != null && bl4.booleanValue()) {
            bl = dialogDataModel.getBoolean("IDS_ALSCAL_BY_CASE");
            String string3 = "";
            if (bl != null && bl.booleanValue()) {
                string3 = "CASE";
            }
            if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_BY_VARIABLE")) != null && bl.booleanValue()) {
                string3 = "VARIABLE";
            }
            n = dialogDataModel.getInteger("STD_ALSCAL_KEY");
            map = MultidimensionalMeasure.getStdMap();
            String string4 = map.get(n).toString();
            if (!string4.trim().equals("NONE")) {
                string4 = string3 + string4;
            }
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("STANDARDIZE", string4));
        } else if (bl3 == null || !bl3.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("STANDARDIZE", "NONE"));
        }
        bl = dialogDataModel.getBoolean("IDS_ALSCAL_BETWEEN_VAR");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("VIEW", "VARIABLE", false));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_BETWEEN_CASES")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("VIEW", "CASE", false));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer;
    }
}

