/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.prefscal;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.MultidimensionalPlots;
import com.spss.java_client.ui.dialogs.market_research.prefscal.MultidimensionalUnfoldDlg;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class MultidimensionalUnfoldPlots
extends BaseSubDialog
implements ItemListener {
    static String MULTI_UNFOLD_PLOT_MULTIPLE_START = "IDS_MULTI_UNFOLD_PLOT_MULTIPLE_START";
    static String MULTI_UNFOLD_PLOT_CMN_SPACE = "IDS_MULTI_UNFOLD_PLOT_CMN_SPACE";
    static String MULTI_UNFOLD_PLOT_STRESS_DIMENSION = "IDS_MULTI_UNFOLD_PLOT_STRESS_DIMENSION";
    static String MULTI_UNFOLD_PLOT_FINAL_SPACE = "IDS_MULTI_UNFOLD_PLOT_FINAL_SPACE";
    static String MULTI_UNFOLD_PLOT_SPACE_WT = "IDS_MULTI_UNFOLD_PLOT_SPACE_WT";
    static String MULTI_UNFOLD_PLOT_IND_SPACE = "IDS_MULTI_UNFOLD_PLOT_IND_SPACE";
    static String MULTI_UNFOLD_PLOT_TRANS_PLOT = "IDS_MULTI_UNFOLD_PLOT_TRANS_PLOT";
    static String MULTI_UNFOLD_PLOT_SHEPARD = "IDS_MULTI_UNFOLD_PLOT_SHEPARD";
    static String MULTI_UNFOLD_PLOT_SCATTER = "IDS_MULTI_UNFOLD_PLOT_SCATTER";
    static String MULTI_UNFOLD_PLOT_RESIDUAL = "IDS_MULTI_UNFOLD_PLOT_RESIDUAL";
    static String MULTI_UNFOLD_PLOT_SRC_LIST = "IDS_MULTI_UNFOLD_PLOT_SRC_LIST";
    static String MULTI_UNFOLD_PLOT_TARGET_COLOR_LIST = "IDS_MULTI_UNFOLD_PLOT_TARGET_COLOR_LIST";
    static String MULTI_UNFOLD_PLOT_TARGET_MARKER_LIST = "IDS_MULTI_UNFOLD_PLOT_TARGET_MARKER_LIST";
    static String MULTI_UNFOLD_PLOT_ALL_RADIO_SRC = "IDS_MULTI_UNFOLD_PLOT_ALL_RADIO_SRC";
    static String MULTI_UNFOLD_PLOT_SELECT_RADIO_SRC = "IDS_MULTI_UNFOLD_PLOT_SELECT_RADIO_SRC";
    static String MULTI_UNFOLD_PLOT_LST_SRC = "IDS_MULTI_UNFOLD_PLOT_LST_SRC";
    static String MULTI_UNFOLD_PLOT_ALL_RADIO_ROW = "IDS_MULTI_UNFOLD_PLOT_ALL_RADIO_ROW";
    static String MULTI_UNFOLD_PLOT_SELECT_RADIO_ROW = "IDS_MULTI_UNFOLD_PLOT_SELECT_RADIO_ROW";
    static String MULTI_UNFOLD_PLOT_LST_ROW = "IDS_MULTI_UNFOLD_PLOT_LST_ROW";
    static String MULTI_UNFOLD_PLOT_SRC_LIST_ID = "IDS_MULTI_UNFOLD_PLOT_SRC_LIST_ID";
    static String MULTI_UNFOLD_PLOT_ROW_LIST_ID = "IDS_MULTI_UNFOLD_PLOT_ROW_LIST_ID";
    private static String MULTI_UNFOLD_PLOT_PNL_NAME_ROW = "IDS_MULTI_UNFOLD_PLOT_PNL_NAME_ROW";
    private static String MULTI_UNFOLD_PLOT_NUMBER_LABEL_ROW = "IDS_MULTI_UNFOLD_PLOT_NUMBER_LABEL_ROW";
    private static String MULTI_UNFOLD_PLOT_PNL_NAME_SRC = "IDS_MULTI_UNFOLD_PLOT_PNL_NAME_SRC";
    private static String MULTI_UNFOLD_PLOT_NUMBER_LABEL_SRC = "IDS_MULTI_UNFOLD_PLOT_NUMBER_LABEL_SRC";
    private MultidimensionalPlots mSourcePlot;
    private MultidimensionalPlots mRowPlot;
    private JCheckBox mMultiStartCheck;
    private JCheckBox mIniCmnSpcCheck;
    private JCheckBox mStressPerDimenCheck;
    private JCheckBox mFinalCmnSpcCheck;
    private JCheckBox mSpcWtCheck;
    private JCheckBox mIndividualSpcCheck;
    private JCheckBox mTransPlotCheck;
    private JCheckBox mShepardCheck;
    private JCheckBox mScatterCheck;
    private JCheckBox mResidualCheck;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetColorList;
    private TargetVariableList mTargetMarkerList;
    private JScrollPane mSrcLstScrollPane;
    private ArrowButton mColorArrowButton;
    private ArrowButton mMarkerArrowButton;

    public MultidimensionalUnfoldPlots(MultidimensionalUnfoldDlg multidimensionalUnfoldDlg) {
        super(multidimensionalUnfoldDlg, multidimensionalUnfoldDlg.getResString("IDS_MULTI_DIMENSION_UNFOLD_PLOT_TITLE"), true);
    }

    @Override
    public boolean continuePressed() {
        this.mSourcePlot.clearNumberTextField();
        this.mRowPlot.clearNumberTextField();
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prfb_plots";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mIndividualSpcCheck || object == this.mScatterCheck || object == this.mResidualCheck) {
            if (this.shouldTurnOnSourcePlotPanel() || this.shouldCondTurnOnSrcPlotPanel()) {
                this.mSourcePlot.setEnabled(true);
            } else {
                this.mSourcePlot.setEnabled(false);
            }
        } else if (object == this.mTransPlotCheck || object == this.mShepardCheck) {
            if (this.shouldTurnOnRowPlotPanel()) {
                this.mRowPlot.setEnabled(true);
            } else {
                this.mRowPlot.setEnabled(false);
            }
            if (this.shouldCondTurnOnSrcPlotPanel() || this.shouldTurnOnSourcePlotPanel()) {
                this.mSourcePlot.setEnabled(true);
            } else {
                this.mSourcePlot.setEnabled(false);
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponentToViewPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_PLOT_MULTIPLE_START);
        this.mMultiStartCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_PLOT_CMN_SPACE);
        this.mIniCmnSpcCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_PLOT_STRESS_DIMENSION);
        this.mStressPerDimenCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_PLOT_FINAL_SPACE);
        this.mFinalCmnSpcCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_PLOT_SPACE_WT);
        this.mSpcWtCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_PLOT_IND_SPACE);
        this.mIndividualSpcCheck = new JCheckBox(toggleButtonAction);
        this.mIndividualSpcCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_PLOT_TRANS_PLOT);
        this.mTransPlotCheck = new JCheckBox(toggleButtonAction);
        this.mTransPlotCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_PLOT_SHEPARD);
        this.mShepardCheck = new JCheckBox(toggleButtonAction);
        this.mShepardCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_PLOT_SCATTER);
        this.mScatterCheck = new JCheckBox(toggleButtonAction);
        this.mScatterCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_PLOT_RESIDUAL);
        this.mResidualCheck = new JCheckBox(toggleButtonAction);
        this.mResidualCheck.addItemListener(this);
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mSrcVarList.setIdentifier(MULTI_UNFOLD_PLOT_SRC_LIST);
        this.mSrcVarList.setMinimumSize(new Dimension(DialogUtil.getVarListHeight(), DialogUtil.getVarListHeight() / 2));
        this.mSrcVarList.setShowIcon(false);
        this.mSrcLstScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcLstScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTargetColorList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetColorList.setIdentifier(MULTI_UNFOLD_PLOT_TARGET_COLOR_LIST);
        this.mTargetColorList.setShowIcon(false);
        this.mColorArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mColorArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mColorArrowButton.registerVariableList(this.mTargetColorList, SpssArrowButton.ButtonOrientation.left);
        this.mTargetMarkerList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetMarkerList.setIdentifier(MULTI_UNFOLD_PLOT_TARGET_MARKER_LIST);
        this.mTargetMarkerList.setShowIcon(false);
        this.mMarkerArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mMarkerArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mMarkerArrowButton.registerVariableList(this.mTargetMarkerList, SpssArrowButton.ButtonOrientation.left);
        String[] stringArray = new String[]{MULTI_UNFOLD_PLOT_ALL_RADIO_SRC, MULTI_UNFOLD_PLOT_SELECT_RADIO_SRC, MULTI_UNFOLD_PLOT_NUMBER_LABEL_SRC, MULTI_UNFOLD_PLOT_LST_SRC, MULTI_UNFOLD_PLOT_PNL_NAME_SRC};
        this.mSourcePlot = new MultidimensionalPlots(stringArray, this);
        this.mSourcePlot.getACRWidget().getList().setActionKey(MULTI_UNFOLD_PLOT_SRC_LIST_ID);
        String[] stringArray2 = new String[]{MULTI_UNFOLD_PLOT_ALL_RADIO_ROW, MULTI_UNFOLD_PLOT_SELECT_RADIO_ROW, MULTI_UNFOLD_PLOT_NUMBER_LABEL_ROW, MULTI_UNFOLD_PLOT_LST_ROW, MULTI_UNFOLD_PLOT_PNL_NAME_ROW};
        this.mRowPlot = new MultidimensionalPlots(stringArray2, this);
        this.mRowPlot.getACRWidget().getList().setActionKey(MULTI_UNFOLD_PLOT_ROW_LIST_ID);
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mFinalCmnSpcCheck.setSelected(true);
        this.mSpcWtCheck.setSelected(true);
        this.mSourcePlot.setEnabled(false);
        this.mRowPlot.setEnabled(false);
        DialogDataModel dialogDataModel = ((MultidimensionalUnfoldDlg)((Object)this.getParent())).getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_OPT_RANDOM");
        if (bl != null && bl.booleanValue()) {
            this.mMultiStartCheck.setEnabled(true);
        } else {
            this.mMultiStartCheck.setEnabled(false);
        }
        bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_IDENTITY");
        if (bl == null) {
            this.mSpcWtCheck.setEnabled(false);
            this.mIndividualSpcCheck.setEnabled(false);
        } else if (bl.booleanValue()) {
            this.mSpcWtCheck.setEnabled(false);
            this.mIndividualSpcCheck.setEnabled(false);
        } else {
            this.mSpcWtCheck.setEnabled(true);
            this.mIndividualSpcCheck.setEnabled(true);
        }
        String string = dialogDataModel.getString("IDS_MAX_TEXT");
        String string2 = dialogDataModel.getString("IDS_MIN_TEXT");
        if (bl != null) {
            if (string.equals(string2)) {
                this.mStressPerDimenCheck.setEnabled(false);
            } else {
                this.mStressPerDimenCheck.setEnabled(true);
            }
        } else {
            this.mStressPerDimenCheck.setEnabled(false);
        }
    }

    private void addComponentToViewPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap() / 2, 0, 0, 0);
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupPlotsPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel3 = this.setupColorMarkerPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel4 = this.mSourcePlot.setupSourcePlotsPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel4);
        JPanel jPanel5 = this.mRowPlot.setupSourcePlotsPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel5);
    }

    private JPanel setupPlotsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mMultiStartCheck, this.mIniCmnSpcCheck, this.mStressPerDimenCheck, new JLabel(" "), this.mFinalCmnSpcCheck, this.mSpcWtCheck, this.mIndividualSpcCheck, new JLabel(" "), this.mTransPlotCheck, this.mShepardCheck, this.mScatterCheck, this.mResidualCheck};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_MULTI_DIMENSION_UNFOLD_PLOT"), 4);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupColorMarkerPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_MULTI_DIMENSION_UNFOLD_COLORS")));
        int n = DialogUtil.getComponentGroupGap();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_MULTI_DIMENSION_UNFOLD_PLOT_SOURCE_LIST_LABEL");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n2 = 23;
        Insets insets = new Insets(0, n, n, 0);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcLstScrollPane, gridBagConstraints, 0, 1, 1, 4, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n2 = 20;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        insets = new Insets(0, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mColorArrowButton, gridBagConstraints, 1, 0, 1, 2, n2, insets);
        insets = new Insets(17, insets2.left, n, insets2.right);
        n2 = 19;
        DialogUtil.addUsingGBL(jPanel, this.mMarkerArrowButton, gridBagConstraints, 1, 3, 1, 2, n2, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_PLOT_COLOR");
        jLabel2.setLabelFor(this.mTargetColorList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n2 = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n2, null);
        JScrollPane jScrollPane = new JScrollPane(this.mTargetColorList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mTargetColorList.getMinimumSize());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n2 = 23;
        gridBagConstraints.fill = 2;
        insets = new Insets(0, 0, 0, n);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n2, insets);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_PLOT_MARKER");
        jLabel3.setLabelFor(this.mTargetMarkerList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n2 = 23;
        gridBagConstraints.fill = 2;
        insets = new Insets(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 3, 1, 1, n2, insets);
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetMarkerList);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.setPreferredSize(this.mTargetMarkerList.getMinimumSize());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n2 = 23;
        gridBagConstraints.fill = 2;
        insets = new Insets(0, 0, n, n);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 4, 1, 1, n2, insets);
        return jPanel;
    }

    private boolean shouldTurnOnSourcePlotPanel() {
        boolean bl = false;
        MultidimensionalUnfoldDlg multidimensionalUnfoldDlg = (MultidimensionalUnfoldDlg)this.mParentDlg;
        if (multidimensionalUnfoldDlg.getSrcTargetListCount() > 0 || multidimensionalUnfoldDlg.getRowsTargetListCount() > 0) {
            bl = true;
        }
        return (this.mScatterCheck.isSelected() || this.mResidualCheck.isSelected() || this.mIndividualSpcCheck.isEnabled() && this.mIndividualSpcCheck.isSelected()) && bl;
    }

    private boolean shouldTurnOnRowPlotPanel() {
        boolean bl = false;
        MultidimensionalUnfoldDlg multidimensionalUnfoldDlg = (MultidimensionalUnfoldDlg)this.mParentDlg;
        DialogDataModel dialogDataModel = multidimensionalUnfoldDlg.getDialogDataModel();
        Boolean bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_WITH_ROW");
        if (bl2 == null) {
            bl = true;
        } else if (bl2 != null && bl2.booleanValue()) {
            bl = true;
        }
        return bl && (this.mTransPlotCheck.isSelected() || this.mShepardCheck.isSelected());
    }

    private boolean shouldCondTurnOnSrcPlotPanel() {
        boolean bl = false;
        MultidimensionalUnfoldDlg multidimensionalUnfoldDlg = (MultidimensionalUnfoldDlg)this.mParentDlg;
        DialogDataModel dialogDataModel = multidimensionalUnfoldDlg.getDialogDataModel();
        Boolean bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_WITH_SRC");
        if ((multidimensionalUnfoldDlg.getSrcTargetListCount() > 0 || multidimensionalUnfoldDlg.getRowsTargetListCount() > 0) && bl2 != null && bl2.booleanValue()) {
            bl = true;
        }
        return bl && (this.mTransPlotCheck.isSelected() || this.mShepardCheck.isSelected());
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMultiStartCheck);
        vector.add(this.mIniCmnSpcCheck);
        vector.add(this.mStressPerDimenCheck);
        vector.add(this.mFinalCmnSpcCheck);
        vector.add(this.mSpcWtCheck);
        vector.add(this.mIndividualSpcCheck);
        vector.add(this.mTransPlotCheck);
        vector.add(this.mShepardCheck);
        vector.add(this.mScatterCheck);
        vector.add(this.mResidualCheck);
        vector.add(this.mSrcVarList);
        vector.add(this.mColorArrowButton);
        vector.add(this.mTargetColorList);
        vector.add(this.mMarkerArrowButton);
        vector.add(this.mTargetMarkerList);
        vector.addAll(this.mSourcePlot.getTraversalComponents());
        vector.addAll(this.mRowPlot.getTraversalComponents());
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

