/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.prefscal;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.market_research.MultiDimensionalCommonSavePanel;
import com.spss.java_client.ui.dialogs.market_research.prefscal.MultidimensionalUnfoldDlg;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class MultidimensionalUnfoldOutput
extends BaseSubDialog {
    static final String MULTI_UNFOLD_INPUT_DATA = "IDS_MULTI_UNFOLD_INPUT_DATA";
    static final String MULTI_UNFOLD_MULTI_START = "IDS_MULTI_UNFOLD_MULTI_START";
    static final String MULTI_UNFOLD_INITIAL_DATA = "IDS_MULTI_UNFOLD_INITIAL_DATA";
    static final String MULTI_UNFOLD_ITERATE_HIST = "IDS_MULTI_UNFOLD_ITERATE_HIST";
    static final String MULTI_UNFOLD_FIT_MEASURE = "IDS_MULTI_UNFOLD_FIT_MEASURE";
    static final String MULTI_UNFOLD_STRESS_DECOMP = "IDS_MULTI_UNFOLD_STRESS_DECOMP";
    static final String MULTI_UNFOLD_TRANS_PROX = "IDS_MULTI_UNFOLD_TRANS_PROX";
    static final String MULTI_UNFOLD_FINAL_COMM = "IDS_MULTI_UNFOLD_FINAL_COMM";
    static final String MULTI_UNFOLD_SPACE_WT = "IDS_MULTI_UNFOLD_SPACE_WT";
    static final String MULTI_UNFOLD_INDI_SPACE = "IDS_MULTI_UNFOLD_INDI_SPACE";
    static final String MULTI_UNFOLD_FIT_DIST = "IDS_MULTI_UNFOLD_FIT_DIST";
    static final String MULTI_UNFOLD_COMM_SPACE = "IDS_MULTI_UNFOLD_COMM_SPACE";
    static final String MULTI_UNFOLD_IND_SPACE_WT = "IDS_MULTI_UNFOLD_IND_SPACE_WT";
    static final String MULTI_UNFOLD_DIST = "IDS_MULTI_UNFOLD_DIST";
    static final String MULTI_UNFOLD_TRANS_PROX_SAVE = "IDS_MULTI_UNFOLD_TRANS_PROX_SAVE";
    static final String COMMON_TEXT_FIELD = "IDS_COMMON_TEXT_FIELD";
    static final String SPACE_TEXT_FIELD = "IDS_SPACE_TEXT_FIELD";
    static final String DIST_TEXT_FIELD = "IDS_DIST_TEXT_FIELD";
    static final String TRANS_TEXT_FIELD = "IDS_TRANS_TEXT_FIELD";
    static final String COMMON_DATASET_SELECTION_STATE = "IDS_COMMON_DATASET_SELECTION_STATE";
    static final String SPACE_DATASET_SELECTION_STATE = "IDS_SPACE_DATASET_SELECTION_STATE";
    static final String DIST_DATASET_SELECTION_STATE = "IDS_DIST_DATASET_SELECTION_STATE";
    static final String TRANS_DATASET_SELECTION_STATE = "IDS_TRANS_DATASET_SELECTION_STATE";
    static final String COMMON_DATASETNAME_TEXT_FIELD = "IDS_DATASETNAME_COMMON_TEXT_FIELD";
    static final String SPACE_DATASETNAME_TEXT_FIELD = "IDS_DATASETNAME_SPACE_TEXT_FIELD";
    static final String DIST_DATASETNAME_TEXT_FIELD = "IDS_DATASETNAME_DIST_TEXT_FIELD";
    static final String TRANS_DATASETNAME_TEXT_FIELD = "IDS_DATASETNAME_TRANS_TEXT_FIELD";
    private JCheckBox mInputDataCheck;
    private JCheckBox mMultiStartCheck;
    private JCheckBox mInitialDataCheck;
    private JCheckBox mIterateHistCheck;
    private JCheckBox mFitMeasureCheck;
    private JCheckBox mStressDecompCheck;
    private JCheckBox mTransformProxCheck;
    private JCheckBox mFinalComSpaceCheck;
    private JCheckBox mSpaceWtCheck;
    private JCheckBox mIndividualSpaceCheck;
    private JCheckBox mFitDistCheck;
    private MultiDimensionalCommonSavePanel mSpaceCoordiPanel;
    private MultiDimensionalCommonSavePanel mIndividualSpWtPanel;
    private MultiDimensionalCommonSavePanel mDistancesPanel;
    private MultiDimensionalCommonSavePanel mTransformProxPanel;

    public MultidimensionalUnfoldOutput(MultidimensionalUnfoldDlg multidimensionalUnfoldDlg) {
        super(multidimensionalUnfoldDlg, multidimensionalUnfoldDlg.getResString("IDS_MULTI_DIMENSION_UNFOLD_OUTPUT_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prfa_output";
    }

    public void paint(Graphics graphics) {
        if (this.mSpaceCoordiPanel.getFileText() != null) {
            this.mSpaceCoordiPanel.setFileText(this.mSpaceCoordiPanel.getFileText());
        }
        if (this.mIndividualSpWtPanel.getFileText() != null) {
            this.mIndividualSpWtPanel.setFileText(this.mIndividualSpWtPanel.getFileText());
        }
        if (this.mDistancesPanel.getFileText() != null) {
            this.mDistancesPanel.setFileText(this.mDistancesPanel.getFileText());
        }
        if (this.mTransformProxPanel.getFileText() != null) {
            this.mTransformProxPanel.setFileText(this.mTransformProxPanel.getFileText());
        }
        super.paint(graphics);
        super.validate();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponentToViewPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private String saveFileChooseDialog() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(this.getResString("IDS_MULTI_UNFOLD_SAVE_FILE_CHOOSER_TITLE"));
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_MULTI_UNFOLD_FILE_FILTER"), this.getResString("IDS_MULTI_UNFOLD_FILE_EXTENSION")));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setFileSelectionMode(0);
        int n = remoteFileChooser.showSaveDialog(this.getParent());
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string = remoteFileChooser.getSelectedFilePath();
            if (!string.endsWith(this.getResString("IDS_MULTI_UNFOLD_FILE_EXTENSION"))) {
                string = string + this.getResString("IDS_MULTI_UNFOLD_FILE_EXTENSION");
                return string;
            }
            return string;
        }
        return "";
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_INPUT_DATA);
        this.mInputDataCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_MULTI_START);
        this.mMultiStartCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_INITIAL_DATA);
        this.mInitialDataCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_ITERATE_HIST);
        this.mIterateHistCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_FIT_MEASURE);
        this.mFitMeasureCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_STRESS_DECOMP);
        this.mStressDecompCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_TRANS_PROX);
        this.mTransformProxCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_FINAL_COMM);
        this.mFinalComSpaceCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_SPACE_WT);
        this.mSpaceWtCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_INDI_SPACE);
        this.mIndividualSpaceCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MULTI_UNFOLD_FIT_DIST);
        this.mFitDistCheck = new JCheckBox(toggleButtonAction);
        this.mSpaceCoordiPanel = new MultiDimensionalCommonSavePanel(this, this.getResString(MULTI_UNFOLD_COMM_SPACE), this.getResString("IDS_MULTI_UNFOLD_SAVE_FILE_CHOOSER_TITLE"), this.getResString("IDS_MULTI_UNFOLD_FILE_FILTER"), this.getResString("IDS_MULTI_UNFOLD_FILE_EXTENSION"), MULTI_UNFOLD_COMM_SPACE);
        this.mIndividualSpWtPanel = new MultiDimensionalCommonSavePanel(this, this.getResString(MULTI_UNFOLD_IND_SPACE_WT), this.getResString("IDS_MULTI_UNFOLD_SAVE_FILE_CHOOSER_TITLE"), this.getResString("IDS_MULTI_UNFOLD_FILE_FILTER"), this.getResString("IDS_MULTI_UNFOLD_FILE_EXTENSION"), MULTI_UNFOLD_IND_SPACE_WT);
        this.mDistancesPanel = new MultiDimensionalCommonSavePanel(this, this.getResString(MULTI_UNFOLD_DIST), this.getResString("IDS_MULTI_UNFOLD_SAVE_FILE_CHOOSER_TITLE"), this.getResString("IDS_MULTI_UNFOLD_FILE_FILTER"), this.getResString("IDS_MULTI_UNFOLD_FILE_EXTENSION"), MULTI_UNFOLD_DIST);
        this.mTransformProxPanel = new MultiDimensionalCommonSavePanel(this, this.getResString(MULTI_UNFOLD_TRANS_PROX_SAVE), this.getResString("IDS_MULTI_UNFOLD_SAVE_FILE_CHOOSER_TITLE"), this.getResString("IDS_MULTI_UNFOLD_FILE_FILTER"), this.getResString("IDS_MULTI_UNFOLD_FILE_EXTENSION"), MULTI_UNFOLD_TRANS_PROX_SAVE);
    }

    private void setDefaults() {
        DialogDataModel dialogDataModel = ((MultidimensionalUnfoldDlg)((Object)this.getParent())).getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_OPT_RANDOM");
        if (bl != null && bl.booleanValue()) {
            this.mMultiStartCheck.setEnabled(true);
        } else {
            this.mMultiStartCheck.setEnabled(false);
        }
        bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_IDENTITY");
        if (bl == null) {
            this.mSpaceWtCheck.setEnabled(false);
            this.mIndividualSpaceCheck.setEnabled(false);
            this.mIndividualSpWtPanel.setCreateCheckEnabled(false);
        } else if (bl.booleanValue()) {
            this.mSpaceWtCheck.setEnabled(false);
            this.mIndividualSpaceCheck.setEnabled(false);
            this.mIndividualSpWtPanel.setCreateCheckEnabled(false);
        } else {
            this.mSpaceWtCheck.setEnabled(true);
            this.mIndividualSpaceCheck.setEnabled(true);
            this.mIndividualSpWtPanel.setCreateCheckEnabled(true);
        }
        this.mSpaceCoordiPanel.setFileSelectionEnabled(false);
        this.mIndividualSpWtPanel.setFileSelectionEnabled(false);
        this.mDistancesPanel.setFileSelectionEnabled(false);
        this.mTransformProxPanel.setFileSelectionEnabled(false);
        this.mFitMeasureCheck.setSelected(true);
        this.mSpaceWtCheck.setSelected(true);
        this.mFinalComSpaceCheck.setSelected(true);
        if (CommandLine.isClementineCaller()) {
            this.mSpaceCoordiPanel.setCreateCheckEnabled(false);
            this.mIndividualSpWtPanel.setCreateCheckEnabled(false);
            this.mDistancesPanel.setCreateCheckEnabled(false);
            this.mTransformProxPanel.setCreateCheckEnabled(false);
        }
    }

    private void addComponentToViewPanel(JPanel jPanel) {
        JPanel jPanel2 = this.setupDisplayPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 3, 1, n, insets);
        JPanel jPanel3 = this.setupSaveNewFilePanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 3, 1, n, insets);
    }

    private JPanel setupDisplayPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mInputDataCheck, this.mMultiStartCheck, this.mInitialDataCheck, new JLabel(" "), this.mIterateHistCheck, this.mFitMeasureCheck, this.mStressDecompCheck, this.mTransformProxCheck, this.mFinalComSpaceCheck, this.mSpaceWtCheck, this.mIndividualSpaceCheck, this.mFitDistCheck};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_MULTI_UNFOLD_DISPLAY"), 4);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupSaveNewFilePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_MULTI_UNFOLD_SAVE_NEW_FILE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mSpaceCoordiPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mIndividualSpWtPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mDistancesPanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mTransformProxPanel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        String string;
        super.loadState(dialogDataModel);
        if (dialogDataModel.getBoolean(COMMON_DATASET_SELECTION_STATE) != null) {
            this.mSpaceCoordiPanel.setCreateNewDataSetRadio(dialogDataModel.getBoolean(COMMON_DATASET_SELECTION_STATE));
        }
        if (dialogDataModel.getBoolean(SPACE_DATASET_SELECTION_STATE) != null) {
            this.mIndividualSpWtPanel.setCreateNewDataSetRadio(dialogDataModel.getBoolean(SPACE_DATASET_SELECTION_STATE));
        }
        if (dialogDataModel.getBoolean(DIST_DATASET_SELECTION_STATE) != null) {
            this.mDistancesPanel.setCreateNewDataSetRadio(dialogDataModel.getBoolean(DIST_DATASET_SELECTION_STATE));
        }
        if (dialogDataModel.getBoolean(TRANS_DATASET_SELECTION_STATE) != null) {
            this.mTransformProxPanel.setCreateNewDataSetRadio(dialogDataModel.getBoolean(TRANS_DATASET_SELECTION_STATE));
        }
        if ((string = dialogDataModel.getString(COMMON_TEXT_FIELD)) != null) {
            this.mSpaceCoordiPanel.setFileText(string);
        }
        if ((string = dialogDataModel.getString(SPACE_TEXT_FIELD)) != null) {
            this.mIndividualSpWtPanel.setFileText(string);
        }
        if ((string = dialogDataModel.getString(DIST_TEXT_FIELD)) != null) {
            this.mDistancesPanel.setFileText(string);
        }
        if ((string = dialogDataModel.getString(TRANS_TEXT_FIELD)) != null) {
            this.mTransformProxPanel.setFileText(string);
        }
        if ((string = dialogDataModel.getString(COMMON_DATASETNAME_TEXT_FIELD)) != null) {
            this.mSpaceCoordiPanel.setDatasetNameText(string);
        }
        if ((string = dialogDataModel.getString(SPACE_DATASETNAME_TEXT_FIELD)) != null) {
            this.mIndividualSpWtPanel.setDatasetNameText(string);
        }
        if ((string = dialogDataModel.getString(DIST_DATASETNAME_TEXT_FIELD)) != null) {
            this.mDistancesPanel.setDatasetNameText(string);
        }
        if ((string = dialogDataModel.getString(TRANS_DATASETNAME_TEXT_FIELD)) != null) {
            this.mTransformProxPanel.setDatasetNameText(string);
        }
        this.enableContinue(this.saveToNewFileSelectedAndChecked(false));
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        dialogDataModel.putBoolean(COMMON_DATASET_SELECTION_STATE, this.mSpaceCoordiPanel.isCreateNewDataSetRadioSelected());
        dialogDataModel.putBoolean(SPACE_DATASET_SELECTION_STATE, this.mIndividualSpWtPanel.isCreateNewDataSetRadioSelected());
        dialogDataModel.putBoolean(DIST_DATASET_SELECTION_STATE, this.mDistancesPanel.isCreateNewDataSetRadioSelected());
        dialogDataModel.putBoolean(TRANS_DATASET_SELECTION_STATE, this.mTransformProxPanel.isCreateNewDataSetRadioSelected());
        dialogDataModel.putString(COMMON_DATASETNAME_TEXT_FIELD, this.mSpaceCoordiPanel.getDatasetNameText());
        dialogDataModel.putString(SPACE_DATASETNAME_TEXT_FIELD, this.mIndividualSpWtPanel.getDatasetNameText());
        dialogDataModel.putString(DIST_DATASETNAME_TEXT_FIELD, this.mDistancesPanel.getDatasetNameText());
        dialogDataModel.putString(TRANS_DATASETNAME_TEXT_FIELD, this.mTransformProxPanel.getDatasetNameText());
        dialogDataModel.putString(COMMON_TEXT_FIELD, this.mSpaceCoordiPanel.getFileText());
        dialogDataModel.putString(SPACE_TEXT_FIELD, this.mIndividualSpWtPanel.getFileText());
        dialogDataModel.putString(DIST_TEXT_FIELD, this.mDistancesPanel.getFileText());
        dialogDataModel.putString(TRANS_TEXT_FIELD, this.mTransformProxPanel.getFileText());
        return bl;
    }

    private boolean saveToNewFileSelectedAndChecked(boolean bl) {
        if (this.mSpaceCoordiPanel.isSelected() && (bl || this.mSpaceCoordiPanel.saveToNewFileSelectedAndChecked(bl))) {
            return false;
        }
        if (this.mIndividualSpWtPanel.isSelected() && (bl || this.mIndividualSpWtPanel.saveToNewFileSelectedAndChecked(bl))) {
            return false;
        }
        if (this.mDistancesPanel.isSelected() && (bl || this.mDistancesPanel.saveToNewFileSelectedAndChecked(bl))) {
            return false;
        }
        return !this.mTransformProxPanel.isSelected() || !bl && !this.mTransformProxPanel.saveToNewFileSelectedAndChecked(bl);
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mInputDataCheck);
        vector.add(this.mMultiStartCheck);
        vector.add(this.mInitialDataCheck);
        vector.add(this.mIterateHistCheck);
        vector.add(this.mFitMeasureCheck);
        vector.add(this.mStressDecompCheck);
        vector.add(this.mTransformProxCheck);
        vector.add(this.mFinalComSpaceCheck);
        vector.add(this.mSpaceWtCheck);
        vector.add(this.mIndividualSpaceCheck);
        vector.add(this.mFitDistCheck);
        for (n = 0; n < this.mSpaceCoordiPanel.getComponentCount(); ++n) {
            vector.add(this.mSpaceCoordiPanel.getComponent(n));
        }
        for (n = 0; n < this.mIndividualSpWtPanel.getComponentCount(); ++n) {
            vector.add(this.mIndividualSpWtPanel.getComponent(n));
        }
        for (n = 0; n < this.mDistancesPanel.getComponentCount(); ++n) {
            vector.add(this.mDistancesPanel.getComponent(n));
        }
        for (n = 0; n < this.mTransformProxPanel.getComponentCount(); ++n) {
            vector.add(this.mTransformProxPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }
}

