/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.prefscal;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.MultiDimensionalCommonPanel;
import com.spss.java_client.ui.dialogs.market_research.prefscal.MultidimensionalUnfoldDlg;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MultidimensionalUnfoldOption
extends BaseSubDialog
implements ItemListener,
DocumentListener,
ListDataListener,
FocusListener {
    static final String CHOICE_TEXT = "IDS_CHOICE_TEXT";
    static final String NUMBER_START_TEXT = "IDS_NUMBER_START_TEXT";
    static final String STRESS_TEXT = "IDS_STRESS_TEXT";
    static final String MIN_STRESS_TEXT = "IDS_MIN_STRESS_TEXT";
    static final String MAX_ITERATE = "IDS_MAX_ITERATE";
    static final String STRENGTH_TEXT = "IDS_STRENGTH_TEXT";
    static final String RANGE_TEXT = "IDS_RANGE_TEXT";
    static final String OPT_FILE_TEXT = "IDS_OPT_FILE_TEXT";
    static final String TARGET_LIST_OPT = "IDS_TARGET_LIST_OPT";
    static final String IMPUTE_BY_COMBO = "IDS_IMPUTE_BY_COMBO";
    static final String CLASS_RADIO = "IDS_MULTI_UNFOLD_OPT_CLASS";
    static final String CLIFF_RADIO = "IDS_MULTI_UNFOLD_OPT_CLIFF";
    static final String CORRESPOND_RADIO = "IDS_MULTI_UNFOLD_OPT_CORRESPOND";
    static final String CENTROID_RADIO = "IDS_MULTI_UNFOLD_OPT_CENTROID";
    static final String RANDOM_RADIO = "IDS_MULTI_UNFOLD_OPT_RANDOM";
    static final String CUSTOM_RADIO = "IDS_MULTI_UNFOLD_OPT_CUSTOM";
    static final String CHOICE_VAL = "1";
    static final String NUMBER_START_VAL = "1";
    static final String CONVERGENCE_VAL = ".000001";
    static final String MIN_STRESS_VAL = ".0001";
    static final String MAX_ITERATE_VAL = "5000";
    static final String STRENGTH_VAL = "0.5";
    static final String RANGE_VAL = "1.0";
    private JPanel mConfigurationPanel;
    private JPanel mIterationPanel;
    private JPanel mPenaltyPanel;
    private MultiDimensionalCommonPanel mCustomConfigPanel;
    private SpssButtonGroup mRadioButtonGroup;
    private PlainList mTargetCustomList;
    private JRadioButton mClassicalRadio;
    private JRadioButton mCliffRadio;
    private JRadioButton mCorrespondRadio;
    private JRadioButton mCentroidRadio;
    private JRadioButton mMultipleRandomRadio;
    private JRadioButton mCustomRadio;
    private JLabel mImputelabel;
    private JLabel mChoicelabel;
    private JLabel mNumberStartlabel;
    private IntTextField mChoiceText;
    private IntTextField mNumberStartText;
    private FloatTextField mConvergenceText;
    private FloatTextField mMinStressText;
    private IntTextField mMaxIterateText;
    private FloatTextField mStrengthText;
    private FloatTextField mRangeText;
    private JComboBox mImputeCombo;

    public MultidimensionalUnfoldOption(MultidimensionalUnfoldDlg multidimensionalUnfoldDlg) {
        super(multidimensionalUnfoldDlg, multidimensionalUnfoldDlg.getResString("IDS_MULTI_DIMENSION_UNFOLD_OPTIONS_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prfa_options";
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.ifAllTextHaveValue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.ifAllTextHaveValue());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.ifAllTextHaveValue());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableContinue(this.ifAllTextHaveValue());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableContinue(this.ifAllTextHaveValue());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableContinue(this.ifAllTextHaveValue());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mClassicalRadio) {
            this.mImputeCombo.setEnabled(true);
            this.mImputelabel.setEnabled(true);
            this.mChoicelabel.setEnabled(false);
            this.mChoiceText.setEnabled(false);
            this.mChoiceText.setEditable(false);
            this.mNumberStartlabel.setEnabled(false);
            this.mNumberStartText.setEnabled(false);
            this.mNumberStartText.setEditable(false);
            this.mCustomConfigPanel.enableComponents(false);
            this.enableContinue(this.ifAllTextHaveValue());
        } else if (object == this.mCentroidRadio) {
            this.mImputeCombo.setEnabled(false);
            this.mImputelabel.setEnabled(false);
            this.mChoicelabel.setEnabled(true);
            this.mChoiceText.setEnabled(true);
            this.mChoiceText.setEditable(true);
            this.mNumberStartlabel.setEnabled(false);
            this.mNumberStartText.setEnabled(false);
            this.mNumberStartText.setEditable(false);
            this.mCustomConfigPanel.enableComponents(false);
            this.enableContinue(this.ifAllTextHaveValue());
        } else if (object == this.mMultipleRandomRadio) {
            this.mImputeCombo.setEnabled(false);
            this.mImputelabel.setEnabled(false);
            this.mChoicelabel.setEnabled(false);
            this.mChoiceText.setEditable(false);
            this.mChoiceText.setEnabled(false);
            this.mNumberStartlabel.setEnabled(true);
            this.mNumberStartText.setEnabled(true);
            this.mNumberStartText.setEditable(true);
            this.mCustomConfigPanel.enableComponents(false);
            this.enableContinue(this.ifAllTextHaveValue());
        } else if (object == this.mCustomRadio) {
            this.mImputeCombo.setEnabled(false);
            this.mImputelabel.setEnabled(false);
            this.mChoicelabel.setEnabled(false);
            this.mChoiceText.setEditable(false);
            this.mChoiceText.setEnabled(false);
            this.mNumberStartlabel.setEnabled(false);
            this.mNumberStartText.setEnabled(false);
            this.mNumberStartText.setEditable(false);
            this.mCustomConfigPanel.enableComponents(true);
            this.enableContinue(this.ifAllTextHaveValue());
        } else {
            this.mImputeCombo.setEnabled(false);
            this.mImputelabel.setEnabled(false);
            this.mChoicelabel.setEnabled(false);
            this.mChoiceText.setEnabled(false);
            this.mChoiceText.setEditable(false);
            this.mNumberStartlabel.setEnabled(false);
            this.mNumberStartText.setEnabled(false);
            this.mNumberStartText.setEditable(false);
            this.mCustomConfigPanel.enableComponents(false);
            this.enableContinue(this.ifAllTextHaveValue());
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object.equals(this.mStrengthText)) {
            this.mStrengthText.selectAll();
        }
        if (object.equals(this.mMinStressText)) {
            this.mMinStressText.selectAll();
        }
        if (object.equals(this.mMaxIterateText)) {
            this.mMaxIterateText.selectAll();
        }
        if (object.equals(this.mRangeText)) {
            this.mRangeText.selectAll();
        }
        if (object.equals(this.mConvergenceText)) {
            this.mConvergenceText.selectAll();
        }
        if (object.equals(this.mChoiceText)) {
            this.mChoiceText.selectAll();
        }
        if (object.equals(this.mNumberStartText)) {
            this.mNumberStartText.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters();
        }
    }

    @Override
    public boolean continuePressed() {
        if (this.mCentroidRadio.isSelected()) {
            MultidimensionalUnfoldDlg multidimensionalUnfoldDlg = (MultidimensionalUnfoldDlg)((Object)this.getParent());
            int n = Integer.parseInt(this.mChoiceText.getText().trim());
            int n2 = multidimensionalUnfoldDlg.getProxTargetListCount();
            if (n < 1 || n > n2) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MULTI_DIMENSION_UNFOLD_OPTION_MSG"), VersionInfo.getAppVersionString());
                this.mChoiceText.setSelectionStart(0);
                this.mChoiceText.setSelectionEnd(this.mChoiceText.getText().length());
                this.mChoiceText.requestFocus();
                return false;
            }
            if (!this.mStrengthText.checkRange()) {
                return false;
            }
            if (!this.mRangeText.checkRange()) {
                return false;
            }
            if (!this.mConvergenceText.checkRange()) {
                return false;
            }
            if (!this.mMinStressText.checkRange()) {
                return false;
            }
            if (!this.mMaxIterateText.checkRange()) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponentToViewPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void initVars() {
        ControlAction controlAction = new ToggleButtonAction(this, CLASS_RADIO);
        this.mClassicalRadio = new JRadioButton(controlAction);
        this.mClassicalRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, CLIFF_RADIO);
        this.mCliffRadio = new JRadioButton(controlAction);
        this.mCliffRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, CORRESPOND_RADIO);
        this.mCorrespondRadio = new JRadioButton(controlAction);
        this.mCorrespondRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, CENTROID_RADIO);
        this.mCentroidRadio = new JRadioButton(controlAction);
        this.mCentroidRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, RANDOM_RADIO);
        this.mMultipleRandomRadio = new JRadioButton(controlAction);
        this.mMultipleRandomRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, CUSTOM_RADIO);
        this.mCustomRadio = new JRadioButton(controlAction);
        this.mCustomRadio.addItemListener(this);
        controlAction = new TextFieldAction(this.mParentDlg, CHOICE_TEXT);
        this.mChoiceText = new IntTextField(true);
        this.mChoiceText.setAllowMinMax(true, true);
        this.mChoiceText.setShowErrorMsgs(false);
        this.mChoiceText.setAction((Action)controlAction);
        this.mChoiceText.getDocument().addDocumentListener(this);
        this.mChoiceText.addFocusListener((FocusListener)this);
        controlAction = new TextFieldAction(this.mParentDlg, NUMBER_START_TEXT);
        this.mNumberStartText = new IntTextField(1, 99999999, true);
        this.mNumberStartText.setAction((Action)controlAction);
        this.mNumberStartText.getDocument().addDocumentListener(this);
        this.mNumberStartText.addFocusListener((FocusListener)this);
        controlAction = new TextFieldAction(this.mParentDlg, STRESS_TEXT);
        this.mConvergenceText = new FloatTextField(0.0, 9.9999999E7, -1, true);
        this.mConvergenceText.setAction((Action)controlAction);
        this.mConvergenceText.getDocument().addDocumentListener(this);
        this.mConvergenceText.addFocusListener((FocusListener)this);
        this.mConvergenceText.setColumns(5);
        controlAction = new TextFieldAction(this.mParentDlg, MIN_STRESS_TEXT);
        this.mMinStressText = new FloatTextField(0.0, 9.9999999E7, -1, true);
        this.mMinStressText.setAction((Action)controlAction);
        this.mMinStressText.getDocument().addDocumentListener(this);
        this.mMinStressText.addFocusListener((FocusListener)this);
        this.mConvergenceText.setColumns(5);
        controlAction = new TextFieldAction(this.mParentDlg, MAX_ITERATE);
        this.mMaxIterateText = new IntTextField(1, 99999999, true);
        this.mMaxIterateText.setAction((Action)controlAction);
        this.mMaxIterateText.getDocument().addDocumentListener(this);
        this.mMaxIterateText.addFocusListener((FocusListener)this);
        this.mConvergenceText.setColumns(5);
        controlAction = new TextFieldAction(this.mParentDlg, STRENGTH_TEXT);
        this.mStrengthText = new FloatTextField(1.0E-6, 1.0, -1, true);
        this.mStrengthText.setAction((Action)controlAction);
        this.mStrengthText.getDocument().addDocumentListener(this);
        this.mStrengthText.addFocusListener((FocusListener)this);
        controlAction = new TextFieldAction(this.mParentDlg, RANGE_TEXT);
        this.mRangeText = new FloatTextField(0.0, 9.9999999E7, -1, true);
        this.mRangeText.setAction((Action)controlAction);
        this.mRangeText.getDocument().addDocumentListener(this);
        this.mRangeText.addFocusListener((FocusListener)this);
        controlAction = new ComboboxAction(this.mParentDlg, IMPUTE_BY_COMBO);
        this.mImputeCombo = new JComboBox<String>(this.getResStringArray("IDS_MULTI_UNFOLD_OPT_COMBO_VALUES"));
        this.mImputeCombo.setAction(controlAction);
        this.mChoicelabel = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_OPT_CHOICE");
        this.mChoicelabel.setLabelFor((Component)this.mChoiceText);
        this.mNumberStartlabel = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_OPT_NUMBER_START");
        this.mNumberStartlabel.setLabelFor((Component)this.mNumberStartText);
        this.mImputelabel = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_OPT_IMPUTE");
        this.mImputelabel.setLabelFor(this.mImputeCombo);
        this.mConfigurationPanel = this.setupConfigurationPanel();
        this.mIterationPanel = this.setupIterationPanel();
        this.mPenaltyPanel = this.setupPenaltyPanel();
        DialogDataModel dialogDataModel = ((MultidimensionalUnfoldDlg)((Object)this.getParent())).getDialogDataModel();
        String string = dialogDataModel.getString("IDS_MAX_TEXT");
        if (string == null) {
            string = "2";
        }
        this.mCustomConfigPanel = new MultiDimensionalCommonPanel(this, this.getResString("IDS_MULTI_UNFOLD_CUSTOM_CFG_PAN"), OPT_FILE_TEXT, "IDS_SRC_LIST_OPT", TARGET_LIST_OPT, string, this.getResString("IDS_MULTI_UNFOLD_INFO_TEXT_MSG"), true);
        this.mCustomConfigPanel.replaceDefaultFileChooserTitleKey("IDS_MULTI_UNFOLD_READ_FILE_CHOOSER_TITLE");
        this.mTargetCustomList = this.mCustomConfigPanel.getTargetList();
        this.mTargetCustomList.getModel().addListDataListener(this);
    }

    private void setDefaults() {
        this.mCustomConfigPanel.enableComponents(false);
        this.mClassicalRadio.setSelected(true);
        this.mChoiceText.setText("1");
        this.mNumberStartText.setText("1");
        this.mConvergenceText.setText(CONVERGENCE_VAL);
        this.mConvergenceText.setCaretPosition(0);
        this.mMinStressText.setText(MIN_STRESS_VAL);
        this.mMaxIterateText.setText(MAX_ITERATE_VAL);
        this.mStrengthText.setText(STRENGTH_VAL);
        this.mRangeText.setText(RANGE_VAL);
        if (CommandLine.isClementineCaller()) {
            this.mCustomRadio.setEnabled(false);
        }
    }

    private JPanel setupConfigurationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_MULTI_UNFOLD_INITIAL_CFG_PAN")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mClassicalRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCliffRadio, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCorrespondRadio, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCentroidRadio, gridBagConstraints, 0, 4, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMultipleRandomRadio, gridBagConstraints, 0, 6, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCustomRadio, gridBagConstraints, 0, 8, 1, 1, n2, insets);
        Insets insets2 = new Insets(0, 6 * n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mImputelabel, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        insets2 = new Insets(0, 9 * n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mChoicelabel, gridBagConstraints, 0, 5, 1, 1, n2, insets2);
        insets2 = new Insets(0, 5 * n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNumberStartlabel, gridBagConstraints, 0, 7, 1, 1, n2, insets2);
        insets2 = new Insets(0, n / 2, 0, n / 2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mImputeCombo, gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mChoiceText, gridBagConstraints, 1, 5, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 0.5;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumberStartText, gridBagConstraints, 1, 7, 1, 1, n2, insets2);
        this.mRadioButtonGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupIterationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_MULTI_UNFOLD_ITERATE_CRITERIA_PAN")));
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_OPT_CONVERGE");
        jLabel.setLabelFor((Component)this.mConvergenceText);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_OPT_MIN_STRESS");
        jLabel2.setLabelFor((Component)this.mMinStressText);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_OPT_MAX_ITERATE");
        jLabel3.setLabelFor((Component)this.mMaxIterateText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        gridBagConstraints.fill = 0;
        int n2 = 23;
        Insets insets = new Insets(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(n, n / 2, 0, n / 2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConvergenceText, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinStressText, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(n, n, n, n);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.mMaxIterateText.setColumns(4);
        gridBagConstraints.fill = 2;
        insets = new Insets(n, n / 2, n, n / 2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterateText, gridBagConstraints, 1, 2, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupPenaltyPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_MULTI_UNFOLD_PENALTY_TERM_PAN")));
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_OPT_STRENGTH");
        jLabel.setLabelFor((Component)this.mStrengthText);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_OPT_RANGE");
        jLabel2.setLabelFor((Component)this.mRangeText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        gridBagConstraints.fill = 0;
        int n2 = 23;
        Insets insets = new Insets(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(n, 7 * n, 0, n / 2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStrengthText, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(n, n, n, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(n, 7 * n, 0, n / 2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mRangeText, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        return jPanel;
    }

    private void addComponentToViewPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mConfigurationPanel, gridBagConstraints, 0, 0, 1, 2, n, insets);
        gridBagConstraints.weightx = 0.5;
        insets = new Insets(n2, 3 * n2 / 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mIterationPanel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        n = 25;
        insets = new Insets(0, 3 * n2 / 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mPenaltyPanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 1;
        insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCustomConfigPanel, gridBagConstraints, 0, 2, 2, 1, n, insets);
    }

    private boolean ifAllTextHaveValue() {
        boolean bl = false;
        if (this.mStrengthText.getText().trim().length() > 0 && this.mRangeText.getText().trim().length() > 0 && this.mMaxIterateText.getText().trim().length() > 0 && this.mMinStressText.getText().trim().length() > 0 && this.mConvergenceText.getText().trim().length() > 0) {
            if (this.mCentroidRadio.isSelected()) {
                bl = this.mChoiceText.getText().trim().length() > 0;
            } else if (this.mMultipleRandomRadio.isSelected()) {
                bl = this.mNumberStartText.getText().trim().length() > 0;
            } else {
                if (this.mCustomRadio.isSelected()) {
                    return this.mTargetCustomList.getModel().getSize() > 0 && this.mTargetCustomList.getModel().getSize() > 0;
                }
                bl = true;
            }
        }
        return bl;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRadioButtonGroup);
        vector.add(this.mImputeCombo);
        vector.add(this.mChoiceText);
        vector.add(this.mNumberStartText);
        vector.add(this.mConvergenceText);
        vector.add(this.mMinStressText);
        vector.add(this.mMaxIterateText);
        vector.add(this.mStrengthText);
        vector.add(this.mRangeText);
        this.mCustomConfigPanel.getElementsForFocusVector(vector);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        PlainList plainList = this.mCustomConfigPanel.getSourceList();
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(plainList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(plainList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(plainList, this.mPlainListVarMoveHandler));
        PlainList plainList2 = this.mCustomConfigPanel.getTargetList();
        plainListDragAdapter = new PlainListDragAdapter(plainList2, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(plainList2, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(plainList2, this.mPlainListVarMoveHandler));
    }
}

