/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.prefscal;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.prefscal.MultidimensionalUnfoldDlg;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MultidimensionalUnfoldModel
extends BaseSubDialog
implements ItemListener,
DocumentListener,
FocusListener {
    static final String MULTI_UNFOLD_INTERCEPT = "IDS_MULTI_UNFOLD_INTERCEPT";
    static final String MULTI_UNFOLD_OBSERVE = "IDS_MULTI_UNFOLD_OBSERVE";
    static final String MULTI_UNFOLD_IDENTITY = "IDS_MULTI_UNFOLD_IDENTITY";
    static final String MULTI_UNFOLD_WEIGHTED = "IDS_MULTI_UNFOLD_WEIGHTED";
    static final String MULTI_UNFOLD_GENERAL = "IDS_MULTI_UNFOLD_GENERAL";
    static final String MULTI_UNFOLD_DISSIMILAR = "IDS_MULTI_UNFOLD_DISSIMILAR";
    static final String MULTI_UNFOLD_SIMILAR = "IDS_MULTI_UNFOLD_SIMILAR";
    static final String MULTI_UNFOLD_NONE = "IDS_MULTI_UNFOLD_NONE";
    static final String MULTI_UNFOLD_LINEAR = "IDS_MULTI_UNFOLD_LINEAR";
    static final String MULTI_UNFOLD_SPLINE = "IDS_MULTI_UNFOLD_SPLINE";
    static final String MULTI_UNFOLD_SMOOTH = "IDS_MULTI_UNFOLD_SMOOTH";
    static final String MULTI_UNFOLD_ORDINAL = "IDS_MULTI_UNFOLD_ORDINAL";
    static final String MULTI_UNFOLD_WITH_ROW = "IDS_MULTI_UNFOLD_WITH_ROW";
    static final String MULTI_UNFOLD_WITH_SRC = "IDS_MULTI_UNFOLD_WITH_SRC";
    static final String MULTI_UNFOLD_ACROSS_SRC = "IDS_MULTI_UNFOLD_ACROSS_SRC";
    static final String MIN_TEXT = "IDS_MIN_TEXT";
    static final String MAX_TEXT = "IDS_MAX_TEXT";
    static final String DEG_TEXT = "IDS_DEG_TEXT";
    static final String KNOT_TEXT = "IDS_KNOT_TEXT";
    private static final String VAL_KNOT_DEF = "1";
    private static final String VAL_MIN_MAX_DEG_DEF = "2";
    private JCheckBox mInterceptCheck;
    private JCheckBox mObservationCheck;
    private JRadioButton mIdentityRadio;
    private JRadioButton mWeightedRadio;
    private JRadioButton mGeneralizedRadio;
    private JRadioButton mDissimilarRadio;
    private JRadioButton mSimilarRadio;
    private JRadioButton mNoneRadio;
    private JRadioButton mLinearRadio;
    private JRadioButton mSplineRadio;
    private JRadioButton mSmoothRadio;
    private JRadioButton mOrdinalRadio;
    private JRadioButton mWithinRowRadio;
    private JRadioButton mWithinSrcRadio;
    private JRadioButton mAcrossSrcRadio;
    private SpssButtonGroup mScaleGroup;
    private SpssButtonGroup mProxGroup;
    private SpssButtonGroup mProxTransGroup;
    private SpssButtonGroup mApplyTransGroup;
    private IntTextField mMinText;
    private IntTextField mMaxText;
    private IntTextField mDegreeText;
    private IntTextField mknotText;
    private JLabel mDegreeLabel;
    private JLabel mKnotsLabel;

    public MultidimensionalUnfoldModel(MultidimensionalUnfoldDlg multidimensionalUnfoldDlg) {
        super(multidimensionalUnfoldDlg, multidimensionalUnfoldDlg.getResString("IDS_MULTI_DIMENSION_UNFOLD_MODEL_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prfa_model";
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.ifAllTextHaveValue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.ifAllTextHaveValue());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.ifAllTextHaveValue());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mSplineRadio) {
            this.enableDisableProximityPanel(true);
            this.mInterceptCheck.setEnabled(true);
            this.mObservationCheck.setEnabled(false);
            this.enableContinue(this.ifAllTextHaveValue());
        } else if (object == this.mNoneRadio) {
            this.enableDisableProximityPanel(false);
            this.mInterceptCheck.setEnabled(true);
            this.mObservationCheck.setEnabled(false);
            this.enableContinue(this.ifAllTextHaveValue());
        } else if (object == this.mLinearRadio) {
            this.enableDisableProximityPanel(false);
            this.mInterceptCheck.setEnabled(true);
            this.mObservationCheck.setEnabled(false);
            this.enableContinue(this.ifAllTextHaveValue());
        } else if (object == this.mSmoothRadio || object == this.mOrdinalRadio) {
            this.enableDisableProximityPanel(false);
            this.mInterceptCheck.setEnabled(false);
            this.mObservationCheck.setEnabled(true);
            this.enableContinue(this.ifAllTextHaveValue());
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mMinText)) {
            this.mMinText.selectAll();
        }
        if (focusEvent.getSource().equals(this.mMaxText)) {
            this.mMaxText.selectAll();
        }
        if (focusEvent.getSource().equals(this.mDegreeText)) {
            this.mDegreeText.selectAll();
        }
        if (focusEvent.getSource().equals(this.mknotText)) {
            this.mknotText.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean continuePressed() {
        int n;
        int n2 = Integer.parseInt(this.mMinText.getText().trim());
        if (n2 > (n = Integer.parseInt(this.mMaxText.getText().trim()))) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MULTI_DIMENSION_UNFOLD_MODEL_MSG"), VersionInfo.getAppVersionString());
            this.mMaxText.setSelectionStart(0);
            this.mMaxText.setSelectionEnd(this.mMaxText.getText().length());
            this.mMaxText.requestFocus();
            return false;
        }
        if (this.mSplineRadio.isSelected()) {
            int n3 = ((MultidimensionalUnfoldDlg)this.mParentDlg).getProxTargetListCount() - 2;
            if (Integer.parseInt(this.mknotText.getText().trim()) > n3) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MULTI_DIMENSION_UNFOLD_MODEL_KNOT_MSG"), VersionInfo.getAppVersionString());
                this.mknotText.setSelectionStart(0);
                this.mknotText.setSelectionEnd(this.mknotText.getText().length());
                this.mknotText.requestFocus();
                return false;
            }
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponentToViewPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void initVars() {
        ControlAction controlAction = new ToggleButtonAction(this, MULTI_UNFOLD_INTERCEPT);
        this.mInterceptCheck = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this, MULTI_UNFOLD_OBSERVE);
        this.mObservationCheck = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this, MULTI_UNFOLD_IDENTITY);
        this.mIdentityRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, MULTI_UNFOLD_WEIGHTED);
        this.mWeightedRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, MULTI_UNFOLD_GENERAL);
        this.mGeneralizedRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, MULTI_UNFOLD_DISSIMILAR);
        this.mDissimilarRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, MULTI_UNFOLD_SIMILAR);
        this.mSimilarRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, MULTI_UNFOLD_NONE);
        this.mNoneRadio = new JRadioButton(controlAction);
        this.mNoneRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, MULTI_UNFOLD_LINEAR);
        this.mLinearRadio = new JRadioButton(controlAction);
        this.mLinearRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, MULTI_UNFOLD_SPLINE);
        this.mSplineRadio = new JRadioButton(controlAction);
        this.mSplineRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, MULTI_UNFOLD_SMOOTH);
        this.mSmoothRadio = new JRadioButton(controlAction);
        this.mSmoothRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, MULTI_UNFOLD_ORDINAL);
        this.mOrdinalRadio = new JRadioButton(controlAction);
        this.mOrdinalRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, MULTI_UNFOLD_WITH_ROW);
        this.mWithinRowRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, MULTI_UNFOLD_WITH_SRC);
        this.mWithinSrcRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, MULTI_UNFOLD_ACROSS_SRC);
        this.mAcrossSrcRadio = new JRadioButton(controlAction);
        controlAction = new TextFieldAction(this, MIN_TEXT);
        this.mMinText = new IntTextField(1, 99999999, true);
        this.mMinText.setAction((Action)controlAction);
        this.mMinText.getDocument().addDocumentListener(this);
        this.mMinText.addFocusListener((FocusListener)this);
        controlAction = new TextFieldAction(this, MAX_TEXT);
        this.mMaxText = new IntTextField(1, 99999999, true);
        this.mMaxText.setAction((Action)controlAction);
        this.mMaxText.getDocument().addDocumentListener(this);
        this.mMaxText.addFocusListener((FocusListener)this);
        controlAction = new TextFieldAction(this, DEG_TEXT);
        this.mDegreeText = new IntTextField(1, 3, true);
        this.mDegreeText.setAction((Action)controlAction);
        this.mDegreeText.getDocument().addDocumentListener(this);
        this.mDegreeText.addFocusListener((FocusListener)this);
        controlAction = new TextFieldAction(this, KNOT_TEXT);
        this.mknotText = new IntTextField(true);
        this.mknotText.setAction((Action)controlAction);
        this.mknotText.getDocument().addDocumentListener(this);
        this.mknotText.addFocusListener((FocusListener)this);
        this.mKnotsLabel = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_KNOTS");
        this.mKnotsLabel.setLabelFor((Component)this.mknotText);
        this.mDegreeLabel = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_DEGREE");
        this.mDegreeLabel.setLabelFor((Component)this.mDegreeText);
    }

    private void setDefaults() {
        this.mIdentityRadio.setSelected(true);
        MultidimensionalUnfoldDlg multidimensionalUnfoldDlg = (MultidimensionalUnfoldDlg)((Object)this.getParent());
        if (multidimensionalUnfoldDlg.getRowsTargetListCount() > 0 || multidimensionalUnfoldDlg.getSrcTargetListCount() > 0) {
            this.mIdentityRadio.setEnabled(true);
            this.mWeightedRadio.setEnabled(true);
            this.mGeneralizedRadio.setEnabled(true);
            this.mInterceptCheck.setEnabled(true);
        } else if (multidimensionalUnfoldDlg.getRowsTargetListCount() == 0 && multidimensionalUnfoldDlg.getSrcTargetListCount() == 0) {
            this.mIdentityRadio.setSelected(true);
            this.mIdentityRadio.setEnabled(false);
            this.mWeightedRadio.setEnabled(false);
            this.mGeneralizedRadio.setEnabled(false);
            this.mInterceptCheck.setEnabled(false);
        }
        this.mDissimilarRadio.setSelected(true);
        this.mOrdinalRadio.setSelected(true);
        this.mWithinRowRadio.setSelected(true);
        this.mMaxText.setText(VAL_MIN_MAX_DEG_DEF);
        this.mMinText.setText(VAL_MIN_MAX_DEG_DEF);
        this.mDegreeText.setText(VAL_MIN_MAX_DEG_DEF);
        this.mknotText.setText(VAL_KNOT_DEF);
    }

    private void enableDisableProximityPanel(boolean bl) {
        this.mDegreeText.setEnabled(bl);
        this.mknotText.setEnabled(bl);
        this.mKnotsLabel.setEnabled(bl);
        this.mDegreeLabel.setEnabled(bl);
        this.mDegreeText.setOpaque(bl);
        this.mknotText.setOpaque(bl);
    }

    private boolean ifAllTextHaveValue() {
        boolean bl = false;
        if (this.mMinText.getText().trim().length() > 0 && this.mMaxText.getText().trim().length() > 0) {
            bl = this.mSplineRadio.isSelected() ? this.mDegreeText.getText().trim().length() > 0 && this.mknotText.getText().trim().length() > 0 : true;
        }
        return bl;
    }

    private void addComponentToViewPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.setupScalingPanel();
        JPanel jPanel3 = this.setupProximitiesPanel();
        JPanel jPanel4 = this.setupProximityTransPanel();
        JPanel jPanel5 = this.setupDimensionPanel();
        this.mScaleGroup = DialogUtil.createButtonGroup(jPanel2);
        this.mProxGroup = DialogUtil.createButtonGroup(jPanel3);
        this.mProxTransGroup = DialogUtil.createButtonGroup(jPanel4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.5;
        insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 1, 0, 1, 4, n, insets);
    }

    private JPanel setupProximityTransPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_MULTI_UNFOLD_PROX_TRANS_PANEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        JPopupMenu.Separator separator = new JPopupMenu.Separator();
        DialogUtil.addUsingGBL(jPanel, this.mNoneRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mLinearRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSplineRadio, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(0, 2 * DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDegreeLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        insets2 = new Insets(DialogUtil.getComponentGroupGap(), 2 * DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mKnotsLabel, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets2 = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDegreeText, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        insets2 = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mknotText, gridBagConstraints, 1, 4, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mSmoothRadio, gridBagConstraints, 0, 5, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mOrdinalRadio, gridBagConstraints, 0, 6, 2, 1, n, insets);
        JPanel jPanel2 = this.setupCheckboxPanel();
        DialogUtil.createButtonGroup(jPanel2);
        JPanel jPanel3 = this.setupApplyTransPanel();
        this.mApplyTransGroup = DialogUtil.createButtonGroup(jPanel3);
        gridBagConstraints.weighty = 0.0;
        insets2 = new Insets(DialogUtil.getComponentGroupGap(), 2 * DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, separator, gridBagConstraints, 0, 7, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 8, 2, 1, n, insets2);
        JLabel jLabel = new JLabel(this.getResString("IDS_MULTI_UNFOLD_APPLY_TRANS_PANEL"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets2 = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 9, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 10;
        insets2 = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, new JPopupMenu.Separator(), gridBagConstraints, 1, 9, 1, 1, n, insets2);
        n = 23;
        gridBagConstraints.weighty = 0.0;
        insets2 = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 10, 2, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupScalingPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mIdentityRadio, this.mWeightedRadio, this.mGeneralizedRadio};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_MULTI_UNFOLD_SCALE_MODEL_PANEL"), 3);
        return jPanel;
    }

    private JPanel setupProximitiesPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mDissimilarRadio, this.mSimilarRadio};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_MULTI_UNFOLD_PROXIMITIES_PANEL"), 2);
        return jPanel;
    }

    private JPanel setupCheckboxPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mInterceptCheck, this.mObservationCheck};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, "", 2);
        return jPanel;
    }

    private JPanel setupApplyTransPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mWithinRowRadio, this.mWithinSrcRadio, this.mAcrossSrcRadio};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, "", 3);
        return jPanel;
    }

    private JPanel setupDimensionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_MULTI_UNFOLD_DIMENSION_PANEL")));
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_MIN");
        jLabel.setLabelFor((Component)this.mMinText);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_MAX");
        jLabel2.setLabelFor((Component)this.mMaxText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxText, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private Vector<Object> setTabTraversal() {
        MultidimensionalUnfoldDlg multidimensionalUnfoldDlg = (MultidimensionalUnfoldDlg)((Object)this.getParent());
        Vector<Object> vector = new Vector<Object>();
        if (multidimensionalUnfoldDlg.getRowsTargetListCount() > 0 || multidimensionalUnfoldDlg.getSrcTargetListCount() > 0) {
            vector.add(this.mScaleGroup);
        }
        vector.add(this.mProxGroup);
        vector.add(this.mMinText);
        vector.add(this.mMaxText);
        vector.add(this.mProxTransGroup);
        vector.add(this.mDegreeText);
        vector.add(this.mknotText);
        vector.add(this.mInterceptCheck);
        vector.add(this.mObservationCheck);
        vector.add(this.mApplyTransGroup);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

