/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.prefscal;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ListFocusTraversalPolicy;
import com.spss.java_client.ui.controls.ListTravArrowButtonFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.prefscal.MultidimensionalUnfoldModel;
import com.spss.java_client.ui.dialogs.market_research.prefscal.MultidimensionalUnfoldOption;
import com.spss.java_client.ui.dialogs.market_research.prefscal.MultidimensionalUnfoldOutput;
import com.spss.java_client.ui.dialogs.market_research.prefscal.MultidimensionalUnfoldPlots;
import com.spss.java_client.ui.dialogs.market_research.prefscal.MultidimensionalUnfoldRestrict;
import com.spss.java_client.ui.dialogs.market_research.res.MarketResearchResBundle;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MultidimensionalUnfoldDlg
extends BaseProcedureDialog
implements ListDataListener {
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetProximitiesList;
    private TargetVariableList mTargetWeightList;
    private TargetVariableList mTargetRowsList;
    private TargetVariableList mTargetSrcList;
    private JScrollPane mSrcLstScrollPane;
    private JScrollPane mTargetProxLstScrollPane;
    private JScrollPane mTargetWtLstScrollPane;
    private ArrowButton mProxyArrowButton;
    private ArrowButton mWtArrowButton;
    private ArrowButton mRowsArrowButton;
    private ArrowButton mSrcArrowButton;
    private ListTravArrowButtonFactory mArrowButtonProx;
    private ListTravArrowButtonFactory mArrowButtonWeight;
    private JButton mRestrictButton;
    private JButton mOptionsButton;
    String mCommonFile;
    String mWeightsFile;
    String mDistancesFile;
    String mTransformsFile;

    public MultidimensionalUnfoldDlg(JFrame jFrame) {
        super(jFrame, false, MarketResearchResBundle.getDefaultResourceBundleName(), MarketResearchResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_MULTI_DIMENSION_UNFOLD"));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prfs";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetProximitiesList.removeAll();
        this.mTargetWeightList.removeAll();
        this.mTargetRowsList.removeAll();
        this.mTargetSrcList.removeAll();
        this.setDefaults();
        this.mSrcVarList.requestFocus();
    }

    @Override
    public String getIActionKey() {
        return "analyze_scale_mult_unfolding";
    }

    @Override
    public String generateSyntax() {
        String string;
        String string2;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("PREFSCAL"));
        String string3 = this.mTargetProximitiesList.getVariablesStringList();
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES="));
        stringBuffer.append(string3);
        stringBuffer.append("\n");
        if (this.mTargetWeightList.getModel().getSize() > 0) {
            string2 = this.mTargetWeightList.getVariablesStringList();
            stringBuffer.append(SyntaxUtil.getSubCommand("/WEIGHTS="));
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        string2 = "";
        if (this.mTargetRowsList.getModel().getSize() > 0) {
            string2 = this.mTargetRowsList.getVariablesStringList();
            string2 = "ROWS(" + string2 + ")";
        }
        String string4 = "";
        if (this.mTargetSrcList.getModel().getSize() > 0) {
            string4 = this.mTargetSrcList.getVariablesStringList();
            string4 = "SOURCES(" + string4 + ")";
        }
        if (string2.trim().length() > 0 || string4.trim().length() > 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/INPUT="));
            if (string2.trim().length() > 0) {
                stringBuffer.append(string2);
            }
            if (string2.trim().length() > 0 && string4.trim().length() > 0) {
                stringBuffer.append(" ");
            }
            if (string4.trim().length() > 0) {
                stringBuffer.append(string4);
            }
            stringBuffer.append("\n");
        }
        this.generateSyntaxForModelOptionSubDlg(stringBuffer);
        this.mCommonFile = null;
        this.mWeightsFile = null;
        this.mDistancesFile = null;
        this.mTransformsFile = null;
        this.generateSyntaxForOutputSubDlg(stringBuffer);
        this.generateSyntaxForPlotSubDlg(stringBuffer);
        PesFile pesFile = PES_Repository.getPesFile((String)this.mCommonFile);
        if (pesFile != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        if ((pesFile = PES_Repository.getPesFile((String)this.mWeightsFile)) != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        if ((pesFile = PES_Repository.getPesFile((String)this.mDistancesFile)) != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        if ((pesFile = PES_Repository.getPesFile((String)this.mTransformsFile)) != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean okPastePressed() {
        int n;
        String string;
        int n2;
        String string2;
        boolean bl;
        if (this.mTargetWeightList.getModel().getSize() == 0) {
            bl = true;
        } else if (this.mTargetWeightList.getModel().getSize() == this.mTargetProximitiesList.getModel().getSize()) {
            bl = true;
        } else {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_WEIGHT_LIST_WARNNING_MESSAGE"), VersionInfo.getAppVersionString());
            return false;
        }
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_ROW_RESTRICT");
        if (bl2 != null && bl2.booleanValue()) {
            if (this.isDimensionValid("IDS_ROW_TARGET_LST")) {
                bl = true;
            } else {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DIMENSION_WARNNING_MESSAGE"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_COL_RESTRICT")) != null && bl2.booleanValue()) {
            if (this.isDimensionValid("IDS_COL_TARGET_LST")) {
                bl = true;
            } else {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DIMENSION_WARNNING_MESSAGE"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_OPT_CUSTOM")) != null && bl2.booleanValue()) {
            if (this.isDimensionValid("IDS_TARGET_LIST_OPT")) {
                bl = true;
            } else {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DIMENSION_WARNNING_MESSAGE"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        if ((string2 = dialogDataModel.getString("IDS_KNOT_TEXT")) == null || string2.trim().length() == 0) {
            string2 = "1";
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_SPLINE")) != null && bl2.booleanValue() && Integer.parseInt(string2) > this.getProxTargetListCount() - 2) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MULTI_DIMENSION_UNFOLD_MODEL_KNOT_MSG"), VersionInfo.getAppVersionString());
            return false;
        }
        Boolean bl3 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_OPT_CENTROID");
        if (bl3 != null && bl3.booleanValue() && (n2 = Integer.parseInt((string = dialogDataModel.getString("IDS_CHOICE_TEXT")).trim())) > (n = this.getProxTargetListCount())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MULTI_DIMENSION_UNFOLD_OPTION_MSG"), VersionInfo.getAppVersionString());
            this.mOptionsButton.requestFocus();
            return false;
        }
        return bl;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetProximitiesList.getModel().getSize() >= 2);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetProximitiesList.getModel().getSize() >= 2);
        if (this.getRowsTargetListCount() == 0 && this.getSrcTargetListCount() == 0) {
            this.updateDialogDataModel();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetProximitiesList.getModel().getSize() >= 2);
    }

    public int getRowsTargetListCount() {
        return this.mTargetRowsList.getModel().getSize();
    }

    public int getSrcTargetListCount() {
        return this.mTargetSrcList.getModel().getSize();
    }

    public int getProxTargetListCount() {
        return this.mTargetProximitiesList.getModel().getSize();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        Vector<Object> vector = this.setTabTraversal();
        ListFocusTraversalPolicy listFocusTraversalPolicy = new ListFocusTraversalPolicy(new ListTravArrowButtonFactory[]{this.mArrowButtonProx, this.mArrowButtonWeight}, vector, false);
        this.setFocusTraversalPolicy(listFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_MODEL_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultidimensionalUnfoldDlg.this.runModelsSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction("IDS_COMMON_RESTRICT_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultidimensionalUnfoldDlg.this.runRestrictionsSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction3 = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultidimensionalUnfoldDlg.this.runOptionsSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction4 = new ToggleButtonAction("IDS_COMMON_PLOTS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultidimensionalUnfoldDlg.this.runPlotsSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction5 = new ToggleButtonAction("IDS_COMMON_OUTPUT_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultidimensionalUnfoldDlg.this.runOutputSubDialog();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.mRestrictButton = new JButton(toggleButtonAction2);
        this.mOptionsButton = new JButton(toggleButtonAction3);
        JButton jButton2 = new JButton(toggleButtonAction4);
        JButton jButton3 = new JButton(toggleButtonAction5);
        this.addOptionsPanelButton(jPanel, jButton);
        this.addOptionsPanelButton(jPanel, this.mRestrictButton);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        this.addOptionsPanelButton(jPanel, jButton2);
        this.addOptionsPanelButton(jPanel, jButton3);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mSrcVarList.setIdentifier("MULTI_UNFOLD_SRC_LIST");
        this.mSrcLstScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcLstScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTargetProximitiesList = new TargetVariableList();
        this.mTargetProximitiesList.setIdentifier("MULTI_UNFOLD_TARGET_PROX_LIST");
        this.mTargetProximitiesList.getModel().addListDataListener(this);
        this.mTargetProximitiesList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetProxLstScrollPane = new JScrollPane(this.mTargetProximitiesList);
        this.mTargetProxLstScrollPane.setPreferredSize(this.mTargetProximitiesList.getMinimumSize());
        this.mProxyArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mProxyArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mProxyArrowButton.registerVariableList(this.mTargetProximitiesList, SpssArrowButton.ButtonOrientation.left);
        this.mTargetWeightList = new TargetVariableList();
        this.mTargetWeightList.setIdentifier("MULTI_UNFOLD_TARGET_WT_LIST");
        this.mTargetWeightList.getModel().addListDataListener(this);
        this.mTargetWeightList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetWtLstScrollPane = new JScrollPane(this.mTargetWeightList);
        this.mTargetWtLstScrollPane.setPreferredSize(this.mTargetWeightList.getMinimumSize());
        this.mWtArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mWtArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mWtArrowButton.registerVariableList(this.mTargetWeightList, SpssArrowButton.ButtonOrientation.left);
        this.mTargetRowsList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetRowsList.setIdentifier("MULTI_UNFOLD_TARGET_ROW_LIST");
        this.mTargetRowsList.getModel().addListDataListener(this);
        this.mTargetRowsList.addVarFilter(new SpssVarFilter(8, false));
        this.mRowsArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mTargetRowsList, SpssArrowButton.ButtonOrientation.left);
        this.mTargetSrcList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetSrcList.setIdentifier("MULTI_UNFOLD_TARGET_SRC_LIST");
        this.mTargetSrcList.getModel().addListDataListener(this);
        this.mTargetSrcList.addVarFilter(new SpssVarFilter(8, false));
        this.mSrcArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSrcArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSrcArrowButton.registerVariableList(this.mTargetSrcList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButtonProx = new ListTravArrowButtonFactory(this.mTargetProximitiesList, false);
        this.mArrowButtonWeight = new ListTravArrowButtonFactory(this.mTargetWeightList, false);
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.enableOkPaste(false);
        if (CommandLine.isClementineCaller()) {
            this.mRestrictButton.setEnabled(false);
        }
    }

    private void addComponents(JPanel jPanel) {
        JPanel jPanel2 = this.mArrowButtonProx.getArrowButtonPanel();
        JPanel jPanel3 = this.mArrowButtonWeight.getArrowButtonPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_MULTI_DIMENSION_UNFOLD_SOURCE_LIST_LABEL");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcLstScrollPane, gridBagConstraints, 0, 1, 1, 9, n, null);
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 10;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mProxyArrowButton, gridBagConstraints, 1, 1, 1, 2, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mWtArrowButton, gridBagConstraints, 1, 4, 1, 2, n, insets);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mRowsArrowButton, gridBagConstraints, 1, 6, 1, 2, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mSrcArrowButton, gridBagConstraints, 1, 8, 1, 2, n, insets2);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_PROXIMITIES_COLON");
        jLabel2.setLabelFor(this.mTargetProximitiesList);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetProxLstScrollPane, gridBagConstraints, 2, 1, 1, 2, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 3, 1, 1, 2, n, null);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_WEIGHT_COLON");
        jLabel3.setLabelFor(this.mTargetWeightList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 3, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetWtLstScrollPane, gridBagConstraints, 2, 4, 1, 2, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 3, 4, 1, 2, n, null);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_ROWS_COLON");
        jLabel4.setLabelFor(this.mTargetRowsList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 6, 1, 1, n, insets2);
        JScrollPane jScrollPane = new JScrollPane(this.mTargetRowsList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mTargetRowsList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 7, 1, 1, n, null);
        JLabel jLabel5 = DialogUtil.createLabel(this, "IDS_MULTI_UNFOLD_SRCS_COLON");
        jLabel5.setLabelFor(this.mTargetSrcList);
        insets2 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel5, gridBagConstraints, 2, 8, 1, 1, n, insets2);
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetSrcList);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.setPreferredSize(this.mTargetSrcList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 9, 1, 1, n, null);
    }

    private void generateSyntaxForModelOptionSubDlg(StringBuffer stringBuffer) {
        Object object;
        Object object2;
        stringBuffer.append(SyntaxUtil.getSubCommand("/INITIAL="));
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_OPT_CLASS");
        if (bl == null) {
            stringBuffer.append("CLASSICAL(TRIANGLE)");
        } else if (bl != null && bl.booleanValue()) {
            int n = dialogDataModel.getInteger("IDS_IMPUTE_BY_COMBO");
            if (n == 0) {
                stringBuffer.append("CLASSICAL(TRIANGLE)");
            } else {
                stringBuffer.append("CLASSICAL(SPEARMAN)");
            }
        }
        bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_OPT_CLIFF");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("ROSSCLIFF");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_OPT_CORRESPOND")) != null && bl.booleanValue()) {
            stringBuffer.append("CORRESPONDENCE");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_OPT_CENTROID")) != null && bl.booleanValue()) {
            stringBuffer.append("CENTROIDS(");
            stringBuffer.append(dialogDataModel.getString("IDS_CHOICE_TEXT"));
            stringBuffer.append(")");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_OPT_RANDOM")) != null && bl.booleanValue()) {
            stringBuffer.append("RANDOM(");
            stringBuffer.append(dialogDataModel.getString("IDS_NUMBER_START_TEXT"));
            stringBuffer.append(")");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_OPT_CUSTOM")) != null && bl.booleanValue()) {
            stringBuffer.append("(");
            stringBuffer.append(CharacterUtil.smartQuote((String)dialogDataModel.getString("IDS_OPT_FILE_TEXT")));
            stringBuffer.append(") ");
            StringBuffer stringBuffer2 = new StringBuffer();
            object2 = dialogDataModel.getArray("IDS_TARGET_LIST_OPT");
            for (Object object3 : object2) {
                stringBuffer2.append(object3.toString());
                stringBuffer2.append(" ");
            }
            object = stringBuffer2.toString();
            stringBuffer.append(((String)object).trim());
        }
        stringBuffer.append("\n");
        if (dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_WITH_ROW") == null && dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_WITH_SRC") == null && dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_ACROSS_SRC") == null) {
            dialogDataModel.putBoolean("IDS_MULTI_UNFOLD_WITH_ROW", true);
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/CONDITION="));
        bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_WITH_ROW");
        if (bl == null) {
            stringBuffer.append("ROW");
        } else if (bl != null && bl.booleanValue()) {
            stringBuffer.append("ROW");
        }
        bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_WITH_SRC");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("MATRIX");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_ACROSS_SRC")) != null && bl.booleanValue()) {
            stringBuffer.append("UNCONDITIONAL");
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/TRANSFORMATION="));
        String string = "";
        object2 = "(KEEPTIES)";
        bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_INTERCEPT");
        if (bl != null && bl.booleanValue()) {
            string = "(INTERCEPT)";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_OBSERVE")) != null && bl.booleanValue()) {
            object2 = "(UNTIE)";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_NONE")) != null && bl.booleanValue()) {
            stringBuffer.append("NONE").append(string);
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_LINEAR")) != null && bl.booleanValue()) {
            stringBuffer.append("LINEAR").append(string);
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_SPLINE")) != null && bl.booleanValue()) {
            object = dialogDataModel.getString("IDS_DEG_TEXT");
            String string2 = dialogDataModel.getString("IDS_KNOT_TEXT");
            stringBuffer.append("SPLINE");
            if (string.trim().length() == 0) {
                stringBuffer.append("(ORDER=").append((String)object).append(" INKNOT=").append(string2).append(")");
            } else {
                stringBuffer.append("(INTERCEPT ORDER=").append((String)object).append(" INKNOT=").append(string2).append(")");
            }
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_SMOOTH")) != null && bl.booleanValue()) {
            stringBuffer.append("SMOOTH").append((String)object2);
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_ORDINAL")) == null) {
            stringBuffer.append("ORDINAL").append((String)object2);
        } else if (bl != null && bl.booleanValue()) {
            stringBuffer.append("ORDINAL").append((String)object2);
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/PROXIMITIES="));
        bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_SIMILAR");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("SIMILARITIES");
        } else {
            stringBuffer.append("DISSIMILARITIES");
        }
        stringBuffer.append("\n");
        if (this.getSrcTargetListCount() > 0 || this.getRowsTargetListCount() > 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/MODEL="));
            bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_IDENTITY");
            if (bl == null) {
                stringBuffer.append("IDENTITY");
            } else if (bl != null && bl.booleanValue()) {
                stringBuffer.append("IDENTITY");
            }
            bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_WEIGHTED");
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append("WEIGHTED");
            }
            if ((bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_GENERAL")) != null && bl.booleanValue()) {
                stringBuffer.append("GENERALIZED");
            }
            stringBuffer.append("\n");
        }
        bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_ROW_RESTRICT");
        object = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_COL_RESTRICT");
        if (bl != null && bl.booleanValue() || object != null && ((Boolean)object).booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/RESTRICTIONS="));
            StringBuffer stringBuffer3 = new StringBuffer();
            if (bl.booleanValue()) {
                Object[] objectArray;
                stringBuffer3.append("ROW(COORDINATES(");
                stringBuffer3.append(CharacterUtil.smartQuote((String)dialogDataModel.getString("IDS_ROW_SRC_FILE")));
                stringBuffer3.append(") ");
                for (Object object3 : objectArray = dialogDataModel.getArray("IDS_ROW_TARGET_LST")) {
                    stringBuffer3.append(object3.toString());
                    stringBuffer3.append(" ");
                }
                String string2 = stringBuffer3.toString().trim();
                stringBuffer3.delete(0, stringBuffer3.length());
                stringBuffer3.append(string2);
                stringBuffer3.append(") ");
            }
            if (((Boolean)object).booleanValue()) {
                Object[] objectArray;
                stringBuffer3.append("COLUMN(COORDINATES(");
                stringBuffer3.append(CharacterUtil.smartQuote((String)dialogDataModel.getString("IDS_COL_SRC_FILE")));
                stringBuffer3.append(") ");
                for (Object object3 : objectArray = dialogDataModel.getArray("IDS_COL_TARGET_LST")) {
                    stringBuffer3.append(object3.toString());
                    stringBuffer3.append(" ");
                }
                String string3 = stringBuffer3.toString().trim();
                stringBuffer3.delete(0, stringBuffer3.length());
                stringBuffer3.append(string3);
                stringBuffer3.append(") ");
            }
            stringBuffer.append(stringBuffer3.toString().trim());
            stringBuffer.append("\n");
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA="));
        stringBuffer.append("DIMENSIONS(");
        if (dialogDataModel.getString("IDS_MIN_TEXT") == null || dialogDataModel.getString("IDS_MAX_TEXT") == null) {
            stringBuffer.append("2,2");
            stringBuffer.append(") ");
        } else {
            stringBuffer.append(dialogDataModel.getString("IDS_MIN_TEXT"));
            stringBuffer.append(",");
            stringBuffer.append(dialogDataModel.getString("IDS_MAX_TEXT"));
            stringBuffer.append(") ");
        }
        stringBuffer.append("DIFFSTRESS(");
        if (dialogDataModel.getString("IDS_STRESS_TEXT") == null) {
            stringBuffer.append(".000001");
        } else {
            stringBuffer.append(dialogDataModel.getString("IDS_STRESS_TEXT"));
        }
        stringBuffer.append(") ");
        stringBuffer.append("MINSTRESS(");
        if (dialogDataModel.getString("IDS_MIN_STRESS_TEXT") == null) {
            stringBuffer.append(".0001");
        } else {
            stringBuffer.append(dialogDataModel.getString("IDS_MIN_STRESS_TEXT"));
        }
        stringBuffer.append(")");
        stringBuffer.append(" MAXITER(");
        if (dialogDataModel.getString("IDS_MAX_ITERATE") == null) {
            stringBuffer.append("5000");
        } else {
            stringBuffer.append(dialogDataModel.getString("IDS_MAX_ITERATE"));
        }
        stringBuffer.append(")");
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/PENALTY="));
        stringBuffer.append("LAMBDA(");
        if (dialogDataModel.getString("IDS_STRENGTH_TEXT") == null) {
            stringBuffer.append("0.5");
        } else {
            stringBuffer.append(dialogDataModel.getString("IDS_STRENGTH_TEXT"));
        }
        stringBuffer.append(") ");
        stringBuffer.append("OMEGA(");
        if (dialogDataModel.getString("IDS_RANGE_TEXT") == null) {
            stringBuffer.append("1.0");
        } else {
            stringBuffer.append(dialogDataModel.getString("IDS_RANGE_TEXT"));
        }
        stringBuffer.append(")");
        stringBuffer.append("\n");
    }

    private void generateSyntaxForOutputSubDlg(StringBuffer stringBuffer) {
        stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT="));
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        boolean bl = false;
        StringBuffer stringBuffer2 = new StringBuffer();
        Boolean bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_INPUT_DATA");
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer2.append("INPUT ");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_MULTI_START")) != null && bl2.booleanValue() && (bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_OPT_RANDOM")) != null && bl2.booleanValue()) {
            stringBuffer2.append("MULTIPLE ");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_INITIAL_DATA")) != null && bl2.booleanValue()) {
            stringBuffer2.append("INITIAL ");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_ITERATE_HIST")) != null && bl2.booleanValue()) {
            stringBuffer2.append("HISTORY ");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_FIT_MEASURE")) == null) {
            stringBuffer2.append("MEASURES ");
            bl = true;
        } else if (bl2.booleanValue()) {
            stringBuffer2.append("MEASURES ");
            bl = true;
        }
        bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_STRESS_DECOMP");
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer2.append("DECOMPOSITION ");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_TRANS_PROX")) != null && bl2.booleanValue()) {
            stringBuffer2.append("TRANSFORMATIONS ");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_FINAL_COMM")) == null) {
            stringBuffer2.append("COMMON ");
            bl = true;
        } else if (bl2.booleanValue()) {
            stringBuffer2.append("COMMON ");
            bl = true;
        }
        bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_SPACE_WT");
        if ((bl2 == null || bl2.booleanValue()) && (bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_IDENTITY")) != null && !bl2.booleanValue()) {
            stringBuffer2.append("WEIGHTS ");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_INDI_SPACE")) != null && bl2.booleanValue() && (bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_IDENTITY")) != null && !bl2.booleanValue()) {
            stringBuffer2.append("INDIVIDUAL ");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_FIT_DIST")) != null && bl2.booleanValue()) {
            stringBuffer2.append("DISTANCES ");
            bl = true;
        }
        if (!bl) {
            stringBuffer2.append("NONE");
        }
        stringBuffer.append(stringBuffer2.toString().trim());
        stringBuffer.append("\n");
        StringBuffer stringBuffer3 = new StringBuffer();
        bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_COMM_SPACE");
        if (bl2 != null && bl2.booleanValue()) {
            bl2 = dialogDataModel.getBoolean("IDS_COMMON_DATASET_SELECTION_STATE");
            this.mCommonFile = bl2 != null && bl2 != false ? dialogDataModel.getString("IDS_DATASETNAME_COMMON_TEXT_FIELD") : dialogDataModel.getString("IDS_COMMON_TEXT_FIELD");
            stringBuffer3.append("COMMON(");
            stringBuffer3.append(CharacterUtil.smartQuote((String)this.mCommonFile));
            stringBuffer3.append(") ");
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_IND_SPACE_WT")) != null && bl2.booleanValue() && (bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_IDENTITY")) != null && !bl2.booleanValue()) {
            bl2 = dialogDataModel.getBoolean("IDS_SPACE_DATASET_SELECTION_STATE");
            this.mWeightsFile = bl2 != null && bl2 != false ? dialogDataModel.getString("IDS_DATASETNAME_SPACE_TEXT_FIELD") : dialogDataModel.getString("IDS_SPACE_TEXT_FIELD");
            stringBuffer3.append("WEIGHTS(");
            stringBuffer3.append(CharacterUtil.smartQuote((String)this.mWeightsFile));
            stringBuffer3.append(") ");
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_DIST")) != null && bl2.booleanValue()) {
            bl2 = dialogDataModel.getBoolean("IDS_SPACE_DATASET_SELECTION_STATE");
            this.mDistancesFile = bl2 != null && bl2 != false ? dialogDataModel.getString("IDS_DATASETNAME_DIST_TEXT_FIELD") : dialogDataModel.getString("IDS_DIST_TEXT_FIELD");
            stringBuffer3.append("DISTANCES(");
            stringBuffer3.append(CharacterUtil.smartQuote((String)this.mDistancesFile));
            stringBuffer3.append(") ");
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_TRANS_PROX_SAVE")) != null && bl2.booleanValue()) {
            bl2 = dialogDataModel.getBoolean("IDS_TRANS_DATASET_SELECTION_STATE");
            this.mTransformsFile = bl2 != null && bl2 != false ? dialogDataModel.getString("IDS_DATASETNAME_TRANS_TEXT_FIELD") : dialogDataModel.getString("IDS_TRANS_TEXT_FIELD");
            stringBuffer3.append("TRANSFORMATIONS(");
            stringBuffer3.append(CharacterUtil.smartQuote((String)this.mTransformsFile));
            stringBuffer3.append(") ");
        }
        if (stringBuffer3.toString().trim().length() > 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/OUTFILE="));
            stringBuffer.append(stringBuffer3.toString().trim());
            stringBuffer.append("\n");
        }
    }

    private void generateSyntaxForPlotSubDlg(StringBuffer stringBuffer) {
        ISpssVariable[] iSpssVariableArray;
        ISpssVariable[] iSpssVariableArray2;
        stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT="));
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        boolean bl = false;
        StringBuffer stringBuffer2 = new StringBuffer();
        Boolean bl2 = dialogDataModel.getBoolean(MultidimensionalUnfoldPlots.MULTI_UNFOLD_PLOT_MULTIPLE_START);
        if (bl2 != null && bl2.booleanValue() && (bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_OPT_RANDOM")) != null && bl2.booleanValue()) {
            stringBuffer2.append("MULTIPLE ");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean(MultidimensionalUnfoldPlots.MULTI_UNFOLD_PLOT_CMN_SPACE)) != null && bl2.booleanValue()) {
            stringBuffer2.append("INITIAL ");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean(MultidimensionalUnfoldPlots.MULTI_UNFOLD_PLOT_STRESS_DIMENSION)) != null && bl2.booleanValue() && !(iSpssVariableArray2 = dialogDataModel.getString("IDS_MAX_TEXT")).equals(iSpssVariableArray = dialogDataModel.getString("IDS_MIN_TEXT"))) {
            stringBuffer2.append("STRESS ");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean(MultidimensionalUnfoldPlots.MULTI_UNFOLD_PLOT_FINAL_SPACE)) == null) {
            stringBuffer2.append("COMMON ");
            bl = true;
        } else if (bl2.booleanValue()) {
            stringBuffer2.append("COMMON ");
            bl = true;
        }
        bl2 = dialogDataModel.getBoolean(MultidimensionalUnfoldPlots.MULTI_UNFOLD_PLOT_SPACE_WT);
        if ((bl2 == null || bl2.booleanValue()) && (bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_IDENTITY")) != null && !bl2.booleanValue()) {
            stringBuffer2.append("WEIGHTS ");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean(MultidimensionalUnfoldPlots.MULTI_UNFOLD_PLOT_IND_SPACE)) != null && bl2.booleanValue() && (bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_IDENTITY")) != null && !bl2.booleanValue()) {
            stringBuffer2.append("INDIVIDUAL");
            stringBuffer2.append(this.getVarListFromSrcPanel());
            stringBuffer2.append(" ");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean(MultidimensionalUnfoldPlots.MULTI_UNFOLD_PLOT_TRANS_PLOT)) != null && bl2.booleanValue()) {
            bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_WITH_ROW");
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer2.append("TRANSFORMATIONS");
                stringBuffer2.append(this.getVarListFromRowPanel());
                stringBuffer2.append(" ");
                bl = true;
            } else {
                bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_WITH_SRC");
                if (bl2 != null && bl2.booleanValue()) {
                    stringBuffer2.append("TRANSFORMATIONS");
                    stringBuffer2.append(this.getVarListFromSrcPanel());
                    stringBuffer2.append(" ");
                    bl = true;
                } else {
                    stringBuffer2.append("TRANSFORMATIONS");
                    stringBuffer2.append(" ");
                    bl = true;
                }
            }
        }
        if ((bl2 = dialogDataModel.getBoolean(MultidimensionalUnfoldPlots.MULTI_UNFOLD_PLOT_SHEPARD)) != null && bl2.booleanValue()) {
            bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_WITH_ROW");
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer2.append("SHEPARD");
                stringBuffer2.append(this.getVarListFromRowPanel());
                stringBuffer2.append(" ");
                bl = true;
            } else {
                bl2 = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_WITH_SRC");
                if (bl2 != null && bl2.booleanValue()) {
                    stringBuffer2.append("SHEPARD");
                    stringBuffer2.append(this.getVarListFromSrcPanel());
                    stringBuffer2.append(" ");
                    bl = true;
                } else {
                    stringBuffer2.append("SHEPARD");
                    stringBuffer2.append(" ");
                    bl = true;
                }
            }
        }
        if ((bl2 = dialogDataModel.getBoolean(MultidimensionalUnfoldPlots.MULTI_UNFOLD_PLOT_SCATTER)) != null && bl2.booleanValue()) {
            stringBuffer2.append("FIT");
            stringBuffer2.append(this.getVarListFromSrcPanel());
            stringBuffer2.append(" ");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean(MultidimensionalUnfoldPlots.MULTI_UNFOLD_PLOT_RESIDUAL)) != null && bl2.booleanValue()) {
            stringBuffer2.append("RESIDUALS");
            stringBuffer2.append(this.getVarListFromSrcPanel());
            stringBuffer2.append(" ");
            bl = true;
        }
        if (!bl) {
            stringBuffer2.append("NONE");
            stringBuffer2.append(" ");
        }
        stringBuffer.append(stringBuffer2.toString().trim());
        iSpssVariableArray2 = dialogDataModel.getVarArray(MultidimensionalUnfoldPlots.MULTI_UNFOLD_PLOT_TARGET_COLOR_LIST);
        iSpssVariableArray = dialogDataModel.getVarArray(MultidimensionalUnfoldPlots.MULTI_UNFOLD_PLOT_TARGET_MARKER_LIST);
        if (iSpssVariableArray2 != null && iSpssVariableArray2.length > 0 || iSpssVariableArray != null && iSpssVariableArray.length > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/OPTIONS="));
            StringBuffer stringBuffer3 = new StringBuffer();
            if (iSpssVariableArray2 != null && iSpssVariableArray2.length > 0) {
                stringBuffer3.append("COLORS(");
                stringBuffer3.append(this.getNameFromTheLocallyUniqueId(iSpssVariableArray2[0].getId()));
                stringBuffer3.append(") ");
            }
            if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
                stringBuffer3.append("MARKERS(");
                stringBuffer3.append(this.getNameFromTheLocallyUniqueId(iSpssVariableArray[0].getId()));
                stringBuffer3.append(") ");
            }
            stringBuffer.append(stringBuffer3.toString().trim());
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
    }

    private String getNameFromTheLocallyUniqueId(LocallyUniqueId locallyUniqueId) {
        String string = "";
        LocallyUniqueId locallyUniqueId2 = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId2);
        int n = iSpssDataSrc.findVarIndex(locallyUniqueId);
        if (n > -1) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
            string = iSpssVariable.getName();
        }
        return string;
    }

    private String getVarListFromSrcPanel() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean(MultidimensionalUnfoldPlots.MULTI_UNFOLD_PLOT_SELECT_RADIO_SRC);
        if (bl != null && bl.booleanValue() && this.getSrcTargetListCount() > 0) {
            stringBuffer.append("(");
            Object[] objectArray = dialogDataModel.getArray(MultidimensionalUnfoldPlots.MULTI_UNFOLD_PLOT_SRC_LIST_ID);
            if (objectArray != null) {
                for (Object object : objectArray) {
                    stringBuffer.append(object.toString());
                    stringBuffer.append(" ");
                }
            }
            string = stringBuffer.toString().trim();
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(string);
            stringBuffer.append(")");
            string = stringBuffer.toString().trim();
        } else {
            stringBuffer.append("(ALL)");
            string = stringBuffer.toString();
        }
        return string;
    }

    private String getVarListFromRowPanel() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean(MultidimensionalUnfoldPlots.MULTI_UNFOLD_PLOT_SELECT_RADIO_ROW);
        if (bl != null && bl.booleanValue() && this.getRowsTargetListCount() > 0) {
            stringBuffer.append("(");
            Object[] objectArray = dialogDataModel.getArray(MultidimensionalUnfoldPlots.MULTI_UNFOLD_PLOT_ROW_LIST_ID);
            if (objectArray != null) {
                for (Object object : objectArray) {
                    stringBuffer.append(object.toString());
                    stringBuffer.append(" ");
                }
            }
            string = stringBuffer.toString().trim();
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(string);
            stringBuffer.append(")");
            string = stringBuffer.toString().trim();
        } else {
            stringBuffer.append("(ALL)");
            string = stringBuffer.toString();
        }
        return string;
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mProxyArrowButton);
        vector.add(this.mWtArrowButton);
        vector.add(this.mRowsArrowButton);
        vector.add(this.mSrcArrowButton);
        vector.add(this.mTargetProximitiesList);
        vector.add(this.mArrowButtonProx.getUpArrowButton());
        vector.add(this.mArrowButtonProx.getDownArrowButton());
        vector.add(this.mTargetWeightList);
        vector.add(this.mArrowButtonWeight.getUpArrowButton());
        vector.add(this.mArrowButtonWeight.getDownArrowButton());
        vector.add(this.mTargetRowsList);
        vector.add(this.mTargetSrcList);
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }

    private void updateDialogDataModel() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_IDENTITY");
        if (bl != null && !bl.booleanValue()) {
            dialogDataModel.putBoolean("IDS_MULTI_UNFOLD_IDENTITY", true);
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_WEIGHTED")) != null && bl.booleanValue()) {
            dialogDataModel.putBoolean("IDS_MULTI_UNFOLD_WEIGHTED", false);
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MULTI_UNFOLD_GENERAL")) != null && bl.booleanValue()) {
            dialogDataModel.putBoolean("IDS_MULTI_UNFOLD_GENERAL", false);
        }
    }

    private boolean isDimensionValid(String string) {
        int n;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Object[] objectArray = dialogDataModel.getArray(string);
        int n2 = objectArray.length;
        String string2 = dialogDataModel.getString("IDS_MAX_TEXT");
        if (string2 == null) {
            string2 = "2";
        }
        return n2 == (n = Integer.parseInt(string2));
    }

    private void runModelsSubDialog() {
        new MultidimensionalUnfoldModel(this);
    }

    private void runRestrictionsSubDialog() {
        new MultidimensionalUnfoldRestrict(this);
    }

    private void runOptionsSubDialog() {
        new MultidimensionalUnfoldOption(this);
    }

    private void runPlotsSubDialog() {
        new MultidimensionalUnfoldPlots(this);
    }

    private void runOutputSubDialog() {
        new MultidimensionalUnfoldOutput(this);
    }
}

