/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.optimal_scaling;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.BasicACREvent;
import com.spss.java_client.ui.controls.BasicACRWidget;
import com.spss.java_client.ui.controls.IBasicACRListener;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingDlg;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.Formatter;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OptimalScalingRegularization
extends BaseSubDialog
implements FocusListener,
ItemListener,
DocumentListener,
IBasicACRListener {
    public static final String REG_NONE_RADIO = "IDS_OS_REG_NONE_LABEL";
    public static final String REG_RIDGE_REGRESS_RADIO = "IDS_OS_REG_RIDGE_REGRESSION";
    public static final String REG_RIDGE_MIN_EDIT = "IDS_OS_REG_RIDGE_MIN_EDIT";
    public static final String REG_RIDGE_MAX_EDIT = "IDS_OS_REG_RIDGE_MAX_EDIT";
    public static final String REG_RIDGE_INCR_EDIT = "IDS_OS_REG_RIDGE_INCR_EDIT";
    public static final String REG_LASSO_RADIO = "IDS_OS_REG_LASSO";
    public static final String REG_LASSO_MIN_EDIT = "IDS_OS_REG_LASSO_MIN_EDIT";
    public static final String REG_LASSO_MAX_EDIT = "IDS_OS_REG_LASSO_MAX_EDIT";
    public static final String REG_LASSO_INCR_EDIT = "IDS_OS_REG_LASSO_INCR_EDIT";
    public static final String REG_ELASTICNET_RADIO = "IDS_OS_REG_ELASTIC_NET";
    public static final String REG_ELN_RIDGE_MIN_EDIT = "IDS_OS_REG_ELN_RIDGE_MIN_EDIT";
    public static final String REG_ELN_RIDGE_MAX_EDIT = "IDS_OS_REG_ELN_RIDGE_MAX_EDIT";
    public static final String REG_ELN_RIDGE_INCR_EDIT = "IDS_OS_REG_ELN_RIDGE_INCR_EDIT";
    public static final String REG_ELN_LASSO_MIN_EDIT = "IDS_OS_REG_ELN_LASSO_MIN_EDIT";
    public static final String REG_ELN_LASSO_MAX_EDIT = "IDS_OS_REG_ELN_LASSO_MAX_EDIT";
    public static final String REG_ELN_LASSO_INCR_EDIT = "IDS_OS_REG_ELN_LASSO_INCR_EDIT";
    public static final String REG_DISP_REG_PLOTS_CHECK = "IDS_OS_REG_DISPLAY_REG_PLOTS";
    public static final String REG_PRODUCE_ALL_ELN_PLOTS = "IDS_OS_REG_PRODUCE_ALL";
    public static final String REG_PRODUCE_SOME_ELN_PLOTS = "IDS_OS_REG_PRODUCE_SOME";
    public static final String REG_RANGE_VALUES_RADIO = "IDS_OS_REG_RANGE_OF_VALUES";
    public static final String REG_RANGE_FIRST_EDIT = "IDS_OS_REG_FIRST";
    public static final String REG_RANGE_LAST_EDIT = "IDS_OS_REG_LAST";
    public static final String REG_SINGLE_VAL_RADIO = "IDS_OS_REG_SINGLE_VALUE";
    public static final String REG_RANGE_SINGLE_VALUE_EDIT = "IDS_OS_REG_VALUE";
    public static final String BASIC_ACR_WIDGET_KEY = "REGULARIZATION_BASIC_ACR_WIDGET_KEY";
    private static final int gap = 6;
    private static final String DEFAULT_MIN_VALUE = "0.0";
    private static final String DEFAULT_MAX_VALUE = "1.0";
    private static final String DEFAULT_INCR_VALUE = "0.02";
    private static final String DEFAULT_ENET_RIDGE_INCR_VALUE = "0.1";
    private static final int RIDGE = 0;
    private static final int LASSO = 1;
    private static final String EMPTY_STR = "";
    private static final String SPACE = " ";
    private static final String HYPHEN = "-";
    private JRadioButton mMethodNoneRadio;
    private JRadioButton mMethodRidgeRadio;
    private JRadioButton mMethodLassoRadio;
    private JRadioButton mMethodElasticNetRadio;
    private SpssButtonGroup mMethodButtonGroup;
    private FloatTextField mRidgeMinTextField;
    private FloatTextField mRidgeMaxTextField;
    private FloatTextField mRidgeIncrTextField;
    private JLabel mRidgeMinLabel;
    private JLabel mRidgeMaxLabel;
    private JLabel mRidgeIncrLabel;
    private JLabel mLassoMinLabel;
    private JLabel mLassoMaxLabel;
    private JLabel mLassoIncrLabel;
    private FloatTextField mLassoMinTextField;
    private FloatTextField mLassoMaxTextField;
    private FloatTextField mLassoIncrTextField;
    private FloatTextField mEnetRidgeMinTextField;
    private FloatTextField mEnetRidgeMaxTextField;
    private FloatTextField mEnetRidgeIncrTextField;
    private FloatTextField mEnetLassoMinTextField;
    private FloatTextField mEnetLassoMaxTextField;
    private FloatTextField mEnetLassoIncrTextField;
    private JLabel mEnetMinLabel;
    private JLabel mEnetMaxLabel;
    private JLabel mEnetIncrLabel;
    private JLabel mEnetRidgeLabel;
    private JLabel mEnetLassoLabel;
    private JCheckBox mDisplayRegPlotsCheck;
    private JRadioButton mElasticProduceAllPlotsRadio;
    private JRadioButton mElasticProduceSomePlotsRadio;
    private SpssButtonGroup mElasticButtonGroup;
    private JRadioButton mRangeOfValuesRadio;
    private JRadioButton mSingleValueRadio;
    private SpssButtonGroup mSomePlotsButtonGroup;
    private FloatTextField mRangeFirstTextField;
    private FloatTextField mRangeLastTextField;
    private FloatTextField mSingleValueTextField;
    private JLabel mElasticFirstLabel;
    private JLabel mElasticLastLabel;
    private JLabel mElasticValueLabel;
    private BasicACRWidget mBasicACRWidget;

    OptimalScalingRegularization(OptimalScalingDlg optimalScalingDlg) {
        super(optimalScalingDlg, optimalScalingDlg.getResString("IDS_OS_REG_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_catr_regularization";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mMethodNoneRadio) || itemEvent.getSource().equals(this.mMethodRidgeRadio) || itemEvent.getSource().equals(this.mMethodLassoRadio) || itemEvent.getSource().equals(this.mMethodElasticNetRadio)) {
            this.enableMethodTextFields(itemEvent);
        }
        this.enableElasticNetPlotsComponents();
    }

    private void enableElasticNetPlotsComponents() {
        this.mElasticProduceAllPlotsRadio.setEnabled(this.mDisplayRegPlotsCheck.isSelected() && this.mMethodElasticNetRadio.isSelected());
        this.mElasticProduceSomePlotsRadio.setEnabled(this.mDisplayRegPlotsCheck.isSelected() && this.mMethodElasticNetRadio.isSelected());
        this.mRangeOfValuesRadio.setEnabled(this.mElasticProduceSomePlotsRadio.isEnabled() && this.mElasticProduceSomePlotsRadio.isSelected());
        this.mSingleValueRadio.setEnabled(this.mElasticProduceSomePlotsRadio.isEnabled() && this.mElasticProduceSomePlotsRadio.isSelected());
        this.mRangeFirstTextField.setEnabled(this.mRangeOfValuesRadio.isEnabled() && this.mRangeOfValuesRadio.isSelected());
        this.mElasticFirstLabel.setEnabled(this.mRangeOfValuesRadio.isEnabled() && this.mRangeOfValuesRadio.isSelected());
        this.mRangeLastTextField.setEnabled(this.mRangeOfValuesRadio.isEnabled() && this.mRangeOfValuesRadio.isSelected());
        this.mElasticLastLabel.setEnabled(this.mRangeOfValuesRadio.isEnabled() && this.mRangeOfValuesRadio.isSelected());
        this.mSingleValueTextField.setEnabled(this.mSingleValueRadio.isEnabled() && this.mSingleValueRadio.isSelected());
        this.mElasticValueLabel.setEnabled(this.mSingleValueRadio.isEnabled() && this.mSingleValueRadio.isSelected());
    }

    private void enableMethodTextFields(ItemEvent itemEvent) {
        boolean bl = this.mMethodRidgeRadio.isSelected();
        this.mRidgeMinTextField.setEnabled(bl);
        this.mRidgeMaxTextField.setEnabled(bl);
        this.mRidgeIncrTextField.setEnabled(bl);
        this.mRidgeMinLabel.setEnabled(bl);
        this.mRidgeMaxLabel.setEnabled(bl);
        this.mRidgeIncrLabel.setEnabled(bl);
        boolean bl2 = this.mMethodLassoRadio.isSelected();
        this.mLassoMinTextField.setEnabled(bl2);
        this.mLassoMaxTextField.setEnabled(bl2);
        this.mLassoIncrTextField.setEnabled(bl2);
        this.mLassoMinLabel.setEnabled(bl2);
        this.mLassoMaxLabel.setEnabled(bl2);
        this.mLassoIncrLabel.setEnabled(bl2);
        boolean bl3 = this.mMethodElasticNetRadio.isSelected();
        this.mEnetRidgeMinTextField.setEnabled(bl3);
        this.mEnetRidgeMaxTextField.setEnabled(bl3);
        this.mEnetRidgeIncrTextField.setEnabled(bl3);
        this.mEnetLassoMinTextField.setEnabled(bl3);
        this.mEnetLassoMaxTextField.setEnabled(bl3);
        this.mEnetLassoIncrTextField.setEnabled(bl3);
        this.mEnetMinLabel.setEnabled(bl3);
        this.mEnetMaxLabel.setEnabled(bl3);
        this.mEnetIncrLabel.setEnabled(bl3);
        this.mEnetRidgeLabel.setEnabled(bl3);
        this.mEnetLassoLabel.setEnabled(bl3);
        this.mDisplayRegPlotsCheck.setEnabled(bl || bl2 || bl3);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableButtons(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableButtons(documentEvent);
    }

    private void enableButtons(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().equals(this.mRangeFirstTextField.getDocument())) {
            this.updateAddChangeButton();
            this.mBasicACRWidget.setRemoveEnabled(false);
        } else if (documentEvent.getDocument().equals(this.mRangeLastTextField.getDocument())) {
            this.updateAddChangeButton();
            this.mBasicACRWidget.setRemoveEnabled(false);
        } else if (documentEvent.getDocument().equals(this.mSingleValueTextField.getDocument())) {
            this.updateAddChangeButton();
            this.mBasicACRWidget.setRemoveEnabled(false);
        }
    }

    private void updateAddChangeButton() {
        if (this.mSingleValueTextField.isEnabled()) {
            this.mBasicACRWidget.setAddEnabled(this.mSingleValueTextField.getText().length() > 0);
            this.mBasicACRWidget.setChangeEnabled(this.mSingleValueTextField.getText().length() > 0 && this.mBasicACRWidget.getListSelectedIndex() != -1);
        } else if (this.mRangeFirstTextField.isEnabled() && this.mRangeLastTextField.isEnabled()) {
            this.mBasicACRWidget.setAddEnabled(this.mRangeFirstTextField.getText().length() > 0 && this.mRangeLastTextField.getText().length() > 0);
            this.mBasicACRWidget.setChangeEnabled(this.mRangeFirstTextField.getText().length() > 0 && this.mRangeLastTextField.getText().length() > 0 && this.mBasicACRWidget.getListSelectedIndex() != -1);
        }
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
    }

    @Override
    public void acrEventOccured(BasicACREvent basicACREvent) {
        if (basicACREvent.getEventType() == BasicACREvent.EventType.addButtonPress) {
            if (!this.processAddButtonPress()) {
                this.mBasicACRWidget.setAddEnabled(false);
                this.mBasicACRWidget.setChangeEnabled(false);
                this.mBasicACRWidget.setRemoveEnabled(false);
                this.mBasicACRWidget.getList().requestFocus();
            }
        } else if (basicACREvent.getEventType() == BasicACREvent.EventType.changeButtonPress) {
            if (!this.processChangeButtonPress()) {
                this.mBasicACRWidget.setAddEnabled(false);
                this.mBasicACRWidget.setChangeEnabled(false);
                this.mBasicACRWidget.setRemoveEnabled(false);
            }
        } else if (basicACREvent.getEventType() == BasicACREvent.EventType.removeButtonPress) {
            this.processRemoveButtonPress();
            this.mBasicACRWidget.setRemoveEnabled(false);
            this.mBasicACRWidget.getList().requestFocus();
        } else if (basicACREvent.getEventType() == BasicACREvent.EventType.listSelectionValueChange) {
            if (this.mBasicACRWidget.getListSelectedIndex() != -1) {
                this.processListSelectionValueChange();
                this.mBasicACRWidget.setAddEnabled(false);
                this.mBasicACRWidget.setChangeEnabled(false);
                this.mBasicACRWidget.setRemoveEnabled(this.mBasicACRWidget.getList().getModel().getSize() > 0);
                this.mBasicACRWidget.getList().requestFocus();
            } else {
                this.mBasicACRWidget.setRemoveEnabled(false);
            }
        }
    }

    private boolean processChangeButtonPress() {
        boolean bl = false;
        if (this.mRangeOfValuesRadio.isSelected()) {
            if (this.isRangeInvalid(this.mRangeFirstTextField.getText(), this.mRangeLastTextField.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_PENALTY_VALUE_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
                this.mRangeFirstTextField.selectAll();
                this.mRangeFirstTextField.requestFocus();
                bl = true;
            }
            if (!bl) {
                String string = this.mRangeFirstTextField.getText() + SPACE + HYPHEN + SPACE + this.mRangeLastTextField.getText();
                int n = this.mBasicACRWidget.getListSelectedIndex();
                DefaultListModel defaultListModel = (DefaultListModel)this.mBasicACRWidget.getList().getModel();
                if (n != -1 && !defaultListModel.contains(string)) {
                    this.mBasicACRWidget.removeListItemAt(n);
                    this.mBasicACRWidget.addListItemAt(n, string);
                }
                this.mRangeFirstTextField.setText(EMPTY_STR);
                this.mRangeLastTextField.setText(EMPTY_STR);
            }
        } else if (this.mSingleValueTextField.isEnabled()) {
            if (this.isSingleValueInvalid(this.mSingleValueTextField.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_PENALTY_VALUE_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
                this.mSingleValueTextField.selectAll();
                this.mSingleValueTextField.requestFocus();
                bl = true;
            } else {
                int n = this.mBasicACRWidget.getListSelectedIndex();
                String string = this.mSingleValueTextField.getText();
                DefaultListModel defaultListModel = (DefaultListModel)this.mBasicACRWidget.getList().getModel();
                if (n != -1 && !defaultListModel.contains(string)) {
                    this.mBasicACRWidget.removeListItemAt(n);
                    this.mBasicACRWidget.addListItemAt(n, string);
                }
                this.mSingleValueTextField.setText(EMPTY_STR);
            }
        }
        return bl;
    }

    private void processRemoveButtonPress() {
        int[] nArray = this.mBasicACRWidget.getList().getSelectedIndices();
        for (int i = nArray.length - 1; i >= 0; --i) {
            String string = (String)this.mBasicACRWidget.getListItemAt(nArray[i]);
            if (string.contains(HYPHEN)) {
                this.mRangeFirstTextField.setText(EMPTY_STR);
                this.mRangeLastTextField.setText(EMPTY_STR);
            } else {
                this.mSingleValueTextField.setText(EMPTY_STR);
            }
            this.mBasicACRWidget.removeListItemAt(nArray[i]);
        }
    }

    private void processListSelectionValueChange() {
        int[] nArray = this.mBasicACRWidget.getList().getSelectedIndices();
        if (nArray.length == 1) {
            String string = (String)this.mBasicACRWidget.getListItemAt(this.mBasicACRWidget.getListSelectedIndex());
            if (string.contains(HYPHEN)) {
                String string2 = string.substring(0, string.indexOf(SPACE));
                String string3 = string.substring(string.indexOf(SPACE) + 3, string.length());
                this.mRangeOfValuesRadio.setSelected(true);
                this.mRangeFirstTextField.setEnabled(true);
                this.mRangeFirstTextField.setOpaque(true);
                this.mElasticFirstLabel.setEnabled(true);
                this.mRangeLastTextField.setEnabled(true);
                this.mRangeLastTextField.setOpaque(true);
                this.mElasticLastLabel.setEnabled(true);
                this.mSingleValueTextField.setEnabled(false);
                this.mSingleValueTextField.setOpaque(false);
                this.mElasticValueLabel.setEnabled(false);
                this.mRangeFirstTextField.setText(string2);
                this.mRangeLastTextField.setText(string3);
            } else {
                this.mSingleValueRadio.setSelected(true);
                this.mRangeFirstTextField.setEnabled(false);
                this.mRangeFirstTextField.setOpaque(false);
                this.mElasticFirstLabel.setEnabled(false);
                this.mRangeLastTextField.setEnabled(false);
                this.mRangeLastTextField.setOpaque(false);
                this.mElasticLastLabel.setEnabled(false);
                this.mSingleValueTextField.setEnabled(true);
                this.mSingleValueTextField.setOpaque(true);
                this.mElasticValueLabel.setEnabled(true);
                this.mSingleValueTextField.setText(string);
            }
        } else {
            this.mRangeFirstTextField.setText(EMPTY_STR);
            this.mRangeLastTextField.setText(EMPTY_STR);
            this.mSingleValueTextField.setText(EMPTY_STR);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponentsToPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void setDefaults() {
        this.mMethodNoneRadio.setSelected(true);
        this.mBasicACRWidget.setEnabled(false);
        Formatter formatter = new Formatter().format(ResUtil.getLocale(), DEFAULT_MIN_VALUE, new Object[0]);
        this.mRidgeMinTextField.setText(formatter.toString());
        this.mLassoMinTextField.setText(formatter.toString());
        this.mEnetRidgeMinTextField.setText(formatter.toString());
        this.mEnetLassoMinTextField.setText(formatter.toString());
        formatter = new Formatter().format(ResUtil.getLocale(), DEFAULT_MAX_VALUE, new Object[0]);
        this.mRidgeMaxTextField.setText(formatter.toString());
        this.mLassoMaxTextField.setText(formatter.toString());
        this.mEnetRidgeMaxTextField.setText(formatter.toString());
        this.mEnetLassoMaxTextField.setText(formatter.toString());
        formatter = new Formatter().format(ResUtil.getLocale(), DEFAULT_INCR_VALUE, new Object[0]);
        this.mRidgeIncrTextField.setText(formatter.toString());
        this.mLassoIncrTextField.setText(formatter.toString());
        this.mEnetLassoIncrTextField.setText(formatter.toString());
        formatter = new Formatter().format(ResUtil.getLocale(), DEFAULT_ENET_RIDGE_INCR_VALUE, new Object[0]);
        this.mEnetRidgeIncrTextField.setText(formatter.toString());
        this.mElasticProduceAllPlotsRadio.setSelected(true);
        this.mDisplayRegPlotsCheck.setSelected(true);
        this.mDisplayRegPlotsCheck.setEnabled(false);
        this.mElasticProduceAllPlotsRadio.setSelected(true);
        this.mElasticProduceAllPlotsRadio.setEnabled(false);
        this.mRangeOfValuesRadio.setSelected(true);
        this.mRangeOfValuesRadio.setEnabled(false);
        this.mSingleValueRadio.setEnabled(false);
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, REG_NONE_RADIO);
        this.mMethodNoneRadio = new JRadioButton(toggleButtonAction);
        this.mMethodNoneRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, REG_RIDGE_REGRESS_RADIO);
        this.mMethodRidgeRadio = new JRadioButton(toggleButtonAction);
        this.mMethodRidgeRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, REG_LASSO_RADIO);
        this.mMethodLassoRadio = new JRadioButton(toggleButtonAction);
        this.mMethodLassoRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, REG_ELASTICNET_RADIO);
        this.mMethodElasticNetRadio = new JRadioButton(toggleButtonAction);
        this.mMethodElasticNetRadio.addItemListener(this);
        this.mMethodButtonGroup = new SpssButtonGroup();
        this.mMethodButtonGroup.add(this.mMethodNoneRadio);
        this.mMethodButtonGroup.add(this.mMethodRidgeRadio);
        this.mMethodButtonGroup.add(this.mMethodLassoRadio);
        this.mMethodButtonGroup.add(this.mMethodElasticNetRadio);
        this.mRidgeMinTextField = this.createFloatTextField(0.0, 9999999.0, 6, true, REG_RIDGE_MIN_EDIT);
        this.mRidgeMaxTextField = this.createFloatTextField(0.0, 9999999.0, 6, true, REG_RIDGE_MAX_EDIT);
        this.mRidgeIncrTextField = this.createFloatTextField(0.0, 9999999.0, 6, true, REG_RIDGE_INCR_EDIT);
        this.mRidgeMinLabel = DialogUtil.createLabel(this, "IDS_OS_REG_MINIMUM");
        this.mRidgeMaxLabel = DialogUtil.createLabel(this, "IDS_OS_REG_MAXIMUM");
        this.mRidgeIncrLabel = DialogUtil.createLabel(this, "IDS_OS_REG_INCREMENT");
        this.mRidgeMinLabel.setLabelFor((Component)this.mRidgeMinTextField);
        this.mRidgeMaxLabel.setLabelFor((Component)this.mRidgeMaxTextField);
        this.mRidgeIncrLabel.setLabelFor((Component)this.mRidgeIncrTextField);
        this.mLassoMinLabel = DialogUtil.createLabel(this, "IDS_OS_REG_MINIMUM");
        this.mLassoMaxLabel = DialogUtil.createLabel(this, "IDS_OS_REG_MAXIMUM");
        this.mLassoIncrLabel = DialogUtil.createLabel(this, "IDS_OS_REG_INCREMENT");
        this.mLassoMinTextField = this.createFloatTextField(0.0, 9999999.0, 6, true, REG_LASSO_MIN_EDIT);
        this.mLassoMaxTextField = this.createFloatTextField(0.0, 9999999.0, 6, true, REG_LASSO_MAX_EDIT);
        this.mLassoIncrTextField = this.createFloatTextField(0.0, 9999999.0, 6, true, REG_LASSO_INCR_EDIT);
        this.mLassoMinLabel.setLabelFor((Component)this.mLassoMinTextField);
        this.mLassoMaxLabel.setLabelFor((Component)this.mLassoMaxTextField);
        this.mLassoIncrLabel.setLabelFor((Component)this.mLassoIncrTextField);
        this.mEnetRidgeMinTextField = this.createFloatTextField(0.0, 9999999.0, 6, true, REG_ELN_RIDGE_MIN_EDIT);
        this.mEnetRidgeMaxTextField = this.createFloatTextField(0.0, 9999999.0, 6, true, REG_ELN_RIDGE_MAX_EDIT);
        this.mEnetRidgeIncrTextField = this.createFloatTextField(0.0, 9999999.0, 6, true, REG_ELN_RIDGE_INCR_EDIT);
        this.mEnetLassoMinTextField = this.createFloatTextField(0.0, 9999999.0, 6, true, REG_ELN_LASSO_MIN_EDIT);
        this.mEnetLassoMaxTextField = this.createFloatTextField(0.0, 9999999.0, 6, true, REG_ELN_LASSO_MAX_EDIT);
        this.mEnetLassoIncrTextField = this.createFloatTextField(0.0, 9999999.0, 6, true, REG_ELN_LASSO_INCR_EDIT);
        this.mEnetMinLabel = DialogUtil.createLabel(this, "IDS_OS_REG_MINIMUM");
        this.mEnetMaxLabel = DialogUtil.createLabel(this, "IDS_OS_REG_MAXIMUM");
        this.mEnetIncrLabel = DialogUtil.createLabel(this, "IDS_OS_REG_INCREMENT");
        this.mEnetRidgeLabel = DialogUtil.createLabel(this, "IDS_OS_REG_RIDGE_REGRESSION_COLON");
        this.mEnetLassoLabel = DialogUtil.createLabel(this, "IDS_OS_REG_LASSO_COLON");
        this.mEnetMinLabel.setLabelFor((Component)this.mEnetRidgeMinTextField);
        this.mEnetMaxLabel.setLabelFor((Component)this.mEnetRidgeMaxTextField);
        this.mEnetIncrLabel.setLabelFor((Component)this.mEnetRidgeIncrTextField);
        this.mEnetRidgeLabel.setLabelFor((Component)this.mEnetRidgeMinTextField);
        this.mEnetLassoLabel.setLabelFor((Component)this.mEnetLassoMinTextField);
        toggleButtonAction = new ToggleButtonAction(this, REG_DISP_REG_PLOTS_CHECK);
        this.mDisplayRegPlotsCheck = new JCheckBox(toggleButtonAction);
        this.mDisplayRegPlotsCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, REG_PRODUCE_ALL_ELN_PLOTS);
        this.mElasticProduceAllPlotsRadio = new JRadioButton(toggleButtonAction);
        this.mElasticProduceAllPlotsRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, REG_PRODUCE_SOME_ELN_PLOTS);
        this.mElasticProduceSomePlotsRadio = new JRadioButton(toggleButtonAction);
        this.mElasticProduceSomePlotsRadio.addItemListener(this);
        this.mElasticButtonGroup = new SpssButtonGroup();
        this.mElasticButtonGroup.add(this.mElasticProduceAllPlotsRadio);
        this.mElasticButtonGroup.add(this.mElasticProduceSomePlotsRadio);
        toggleButtonAction = new ToggleButtonAction(this, REG_RANGE_VALUES_RADIO);
        this.mRangeOfValuesRadio = new JRadioButton(toggleButtonAction);
        this.mRangeOfValuesRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, REG_SINGLE_VAL_RADIO);
        this.mSingleValueRadio = new JRadioButton(toggleButtonAction);
        this.mSingleValueRadio.addItemListener(this);
        this.mSomePlotsButtonGroup = new SpssButtonGroup();
        this.mSomePlotsButtonGroup.add(this.mRangeOfValuesRadio);
        this.mSomePlotsButtonGroup.add(this.mSingleValueRadio);
        this.mRangeFirstTextField = this.createFloatTextField(0.0, 9999999.0, 6, true, REG_RANGE_FIRST_EDIT);
        this.mRangeLastTextField = this.createFloatTextField(0.0, 9999999.0, 6, true, REG_RANGE_LAST_EDIT);
        this.mSingleValueTextField = this.createFloatTextField(0.0, 9999999.0, 6, true, REG_RANGE_SINGLE_VALUE_EDIT);
        this.mElasticFirstLabel = DialogUtil.createLabel(this, REG_RANGE_FIRST_EDIT);
        this.mElasticLastLabel = DialogUtil.createLabel(this, REG_RANGE_LAST_EDIT);
        this.mElasticValueLabel = DialogUtil.createLabel(this, REG_RANGE_SINGLE_VALUE_EDIT);
        this.mElasticFirstLabel.setLabelFor((Component)this.mRangeFirstTextField);
        this.mElasticLastLabel.setLabelFor((Component)this.mRangeLastTextField);
        this.mElasticValueLabel.setLabelFor((Component)this.mSingleValueTextField);
        this.mBasicACRWidget = new BasicACRWidget(BASIC_ACR_WIDGET_KEY);
        this.mBasicACRWidget.getList().setSelectionMode(2);
        this.mBasicACRWidget.addBasicACRListener(this);
        this.mBasicACRWidget.setChangeMnemonic(72);
        this.mBasicACRWidget.setRemoveMnemonic(69);
    }

    private FloatTextField createFloatTextField(double d, double d2, int n, boolean bl, String string) {
        FloatTextField floatTextField = new FloatTextField(d, d2, n, bl);
        floatTextField.setColumns(5);
        floatTextField.getDocument().addDocumentListener(this);
        floatTextField.setAction((Action)new TextFieldAction(this, string));
        floatTextField.addFocusListener((FocusListener)this);
        return floatTextField;
    }

    @Override
    public boolean continuePressed() {
        int n;
        if (this.mMethodRidgeRadio.isSelected()) {
            if (!this.validateMinMaxValue(this.mRidgeMinTextField, this.mRidgeMaxTextField)) {
                return false;
            }
            if (!this.validateIncrement(this.mRidgeIncrTextField)) {
                return false;
            }
        }
        if (this.mMethodLassoRadio.isSelected()) {
            if (!this.validateMinMaxValue(this.mLassoMinTextField, this.mLassoMaxTextField)) {
                return false;
            }
            if (!this.validateIncrement(this.mLassoIncrTextField)) {
                return false;
            }
        }
        if (this.mMethodElasticNetRadio.isSelected()) {
            if (!this.validateMinMaxValue(this.mEnetRidgeMinTextField, this.mEnetRidgeMaxTextField)) {
                return false;
            }
            if (!this.validateIncrement(this.mEnetRidgeIncrTextField)) {
                return false;
            }
            if (!this.validateMinMaxValue(this.mEnetLassoMinTextField, this.mEnetLassoMaxTextField)) {
                return false;
            }
            if (!this.validateIncrement(this.mEnetLassoIncrTextField)) {
                return false;
            }
        }
        if (this.mRangeOfValuesRadio.isEnabled() && this.mRangeOfValuesRadio.isSelected() && this.mRangeFirstTextField.getText().length() > 0) {
            if (this.mRangeLastTextField.getText().length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_PENALTY_VALUE_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
                this.mRangeFirstTextField.selectAll();
                this.mRangeFirstTextField.requestFocus();
                return false;
            }
            if (this.isRangeInvalid(this.mRangeFirstTextField.getText(), this.mRangeLastTextField.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_PENALTY_VALUE_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
                this.mRangeLastTextField.selectAll();
                this.mRangeLastTextField.requestFocus();
                return false;
            }
        }
        if (this.mSingleValueRadio.isEnabled() && this.mSingleValueRadio.isSelected() && this.mSingleValueTextField.getText().length() > 0 && this.isSingleValueInvalid(this.mSingleValueTextField.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_PENALTY_VALUE_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
            this.mSingleValueTextField.requestFocus();
            this.mSingleValueTextField.selectAll();
            return false;
        }
        if (this.mRangeOfValuesRadio.isEnabled() && this.mRangeOfValuesRadio.isSelected() && this.mBasicACRWidget.getListItemCount() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_NO_RIDGE_PENALTY_VALUES"), VersionInfo.getAppVersionString());
            this.mRangeFirstTextField.requestFocus();
            this.mRangeFirstTextField.selectAll();
            return false;
        }
        if (this.mSingleValueRadio.isEnabled() && this.mSingleValueRadio.isSelected() && this.mBasicACRWidget.getListItemCount() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_NO_RIDGE_PENALTY_VALUES"), VersionInfo.getAppVersionString());
            this.mSingleValueTextField.requestFocus();
            this.mSingleValueTextField.selectAll();
            return false;
        }
        if (!this.validatePenaltyValuesList()) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_PENALTY_LIST_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
            return false;
        }
        if ((this.mBasicACRWidget.isAddEnabled() || this.mBasicACRWidget.isChangeEnabled()) && (n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_OS_PENDING_ADD_CHANGE_ERR"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) == 3) {
            if (this.mBasicACRWidget.isAddEnabled()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptimalScalingRegularization.this.mContinueButton.requestFocus();
                    }
                });
            } else if (this.mBasicACRWidget.isChangeEnabled()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptimalScalingRegularization.this.mContinueButton.requestFocus();
                    }
                });
            }
            return false;
        }
        return super.continuePressed();
    }

    private boolean validatePenaltyValuesList() {
        boolean bl = true;
        for (int i = 0; i < this.mBasicACRWidget.getListItemCount() && bl; ++i) {
            String string = (String)this.mBasicACRWidget.getListItemAt(i);
            if (string.contains(HYPHEN)) {
                String string2;
                String string3 = string.substring(0, string.indexOf(SPACE));
                if (!this.isRangeInvalid(string3, string2 = string.substring(string.indexOf(SPACE) + 3, string.length()))) continue;
                this.mBasicACRWidget.setListSelectedIndex(i);
                return false;
            }
            if (!this.isSingleValueInvalid(string)) continue;
            this.mBasicACRWidget.setListSelectedIndex(i);
            return false;
        }
        return bl;
    }

    private boolean validateMinMaxValue(FloatTextField floatTextField, FloatTextField floatTextField2) {
        if (floatTextField.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_NO_MIN_VALUE"), VersionInfo.getAppVersionString());
            floatTextField.selectAll();
            floatTextField.requestFocus();
            return false;
        }
        if (floatTextField2.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_NO_MAX_VALUE"), VersionInfo.getAppVersionString());
            floatTextField2.selectAll();
            floatTextField2.requestFocus();
            return false;
        }
        if (!this.minValueValid(floatTextField, floatTextField2)) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MIN_VALUE_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
            floatTextField.selectAll();
            floatTextField.requestFocus();
            return false;
        }
        return true;
    }

    private boolean validateIncrement(FloatTextField floatTextField) {
        if (floatTextField.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_NO_INCR_VALUE"), VersionInfo.getAppVersionString());
            floatTextField.selectAll();
            floatTextField.requestFocus();
            return false;
        }
        if (!this.incrValueValid(floatTextField)) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_INCR_VALUE_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
            floatTextField.selectAll();
            floatTextField.requestFocus();
            return false;
        }
        return true;
    }

    private boolean minValueValid(FloatTextField floatTextField, FloatTextField floatTextField2) {
        boolean bl = true;
        BigDecimal bigDecimal = new BigDecimal(floatTextField.getText());
        BigDecimal bigDecimal2 = new BigDecimal(floatTextField2.getText());
        BigDecimal bigDecimal3 = new BigDecimal(0.0);
        bl = bigDecimal.compareTo(bigDecimal3) >= 0 && bigDecimal.compareTo(bigDecimal2) <= 0;
        return bl;
    }

    private boolean maxValueValid(FloatTextField floatTextField, FloatTextField floatTextField2) {
        BigDecimal bigDecimal;
        boolean bl = true;
        BigDecimal bigDecimal2 = new BigDecimal(floatTextField.getText());
        BigDecimal bigDecimal3 = new BigDecimal(floatTextField2.getText());
        bl = bigDecimal3.compareTo(bigDecimal = new BigDecimal(0.0)) >= 0 && bigDecimal3.compareTo(bigDecimal2) >= 0;
        return bl;
    }

    private boolean incrValueValid(FloatTextField floatTextField) {
        BigDecimal bigDecimal;
        boolean bl = true;
        BigDecimal bigDecimal2 = new BigDecimal(floatTextField.getText());
        bl = bigDecimal2.compareTo(bigDecimal = new BigDecimal(0.0)) >= 0;
        return bl;
    }

    private boolean isRangeInvalid(String string, String string2) {
        BigDecimal bigDecimal = new BigDecimal(string);
        BigDecimal bigDecimal2 = new BigDecimal(string2);
        if (string2.compareTo(string) == -1) {
            return true;
        }
        BigDecimal bigDecimal3 = new BigDecimal(this.mEnetRidgeMinTextField.getText());
        BigDecimal bigDecimal4 = new BigDecimal(this.mEnetRidgeMaxTextField.getText());
        BigDecimal bigDecimal5 = new BigDecimal(this.mEnetRidgeIncrTextField.getText());
        if (bigDecimal.compareTo(bigDecimal3) < 0 || bigDecimal.compareTo(bigDecimal4) > 0) {
            return true;
        }
        if (!this.validatePenaltyValueIncrement(bigDecimal, bigDecimal3, bigDecimal4, bigDecimal5)) {
            return true;
        }
        if (bigDecimal2.compareTo(bigDecimal3) < 0 || bigDecimal2.compareTo(bigDecimal4) > 0) {
            return true;
        }
        return !this.validatePenaltyValueIncrement(bigDecimal2, bigDecimal3, bigDecimal4, bigDecimal5);
    }

    private boolean isSingleValueInvalid(String string) {
        BigDecimal bigDecimal = new BigDecimal(string);
        BigDecimal bigDecimal2 = new BigDecimal(this.mEnetRidgeMinTextField.getText());
        BigDecimal bigDecimal3 = new BigDecimal(this.mEnetRidgeMaxTextField.getText());
        BigDecimal bigDecimal4 = new BigDecimal(this.mEnetRidgeIncrTextField.getText());
        if (bigDecimal.compareTo(bigDecimal2) < 0 || bigDecimal.compareTo(bigDecimal3) > 0) {
            return true;
        }
        return !this.validatePenaltyValueIncrement(bigDecimal, bigDecimal2, bigDecimal3, bigDecimal4);
    }

    private boolean validatePenaltyValueIncrement(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, BigDecimal bigDecimal4) {
        boolean bl = false;
        BigDecimal bigDecimal5 = bigDecimal2;
        int n = 0;
        while (bigDecimal5.compareTo(bigDecimal3) <= 0 && !bl) {
            BigDecimal bigDecimal6 = new BigDecimal(n);
            bigDecimal5 = bigDecimal2.add(bigDecimal4.multiply(bigDecimal6));
            if (bigDecimal.compareTo(bigDecimal5) == 0) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private boolean processAddButtonPress() {
        boolean bl = false;
        if (this.mRangeOfValuesRadio.isSelected()) {
            if (this.isRangeInvalid(this.mRangeFirstTextField.getText(), this.mRangeLastTextField.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_PENALTY_VALUE_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
                this.mRangeFirstTextField.selectAll();
                this.mRangeFirstTextField.requestFocus();
                bl = true;
            }
            if (!bl) {
                String string = this.mRangeFirstTextField.getText() + SPACE + HYPHEN + SPACE + this.mRangeLastTextField.getText();
                this.mBasicACRWidget.addListItemAt(this.mBasicACRWidget.getListItemCount(), string);
                this.mRangeFirstTextField.setText(EMPTY_STR);
                this.mRangeLastTextField.setText(EMPTY_STR);
            }
        } else if (this.mSingleValueTextField.isEnabled()) {
            if (this.isSingleValueInvalid(this.mSingleValueTextField.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_PENALTY_VALUE_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
                this.mSingleValueTextField.selectAll();
                this.mSingleValueTextField.requestFocus();
                bl = true;
            } else {
                this.mBasicACRWidget.addListItemAt(this.mBasicACRWidget.getListItemCount(), this.mSingleValueTextField.getText());
                this.mSingleValueTextField.setText(EMPTY_STR);
            }
        }
        return bl;
    }

    private void addComponentsToPanel(JPanel jPanel) {
        double[] dArray = new double[]{-2.0, -1.0};
        double[] dArray2 = new double[]{-1.0, DialogUtil.getGroupBoxInnerMargin() * 2, -2.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        jPanel.setLayout((LayoutManager)tableLayout);
        tableLayout.setHGap(6);
        tableLayout.setVGap(6);
        jPanel.add((Component)this.createMethodPanel(), "0, 0, 0, 0");
        jPanel.add((Component)this.mDisplayRegPlotsCheck, "0, 2, 0, 0");
        jPanel.add((Component)this.createElasticPanel(), "1, 0, 0, 0");
    }

    private JPanel createMethodPanel() {
        JPanel jPanel = new JPanel();
        double[] dArray = new double[]{-1.0};
        double[] dArray2 = new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        jPanel.setLayout((LayoutManager)tableLayout);
        tableLayout.setHGap(6);
        tableLayout.setVGap(6);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OS_REG_METHOD_LABEL")));
        jPanel.add((Component)this.mMethodNoneRadio, "0, 0, 0, 0");
        jPanel.add((Component)this.mMethodRidgeRadio, "0, 1, 0, 0");
        jPanel.add((Component)this.createMinMaxIncrSubPanel(0, this.mRidgeMinTextField, this.mRidgeMaxTextField, this.mRidgeIncrTextField), "0, 2, 0, 0");
        jPanel.add((Component)this.mMethodLassoRadio, "0, 3, 0, 0");
        jPanel.add((Component)this.createMinMaxIncrSubPanel(1, this.mLassoMinTextField, this.mLassoMaxTextField, this.mLassoIncrTextField), "0, 4, 0, 0");
        jPanel.add((Component)this.mMethodElasticNetRadio, "0, 5, 0, 0");
        jPanel.add((Component)this.createEnetSubPanel(), "0, 6, 0, 0");
        return jPanel;
    }

    private JPanel createMinMaxIncrSubPanel(int n, FloatTextField floatTextField, FloatTextField floatTextField2, FloatTextField floatTextField3) {
        JPanel jPanel = new JPanel();
        double[] dArray = new double[]{DialogUtil.getGroupBoxInnerMargin() * 2, -2.0, -2.0, -2.0};
        double[] dArray2 = new double[]{-2.0, -2.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        tableLayout.setHGap(DialogUtil.getGroupBoxInnerMargin() * 2);
        tableLayout.setVGap(DialogUtil.getGroupBoxInnerMargin());
        jPanel.setLayout((LayoutManager)tableLayout);
        JLabel jLabel = n == 0 ? this.mRidgeMinLabel : this.mLassoMinLabel;
        JLabel jLabel2 = n == 0 ? this.mRidgeMaxLabel : this.mLassoMaxLabel;
        JLabel jLabel3 = n == 0 ? this.mRidgeIncrLabel : this.mLassoIncrLabel;
        jPanel.add((Component)jLabel, "1, 0, 0, 0");
        jPanel.add((Component)floatTextField, "1, 1, 0, 0");
        jPanel.add((Component)jLabel2, "2, 0, 0, 0");
        jPanel.add((Component)floatTextField2, "2, 1, 0, 0");
        jPanel.add((Component)jLabel3, "3, 0, 0, 0");
        jPanel.add((Component)floatTextField3, "3, 1, 0, 0");
        return jPanel;
    }

    private JPanel createEnetSubPanel() {
        JPanel jPanel = new JPanel();
        double[] dArray = new double[]{DialogUtil.getGroupBoxInnerMargin() * 2, -2.0, -2.0, -2.0, -2.0, DialogUtil.getGroupBoxInnerMargin() * 2};
        double[] dArray2 = new double[]{-2.0, -2.0, -2.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        tableLayout.setHGap(DialogUtil.getGroupBoxInnerMargin() * 2);
        tableLayout.setVGap(DialogUtil.getGroupBoxInnerMargin());
        jPanel.setLayout((LayoutManager)tableLayout);
        jPanel.add((Component)this.mEnetRidgeLabel, "1, 1, 0, 0");
        jPanel.add((Component)this.mEnetLassoLabel, "1, 2, 0, 0");
        jPanel.add((Component)this.mEnetMinLabel, "2, 0, 0, 0");
        jPanel.add((Component)this.mEnetRidgeMinTextField, "2, 1, 0, 0");
        jPanel.add((Component)this.mEnetMaxLabel, "3, 0, 0, 0");
        jPanel.add((Component)this.mEnetRidgeMaxTextField, "3, 1, 0, 0");
        jPanel.add((Component)this.mEnetIncrLabel, "4, 0, 0, 0");
        jPanel.add((Component)this.mEnetRidgeIncrTextField, "4, 1, 0, 0");
        jPanel.add((Component)this.mEnetLassoMinTextField, "2, 2, 0, 0");
        jPanel.add((Component)this.mEnetLassoMaxTextField, "3, 2, 0, 0");
        jPanel.add((Component)this.mEnetLassoIncrTextField, "4, 2, 0, 0");
        return jPanel;
    }

    private JPanel createElasticPanel() {
        JPanel jPanel = new JPanel();
        double[] dArray = new double[]{-2.0, -2.0};
        double[] dArray2 = new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -2.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        jPanel.setLayout((LayoutManager)tableLayout);
        tableLayout.setHGap(6);
        tableLayout.setVGap(6);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OS_REG_ELASTIC_NET_PLOTS")));
        jPanel.add((Component)this.mElasticProduceAllPlotsRadio, "0, 0, 0, 0");
        jPanel.add((Component)this.mElasticProduceSomePlotsRadio, "0, 1, 0, 0");
        jPanel.add((Component)this.createPenaltiesSubPanel(), "0, 2, 0, 0");
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        DialogUtil.applyTopBorder(jPanel3);
        DialogUtil.applyTopBorder(jPanel4);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_OS_REG_RIDGE_PENALTY");
        double[] dArray3 = new double[]{DialogUtil.getGroupBoxInnerMargin(), -2.0, -1.0};
        double[] dArray4 = new double[]{-2.0};
        TableLayout tableLayout2 = new TableLayout(dArray3, dArray4);
        jPanel2.setLayout((LayoutManager)tableLayout2);
        tableLayout2.setHGap(6);
        tableLayout2.setVGap(6);
        jPanel2.add((Component)jPanel3, "0, 0, 0, 0");
        jPanel2.add((Component)jLabel, "1, 0, 0, 0");
        jPanel2.add((Component)jPanel4, "2, 0, 0, 0");
        jPanel.add((Component)jPanel2, "0, 3, 0, 0");
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_OS_REG_LIST_OF_PENALTY_VALS");
        JPanel jPanel5 = new JPanel();
        double[] dArray5 = new double[]{100.0, -2.0};
        double[] dArray6 = new double[]{-2.0};
        TableLayout tableLayout3 = new TableLayout(dArray5, dArray6);
        jPanel5.setLayout((LayoutManager)tableLayout3);
        tableLayout3.setHGap(6);
        tableLayout3.setVGap(6);
        jPanel5.add((Component)jLabel2, "1,0,0,0");
        jPanel.add((Component)jPanel5, "0, 4, 0, 0");
        jPanel.add((Component)this.mBasicACRWidget, "0, 5, 0, 0");
        return jPanel;
    }

    private JPanel createPenaltiesSubPanel() {
        JPanel jPanel = new JPanel();
        double[] dArray = new double[]{DialogUtil.getGroupBoxInnerMargin() * 2, -2.0};
        double[] dArray2 = new double[]{-2.0, -2.0, -2.0, -2.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        tableLayout.setHGap(DialogUtil.getGroupBoxInnerMargin() * 2);
        tableLayout.setVGap(DialogUtil.getGroupBoxInnerMargin());
        jPanel.setLayout((LayoutManager)tableLayout);
        jPanel.add((Component)this.mRangeOfValuesRadio, "1, 0, 0, 0");
        JPanel jPanel2 = new JPanel();
        double[] dArray3 = new double[]{DialogUtil.getGroupBoxInnerMargin() * 4, -2.0, -2.0};
        double[] dArray4 = new double[]{-2.0, -2.0};
        TableLayout tableLayout2 = new TableLayout(dArray3, dArray4);
        tableLayout2.setHGap(DialogUtil.getGroupBoxInnerMargin() * 2);
        tableLayout2.setVGap(DialogUtil.getGroupBoxInnerMargin());
        jPanel2.setLayout((LayoutManager)tableLayout2);
        jPanel2.add((Component)this.mElasticFirstLabel, "1, 0, 0, 0");
        jPanel2.add((Component)this.mRangeFirstTextField, "2, 0, 0, 0");
        jPanel2.add((Component)this.mElasticLastLabel, "1, 1, 0, 0");
        jPanel2.add((Component)this.mRangeLastTextField, "2, 1, 0, 0");
        jPanel.add((Component)jPanel2, "1, 1, 0, 0");
        jPanel.add((Component)this.mSingleValueRadio, "1, 2, 0, 0");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)tableLayout2);
        jPanel3.add((Component)this.mElasticValueLabel, "1, 0, 0, 0");
        jPanel3.add((Component)this.mSingleValueTextField, "2, 0, 0, 0");
        jPanel.add((Component)jPanel3, "1, 3, 0, 0");
        return jPanel;
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMethodNoneRadio);
        vector.add(this.mMethodRidgeRadio);
        vector.add(this.mRidgeMinTextField);
        vector.add(this.mRidgeMaxTextField);
        vector.add(this.mRidgeIncrTextField);
        vector.add(this.mMethodLassoRadio);
        vector.add(this.mLassoMinTextField);
        vector.add(this.mLassoMaxTextField);
        vector.add(this.mLassoIncrTextField);
        vector.add(this.mMethodElasticNetRadio);
        vector.add(this.mEnetRidgeMinTextField);
        vector.add(this.mEnetRidgeMaxTextField);
        vector.add(this.mEnetRidgeIncrTextField);
        vector.add(this.mEnetLassoMinTextField);
        vector.add(this.mEnetLassoMaxTextField);
        vector.add(this.mEnetLassoIncrTextField);
        vector.add(this.mDisplayRegPlotsCheck);
        vector.add(this.mElasticProduceAllPlotsRadio);
        vector.add(this.mElasticProduceSomePlotsRadio);
        vector.add(this.mRangeOfValuesRadio);
        vector.add(this.mRangeFirstTextField);
        vector.add(this.mRangeLastTextField);
        vector.add(this.mSingleValueRadio);
        vector.add(this.mSingleValueTextField);
        Component[] componentArray = new Component[3];
        for (n = 0; n < this.mBasicACRWidget.getComponentCount() - 1; ++n) {
            componentArray[n] = this.mBasicACRWidget.getComponent(n);
        }
        vector.add(componentArray[0]);
        vector.add(componentArray[1]);
        vector.add(componentArray[2]);
        vector.add(this.mBasicACRWidget.getList());
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

