/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.optimal_scaling;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingDlg;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class OptimalScalingPlots
extends BaseSubDialog
implements FocusListener,
IVarMoveHandler {
    static final String PLOTS_TRANSFORMATION_LIST_KEY = "PLOTS_TRANSFORMATION_LIST_KEY";
    static final String PLOTS_RESIDUAL_LIST_KEY = "PLOTS_RESIDUAL_LIST_KEY";
    private TargetVariableList mSrcVariableList;
    private TargetVariableList mTransformationPlotsList;
    private TargetVariableList mResidualPlotsList;
    private JScrollPane mVariableScrollPane;
    private JScrollPane mTransformationPlotsScrollPane;
    private JScrollPane mResidualPlotsScrollPane;
    private ArrowButton mTransformationPlotsArrowButton;
    private ArrowButton mResidualPlotsArrowButton;
    private JLabel mTransformationPlotsLabel;
    private JLabel mResidualPlotsLabel;
    private int[] mTransformationSelectedIndices;
    private int[] mResidualplotsSelectedIndices;
    private ISpssVariable mDependentVar;

    OptimalScalingPlots(OptimalScalingDlg optimalScalingDlg) {
        super(optimalScalingDlg, optimalScalingDlg.getResString("IDS_OS_PLOTS_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_catr_plot";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mTransformationPlotsList)) {
            if (this.mTransformationSelectedIndices != null) {
                this.mTransformationPlotsList.setSelectedIndices(this.mTransformationSelectedIndices);
                this.mTransformationSelectedIndices = null;
            }
            this.mTransformationPlotsArrowButton.setEnabled(true);
            this.mResidualPlotsArrowButton.setEnabled(false);
        } else if (focusEvent.getSource().equals(this.mResidualPlotsList)) {
            if (this.mResidualplotsSelectedIndices != null) {
                this.mResidualPlotsList.setSelectedIndices(this.mResidualplotsSelectedIndices);
                this.mResidualplotsSelectedIndices = null;
            }
            this.mResidualPlotsArrowButton.setEnabled(true);
            this.mTransformationPlotsArrowButton.setEnabled(false);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        if (variableList.equals(this.mResidualPlotsList) && this.mDependentVar != null) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                SpssVariable spssVariable = (SpssVariable)iSpssVariable;
                if (!spssVariable.getId().equals((Object)this.mDependentVar.getId())) continue;
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_OS_RESIDUAL_PLOTS_DEPENDENT_VAR_INFO_MESSAGE"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        return true;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        ISpssVariable iSpssVariable;
        int n;
        int n2;
        super.loadState(dialogDataModel);
        TargetVariableList targetVariableList = ((OptimalScalingDlg)this.mParentDlg).getDependentVarList();
        TargetVariableList targetVariableList2 = ((OptimalScalingDlg)this.mParentDlg).getIndependentVarList();
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        for (int i = 0; i < this.mSrcVariableList.getModel().getSize(); ++i) {
            ISpssVariable iSpssVariable2 = this.mSrcVariableList.getModel().getElementAt(i);
            n2 = iSpssVariable2.getId().asInt();
            if (this.isItemPresent(n2, targetVariableList) || this.isItemPresent(n2, targetVariableList2)) continue;
            vector.add(iSpssVariable2);
        }
        for (ISpssVariable iSpssVariable2 : vector) {
            this.mSrcVariableList.getModel().removeElement(iSpssVariable2);
            if (this.isItemPresent(iSpssVariable2.getId().asInt(), this.mTransformationPlotsList)) {
                this.mTransformationPlotsList.getModel().removeElement(iSpssVariable2);
            }
            if (!this.isItemPresent(iSpssVariable2.getId().asInt(), this.mResidualPlotsList)) continue;
            this.mResidualPlotsList.getModel().removeElement(iSpssVariable2);
        }
        for (n = 0; n < targetVariableList.getModel().getSize(); ++n) {
            this.mDependentVar = targetVariableList.getModel().getElementAt(n);
            int n3 = this.mDependentVar.getId().asInt();
            if (this.isItemPresent(n3, this.mSrcVariableList)) continue;
            this.mSrcVariableList.getModel().insertElementAt(this.mDependentVar, 0);
        }
        for (n = 0; n < targetVariableList2.getModel().getSize(); ++n) {
            ISpssVariable iSpssVariable3 = targetVariableList2.getModel().getElementAt(n);
            n2 = iSpssVariable3.getId().asInt();
            if (this.isItemPresent(n2, this.mSrcVariableList)) continue;
            this.mSrcVariableList.getModel().addElement(iSpssVariable3);
        }
        n = this.mSrcVariableList.getModel().getSize();
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[n];
        for (n2 = 0; n2 < n; ++n2) {
            iSpssVariableArray[n2] = iSpssVariable = this.mSrcVariableList.getModel().getElementAt(n2);
        }
        dialogDataModel.putVarArray(this.mSrcVariableList.getIdentifier(), iSpssVariableArray);
        n = this.mTransformationPlotsList.getModel().getSize();
        iSpssVariableArray = new ISpssVariable[n];
        for (n2 = 0; n2 < n; ++n2) {
            iSpssVariableArray[n2] = iSpssVariable = this.mTransformationPlotsList.getModel().getElementAt(n2);
        }
        dialogDataModel.putVarArray(this.mTransformationPlotsList.getIdentifier(), iSpssVariableArray);
        n = this.mResidualPlotsList.getModel().getSize();
        iSpssVariableArray = new ISpssVariable[n];
        for (n2 = 0; n2 < n; ++n2) {
            iSpssVariableArray[n2] = iSpssVariable = this.mResidualPlotsList.getModel().getElementAt(n2);
        }
        dialogDataModel.putVarArray(this.mResidualPlotsList.getIdentifier(), iSpssVariableArray);
        if (this.mSrcVariableList.getModel().getSize() > 0) {
            this.mSrcVariableList.setSelectedIndex(0);
        } else {
            this.mTransformationPlotsArrowButton.setEnabled(false);
            this.mResidualPlotsArrowButton.setEnabled(false);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.addComponentsToPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private boolean isItemPresent(int n, TargetVariableList targetVariableList) {
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            int n2 = targetVariableList.getModel().getElementAt(i).getId().asInt();
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    private void initVars() {
        this.mSrcVariableList = new TargetVariableList();
        this.mSrcVariableList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mSrcVariableList.getFixedCellHeight() * 17 + 2));
        this.mSrcVariableList.setDataSource(true);
        this.mSrcVariableList.setShowIcon(false);
        this.mSrcVariableList.setIdentifier("PLOTS_SOURCE_LIST_KEY");
        this.mVariableScrollPane = new JScrollPane(this.mSrcVariableList);
        this.mVariableScrollPane.setPreferredSize(this.mSrcVariableList.getMinimumSize());
        this.mTransformationPlotsList = new TargetVariableList();
        this.mTransformationPlotsList.setAllowDuplicates(false);
        this.mTransformationPlotsList.setShowIcon(false);
        this.mTransformationPlotsList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mTransformationPlotsList.addFocusListener(this);
        this.mTransformationPlotsList.setIdentifier(PLOTS_TRANSFORMATION_LIST_KEY);
        this.mTransformationPlotsList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTransformationPlotsList.getFixedCellHeight() * 6 + 2));
        this.mTransformationPlotsScrollPane = new JScrollPane(this.mTransformationPlotsList);
        this.mTransformationPlotsScrollPane.setPreferredSize(this.mTransformationPlotsList.getMinimumSize());
        this.mTransformationPlotsLabel = DialogUtil.createLabel(this, "IDS_OS_TRANSFORMATION_PLOTS_LABEL");
        this.mTransformationPlotsLabel.setLabelFor(this.mTransformationPlotsList);
        this.mResidualPlotsList = new TargetVariableList();
        this.mResidualPlotsList.setAllowDuplicates(false);
        this.mResidualPlotsList.setShowIcon(false);
        this.mResidualPlotsList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mResidualPlotsList.addFocusListener(this);
        this.mResidualPlotsList.setIdentifier(PLOTS_RESIDUAL_LIST_KEY);
        this.mResidualPlotsList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mResidualPlotsList.getFixedCellHeight() * 6 + 2));
        this.mResidualPlotsScrollPane = new JScrollPane(this.mResidualPlotsList);
        this.mResidualPlotsScrollPane.setPreferredSize(this.mResidualPlotsList.getMinimumSize());
        this.mResidualPlotsLabel = DialogUtil.createLabel(this, "IDS_OS_RESIDUAL_PLOTS_LABEL");
        this.mResidualPlotsLabel.setLabelFor(this.mResidualPlotsList);
        this.mTransformationPlotsArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTransformationPlotsArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mTransformationPlotsArrowButton.registerVariableList(this.mTransformationPlotsList, SpssArrowButton.ButtonOrientation.left);
        this.mResidualPlotsArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mResidualPlotsArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mResidualPlotsArrowButton.registerVariableList(this.mResidualPlotsList, SpssArrowButton.ButtonOrientation.left);
        this.mResidualPlotsArrowButton.setVarMoveHandler(this);
        this.mVarMoveHandler = this;
    }

    private void addComponentsToPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_OS_VARIABLELIST_LABEL");
        jLabel.setLabelFor(this.mSrcVariableList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mVariableScrollPane, gridBagConstraints, 0, 1, 1, 3, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mTransformationPlotsArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mResidualPlotsArrowButton, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTransformationPlotsLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTransformationPlotsScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mResidualPlotsLabel, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mResidualPlotsScrollPane, gridBagConstraints, 2, 3, 1, 1, n, null);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVariableList);
        vector.add(this.mTransformationPlotsArrowButton);
        vector.add(this.mResidualPlotsArrowButton);
        vector.add(this.mTransformationPlotsList);
        vector.add(this.mResidualPlotsList);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

