/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.optimal_scaling;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingDlg;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class OptimalScalingOutput
extends BaseSubDialog
implements FocusListener,
ItemListener {
    static final String MULTIPLE_R = "IDS_OS_MULTIPLE_R";
    static final String CO_EFFICIENTS = "IDS_OS_CO_EFFICIENTS";
    static final String ITERATION_HISTORY = "IDS_OS_ITERATION_HISTORY";
    static final String CORRELATION_ORIG_VARS = "IDS_OS_CORRELATION_ORIG_VARS";
    static final String CORRELATION_TRANS_VARS = "IDS_OS_CORRELATION_TRANS_VARS";
    static final String ANOVA = "IDS_OS_ANOVA";
    static final String REGULARIZED_MODELS_CHECK = "IDS_OS_OUTPUT_REGULARIZED_MODELS";
    static final String RESAMPLING_NONE_RADIO = "IDS_OS_OUTPUT_NONE";
    static final String RESAMPLING_CROSSVALIDATION_RADIO = "IDS_OS_OUTPUT_CROSSVALIDATION";
    static final String RESAMPLING_632BOOTSTRAP_RADIO = "IDS_OS_OUTPUT_632_BOOTSTRAP";
    static final String RESAMPLING_NUM_FOLDS_TEXT = "IDS_OS_OUTPUT_NUM_FOLDS";
    static final String RESAMPLING_NUM_SAMPLES_TEXT = "IDS_OS_OUTPUT_NUM_SAMPLES";
    static final String OUTPUT_ANALYSIS_LIST_KEY = "OUTPUT_ANALYSIS_LIST_KEY";
    static final String OUTPUT_CATEGORY_LIST_KEY = "OUTPUT_CATEGORY_LIST_KEY";
    static final String OUTPUT_DESCRIPTIVES_LIST_KEY = "OUTPUT_DESCRIPTIVES_LIST_KEY";
    static final String DEFAULT_NUM_FOLDS = "10";
    static final String DEFAULT_NUM_SAMPLES = "50";
    private JCheckBox mMultipleRCheckBox;
    private JCheckBox mCoefficientsCheckBox;
    private JCheckBox mIterationHistoryCheckBox;
    private JCheckBox mCorrelationOrigVarCheckBox;
    private JCheckBox mCorrelationTransVarCheckBox;
    private JCheckBox mAnovaCheckBox;
    private JCheckBox mRegularizedModelsCheckBox;
    private JRadioButton mResamplingNoneRadio;
    private JRadioButton mResamplingCrossvalidationRadio;
    private JRadioButton mResampling632BootstrapRadio;
    private SpssButtonGroup mResamplingRadioGroup;
    private IntTextField mNumFoldsTextField;
    private JLabel mNumFoldsLabel;
    private IntTextField mNumSamplesTextField;
    private JLabel mNumSamplesLabel;
    private TargetVariableList mSrcAnalysisVariableList;
    private TargetVariableList mCategoryQuantificationList;
    private TargetVariableList mDescriptivesStatisticsList;
    private JScrollPane mAnalysisVariableScrollPane;
    private JScrollPane mCategoryQuantificationScrollPane;
    private JScrollPane mDescriptivesStatisticsScrollPane;
    private ArrowButton mCategoryArrowButton;
    private ArrowButton mDescriptivesArrowButton;
    private JLabel mAnalysisVariablesLabel;
    private JLabel mCategoryQuantificationLabel;
    private JLabel mDescriptivesStatisticsLabel;

    OptimalScalingOutput(OptimalScalingDlg optimalScalingDlg) {
        super(optimalScalingDlg, optimalScalingDlg.getResString("IDS_OS_OUTPUT_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_catr_output";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mSrcAnalysisVariableList)) {
            this.mDescriptivesArrowButton.setEnabled(true);
            this.mCategoryArrowButton.setEnabled(true);
        } else if (focusEvent.getSource().equals(this.mCategoryQuantificationList)) {
            this.mCategoryArrowButton.setEnabled(true);
            this.mDescriptivesArrowButton.setEnabled(false);
        } else if (focusEvent.getSource().equals(this.mDescriptivesStatisticsList)) {
            this.mDescriptivesArrowButton.setEnabled(true);
            this.mCategoryArrowButton.setEnabled(false);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mResamplingNoneRadio) || itemEvent.getSource().equals(this.mResamplingCrossvalidationRadio) || itemEvent.getSource().equals(this.mResampling632BootstrapRadio)) {
            boolean bl = this.mResamplingCrossvalidationRadio.isSelected();
            this.mNumFoldsLabel.setEnabled(bl);
            this.mNumFoldsTextField.setEnabled(bl);
            this.mNumFoldsTextField.setOpaque(bl);
            bl = this.mResampling632BootstrapRadio.isSelected();
            this.mNumSamplesLabel.setEnabled(bl);
            this.mNumSamplesTextField.setEnabled(bl);
            this.mNumSamplesTextField.setOpaque(bl);
        }
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        ISpssVariable iSpssVariable;
        int n;
        int n2;
        super.loadState(dialogDataModel);
        TargetVariableList targetVariableList = ((OptimalScalingDlg)this.mParentDlg).getDependentVarList();
        TargetVariableList targetVariableList2 = ((OptimalScalingDlg)this.mParentDlg).getIndependentVarList();
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        for (int i = 0; i < this.mSrcAnalysisVariableList.getModel().getSize(); ++i) {
            ISpssVariable iSpssVariable22 = this.mSrcAnalysisVariableList.getModel().getElementAt(i);
            n2 = iSpssVariable22.getId().asInt();
            if (this.isItemPresent(n2, targetVariableList) || this.isItemPresent(n2, targetVariableList2)) continue;
            vector.add(iSpssVariable22);
        }
        for (ISpssVariable iSpssVariable2 : vector) {
            this.mSrcAnalysisVariableList.getModel().removeElement(iSpssVariable2);
            if (this.isItemPresent(iSpssVariable2.getId().asInt(), this.mCategoryQuantificationList)) {
                this.mCategoryQuantificationList.getModel().removeElement(iSpssVariable2);
            }
            if (!this.isItemPresent(iSpssVariable2.getId().asInt(), this.mDescriptivesStatisticsList)) continue;
            this.mDescriptivesStatisticsList.getModel().removeElement(iSpssVariable2);
        }
        for (n = 0; n < targetVariableList.getModel().getSize(); ++n) {
            ISpssVariable iSpssVariable3 = targetVariableList.getModel().getElementAt(n);
            n2 = iSpssVariable3.getId().asInt();
            if (this.isItemPresent(n2, this.mSrcAnalysisVariableList)) continue;
            this.mSrcAnalysisVariableList.getModel().insertElementAt(iSpssVariable3, 0);
        }
        for (n = 0; n < targetVariableList2.getModel().getSize(); ++n) {
            ISpssVariable iSpssVariable4 = targetVariableList2.getModel().getElementAt(n);
            n2 = iSpssVariable4.getId().asInt();
            if (this.isItemPresent(n2, this.mSrcAnalysisVariableList)) continue;
            this.mSrcAnalysisVariableList.getModel().addElement(iSpssVariable4);
        }
        n = this.mSrcAnalysisVariableList.getModel().getSize();
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[n];
        for (n2 = 0; n2 < n; ++n2) {
            iSpssVariableArray[n2] = iSpssVariable = this.mSrcAnalysisVariableList.getModel().getElementAt(n2);
        }
        dialogDataModel.putVarArray(this.mSrcAnalysisVariableList.getIdentifier(), iSpssVariableArray);
        n = this.mCategoryQuantificationList.getModel().getSize();
        ISpssVariable[] iSpssVariableArray2 = new ISpssVariable[n];
        for (n2 = 0; n2 < n; ++n2) {
            iSpssVariableArray2[n2] = iSpssVariable = this.mCategoryQuantificationList.getModel().getElementAt(n2);
        }
        dialogDataModel.putVarArray(this.mCategoryQuantificationList.getIdentifier(), iSpssVariableArray2);
        n = this.mDescriptivesStatisticsList.getModel().getSize();
        ISpssVariable[] iSpssVariableArray3 = new ISpssVariable[n];
        for (n2 = 0; n2 < n; ++n2) {
            iSpssVariableArray3[n2] = iSpssVariable = this.mDescriptivesStatisticsList.getModel().getElementAt(n2);
        }
        dialogDataModel.putVarArray(this.mDescriptivesStatisticsList.getIdentifier(), iSpssVariableArray3);
        this.mCategoryArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
        this.mCategoryArrowButton.setEnabled(false);
        this.mDescriptivesArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
        this.mDescriptivesArrowButton.setEnabled(false);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponentsToPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    public boolean continuePressed() {
        if (this.mResamplingCrossvalidationRadio.isSelected() && this.mNumFoldsTextField.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_ENTER_A_VAL_FOLDS"), VersionInfo.getAppVersionString());
            this.mNumFoldsTextField.requestFocus();
            return false;
        }
        if (this.mResamplingCrossvalidationRadio.isSelected() && this.isTextZero(this.mNumFoldsTextField.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_FOLDS_POS_INTEGER"), VersionInfo.getAppVersionString());
            this.mNumFoldsTextField.requestFocus();
            this.mNumFoldsTextField.selectAll();
            return false;
        }
        if (this.mResampling632BootstrapRadio.isSelected() && this.mNumSamplesTextField.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_ENTER_A_VAL_SAMPLES"), VersionInfo.getAppVersionString());
            this.mNumSamplesTextField.requestFocus();
            return false;
        }
        if (this.mResampling632BootstrapRadio.isSelected() && this.isTextZero(this.mNumSamplesTextField.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_SAMPLES_POS_INTEGER"), VersionInfo.getAppVersionString());
            this.mNumSamplesTextField.requestFocus();
            this.mNumSamplesTextField.selectAll();
            return false;
        }
        return super.continuePressed();
    }

    private boolean isTextZero(String string) {
        Integer n = new Integer(string);
        return 0 == n;
    }

    private boolean isItemPresent(int n, TargetVariableList targetVariableList) {
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            int n2 = targetVariableList.getModel().getElementAt(i).getId().asInt();
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, MULTIPLE_R);
        this.mMultipleRCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, CO_EFFICIENTS);
        this.mCoefficientsCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, ITERATION_HISTORY);
        this.mIterationHistoryCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, CORRELATION_ORIG_VARS);
        this.mCorrelationOrigVarCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, CORRELATION_TRANS_VARS);
        this.mCorrelationTransVarCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, ANOVA);
        this.mAnovaCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, REGULARIZED_MODELS_CHECK);
        this.mRegularizedModelsCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, RESAMPLING_NONE_RADIO);
        this.mResamplingNoneRadio = new JRadioButton(toggleButtonAction);
        this.mResamplingNoneRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, RESAMPLING_CROSSVALIDATION_RADIO);
        this.mResamplingCrossvalidationRadio = new JRadioButton(toggleButtonAction);
        this.mResamplingCrossvalidationRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, RESAMPLING_632BOOTSTRAP_RADIO);
        this.mResampling632BootstrapRadio = new JRadioButton(toggleButtonAction);
        this.mResampling632BootstrapRadio.addItemListener(this);
        this.mResamplingRadioGroup = new SpssButtonGroup();
        this.mResamplingRadioGroup.add(this.mResamplingNoneRadio);
        this.mResamplingRadioGroup.add(this.mResamplingCrossvalidationRadio);
        this.mResamplingRadioGroup.add(this.mResampling632BootstrapRadio);
        this.mNumFoldsTextField = new IntTextField(true);
        this.mNumFoldsTextField.setColumns(5);
        this.mNumFoldsTextField.setAction((Action)new TextFieldAction(this, RESAMPLING_NUM_FOLDS_TEXT));
        this.mNumFoldsLabel = DialogUtil.createLabel(this, RESAMPLING_NUM_FOLDS_TEXT);
        this.mNumFoldsLabel.setLabelFor((Component)this.mNumFoldsTextField);
        this.mNumSamplesTextField = new IntTextField(true);
        this.mNumSamplesTextField.setColumns(5);
        this.mNumSamplesTextField.setAction((Action)new TextFieldAction(this, RESAMPLING_NUM_SAMPLES_TEXT));
        this.mNumSamplesLabel = DialogUtil.createLabel(this, RESAMPLING_NUM_SAMPLES_TEXT);
        this.mNumSamplesLabel.setLabelFor((Component)this.mNumSamplesTextField);
        this.mSrcAnalysisVariableList = new TargetVariableList();
        this.mSrcAnalysisVariableList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mSrcAnalysisVariableList.getFixedCellHeight() * 12 + 2));
        this.mSrcAnalysisVariableList.setIdentifier(OUTPUT_ANALYSIS_LIST_KEY);
        this.mSrcAnalysisVariableList.addFocusListener(this);
        this.mSrcAnalysisVariableList.setDataSource(true);
        this.mSrcAnalysisVariableList.setShowIcon(false);
        this.mAnalysisVariableScrollPane = new JScrollPane(this.mSrcAnalysisVariableList);
        this.mAnalysisVariableScrollPane.setPreferredSize(this.mSrcAnalysisVariableList.getMinimumSize());
        this.mAnalysisVariablesLabel = DialogUtil.createLabel(this, "IDS_OS_ANALYSIS_VARIABLES_LABEL");
        this.mAnalysisVariablesLabel.setLabelFor(this.mSrcAnalysisVariableList);
        this.mCategoryQuantificationList = new TargetVariableList();
        this.mCategoryQuantificationList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mCategoryQuantificationList.setAllowDuplicates(false);
        this.mCategoryQuantificationList.setIdentifier(OUTPUT_CATEGORY_LIST_KEY);
        this.mCategoryQuantificationList.addFocusListener(this);
        this.mCategoryQuantificationList.setShowIcon(false);
        this.mCategoryQuantificationList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mCategoryQuantificationList.getFixedCellHeight() * 5 + 2));
        this.mCategoryQuantificationScrollPane = new JScrollPane(this.mCategoryQuantificationList);
        this.mCategoryQuantificationScrollPane.setPreferredSize(this.mCategoryQuantificationList.getMinimumSize());
        this.mCategoryQuantificationLabel = DialogUtil.createLabel(this, "IDS_OS_CATEGORY_QUANTIFICATION_LABEL");
        this.mCategoryQuantificationLabel.setLabelFor(this.mCategoryQuantificationList);
        this.mDescriptivesStatisticsList = new TargetVariableList();
        this.mDescriptivesStatisticsList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mDescriptivesStatisticsList.setAllowDuplicates(false);
        this.mDescriptivesStatisticsList.setIdentifier(OUTPUT_DESCRIPTIVES_LIST_KEY);
        this.mDescriptivesStatisticsList.addFocusListener(this);
        this.mDescriptivesStatisticsList.setShowIcon(false);
        this.mDescriptivesStatisticsList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mDescriptivesStatisticsList.getFixedCellHeight() * 5 + 2));
        this.mDescriptivesStatisticsScrollPane = new JScrollPane(this.mDescriptivesStatisticsList);
        this.mDescriptivesStatisticsScrollPane.setPreferredSize(this.mDescriptivesStatisticsList.getMinimumSize());
        this.mDescriptivesStatisticsLabel = DialogUtil.createLabel(this, "IDS_OS_DESCRIPTIVE_STATISTICS_LABEL");
        this.mDescriptivesStatisticsLabel.setLabelFor(this.mDescriptivesStatisticsList);
        this.mCategoryArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCategoryArrowButton.registerVariableList(this.mSrcAnalysisVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mCategoryArrowButton.registerVariableList(this.mCategoryQuantificationList, SpssArrowButton.ButtonOrientation.left);
        this.mDescriptivesArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDescriptivesArrowButton.registerVariableList(this.mSrcAnalysisVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mDescriptivesArrowButton.registerVariableList(this.mDescriptivesStatisticsList, SpssArrowButton.ButtonOrientation.left);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mMultipleRCheckBox);
        spssButtonGroup.add(this.mCoefficientsCheckBox);
        spssButtonGroup.add(this.mIterationHistoryCheckBox);
        spssButtonGroup.add(this.mCorrelationOrigVarCheckBox);
        spssButtonGroup.add(this.mCorrelationTransVarCheckBox);
        spssButtonGroup.add(this.mAnovaCheckBox);
    }

    private void setDefaults() {
        this.mMultipleRCheckBox.setSelected(true);
        this.mCoefficientsCheckBox.setSelected(true);
        this.mAnovaCheckBox.setSelected(true);
        Boolean bl = this.mParentDlg.getDialogDataModel().getBoolean("IDS_OS_REG_NONE_LABEL");
        if (bl == null) {
            this.mRegularizedModelsCheckBox.setEnabled(false);
        }
        if (bl != null && !bl.booleanValue()) {
            this.mRegularizedModelsCheckBox.setEnabled(true);
        } else {
            this.mRegularizedModelsCheckBox.setEnabled(false);
        }
        this.mResamplingNoneRadio.setSelected(true);
        this.mNumFoldsTextField.setText(DEFAULT_NUM_FOLDS);
        this.mNumSamplesTextField.setText(DEFAULT_NUM_SAMPLES);
    }

    private void addComponentsToPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        JPanel jPanel2 = this.setupTablesPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        JPanel jPanel3 = this.setupResamplingPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 2, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mAnalysisVariablesLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mAnalysisVariableScrollPane, gridBagConstraints, 0, 2, 1, 3, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mCategoryArrowButton, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mDescriptivesArrowButton, gridBagConstraints, 1, 4, 1, 1, n, insets2);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mCategoryQuantificationLabel, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mCategoryQuantificationScrollPane, gridBagConstraints, 2, 2, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDescriptivesStatisticsLabel, gridBagConstraints, 2, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mDescriptivesStatisticsScrollPane, gridBagConstraints, 2, 4, 1, 1, n, null);
    }

    private JPanel setupTablesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OS_TABLES_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JComponent[] jComponentArray = new JComponent[]{this.mMultipleRCheckBox, this.mAnovaCheckBox, this.mCoefficientsCheckBox, this.mIterationHistoryCheckBox, this.mCorrelationOrigVarCheckBox, this.mCorrelationTransVarCheckBox, this.mRegularizedModelsCheckBox};
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, null);
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupResamplingPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OS_OUTPUT_RESAMPLING")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mResamplingNoneRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mResamplingCrossvalidationRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, this.mNumFoldsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mNumFoldsTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mResampling632BootstrapRadio, gridBagConstraints, 0, 3, 2, 1, n, insets);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel3, this.mNumSamplesLabel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel3, (JComponent)this.mNumSamplesTextField, gridBagConstraints, 1, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 4, 1, 1, n, insets);
        return jPanel;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMultipleRCheckBox);
        vector.add(this.mAnovaCheckBox);
        vector.add(this.mCoefficientsCheckBox);
        vector.add(this.mIterationHistoryCheckBox);
        vector.add(this.mCorrelationOrigVarCheckBox);
        vector.add(this.mCorrelationTransVarCheckBox);
        vector.add(this.mRegularizedModelsCheckBox);
        vector.add(this.mResamplingNoneRadio);
        vector.add(this.mResamplingCrossvalidationRadio);
        vector.add(this.mNumFoldsTextField);
        vector.add(this.mResampling632BootstrapRadio);
        vector.add(this.mNumSamplesTextField);
        vector.add(this.mSrcAnalysisVariableList);
        vector.add(this.mCategoryArrowButton);
        vector.add(this.mDescriptivesArrowButton);
        vector.add(this.mCategoryQuantificationList);
        vector.add(this.mDescriptivesStatisticsList);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

