/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.optimal_scaling;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.IDataDocument;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.BasicACREvent;
import com.spss.java_client.ui.controls.BasicACRWidget;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.IBasicACRListener;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineLabel;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingDlg;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class OptimalScalingOptions
extends BaseSubDialog
implements FocusListener,
DocumentListener,
IBasicACRListener,
ItemListener,
ActionListener {
    static final String NUMERICAL = "IDS_OS_NUMERICAL";
    static final String RANDOM = "IDS_OS_RANDOM";
    static final String MULTIPLE = "IDS_OS_MULTIPLE";
    static final String USEFIXED = "IDS_OS_USEFIXED";
    static final String ALLPOSSIBLE = "IDS_OS_ALL_POSSIBLE";
    static final String REDUCED_NUM = "IDS_OS_REDUCED_NUM";
    static final String READ_FROM_DATASET = "IDS_OS_READ_DATASET";
    static final String READ_FROM_FILE = "IDS_OS_READ_DATAFILE";
    static final String DATASET_NAME_KEY = "IDS_OS_DATASET";
    static final String DATA_FILE_NAME_KEY = "IDS_OS_DS_FILE";
    static final String VARIABLE_LABELS = "IDS_OS_VARIABLE_LABELS";
    static final String VARIABLE_NAMES = "IDS_OS_VARIABLE_NAMES";
    static final String CONVERGENCE_TEXT_FIELD_KEY = "CONVERGENCE_TEXT_FIELD_KEY";
    static final String ITER_TEXT_FIELD_KEY = "ITER_TEXT_FIELD_KEY";
    static final String LIMIT_TEXT_FIELD_KEY = "LIMIT_TEXT_FIELD_KEY";
    static final String BASIC_ACR_WIDGET_KEY = "BASIC_ACR_WIDGET_KEY";
    static final String DATASET_NAME_TEXTFIELD_KEY = "IDS_OS_DATASET_NAME_TEXTFIELD_KEY";
    static final String DATASET_NAME_COMBO_KEY = "IDS_OS_DATASET_NAME_COMBO_KEY";
    static final String DEFAULT_CONVERGENCE_VALUE = ".00001";
    static final String DEFAULT_MAX_ITER_VALUE = "100";
    static final String DEFAULT_LIMIT_VALUE = "20";
    static final String DEFAULT_LOSS_THRESHOLD = "50";
    static final String LOSS_OF_VARIANCE_TEXTFIELD_KEY = "LOSS_OF_VARIANCE_TEXTFIELD_KEY";
    static final String CASE_NUM_OF_SIGN_PATTERNS_KEY = "CASE_NUM_OF_SIGN_PATTERNS_KEY";
    private static final String VALUE_OUT_OF_RANGE = "ERR_OS_VALUE_OUT_OF_RANGE";
    private static final String WARNING_INVALID_RANGE = "ERR_OS_WARNING_INVALID_RANGE";
    private static final String EMPTY_STR = "";
    private static final String SPACE = " ";
    private static final String HYPHEN = "-";
    static final int FILEPATHTEXT = 20;
    private JRadioButton mRangeOfCasesRadio;
    private JLabel mFirstLabel;
    private IntTextField mFirstTextField;
    private JLabel mLastLabel;
    private IntTextField mLastTextField;
    private JRadioButton mSingleCaseRadio;
    private IntTextField mSingleCaseTextField;
    private BasicACRWidget mBasicACRWidget;
    private JRadioButton mNumericalRadio;
    private JRadioButton mRandomRadio;
    private JRadioButton mMultipleRadio;
    private JRadioButton mUseFixedRadio;
    private JLabel mConvergenceLabel;
    private FloatTextField mConvergenceTextField;
    private JLabel mMaximumIterationsLabel;
    private IntTextField mMaximumIterationsTextField;
    private JRadioButton mVariableLabelsRadio;
    private JRadioButton mVariableNamesRadio;
    private JLabel mLimitForLengthLabel;
    private IntTextField mLimitForLengthTextField;
    private SpssButtonGroup mSuppObjectsGroup;
    private SpssButtonGroup mInitialConfGroup;
    private SpssButtonGroup mLabelPlotsGroup;
    private JRadioButton mAllPossibleRadio;
    private JRadioButton mReducedRadio;
    private SpssButtonGroup mPatternsGroup;
    private JLabel mLossOfVarianceLabel;
    private IntTextField mLossOfVarianceTextField;
    private JLabel mCaseNumberLabel;
    private IntTextField mCaseNumberTextField;
    private JRadioButton mReadFromDSRadio;
    private JRadioButton mReadFromDataFileRadio;
    private SpssButtonGroup mSignsRadioGroup;
    private JLabel mDataSetNameLabel;
    private JComboBox mDataSetNameCombo;
    private JButton mFileButton;
    private FileTextField mDataFilePath;
    private List<LocallyUniqueId> mDatasetIds;
    private Vector<String> mDatasetTitles;
    private boolean mDataSetsInCombo;

    OptimalScalingOptions(OptimalScalingDlg optimalScalingDlg) {
        super(optimalScalingDlg, optimalScalingDlg.getResString("IDS_OS_OPTIONS_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_catr_options";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mFirstTextField)) {
            this.mFirstTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mLastTextField)) {
            this.mLastTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mSingleCaseTextField)) {
            this.mSingleCaseTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mConvergenceTextField)) {
            this.mConvergenceTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mMaximumIterationsTextField)) {
            this.mMaximumIterationsTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mLimitForLengthTextField)) {
            this.mLimitForLengthTextField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mFirstTextField)) {
            this.mFirstTextField.select(0, 0);
        } else if (focusEvent.getSource().equals(this.mLastTextField)) {
            this.mLastTextField.select(0, 0);
        } else if (focusEvent.getSource().equals(this.mSingleCaseTextField)) {
            this.mSingleCaseTextField.select(0, 0);
        } else if (focusEvent.getSource().equals(this.mMaximumIterationsTextField)) {
            this.mMaximumIterationsTextField.select(0, 0);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableButtons(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableButtons(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mVariableLabelsRadio) || itemEvent.getSource().equals(this.mVariableNamesRadio)) {
            boolean bl = this.mVariableLabelsRadio.isSelected();
            this.mLimitForLengthLabel.setEnabled(bl);
            this.mLimitForLengthTextField.setEnabled(bl);
            this.mLimitForLengthTextField.setOpaque(bl);
        } else if (this.mRangeOfCasesRadio.isSelected()) {
            this.mFirstTextField.setEnabled(true);
            this.mFirstTextField.setOpaque(true);
            this.mLastTextField.setEnabled(true);
            this.mLastTextField.setOpaque(true);
            this.mSingleCaseTextField.setEnabled(false);
            this.mSingleCaseTextField.setOpaque(false);
            this.updateAddChangeButton();
        } else if (this.mSingleCaseRadio.isSelected()) {
            this.mFirstTextField.setEnabled(false);
            this.mFirstTextField.setOpaque(false);
            this.mLastTextField.setEnabled(false);
            this.mLastTextField.setOpaque(false);
            this.mSingleCaseTextField.setEnabled(true);
            this.mSingleCaseTextField.setOpaque(true);
            this.updateAddChangeButton();
        }
        if (itemEvent.getSource().equals(this.mMultipleRadio) || itemEvent.getSource().equals(this.mNumericalRadio) || itemEvent.getSource().equals(this.mRandomRadio) || itemEvent.getSource().equals(this.mUseFixedRadio)) {
            this.enablePatternsGroupComponents();
            this.enableSignsGroupComponents();
        }
        if (itemEvent.getSource().equals(this.mAllPossibleRadio) || itemEvent.getSource().equals(this.mReducedRadio)) {
            this.enablePatternsGroupComponents();
        }
        if (itemEvent.getSource().equals(this.mReadFromDSRadio) || itemEvent.getSource().equals(this.mReadFromDataFileRadio)) {
            this.enableSignsGroupComponents();
        }
    }

    private void enablePatternsGroupComponents() {
        boolean bl = this.mMultipleRadio.isSelected();
        this.mAllPossibleRadio.setEnabled(bl);
        this.mReducedRadio.setEnabled(bl);
        boolean bl2 = this.mReducedRadio.isEnabled() && this.mReducedRadio.isSelected();
        this.mLossOfVarianceLabel.setEnabled(bl2);
        this.mLossOfVarianceTextField.setEnabled(bl2);
        this.updateContinue();
    }

    private void enableSignsGroupComponents() {
        boolean bl = this.mUseFixedRadio.isSelected();
        this.mCaseNumberLabel.setEnabled(bl);
        this.mCaseNumberTextField.setEnabled(bl);
        this.mReadFromDSRadio.setEnabled(bl && this.mDataSetsInCombo);
        this.mReadFromDataFileRadio.setEnabled(bl);
        boolean bl2 = this.mReadFromDSRadio.isEnabled() && this.mReadFromDSRadio.isSelected() && this.mDataSetsInCombo;
        this.mDataSetNameLabel.setEnabled(bl2);
        this.mDataSetNameCombo.setEnabled(bl2);
        this.mFileButton.setEnabled(bl && !bl2);
        this.mDataFilePath.setEnabled(bl && !bl2);
        if (!this.mDataSetsInCombo && this.mReadFromDSRadio.isSelected()) {
            this.mReadFromDSRadio.setSelected(false);
            this.mReadFromDataFileRadio.setSelected(true);
        }
        this.updateContinue();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mFileButton) {
            this.showOpenDialog();
        }
    }

    @Override
    public void acrEventOccured(BasicACREvent basicACREvent) {
        if (basicACREvent.getEventType() == BasicACREvent.EventType.addButtonPress) {
            if (!this.processAddButtonPress()) {
                this.mBasicACRWidget.setAddEnabled(false);
                this.mBasicACRWidget.setChangeEnabled(false);
                this.mBasicACRWidget.setRemoveEnabled(false);
                this.mBasicACRWidget.getList().requestFocus();
            }
        } else if (basicACREvent.getEventType() == BasicACREvent.EventType.changeButtonPress) {
            if (!this.processChangeButtonPress()) {
                this.mBasicACRWidget.setAddEnabled(false);
                this.mBasicACRWidget.setChangeEnabled(false);
                this.mBasicACRWidget.setRemoveEnabled(false);
            }
        } else if (basicACREvent.getEventType() == BasicACREvent.EventType.removeButtonPress) {
            this.processRemoveButtonPress();
            this.mBasicACRWidget.setRemoveEnabled(false);
            this.mBasicACRWidget.getList().requestFocus();
        } else if (basicACREvent.getEventType() == BasicACREvent.EventType.listSelectionValueChange) {
            if (this.mBasicACRWidget.getListSelectedIndex() != -1) {
                this.processListSelectionValueChange();
                this.mBasicACRWidget.setAddEnabled(false);
                this.mBasicACRWidget.setChangeEnabled(false);
                this.mBasicACRWidget.setRemoveEnabled(this.mBasicACRWidget.getList().getModel().getSize() > 0);
                this.mBasicACRWidget.getList().requestFocus();
            } else {
                this.mBasicACRWidget.setRemoveEnabled(false);
            }
        }
    }

    @Override
    public boolean continuePressed() {
        int n;
        if (this.mRangeOfCasesRadio.isSelected() && this.mFirstTextField.getText().length() > 0) {
            if (this.mLastTextField.getText().length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(WARNING_INVALID_RANGE), VersionInfo.getAppVersionString());
                this.mFirstTextField.selectAll();
                this.mFirstTextField.requestFocus();
                return false;
            }
            if (this.isRangeInvalid()) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(WARNING_INVALID_RANGE), VersionInfo.getAppVersionString());
                this.mLastTextField.selectAll();
                this.mLastTextField.requestFocus();
                return false;
            }
        }
        if (this.mSingleCaseRadio.isSelected() && this.mSingleCaseTextField.getText().length() > 0 && this.isTextZero(this.mSingleCaseTextField.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
            this.mSingleCaseTextField.selectAll();
            this.mSingleCaseTextField.requestFocus();
            return false;
        }
        if (this.isTextZero(this.mMaximumIterationsTextField.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
            this.mMaximumIterationsTextField.selectAll();
            this.mMaximumIterationsTextField.requestFocus();
            return false;
        }
        if (this.mReadFromDataFileRadio.isEnabled() && this.mReadFromDataFileRadio.isSelected() && this.mDataFilePath.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("IDS_OS_SPECIFY_FILE_ERR"), VersionInfo.getAppVersionString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptimalScalingOptions.this.mFileButton.requestFocus();
                }
            });
            return false;
        }
        if (this.mDataSetNameCombo.isEnabled() && this.mDataSetNameCombo.getItemCount() > 0) {
            n = this.mDataSetNameCombo.getSelectedIndex();
            this.mParentDlg.getDialogDataModel().putString(DATASET_NAME_KEY, (String)this.mDataSetNameCombo.getItemAt(n));
        } else {
            this.mParentDlg.getDialogDataModel().putString(DATASET_NAME_KEY, null);
        }
        if ((this.mBasicACRWidget.isAddEnabled() || this.mBasicACRWidget.isChangeEnabled()) && (n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_OS_PENDING_ADD_CHANGE_ERR"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) == 3) {
            if (this.mBasicACRWidget.isAddEnabled()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptimalScalingOptions.this.mContinueButton.requestFocus();
                    }
                });
            } else if (this.mBasicACRWidget.isChangeEnabled()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptimalScalingOptions.this.mContinueButton.requestFocus();
                    }
                });
            }
            return false;
        }
        return super.continuePressed();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponentsToPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void updateContinue() {
        boolean bl = true;
        boolean bl2 = true;
        if (this.mLossOfVarianceTextField.isEnabled() && this.mLossOfVarianceTextField.getText().length() == 0) {
            bl = false;
        }
        if (this.mCaseNumberTextField.isEnabled() && this.mCaseNumberTextField.getText().length() == 0) {
            bl2 = false;
        }
        this.enableContinue(this.mConvergenceTextField.getText().length() > 0 && this.mMaximumIterationsTextField.getText().length() > 0 && this.mLimitForLengthTextField.getText().length() > 0 && bl && bl2);
    }

    private boolean isTextZero(String string) {
        Integer n = new Integer(string);
        return 0 == n;
    }

    private boolean isRangeInvalid() {
        BigDecimal bigDecimal = new BigDecimal(this.mFirstTextField.getText());
        BigDecimal bigDecimal2 = new BigDecimal(this.mLastTextField.getText());
        return bigDecimal2.compareTo(bigDecimal) == -1;
    }

    private boolean processAddButtonPress() {
        boolean bl = false;
        if (this.mRangeOfCasesRadio.isSelected()) {
            if (this.isRangeInvalid()) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(WARNING_INVALID_RANGE), VersionInfo.getAppVersionString());
                this.mFirstTextField.selectAll();
                this.mFirstTextField.requestFocus();
                bl = true;
            }
            if (this.isTextZero(this.mFirstTextField.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
                this.mFirstTextField.selectAll();
                this.mFirstTextField.requestFocus();
                bl = true;
            }
            if (this.isTextZero(this.mLastTextField.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
                this.mLastTextField.selectAll();
                this.mLastTextField.requestFocus();
                bl = true;
            }
            if (!bl) {
                String string = this.mFirstTextField.getText() + SPACE + HYPHEN + SPACE + this.mLastTextField.getText();
                this.mBasicACRWidget.addListItemAt(this.mBasicACRWidget.getListItemCount(), string);
                this.mFirstTextField.setText(EMPTY_STR);
                this.mLastTextField.setText(EMPTY_STR);
            }
        } else if (this.mSingleCaseTextField.isEnabled()) {
            if (this.isTextZero(this.mSingleCaseTextField.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
                bl = true;
            } else {
                this.mBasicACRWidget.addListItemAt(this.mBasicACRWidget.getListItemCount(), this.mSingleCaseTextField.getText());
                this.mSingleCaseTextField.setText(EMPTY_STR);
            }
        }
        return bl;
    }

    private boolean processChangeButtonPress() {
        boolean bl = false;
        if (this.mRangeOfCasesRadio.isSelected()) {
            if (this.isRangeInvalid()) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(WARNING_INVALID_RANGE), VersionInfo.getAppVersionString());
                this.mFirstTextField.selectAll();
                this.mFirstTextField.requestFocus();
                bl = true;
            }
            if (this.isTextZero(this.mLastTextField.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
                this.mLastTextField.selectAll();
                this.mLastTextField.requestFocus();
                bl = true;
            }
            if (!bl) {
                String string = this.mFirstTextField.getText() + SPACE + HYPHEN + SPACE + this.mLastTextField.getText();
                int n = this.mBasicACRWidget.getListSelectedIndex();
                DefaultListModel defaultListModel = (DefaultListModel)this.mBasicACRWidget.getList().getModel();
                if (n != -1 && !defaultListModel.contains(string)) {
                    this.mBasicACRWidget.removeListItemAt(n);
                    this.mBasicACRWidget.addListItemAt(n, string);
                }
                this.mFirstTextField.setText(EMPTY_STR);
                this.mLastTextField.setText(EMPTY_STR);
            }
        } else if (this.mSingleCaseTextField.isEnabled()) {
            if (this.isTextZero(this.mSingleCaseTextField.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
                bl = true;
            } else {
                int n = this.mBasicACRWidget.getListSelectedIndex();
                String string = this.mSingleCaseTextField.getText();
                DefaultListModel defaultListModel = (DefaultListModel)this.mBasicACRWidget.getList().getModel();
                if (n != -1 && !defaultListModel.contains(string)) {
                    this.mBasicACRWidget.removeListItemAt(n);
                    this.mBasicACRWidget.addListItemAt(n, string);
                }
                this.mSingleCaseTextField.setText(EMPTY_STR);
            }
        }
        return bl;
    }

    private void processRemoveButtonPress() {
        int[] nArray = this.mBasicACRWidget.getList().getSelectedIndices();
        for (int i = nArray.length - 1; i >= 0; --i) {
            String string = (String)this.mBasicACRWidget.getListItemAt(nArray[i]);
            if (string.contains(HYPHEN)) {
                this.mFirstTextField.setText(EMPTY_STR);
                this.mLastTextField.setText(EMPTY_STR);
            } else {
                this.mSingleCaseTextField.setText(EMPTY_STR);
            }
            this.mBasicACRWidget.removeListItemAt(nArray[i]);
        }
    }

    private void processListSelectionValueChange() {
        int[] nArray = this.mBasicACRWidget.getList().getSelectedIndices();
        if (nArray.length == 1) {
            String string = (String)this.mBasicACRWidget.getListItemAt(this.mBasicACRWidget.getListSelectedIndex());
            if (string.contains(HYPHEN)) {
                String string2 = string.substring(0, string.indexOf(SPACE));
                String string3 = string.substring(string.indexOf(SPACE) + 3, string.length());
                this.mRangeOfCasesRadio.setSelected(true);
                this.mFirstTextField.setEnabled(true);
                this.mFirstTextField.setOpaque(true);
                this.mLastTextField.setEnabled(true);
                this.mLastTextField.setOpaque(true);
                this.mSingleCaseTextField.setEnabled(false);
                this.mSingleCaseTextField.setOpaque(false);
                this.mFirstTextField.setText(string2);
                this.mLastTextField.setText(string3);
            } else {
                this.mSingleCaseRadio.setSelected(true);
                this.mFirstTextField.setEnabled(false);
                this.mFirstTextField.setOpaque(false);
                this.mLastTextField.setEnabled(false);
                this.mLastTextField.setOpaque(false);
                this.mSingleCaseTextField.setEnabled(true);
                this.mSingleCaseTextField.setOpaque(true);
                this.mSingleCaseTextField.setText(string);
            }
        } else {
            this.mFirstTextField.setText(EMPTY_STR);
            this.mLastTextField.setText(EMPTY_STR);
            this.mSingleCaseTextField.setText(EMPTY_STR);
        }
    }

    private void enableButtons(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().equals(this.mFirstTextField.getDocument())) {
            this.updateAddChangeButton();
            this.mBasicACRWidget.setRemoveEnabled(false);
        } else if (documentEvent.getDocument().equals(this.mLastTextField.getDocument())) {
            this.updateAddChangeButton();
            this.mBasicACRWidget.setRemoveEnabled(false);
        } else if (documentEvent.getDocument().equals(this.mSingleCaseTextField.getDocument())) {
            this.updateAddChangeButton();
            this.mBasicACRWidget.setRemoveEnabled(false);
        } else {
            this.updateContinue();
        }
    }

    private void updateAddChangeButton() {
        if (this.mSingleCaseTextField.isEnabled()) {
            this.mBasicACRWidget.setAddEnabled(this.mSingleCaseTextField.getText().length() > 0);
            this.mBasicACRWidget.setChangeEnabled(this.mSingleCaseTextField.getText().length() > 0 && this.mBasicACRWidget.getListSelectedIndex() != -1);
        } else if (this.mFirstTextField.isEnabled() && this.mLastTextField.isEnabled()) {
            this.mBasicACRWidget.setAddEnabled(this.mFirstTextField.getText().length() > 0 && this.mLastTextField.getText().length() > 0);
            this.mBasicACRWidget.setChangeEnabled(this.mFirstTextField.getText().length() > 0 && this.mLastTextField.getText().length() > 0 && this.mBasicACRWidget.getListSelectedIndex() != -1);
        }
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_RANGE_OF_CASES");
        this.mRangeOfCasesRadio = new JRadioButton(toggleButtonAction);
        this.mRangeOfCasesRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_SINGLE_CASE");
        this.mSingleCaseRadio = new JRadioButton(toggleButtonAction);
        this.mSingleCaseRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, NUMERICAL);
        this.mNumericalRadio = new JRadioButton(toggleButtonAction);
        this.mNumericalRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, RANDOM);
        this.mRandomRadio = new JRadioButton(toggleButtonAction);
        this.mRandomRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, MULTIPLE);
        this.mMultipleRadio = new JRadioButton(toggleButtonAction);
        this.mMultipleRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, USEFIXED);
        this.mUseFixedRadio = new JRadioButton(toggleButtonAction);
        this.mUseFixedRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, VARIABLE_LABELS);
        this.mVariableLabelsRadio = new JRadioButton(toggleButtonAction);
        this.mVariableLabelsRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, VARIABLE_NAMES);
        this.mVariableNamesRadio = new JRadioButton(toggleButtonAction);
        this.mVariableNamesRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, ALLPOSSIBLE);
        this.mAllPossibleRadio = new JRadioButton(toggleButtonAction);
        this.mAllPossibleRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, REDUCED_NUM);
        this.mReducedRadio = new JRadioButton(toggleButtonAction);
        this.mReducedRadio.addItemListener(this);
        this.mLossOfVarianceTextField = new IntTextField(0, 100, true);
        this.mLossOfVarianceTextField.setColumns(5);
        this.mLossOfVarianceTextField.getDocument().addDocumentListener(this);
        this.mLossOfVarianceTextField.setAction((Action)new TextFieldAction(this, LOSS_OF_VARIANCE_TEXTFIELD_KEY));
        this.mLossOfVarianceTextField.addFocusListener((FocusListener)this);
        this.mLossOfVarianceLabel = DialogUtil.createLabel(this, "IDS_OS_LOSS_OF_VARIANCE");
        this.mLossOfVarianceLabel.setLabelFor((Component)this.mLossOfVarianceTextField);
        this.mCaseNumberTextField = new IntTextField(1, 9999999, true);
        this.mCaseNumberTextField.setColumns(5);
        this.mCaseNumberTextField.getDocument().addDocumentListener(this);
        this.mCaseNumberTextField.setAction((Action)new TextFieldAction(this, CASE_NUM_OF_SIGN_PATTERNS_KEY));
        this.mCaseNumberTextField.addFocusListener((FocusListener)this);
        this.mCaseNumberLabel = DialogUtil.createLabel(this, "IDS_OS_OPT_CASE_NUM_OF_SIGN_PATTERN");
        this.mCaseNumberLabel.setLabelFor((Component)this.mCaseNumberTextField);
        toggleButtonAction = new ToggleButtonAction(this, READ_FROM_DATASET);
        this.mReadFromDSRadio = new JRadioButton(toggleButtonAction);
        this.mReadFromDSRadio.addItemListener(this);
        this.mDataSetNameCombo = new JComboBox();
        this.mDataSetNameCombo.setAction(new ComboboxAction(this, DATASET_NAME_COMBO_KEY));
        this.mDataSetNameCombo.setPreferredSize(new Dimension(180, 22));
        this.mDataSetNameLabel = DialogUtil.createLabel(this, "IDS_OS_DATASET_NAME");
        this.mDataSetNameLabel.setLabelFor(this.mDataSetNameCombo);
        toggleButtonAction = new ToggleButtonAction(this, READ_FROM_FILE);
        this.mReadFromDataFileRadio = new JRadioButton(toggleButtonAction);
        this.mReadFromDataFileRadio.addItemListener(this);
        this.mFileButton = DialogUtil.createButton(this, DATA_FILE_NAME_KEY, this);
        this.mFirstTextField = new IntTextField(1, 99999999, true);
        this.mFirstTextField.setColumns(8);
        this.mFirstTextField.getDocument().addDocumentListener(this);
        this.mFirstTextField.addFocusListener((FocusListener)this);
        this.mFirstLabel = DialogUtil.createLabel(this, "IDS_OS_FIRST_LABEL");
        this.mFirstLabel.setLabelFor((Component)this.mFirstTextField);
        this.mLastTextField = new IntTextField(1, 99999999, true);
        this.mLastTextField.setColumns(8);
        this.mLastTextField.getDocument().addDocumentListener(this);
        this.mLastTextField.addFocusListener((FocusListener)this);
        this.mSingleCaseTextField = new IntTextField(1, 99999999, true);
        this.mSingleCaseTextField.setColumns(8);
        this.mSingleCaseTextField.getDocument().addDocumentListener(this);
        this.mSingleCaseTextField.addFocusListener((FocusListener)this);
        this.mLastLabel = DialogUtil.createLabel(this, "IDS_OS_LAST_LABEL");
        this.mLastLabel.setLabelFor((Component)this.mLastTextField);
        this.mBasicACRWidget = new BasicACRWidget(BASIC_ACR_WIDGET_KEY);
        this.mBasicACRWidget.getList().setSelectionMode(2);
        this.mBasicACRWidget.addBasicACRListener(this);
        this.mConvergenceTextField = new FloatTextField(1.0E-6, 0.1, 6, true);
        this.mConvergenceTextField.setColumns(5);
        this.mConvergenceTextField.getDocument().addDocumentListener(this);
        this.mConvergenceTextField.setAction((Action)new TextFieldAction(this, CONVERGENCE_TEXT_FIELD_KEY));
        this.mConvergenceTextField.addFocusListener((FocusListener)this);
        this.mConvergenceLabel = DialogUtil.createLabel(this, "IDS_OS_CONVERGENCE_LABEL");
        this.mConvergenceLabel.setLabelFor((Component)this.mConvergenceTextField);
        this.mMaximumIterationsTextField = new IntTextField(1, 99999999, true);
        this.mMaximumIterationsTextField.setColumns(8);
        this.mMaximumIterationsTextField.getDocument().addDocumentListener(this);
        this.mMaximumIterationsTextField.setAction((Action)new TextFieldAction(this, ITER_TEXT_FIELD_KEY));
        this.mMaximumIterationsTextField.addFocusListener((FocusListener)this);
        this.mMaximumIterationsLabel = DialogUtil.createLabel(this, "IDS_OS_MAX_ITERATIONS_LABEL");
        this.mMaximumIterationsLabel.setLabelFor((Component)this.mMaximumIterationsTextField);
        this.mLimitForLengthTextField = new IntTextField(1, 20, true);
        this.mLimitForLengthTextField.setColumns(5);
        this.mLimitForLengthTextField.getDocument().addDocumentListener(this);
        this.mLimitForLengthTextField.setAction((Action)new TextFieldAction(this, LIMIT_TEXT_FIELD_KEY));
        this.mLimitForLengthTextField.addFocusListener((FocusListener)this);
        this.mLimitForLengthLabel = DialogUtil.createLabel(this, "IDS_OS_LIMIT_FOR_LENGTH_LABEL");
        this.mLimitForLengthLabel.setLabelFor((Component)this.mLimitForLengthTextField);
        this.mBasicACRWidget.setChangeMnemonic(72);
        this.mBasicACRWidget.setRemoveMnemonic(69);
        this.mDataFilePath = new FileTextField();
        this.mDataFilePath.setEditable(false);
        this.mDataFilePath.setOpaque(false);
        this.mDataFilePath.setColumns(20);
        this.mDataFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mDataFilePath.getDocument().addDocumentListener(this);
        this.mDataFilePath.setAction(new TextFieldAction(this, DATA_FILE_NAME_KEY));
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        DataMgr dataMgr = DataMgr.getDataMgr();
        IDataDocument iDataDocument = dataMgr.findDataDocument(locallyUniqueId);
        this.mDatasetIds = new ArrayList<LocallyUniqueId>();
        this.mDatasetTitles = new Vector();
        for (SpssFrame spssFrame : SpssFrameMgr.getSpssFrameMgr().getOpenDocuments()) {
            if (!(spssFrame instanceof DataFrame) || ((DataFrame)spssFrame).getDatasetId() == locallyUniqueId) continue;
            DataFrame dataFrame = (DataFrame)spssFrame;
            this.mDatasetIds.add(dataFrame.getDatasetId());
            IDataDocument iDataDocument2 = dataMgr.findDataDocument(dataFrame.getDatasetId());
            this.mDatasetTitles.add(iDataDocument2.getDatasetName());
            Collections.sort(this.mDatasetTitles);
        }
        this.mDataSetsInCombo = this.mDatasetTitles.size() > 0;
    }

    private void setDefaults() {
        this.mRangeOfCasesRadio.setSelected(true);
        this.mSingleCaseTextField.setEnabled(false);
        this.mSingleCaseTextField.setOpaque(false);
        this.mBasicACRWidget.setEnabled(false);
        this.mNumericalRadio.setSelected(true);
        Formatter formatter = new Formatter().format(ResUtil.getLocale(), DEFAULT_CONVERGENCE_VALUE, new Object[0]);
        this.mConvergenceTextField.setText(formatter.toString());
        this.mMaximumIterationsTextField.setText(DEFAULT_MAX_ITER_VALUE);
        this.mVariableLabelsRadio.setSelected(true);
        this.mLimitForLengthTextField.setText(DEFAULT_LIMIT_VALUE);
        this.mAllPossibleRadio.setSelected(true);
        this.mLossOfVarianceTextField.setText(DEFAULT_LOSS_THRESHOLD);
        this.mReadFromDSRadio.setSelected(true);
        this.mDataFilePath.setText(EMPTY_STR);
        this.mDataFilePath.setOpaque(false);
        this.mDataFilePath.setEnabled(true);
        this.mDataFilePath.setEditable(false);
        this.mDataFilePath.setCaretPosition(0);
        if (this.mDataSetNameCombo.getItemCount() > 0) {
            this.mDataSetNameCombo.removeAllItems();
        }
        this.populateDataSetNameCombo();
        if (this.mDataSetNameCombo.getItemCount() > 0) {
            this.mDataSetNameCombo.setSelectedIndex(0);
        }
    }

    private void populateDataSetNameCombo() {
        for (int i = 0; i < this.mDatasetTitles.size(); ++i) {
            this.mDataSetNameCombo.addItem(this.mDatasetTitles.get(i));
        }
    }

    private void addComponentsToPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        JPanel jPanel2 = this.setupSuppObjectsPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.mSuppObjectsGroup = DialogUtil.createButtonGroup(jPanel2);
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        JPanel jPanel3 = this.setupInitialConfPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 2, n, insets);
        this.mInitialConfGroup = new SpssButtonGroup();
        this.mInitialConfGroup.add(this.mNumericalRadio);
        this.mInitialConfGroup.add(this.mRandomRadio);
        this.mInitialConfGroup.add(this.mMultipleRadio);
        this.mInitialConfGroup.add(this.mUseFixedRadio);
        JPanel jPanel4 = this.setupCriteriaPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 1, 1, 1, n, null);
        JPanel jPanel5 = this.setupLabelPlotsByPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 2, 1, 1, n, null);
        this.mLabelPlotsGroup = DialogUtil.createButtonGroup(jPanel5);
    }

    private JPanel setupInitialConfPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OS_INITIAL_CONFIGURATION_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 23;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNumericalRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRandomRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMultipleRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        Insets insets2 = new Insets(0, DialogUtil.getGroupBoxInnerMargin() * 5, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupPatternsToTestPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets2);
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mUseFixedRadio, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupSignsPanel(), gridBagConstraints, 0, 5, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupPatternsToTestPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OS_PATTERNS_TO_TEST")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        gridBagConstraints.fill = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mAllPossibleRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mReducedRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 7, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mLossOfVarianceLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLossOfVarianceTextField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel(new ImageIcon(uRL));
        JPanel jPanel2 = new JPanel();
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        SpssMultiLineLabel spssMultiLineLabel = new SpssMultiLineLabel(this.getResString("IDS_OS_REDUCED_SET_DESC"), null, 300);
        DialogUtil.addUsingGBL(jPanel2, spssMultiLineLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(0, DialogUtil.getGroupBoxInnerMargin() * 7, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 2, 1, n, insets);
        this.mPatternsGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupSignsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OS_SIGNS_OF_REGRESSION")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        gridBagConstraints.fill = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel2, this.mCaseNumberLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mCaseNumberTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mReadFromDSRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 7, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDataSetNameLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDataSetNameCombo, gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mReadFromDataFileRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel3, this.mFileButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel3, (JComponent)((Object)this.mDataFilePath), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 4, 2, 1, n, insets);
        this.mSignsRadioGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupSuppObjectsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OS_SUPPLEMENTARY_OBJECTS_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mRangeOfCasesRadio, gridBagConstraints, 0, 0, 3, 1, n, insets);
        insets.set(0, DialogUtil.getGroupBoxInnerMargin() * 8, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFirstLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mFirstTextField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 8, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mLastLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLastTextField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSingleCaseRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(DialogUtil.getGroupBoxInnerMargin() * 2, DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSingleCaseTextField, gridBagConstraints, 2, 3, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(this.getResString("IDS_OS_CASES_TO_TREAT"));
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        DialogUtil.applyTopBorder(jPanel3);
        DialogUtil.applyTopBorder(jPanel4);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        int n2 = 23;
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n3 - 4, n3, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints2, 0, 0, 1, 1, n2, insets2);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints2, 1, 0, 1, 1, n2, null);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, jPanel4, gridBagConstraints2, 2, 0, 2, 1, n2, insets2);
        insets.set(DialogUtil.getGroupBoxInnerMargin() * 2, 0, DialogUtil.getGroupBoxInnerMargin() * 2, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints2, 0, 4, 3, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mBasicACRWidget, gridBagConstraints, 0, 5, 3, 1, n, insets);
        return jPanel;
    }

    private JPanel setupCriteriaPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OS_CRITERIA_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mConvergenceLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConvergenceTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMaximumIterationsLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaximumIterationsTextField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupLabelPlotsByPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OS_LABEL_PLOTS_BY_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mVariableLabelsRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin() * 7, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mLimitForLengthLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(0, DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLimitForLengthTextField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mVariableNamesRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSuppObjectsGroup);
        vector.add(this.mFirstTextField);
        vector.add(this.mLastTextField);
        vector.add(this.mSingleCaseTextField);
        Component[] componentArray = new Component[3];
        for (n = 0; n < this.mBasicACRWidget.getComponentCount() - 1; ++n) {
            componentArray[n] = this.mBasicACRWidget.getComponent(n);
        }
        vector.add(componentArray[0]);
        vector.add(componentArray[1]);
        vector.add(componentArray[2]);
        vector.add(this.mBasicACRWidget.getList());
        vector.add(this.mConvergenceTextField);
        vector.add(this.mMaximumIterationsTextField);
        vector.add(this.mLabelPlotsGroup);
        vector.add(this.mLimitForLengthTextField);
        vector.add(this.mInitialConfGroup);
        vector.add(this.mPatternsGroup);
        vector.add(this.mLossOfVarianceTextField);
        vector.add(this.mSignsRadioGroup);
        vector.add(this.mCaseNumberTextField);
        vector.add(this.mDataSetNameCombo);
        vector.add(this.mFileButton);
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void showOpenDialog() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_OS_SPSS_DATAFILE_FILTER"), this.getResString("IDS_OS_SPSS_DATAFILE_EXT"));
        remoteFileChooser.setApproveButtonText(this.getResString("IDS_OS_SPSS_DATAFILE_OPEN"));
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        int n = remoteFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = remoteFileChooser.getSelectedFile();
            remoteFileChooser.setCurrentDirectory(file);
            this.mDataFilePath.setText(remoteFileChooser.getSelectedFilePath());
        }
    }
}

