/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.optimal_scaling;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingDlg;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingDlgVarFormatter;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingMissingVarListModel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OptimalScalingMissing
extends BaseSubDialog
implements ListSelectionListener,
ItemListener {
    private static final String MISSING_FORMATTER_KEY = "MISSING_FORMATTER_KEY";
    private JLabel mAnalysisVariablesLabel;
    private TargetVariableList mTargetVarList;
    private JScrollPane mTargetVarScrollPane;
    private JButton mChangeButton;
    private JRadioButton mExcludeRadio;
    private JRadioButton mImputeRadio;
    private JRadioButton mModeRadio;
    private JRadioButton mExtraCatRadio;
    private SpssButtonGroup mExcludeImputeButtonGroup;
    private SpssButtonGroup mModeExtraButtonGroup;
    private static OptimalScalingDlgVarFormatter sFormatter;

    OptimalScalingMissing(OptimalScalingDlg optimalScalingDlg) {
        super(optimalScalingDlg, optimalScalingDlg.getResString("IDS_OS_MISSING_TITLE"), true);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.mTargetVarList)) {
            this.mChangeButton.setEnabled(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mExcludeRadio)) {
            this.mModeRadio.setEnabled(false);
            this.mExtraCatRadio.setEnabled(false);
        } else if (itemEvent.getSource().equals(this.mImputeRadio)) {
            this.mModeRadio.setEnabled(true);
            this.mExtraCatRadio.setEnabled(true);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_catr_missing";
    }

    static OptimalScalingDlgVarFormatter getFormatter() {
        return sFormatter;
    }

    VarListModel getListModel() {
        return this.mTargetVarList.getModel();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        int n;
        int n2;
        ISpssVariable iSpssVariable2;
        super.loadState(dialogDataModel);
        sFormatter.setVarMap(dialogDataModel.getMap(MISSING_FORMATTER_KEY));
        TargetVariableList targetVariableList = ((OptimalScalingDlg)this.mParentDlg).getDependentVarList();
        TargetVariableList targetVariableList2 = ((OptimalScalingDlg)this.mParentDlg).getIndependentVarList();
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        for (int i = 0; i < this.mTargetVarList.getModel().getSize(); ++i) {
            iSpssVariable2 = this.mTargetVarList.getModel().getElementAt(i);
            n2 = iSpssVariable2.getId().asInt();
            if (this.isItemPresent(n2, targetVariableList) || this.isItemPresent(n2, targetVariableList2)) continue;
            vector.add(iSpssVariable2);
        }
        for (ISpssVariable iSpssVariable2 : vector) {
            this.mTargetVarList.getModel().removeElement(iSpssVariable2);
        }
        for (n = 0; n < targetVariableList.getModel().getSize(); ++n) {
            iSpssVariable2 = targetVariableList.getModel().getElementAt(n);
            n2 = iSpssVariable2.getId().asInt();
            if (this.isItemPresent(n2, this.mTargetVarList)) continue;
            this.mTargetVarList.getModel().insertElementAt(iSpssVariable2, 0);
        }
        for (n = 0; n < targetVariableList2.getModel().getSize(); ++n) {
            iSpssVariable2 = targetVariableList2.getModel().getElementAt(n);
            n2 = iSpssVariable2.getId().asInt();
            if (this.isItemPresent(n2, this.mTargetVarList)) continue;
            this.mTargetVarList.getModel().addElement(iSpssVariable2);
        }
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        this.mExcludeRadio.setSelected(true);
        super.saveState(dialogDataModel);
        dialogDataModel.putMap(MISSING_FORMATTER_KEY, sFormatter.getVarMapForSerialization());
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponentsToPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void initVars() {
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setLoadFromPersistent(false);
        this.mTargetVarList.addListSelectionListener(this);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 11 + 2));
        this.mTargetVarScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        sFormatter = new OptimalScalingDlgVarFormatter(this.mTargetVarList);
        this.mTargetVarList.setModel(new OptimalScalingMissingVarListModel(this, sFormatter));
        this.mTargetVarList.setCellRenderer(new CustomVarListCellRenderer(sFormatter));
        this.mAnalysisVariablesLabel = DialogUtil.createLabel(this, "IDS_OS_ANALYSIS_VARIABLES_LABEL");
        this.mAnalysisVariablesLabel.setLabelFor(this.mTargetVarList);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_CHANGE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptimalScalingMissing.this.handleChangeButtonPress();
            }
        };
        this.mChangeButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_EXCLUDE");
        this.mExcludeRadio = new JRadioButton(toggleButtonAction);
        this.mExcludeRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_IMPUTE");
        this.mImputeRadio = new JRadioButton(toggleButtonAction);
        this.mImputeRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_MODE");
        this.mModeRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_EXTRA_CATEGORY");
        this.mExtraCatRadio = new JRadioButton(toggleButtonAction);
    }

    private void setDefaults() {
        this.mExcludeRadio.setSelected(true);
        this.mModeRadio.setSelected(true);
        this.mModeRadio.setEnabled(false);
        this.mExtraCatRadio.setEnabled(false);
        this.mChangeButton.setEnabled(false);
        this.enableContinue(false);
    }

    private void addComponentsToPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        JPanel jPanel2 = this.setupMissingValueStrategyPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mChangeButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        JPanel jPanel3 = this.setupStrategyPanel();
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 2, 1, n, insets);
    }

    private JPanel setupMissingValueStrategyPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OS_MISSING_VALUE_STRATEGY_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mAnalysisVariablesLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(0, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap() * 2);
        DialogUtil.addUsingGBL(jPanel, this.mTargetVarScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupStrategyPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mExcludeRadio, this.mImputeRadio};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, null);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OS_STRATEGY_PANEL_TITLE")));
        this.mExcludeImputeButtonGroup = DialogUtil.createButtonGroup(jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        JPanel jPanel2 = this.setupModeExtraCatPanel();
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin() * 6, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupModeExtraCatPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin() * 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mModeRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin() * 8, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mExtraCatRadio, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mModeExtraButtonGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTargetVarList);
        vector.add(this.mExcludeImputeButtonGroup);
        vector.add(this.mModeExtraButtonGroup);
        vector.add(this.mChangeButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private boolean isItemPresent(int n, TargetVariableList targetVariableList) {
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            int n2 = targetVariableList.getModel().getElementAt(i).getId().asInt();
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    private void handleChangeButtonPress() {
        int[] nArray;
        String string = this.mExcludeRadio.isSelected() ? this.getResString("IDS_OS_EXCLUDE_DISPLAY_TEXT") : (this.mModeRadio.isSelected() ? this.getResString("IDS_OS_IMPUTE_MODE_DISPLAY_TEXT") : this.getResString("IDS_OS_IMPUTE_EXTRA_CATEGORY_DISPLAY_TEXT"));
        for (int n : nArray = this.mTargetVarList.getSelectedIndices()) {
            ((OptimalScalingMissingVarListModel)this.mTargetVarList.getModel()).setElementPropertyAt(n, string);
        }
        this.enableContinue(true);
    }
}

