/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.optimal_scaling;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingDefineScale;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingDiscretize;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingDlgVarFormatter;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingDlgVarListModel;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingMissing;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingOptions;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingOutput;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingPlots;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingRegularization;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingSave;
import com.spss.java_client.ui.dialogs.market_research.res.MarketResearchResBundle;
import com.spss.uitools.util.CharacterUtil;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OptimalScalingDlg
extends BaseProcedureDialog
implements ListSelectionListener,
ListDataListener,
FocusListener,
IVarMoveHandler {
    static final String DEPENDENT_VAR_LIST_IDENTIFIER = "DependentVarList";
    static final String INDEPENDENT_VAR_LIST_IDENTIFIER = "IndependentVarList";
    private static final String EMPTY_STR = "";
    private static final String SPACE = " ";
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private JLabel mDependentVariableLabel;
    private TargetVariableList mTargetDependentVarList;
    private JScrollPane mTargetDependentScrollPane;
    private JLabel mIndependentVariablesLabel;
    private TargetVariableList mTargetIndependentVarList;
    private JScrollPane mTargetIndependentScrollPane;
    private JButton mDependentDefineScaleButton;
    private JButton mIndependentDefineScaleButton;
    private ArrowButton mDependentArrowButton;
    private ArrowButton mIndependentArrowButton;
    private OptimalScalingDlgVarFormatter mDependentListFormatter;
    private OptimalScalingDlgVarFormatter mIndependentListFormatter;
    private boolean mIsDependent;
    private OptimalScalingDiscretize mDiscretizeSubDlg;
    private OptimalScalingMissing mMissingSubDlg;
    private String mDiscFileName;
    private String mTransFileName;

    public OptimalScalingDlg(JFrame jFrame) {
        super(jFrame, false, MarketResearchResBundle.getDefaultResourceBundleName(), MarketResearchResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_OS_OPTIMAL_SCALING_TITLE"));
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mSrcVarList)) {
            this.mDependentDefineScaleButton.setEnabled(false);
            this.mIndependentDefineScaleButton.setEnabled(false);
        } else if (focusEvent.getSource().equals(this.mTargetDependentVarList)) {
            if (this.mTargetDependentVarList.getSelectedIndex() != -1) {
                this.mDependentDefineScaleButton.setEnabled(true);
                this.mIndependentDefineScaleButton.setEnabled(false);
            }
        } else if (focusEvent.getSource().equals(this.mTargetIndependentVarList) && this.mTargetIndependentVarList.getSelectedIndex() != -1) {
            this.mTargetDependentVarList.clearSelection();
            this.mDependentDefineScaleButton.setEnabled(false);
            this.mIndependentDefineScaleButton.setEnabled(true);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.mTargetDependentVarList)) {
            if (this.mTargetDependentVarList.getSelectedValue() != null) {
                this.mDependentDefineScaleButton.setEnabled(true);
                this.mIndependentDefineScaleButton.setEnabled(false);
            } else {
                this.mDependentDefineScaleButton.setEnabled(false);
                this.mIndependentDefineScaleButton.setEnabled(false);
            }
        } else if (listSelectionEvent.getSource().equals(this.mTargetIndependentVarList)) {
            if (this.mTargetIndependentVarList.getSelectedValue() != null) {
                this.mIndependentDefineScaleButton.setEnabled(true);
                this.mDependentDefineScaleButton.setEnabled(false);
            } else {
                this.mDependentDefineScaleButton.setEnabled(false);
                this.mIndependentDefineScaleButton.setEnabled(false);
            }
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mTargetDependentVarList.getModel())) {
            this.mDependentDefineScaleButton.setEnabled(true);
        } else if (listDataEvent.getSource().equals(this.mTargetIndependentVarList.getModel())) {
            this.mIndependentDefineScaleButton.setEnabled(true);
        }
        this.updateOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mTargetDependentVarList.getModel())) {
            this.mDependentDefineScaleButton.setEnabled(false);
        } else if (listDataEvent.getSource().equals(this.mTargetIndependentVarList.getModel())) {
            this.mIndependentDefineScaleButton.setEnabled(this.mTargetIndependentVarList.getModel().getSize() > 0);
        }
        this.updateDialogDataModel("OUTPUT_CATEGORY_LIST_KEY");
        this.updateDialogDataModel("OUTPUT_DESCRIPTIVES_LIST_KEY");
        this.updateDialogDataModel("PLOTS_TRANSFORMATION_LIST_KEY");
        this.updateDialogDataModel("PLOTS_RESIDUAL_LIST_KEY");
        this.updateOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        if (variableList instanceof SrcVariableList) {
            VarListModel varListModel;
            Vector<ISpssVariable> vector = this.getVector(iSpssVariableArray);
            if (this.mDiscretizeSubDlg != null) {
                varListModel = this.mDiscretizeSubDlg.getListModel();
                this.updateModel(varListModel, vector);
            }
            if (this.mMissingSubDlg != null) {
                varListModel = this.mMissingSubDlg.getListModel();
                this.updateModel(varListModel, vector);
            }
        }
        return true;
    }

    @Override
    public String generateSyntax() {
        String string;
        String string2;
        Object object;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        this.mDiscFileName = null;
        this.mTransFileName = null;
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_OS_CREATE_DISCRETIZED_DATA");
        if (bl != null && bl.booleanValue() && (object = this.getDialogDataModel().getBoolean("IDS_OS_DISCRETIZED_CREATE_NEW_DATASET")) != null && ((Boolean)object).booleanValue()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("DATASET DECLARE "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.getDialogDataModel().getString("DISCRETIZED_DATA_SET_NAME_KEY")));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_OS_CREATE_TRANSFORMED_VARS")) != null && bl.booleanValue() && (object = this.getDialogDataModel().getBoolean("IDS_OS_TRANSFROMED_CREATE_NEW_DATASET")) != null && ((Boolean)object).booleanValue()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("DATASET DECLARE "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.getDialogDataModel().getString("TRANSFORMED_DATA_SET_NAME_KEY")));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        object = null;
        String string3 = null;
        if (this.needUniqueRegularizationDatasetName()) {
            object = SpssMgr.getSpssMgr().getNextFreeDatasetName();
        }
        if (this.needUniqueRegressionDatasetName()) {
            string3 = SpssMgr.getSpssMgr().getNextFreeDatasetName();
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_OS_SAVE_REGU_CREATE_NEW_DATASET")) != null && bl.booleanValue()) {
            object = this.getDialogDataModel().getString("REGULARIZED_DATA_SET_NAME_KEY");
        }
        if (object != null && this.needRegularizationDatasetDeclare()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("DATASET DECLARE "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters((String)object));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_OS_SAVE_REG_CREATE_NEW_DATASET")) != null && bl.booleanValue()) {
            string3 = this.getDialogDataModel().getString("REGRESSION_DATA_SET_NAME_KEY");
        }
        if (string3 != null && this.needReressionDatasetDeclare()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("DATASET DECLARE "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string3));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("CATREG"));
        stringBuffer.append(this.getVariablesSyntax());
        stringBuffer.append(this.getAnalysisSyntax());
        String string4 = this.getDiscretizationSyntax();
        if (string4.length() > 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/DISCRETIZATION="));
            stringBuffer.append(string4);
            stringBuffer.append("\n");
        }
        stringBuffer.append(this.getMissingSyntax());
        String string5 = this.getSupplementarySyntax();
        if (string5.length() > 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/SUPPLEMENTARY="));
            stringBuffer.append("OBJECT(");
            stringBuffer.append(string5.trim());
            stringBuffer.append(")");
            stringBuffer.append("\n");
        }
        stringBuffer.append(this.getMaxIterSyntax());
        stringBuffer.append(this.getCritIterSyntax());
        String string6 = this.getPrintSyntax();
        if (string6.length() > 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT="));
            stringBuffer.append(string6);
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT=NONE"));
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.getInitialSyntax(string3));
        String string7 = this.getPlotSyntax();
        if (string7.length() > 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT="));
            stringBuffer.append(string7);
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT=NONE"));
        }
        String string8 = this.getSaveSyntax();
        if (string8.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SAVE="));
            stringBuffer.append(string8);
        }
        if ((string2 = this.getOutfileSyntax()).length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/OUTFILE="));
            stringBuffer.append(string2);
        }
        stringBuffer.append("\n");
        String string9 = this.getRegularizationSyntax((String)object);
        stringBuffer.append(string9);
        stringBuffer.append("\n");
        String string10 = this.getResampleSyntax();
        stringBuffer.append(string10);
        stringBuffer.append(SyntaxUtil.terminateSyntax().toString());
        PesFile pesFile = PES_Repository.getPesFile((String)this.mDiscFileName);
        if (pesFile != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        if ((pesFile = PES_Repository.getPesFile((String)this.mTransFileName)) != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private boolean needUniqueRegularizationDatasetName() {
        boolean bl = false;
        Boolean bl2 = this.getDialogDataModel().getBoolean("IDS_OS_REG_NONE_LABEL");
        if (bl2 == null) {
            return false;
        }
        if (!bl2.booleanValue() && (bl2 = this.getDialogDataModel().getBoolean("IDS_OS_SAVE_REGU_CREATE_NEW_DATASET")) == null) {
            bl = true;
        }
        return bl;
    }

    private boolean needRegularizationDatasetDeclare() {
        boolean bl = false;
        Boolean bl2 = this.getDialogDataModel().getBoolean("IDS_OS_REG_NONE_LABEL");
        if (bl2 == null) {
            return false;
        }
        if (!bl2.booleanValue()) {
            bl2 = this.getDialogDataModel().getBoolean("IDS_OS_SAVE_REGU_CREATE_NEW_DATASET");
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else if (bl2 == null) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean needReressionDatasetDeclare() {
        boolean bl = false;
        Boolean bl2 = this.getDialogDataModel().getBoolean("IDS_OS_MULTIPLE");
        if (bl2 != null && bl2.booleanValue()) {
            Boolean bl3 = this.getDialogDataModel().getBoolean("IDS_OS_SAVE_REG_CREATE_NEW_DATASET");
            if (bl3 != null && bl3.booleanValue()) {
                bl = true;
            } else if (bl3 == null) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean needUniqueRegressionDatasetName() {
        Boolean bl;
        boolean bl2 = false;
        Boolean bl3 = this.getDialogDataModel().getBoolean("IDS_OS_MULTIPLE");
        if (bl3 != null && bl3.booleanValue() && (bl = this.getDialogDataModel().getBoolean("IDS_OS_SAVE_REG_CREATE_NEW_DATASET")) == null) {
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_catr";
    }

    @Override
    public String getIActionKey() {
        return "analyze_regression_optimal_scaling";
    }

    @Override
    public void reset() {
        super.reset();
        this.mDependentListFormatter.getVarMap().clear();
        this.mIndependentListFormatter.getVarMap().clear();
        if (OptimalScalingDiscretize.getFormatter() != null) {
            OptimalScalingDiscretize.getFormatter().getVarMap().clear();
        }
        if (OptimalScalingMissing.getFormatter() != null) {
            OptimalScalingMissing.getFormatter().getVarMap().clear();
        }
        this.mTargetIndependentVarList.removeAll();
        this.mTargetDependentVarList.removeAll();
        this.setDefaults();
        this.updateOkPaste();
    }

    @Override
    public BaseProcedureDialog.NameLabelOption getNameLabelOverride() {
        return BaseProcedureDialog.NameLabelOption.show_names;
    }

    TargetVariableList getDependentVarList() {
        return this.mTargetDependentVarList;
    }

    TargetVariableList getIndependentVarList() {
        return this.mTargetIndependentVarList;
    }

    boolean getDependentFlag() {
        return this.mIsDependent;
    }

    @Override
    protected void loadDialogState() {
        OptimalScalingDlg.setAddMissingVars(false);
        super.loadDialogState();
        OptimalScalingDlg.setAddMissingVars(true);
        boolean bl = false;
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options");
        Preferences preferences3 = preferences2.node("general");
        bl = preferences3.get("var_list_display", PrefDefaults.DEF_VAR_LIST_DISPLAY_LABELS).equals(IOptionConstants.VAR_LIST_DISPLAY_VALUES[0]);
        this.mSrcVarList.getModel().setShowVarLabels(bl);
        this.mDependentListFormatter.setVarMap(this.getDialogDataModel().getMap("DEPENDENT_LIST_FORMATTER_KEY"));
        this.mIndependentListFormatter.setVarMap(this.getDialogDataModel().getMap("INDEPENDENT_LIST_FORMATTER_KEY"));
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putMap("DEPENDENT_LIST_FORMATTER_KEY", this.mDependentListFormatter.getVarMapForSerialization());
        this.getDialogDataModel().putMap("INDEPENDENT_LIST_FORMATTER_KEY", this.mIndependentListFormatter.getVarMapForSerialization());
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        this.addComponentsToPanel(jPanel);
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_DISCRETIZE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptimalScalingDlg.this.runDiscretizeSubDialog();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_MISSING"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptimalScalingDlg.this.runMissingSubDialog();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptimalScalingDlg.this.runOptionsSubDialog();
            }
        };
        JButton jButton3 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton3);
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_REGU_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptimalScalingDlg.this.runRegularizationSubDialog();
            }
        };
        JButton jButton4 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton4);
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OUTPUT_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptimalScalingDlg.this.runOutputSubDialog();
            }
        };
        JButton jButton5 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton5);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_SAVE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptimalScalingDlg.this.runSaveSubDialog();
            }
        };
        JButton jButton6 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton6);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            jButton6.setEnabled(false);
        }
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_PLOTS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptimalScalingDlg.this.runPlotsSubDialog();
            }
        };
        JButton jButton7 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton7);
        return jPanel;
    }

    private Vector<ISpssVariable> getVector(ISpssVariable[] iSpssVariableArray) {
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        vector.addAll(Arrays.asList(iSpssVariableArray));
        return vector;
    }

    private void updateModel(VarListModel varListModel, Vector<ISpssVariable> vector) {
        for (int i = 0; i < varListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            if (!vector.contains(iSpssVariable)) continue;
            varListModel.removeElementAt(i);
        }
    }

    private boolean isItemPresent(LocallyUniqueId locallyUniqueId, TargetVariableList targetVariableList) {
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            LocallyUniqueId locallyUniqueId2 = targetVariableList.getModel().getElementAt(i).getId();
            if (!locallyUniqueId2.equals((Object)locallyUniqueId)) continue;
            return true;
        }
        return false;
    }

    private void updateDialogDataModel(String string) {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(string);
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        if (iSpssVariableArray != null) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (!this.isItemPresent(iSpssVariable.getId(), this.mTargetDependentVarList) && !this.isItemPresent(iSpssVariable.getId(), this.mTargetIndependentVarList)) continue;
                vector.add(iSpssVariable);
            }
            if (vector.size() > 0) {
                ISpssVariable[] iSpssVariableArray2 = new ISpssVariable[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    iSpssVariableArray2[i] = (ISpssVariable)vector.get(i);
                }
                dialogDataModel.putVarArray(string, iSpssVariableArray2);
            } else {
                dialogDataModel.putVarArray(string, null);
            }
        }
    }

    private String getVariablesSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES="));
        SpssVariable spssVariable = (SpssVariable)this.mTargetDependentVarList.getModel().getElementAt(0);
        stringBuffer.append(spssVariable.getName());
        stringBuffer.append(SPACE);
        for (int i = 0; i < this.mTargetIndependentVarList.getModel().getSize(); ++i) {
            spssVariable = (SpssVariable)this.mTargetIndependentVarList.getModel().getElementAt(i);
            stringBuffer.append(spssVariable.getName());
            if (i == this.mTargetIndependentVarList.getModel().getSize() - 1) continue;
            stringBuffer.append(SPACE);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String getAnalysisSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/ANALYSIS="));
        SpssVariable spssVariable = (SpssVariable)this.mTargetDependentVarList.getModel().getElementAt(0);
        stringBuffer.append(spssVariable.getName());
        stringBuffer.append("(LEVEL=");
        String string = (String)this.mDependentListFormatter.getVarMap().get(spssVariable.getId().asInt());
        String string2 = this.getDefineScaleValue(string);
        stringBuffer.append(string2);
        stringBuffer.append(") WITH ");
        for (int i = 0; i < this.mTargetIndependentVarList.getModel().getSize(); ++i) {
            spssVariable = (SpssVariable)this.mTargetIndependentVarList.getModel().getElementAt(i);
            stringBuffer.append(spssVariable.getName());
            stringBuffer.append("(LEVEL=");
            string = (String)this.mIndependentListFormatter.getVarMap().get(spssVariable.getId().asInt());
            string2 = this.getDefineScaleValue(string);
            stringBuffer.append(string2);
            stringBuffer.append(")");
            if (i == this.mTargetIndependentVarList.getModel().getSize() - 1) continue;
            stringBuffer.append(SPACE);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String getDefineScaleValue(String string) {
        String string2 = EMPTY_STR;
        if (string.equals("(" + this.getResString("IDS_OS_NUMERIC_DISPLAY_TEXT") + ")")) {
            string2 = "NUME";
        } else if (string.equals("(" + this.getResString("IDS_OS_ORDINAL_DISPLAY_TEXT") + ")")) {
            string2 = "ORDI";
        } else if (string.equals("(" + this.getResString("IDS_OS_NOMINAL_DISPLAY_TEXT") + ")")) {
            string2 = "NOMI";
        } else if (string.contains(this.getResString("IDS_OS_SPLINE_ORDINAL_DISPLAY_TEXT"))) {
            int n = string.lastIndexOf(SPACE);
            String string3 = string.substring(n + 1, string.length() - 1);
            String string4 = string.substring(0, n);
            n = string4.lastIndexOf(SPACE);
            String string5 = string4.substring(n + 1, string4.length());
            string2 = "SPORD,DEGREE=" + string5 + "," + "INKNOT" + "=" + string3;
        } else if (string.contains(this.getResString("IDS_OS_SPLINE_NOMINAL_DISPLAY_TEXT"))) {
            int n = string.indexOf(SPACE);
            int n2 = string.indexOf(SPACE, n + 1);
            int n3 = string.indexOf(SPACE, n2 + 1);
            String string6 = string.substring(n2 + 1, n3);
            String string7 = string.substring(n3 + 1, string.length() - 1);
            string2 = "SPNOM,DEGREE=" + string6 + "," + "INKNOT" + "=" + string7;
        }
        return string2;
    }

    private String getDiscretizationSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        SpssVariable spssVariable = (SpssVariable)this.mTargetDependentVarList.getModel().getElementAt(0);
        OptimalScalingDlgVarFormatter optimalScalingDlgVarFormatter = OptimalScalingDiscretize.getFormatter();
        if (optimalScalingDlgVarFormatter != null) {
            String string = (String)optimalScalingDlgVarFormatter.getVarMap().get(spssVariable.getId().asInt());
            if (string != null && !string.equals("(" + this.getResString("IDS_OS_UNSPECIFIED_DISPLAY_TEXT") + ")")) {
                stringBuffer.append(spssVariable.getName());
                stringBuffer.append("(");
                String string2 = this.getDiscretizationValue(string);
                stringBuffer.append(string2);
                stringBuffer.append(")");
                stringBuffer.append(SPACE);
            }
            for (int i = 0; i < this.mTargetIndependentVarList.getModel().getSize(); ++i) {
                spssVariable = (SpssVariable)this.mTargetIndependentVarList.getModel().getElementAt(i);
                string = (String)optimalScalingDlgVarFormatter.getVarMap().get(spssVariable.getId().asInt());
                if (string == null || string.equals("(" + this.getResString("IDS_OS_UNSPECIFIED_DISPLAY_TEXT") + ")")) continue;
                stringBuffer.append(spssVariable.getName());
                stringBuffer.append("(");
                String string3 = this.getDiscretizationValue(string);
                stringBuffer.append(string3);
                stringBuffer.append(")");
                stringBuffer.append(SPACE);
            }
        }
        return stringBuffer.toString();
    }

    private String getDiscretizationValue(String string) {
        String string2;
        if (string.equals("(" + this.getResString("IDS_OS_RANKING_DISPLAY_TEXT") + ")")) {
            string2 = "RANKING";
        } else if (string.equals("(" + this.getResString("IDS_OS_MULTIPLYING_DISPLAY_TEXT") + ")")) {
            string2 = "MULTIPLYING";
        } else if (string.contains(this.getResString("IDS_OS_NORMAL_DISPLAY_TEXT"))) {
            int n = string.indexOf(SPACE);
            int n2 = string.indexOf(SPACE, n + 1);
            String string3 = string.substring(n2 + 1, string.length() - 1);
            string2 = "GROUPING,NCAT=" + string3 + ",DISTR=NORMAL";
        } else if (string.contains(this.getResString("IDS_OS_UNIFORM_DISPLAY_TEXT"))) {
            int n = string.indexOf(SPACE);
            int n3 = string.indexOf(SPACE, n + 1);
            String string4 = string.substring(n3 + 1, string.length() - 1);
            string2 = "GROUPING,NCAT=" + string4 + ",DISTR=UNIFORM";
        } else {
            String string5 = this.getResString("IDS_OS_GROUPING_DISPLAY_TEXT");
            int n = string.indexOf("(" + string5);
            int n4 = string.indexOf(")");
            string2 = n >= 0 && n4 > 0 ? "GROUPING,EQINTV=" + string.substring(n + string5.length() + 2, n4) : EMPTY_STR;
        }
        return string2;
    }

    private String getMissingSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING="));
        SpssVariable spssVariable = (SpssVariable)this.mTargetDependentVarList.getModel().getElementAt(0);
        OptimalScalingDlgVarFormatter optimalScalingDlgVarFormatter = OptimalScalingMissing.getFormatter();
        if (optimalScalingDlgVarFormatter != null) {
            stringBuffer.append(spssVariable.getName());
            String string = (String)optimalScalingDlgVarFormatter.getVarMap().get(spssVariable.getId().asInt());
            if (string != null) {
                if (string.equals("(" + this.getResString("IDS_OS_EXCLUDE_DISPLAY_TEXT") + ")")) {
                    stringBuffer.append("(LISTWISE)");
                } else if (string.contains(this.getResString("IDS_OS_IMPUTE_MODE_DISPLAY_TEXT"))) {
                    stringBuffer.append("(MODEIMPU)");
                } else {
                    stringBuffer.append("(EXTRACAT)");
                }
                stringBuffer.append(SPACE);
            } else {
                stringBuffer.append("(LISTWISE)");
                stringBuffer.append(SPACE);
            }
            for (int i = 0; i < this.mTargetIndependentVarList.getModel().getSize(); ++i) {
                spssVariable = (SpssVariable)this.mTargetIndependentVarList.getModel().getElementAt(i);
                stringBuffer.append(spssVariable.getName());
                string = (String)optimalScalingDlgVarFormatter.getVarMap().get(spssVariable.getId().asInt());
                if (string != null) {
                    if (string.equals("(" + this.getResString("IDS_OS_EXCLUDE_DISPLAY_TEXT") + ")")) {
                        stringBuffer.append("(LISTWISE)");
                    } else if (string.contains(this.getResString("IDS_OS_IMPUTE_MODE_DISPLAY_TEXT"))) {
                        stringBuffer.append("(MODEIMPU)");
                    } else {
                        stringBuffer.append("(EXTRACAT)");
                    }
                    if (i == this.mTargetIndependentVarList.getModel().getSize() - 1) continue;
                    stringBuffer.append(SPACE);
                    continue;
                }
                stringBuffer.append("(LISTWISE)");
                if (i == this.mTargetIndependentVarList.getModel().getSize() - 1) continue;
                stringBuffer.append(SPACE);
            }
        } else {
            stringBuffer.append(spssVariable.getName());
            stringBuffer.append("(LISTWISE)");
            stringBuffer.append(SPACE);
            for (int i = 0; i < this.mTargetIndependentVarList.getModel().getSize(); ++i) {
                spssVariable = (SpssVariable)this.mTargetIndependentVarList.getModel().getElementAt(i);
                stringBuffer.append(spssVariable.getName());
                stringBuffer.append("(LISTWISE)");
                if (i == this.mTargetIndependentVarList.getModel().getSize() - 1) continue;
                stringBuffer.append(SPACE);
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String getSupplementarySyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.getDialogDataModel().getArray("BASIC_ACR_WIDGET_KEY");
        if (objectArray != null) {
            for (Object object : objectArray) {
                String string = (String)object;
                if (string.contains("-")) {
                    int n = string.indexOf(SPACE);
                    int n2 = string.indexOf(SPACE, n + 1);
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n2 + 1, string.length());
                    stringBuffer.append(string2).append(" TO ").append(string3);
                } else {
                    stringBuffer.append(string);
                }
                stringBuffer.append(SPACE);
            }
        }
        return stringBuffer.toString();
    }

    private String getMaxIterSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/MAXITER="));
        String string = this.getDialogDataModel().getString("ITER_TEXT_FIELD_KEY");
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("100");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String getCritIterSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITITER="));
        String string = this.getDialogDataModel().getString("CONVERGENCE_TEXT_FIELD_KEY");
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(".00001");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String getPrintSyntax() {
        Boolean bl;
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl2 = this.getDialogDataModel().getBoolean("IDS_OS_MULTIPLE_R");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                stringBuffer.append("R ");
            }
        } else {
            stringBuffer.append("R ");
        }
        if ((bl2 = this.getDialogDataModel().getBoolean("IDS_OS_CO_EFFICIENTS")) != null) {
            if (bl2.booleanValue()) {
                stringBuffer.append("COEFF ");
            }
        } else {
            stringBuffer.append("COEFF ");
        }
        if ((bl2 = this.getDialogDataModel().getBoolean("IDS_OS_ITERATION_HISTORY")) != null && bl2.booleanValue()) {
            stringBuffer.append("HISTORY ");
        }
        if ((bl2 = this.getDialogDataModel().getBoolean("IDS_OS_CORRELATION_ORIG_VARS")) != null && bl2.booleanValue()) {
            stringBuffer.append("OCORR ");
        }
        if ((bl2 = this.getDialogDataModel().getBoolean("IDS_OS_CORRELATION_TRANS_VARS")) != null && bl2.booleanValue()) {
            stringBuffer.append("CORR ");
        }
        if ((bl2 = this.getDialogDataModel().getBoolean("IDS_OS_ANOVA")) != null) {
            if (bl2.booleanValue()) {
                stringBuffer.append("ANOVA ");
            }
        } else {
            stringBuffer.append("ANOVA");
        }
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        ISpssVariable[] iSpssVariableArray = this.getDialogDataModel().getVarArray("OUTPUT_DESCRIPTIVES_LIST_KEY");
        if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
            stringBuffer.append("DESCRIP(");
            for (n = 0; n < iSpssVariableArray.length; ++n) {
                object = iSpssVariableArray[n];
                stringBuffer.append(object.getName());
                if (n == iSpssVariableArray.length - 1) continue;
                stringBuffer.append(SPACE);
            }
            stringBuffer.append(")");
            stringBuffer.append(SPACE);
        }
        if ((iSpssVariableArray = this.getDialogDataModel().getVarArray("OUTPUT_CATEGORY_LIST_KEY")) != null && iSpssVariableArray.length > 0) {
            stringBuffer.append("QUANT(");
            for (n = 0; n < iSpssVariableArray.length; ++n) {
                object = iSpssVariableArray[n];
                stringBuffer.append(object.getName());
                if (n == iSpssVariableArray.length - 1) continue;
                stringBuffer.append(SPACE);
            }
            stringBuffer.append(")");
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_OS_REG_NONE_LABEL")) != null && !bl.booleanValue() && (object = this.getDialogDataModel().getBoolean("IDS_OS_OUTPUT_REGULARIZED_MODELS")) != null && ((Boolean)object).booleanValue()) {
            stringBuffer.append(" REGU");
        }
        return stringBuffer.toString();
    }

    private String getInitialSyntax(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/INITIAL="));
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_OS_NUMERICAL");
        Boolean bl2 = this.getDialogDataModel().getBoolean("IDS_OS_RANDOM");
        Boolean bl3 = this.getDialogDataModel().getBoolean("IDS_OS_MULTIPLE");
        Boolean bl4 = this.getDialogDataModel().getBoolean("IDS_OS_USEFIXED");
        if (bl != null) {
            if (bl.booleanValue()) {
                stringBuffer.append("NUMERICAL");
            } else if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append("RANDOM");
            } else if (bl3 != null && bl3.booleanValue()) {
                stringBuffer.append(this.getMultiStartSyntax(string));
            } else if (bl4 != null && bl4.booleanValue()) {
                stringBuffer.append(this.getFixSignsSyntax());
            }
        } else {
            stringBuffer.append("NUMERICAL");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String getMultiStartSyntax(String string) {
        String string2;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MULTISTART(");
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_OS_ALL_POSSIBLE");
        Boolean bl2 = this.getDialogDataModel().getBoolean("IDS_OS_REDUCED_NUM");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("ALL");
        } else if (bl2 != null && bl2.booleanValue()) {
            object = this.getDialogDataModel().getString("LOSS_OF_VARIANCE_TEXTFIELD_KEY");
            stringBuffer.append((String)object);
        }
        stringBuffer.append(") ");
        object = this.getDialogDataModel().getBoolean("IDS_OS_SAVE_REG_CREATE_NEW_DATASET");
        if (object != null) {
            if (((Boolean)object).booleanValue()) {
                string2 = this.getDialogDataModel().getString("REGRESSION_DATA_SET_NAME_KEY");
                stringBuffer.append("(" + string2 + ")");
            }
        } else {
            stringBuffer.append("(" + string + ")");
        }
        if ((object = this.getDialogDataModel().getBoolean("IDS_OS_SAVE_REG_WRITE_NEW_DATA_FILE")) != null && ((Boolean)object).booleanValue()) {
            string2 = CharacterUtil.smartQuote((String)this.getDialogDataModel().getString("REGRESSION_FILE_TEXT_FIELD"));
            stringBuffer.append("(" + string2 + ")");
        }
        return stringBuffer.toString();
    }

    private String getFixSignsSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FIXSIGNS(");
        String string = this.getDialogDataModel().getString("CASE_NUM_OF_SIGN_PATTERNS_KEY");
        stringBuffer.append(string + ")(");
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_OS_READ_DATASET");
        Boolean bl2 = this.getDialogDataModel().getBoolean("IDS_OS_READ_DATAFILE");
        if (bl != null && bl.booleanValue()) {
            String string2 = this.getDialogDataModel().getString("IDS_OS_DATASET");
            stringBuffer.append(string2);
        } else if (bl2 != null && bl2.booleanValue()) {
            String string3 = CharacterUtil.smartQuote((String)this.getDialogDataModel().getString("IDS_OS_DS_FILE"));
            stringBuffer.append(string3);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String getPlotSyntax() {
        Boolean bl;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        ISpssVariable[] iSpssVariableArray = this.getDialogDataModel().getVarArray("PLOTS_TRANSFORMATION_LIST_KEY");
        if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
            stringBuffer.append("TRANS(");
            for (int i = 0; i < iSpssVariableArray.length; ++i) {
                object = iSpssVariableArray[i];
                stringBuffer.append(object.getName());
                if (i == iSpssVariableArray.length - 1) continue;
                stringBuffer.append(SPACE);
            }
            stringBuffer.append(")(");
            bl = this.getDialogDataModel().getBoolean("IDS_OS_VARIABLE_LABELS");
            if (bl != null) {
                if (bl.booleanValue()) {
                    stringBuffer.append(this.getDialogDataModel().getString("LIMIT_TEXT_FIELD_KEY"));
                } else {
                    stringBuffer.append("0");
                }
            } else {
                stringBuffer.append("20");
            }
            stringBuffer.append(")");
            stringBuffer.append(SPACE);
        }
        if ((iSpssVariableArray = this.getDialogDataModel().getVarArray("PLOTS_RESIDUAL_LIST_KEY")) != null && iSpssVariableArray.length > 0) {
            stringBuffer.append("RESID(");
            for (int i = 0; i < iSpssVariableArray.length; ++i) {
                object = iSpssVariableArray[i];
                stringBuffer.append(object.getName());
                if (i == iSpssVariableArray.length - 1) continue;
                stringBuffer.append(SPACE);
            }
            stringBuffer.append(")(");
            bl = this.getDialogDataModel().getBoolean("IDS_OS_VARIABLE_LABELS");
            if (bl != null) {
                if (bl.booleanValue()) {
                    stringBuffer.append(this.getDialogDataModel().getString("LIMIT_TEXT_FIELD_KEY"));
                } else {
                    stringBuffer.append("0");
                }
            } else {
                stringBuffer.append("20");
            }
            stringBuffer.append(")");
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_OS_REG_DISPLAY_REG_PLOTS")) != null && bl.booleanValue() && (object = this.getDialogDataModel().getBoolean("IDS_OS_REG_NONE_LABEL")) != null && !((Boolean)object).booleanValue()) {
            stringBuffer.append(" REGU");
            Boolean bl2 = this.getDialogDataModel().getBoolean("IDS_OS_REG_ELASTIC_NET");
            if (bl2 != null && bl2.booleanValue()) {
                Object[] objectArray;
                Boolean bl3 = this.getDialogDataModel().getBoolean("IDS_OS_REG_PRODUCE_ALL");
                if (bl3 != null && bl3.booleanValue()) {
                    stringBuffer.append("(ALL)");
                }
                Boolean bl4 = this.getDialogDataModel().getBoolean("IDS_OS_REG_PRODUCE_SOME");
                if (bl3 != null && bl4.booleanValue() && (objectArray = this.getDialogDataModel().getArray("REGULARIZATION_BASIC_ACR_WIDGET_KEY")) != null) {
                    stringBuffer.append("(");
                    for (int i = 0; i < objectArray.length; ++i) {
                        String string = (String)objectArray[i];
                        if (string.contains("-")) {
                            int n = string.indexOf(SPACE);
                            int n2 = string.indexOf(SPACE, n + 1);
                            String string2 = string.substring(0, n);
                            String string3 = string.substring(n2 + 1, string.length());
                            stringBuffer.append(string2 + SPACE + "TO" + SPACE + string3);
                        } else {
                            stringBuffer.append(string);
                        }
                        stringBuffer.append(SPACE);
                    }
                    stringBuffer.append(")");
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getSaveSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_OS_SAVE_TRANSFORMED_VARS");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("TRDATA");
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_OS_SAVE_PREDICTED_VALUES")) != null && bl.booleanValue()) {
            stringBuffer.append(SPACE);
            stringBuffer.append("PRED");
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_OS_SAVE_RESIDUALS")) != null && bl.booleanValue()) {
            stringBuffer.append(SPACE);
            stringBuffer.append("RES");
        }
        return stringBuffer.toString();
    }

    private String getOutfileSyntax() {
        Boolean bl;
        Boolean bl2;
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl3 = this.getDialogDataModel().getBoolean("IDS_OS_CREATE_DISCRETIZED_DATA");
        if (bl3 != null && bl3.booleanValue()) {
            bl2 = this.getDialogDataModel().getBoolean("IDS_OS_DISCRETIZED_CREATE_NEW_DATASET");
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append("DISCRDATA(").append(this.getDialogDataModel().getString("DISCRETIZED_DATA_SET_NAME_KEY")).append(")");
            } else {
                bl = this.getDialogDataModel().getBoolean("IDS_OS_DISCRETIZED_WRITE_NEW_DATA_FILE");
                if (bl != null && bl.booleanValue()) {
                    this.mDiscFileName = this.getDialogDataModel().getString("DISCRETIZED_FILE_TEXT_FIELD");
                    stringBuffer.append("DISCRDATA(").append(CharacterUtil.smartQuote((String)this.mDiscFileName)).append(")");
                }
            }
        }
        if ((bl3 = this.getDialogDataModel().getBoolean("IDS_OS_CREATE_TRANSFORMED_VARS")) != null && bl3.booleanValue()) {
            bl2 = this.getDialogDataModel().getBoolean("IDS_OS_TRANSFROMED_CREATE_NEW_DATASET");
            if (bl2 != null && bl2.booleanValue()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(SPACE);
                }
                stringBuffer.append("TRDATA(").append(this.getDialogDataModel().getString("TRANSFORMED_DATA_SET_NAME_KEY")).append(")");
            } else {
                bl = this.getDialogDataModel().getBoolean("IDS_OS_TRANSFORMED_WRITE_NEW_DATA_FILE");
                if (bl != null && bl.booleanValue()) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(SPACE);
                    }
                    this.mTransFileName = this.getDialogDataModel().getString("TRANSFORMED_FILE_TEXT_FIELD");
                    stringBuffer.append("TRDATA(").append(CharacterUtil.smartQuote((String)this.mTransFileName)).append(")");
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getRegularizationSyntax(String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_OS_REG_NONE_LABEL");
        if (bl != null) {
            if (bl.booleanValue()) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/REGULARIZATION=NONE"));
            }
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/REGULARIZATION=NONE"));
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_OS_REG_RIDGE_REGRESSION")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/REGULARIZATION=RIDGE("));
            string2 = this.getDialogDataModel().getString("IDS_OS_REG_RIDGE_MIN_EDIT");
            stringBuffer.append(string2 + ",");
            string2 = this.getDialogDataModel().getString("IDS_OS_REG_RIDGE_MAX_EDIT");
            stringBuffer.append(string2 + ",");
            string2 = this.getDialogDataModel().getString("IDS_OS_REG_RIDGE_INCR_EDIT");
            stringBuffer.append(string2 + ")");
            this.addRegularizationFilespecSyntax(stringBuffer, string);
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_OS_REG_LASSO")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/REGULARIZATION=LASSO("));
            string2 = this.getDialogDataModel().getString("IDS_OS_REG_LASSO_MIN_EDIT");
            stringBuffer.append(string2 + ",");
            string2 = this.getDialogDataModel().getString("IDS_OS_REG_LASSO_MAX_EDIT");
            stringBuffer.append(string2 + ",");
            string2 = this.getDialogDataModel().getString("IDS_OS_REG_LASSO_INCR_EDIT");
            stringBuffer.append(string2 + ")");
            this.addRegularizationFilespecSyntax(stringBuffer, string);
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_OS_REG_ELASTIC_NET")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/REGULARIZATION=ENET("));
            string2 = this.getDialogDataModel().getString("IDS_OS_REG_ELN_RIDGE_MIN_EDIT");
            stringBuffer.append(string2 + ",");
            string2 = this.getDialogDataModel().getString("IDS_OS_REG_ELN_RIDGE_MAX_EDIT");
            stringBuffer.append(string2 + ",");
            string2 = this.getDialogDataModel().getString("IDS_OS_REG_ELN_RIDGE_INCR_EDIT");
            stringBuffer.append(string2 + ")");
            string2 = this.getDialogDataModel().getString("IDS_OS_REG_ELN_LASSO_MIN_EDIT");
            stringBuffer.append("(" + string2 + ",");
            string2 = this.getDialogDataModel().getString("IDS_OS_REG_ELN_LASSO_MAX_EDIT");
            stringBuffer.append(string2 + ",");
            string2 = this.getDialogDataModel().getString("IDS_OS_REG_ELN_LASSO_INCR_EDIT");
            stringBuffer.append(string2 + ")");
            this.addRegularizationFilespecSyntax(stringBuffer, string);
        }
        return stringBuffer.toString();
    }

    private void addRegularizationFilespecSyntax(StringBuffer stringBuffer, String string) {
        String string2;
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_OS_SAVE_REGU_CREATE_NEW_DATASET");
        if (bl != null) {
            if (bl.booleanValue() && (string2 = this.getDialogDataModel().getString("REGULARIZED_DATA_SET_NAME_KEY")) != null) {
                stringBuffer.append("(" + string2 + ")");
            }
        } else {
            stringBuffer.append("(" + string + ")");
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_OS_SAVE_REGU_WRITE_NEW_DATA_FILE")) != null && bl.booleanValue() && (string2 = CharacterUtil.smartQuote((String)this.getDialogDataModel().getString("REGULARIZED_FILE_TEXT_FIELD"))) != null) {
            stringBuffer.append("(" + string2 + ")");
        }
    }

    private String getResampleSyntax() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_OS_OUTPUT_NONE");
        if (bl != null) {
            if (bl.booleanValue()) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/RESAMPLE=NONE"));
            }
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/RESAMPLE=NONE"));
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_OS_OUTPUT_CROSSVALIDATION")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/RESAMPLE=CROSSVAL("));
            string = this.getDialogDataModel().getString("IDS_OS_OUTPUT_NUM_FOLDS");
            stringBuffer.append(string + ")");
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_OS_OUTPUT_632_BOOTSTRAP")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/RESAMPLE=BOOTSTRAP("));
            string = this.getDialogDataModel().getString("IDS_OS_OUTPUT_NUM_SAMPLES");
            stringBuffer.append(string + ")");
        }
        return stringBuffer.toString();
    }

    private void runDefineScaleSubDialog() {
        boolean bl = this.mIsDependent = this.mTargetDependentVarList.getSelectedValue() != null;
        if (this.runSubDialog(new OptimalScalingDefineScale(this))) {
            String string = this.getNewValue();
            if (this.mTargetDependentVarList.getSelectedValue() != null) {
                int n = this.mTargetDependentVarList.getSelectedIndex();
                ((OptimalScalingDlgVarListModel)this.mTargetDependentVarList.getModel()).setElementPropertyAt(n, string);
            } else {
                int[] nArray;
                for (int n : nArray = this.mTargetIndependentVarList.getSelectedIndices()) {
                    ((OptimalScalingDlgVarListModel)this.mTargetIndependentVarList.getModel()).setElementPropertyAt(n, string);
                }
            }
        }
    }

    private String getNewValue() {
        String string = EMPTY_STR;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (dialogDataModel.getBoolean("IDS_OS_SPLINE_ORDINAL") != null && dialogDataModel.getBoolean("IDS_OS_SPLINE_ORDINAL").booleanValue()) {
            String string2 = dialogDataModel.getString("DEGREE_TEXT_FIELD_KEY");
            String string3 = dialogDataModel.getString("INTERIOR_KNOTS_TEXT_FIELD_KEY");
            string = this.getResString("IDS_OS_SPLINE_ORDINAL_DISPLAY_TEXT") + SPACE + string2 + SPACE + string3;
        } else if (dialogDataModel.getBoolean("IDS_OS_SPLINE_NOMINAL") != null && dialogDataModel.getBoolean("IDS_OS_SPLINE_NOMINAL").booleanValue()) {
            String string4 = dialogDataModel.getString("DEGREE_TEXT_FIELD_KEY");
            String string5 = dialogDataModel.getString("INTERIOR_KNOTS_TEXT_FIELD_KEY");
            string = this.getResString("IDS_OS_SPLINE_NOMINAL_DISPLAY_TEXT") + SPACE + string4 + SPACE + string5;
        } else if (dialogDataModel.getBoolean("IDS_OS_NUMERIC") != null && dialogDataModel.getBoolean("IDS_OS_NUMERIC").booleanValue()) {
            string = this.getResString("IDS_OS_NUMERIC_DISPLAY_TEXT");
        } else if (dialogDataModel.getBoolean("IDS_OS_ORDINAL") != null && dialogDataModel.getBoolean("IDS_OS_ORDINAL").booleanValue()) {
            string = this.getResString("IDS_OS_ORDINAL_DISPLAY_TEXT");
        } else if (dialogDataModel.getBoolean("IDS_OS_NOMINAL") != null && dialogDataModel.getBoolean("IDS_OS_NOMINAL").booleanValue()) {
            string = this.getResString("IDS_OS_NOMINAL_DISPLAY_TEXT");
        }
        return string;
    }

    private void runDiscretizeSubDialog() {
        this.mDiscretizeSubDlg = new OptimalScalingDiscretize(this);
        this.runSubDialog(this.mDiscretizeSubDlg);
    }

    private void runMissingSubDialog() {
        this.mMissingSubDlg = new OptimalScalingMissing(this);
        this.runSubDialog(this.mMissingSubDlg);
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new OptimalScalingOptions(this));
    }

    private void runRegularizationSubDialog() {
        this.runSubDialog(new OptimalScalingRegularization(this));
    }

    private void runOutputSubDialog() {
        this.runSubDialog(new OptimalScalingOutput(this));
    }

    private void runSaveSubDialog() {
        this.runSubDialog(new OptimalScalingSave(this));
    }

    private void runPlotsSubDialog() {
        this.runSubDialog(new OptimalScalingPlots(this));
    }

    private void updateOkPaste() {
        this.enableOkPaste(this.mTargetDependentVarList.getModel().getSize() > 0 && this.mTargetIndependentVarList.getModel().getSize() > 0);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addListSelectionListener(this);
        this.mSrcVarList.addFocusListener(this);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTargetDependentVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetDependentVarList.setLoadFromPersistent(false);
        this.mTargetDependentVarList.setIdentifier(DEPENDENT_VAR_LIST_IDENTIFIER);
        this.mTargetDependentVarList.addListSelectionListener(this);
        this.mTargetDependentVarList.addFocusListener(this);
        this.mTargetDependentScrollPane = new JScrollPane(this.mTargetDependentVarList);
        this.mTargetDependentScrollPane.setHorizontalScrollBarPolicy(31);
        this.mTargetDependentScrollPane.setVerticalScrollBarPolicy(21);
        this.mTargetDependentScrollPane.setPreferredSize(this.mTargetDependentVarList.getMinimumSize());
        this.mDependentListFormatter = new OptimalScalingDlgVarFormatter(this.mTargetDependentVarList);
        this.mTargetDependentVarList.setModel(new OptimalScalingDlgVarListModel(this, this.mDependentListFormatter));
        this.mTargetDependentVarList.setCellRenderer(new CustomVarListCellRenderer(this.mDependentListFormatter));
        this.mTargetDependentVarList.getModel().addListDataListener(this);
        this.mDependentVariableLabel = DialogUtil.createLabel(this, "IDS_OS_DEPENDENT_VARIABLE_LABEL");
        this.mDependentVariableLabel.setLabelFor(this.mTargetDependentVarList);
        this.mTargetIndependentVarList = new TargetVariableList();
        this.mTargetIndependentVarList.setLoadFromPersistent(false);
        this.mTargetIndependentVarList.setIdentifier(INDEPENDENT_VAR_LIST_IDENTIFIER);
        this.mTargetIndependentVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetIndependentVarList.getFixedCellHeight() * 10 + 2));
        this.mTargetIndependentVarList.addListSelectionListener(this);
        this.mTargetIndependentVarList.addFocusListener(this);
        this.mIndependentListFormatter = new OptimalScalingDlgVarFormatter(this.mTargetIndependentVarList);
        this.mTargetIndependentVarList.setModel(new OptimalScalingDlgVarListModel(this, this.mIndependentListFormatter));
        this.mTargetIndependentVarList.setCellRenderer(new CustomVarListCellRenderer(this.mIndependentListFormatter));
        this.mTargetIndependentVarList.getModel().addListDataListener(this);
        this.mTargetIndependentScrollPane = new JScrollPane(this.mTargetIndependentVarList);
        this.mTargetIndependentScrollPane.setPreferredSize(this.mTargetIndependentVarList.getMinimumSize());
        this.mIndependentVariablesLabel = DialogUtil.createLabel(this, "IDS_OS_INDEPENDENT_VARIABLE_LABEL");
        this.mIndependentVariablesLabel.setLabelFor(this.mTargetIndependentVarList);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_DEPENDENT_DEFINE_SCALE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptimalScalingDlg.this.runDefineScaleSubDialog();
            }
        };
        this.mDependentDefineScaleButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_INDEPENDENT_DEFINE_SCALE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptimalScalingDlg.this.runDefineScaleSubDialog();
            }
        };
        this.mIndependentDefineScaleButton = new JButton(toggleButtonAction);
        this.mVarMoveHandler = this;
        this.mDependentArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDependentArrowButton.setVarMoveHandler(this);
        this.mDependentArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDependentArrowButton.registerVariableList(this.mTargetDependentVarList, SpssArrowButton.ButtonOrientation.left);
        this.mIndependentArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mIndependentArrowButton.setVarMoveHandler(this);
        this.mIndependentArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mIndependentArrowButton.registerVariableList(this.mTargetIndependentVarList, SpssArrowButton.ButtonOrientation.left);
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mDependentDefineScaleButton.setEnabled(false);
        this.mIndependentDefineScaleButton.setEnabled(false);
    }

    private void addComponentsToPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_OS_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 5, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, DialogUtil.getArrowButtonInsets().left, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mDependentArrowButton, gridBagConstraints, 1, 0, 1, 2, n, insets);
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mIndependentArrowButton, gridBagConstraints, 1, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDependentVariableLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mTargetDependentScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDependentDefineScaleButton, gridBagConstraints, 2, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mIndependentVariablesLabel, gridBagConstraints, 2, 3, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetIndependentScrollPane, gridBagConstraints, 2, 4, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mIndependentDefineScaleButton, gridBagConstraints, 2, 5, 1, 1, n, insets2);
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mDependentArrowButton);
        vector.add(this.mIndependentArrowButton);
        vector.add(this.mTargetDependentVarList);
        vector.add(this.mDependentDefineScaleButton);
        vector.add(this.mTargetIndependentVarList);
        vector.add(this.mIndependentDefineScaleButton);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

