/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.optimal_scaling;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingDiscretizeVarListModel;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingDlg;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingDlgVarFormatter;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OptimalScalingDiscretize
extends BaseSubDialog
implements ItemListener,
DocumentListener,
ListSelectionListener,
FocusListener {
    static final String EQUAL_TEXT_KEY = "EQUAL_TEXT_KEY";
    private static final String DISCRETIZE_FORMATTER_KEY = "DISCRETIZE_FORMATTER_KEY";
    private static OptimalScalingDlgVarFormatter sFormatter;
    private JLabel mVariablesLabel;
    private TargetVariableList mTargetVarList;
    private JScrollPane mTargetVarScrollPane;
    private JLabel mMethodLabel;
    private JComboBox mMethodComboBox;
    private JButton mChangeButton;
    private JRadioButton mNumberOfCategoriesRadio;
    private IntTextField mNumberOfCategoriesTextField;
    private JLabel mDistributionLabel;
    private JRadioButton mNormalRadio;
    private JRadioButton mUniformRadio;
    private JRadioButton mEqualIntervalsRadio;
    private FloatTextField mEqualIntervalsTextField;
    private SpssButtonGroup mNumberEqualButtonGroup;
    private SpssButtonGroup mNormalUniformButtonGroup;

    OptimalScalingDiscretize(OptimalScalingDlg optimalScalingDlg) {
        super(optimalScalingDlg, optimalScalingDlg.getResString("IDS_OS_DISCRETIZE_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_catr_discretize";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mNumberOfCategoriesTextField)) {
            this.mNumberOfCategoriesTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mEqualIntervalsTextField)) {
            this.mEqualIntervalsTextField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mNumberOfCategoriesTextField)) {
            this.mNumberOfCategoriesTextField.select(0, 0);
        } else if (focusEvent.getSource().equals(this.mEqualIntervalsTextField)) {
            this.mEqualIntervalsTextField.select(0, 0);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.mTargetVarList)) {
            this.updateChangeButton();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mMethodComboBox)) {
            this.enableGroupingPanelComponents(this.mMethodComboBox.getSelectedIndex() == 1);
        } else if (itemEvent.getSource().equals(this.mEqualIntervalsRadio)) {
            this.mNumberOfCategoriesTextField.setEnabled(false);
            this.mNumberOfCategoriesTextField.setOpaque(false);
            this.mDistributionLabel.setEnabled(false);
            this.mNormalRadio.setEnabled(false);
            this.mUniformRadio.setEnabled(false);
            this.mEqualIntervalsTextField.setEnabled(true);
            this.mEqualIntervalsTextField.setOpaque(true);
            this.updateChangeButton();
        } else if (itemEvent.getSource().equals(this.mNumberOfCategoriesRadio)) {
            this.mNumberOfCategoriesTextField.setEnabled(true);
            this.mNumberOfCategoriesTextField.setOpaque(true);
            this.mDistributionLabel.setEnabled(true);
            this.mNormalRadio.setEnabled(true);
            this.mUniformRadio.setEnabled(true);
            this.mEqualIntervalsTextField.setEnabled(false);
            this.mEqualIntervalsTextField.setOpaque(false);
            this.updateChangeButton();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateChangeButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateChangeButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    static OptimalScalingDlgVarFormatter getFormatter() {
        return sFormatter;
    }

    VarListModel getListModel() {
        return this.mTargetVarList.getModel();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        int n;
        int n2;
        ISpssVariable iSpssVariable2;
        super.loadState(dialogDataModel);
        sFormatter.setVarMap(dialogDataModel.getMap(DISCRETIZE_FORMATTER_KEY));
        TargetVariableList targetVariableList = ((OptimalScalingDlg)this.mParentDlg).getDependentVarList();
        TargetVariableList targetVariableList2 = ((OptimalScalingDlg)this.mParentDlg).getIndependentVarList();
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        for (int i = 0; i < this.mTargetVarList.getModel().getSize(); ++i) {
            iSpssVariable2 = this.mTargetVarList.getModel().getElementAt(i);
            n2 = iSpssVariable2.getId().asInt();
            if (this.isItemPresent(n2, targetVariableList) || this.isItemPresent(n2, targetVariableList2)) continue;
            vector.add(iSpssVariable2);
        }
        for (ISpssVariable iSpssVariable2 : vector) {
            this.mTargetVarList.getModel().removeElement(iSpssVariable2);
        }
        for (n = 0; n < targetVariableList.getModel().getSize(); ++n) {
            iSpssVariable2 = targetVariableList.getModel().getElementAt(n);
            n2 = iSpssVariable2.getId().asInt();
            if (this.isItemPresent(n2, this.mTargetVarList)) continue;
            this.mTargetVarList.getModel().insertElementAt(iSpssVariable2, 0);
        }
        for (n = 0; n < targetVariableList2.getModel().getSize(); ++n) {
            iSpssVariable2 = targetVariableList2.getModel().getElementAt(n);
            n2 = iSpssVariable2.getId().asInt();
            if (this.isItemPresent(n2, this.mTargetVarList)) continue;
            this.mTargetVarList.getModel().addElement(iSpssVariable2);
        }
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        this.mNumberOfCategoriesRadio.setSelected(true);
        super.saveState(dialogDataModel);
        dialogDataModel.putMap(DISCRETIZE_FORMATTER_KEY, sFormatter.getVarMapForSerialization());
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponentsToPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void initVars() {
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setLoadFromPersistent(false);
        this.mTargetVarList.setIdentifier("DiscretizeList");
        this.mTargetVarList.addListSelectionListener(this);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 12 + 2));
        this.mTargetVarScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        sFormatter = new OptimalScalingDlgVarFormatter(this.mTargetVarList, this);
        this.mTargetVarList.setModel(new OptimalScalingDiscretizeVarListModel(this, sFormatter));
        this.mTargetVarList.setCellRenderer(new CustomVarListCellRenderer(sFormatter));
        this.mVariablesLabel = DialogUtil.createLabel(this, "IDS_OS_VARIABLES_LABEL");
        this.mVariablesLabel.setLabelFor(this.mTargetVarList);
        String[] stringArray = this.getResStringArray("IDS_OS_METHOD_NAMES");
        this.mMethodComboBox = new JComboBox<String>(stringArray);
        this.mMethodComboBox.setSize(new Dimension(150, 20));
        this.mMethodComboBox.addItemListener(this);
        this.mMethodLabel = DialogUtil.createLabel(this, "IDS_OS_METHOD_LABEL");
        this.mMethodLabel.setLabelFor(this.mMethodComboBox);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_CHANGE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptimalScalingDiscretize.this.handleChangeButtonPress();
            }
        };
        this.mChangeButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_NUM_OF_CATEGORIES_LABEL");
        this.mNumberOfCategoriesRadio = new JRadioButton(toggleButtonAction);
        this.mNumberOfCategoriesRadio.addItemListener(this);
        this.mNumberOfCategoriesTextField = new IntTextField(2, 35, true);
        this.mNumberOfCategoriesTextField.setColumns(2);
        this.mNumberOfCategoriesTextField.getDocument().addDocumentListener(this);
        this.mNumberOfCategoriesTextField.addFocusListener((FocusListener)this);
        this.mDistributionLabel = new JLabel(this.getResString("IDS_OS_DISTRIBUTION_LABEL"));
        toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_NORMAL");
        this.mNormalRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_UNIFORM");
        this.mUniformRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_OS_EQUAL_INTERVALS");
        this.mEqualIntervalsRadio = new JRadioButton(toggleButtonAction);
        this.mEqualIntervalsRadio.addItemListener(this);
        this.mEqualIntervalsTextField = new FloatTextField(1.0, 9.9999999E7, 8, true);
        this.mEqualIntervalsTextField.setColumns(8);
        this.mEqualIntervalsTextField.setAction((Action)new TextFieldAction(this, EQUAL_TEXT_KEY));
        this.mEqualIntervalsTextField.getDocument().addDocumentListener(this);
        this.mEqualIntervalsTextField.addFocusListener((FocusListener)this);
    }

    private void setDefaults() {
        this.mNumberOfCategoriesTextField.setText("7");
        this.mNormalRadio.setSelected(true);
        this.mNumberOfCategoriesRadio.setSelected(true);
        this.mMethodComboBox.setSelectedIndex(1);
        this.mEqualIntervalsTextField.setEnabled(false);
        this.mEqualIntervalsTextField.setOpaque(false);
        this.mChangeButton.setEnabled(false);
        this.enableContinue(false);
    }

    private void addComponentsToPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mVariablesLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetVarScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0, 0);
        JPanel jPanel2 = this.setupMethodPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JPanel jPanel3 = this.setupGroupingPanel();
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 3, 1, 1, n, insets);
    }

    private JPanel setupMethodPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mMethodLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMethodComboBox, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mChangeButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupGroupingPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OS_GROUPING_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNumberOfCategoriesRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumberOfCategoriesTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JPanel jPanel2 = this.setupDistributionPanel();
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 6, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 2, 1, n, insets);
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mEqualIntervalsRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getComponentGroupGap(), DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mEqualIntervalsTextField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        this.mNumberEqualButtonGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupDistributionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDistributionLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 19;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNormalRadio, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mUniformRadio, gridBagConstraints, 2, 0, 1, 1, n, insets);
        this.mNormalUniformButtonGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTargetVarList);
        vector.add(this.mMethodComboBox);
        vector.add(this.mChangeButton);
        vector.add(this.mNumberEqualButtonGroup);
        vector.add(this.mNormalUniformButtonGroup);
        vector.add(this.mNumberOfCategoriesTextField);
        vector.add(this.mEqualIntervalsTextField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void updateChangeButton() {
        if (this.mNumberOfCategoriesRadio.isEnabled() && this.mNumberOfCategoriesRadio.isSelected()) {
            this.mChangeButton.setEnabled(this.mTargetVarList.getSelectedValue() != null && this.mNumberOfCategoriesTextField.getText().length() > 0);
        } else if (this.mEqualIntervalsRadio.isEnabled() && this.mEqualIntervalsRadio.isSelected()) {
            this.mChangeButton.setEnabled(this.mTargetVarList.getSelectedValue() != null && this.mEqualIntervalsTextField.getText().length() > 0);
        } else {
            this.mChangeButton.setEnabled(this.mTargetVarList.getSelectedValue() != null);
        }
    }

    private boolean isItemPresent(int n, TargetVariableList targetVariableList) {
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            int n2 = targetVariableList.getModel().getElementAt(i).getId().asInt();
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    private void enableGroupingPanelComponents(boolean bl) {
        if (bl) {
            if (this.mNumberOfCategoriesRadio.isSelected()) {
                this.mNumberOfCategoriesTextField.setEnabled(bl);
                this.mNumberOfCategoriesTextField.setOpaque(bl);
                this.mEqualIntervalsTextField.setEnabled(!bl);
                this.mEqualIntervalsTextField.setOpaque(!bl);
                this.mDistributionLabel.setEnabled(bl);
                this.mNormalRadio.setEnabled(bl);
                this.mUniformRadio.setEnabled(bl);
            } else {
                this.mNumberOfCategoriesTextField.setEnabled(!bl);
                this.mNumberOfCategoriesTextField.setOpaque(!bl);
                this.mEqualIntervalsTextField.setEnabled(bl);
                this.mEqualIntervalsTextField.setOpaque(bl);
                this.mDistributionLabel.setEnabled(!bl);
                this.mNormalRadio.setEnabled(!bl);
                this.mUniformRadio.setEnabled(!bl);
            }
            this.mNumberOfCategoriesRadio.setEnabled(bl);
            this.mEqualIntervalsRadio.setEnabled(bl);
        } else {
            this.mNumberOfCategoriesRadio.setEnabled(bl);
            this.mNumberOfCategoriesTextField.setEnabled(bl);
            this.mNumberOfCategoriesTextField.setOpaque(bl);
            this.mDistributionLabel.setEnabled(bl);
            this.mNormalRadio.setEnabled(bl);
            this.mUniformRadio.setEnabled(bl);
            this.mEqualIntervalsRadio.setEnabled(bl);
            this.mEqualIntervalsTextField.setEnabled(bl);
            this.mEqualIntervalsTextField.setOpaque(bl);
        }
        this.updateChangeButton();
    }

    private boolean isInvalidNumberOfCategoriesRange(String string) {
        Integer n = new Integer(string);
        return n < 2 || n > 35;
    }

    private boolean textZero(String string) {
        Float f = new Float(string);
        return 0.0f == f.floatValue();
    }

    private void handleChangeButtonPress() {
        String string = "";
        String string2 = this.getResString("IDS_OS_GROUPING_DISPLAY_TEXT");
        boolean bl = false;
        if (this.mNumberOfCategoriesRadio.isEnabled() && this.mNumberOfCategoriesRadio.isSelected()) {
            if (this.isInvalidNumberOfCategoriesRange(this.mNumberOfCategoriesTextField.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OS_VALUE_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
                this.mNumberOfCategoriesTextField.selectAll();
                this.mNumberOfCategoriesTextField.requestFocus();
                bl = true;
            } else {
                string = this.mNormalRadio.isSelected() ? string2 + " " + this.getResString("IDS_OS_NORMAL_DISPLAY_TEXT") + " " + this.mNumberOfCategoriesTextField.getText() : string2 + " " + this.getResString("IDS_OS_UNIFORM_DISPLAY_TEXT") + " " + this.mNumberOfCategoriesTextField.getText();
            }
        } else if (this.mEqualIntervalsRadio.isEnabled() && this.mEqualIntervalsRadio.isSelected()) {
            if (this.textZero(this.mEqualIntervalsTextField.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OS_VALUE_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
                this.mEqualIntervalsTextField.selectAll();
                this.mEqualIntervalsTextField.requestFocus();
                bl = true;
            } else {
                string = string2 + " " + this.mEqualIntervalsTextField.getText();
            }
        } else {
            string = (String)this.mMethodComboBox.getSelectedItem();
        }
        if (!bl) {
            int[] nArray;
            for (int n : nArray = this.mTargetVarList.getSelectedIndices()) {
                ((OptimalScalingDiscretizeVarListModel)this.mTargetVarList.getModel()).setElementPropertyAt(n, string);
            }
        }
        this.enableContinue(true);
    }
}

