/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.optimal_scaling;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingDlg;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingDlgVarFormatter;
import com.spss.java_client.ui.dialogs.market_research.optimal_scaling.OptimalScalingDlgVarListModel;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class OptimalScalingDefineScale
extends BaseSubDialog
implements DocumentListener,
FocusListener,
ItemListener {
    static final String SPLINE_ORDINAL = "IDS_OS_SPLINE_ORDINAL";
    static final String SPLINE_NOMINAL = "IDS_OS_SPLINE_NOMINAL";
    static final String NUMERIC = "IDS_OS_NUMERIC";
    static final String ORDINAL = "IDS_OS_ORDINAL";
    static final String NOMINAL = "IDS_OS_NOMINAL";
    static final String DEGREE_TEXT_FIELD_KEY = "DEGREE_TEXT_FIELD_KEY";
    static final String INTERIOR_KNOTS_TEXT_FIELD_KEY = "INTERIOR_KNOTS_TEXT_FIELD_KEY";
    private static final String DEFAULT_DEGREE_TEXT = "2";
    private static final String DEFAULT_INTERIOR_KNOTS_TEXT = "2";
    private static final String SPACE = " ";
    private static final String SPLINE_ORDINAL_STR = "IDS_OS_SPLINE_ORDINAL_DISPLAY_TEXT";
    private static final String SPLINE_NOMINAL_STR = "IDS_OS_SPLINE_NOMINAL_DISPLAY_TEXT";
    private static final String NUMERIC_STR = "IDS_OS_NUMERIC_DISPLAY_TEXT";
    private static final String ORDINAL_STR = "IDS_OS_ORDINAL_DISPLAY_TEXT";
    private static final String NOMINAL_STR = "IDS_OS_NOMINAL_DISPLAY_TEXT";
    private JRadioButton mSplineOrdinalRadio;
    private JRadioButton mSplineNominalRadio;
    private JRadioButton mNumericRadio;
    private JRadioButton mOrdinalRadio;
    private JRadioButton mNominalRadio;
    private JLabel mDegreeLabel;
    private JLabel mInteriorKnotsLabel;
    private IntTextField mDegreeTextField;
    private ContextEnabledTextField mInteriorKnotsTextField;
    private SpssButtonGroup mRadioButtonGroup;

    OptimalScalingDefineScale(OptimalScalingDlg optimalScalingDlg) {
        super(optimalScalingDlg, optimalScalingDlg.getResString("IDS_OS_DEFINE_SCALE_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_catr_scale";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mDegreeTextField)) {
            this.mDegreeTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mInteriorKnotsTextField)) {
            this.mInteriorKnotsTextField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mDegreeTextField)) {
            this.mDegreeTextField.select(0, 0);
        } else if (focusEvent.getSource().equals(this.mInteriorKnotsTextField)) {
            this.mInteriorKnotsTextField.select(0, 0);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinue();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinue();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mSplineOrdinalRadio) || itemEvent.getSource().equals(this.mSplineNominalRadio)) {
            this.enableSplinePanelComponents(true);
            this.updateContinue();
        } else if (itemEvent.getSource().equals(this.mNumericRadio) || itemEvent.getSource().equals(this.mOrdinalRadio) || itemEvent.getSource().equals(this.mNominalRadio)) {
            this.enableSplinePanelComponents(false);
            this.enableContinue(true);
        }
    }

    @Override
    public boolean continuePressed() {
        if (this.isDegreeTextZero()) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OS_VALUE_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
            this.mDegreeTextField.selectAll();
            this.mDegreeTextField.requestFocus();
            return false;
        }
        return super.continuePressed();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (((OptimalScalingDlg)this.mParentDlg).getDependentFlag()) {
            TargetVariableList targetVariableList = ((OptimalScalingDlg)this.mParentDlg).getDependentVarList();
            OptimalScalingDlgVarListModel optimalScalingDlgVarListModel = (OptimalScalingDlgVarListModel)targetVariableList.getModel();
            SpssVariable spssVariable = (SpssVariable)targetVariableList.getSelectedValue();
            OptimalScalingDlgVarFormatter optimalScalingDlgVarFormatter = optimalScalingDlgVarListModel.getVarFormatter();
            String string = optimalScalingDlgVarFormatter.getDisplayText((ISpssVariable)spssVariable);
            String string2 = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
            if (string2.equalsIgnoreCase(this.getResString(NUMERIC_STR))) {
                this.mNumericRadio.setSelected(true);
                this.enableSplinePanelComponents(false);
            } else if (string2.equalsIgnoreCase(this.getResString(ORDINAL_STR))) {
                this.mOrdinalRadio.setSelected(true);
                this.enableSplinePanelComponents(false);
            } else if (string2.equalsIgnoreCase(this.getResString(NOMINAL_STR))) {
                this.mNominalRadio.setSelected(true);
                this.enableSplinePanelComponents(false);
            } else if (string2.contains(this.getResString(SPLINE_ORDINAL_STR))) {
                int n = string2.indexOf(SPACE);
                int n2 = string2.indexOf(SPACE, n + 1);
                int n3 = string2.indexOf(SPACE, n2 + 1);
                String string3 = string2.substring(n2 + 1, n3);
                String string4 = string2.substring(n3 + 1, string2.length());
                this.mSplineOrdinalRadio.setSelected(true);
                this.enableSplinePanelComponents(true);
                this.mDegreeTextField.setText(string3);
                this.mInteriorKnotsTextField.setText(string4);
            } else if (string2.contains(this.getResString(SPLINE_NOMINAL_STR))) {
                int n = string2.indexOf(SPACE);
                int n4 = string2.indexOf(SPACE, n + 1);
                int n5 = string2.indexOf(SPACE, n4 + 1);
                String string5 = string2.substring(n4 + 1, n5);
                String string6 = string2.substring(n5 + 1, string2.length());
                this.mSplineNominalRadio.setSelected(true);
                this.enableSplinePanelComponents(true);
                this.mDegreeTextField.setText(string5);
                this.mInteriorKnotsTextField.setText(string6);
            }
        } else {
            int n;
            boolean bl = true;
            TargetVariableList targetVariableList = ((OptimalScalingDlg)this.mParentDlg).getIndependentVarList();
            OptimalScalingDlgVarListModel optimalScalingDlgVarListModel = (OptimalScalingDlgVarListModel)targetVariableList.getModel();
            ISpssVariable[] iSpssVariableArray = targetVariableList.getSelectedValues();
            OptimalScalingDlgVarFormatter optimalScalingDlgVarFormatter = optimalScalingDlgVarListModel.getVarFormatter();
            String string = optimalScalingDlgVarFormatter.getDisplayText(iSpssVariableArray[0]);
            String string7 = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
            String string8 = "";
            String string9 = "";
            if (iSpssVariableArray.length > 1) {
                for (n = 1; n < iSpssVariableArray.length; ++n) {
                    string8 = optimalScalingDlgVarFormatter.getDisplayText(iSpssVariableArray[n]);
                    string9 = string8.substring(string8.indexOf("(") + 1, string8.indexOf(")"));
                    if (string7.equalsIgnoreCase(this.getResString(NUMERIC_STR)) || string7.equalsIgnoreCase(this.getResString(ORDINAL_STR)) || string7.equalsIgnoreCase(this.getResString(NOMINAL_STR))) {
                        if (string7.equalsIgnoreCase(string9)) continue;
                        bl = false;
                        break;
                    }
                    if (string7.contains(this.getResString(SPLINE_ORDINAL_STR))) {
                        if (string9.contains(this.getResString(SPLINE_ORDINAL_STR))) continue;
                        bl = false;
                        break;
                    }
                    if (!string7.contains(this.getResString(SPLINE_NOMINAL_STR)) || string9.contains(this.getResString(SPLINE_NOMINAL_STR))) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                if (string7.equalsIgnoreCase(this.getResString(NUMERIC_STR))) {
                    this.mNumericRadio.setSelected(true);
                    this.enableSplinePanelComponents(false);
                } else if (string7.equalsIgnoreCase(this.getResString(ORDINAL_STR))) {
                    this.mOrdinalRadio.setSelected(true);
                    this.enableSplinePanelComponents(false);
                } else if (string7.equalsIgnoreCase(this.getResString(NOMINAL_STR))) {
                    this.mNominalRadio.setSelected(true);
                    this.enableSplinePanelComponents(false);
                } else if (string7.contains(this.getResString(SPLINE_ORDINAL_STR))) {
                    n = string7.indexOf(SPACE);
                    int n6 = string7.indexOf(SPACE, n + 1);
                    int n7 = string7.indexOf(SPACE, n6 + 1);
                    String string10 = string7.substring(n6 + 1, n7);
                    String string11 = string7.substring(n7 + 1, string7.length());
                    this.mDegreeTextField.setText(string10);
                    this.mInteriorKnotsTextField.setText(string11);
                    this.mSplineOrdinalRadio.setSelected(true);
                    this.enableSplinePanelComponents(true);
                } else if (string7.contains(this.getResString(SPLINE_NOMINAL_STR))) {
                    n = string7.indexOf(SPACE);
                    int n8 = string7.indexOf(SPACE, n + 1);
                    int n9 = string7.indexOf(SPACE, n8 + 1);
                    String string12 = string7.substring(n8 + 1, n9);
                    String string13 = string7.substring(n9 + 1, string7.length());
                    this.mDegreeTextField.setText(string12);
                    this.mInteriorKnotsTextField.setText(string13);
                    this.mSplineNominalRadio.setSelected(true);
                    this.enableSplinePanelComponents(true);
                }
            } else {
                this.mSplineOrdinalRadio.setSelected(true);
                this.mDegreeTextField.setText("2");
                this.mInteriorKnotsTextField.setText("2");
            }
        }
        dialogDataModel.putString(DEGREE_TEXT_FIELD_KEY, this.mDegreeTextField.getText());
        dialogDataModel.putString(INTERIOR_KNOTS_TEXT_FIELD_KEY, this.mInteriorKnotsTextField.getText());
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponentsToPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, SPLINE_ORDINAL);
        this.mSplineOrdinalRadio = new JRadioButton(toggleButtonAction);
        this.mSplineOrdinalRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, SPLINE_NOMINAL);
        this.mSplineNominalRadio = new JRadioButton(toggleButtonAction);
        this.mSplineNominalRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, NUMERIC);
        this.mNumericRadio = new JRadioButton(toggleButtonAction);
        this.mNumericRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, ORDINAL);
        this.mOrdinalRadio = new JRadioButton(toggleButtonAction);
        this.mOrdinalRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, NOMINAL);
        this.mNominalRadio = new JRadioButton(toggleButtonAction);
        this.mNominalRadio.addItemListener(this);
        this.mDegreeTextField = new IntTextField(1, 99999999, true);
        this.mDegreeTextField.setAction((Action)new TextFieldAction(this, DEGREE_TEXT_FIELD_KEY));
        this.mDegreeTextField.setColumns(8);
        this.mDegreeTextField.getDocument().addDocumentListener(this);
        this.mDegreeTextField.addFocusListener((FocusListener)this);
        this.mDegreeLabel = DialogUtil.createLabel(this, "IDS_OS_DEGREE_LABEL");
        this.mDegreeLabel.setLabelFor((Component)this.mDegreeTextField);
        this.mInteriorKnotsTextField = new ContextEnabledTextField();
        this.mInteriorKnotsTextField.setAction((Action)new TextFieldAction(this, INTERIOR_KNOTS_TEXT_FIELD_KEY));
        this.mInteriorKnotsTextField.setColumns(5);
        this.mInteriorKnotsTextField.setDocument((Document)new FixedLengthNumericDocument(8, true, false));
        this.mInteriorKnotsTextField.getDocument().addDocumentListener(this);
        this.mInteriorKnotsTextField.addFocusListener((FocusListener)this);
        this.mInteriorKnotsLabel = DialogUtil.createLabel(this, "IDS_OS_INTERIOR_KNOTS_LABEL");
        this.mInteriorKnotsLabel.setLabelFor((Component)this.mInteriorKnotsTextField);
    }

    private void setDefaults() {
        this.mSplineOrdinalRadio.setSelected(true);
        this.mDegreeTextField.setText("2");
        this.mInteriorKnotsTextField.setText("2");
        this.enableContinue(true);
    }

    private void enableSplinePanelComponents(boolean bl) {
        this.mDegreeLabel.setEnabled(bl);
        this.mDegreeTextField.setEnabled(bl);
        this.mDegreeTextField.setOpaque(bl);
        this.mInteriorKnotsLabel.setEnabled(bl);
        this.mInteriorKnotsTextField.setEnabled(bl);
        this.mInteriorKnotsTextField.setOpaque(bl);
    }

    private boolean isDegreeTextZero() {
        Integer n = new Integer(this.mDegreeTextField.getText());
        return 0 == n;
    }

    private void updateContinue() {
        this.enableContinue(this.mDegreeTextField.getText().length() > 0 && this.mInteriorKnotsTextField.getText().length() > 0);
    }

    private void addComponentsToPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        JPanel jPanel2 = this.setupOptimalScalingLevelPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        n = 19;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        JPanel jPanel3 = this.setupSplinePanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private JPanel setupOptimalScalingLevelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OS_OPTIMAL_SCALING_LEVEL_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mSplineOrdinalRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSplineNominalRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mNumericRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mOrdinalRadio, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mNominalRadio, gridBagConstraints, 1, 1, 1, 1, n, insets);
        this.mRadioButtonGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupSplinePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OS_SPLINE_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mDegreeLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDegreeTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mInteriorKnotsLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mInteriorKnotsTextField, gridBagConstraints, 3, 0, 1, 1, n, insets);
        return jPanel;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRadioButtonGroup);
        vector.add(this.mDegreeTextField);
        vector.add(this.mInteriorKnotsTextField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

