/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.overals;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.ISpssVarFormatter;
import com.spss.java_client.ui.controls.MultiVarListAccessor;
import com.spss.java_client.ui.controls.SpssVarFormatter;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.overals.NonlinearCanonicalDlg;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.overals.RangeAndScaleListModel;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.overals.RangeAndScaleVarFormatter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VariablesSetManager
implements ActionListener,
ListSelectionListener,
ListDataListener,
MultiVarListAccessor {
    static final String CURRENT_SET = "IDS_CURRENT_SELECTED_SET";
    static final String TOTAL_SETS = "IDS_TOTAL_NUMBER_OF_SETS";
    static final String SET_VARS_AND_MAPS = "IDS_VARIABLES_AND_MAPS_IN_SETS";
    private static final int MAX_SETS = 9;
    private int mCurrentSet = 1;
    private int mTotalSets = 1;
    private ArrayList<RangeAndScaleListModel> mListModels;
    private List<CustomVarListCellRenderer> mListRenderers;
    private List<Boolean> mAreSetsDefined;
    private TargetVariableList mVariableList;
    private JButton mPreviousButton;
    private JButton mNextButton;
    private JButton mDefineButton;
    private NonlinearCanonicalDlg mNonlinearCanonicalDlg;

    public VariablesSetManager(TargetVariableList targetVariableList, JButton jButton, JButton jButton2, JButton jButton3, NonlinearCanonicalDlg nonlinearCanonicalDlg) {
        this.mVariableList = targetVariableList;
        this.mPreviousButton = jButton;
        this.mNextButton = jButton2;
        this.mDefineButton = jButton3;
        this.mNonlinearCanonicalDlg = nonlinearCanonicalDlg;
        this.mAreSetsDefined = new ArrayList<Boolean>(1);
        this.mListModels = new ArrayList(1);
        this.mListRenderers = new ArrayList<CustomVarListCellRenderer>(1);
        RangeAndScaleVarFormatter rangeAndScaleVarFormatter = new RangeAndScaleVarFormatter(this.mVariableList, this.mNonlinearCanonicalDlg);
        rangeAndScaleVarFormatter.setVarListId(this.mVariableList.getIdentifier() + "0");
        RangeAndScaleListModel rangeAndScaleListModel = new RangeAndScaleListModel(rangeAndScaleVarFormatter);
        this.mVariableList.setModel(rangeAndScaleListModel);
        CustomVarListCellRenderer customVarListCellRenderer = new CustomVarListCellRenderer(rangeAndScaleVarFormatter);
        this.mVariableList.setCellRenderer(customVarListCellRenderer);
        this.mListModels.add(rangeAndScaleListModel);
        this.mAreSetsDefined.add(rangeAndScaleListModel.isSetDefined());
        this.mListRenderers.add(customVarListCellRenderer);
        this.addListioners();
    }

    public void resetState() {
        this.removeListioners();
        this.mAreSetsDefined = new ArrayList<Boolean>(1);
        this.mListModels = new ArrayList(1);
        this.mListRenderers = new ArrayList<CustomVarListCellRenderer>(1);
        RangeAndScaleVarFormatter rangeAndScaleVarFormatter = new RangeAndScaleVarFormatter(this.mVariableList, this.mNonlinearCanonicalDlg);
        rangeAndScaleVarFormatter.setVarListId(this.mVariableList.getIdentifier() + "0");
        RangeAndScaleListModel rangeAndScaleListModel = new RangeAndScaleListModel(rangeAndScaleVarFormatter);
        this.mVariableList.setModel(rangeAndScaleListModel);
        CustomVarListCellRenderer customVarListCellRenderer = new CustomVarListCellRenderer(rangeAndScaleVarFormatter);
        this.mVariableList.setCellRenderer(customVarListCellRenderer);
        this.mListModels.add(rangeAndScaleListModel);
        this.mAreSetsDefined.add(rangeAndScaleListModel.isSetDefined());
        this.mListRenderers.add(customVarListCellRenderer);
        this.mTotalSets = 1;
        this.mCurrentSet = 1;
        this.addListioners();
        this.updateButtons();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.mDefineButton.setEnabled(this.mVariableList.getSelectedIndices().length > 0);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateButtons();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateButtons();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateButtons();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (actionEvent.getSource() == this.mNextButton) {
            this.mVariableList.getModel().removeListDataListener(this);
            if (this.mVariableList.getModel().getSize() <= 0) {
                this.mListModels.remove(this.mCurrentSet - 1);
                this.mListRenderers.remove(this.mCurrentSet - 1);
                --this.mTotalSets;
                this.mVariableList.setModel(this.mListModels.get(this.mCurrentSet - 1));
                this.mVariableList.setCellRenderer(this.mListRenderers.get(this.mCurrentSet - 1));
            } else if (this.mListModels.size() <= this.mCurrentSet) {
                object = new RangeAndScaleVarFormatter(this.mVariableList, this.mNonlinearCanonicalDlg);
                ((RangeAndScaleVarFormatter)object).setVarListId(this.mVariableList.getIdentifier() + this.mCurrentSet);
                RangeAndScaleListModel rangeAndScaleListModel = new RangeAndScaleListModel((SpssVarFormatter)object);
                this.mVariableList.setModel(rangeAndScaleListModel);
                CustomVarListCellRenderer customVarListCellRenderer = new CustomVarListCellRenderer((ISpssVarFormatter)object);
                this.mVariableList.setCellRenderer(customVarListCellRenderer);
                this.mListModels.add(rangeAndScaleListModel);
                this.mAreSetsDefined.add(rangeAndScaleListModel.isSetDefined());
                this.mListRenderers.add(customVarListCellRenderer);
                ++this.mCurrentSet;
                ++this.mTotalSets;
            } else {
                ++this.mCurrentSet;
                this.mVariableList.setModel(this.mListModels.get(this.mCurrentSet - 1));
                this.mVariableList.setCellRenderer(this.mListRenderers.get(this.mCurrentSet - 1));
            }
            this.mVariableList.getModel().addListDataListener(this);
            this.mNonlinearCanonicalDlg.updateSetsPanelTitle();
            this.updateButtons();
        } else if (actionEvent.getSource() == this.mPreviousButton) {
            this.mVariableList.getModel().removeListDataListener(this);
            if (this.mVariableList.getModel().getSize() <= 0) {
                this.mListModels.remove(this.mCurrentSet - 1);
                this.mListRenderers.remove(this.mCurrentSet - 1);
                --this.mTotalSets;
            }
            --this.mCurrentSet;
            this.mVariableList.setModel(this.mListModels.get(this.mCurrentSet - 1));
            this.mVariableList.setCellRenderer(this.mListRenderers.get(this.mCurrentSet - 1));
            this.mVariableList.getModel().addListDataListener(this);
            this.mNonlinearCanonicalDlg.updateSetsPanelTitle();
            this.updateButtons();
        }
        object = this.mListModels.get(this.mCurrentSet - 1);
        this.mAreSetsDefined.set(this.mCurrentSet - 1, ((RangeAndScaleListModel)object).isSetDefined());
    }

    protected int getCurrentSet() {
        return this.mCurrentSet;
    }

    protected void setCurrentSet(int n) {
        this.mCurrentSet = n;
    }

    protected int getTotalSets() {
        return this.mTotalSets;
    }

    protected void setTotalSets(int n) {
        this.mTotalSets = n;
    }

    @Override
    public ArrayList<VarListModel> getVarListModels() {
        ArrayList<VarListModel> arrayList = new ArrayList<VarListModel>();
        for (VarListModel varListModel : this.mListModels) {
            arrayList.add(varListModel);
        }
        return arrayList;
    }

    protected List<RangeAndScaleListModel> getRangeAndScaleListModels() {
        return this.mListModels;
    }

    protected void setListModels(ArrayList<RangeAndScaleListModel> arrayList) {
        this.mListModels = arrayList;
    }

    protected void updateButtons() {
        boolean bl;
        this.mPreviousButton.setEnabled(this.mCurrentSet > 1);
        boolean bl2 = bl = this.mCurrentSet < 9;
        if (bl && this.mCurrentSet == this.mTotalSets) {
            bl = this.mVariableList.getModel().getSize() > 0;
        }
        this.mNextButton.setEnabled(bl);
        RangeAndScaleListModel rangeAndScaleListModel = this.mListModels.get(this.mCurrentSet - 1);
        this.mAreSetsDefined.set(this.mCurrentSet - 1, rangeAndScaleListModel.isSetDefined());
        this.mNonlinearCanonicalDlg.updateOkPaste();
    }

    protected boolean hasDefinedSets() {
        return this.allSetsDefined() && (this.mTotalSets > 2 || this.mTotalSets == 2 && this.mVariableList.getModel().getSize() > 0);
    }

    protected Object[] getMapsAndVarsLists() {
        ArrayList<Map<Integer, Object>> arrayList = new ArrayList<Map<Integer, Object>>();
        ArrayList<ISpssVariable[]> arrayList2 = new ArrayList<ISpssVariable[]>();
        for (RangeAndScaleListModel rangeAndScaleListModel : this.mListModels) {
            arrayList.add(rangeAndScaleListModel.getVarFormatterMap());
            int n = rangeAndScaleListModel.getSize();
            ISpssVariable[] iSpssVariableArray = new ISpssVariable[n];
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable;
                iSpssVariableArray[i] = iSpssVariable = rangeAndScaleListModel.getElementAt(i);
            }
            arrayList2.add(iSpssVariableArray);
        }
        Object[] objectArray = new Object[]{arrayList.toArray(), arrayList2.toArray()};
        return objectArray;
    }

    protected void loadMapsAndVarsLists(Object[] objectArray) {
        CustomVarListCellRenderer customVarListCellRenderer;
        RangeAndScaleListModel rangeAndScaleListModel;
        Object[] objectArray2 = (Object[])objectArray[0];
        Object[] objectArray3 = (Object[])objectArray[1];
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc == null) {
            return;
        }
        this.mVariableList.getModel().removeListDataListener(this);
        this.mListModels.clear();
        this.mAreSetsDefined.clear();
        this.mListRenderers.clear();
        for (int i = 0; i < objectArray3.length && i < objectArray2.length; ++i) {
            RangeAndScaleVarFormatter rangeAndScaleVarFormatter = new RangeAndScaleVarFormatter(this.mVariableList, this.mNonlinearCanonicalDlg);
            rangeAndScaleVarFormatter.setVarListId(this.mVariableList.getIdentifier() + i);
            rangeAndScaleVarFormatter.setVarMap((HashMap)objectArray2[i]);
            rangeAndScaleListModel = new RangeAndScaleListModel(rangeAndScaleVarFormatter);
            customVarListCellRenderer = new CustomVarListCellRenderer(rangeAndScaleVarFormatter);
            this.mListModels.add(rangeAndScaleListModel);
            this.mAreSetsDefined.add(rangeAndScaleListModel.isSetDefined());
            this.mListRenderers.add(customVarListCellRenderer);
            ISpssVariable[] iSpssVariableArray = (ISpssVariable[])objectArray3[i];
            if (iSpssVariableArray == null) continue;
            rangeAndScaleListModel.removeAll();
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (iSpssVariable == null) continue;
                rangeAndScaleListModel.addElement(iSpssVariable, false);
            }
        }
        rangeAndScaleListModel = this.mListModels.get(this.mCurrentSet - 1);
        customVarListCellRenderer = this.mListRenderers.get(this.mCurrentSet - 1);
        this.mVariableList.setModel(rangeAndScaleListModel);
        this.mVariableList.setCellRenderer(customVarListCellRenderer);
        this.mVariableList.getModel().addListDataListener(this);
        this.mNonlinearCanonicalDlg.updateSetsPanelTitle();
        this.updateButtons();
    }

    private void removeListioners() {
        this.mPreviousButton.removeActionListener(this);
        this.mNextButton.removeActionListener(this);
        this.mVariableList.removeListSelectionListener(this);
        this.mVariableList.getModel().removeListDataListener(this);
    }

    private void addListioners() {
        this.mPreviousButton.addActionListener(this);
        this.mNextButton.addActionListener(this);
        this.mVariableList.addListSelectionListener(this);
        this.mVariableList.getModel().addListDataListener(this);
    }

    private boolean allSetsDefined() {
        Object object = this.mAreSetsDefined.iterator();
        while (object.hasNext()) {
            boolean bl = object.next();
            if (bl) continue;
            return false;
        }
        object = (RangeAndScaleListModel)this.mVariableList.getModel();
        return ((RangeAndScaleListModel)object).isSetDefined();
    }

    @Override
    public TargetVariableList getTargetVariableList() {
        return this.mVariableList;
    }

    @Override
    public int getMaxNoOfLayers() {
        return 9;
    }
}

