/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.overals;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.CommonOneSetMainDlg;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.overals.MeasurementScale;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.overals.NonlinearCanonicalDlg;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.overals.VariableDecoration;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DefineRangeAndScale
extends BaseSubDialog
implements DocumentListener {
    private static final int RANGE_MINIMUM = 1;
    private IntTextField mMaximumEdit;
    private JRadioButton mOrdinalCheck;
    private JRadioButton mSingleNominalCheck;
    private JRadioButton mMultipleNominalCheck;
    private JRadioButton mDiscreteNumericCheck;
    private VariableDecoration mOldDecoration;
    private SpssButtonGroup mScaleButtonGroup;

    public DefineRangeAndScale(BaseProcedureDialog baseProcedureDialog, String string, boolean bl, VariableDecoration variableDecoration) {
        super(baseProcedureDialog, string, bl);
        this.mOldDecoration = variableDecoration;
        this.pack();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_defr_rs";
    }

    @Override
    public boolean continuePressed() {
        int n = Integer.parseInt(this.mMaximumEdit.getText());
        MeasurementScale measurementScale = MeasurementScale.eORDINAL;
        if (this.mOrdinalCheck.isSelected()) {
            measurementScale = MeasurementScale.eORDINAL;
        } else if (this.mSingleNominalCheck.isSelected()) {
            measurementScale = MeasurementScale.eSINGLE_NOMINAL;
        } else if (this.mMultipleNominalCheck.isSelected()) {
            measurementScale = MeasurementScale.eMULTIPLE_NOMINAL;
        } else if (this.mDiscreteNumericCheck.isSelected()) {
            measurementScale = MeasurementScale.eDISCRETE_NUMERIC;
        }
        ((NonlinearCanonicalDlg)((Object)this.getParent())).defineRangeAndScale(n, measurementScale);
        return super.continuePressed();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        if (this.mOldDecoration != null) {
            int n = this.mOldDecoration.getMaximum();
            this.mMaximumEdit.setText(n == 1 ? "" : String.valueOf(n));
            if (this.mOldDecoration.getMeasurementScale() == MeasurementScale.eORDINAL) {
                this.mOrdinalCheck.setSelected(true);
            } else if (this.mOldDecoration.getMeasurementScale() == MeasurementScale.eSINGLE_NOMINAL) {
                this.mSingleNominalCheck.setSelected(true);
            } else if (this.mOldDecoration.getMeasurementScale() == MeasurementScale.eMULTIPLE_NOMINAL) {
                this.mMultipleNominalCheck.setSelected(true);
            } else if (this.mOldDecoration.getMeasurementScale() == MeasurementScale.eDISCRETE_NUMERIC) {
                this.mDiscreteNumericCheck.setSelected(true);
            }
        } else {
            this.mMaximumEdit.setText("");
            this.mOrdinalCheck.setSelected(true);
        }
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(this.getResString("IDS_OVERALS_DEF_RANGE_MINIMUM") + 1);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParentDlg, "IDS_OVERALS_DEF_RANGE_MAXIMUM");
        jLabel2.setLabelFor((Component)this.mMaximumEdit);
        this.mMaximumEdit.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_RANGE_AND_SCALE_MAX"));
        this.mMaximumEdit.setColumns(4);
        this.mMaximumEdit.getDocument().addDocumentListener(this);
        JPanel jPanel3 = this.setupMeasurementScalePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 21;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(insets.top, n2 * 2, insets.bottom, insets.right);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mMaximumEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 2, 1, n, null);
        this.updateContinueButton();
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMaximumEdit);
        vector.add(this.mScaleButtonGroup);
        CommonOneSetMainDlg.fillVectorWithPanelComponents(this.mCmdButtonPanel, vector);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        this.mMaximumEdit = new IntTextField(2, 999, true);
        this.mScaleButtonGroup = new SpssButtonGroup();
        this.mOrdinalCheck = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_OVERALS_DEF_RANGE_ORDINAL"));
        this.mSingleNominalCheck = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_OVERALS_DEF_RANGE_SNOMINAL"));
        this.mMultipleNominalCheck = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_OVERALS_DEF_RANGE_MNOMINAL"));
        this.mDiscreteNumericCheck = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_OVERALS_DEF_RANGE_NUMERIC"));
    }

    private void updateContinueButton() {
        this.enableContinue(this.mMaximumEdit.getText().length() > 0);
    }

    private JPanel setupMeasurementScalePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OVERALS_DEF_RANGE_MEAS_TITLE")));
        this.mScaleButtonGroup.add(this.mOrdinalCheck);
        this.mScaleButtonGroup.add(this.mSingleNominalCheck);
        this.mScaleButtonGroup.add(this.mMultipleNominalCheck);
        this.mScaleButtonGroup.add(this.mDiscreteNumericCheck);
        this.mOrdinalCheck.setSelected(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mOrdinalCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mMultipleNominalCheck, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSingleNominalCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDiscreteNumericCheck, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }
}

