/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.mca;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.BaseCategoryPlotsSubDlg;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.CommonOneSetMainDlg;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.SimpleListCellRenderer;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.mca.MultiCorresAnalysisDlg;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ListDataEvent;

public class VariablePlots
extends BaseCategoryPlotsSubDlg
implements ItemListener {
    static final String VARIABLEPLOTS_DIMESION_TEXTFIELD_STATUS = "VARIABLEPLOTS_DIMENSION_TEXTFIELD_STATUS";
    static final String CATEGORY_PLOTS = "IDS_MCA_VAR_CATEGORY_PLOTS_COLON";
    static final String JOINT_CATEGORY_PLOTS = "IDS_MCA_VAR_JOINT_CATEGORY_PLOTS";
    static final String TRANSFORMATION_PLOTS = "IDS_MCA_VAR_TRANSFORMATION_PLOTS";
    static final String DIMENSIONS_FOR_MULTI_NOM = "IDS_MCA_VAR_DIMENSIONS";
    static final String INCLUDE_RESID_PLOTS = "IDS_MCA_VAR_INCL_RESID_PLOTS";
    static final String DISCRIMINATION_MEASURES = "IDS_MCA_VAR_PROJ_CENTROIDS_OF";
    static final String DISPLAY_PLOT = "IDS_MCA_VAR_PROJ_CENTROIDS_ONTO";
    static final String USE_ALL_VARS = "IDS_MCA_VAR_USE_ALL_VARS";
    static final String USE_SELECTED_VARS = "IDS_MCA_VAR_USE_SELECTED_VARS";
    private TargetVariableList mDiscMeasuresVarList;
    private JCheckBox mDisplayPlot;
    private JRadioButton mUseAllVars;
    private JRadioButton mUseSelectedVars;
    private ArrowButton mDiscMeasuresArrow;
    private ArrowButton mCatPlotsArrow;
    private ArrowButton mJointCatPlotsArrow;
    private ArrowButton mTransPlotsArrow;

    public VariablePlots(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_mcan_category";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updatePlotsOptions();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updatePlotsOptions();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updatePlotsOptions();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updatePlotsOptions();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putBoolean(VARIABLEPLOTS_DIMESION_TEXTFIELD_STATUS, this.mDimensionsForMultiNomEdit.isEnabled());
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        Map<Integer, ISpssVariable> map = ((MultiCorresAnalysisDlg)this.mParentDlg).getAnalysisAndSuppleVars();
        this.mSourceVarList.getModel().removeAll();
        VarListModel varListModel = this.mSourceVarList.getModel();
        if (map.size() > 0) {
            Iterator<Integer> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                ISpssVariable iSpssVariable = map.get(iterator.next());
                varListModel.addElement(iSpssVariable);
            }
        }
        this.updateListFromLoadingMap(map, this.mCatPlotsVarList);
        this.updateListFromLoadingMap(map, this.mJointCatPlotsVarList);
        this.updateListFromLoadingMap(map, this.mTransPlotsVarList);
        this.updateListFromLoadingMap(map, this.mDiscMeasuresVarList);
        this.mSourceVarList.setSelectedIndex(0);
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        CommonOneSetMainDlg.setMnemonicOnContinueButton(jPanel, this.getDlgAccessKey("IDK_MCA_VAR_CONTINUE_KEY"));
        return jPanel;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        this.setupViewPanel();
        this.updatePlotsOptions();
    }

    private void initVars() {
        this.mSourceVarList = new SrcVariableList(VariableList.VarMoveType.eKeepOriginal);
        this.mCatPlotsVarList = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eKeepOriginal);
        this.mJointCatPlotsVarList = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eKeepOriginal);
        this.mTransPlotsVarList = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eKeepOriginal);
        this.mDiscMeasuresVarList = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eKeepOriginal);
        this.mDimensionsForMultiNom = DialogUtil.createLabel(this.mParentDlg, DIMENSIONS_FOR_MULTI_NOM);
        this.mDimensionsForMultiNomEdit = new IntTextField(1, 99999999, true);
        this.mDimensionsForMultiNom.setLabelFor((Component)this.mDimensionsForMultiNomEdit);
        this.mDimensionsForMultiNomEdit.addFocusListener((FocusListener)this);
        this.mInclResidPlots = new JCheckBox(new ToggleButtonAction(this, INCLUDE_RESID_PLOTS));
        this.mDisplayPlot = new JCheckBox(new ToggleButtonAction(this, DISPLAY_PLOT));
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        this.mUseAllVars = new JRadioButton(new ToggleButtonAction(this, USE_ALL_VARS));
        this.mUseSelectedVars = new JRadioButton(new ToggleButtonAction(this, USE_SELECTED_VARS));
        spssButtonGroup.add(this.mUseAllVars);
        spssButtonGroup.add(this.mUseSelectedVars);
        this.mCatPlotsLabel = this.createLabelWithKey(CATEGORY_PLOTS, this.mCatPlotsVarList);
        this.mJointCatPlotsLabel = this.createLabelWithKey(JOINT_CATEGORY_PLOTS, this.mJointCatPlotsVarList);
        this.mTransPlotPanel = new JPanel();
        this.mTransPlotPanel.setBorder(BorderFactory.createTitledBorder(this.getResString(TRANSFORMATION_PLOTS)));
        this.mProjCentroidsOfPanel = new JPanel();
        this.mProjCentroidsOfPanel.setBorder(BorderFactory.createTitledBorder(this.getResString(DISCRIMINATION_MEASURES)));
        this.mDiscMeasuresArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCatPlotsArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mJointCatPlotsArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTransPlotsArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSourceVarList);
        vector.add(this.mCatPlotsArrow);
        vector.add(this.mJointCatPlotsArrow);
        vector.add(this.mTransPlotsArrow);
        vector.add(this.mDiscMeasuresArrow);
        vector.add(this.mCatPlotsVarList);
        vector.add(this.mJointCatPlotsVarList);
        vector.add(this.mTransPlotsVarList);
        vector.add(this.mDimensionsForMultiNomEdit);
        vector.add(this.mInclResidPlots);
        vector.add(this.mDisplayPlot);
        vector.add(spssButtonGroup);
        vector.add(this.mDiscMeasuresVarList);
        CommonOneSetMainDlg.fillVectorWithPanelComponents(this.mCmdButtonPanel, vector);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mCatPlotsVarList.setIdentifier(CATEGORY_PLOTS);
        this.mJointCatPlotsVarList.setIdentifier(JOINT_CATEGORY_PLOTS);
        this.mTransPlotsVarList.setIdentifier(TRANSFORMATION_PLOTS);
        this.mDiscMeasuresVarList.setIdentifier(DISCRIMINATION_MEASURES);
        this.mSourceVarList.setCellRenderer(new SimpleListCellRenderer());
        this.mCatPlotsVarList.setCellRenderer(new SimpleListCellRenderer());
        this.mJointCatPlotsVarList.setCellRenderer(new SimpleListCellRenderer());
        this.mTransPlotsVarList.setCellRenderer(new SimpleListCellRenderer());
        this.mDiscMeasuresVarList.setCellRenderer(new SimpleListCellRenderer());
        this.mDimensionsForMultiNomEdit.setAction((Action)new TextFieldAction(this, DIMENSIONS_FOR_MULTI_NOM));
        this.mDimensionsForMultiNomEdit.setColumns(4);
        this.mDimensionsForMultiNomEdit.getDocument().addDocumentListener(this);
        this.mDimensionsForMultiNomEdit.setText("2");
        this.mTransPlotsVarList.getModel().addListDataListener(this);
        this.mDiscMeasuresVarList.getModel().addListDataListener(this);
        this.mDimensionsForMultiNom.setEnabled(false);
        this.mDimensionsForMultiNomEdit.setEnabled(false);
        this.mDimensionsForMultiNomEdit.setOpaque(false);
        this.mInclResidPlots.setEnabled(false);
        this.mDisplayPlot.setSelected(true);
        this.mUseAllVars.setSelected(true);
        this.mDisplayPlot.addItemListener(this);
        this.mUseAllVars.addItemListener(this);
        this.mUseSelectedVars.addItemListener(this);
    }

    private void setupViewPanel() {
        JPanel jPanel = this.getViewPanel();
        this.mCatPlotsArrow.registerVariableList(this.mSourceVarList, SpssArrowButton.ButtonOrientation.right);
        this.mJointCatPlotsArrow.registerVariableList(this.mSourceVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTransPlotsArrow.registerVariableList(this.mSourceVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDiscMeasuresArrow.registerVariableList(this.mSourceVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCatPlotsArrow.registerVariableList(this.mCatPlotsVarList, SpssArrowButton.ButtonOrientation.left);
        this.mJointCatPlotsArrow.registerVariableList(this.mJointCatPlotsVarList, SpssArrowButton.ButtonOrientation.left);
        this.mTransPlotsArrow.registerVariableList(this.mTransPlotsVarList, SpssArrowButton.ButtonOrientation.left);
        this.mDiscMeasuresArrow.registerVariableList(this.mDiscMeasuresVarList, SpssArrowButton.ButtonOrientation.left);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 21;
        int n2 = 10;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CORR_ANA_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSourceVarList);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        Insets insets = DialogUtil.getStandardControlInsets();
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(insets.top, n3, insets.bottom, n3);
        Insets insets3 = new Insets(n3, insets.left, insets.bottom, insets.right);
        Insets insets4 = DialogUtil.getArrowButtonInsets();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.createScrollPaneForList(this.mSourceVarList), gridBagConstraints, 0, 1, 1, 14, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCatPlotsArrow, gridBagConstraints, 1, 1, 1, 1, n2, insets4);
        DialogUtil.addUsingGBL(jPanel, this.mJointCatPlotsArrow, gridBagConstraints, 1, 3, 1, 1, n2, insets4);
        DialogUtil.addUsingGBL(jPanel, this.mTransPlotsArrow, gridBagConstraints, 1, 5, 1, 1, n2, insets4);
        DialogUtil.addUsingGBL(jPanel, this.mDiscMeasuresArrow, gridBagConstraints, 1, 13, 1, 1, n2, insets4);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mCatPlotsLabel, gridBagConstraints, 2, 0, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mJointCatPlotsLabel, gridBagConstraints, 2, 2, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mDimensionsForMultiNom, gridBagConstraints, 2, 6, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mInclResidPlots, gridBagConstraints, 2, 7, 2, 1, n, insets2);
        n = 22;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDimensionsForMultiNomEdit, gridBagConstraints, 3, 6, 1, 1, n, insets2);
        n = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.createScrollPaneForList(this.mCatPlotsVarList), gridBagConstraints, 2, 1, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.createScrollPaneForList(this.mJointCatPlotsVarList), gridBagConstraints, 2, 3, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.createScrollPaneForList(this.mTransPlotsVarList), gridBagConstraints, 2, 5, 2, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mDisplayPlot, gridBagConstraints, 2, 10, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mUseAllVars, gridBagConstraints, 2, 11, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mUseSelectedVars, gridBagConstraints, 2, 12, 2, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.createScrollPaneForList(this.mDiscMeasuresVarList), gridBagConstraints, 2, 13, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mTransPlotPanel, gridBagConstraints, 2, 4, 2, 5, n, null);
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 2, 4, 2, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 2, 8, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mProjCentroidsOfPanel, gridBagConstraints, 2, 9, 2, 6, n, null);
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 2, 9, 2, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 2, 14, 2, 1, n, insets);
    }

    private void updatePlotsOptions() {
        boolean bl = this.mTransPlotsVarList.getModel().getSize() > 0;
        this.mDimensionsForMultiNom.setEnabled(bl);
        this.mDimensionsForMultiNomEdit.setEnabled(bl);
        this.mDimensionsForMultiNomEdit.setOpaque(bl);
        this.mInclResidPlots.setEnabled(bl);
        bl = this.mDisplayPlot.isSelected();
        this.mUseAllVars.setEnabled(bl);
        this.mUseSelectedVars.setEnabled(bl);
        bl = bl && this.mUseSelectedVars.isSelected();
        this.mDiscMeasuresArrow.setEnabled(bl);
        this.mDiscMeasuresVarList.setEnabled(bl);
        if (bl) {
            this.mDiscMeasuresArrow.registerVariableList(this.mSourceVarList, SpssArrowButton.ButtonOrientation.right);
            this.mDiscMeasuresArrow.registerVariableList(this.mDiscMeasuresVarList, SpssArrowButton.ButtonOrientation.left);
            this.mDiscMeasuresVarList.getModel().removeListDataListener(this);
            this.mDiscMeasuresVarList.getModel().addListDataListener(this);
        } else {
            this.mDiscMeasuresArrow.unRegisterVariableList(this.mSourceVarList);
            this.mDiscMeasuresArrow.unRegisterVariableList(this.mDiscMeasuresVarList);
            this.mDiscMeasuresVarList.getModel().removeListDataListener(this);
        }
        this.updateContinue();
        if (this.mDisplayPlot.isSelected() && this.mUseSelectedVars.isSelected()) {
            this.enableContinue(this.mDiscMeasuresVarList.getModel().getSize() > 0);
        }
    }
}

