/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.mca;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.BaseOutputSubDlg;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.CommonOneSetMainDlg;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.SimpleListCellRenderer;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.mca.MultiCorresAnalysisDlg;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class Output
extends BaseOutputSubDlg {
    static final String LABELING_VARS = "IDS_MCA_OP_LABELING_VARS";
    static final String QUANTIFIED_VARS = "IDS_MCA_OP_QUANTIFIED_VARS";
    static final String DESC_STATS = "IDS_MCA_OP_DESC_STATS";
    static final String CAT_QUANTS = "IDS_MCA_OP_CAT_QUANTS";
    static final String OBJ_SCORES_LABEL_BY = "IDS_MCA_OP_OBJ_SCORES_LABEL_BY";
    static final String OBJ_SCORES_INCL_CATS = "IDS_MCA_OP_OBJ_SCORES_INCL_CATS";
    static final String CORRE_TRANS_VALS = "IDS_MCA_OP_CORRE_TRANS_VALS";
    static final String CORRE_ORIGINAL_VALS = "IDS_MCA_OP_CORRE_ORIGINAL_VALS";
    static final String ITERATION_HISTORY = "IDS_MCA_OP_ITERATION_HISTORY";
    static final String DISCRIMINATION_MEASURES = "IDS_MCA_OP_DISC_MEARSURES";
    static final String OBJECT_SCORES = "IDS_MCA_OP_OBJECT_SCORES";
    private JCheckBox mDiscMeasures;
    private JCheckBox mIterationHistory;
    private JCheckBox mCorreOriginalVars;
    private JCheckBox mCorreTransVars;

    public Output(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.mObjectScores.requestFocus();
        this.updateObjectScoresPanel();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_mcan_output";
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        ISpssVariable iSpssVariable;
        Object object;
        super.loadState(dialogDataModel);
        Map<Integer, ISpssVariable> map = ((MultiCorresAnalysisDlg)this.mParentDlg).getAnalysisAndSuppleVars();
        this.mQuantifiedVars.getModel().removeAll();
        VarListModel varListModel = this.mQuantifiedVars.getModel();
        if (map.size() > 0) {
            object = map.keySet().iterator();
            while (object.hasNext()) {
                iSpssVariable = map.get(object.next());
                varListModel.addElement(iSpssVariable);
            }
        }
        if (this.mQuantifiedVars.getModel().getSize() > 0) {
            this.mQuantifiedVars.setSelectedIndex(0);
        }
        object = ((MultiCorresAnalysisDlg)this.mParentDlg).getLabelingVars();
        this.mLabelingVars.getModel().removeAll();
        varListModel = this.mLabelingVars.getModel();
        if (object.size() > 0) {
            Iterator iterator = object.keySet().iterator();
            while (iterator.hasNext()) {
                iSpssVariable = (ISpssVariable)object.get(iterator.next());
                varListModel.addElement(iSpssVariable);
            }
        }
        map.putAll((Map<Integer, ISpssVariable>)object);
        this.updateListFromLoadingMap(map, this.mCatQuantificatoins);
        this.updateListFromLoadingMap(map, this.mDescStats);
        this.updateListFromLoadingMap(map, this.mObjScoresIncludeCat);
        this.updateListFromLoadingMap(map, this.mObjScoresLabelBy);
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        CommonOneSetMainDlg.setMnemonicOnContinueButton(jPanel, this.getDlgAccessKey("IDK_MCA_OP_CONTINUE_KEY"));
        return jPanel;
    }

    @Override
    protected void initVars() {
        this.mObjectScores = new JCheckBox(new ToggleButtonAction(this, OBJECT_SCORES));
        this.mDiscMeasures = new JCheckBox(new ToggleButtonAction(this, DISCRIMINATION_MEASURES));
        this.mIterationHistory = new JCheckBox(new ToggleButtonAction(this, ITERATION_HISTORY));
        this.mCorreOriginalVars = new JCheckBox(new ToggleButtonAction(this, CORRE_ORIGINAL_VALS));
        this.mCorreTransVars = new JCheckBox(new ToggleButtonAction(this, CORRE_TRANS_VALS));
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mObjectScores);
        spssButtonGroup.add(this.mDiscMeasures);
        spssButtonGroup.add(this.mIterationHistory);
        spssButtonGroup.add(this.mCorreOriginalVars);
        spssButtonGroup.add(this.mCorreTransVars);
        this.mQuantifiedVars = new SrcVariableList(VariableList.VarMoveType.eKeepOriginal);
        this.mLabelingVars = new SrcVariableList(VariableList.VarMoveType.eKeepOriginal);
        this.mCatQuantificatoins = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eKeepOriginal);
        this.mCatQuantificatoinsArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDescStats = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eKeepOriginal);
        this.mDescStatsArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mObjScoresIncludeCat = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eKeepOriginal);
        this.mObjScoresIncludeCatArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mObjScoresIncludeCatLabel = this.createLabelWithKey(OBJ_SCORES_INCL_CATS, this.mObjScoresIncludeCat);
        this.mObjScoresLabelBy = new TargetVariableList(TargetVariableList.TargetListType.single_item, VariableList.VarMoveType.eKeepOriginal);
        this.mObjScoresLabelByArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mObjScoresLabelByLabel = this.createLabelWithKey(OBJ_SCORES_LABEL_BY, this.mObjScoresLabelBy);
        this.mObjScoresPanel = new JPanel(new GridBagLayout());
        this.mQuantifiedVariablesLabel = this.createLabelWithKey(QUANTIFIED_VARS, this.mQuantifiedVars);
        this.mLabelingVariablesLabel = this.createLabelWithKey(LABELING_VARS, this.mLabelingVars);
        this.mCategoryQuantificationsLabel = DialogUtil.createMultiLineLabel(this, CAT_QUANTS, 200);
        this.mCategoryQuantificationsLabel.setLabelFor(this.mCatQuantificatoins);
        this.mDescriptiveStatisticsLabel = this.createLabelWithKey(DESC_STATS, this.mDescStats);
    }

    @Override
    protected void setDefaults() {
        this.mObjectScores.addItemListener(this);
        this.mDiscMeasures.setSelected(true);
        this.mCorreTransVars.setSelected(true);
        this.mQuantifiedVars.addFocusListener(this);
        this.mLabelingVars.addFocusListener(this);
        this.mCatQuantificatoins.addFocusListener(this);
        this.mDescStats.addFocusListener(this);
        this.mQuantifiedVars.addListSelectionListener(this);
        this.mLabelingVars.addListSelectionListener(this);
        this.mQuantifiedVars.setIdentifier(QUANTIFIED_VARS);
        this.mLabelingVars.setIdentifier(LABELING_VARS);
        this.mCatQuantificatoins.setIdentifier(CAT_QUANTS);
        this.mDescStats.setIdentifier(DESC_STATS);
        this.mObjScoresIncludeCat.setIdentifier(OBJ_SCORES_INCL_CATS);
        this.mObjScoresLabelBy.setIdentifier(OBJ_SCORES_LABEL_BY);
        this.mQuantifiedVars.setCellRenderer(new SimpleListCellRenderer());
        this.mLabelingVars.setCellRenderer(new SimpleListCellRenderer());
        this.mCatQuantificatoins.setCellRenderer(new SimpleListCellRenderer());
        this.mDescStats.setCellRenderer(new SimpleListCellRenderer());
        this.mObjScoresIncludeCat.setCellRenderer(new SimpleListCellRenderer());
        this.mObjScoresLabelBy.setCellRenderer(new SimpleListCellRenderer());
        this.mCatQuantificatoinsArrow.registerVariableList(this.mCatQuantificatoins, SpssArrowButton.ButtonOrientation.left);
        this.mDescStatsArrow.registerVariableList(this.mDescStats, SpssArrowButton.ButtonOrientation.left);
        this.mObjScoresIncludeCatArrow.registerVariableList(this.mObjScoresIncludeCat, SpssArrowButton.ButtonOrientation.left);
        this.mObjScoresLabelByArrow.registerVariableList(this.mObjScoresLabelBy, SpssArrowButton.ButtonOrientation.left);
        this.mCatQuantificatoinsArrow.registerVariableList(this.mQuantifiedVars, SpssArrowButton.ButtonOrientation.right);
        this.registerArrowButtonsToQuant();
        this.mCatQuantificatoinsArrow.setEnabled(false);
        this.mDescStatsArrow.setEnabled(false);
        this.mObjScoresPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MCA_OP_OBJECT_SCORES_OPTIONS")));
        this.mObjScoresPanel.setOpaque(false);
        this.enableObjectScoreControls(this.mObjectScores.isSelected());
    }

    @Override
    protected JPanel setupTablesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MCA_OP_TABLES")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 21;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mObjectScores, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mDiscMeasures, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mIterationHistory, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCorreOriginalVars, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCorreTransVars, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }
}

