/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.catpca;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.BasicACRWidget;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.BaseOptionsSubDlg;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.CommonOneSetMainDlg;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.catpca.CatPrincipalComponentsDlg;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntDocument;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;

public class Options
extends BaseOptionsSubDlg {
    static final String VARIABLE_LABELS = "IDS_CATPCA_OPTS_LBL_PLOT_VAR_LBL_OR_VAL_LBL";
    static final String VARIABLE_NAMES = "IDS_CATPCA_OPTS_LBL_PLOT_VAR_NAME_OR_VAL";
    static final String CONVERGENCE_TEXT_FIELD_KEY = "CONVERGENCE_TEXT_FIELD_KEY";
    static final String ITER_TEXT_FIELD_KEY = "ITER_TEXT_FIELD_KEY";
    static final String LIMIT_TEXT_FIELD_KEY = "LIMIT_TEXT_FIELD_KEY";
    static final String BASIC_ACR_WIDGET_KEY = "BASIC_ACR_WIDGET_KEY";
    static final String CONFIG_FILE = "IDS_CATPCA_OPTS_CONFIG_FILE_3DOT";
    static final String CONFIG_OPTIONS = "IDS_CATPCA_OPTS_CONFIG_OPTIONS";
    static final String PLOT_DIM_HIGHEST_DIM = "IDS_CATPCA_OPTS_PLOT_DIM_HIGHEST_DIM";
    static final String PLOT_DIM_LOWEST_DIM = "IDS_CATPCA_OPTS_PLOT_DIM_LOWEST_DIM";
    static final String PLOT_DIM_RESTRICT_NUM_OF_DIM = "IDS_CATPCA_OPTS_PLOT_DIM_RESTRICT_NUM_OF_DIM";
    static final String PLOT_DIM_DISP_ALL_DIMS_IN_THE_SOL = "IDS_CATPCA_OPTS_PLOT_DIM_DISP_ALL_DIMS_IN_THE_SOL";
    static final String NORMALIZATION_CUSTOM_VALUE = "IDS_CATPCA_OPTS_NORM_CUSTOM_VAL";
    static final String NORMALIZATION_METHOD = "IDS_CATPCA_OPTS_NORM_METHOD_OPTIONS";
    static final String DEFAULT_CONVERGENCE_VALUE = ".00001";
    static final String DEFAULT_MAX_ITER_VALUE = "100";
    static final String DEFAULT_LIMIT_VALUE = "20";
    private static final String RANGE_OF_CASES = "IDS_CATPCA_OPTS_SUPPLE_OBJ_RANGE_OF_CASES";
    private static final String SINGLE_CASE = "IDS_CATPCA_OPTS_SUPPLE_OBJ_SINGLE_CASE";
    private static final String FIRST_LABEL = "IDS_CATPCA_OPTS_SUPPLE_OBJ_RANGE_FIRST";
    private static final String LAST_LABEL = "IDS_CATPCA_OPTS_SUPPLE_OBJ_RANGE_LAST";
    private static final String LAST_LABEL_KEY = "IDK_CATPCA_OPTS_SUPPLE_OBJ_RANGE_LAST_KEY";
    private static final String CONVERGENCE_LABEL = "IDS_CATPCA_OPTS_CRIT_CONVERGENCE";
    private static final String MAX_ITERATIONS_LABEL = "IDS_CATPCA_OPTS_CRIT_MAX_ITERS";
    private static final String LIMIT_FOR_LENGTH_LABEL = "IDS_CATPCA_OPTS_LBL_PLOT_LIMI_LABLE_LENGTH";
    private static final String SUPPLEMENTARY_OBJECTS_PANEL_TITLE = "IDS_CATPCA_OPTS_SUPPLEMENTARY_OBJECTS";
    private static final String CRITERIA_PANEL_TITLE = "IDS_CATPCA_OPTS_CRITERIA";
    private static final String LABEL_PLOTS_BY_PANEL_TITLE = "IDS_CATPCA_OPTS_LBL_PLOT_BY";
    private static final String VALUE_OUT_OF_RANGE = "ERR_CATPCA_OPTS_VAL_OUT_OF_RANGE";
    private static final String WARNING_INVALID_RANGE = "ERR_CATPCA_OPTS_VAL_INVALID_RANGE";

    public Options(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cpca_options";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(this.getResString("IDS_CATPCA_OPTS_FILE_CHOOSER_TITLE"));
        RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_CATPCA_OPTS_FILE_FILTER_DESC"), this.getResString("IDS_CATPCA_OPTS_FILE_EXTENSION"));
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(true);
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        int n = remoteFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string = remoteFileChooser.getSelectedFilePath();
            if (!string.contains(this.getResString("IDS_CATPCA_OPTS_FILE_EXTENSION"))) {
                string = string + this.getResString("IDS_CATPCA_OPTS_FILE_EXTENSION");
            }
            this.mConfigFile.setText(string);
        }
    }

    @Override
    public boolean continuePressed() {
        if (this.mBasicACRWidget.isAddEnabled() && SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_OPTS_PENDING_OPERATION_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) != 0) {
            return false;
        }
        if (this.mRangeOfCasesRadio.isSelected() && this.mFirstTextField.getText().length() > 0) {
            if (this.mLastTextField.getText().length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(WARNING_INVALID_RANGE), VersionInfo.getAppVersionString());
                this.mFirstTextField.selectAll();
                this.mFirstTextField.requestFocus();
                return false;
            }
            if (this.isRangeInvalid()) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(WARNING_INVALID_RANGE), VersionInfo.getAppVersionString());
                this.mLastTextField.selectAll();
                this.mLastTextField.requestFocus();
                return false;
            }
        }
        if (this.mSingleCaseRadio.isSelected() && this.mSingleCaseTextField.getText().length() > 0 && this.isTextZero(this.mSingleCaseTextField.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
            this.mSingleCaseTextField.selectAll();
            this.mSingleCaseTextField.requestFocus();
            return false;
        }
        if (this.mPlotDimRestrict.isSelected()) {
            if (this.mPlotDimLoDimEdit.getText().length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MCA_OPTS_INVALID_DIM_VAL"), VersionInfo.getAppVersionString());
                this.mPlotDimLoDimEdit.selectAll();
                this.mPlotDimLoDimEdit.requestFocus();
                return false;
            }
            if (this.mPlotDimHiDimEdit.getText().length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MCA_OPTS_INVALID_DIM_VAL"), VersionInfo.getAppVersionString());
                this.mPlotDimHiDimEdit.selectAll();
                this.mPlotDimHiDimEdit.requestFocus();
                return false;
            }
            int n = Integer.parseInt(this.mPlotDimLoDimEdit.getText());
            int n2 = Integer.parseInt(this.mPlotDimHiDimEdit.getText());
            int n3 = ((CatPrincipalComponentsDlg)this.mParentDlg).getDimension();
            if (n >= n2 || n <= 0 || n >= n3) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CATPCA_OPTS_INVALID_DIM_VAL"), VersionInfo.getAppVersionString());
                this.mPlotDimLoDimEdit.selectAll();
                this.mPlotDimLoDimEdit.requestFocus();
                return false;
            }
            if (n2 <= 1 || n2 > n3) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CATPCA_OPTS_INVALID_DIM_VAL"), VersionInfo.getAppVersionString());
                this.mPlotDimHiDimEdit.selectAll();
                this.mPlotDimHiDimEdit.requestFocus();
                return false;
            }
        }
        if (this.isTextZero(this.mMaximumIterationsTextField.getText()) || this.isTextTooBig(this.mMaximumIterationsTextField.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
            this.mMaximumIterationsTextField.selectAll();
            this.mMaximumIterationsTextField.requestFocus();
            return false;
        }
        if (this.mNormalizationMethodCombo.getSelectedItem().toString().equals(this.mNormMethodArr[4])) {
            return this.mNormCustomValueEdit.getText() != null && this.mNormCustomValueEdit.getText().length() > 0 && this.mNormCustomValueEdit.checkRange();
        }
        return super.continuePressed();
    }

    @Override
    protected void updateContinue() {
        boolean bl = true;
        if (!this.mConfigurationCombo.getSelectedItem().toString().equals(this.mConfigOptionsArr[0])) {
            boolean bl2 = bl = this.mConfigFile.getText() != null && this.mConfigFile.getText().length() > 0;
        }
        if (bl && this.mNormalizationMethodCombo.getSelectedItem().toString().equals(this.mNormMethodArr[4])) {
            bl = this.mNormCustomValueEdit.getText() != null && this.mNormCustomValueEdit.getText().length() > 0;
        }
        this.enableContinue(bl && this.mConvergenceTextField.getText().length() > 0 && this.mMaximumIterationsTextField.getText().length() > 0 && this.mLimitForLengthTextField.getText().length() > 0);
        if (this.mDeltaFloatEdit.isEnabled() && this.mDeltaFloatEdit.getText().length() == 0) {
            this.enableContinue(false);
        } else if (this.mKappaFloatEdit.isEnabled() && this.mKappaFloatEdit.getText().length() == 0) {
            this.enableContinue(false);
        } else {
            this.enableContinue(true);
        }
    }

    @Override
    protected void showValueOutOfRangeWarning() {
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
    }

    @Override
    protected void showInvalideRangeWarning() {
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(WARNING_INVALID_RANGE), VersionInfo.getAppVersionString());
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        CommonOneSetMainDlg.setMnemonicOnContinueButton(jPanel, this.getDlgAccessKey("IDK_CATPCA_OPTS_CONTINUE_KEY"));
        return jPanel;
    }

    @Override
    protected void initVars() {
        this.mSuppObjectsGroup = new SpssButtonGroup();
        this.mLabelPlotsGroup = new SpssButtonGroup();
        this.mPlotDimsGroup = new SpssButtonGroup();
        this.mRotationGroup = new SpssButtonGroup();
        this.mNormMethodArr = this.getResStringArray(NORMALIZATION_METHOD);
        this.mNormalizationMethodCombo = new JComboBox<String>(this.mNormMethodArr);
        this.mNormalizationMethodCombo.setAction(new ComboboxAction(this, NORMALIZATION_METHOD));
        this.mNormalizationMethodCombo.addItemListener(this);
        this.mNormCustomValue = DialogUtil.createLabel(this.mParentDlg, NORMALIZATION_CUSTOM_VALUE);
        this.mNormCustomValueEdit = new FloatTextField(-1.0, 1.0, 6, false);
        this.mNormCustomValueEdit.setAction((Action)new TextFieldAction(this, NORMALIZATION_CUSTOM_VALUE));
        this.mNormCustomValueEdit.setColumns(5);
        this.mNormCustomValueEdit.getDocument().addDocumentListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, RANGE_OF_CASES);
        this.mRangeOfCasesRadio = new JRadioButton(toggleButtonAction);
        this.mRangeOfCasesRadio.addItemListener(this);
        this.mSuppObjectsGroup.add(this.mRangeOfCasesRadio);
        toggleButtonAction = new ToggleButtonAction(this, SINGLE_CASE);
        this.mSingleCaseRadio = new JRadioButton(toggleButtonAction);
        this.mSingleCaseRadio.addItemListener(this);
        this.mSuppObjectsGroup.add(this.mSingleCaseRadio);
        toggleButtonAction = new ToggleButtonAction(this, VARIABLE_LABELS);
        this.mVariableLabelsRadio = new JRadioButton(toggleButtonAction);
        this.mVariableLabelsRadio.addItemListener(this);
        this.mLabelPlotsGroup.add(this.mVariableLabelsRadio);
        toggleButtonAction = new ToggleButtonAction(this, VARIABLE_NAMES);
        this.mVariableNamesRadio = new JRadioButton(toggleButtonAction);
        this.mVariableNamesRadio.addItemListener(this);
        this.mLabelPlotsGroup.add(this.mVariableNamesRadio);
        this.mFirstTextField = new ContextEnabledTextField();
        this.mFirstTextField.setColumns(5);
        this.mFirstTextField.setDocument((Document)new IntDocument(true));
        this.mFirstTextField.getDocument().addDocumentListener(this);
        this.mFirstTextField.addFocusListener((FocusListener)this);
        this.mFirstLabel = DialogUtil.createLabel(this, FIRST_LABEL);
        this.mFirstLabel.setLabelFor((Component)this.mFirstTextField);
        this.mLastTextField = new ContextEnabledTextField();
        this.mLastTextField.setDocument((Document)new IntDocument(true));
        this.mLastTextField.getDocument().addDocumentListener(this);
        this.mLastTextField.addFocusListener((FocusListener)this);
        this.mSingleCaseTextField = new ContextEnabledTextField();
        this.mSingleCaseTextField.setDocument((Document)new FixedLengthNumericDocument(8, true, false));
        this.mSingleCaseTextField.getDocument().addDocumentListener(this);
        this.mSingleCaseTextField.addFocusListener((FocusListener)this);
        this.mLastLabel = DialogUtil.createLabel(this.mParentDlg, LAST_LABEL);
        this.mLastLabel.setLabelFor((Component)this.mLastTextField);
        this.mBasicACRWidget = new BasicACRWidget(BASIC_ACR_WIDGET_KEY);
        this.mBasicACRWidget.getList().setSelectionMode(2);
        this.mBasicACRWidget.addBasicACRListener(this);
        this.mBasicACRWidget.setAddMnemonic(this.getDlgAccessKey("IDK_CATPCA_OPTS_SUPPLE_OBJ_ACR_ADD_KEY"));
        this.mBasicACRWidget.setChangeMnemonic(this.getDlgAccessKey("IDK_CATPCA_OPTS_SUPPLE_OBJ_ACR_CHANGE_KEY"));
        this.mBasicACRWidget.setRemoveMnemonic(this.getDlgAccessKey("IDK_CATPCA_OPTS_SUPPLE_OBJ_ACR_REMOVE_KEY"));
        this.mConvergenceTextField = new FloatTextField(1.0E-6, 9.9999999E7, 6, true);
        this.mConvergenceTextField.getDocument().addDocumentListener(this);
        this.mConvergenceTextField.setAction((Action)new TextFieldAction(this, CONVERGENCE_TEXT_FIELD_KEY));
        this.mConvergenceTextField.addFocusListener((FocusListener)this);
        this.mConvergenceLabel = DialogUtil.createLabel(this, CONVERGENCE_LABEL);
        this.mConvergenceLabel.setLabelFor((Component)this.mConvergenceTextField);
        this.mMaximumIterationsTextField = new ContextEnabledTextField();
        this.mMaximumIterationsTextField.setDocument((Document)new IntDocument());
        this.mMaximumIterationsTextField.getDocument().addDocumentListener(this);
        this.mMaximumIterationsTextField.setAction((Action)new TextFieldAction(this, ITER_TEXT_FIELD_KEY));
        this.mMaximumIterationsTextField.addFocusListener((FocusListener)this);
        this.mMaximumIterationsLabel = DialogUtil.createLabel(this, MAX_ITERATIONS_LABEL);
        this.mMaximumIterationsLabel.setLabelFor((Component)this.mMaximumIterationsTextField);
        this.mLimitForLengthTextField = new IntTextField(1, 20, true);
        this.mLimitForLengthTextField.getDocument().addDocumentListener(this);
        this.mLimitForLengthTextField.setAction((Action)new TextFieldAction(this, LIMIT_TEXT_FIELD_KEY));
        this.mLimitForLengthTextField.addFocusListener((FocusListener)this);
        this.mLimitForLengthLabel = DialogUtil.createLabel(this, LIMIT_FOR_LENGTH_LABEL);
        this.mLimitForLengthLabel.setLabelFor((Component)this.mLimitForLengthTextField);
        this.mPlotDimDisplayAll = new JRadioButton(new ToggleButtonAction(this, PLOT_DIM_DISP_ALL_DIMS_IN_THE_SOL));
        this.mPlotDimsGroup.add(this.mPlotDimDisplayAll);
        this.mPlotDimDisplayAll.addItemListener(this);
        this.mPlotDimRestrict = new JRadioButton(new ToggleButtonAction(this, PLOT_DIM_RESTRICT_NUM_OF_DIM));
        this.mPlotDimsGroup.add(this.mPlotDimRestrict);
        this.mPlotDimRestrict.addItemListener(this);
        this.mPlotDimLoDim = DialogUtil.createLabel(this, PLOT_DIM_LOWEST_DIM);
        this.mPlotDimLoDimEdit = new IntTextField(1, 99999999, true);
        this.mPlotDimLoDimEdit.setAction((Action)new TextFieldAction(this, PLOT_DIM_LOWEST_DIM));
        this.mPlotDimLoDim.setLabelFor((Component)this.mPlotDimLoDimEdit);
        this.mPlotDimHiDim = DialogUtil.createLabel(this, PLOT_DIM_HIGHEST_DIM);
        this.mPlotDimHiDimEdit = new IntTextField(2, 99999999, true);
        this.mPlotDimHiDimEdit.setAction((Action)new TextFieldAction(this, PLOT_DIM_HIGHEST_DIM));
        this.mPlotDimHiDim.setLabelFor((Component)this.mPlotDimHiDimEdit);
        this.mConfigOptionsArr = this.getResStringArray(CONFIG_OPTIONS);
        this.mConfigurationCombo = new JComboBox<String>(this.mConfigOptionsArr);
        this.mConfigurationCombo.setAction(new ComboboxAction(this, CONFIG_OPTIONS));
        this.mConfigurationCombo.addItemListener(this);
        this.mConfigFileButton = DialogUtil.createButton(this, CONFIG_FILE, this);
        this.mConfigFile = new FileTextField();
        this.mConfigFile.setAction(new TextFieldAction(this, CONFIG_FILE));
        this.mConfigFile.setEditable(false);
        this.mConfigFile.setBorder(BorderFactory.createEmptyBorder());
        this.mConfigFile.getDocument().addDocumentListener(this);
        this.mNormMethodPanel = new JPanel(new GridBagLayout());
        this.mConfigPanel = new JPanel(new GridBagLayout());
        this.mPlotDimPanel = new JPanel(new GridBagLayout());
        this.mPlotDimPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CATPCA_OPTS_PLOT_DIM_TITLE")));
        this.mSuppObjectsPanel = new JPanel(new GridBagLayout());
        this.mSuppObjectsPanel.setBorder(BorderFactory.createTitledBorder(this.getResString(SUPPLEMENTARY_OBJECTS_PANEL_TITLE)));
        this.mCriteriaPanel = new JPanel(new GridBagLayout());
        this.mCriteriaPanel.setBorder(BorderFactory.createTitledBorder(this.getResString(CRITERIA_PANEL_TITLE)));
        this.mLabelPlotsByPanel = new JPanel(new GridBagLayout());
        this.mLabelPlotsByPanel.setBorder(BorderFactory.createTitledBorder(this.getResString(LABEL_PLOTS_BY_PANEL_TITLE)));
        this.mNoneRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_CATPCA_OPTS_ROTATION_NONE"));
        this.mRotationGroup.add(this.mNoneRadio);
        this.mNoneRadio.addItemListener(this);
        this.mVarimaxRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_CATPCA_OPTS_ROTATION_VARIMAX"));
        this.mRotationGroup.add(this.mVarimaxRadio);
        this.mObliminRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_CATPCA_OPTS_ROTATION_OBLIMIN"));
        this.mRotationGroup.add(this.mObliminRadio);
        this.mObliminRadio.addItemListener(this);
        this.mQuartimaxRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_CATPCA_OPTS_ROTATION_QUARTIMAX"));
        this.mRotationGroup.add(this.mQuartimaxRadio);
        this.mEquimaxRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_CATPCA_OPTS_ROTATION_EQUIMAX"));
        this.mRotationGroup.add(this.mEquimaxRadio);
        this.mPromaxRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_CATPCA_OPTS_ROTATION_PROMAX"));
        this.mRotationGroup.add(this.mPromaxRadio);
        this.mPromaxRadio.addItemListener(this);
        this.mKappaLabel = DialogUtil.createLabel(this, "IDS_CATPCA_OPTS_ROTATION_KAPPA");
        this.mKappaFloatEdit = new FloatTextField(1.0, 10000.0, 2, true);
        this.mKappaFloatEdit.setIncludeMinRange(true);
        this.mKappaFloatEdit.setIncludeMaxRange(false);
        this.mKappaFloatEdit.setAction((Action)new TextFieldAction(this, "IDS_CATPCA_OPTS_ROTATION_KAPPA"));
        this.mKappaFloatEdit.getDocument().addDocumentListener(this);
        this.mKappaFloatEdit.addFocusListener((FocusListener)this);
        this.mKappaLabel.setLabelFor((Component)this.mKappaFloatEdit);
        this.mDeltaLabel = DialogUtil.createLabel(this, "IDS_CATPCA_OPTS_ROTATION_DELTA");
        this.mDeltaFloatEdit = new FloatTextField(Double.NaN, 0.8, 1);
        this.mDeltaFloatEdit.setAction((Action)new TextFieldAction(this, "IDS_CATPCA_OPTS_ROTATION_DELTA"));
        this.mDeltaFloatEdit.getDocument().addDocumentListener(this);
        this.mDeltaFloatEdit.addFocusListener((FocusListener)this);
        this.mDeltaLabel.setLabelFor((Component)this.mDeltaFloatEdit);
        this.mKaiserCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_CATPCA_OPTS_ROTATION_KAISER"));
    }

    @Override
    protected void setDefaults() {
        this.mLastTextField.setColumns(5);
        this.mSingleCaseTextField.setColumns(5);
        this.mConvergenceTextField.setColumns(5);
        this.mMaximumIterationsTextField.setColumns(5);
        this.mLimitForLengthTextField.setColumns(5);
        this.mRangeOfCasesRadio.setSelected(true);
        this.mSingleCaseTextField.setEnabled(false);
        this.mSingleCaseTextField.setOpaque(false);
        this.mBasicACRWidget.setEnabled(false);
        this.mConvergenceTextField.setText(DEFAULT_CONVERGENCE_VALUE);
        this.mMaximumIterationsTextField.setText(DEFAULT_MAX_ITER_VALUE);
        this.mVariableLabelsRadio.setSelected(true);
        this.mLimitForLengthTextField.setText(DEFAULT_LIMIT_VALUE);
        this.mPlotDimDisplayAll.setSelected(true);
        this.mConfigFileButton.setEnabled(false);
        this.mConfigFile.setEnabled(false);
        this.mNormCustomValue.setEnabled(false);
        this.mNormCustomValueEdit.setEnabled(false);
        this.mNormCustomValueEdit.setOpaque(false);
        this.mNoneRadio.setSelected(true);
        this.setRotationState();
        this.mDeltaFloatEdit.setText("0");
        this.mKappaFloatEdit.setText("4");
        this.mKaiserCheck.setSelected(true);
    }

    private void setRotationState() {
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        boolean bl = dialogDataModel != null && dialogDataModel.containsBooleanKey("IDS_CATPCA_BOOTSTRAP_PERFORM") ? dialogDataModel.getBoolean("IDS_CATPCA_BOOTSTRAP_PERFORM") : false;
        this.mNoneRadio.setEnabled(!bl);
        this.mQuartimaxRadio.setEnabled(!bl);
        this.mVarimaxRadio.setEnabled(!bl);
        this.mEquimaxRadio.setEnabled(!bl);
        this.mObliminRadio.setEnabled(!bl);
        this.mPromaxRadio.setEnabled(!bl);
        this.mDeltaLabel.setEnabled(!bl && this.mObliminRadio.isSelected());
        this.mDeltaFloatEdit.setEnabled(!bl && this.mObliminRadio.isSelected());
        this.mKappaLabel.setEnabled(!bl && this.mPromaxRadio.isSelected());
        this.mKappaFloatEdit.setEnabled(!bl && this.mPromaxRadio.isSelected());
        this.mKaiserCheck.setEnabled(!bl && !this.mNoneRadio.isSelected());
    }
}

