/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.catpca;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.CommonOneSetMainDlg;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.OptimalScalingDropListener;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.SimpleListCellRenderer;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.catpca.CatPrincipalComponentsDlg;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class LoadingPlots
extends BaseSubDialog
implements ItemListener {
    static final String DISP_COMP_LOADINGS = "IDS_CATPCA_LOAD_DISP_COMP_LOADINGS";
    static final String INCLUDE_CENTROIDS = "IDS_CATPCA_LOAD_INCLUDE_CENTROIDS";
    static final String LOADING_ALL_VARS = "IDS_CATPCA_LOAD_ALL_VARS";
    static final String LOADING_SELECTED_VARS = "IDS_CATPCA_LOAD_SELECTED_VARS";
    static final String LOADING_VARS_AVAILABLE = "IDS_CATPCA_LOAD_AVAILABLE";
    static final String LOADING_VARS_SELECTED = "IDS_CATPCA_LOAD_SELECTED";
    static final String INCLUDE_CENTR_ALL_VARS = "IDS_CATPCA_LOAD_CENTR_ALL_VARS";
    static final String INCLUDE_CENTR_SELECTED_VARS = "IDS_CATPCA_LOAD_CENTR_SELECTED_VARS";
    static final String INCLUDE_CENTR_AVAILABLE = "IDS_CATPCA_LOAD_CENTR_AVAILABLE";
    static final String INCLUDE_CENTR_SELECTED = "IDS_CATPCA_LOAD_CENTR_SELECTED";
    private JCheckBox mVarianceCheck;
    private JCheckBox mDisplayCompLoadings;
    private JCheckBox mIncludeCentroids;
    private JPanel mLoadingPanel;
    private JLabel mLoadingInclude;
    private JRadioButton mLoadingIncludeAllVars;
    private JRadioButton mLoadingIncludeSelectedVars;
    private JLabel mLoadingAvailable;
    private JLabel mLoadingSelected;
    private SrcVariableList mLoadingAvailableVars;
    private TargetVariableList mLoadingSelectedVars;
    private ArrowButton mLoadingArrow;
    private JPanel mIncludeCentroidsPanel;
    private JLabel mIncludeCentroidsInclude;
    private JRadioButton mIncludeCentroidsIncludeAllVars;
    private JRadioButton mIncludeCentroidsIncludeSelectedVars;
    private JLabel mIncludeCentroidsAvailable;
    private JLabel mIncludeCentroidsSelected;
    private SrcVariableList mIncludeCentroidsAvailableVars;
    private TargetVariableList mIncludeCentroidsSelectedVars;
    private ArrowButton mIncludeCentroidsArrow;
    private SpssButtonGroup mLoadingIncludeButtonGroup;
    private SpssButtonGroup mCentroidsIncludeButtonGroup;
    private JScrollPane mCelenoidAvailableVarsScrollPane;
    private JScrollPane mCelenoidSelectedVarsScrollPane;
    private JScrollPane mLoadingAvailableVarsScrollPane;
    private JScrollPane mLoadingSelectedVarsScrollPane;

    public LoadingPlots(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.pack();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cpca_loading";
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            DialogUtil.removeDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this));
            SrcVariableList[] srcVariableListArray = new SrcVariableList[]{this.mLoadingAvailableVars, this.mIncludeCentroidsAvailableVars};
            TargetVariableList[] targetVariableListArray = new TargetVariableList[]{this.mLoadingSelectedVars, this.mIncludeCentroidsSelectedVars};
            OptimalScalingDropListener.addDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this), this, srcVariableListArray, targetVariableListArray);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mDisplayCompLoadings) {
            this.updatePanels();
        } else if (itemEvent.getSource() == this.mIncludeCentroids) {
            this.updatePanels();
        } else if (itemEvent.getSource() == this.mLoadingIncludeAllVars || itemEvent.getSource() == this.mLoadingIncludeSelectedVars) {
            this.enableLoadingLists(this.mLoadingIncludeSelectedVars.isSelected());
        } else if (itemEvent.getSource() == this.mIncludeCentroidsIncludeAllVars || itemEvent.getSource() == this.mIncludeCentroidsIncludeSelectedVars) {
            this.enableIncludeCentroidsLists(this.mIncludeCentroidsIncludeSelectedVars.isSelected());
        }
    }

    protected boolean isDisplayComponentLoadings() {
        return this.mDisplayCompLoadings.isSelected();
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        CommonOneSetMainDlg.setMnemonicOnContinueButton(jPanel, this.getDlgAccessKey("IDK_CATPCA_LOAD_SAVE_CONTINUE_KEY"));
        return jPanel;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        this.setupViewPanel();
        this.setTabTraversal();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        ISpssVariable iSpssVariable;
        Iterator<Integer> iterator;
        super.loadState(dialogDataModel);
        CatPrincipalComponentsDlg catPrincipalComponentsDlg = (CatPrincipalComponentsDlg)this.mParentDlg;
        List<Map<Integer, ISpssVariable>> list = catPrincipalComponentsDlg.getMultiNominalVars();
        Map<Integer, ISpssVariable> map = list.get(0);
        this.updateListFromLoadingMap(map, this.mIncludeCentroidsAvailableVars);
        this.updateListFromLoadingMap(map, this.mIncludeCentroidsSelectedVars);
        VarListModel varListModel = this.mIncludeCentroidsAvailableVars.getModel();
        if (map.size() > 0) {
            iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                iSpssVariable = map.get(iterator.next());
                varListModel.addElement(iSpssVariable);
            }
        }
        map = list.get(1);
        this.updateListFromLoadingMap(map, this.mLoadingAvailableVars);
        this.updateListFromLoadingMap(map, this.mLoadingSelectedVars);
        varListModel = this.mLoadingAvailableVars.getModel();
        if (map.size() > 0) {
            iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                iSpssVariable = map.get(iterator.next());
                varListModel.addElement(iSpssVariable);
            }
        }
    }

    private void updateListFromLoadingMap(Map<Integer, ISpssVariable> map, VariableList variableList) {
        VarListModel varListModel = variableList.getModel();
        int n = varListModel.getSize();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            int n2 = iSpssVariable.getId().asInt();
            if (map.containsKey(n2)) {
                map.remove(n2);
                continue;
            }
            varListModel.removeElement(iSpssVariable);
            --i;
            --n;
        }
    }

    private void setDefaults() {
        this.mLoadingIncludeButtonGroup = new SpssButtonGroup();
        this.mLoadingIncludeButtonGroup.add(this.mLoadingIncludeAllVars);
        this.mLoadingIncludeButtonGroup.add(this.mLoadingIncludeSelectedVars);
        this.mCentroidsIncludeButtonGroup = new SpssButtonGroup();
        this.mCentroidsIncludeButtonGroup.add(this.mIncludeCentroidsIncludeAllVars);
        this.mCentroidsIncludeButtonGroup.add(this.mIncludeCentroidsIncludeSelectedVars);
        this.mDisplayCompLoadings.addItemListener(this);
        this.mIncludeCentroids.addItemListener(this);
        this.mLoadingIncludeAllVars.addItemListener(this);
        this.mLoadingIncludeSelectedVars.addItemListener(this);
        this.mIncludeCentroidsIncludeAllVars.addItemListener(this);
        this.mIncludeCentroidsIncludeSelectedVars.addItemListener(this);
        this.mLoadingAvailableVars.setCellRenderer(new SimpleListCellRenderer());
        this.mLoadingSelectedVars.setCellRenderer(new SimpleListCellRenderer());
        this.mIncludeCentroidsAvailableVars.setCellRenderer(new SimpleListCellRenderer());
        this.mIncludeCentroidsSelectedVars.setCellRenderer(new SimpleListCellRenderer());
        this.mLoadingArrow.registerVariableList(this.mLoadingAvailableVars, SpssArrowButton.ButtonOrientation.right);
        this.mLoadingArrow.registerVariableList(this.mLoadingSelectedVars, SpssArrowButton.ButtonOrientation.left);
        this.mIncludeCentroidsArrow.registerVariableList(this.mIncludeCentroidsAvailableVars, SpssArrowButton.ButtonOrientation.right);
        this.mIncludeCentroidsArrow.registerVariableList(this.mIncludeCentroidsSelectedVars, SpssArrowButton.ButtonOrientation.left);
        this.mVarianceCheck.setSelected(false);
        this.mDisplayCompLoadings.setSelected(true);
        this.mLoadingIncludeAllVars.setSelected(true);
        this.mIncludeCentroidsIncludeAllVars.setSelected(true);
    }

    private void setTabTraversal() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mVarianceCheck);
        vector.add(this.mDisplayCompLoadings);
        vector.add(this.mLoadingIncludeButtonGroup);
        vector.add(this.mLoadingAvailableVars);
        vector.add(this.mLoadingArrow);
        vector.add(this.mLoadingSelectedVars);
        vector.add(this.mIncludeCentroids);
        vector.add(this.mCentroidsIncludeButtonGroup);
        vector.add(this.mIncludeCentroidsAvailableVars);
        vector.add(this.mIncludeCentroidsArrow);
        vector.add(this.mIncludeCentroidsSelected);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    private void initVars() {
        this.mVarianceCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_CATPCA_LOAD_VARIANCE_ACC_FOR"));
        this.mDisplayCompLoadings = new JCheckBox(new ToggleButtonAction(this, DISP_COMP_LOADINGS));
        this.mIncludeCentroids = new JCheckBox(new ToggleButtonAction(this, INCLUDE_CENTROIDS));
        this.mLoadingAvailableVars = new SrcVariableList();
        this.mLoadingSelectedVars = new TargetVariableList();
        this.mLoadingArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mIncludeCentroidsAvailableVars = new SrcVariableList();
        this.mIncludeCentroidsSelectedVars = new TargetVariableList();
        this.mIncludeCentroidsArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mLoadingAvailableVarsScrollPane = new JScrollPane(this.mLoadingAvailableVars);
        this.mLoadingSelectedVarsScrollPane = new JScrollPane(this.mLoadingSelectedVars);
        this.mCelenoidAvailableVarsScrollPane = new JScrollPane(this.mIncludeCentroidsAvailableVars);
        this.mCelenoidSelectedVarsScrollPane = new JScrollPane(this.mIncludeCentroidsSelectedVars);
        this.mLoadingPanel = new JPanel(new GridBagLayout());
        this.mLoadingPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CATPCA_LOAD_LOADING_VARS")));
        this.mLoadingInclude = new JLabel(this.getResString("IDS_CATPCA_LOAD_INCLUDE_COLON"));
        this.mLoadingIncludeAllVars = new JRadioButton(new ToggleButtonAction(this, LOADING_ALL_VARS));
        this.mLoadingIncludeSelectedVars = new JRadioButton(new ToggleButtonAction(this, LOADING_SELECTED_VARS));
        this.mLoadingAvailable = this.createLabelFromKeyForVarlist(LOADING_VARS_AVAILABLE, this.mLoadingAvailableVars);
        this.mLoadingSelected = this.createLabelFromKeyForVarlist(LOADING_VARS_SELECTED, this.mLoadingSelectedVars);
        this.mIncludeCentroidsPanel = new JPanel(new GridBagLayout());
        this.mIncludeCentroidsPanel.setBorder(BorderFactory.createTitledBorder(" "));
        this.mIncludeCentroidsInclude = new JLabel(this.getResString("IDS_CATPCA_LOAD_CENTR_INCLUDE"));
        this.mIncludeCentroidsIncludeAllVars = new JRadioButton(new ToggleButtonAction(this, INCLUDE_CENTR_ALL_VARS));
        this.mIncludeCentroidsIncludeSelectedVars = new JRadioButton(new ToggleButtonAction(this, INCLUDE_CENTR_SELECTED_VARS));
        this.mIncludeCentroidsAvailable = this.createLabelFromKeyForVarlist(INCLUDE_CENTR_AVAILABLE, this.mIncludeCentroidsAvailableVars);
        this.mIncludeCentroidsSelected = this.createLabelFromKeyForVarlist(INCLUDE_CENTR_SELECTED, this.mIncludeCentroidsSelectedVars);
    }

    private JLabel createLabelFromKeyForVarlist(String string, VariableList variableList) {
        variableList.setIdentifier(string);
        JLabel jLabel = DialogUtil.createLabel(this.mParentDlg, string);
        jLabel.setLabelFor(variableList);
        return jLabel;
    }

    private void setupViewPanel() {
        JPanel jPanel = this.getViewPanel();
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight());
        this.mLoadingAvailableVarsScrollPane.setHorizontalScrollBarPolicy(30);
        this.mLoadingAvailableVarsScrollPane.setVerticalScrollBarPolicy(20);
        this.mLoadingAvailableVarsScrollPane.setPreferredSize(dimension);
        this.mLoadingSelectedVarsScrollPane.setHorizontalScrollBarPolicy(30);
        this.mLoadingSelectedVarsScrollPane.setVerticalScrollBarPolicy(20);
        this.mLoadingSelectedVarsScrollPane.setPreferredSize(dimension);
        dimension = new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight() / 2);
        this.mCelenoidAvailableVarsScrollPane.setHorizontalScrollBarPolicy(30);
        this.mCelenoidAvailableVarsScrollPane.setVerticalScrollBarPolicy(20);
        this.mCelenoidAvailableVarsScrollPane.setPreferredSize(dimension);
        this.mCelenoidSelectedVarsScrollPane.setHorizontalScrollBarPolicy(30);
        this.mCelenoidSelectedVarsScrollPane.setVerticalScrollBarPolicy(20);
        this.mCelenoidSelectedVarsScrollPane.setPreferredSize(dimension);
        this.mLoadingPanel.setOpaque(false);
        this.mIncludeCentroidsPanel.setOpaque(false);
        this.mIncludeCentroids.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 10;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n2, insets.left, insets.bottom, insets.right);
        Insets insets3 = new Insets(insets.top, n2, insets.bottom, insets.right);
        Insets insets4 = new Insets(insets.top, insets.left, insets.bottom, n2);
        Insets insets5 = new Insets(insets.left, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mVarianceCheck, gridBagConstraints, 0, 0, 4, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayCompLoadings, gridBagConstraints, 0, 1, 4, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mLoadingPanel, gridBagConstraints, 0, 2, 4, 6, n, null);
        gridBagConstraints.fill = 0;
        n = 21;
        DialogUtil.addUsingGBL(jPanel, this.mIncludeCentroids, gridBagConstraints, 0, 8, 4, 1, n, insets);
        gridBagConstraints.fill = 1;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mIncludeCentroidsPanel, gridBagConstraints, 0, 8, 4, 6, n, insets5);
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 2, 4, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 7, 4, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 13, 4, 1, n, insets2);
        n = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mLoadingInclude, gridBagConstraints, 0, 4, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mLoadingIncludeAllVars, gridBagConstraints, 0, 5, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mLoadingIncludeSelectedVars, gridBagConstraints, 0, 6, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeCentroidsInclude, gridBagConstraints, 0, 10, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeCentroidsIncludeAllVars, gridBagConstraints, 0, 11, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeCentroidsIncludeSelectedVars, gridBagConstraints, 0, 12, 1, 1, n, insets3);
        n = 21;
        DialogUtil.addUsingGBL(jPanel, this.mLoadingAvailable, gridBagConstraints, 1, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mLoadingSelected, gridBagConstraints, 3, 3, 1, 1, n, insets4);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeCentroidsAvailable, gridBagConstraints, 1, 9, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeCentroidsSelected, gridBagConstraints, 3, 9, 1, 1, n, insets4);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mLoadingAvailableVarsScrollPane, gridBagConstraints, 1, 4, 1, 3, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mLoadingSelectedVarsScrollPane, gridBagConstraints, 3, 4, 1, 3, n, insets4);
        DialogUtil.addUsingGBL(jPanel, this.mCelenoidAvailableVarsScrollPane, gridBagConstraints, 1, 10, 1, 3, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCelenoidSelectedVarsScrollPane, gridBagConstraints, 3, 10, 1, 3, n, insets4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 10;
        insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mLoadingArrow, gridBagConstraints, 2, 4, 1, 3, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeCentroidsArrow, gridBagConstraints, 2, 10, 1, 3, n, insets);
    }

    private void updatePanels() {
        boolean bl = this.mDisplayCompLoadings.isSelected();
        this.enableLoadingPanel(bl);
        boolean bl2 = this.mIncludeCentroids.isEnabled() && this.mIncludeCentroids.isSelected();
        this.enableIncludeCentroidsPanel(bl && bl2);
    }

    private void enableLoadingPanel(boolean bl) {
        this.mLoadingPanel.setEnabled(bl);
        this.mLoadingInclude.setEnabled(bl);
        this.mLoadingIncludeAllVars.setEnabled(bl);
        this.mLoadingIncludeSelectedVars.setEnabled(bl);
        this.mIncludeCentroids.setEnabled(bl);
        this.enableLoadingLists(bl && this.mLoadingIncludeSelectedVars.isSelected());
    }

    private void enableIncludeCentroidsPanel(boolean bl) {
        this.mIncludeCentroidsPanel.setEnabled(bl);
        this.mIncludeCentroidsInclude.setEnabled(bl);
        this.mIncludeCentroidsIncludeAllVars.setEnabled(bl);
        this.mIncludeCentroidsIncludeSelectedVars.setEnabled(bl);
        this.enableIncludeCentroidsLists(bl && this.mIncludeCentroidsIncludeSelectedVars.isSelected());
    }

    private void enableLoadingLists(boolean bl) {
        this.mLoadingAvailable.setEnabled(bl);
        this.mLoadingAvailableVars.setEnabled(bl);
        this.mLoadingSelected.setEnabled(bl);
        this.mLoadingSelectedVars.setEnabled(bl);
        this.mLoadingArrow.setEnabled(bl);
        if (this.mLoadingAvailableVarsScrollPane.getVerticalScrollBar() != null) {
            this.mLoadingAvailableVarsScrollPane.getVerticalScrollBar().setEnabled(bl);
            this.mLoadingAvailableVarsScrollPane.setWheelScrollingEnabled(bl);
        }
        if (this.mLoadingSelectedVarsScrollPane.getVerticalScrollBar() != null) {
            this.mLoadingSelectedVarsScrollPane.getVerticalScrollBar().setEnabled(bl);
            this.mLoadingSelectedVarsScrollPane.setWheelScrollingEnabled(bl);
        }
    }

    private void enableIncludeCentroidsLists(boolean bl) {
        this.mIncludeCentroidsAvailable.setEnabled(bl);
        this.mIncludeCentroidsAvailableVars.setEnabled(bl);
        this.mIncludeCentroidsSelected.setEnabled(bl);
        this.mIncludeCentroidsSelectedVars.setEnabled(bl);
        this.mIncludeCentroidsArrow.setEnabled(bl);
        if (this.mCelenoidAvailableVarsScrollPane.getVerticalScrollBar() != null) {
            this.mCelenoidAvailableVarsScrollPane.getVerticalScrollBar().setEnabled(bl);
            this.mCelenoidAvailableVarsScrollPane.setWheelScrollingEnabled(bl);
        }
        if (this.mCelenoidSelectedVarsScrollPane.getVerticalScrollBar() != null) {
            this.mCelenoidSelectedVarsScrollPane.getVerticalScrollBar().setEnabled(bl);
            this.mCelenoidSelectedVarsScrollPane.setWheelScrollingEnabled(bl);
        }
    }
}

