/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.catpca;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.BaseDiscretizationSubDlg;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.CommonOneSetMainDlg;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.catpca.CatPrincipalComponentsDlg;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.catpca.DiscListModel;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.catpca.DiscVarFormatter;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.Document;

public class Discretization
extends BaseDiscretizationSubDlg {
    static String EQUAL_INTERVAL_VALUE = "IDS_CATPCA_DISC_INTERVAL_VALUE";
    static final String VARIABLES = "IDS_CATPCA_DISC_VARIABLES";
    private static final int NUMBER_OF_CATEGORIES = 7;
    private DiscVarFormatter mVarListFormatter;

    public Discretization(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cpca_discretize";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = "";
        String string2 = this.getResString("IDS_OS_GROUPING_DISPLAY_TEXT");
        boolean bl = false;
        if (this.mNumberOfCategories.isEnabled() && this.mNumberOfCategories.isSelected()) {
            if (this.isInvalidNumberOfCategoriesRange(this.mNumberOfCategoriesEdit.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CATPCA_OPTS_VAL_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
                this.mNumberOfCategoriesEdit.selectAll();
                this.mNumberOfCategoriesEdit.requestFocus();
                bl = true;
            } else {
                string = this.mDistributionNormal.isSelected() ? string2 + " " + this.getResString("IDS_OS_NORMAL_DISPLAY_TEXT") + " " + this.mNumberOfCategoriesEdit.getText() : string2 + " " + this.getResString("IDS_OS_UNIFORM_DISPLAY_TEXT") + " " + this.mNumberOfCategoriesEdit.getText();
            }
        } else if (this.mEqualIntervals.isEnabled() && this.mEqualIntervals.isSelected()) {
            if (new Float(this.mEqualIntervalsEdit.getText()).floatValue() == 0.0f) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CATPCA_OPTS_VAL_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
                this.mEqualIntervalsEdit.selectAll();
                this.mEqualIntervalsEdit.requestFocus();
                bl = true;
            } else {
                string = string2 + " " + this.mEqualIntervalsEdit.getText();
            }
        } else {
            string = (String)this.mMethodComboBox.getSelectedItem();
        }
        if (!bl) {
            int[] nArray;
            for (int n : nArray = this.mVariablesList.getSelectedIndices()) {
                ((DiscListModel)this.mVariablesList.getModel()).setElementPropertyAt(n, string);
            }
        }
        this.enableContinue(true);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        ISpssVariable iSpssVariable;
        super.loadState(dialogDataModel);
        this.mVariablesList.getModel().removeAll();
        this.mVarListFormatter.setUpdateNameMap(true);
        Map<Integer, ISpssVariable> map = ((CatPrincipalComponentsDlg)this.mParentDlg).getAnalysisAndSuppleVars();
        HashMap<Integer, Object> hashMap = dialogDataModel.getMap(VARIABLES);
        this.mVarListFormatter.setVarMap(hashMap);
        VarListModel varListModel = this.mVariablesList.getModel();
        int n = varListModel.getSize();
        for (int i = 0; i < n; ++i) {
            iSpssVariable = varListModel.getElementAt(i);
            int n2 = iSpssVariable.getId().asInt();
            if (map.containsKey(n2)) {
                map.remove(n2);
                continue;
            }
            varListModel.removeElement(iSpssVariable);
            if (hashMap != null && hashMap.containsKey(n2)) {
                hashMap.remove(n2);
            }
            --i;
            --n;
        }
        if (map.size() > 0) {
            for (Integer n3 : map.keySet()) {
                iSpssVariable = map.get(n3);
                varListModel.addElement(iSpssVariable);
            }
        }
        this.mNumberOfCategories.setSelected(true);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        dialogDataModel.putMap(VARIABLES, this.mVarListFormatter.getVarMapForSerialization());
        return bl;
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        CommonOneSetMainDlg.setMnemonicOnContinueButton(jPanel, this.getDlgAccessKey("IDK_CATPCA_DISC_CONTINUE_KEY"));
        return jPanel;
    }

    @Override
    protected void initVars() {
        this.mMethodComboBox = new JComboBox<String>(new String[]{this.getResString("IDS_CATPCA_METHOD_UNSPECIFIED"), this.getResString("IDS_CATPCA_METHOD_GROUPING"), this.getResString("IDS_CATPCA_METHOD_RANKING"), this.getResString("IDS_CATPCA_METHOD_MULTIPLYING")});
        this.mDistribution = new JLabel(this.getResString("IDS_CATPCA_DISC_DISTRIBUTION_COLON"));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_CATPCA_DISC_NUMBER_OF_CAT");
        this.mNumberOfCategories = new JRadioButton(toggleButtonAction);
        this.mNumberOfCategoriesEdit = new IntTextField(2, 35, true);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_CATPCA_DISTRIBUTION_NORMAL");
        this.mDistributionNormal = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_CATPCA_DISTRIBUTION_UNIFORM");
        this.mDistributionUniform = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_CATPCA_DISC_EQUAL_INERVALS_COLON");
        this.mEqualIntervals = new JRadioButton(toggleButtonAction);
        this.mEqualIntervalsEdit = new ContextEnabledTextField();
        this.mEqualIntervalsEdit.setAction((Action)new TextFieldAction(this, EQUAL_INTERVAL_VALUE));
        this.mEqualIntervalsEdit.setDocument((Document)new FixedLengthNumericDocument(8, true, true));
        this.mEqualIntervalsEdit.getDocument().addDocumentListener(this);
        this.mVariablesList = new TargetVariableList();
        this.mVarListFormatter = new DiscVarFormatter(this.mVariablesList, this);
        this.mChangeButton = DialogUtil.createButton(this, "IDS_CATPCA_DISC_CHANGE", this);
        this.mGroupingPanel = new JPanel(new GridBagLayout());
        this.mGroupingPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CATPCA_DISC_GROUPING_TITLE")));
        this.mVariablesLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_CATPCA_DISC_VARIABLES_COLON");
        this.mVariablesLabel.setLabelFor(this.mVariablesList);
        this.mMethodLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_CATPCA_DISC_METHOD_COLON");
        this.mMethodLabel.setLabelFor(this.mMethodComboBox);
        this.mMethodComboBox.addItemListener(this);
        this.mNumberOfCategories.addItemListener(this);
        this.mEqualIntervals.addItemListener(this);
        this.mNumberOfCategoriesEdit.getDocument().addDocumentListener(this);
        this.mVariablesList.addListSelectionListener(this);
        this.mVariablesList.setIdentifier(VARIABLES);
        this.mVarListFormatter.setUpdateNameMap(false);
    }

    @Override
    protected void setDefaults() {
        this.mNumberOfCategoriesEdit.setColumns(4);
        this.mEqualIntervalsEdit.setColumns(4);
        DiscListModel discListModel = new DiscListModel(this, this.mVarListFormatter);
        this.mVariablesList.setModel(discListModel);
        this.mVariablesList.setCellRenderer(new CustomVarListCellRenderer(this.mVarListFormatter));
        this.mMethodComboBox.setSelectedIndex(1);
        this.mNumberOfCategories.setSelected(true);
        this.mDistributionNormal.setSelected(true);
        this.enableContinue(false);
        this.mChangeButton.setEnabled(false);
        this.mNumberOfCategoriesEdit.setText(String.valueOf(7));
    }

    private boolean isInvalidNumberOfCategoriesRange(String string) {
        Integer n = new Integer(string);
        return n < 2 || n > 35;
    }
}

