/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.catpca;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.CommonOneSetMainDlg;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.catpca.CatPrincipalComponentsDlg;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.catpca.OptimalScalingLevel;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.catpca.VariableScaleDecoration;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DefineScaleAndWeight
extends BaseSubDialog
implements DocumentListener,
ItemListener {
    static final String KEY_WEIGHT = "IDS_CATPCA_VARIABLE_WEIGHT";
    static final String KEY_DEGREE = "IDS_CATPCA_SPLINE_DEGREE";
    static final String KEY_INTERIOR_KNOTS = "IDS_CATPCA_SPLINE_INTERIOR_KNOTS";
    private static final int DEFAULT_WEIGHT = 1;
    private static final int DEFAULT_DEGREE = 2;
    private static final int DEFAULT_INTERIOR_KNOTS = 2;
    private IntTextField mWeightEdit;
    private IntTextField mDegreeEdit;
    private IntTextField mInteriorKnotsEdit;
    private JLabel mDegree;
    private JLabel mInteriorKnots;
    private JRadioButton mSplineOrdinalCheck;
    private JRadioButton mSplineNominalCheck;
    private JRadioButton mMultipleNominalCheck;
    private JRadioButton mOrdinalCheck;
    private JRadioButton mNominalCheck;
    private JRadioButton mNumericCheck;
    private VariableScaleDecoration mOldDecoration;
    private SpssButtonGroup mScaleButtonGroup;

    public DefineScaleAndWeight(BaseProcedureDialog baseProcedureDialog, String string, boolean bl, VariableScaleDecoration variableScaleDecoration) {
        super(baseProcedureDialog, string, bl);
        this.mOldDecoration = variableScaleDecoration;
        this.pack();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cpca_weight";
    }

    @Override
    public boolean continuePressed() {
        int n = Integer.parseInt(this.mWeightEdit.getText());
        int n2 = 0;
        int n3 = 0;
        OptimalScalingLevel optimalScalingLevel = OptimalScalingLevel.eSPLINE_ORDINAL;
        if (this.mSplineOrdinalCheck.isSelected()) {
            optimalScalingLevel = OptimalScalingLevel.eSPLINE_ORDINAL;
            n2 = Integer.parseInt(this.mDegreeEdit.getText());
            n3 = Integer.parseInt(this.mInteriorKnotsEdit.getText());
        } else if (this.mSplineNominalCheck.isSelected()) {
            optimalScalingLevel = OptimalScalingLevel.eSPLINE_NOMINAL;
            n2 = Integer.parseInt(this.mDegreeEdit.getText());
            n3 = Integer.parseInt(this.mInteriorKnotsEdit.getText());
        } else if (this.mMultipleNominalCheck.isSelected()) {
            optimalScalingLevel = OptimalScalingLevel.eMULTIPLE_NOMINAL;
        } else if (this.mOrdinalCheck.isSelected()) {
            optimalScalingLevel = OptimalScalingLevel.eORDINAL;
        } else if (this.mNominalCheck.isSelected()) {
            optimalScalingLevel = OptimalScalingLevel.eNOMINAL;
        } else if (this.mNumericCheck.isSelected()) {
            optimalScalingLevel = OptimalScalingLevel.eNUMERIC;
        }
        ((CatPrincipalComponentsDlg)((Object)this.getParent())).defineScaleAndWeight(n, optimalScalingLevel, n2, n3);
        return super.continuePressed();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableSplineComponents(this.mSplineNominalCheck.isSelected() || this.mSplineOrdinalCheck.isSelected());
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (this.mOldDecoration != null) {
            this.mWeightEdit.setText(String.valueOf(this.mOldDecoration.getWeight()));
            if (this.mOldDecoration.getOptimalScalingLevel() == OptimalScalingLevel.eSPLINE_ORDINAL) {
                this.mSplineOrdinalCheck.setSelected(true);
                this.mDegreeEdit.setText(String.valueOf(this.mOldDecoration.getDegree()));
                this.mInteriorKnotsEdit.setText(String.valueOf(this.mOldDecoration.getInteriorKnots()));
            } else if (this.mOldDecoration.getOptimalScalingLevel() == OptimalScalingLevel.eSPLINE_NOMINAL) {
                this.mSplineNominalCheck.setSelected(true);
                this.mDegreeEdit.setText(String.valueOf(this.mOldDecoration.getDegree()));
                this.mInteriorKnotsEdit.setText(String.valueOf(this.mOldDecoration.getInteriorKnots()));
            } else if (this.mOldDecoration.getOptimalScalingLevel() == OptimalScalingLevel.eMULTIPLE_NOMINAL) {
                this.mMultipleNominalCheck.setSelected(true);
            } else if (this.mOldDecoration.getOptimalScalingLevel() == OptimalScalingLevel.eORDINAL) {
                this.mOrdinalCheck.setSelected(true);
            } else if (this.mOldDecoration.getOptimalScalingLevel() == OptimalScalingLevel.eNOMINAL) {
                this.mNominalCheck.setSelected(true);
            } else if (this.mOldDecoration.getOptimalScalingLevel() == OptimalScalingLevel.eNUMERIC) {
                this.mNumericCheck.setSelected(true);
            }
        } else {
            this.setDefaults();
        }
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        CommonOneSetMainDlg.setMnemonicOnContinueButton(jPanel, this.getDlgAccessKey("IDK_CATPCA_CONTINUE_KEY"));
        return jPanel;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JLabel jLabel = this.createLabelWithKey(KEY_WEIGHT, (Component)this.mWeightEdit);
        JPanel jPanel2 = this.setupOptimalScalingLevelPanel();
        JPanel jPanel3 = this.setupSplinePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 21;
        Insets insets = DialogUtil.getStandardDialogInsets();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mWeightEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 2, 1, n, insets);
        this.updateContinueButton();
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mWeightEdit);
        vector.add(this.mScaleButtonGroup);
        vector.add(this.mDegreeEdit);
        vector.add(this.mInteriorKnotsEdit);
        CommonOneSetMainDlg.fillVectorWithPanelComponents(this.mCmdButtonPanel, vector);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        this.mWeightEdit = new IntTextField(1, 99999999, true);
        this.mDegreeEdit = new IntTextField(1, 99999999, true);
        this.mInteriorKnotsEdit = new IntTextField(1, 99999999, true);
        this.mDegree = this.createLabelWithKey(KEY_DEGREE, (Component)this.mDegreeEdit);
        this.mInteriorKnots = this.createLabelWithKey(KEY_INTERIOR_KNOTS, (Component)this.mInteriorKnotsEdit);
        this.mWeightEdit.setAction((Action)new TextFieldAction(this, KEY_WEIGHT));
        this.mDegreeEdit.setAction((Action)new TextFieldAction(this, KEY_DEGREE));
        this.mInteriorKnotsEdit.setAction((Action)new TextFieldAction(this, KEY_INTERIOR_KNOTS));
        this.mWeightEdit.getDocument().addDocumentListener(this);
        this.mDegreeEdit.getDocument().addDocumentListener(this);
        this.mInteriorKnotsEdit.getDocument().addDocumentListener(this);
        this.mSplineOrdinalCheck = this.createRadioButtonFromKey("IDS_CATPCA_SCALING_LEVEL_SPLINE_ORDINAL");
        this.mSplineNominalCheck = this.createRadioButtonFromKey("IDS_CATPCA_SCALING_LEVEL_SPLINE_NOMINAL");
        this.mMultipleNominalCheck = this.createRadioButtonFromKey("IDS_CATPCA_SCALING_LEVEL_MULTIPLE_NOMINAL");
        this.mOrdinalCheck = this.createRadioButtonFromKey("IDS_CATPCA_SCALING_LEVEL_ORDINAL");
        this.mNominalCheck = this.createRadioButtonFromKey("IDS_CATPCA_SCALING_LEVEL_NOMINAL");
        this.mNumericCheck = this.createRadioButtonFromKey("IDS_CATPCA_SCALING_LEVEL_NUMERIC");
        this.mSplineOrdinalCheck.addItemListener(this);
        this.mSplineNominalCheck.addItemListener(this);
        this.mMultipleNominalCheck.addItemListener(this);
        this.mOrdinalCheck.addItemListener(this);
        this.mNominalCheck.addItemListener(this);
        this.mNumericCheck.addItemListener(this);
    }

    private void setDefaults() {
        this.mWeightEdit.setColumns(4);
        this.mDegreeEdit.setColumns(4);
        this.mInteriorKnotsEdit.setColumns(4);
        this.mSplineOrdinalCheck.setSelected(true);
        this.mWeightEdit.setText(String.valueOf(1));
        this.mDegreeEdit.setText(String.valueOf(2));
        this.mInteriorKnotsEdit.setText(String.valueOf(2));
    }

    private JRadioButton createRadioButtonFromKey(String string) {
        JRadioButton jRadioButton = new JRadioButton(this.getResString(string));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            string = string.replaceFirst("IDS_", "IDK_");
            jRadioButton.setMnemonic(this.getDlgAccessKey(string + "_KEY"));
        }
        return jRadioButton;
    }

    private JLabel createLabelWithKey(String string, Component component) {
        JLabel jLabel = DialogUtil.createLabel(this.mParentDlg, string);
        jLabel.setLabelFor(component);
        return jLabel;
    }

    private void updateContinueButton() {
        if (this.mWeightEdit.getText().length() <= 0) {
            this.enableContinue(false);
        } else if (this.mSplineNominalCheck.isSelected() || this.mSplineOrdinalCheck.isSelected()) {
            this.enableContinue(this.mDegreeEdit.getText().length() > 0 && this.mInteriorKnotsEdit.getText().length() > 0);
        } else {
            this.enableContinue(true);
        }
    }

    private JPanel setupOptimalScalingLevelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CATPCA_SCALING_LEVEL_TITLE")));
        this.mScaleButtonGroup = new SpssButtonGroup();
        this.mScaleButtonGroup.add(this.mSplineOrdinalCheck);
        this.mScaleButtonGroup.add(this.mSplineNominalCheck);
        this.mScaleButtonGroup.add(this.mMultipleNominalCheck);
        this.mScaleButtonGroup.add(this.mOrdinalCheck);
        this.mScaleButtonGroup.add(this.mNominalCheck);
        this.mScaleButtonGroup.add(this.mNumericCheck);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSplineOrdinalCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSplineNominalCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mMultipleNominalCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mOrdinalCheck, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mNominalCheck, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mNumericCheck, gridBagConstraints, 1, 2, 1, 1, n, insets);
        return jPanel;
    }

    private void enableSplineComponents(boolean bl) {
        this.mDegree.setEnabled(bl);
        this.mInteriorKnots.setEnabled(bl);
        this.mDegreeEdit.setEnabled(bl);
        this.mInteriorKnotsEdit.setEnabled(bl);
        this.mDegreeEdit.setOpaque(bl);
        this.mInteriorKnotsEdit.setOpaque(bl);
    }

    private JPanel setupSplinePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CATPCA_SPLINE_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(insets.top, n2, insets.bottom, insets.right);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDegree, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDegreeEdit, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        insets2.left = n2 * 2;
        DialogUtil.addUsingGBL(jPanel, this.mInteriorKnots, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        insets2.left = n2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mInteriorKnotsEdit, gridBagConstraints, 3, 0, 1, 1, n, insets2);
        return jPanel;
    }
}

