/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.catpca;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.catpca.CatPrincipalComponentsDlg;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Bootstrap
extends BaseSubDialog
implements DocumentListener,
ItemListener,
FocusListener {
    protected static final int LOADING_PLOT = 0;
    protected static final int OBJECT_PLOT = 1;
    protected static final int CATEGORY_PLOT = 2;
    private JCheckBox mPerformBTCheck;
    private JRadioButton mBalancedRadio;
    private JRadioButton mUnbalancedRadio;
    private SpssButtonGroup mRadioGroup1;
    private JLabel mNumberSamplesLabel;
    private JLabel mConfLevelLabel;
    private IntTextField mNumberSamplesIntField;
    private FloatTextField mConfLevelIntField;
    private JRadioButton mProcrustesRadio;
    private JRadioButton mReflectionRadio;
    private SpssButtonGroup mRadioGroup2;
    private JLabel[] mThresholdAreaLabels;
    private JLabel[] mOperatorLabels;
    private JLabel[] mValueLabels;
    private JComboBox[] mThresholdAreaCombos;
    private JComboBox[] mOperatorCombos;
    private FloatTextField[] mValueFloatFields;
    private JLabel mNumberPointsLabel;
    private FloatTextField mNumberPointsIntField;
    private float[][] mPlotValues;

    public Bootstrap(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_CATPCA_BOOTSTRAP_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cpca_bootstrap";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        for (int i = 0; i < 3; ++i) {
            if (object != this.mValueFloatFields[i]) continue;
            this.updatePlotValue(i);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinue(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinue(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinue(documentEvent);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mPerformBTCheck) {
            this.onPerformBootstrapping();
        } else {
            for (int i = 0; i < this.mThresholdAreaCombos.length; ++i) {
                if (itemEvent.getSource() != this.mThresholdAreaCombos[i]) continue;
                int n = this.mThresholdAreaCombos[i].getSelectedIndex();
                this.mValueFloatFields[i].setText(String.valueOf(this.mPlotValues[i][n]));
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupTopPanel();
        JPanel jPanel3 = this.setupMethodPanel();
        JPanel jPanel4 = this.setupEllipsesPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n, 0, 0, 0);
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mPerformBTCheck, gridBagConstraints, 0, 0, 1, 1, n2, null);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        this.setTabTraversal();
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        for (int i = 0; i <= 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                String string = dialogDataModel.getString("IDS_CATPCA_BOOTSTRAP_THRESHOLD_AREA" + i + i + j);
                if (string == null) continue;
                this.mPlotValues[i][j] = Float.parseFloat(string);
            }
        }
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        for (int i = 0; i <= 2; ++i) {
            dialogDataModel.putBoolean("IDS_CATPCA_BOOTSTRAP_THRESHOLD_AREA" + i + "_STATUS" + i, this.mThresholdAreaCombos[i].isEnabled());
            dialogDataModel.putInteger("IDS_CATPCA_BOOTSTRAP_THRESHOLD_AREA" + i + "_IDX" + i, this.mThresholdAreaCombos[i].getSelectedIndex());
            for (int j = 0; j < 2; ++j) {
                dialogDataModel.putString("IDS_CATPCA_BOOTSTRAP_THRESHOLD_AREA" + i + i + j, String.valueOf(this.mPlotValues[i][j]));
            }
        }
        dialogDataModel.putBoolean("IDS_CATPCA_BOOTSTRAP_NUMBER_POINTS_STATUS", this.mNumberPointsIntField.isEnabled());
        return super.saveState(dialogDataModel);
    }

    private void updateContinue(DocumentEvent documentEvent) {
        for (int i = 0; i <= 2; ++i) {
            if (!this.mValueFloatFields[i].isEnabled() || this.mValueFloatFields[i].getText().length() != 0) continue;
            this.enableContinue(false);
            return;
        }
        if (this.mNumberPointsIntField.isEnabled() && this.mNumberPointsIntField.getText().length() == 0) {
            this.enableContinue(false);
        } else if (this.mConfLevelIntField.isEnabled() && this.mConfLevelIntField.getText().length() == 0) {
            this.enableContinue(false);
        } else if (this.mNumberSamplesIntField.isEnabled() && this.mNumberSamplesIntField.getText().length() == 0) {
            this.enableContinue(false);
        } else {
            this.enableContinue(true);
        }
    }

    private void setTabTraversal() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mPerformBTCheck);
        vector.add(this.mRadioGroup1);
        vector.add(this.mNumberSamplesIntField);
        vector.add(this.mConfLevelIntField);
        vector.add(this.mRadioGroup2);
        for (int i = 0; i <= 2; ++i) {
            vector.add(this.mThresholdAreaCombos[i]);
            vector.add(this.mOperatorCombos[i]);
            vector.add(this.mValueFloatFields[i]);
        }
        vector.add(this.mNumberPointsIntField);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    private JPanel setupTopPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n, n, 0);
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mBalancedRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mUnbalancedRadio, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mNumberSamplesLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumberSamplesIntField, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mConfLevelLabel, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConfLevelIntField, gridBagConstraints, 1, 2, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupMethodPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_CATPCA_BOOTSTRAP_METHOD_TITLE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n, n, 0);
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mProcrustesRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mReflectionRadio, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupEllipsesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CATPCA_BOOTSTRAP_ELLIPSES_TITLE")));
        JPanel jPanel2 = this.setupEllipsesSubPanel("IDS_CATPCA_BOOTSTRAP_LOADING_PLOT_TITLE", 0);
        JPanel jPanel3 = this.setupEllipsesSubPanel("IDS_CATPCA_BOOTSTRAP_OBJECT_PLOT_TITLE", 1);
        JPanel jPanel4 = this.setupEllipsesSubPanel("IDS_CATPCA_BOOTSTRAP_CATEGORY_PLOT_TITLE", 2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n2, null);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 2, 1, n2, null);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 2, 1, n2, null);
        Insets insets = new Insets(n, n, n, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNumberPointsLabel, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(n, 2, n, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumberPointsIntField, gridBagConstraints, 1, 3, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupEllipsesSubPanel(String string, int n) {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString(string));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 2, 0);
        int n3 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mThresholdAreaLabels[n], gridBagConstraints, 0, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, this.mOperatorLabels[n], gridBagConstraints, 1, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, this.mValueLabels[n], gridBagConstraints, 2, 0, 1, 1, n3, insets);
        insets.set(0, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mThresholdAreaCombos[n], gridBagConstraints, 0, 1, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, this.mOperatorCombos[n], gridBagConstraints, 1, 1, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mValueFloatFields[n], gridBagConstraints, 2, 1, 1, 1, n3, insets);
        return jPanel;
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_CATPCA_BOOTSTRAP_PERFORM");
        this.mPerformBTCheck = new JCheckBox(toggleButtonAction);
        this.mPerformBTCheck.addItemListener(this);
        this.mRadioGroup1 = new SpssButtonGroup();
        toggleButtonAction = new ToggleButtonAction(this, "IDS_CATPCA_BOOTSTRAP_BALANCED");
        this.mBalancedRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_CATPCA_BOOTSTRAP_UNBALANCED");
        this.mUnbalancedRadio = new JRadioButton(toggleButtonAction);
        this.mRadioGroup1.add(this.mBalancedRadio);
        this.mRadioGroup1.add(this.mUnbalancedRadio);
        this.mNumberSamplesLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_CATPCA_BOOTSTRAP_NUMBER_SAMPLES");
        this.mNumberSamplesIntField = new IntTextField(true);
        this.mNumberSamplesIntField.setAction((Action)new TextFieldAction(this, "IDS_CATPCA_BOOTSTRAP_NUMBER_SAMPLES"));
        this.mNumberSamplesIntField.setColumns(8);
        this.mNumberSamplesIntField.getDocument().addDocumentListener(this);
        this.mNumberSamplesLabel.setLabelFor((Component)this.mNumberSamplesIntField);
        this.mConfLevelLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_CATPCA_BOOTSTRAP_CONF_LEVEL");
        this.mConfLevelIntField = new FloatTextField(0.0, 100.0, 2, true);
        this.mConfLevelIntField.setAction((Action)new TextFieldAction(this, "IDS_CATPCA_BOOTSTRAP_CONF_LEVEL"));
        this.mConfLevelIntField.setAllowMinMax(false, false);
        this.mConfLevelIntField.setColumns(8);
        this.mConfLevelIntField.getDocument().addDocumentListener(this);
        this.mConfLevelLabel.setLabelFor((Component)this.mConfLevelIntField);
        this.mRadioGroup2 = new SpssButtonGroup();
        toggleButtonAction = new ToggleButtonAction(this, "IDS_CATPCA_BOOTSTRAP_PROCRUSTES");
        this.mProcrustesRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_CATPCA_BOOTSTRAP_REFLECTION");
        this.mReflectionRadio = new JRadioButton(toggleButtonAction);
        this.mRadioGroup2.add(this.mProcrustesRadio);
        this.mRadioGroup2.add(this.mReflectionRadio);
        this.mThresholdAreaLabels = new JLabel[3];
        this.mOperatorLabels = new JLabel[3];
        this.mValueLabels = new JLabel[3];
        this.mThresholdAreaCombos = new JComboBox[3];
        this.mOperatorCombos = new JComboBox[3];
        this.mValueFloatFields = new FloatTextField[3];
        String[] stringArray = this.getResStringArray("IDS_CATPCA_BOOTSTRAP_THRESHOLD_OPTIONS");
        String[] stringArray2 = new String[]{">", "<"};
        for (int i = 0; i <= 2; ++i) {
            this.mThresholdAreaLabels[i] = DialogUtil.createLabel(this.mParentDlg, "IDS_CATPCA_BOOTSTRAP_THRESHOLD_AREA" + i);
            this.mOperatorLabels[i] = DialogUtil.createLabel(this.mParentDlg, "IDS_CATPCA_BOOTSTRAP_OPERATOR", i);
            this.mValueLabels[i] = DialogUtil.createLabel(this.mParentDlg, "IDS_CATPCA_BOOTSTRAP_VALUE", i);
            this.mThresholdAreaCombos[i] = new JComboBox<String>(stringArray);
            this.mThresholdAreaCombos[i].setAction(new ComboboxAction(this, "IDS_CATPCA_BOOTSTRAP_THRESHOLD_AREA" + i));
            this.mThresholdAreaCombos[i].addItemListener(this);
            this.mOperatorCombos[i] = new JComboBox<String>(stringArray2);
            this.mOperatorCombos[i].setAction(new ComboboxAction(this, "IDS_CATPCA_BOOTSTRAP_OPERATOR" + i));
            this.mValueFloatFields[i] = new FloatTextField(0.0, 100.0, 2, true);
            this.mValueFloatFields[i].setAction((Action)new TextFieldAction(this, "IDS_CATPCA_BOOTSTRAP_VALUE" + i));
            this.mValueFloatFields[i].getDocument().addDocumentListener(this);
            this.mValueFloatFields[i].addFocusListener((FocusListener)this);
            this.mValueLabels[i].setLabelFor((Component)this.mValueFloatFields[i]);
            this.mOperatorLabels[i].setLabelFor(this.mOperatorCombos[i]);
            this.mThresholdAreaLabels[i].setLabelFor(this.mThresholdAreaCombos[i]);
        }
        this.mNumberPointsLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_CATPCA_BOOTSTRAP_NUMBER_POINTS");
        TextFieldAction textFieldAction = new TextFieldAction(this, "IDS_CATPCA_BOOTSTRAP_NUMBER_POINTS");
        this.mNumberPointsIntField = new FloatTextField(4.0, 100.0, 2, true);
        this.mNumberPointsIntField.setAction((Action)textFieldAction);
        this.mNumberPointsIntField.setColumns(8);
        this.mNumberPointsIntField.getDocument().addDocumentListener(this);
        this.mNumberPointsLabel.setLabelFor((Component)this.mNumberPointsIntField);
        this.mPlotValues = new float[3][2];
    }

    private void setDefaults() {
        this.mPerformBTCheck.setSelected(false);
        this.mBalancedRadio.setSelected(true);
        this.mNumberSamplesIntField.setText("1000");
        this.mConfLevelIntField.setText("95");
        this.mProcrustesRadio.setSelected(true);
        this.mThresholdAreaCombos[0].setSelectedIndex(0);
        this.mThresholdAreaCombos[1].setSelectedIndex(1);
        this.mThresholdAreaCombos[2].setSelectedIndex(0);
        this.mValueFloatFields[0].setText("0");
        this.mValueFloatFields[1].setText("2");
        this.mValueFloatFields[2].setText("2");
        for (int i = 0; i < this.mPlotValues.length; ++i) {
            this.mPlotValues[i][0] = i < 1 ? 0.0f : 2.0f;
            this.mPlotValues[i][1] = 2.0f;
        }
        this.mNumberPointsIntField.setText("40");
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        boolean bl = dialogDataModel != null && dialogDataModel.containsBooleanKey("IDS_CATPCA_OPTS_ROTATION_NONE") ? dialogDataModel.getBoolean("IDS_CATPCA_OPTS_ROTATION_NONE") : true;
        this.mPerformBTCheck.setEnabled(bl);
        this.onPerformBootstrapping();
    }

    private void updatePlotValue(int n) {
        int n2 = this.mThresholdAreaCombos[n].getSelectedIndex();
        this.mPlotValues[n][n2] = Float.parseFloat(this.mValueFloatFields[n].getText());
    }

    private void onPerformBootstrapping() {
        boolean bl = this.mPerformBTCheck.isEnabled() && this.mPerformBTCheck.isSelected();
        this.mBalancedRadio.setEnabled(bl);
        this.mUnbalancedRadio.setEnabled(bl);
        this.mNumberSamplesLabel.setEnabled(bl);
        this.mConfLevelLabel.setEnabled(bl);
        this.mNumberSamplesIntField.setEnabled(bl);
        this.mConfLevelIntField.setEnabled(bl);
        this.mProcrustesRadio.setEnabled(bl);
        this.mReflectionRadio.setEnabled(bl);
        if (this.mParentDlg instanceof CatPrincipalComponentsDlg) {
            int n = ((CatPrincipalComponentsDlg)this.mParentDlg).getDimension();
            this.setEllipsesEnabled(bl && n == 2);
        }
    }

    private boolean checkPlotSetting(int n) {
        boolean bl = false;
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        if (n == 0) {
            bl = dialogDataModel != null && dialogDataModel.containsBooleanKey("IDS_CATPCA_LOAD_DISP_COMP_LOADINGS") ? dialogDataModel.getBoolean("IDS_CATPCA_LOAD_DISP_COMP_LOADINGS") : true;
        } else if (n == 1) {
            bl = dialogDataModel != null && dialogDataModel.containsBooleanKey("IDS_CATPCA_OBJ_OBJECT_POINTS") ? dialogDataModel.getBoolean("IDS_CATPCA_OBJ_OBJECT_POINTS") : true;
        } else if (n == 2) {
            ISpssVariable[] iSpssVariableArray = dialogDataModel != null ? dialogDataModel.getVarArray("IDS_CATPCA_CAT_CATEGORY_PLOTS_COLON") : null;
            bl = iSpssVariableArray != null && iSpssVariableArray.length > 0;
        }
        return bl;
    }

    private void setEllipsesEnabled(boolean bl) {
        for (int i = 0; i <= 2; ++i) {
            boolean bl2 = bl & this.checkPlotSetting(i);
            this.mThresholdAreaLabels[i].setEnabled(bl2);
            this.mThresholdAreaCombos[i].setEnabled(bl2);
            this.mOperatorLabels[i].setEnabled(bl2);
            this.mOperatorCombos[i].setEnabled(bl2);
            this.mValueLabels[i].setEnabled(bl2);
            this.mValueFloatFields[i].setEnabled(bl2);
        }
        this.mNumberPointsLabel.setEnabled(bl);
        this.mNumberPointsIntField.setEnabled(bl);
    }
}

