/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.res.MarketResearchResBundle;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FocusableLabel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class OptimalScalingGatingDlg
extends BaseGatingDialog
implements ItemListener {
    private JRadioButton mAllVarsMultiNominal;
    private JRadioButton mSomeVarsNotMultiNominal;
    private JRadioButton mMultipleSets;
    private JRadioButton mOneSet;
    private JLabel mMultiCorrespondenceAnaLabel;
    private JLabel mCatPrincipalCompsLabel;
    private JLabel mNonlinearCanCorrLabel;

    public OptimalScalingGatingDlg(JFrame jFrame) {
        super(jFrame, MarketResearchResBundle.getDefaultResourceBundleName(), MarketResearchResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_OPTIMAL_SCALING_TITLE"));
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    @Override
    public String getIActionKey() {
        return "analyze_data_reduction_opt_scaling";
    }

    @Override
    public String getNextProcDlgActionKey() {
        if (this.mMultipleSets.isSelected()) {
            return "analyze_data_reduction_opt_scaling_nonlinear_can";
        }
        if (this.mAllVarsMultiNominal.isSelected()) {
            return "analyze_data_reduction_opt_scaling_multi_corres";
        }
        return "analyze_data_reduction_opt_scaling_cat_principal";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_opts";
    }

    @Override
    public boolean continuePressed() {
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateSelection();
    }

    @Override
    protected void init() {
        super.init();
        this.renameContinueAction("IDS_DEFINE");
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mOneSet);
        spssButtonGroup.add(this.mMultipleSets);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mAllVarsMultiNominal);
        spssButtonGroup2.add(this.mSomeVarsNotMultiNominal);
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, insets.left, n2, insets.right);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.getOptimalScalingLevelPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.getNumberOfSetsOfVariablesPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.getSelectedAnalysisPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets2);
        Vector<Object> vector = new Vector<Object>();
        vector.add(spssButtonGroup2);
        vector.add(spssButtonGroup);
        vector.add(this.mMultiCorrespondenceAnaLabel);
        vector.add(this.mCatPrincipalCompsLabel);
        vector.add(this.mNonlinearCanCorrLabel);
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            vector.add(this.mHelpButton);
            vector.add(this.mCancelButton);
            vector.add(this.mDefineButton);
        } else {
            vector.add(this.mDefineButton);
            vector.add(this.mCancelButton);
            vector.add(this.mHelpButton);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        this.mOneSet = new JRadioButton(new ToggleButtonAction(this, "IDS_DROS_ONE_SET"));
        this.mMultipleSets = new JRadioButton(new ToggleButtonAction(this, "IDS_DROS_MULTIPLE_SETS"));
        this.mMultiCorrespondenceAnaLabel = new FocusableLabel(this.getResString("IDS_DROS_MUTLIPLE_CORRES_ANA"));
        this.mCatPrincipalCompsLabel = new FocusableLabel(this.getResString("IDS_DROS_CAT_PRIN_COMPS"));
        this.mNonlinearCanCorrLabel = new FocusableLabel(this.getResString("IDS_DROS_NONLIN_CAN_CAT"));
        this.mAllVarsMultiNominal = new JRadioButton(new ToggleButtonAction(this, "IDS_DROS_ALL_VARS_MULTI_NOMINAL"));
        this.mSomeVarsNotMultiNominal = new JRadioButton(new ToggleButtonAction(this, "IDS_DROS_SOME_VARS_NOT_MUTLI_NOMINAL"));
    }

    private void setDefaults() {
        this.mOneSet.setSelected(true);
        this.mMultipleSets.setSelected(false);
        this.mMultiCorrespondenceAnaLabel.setEnabled(true);
        this.mCatPrincipalCompsLabel.setEnabled(false);
        this.mNonlinearCanCorrLabel.setEnabled(false);
        this.mAllVarsMultiNominal.setSelected(true);
        this.mSomeVarsNotMultiNominal.setSelected(false);
        this.mOneSet.addItemListener(this);
        this.mMultipleSets.addItemListener(this);
        this.mAllVarsMultiNominal.addItemListener(this);
        this.mSomeVarsNotMultiNominal.addItemListener(this);
    }

    private JPanel getOptimalScalingLevelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_DROS_OPT_SCALING_LEVEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mAllVarsMultiNominal, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mSomeVarsNotMultiNominal, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getNumberOfSetsOfVariablesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_DORS_NUMBER_SETS_VARS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mOneSet, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mMultipleSets, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getSelectedAnalysisPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_DORS_SELECTED_ANALYSIS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, insets.left, n2, insets.right);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMultiCorrespondenceAnaLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mCatPrincipalCompsLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mNonlinearCanCorrLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private void updateSelection() {
        if (this.mMultipleSets.isSelected()) {
            this.mMultiCorrespondenceAnaLabel.setEnabled(false);
            this.mCatPrincipalCompsLabel.setEnabled(false);
            this.mNonlinearCanCorrLabel.setEnabled(true);
        } else {
            if (this.mAllVarsMultiNominal.isSelected()) {
                this.mMultiCorrespondenceAnaLabel.setEnabled(true);
                this.mCatPrincipalCompsLabel.setEnabled(false);
            } else {
                this.mMultiCorrespondenceAnaLabel.setEnabled(false);
                this.mCatPrincipalCompsLabel.setEnabled(true);
            }
            this.mNonlinearCanCorrLabel.setEnabled(false);
        }
    }
}

